#include "ab6_invars.h"
#include <string.h>
#include <stdlib.h>
#include <config.h>

/* The way the fortran compiler set the names of module routines. */
#ifdef FC_GCC
#define FC_MOD_NAME(M,A) __ ## M ## __ ## A
#endif
#ifdef FC_G95
#define FC_MOD_NAME(M,A) M ## _MP_ ## A
#endif



#define FC_MOD_CALL(M,A,...) FC_MOD_NAME(M,A)(__VA_ARGS__)

/* Fortran interface. */
void FC_MOD_NAME(ab6_invars, ab6_invars_new_from_file)(int *dt, const char *filename, int *len);
void FC_MOD_NAME(ab6_invars, ab6_invars_new_from_string)(int *dt, const char *string, int *len);
void FC_MOD_NAME(ab6_invars, ab6_invars_free)(int *dt);
void FC_MOD_NAME(ab6_invars, ab6_invars_get_ndtset)(int *dt, int *ndtset, unsigned int *errno);
void FC_MOD_NAME(ab6_invars, ab6_invars_get_integer)(int *dt, int *value, int *att, int *idtset, unsigned int *errno);
void FC_MOD_NAME(ab6_invars, ab6_invars_get_real)(int *dt, double *value, int *att, int *idtset, unsigned int *errno);
void FC_MOD_NAME(ab6_invars, ab6_invars_get_shape)(int *dt, int *dims, int *size, int *att, int *idtset, unsigned int *errno);
void FC_MOD_NAME(ab6_invars, ab6_invars_get_integer_array)(int *dt, int *values, int *size, int *att, int *idtset, unsigned int *errno);
void FC_MOD_NAME(ab6_invars, ab6_invars_get_real_array)(int *dt, double *values, int *size, int *att, int *idtset, unsigned int *errno);

#include "ab6_invars_c.h"

Ab6InvarsTypes ab6_invars_get_type_from_id(Ab6InvarsIds id)
{
  return ((id >= 0 && id < AB6_INVARS_N_IDS)?ab6_invars_types[id]:_OTHER);
}

Ab6Invars* ab6_invars_new_from_file(const char *filename)
{
  int n;
  Ab6Invars *dt, tmpDt;
  
  n = strlen(filename);
  
  FC_MOD_CALL(ab6_invars, ab6_invars_new_from_file, &tmpDt, filename, &n);
  if (tmpDt > 0)
    {
      dt = malloc(sizeof(Ab6Invars));
      *dt = tmpDt;
    }
  else
    dt = (Ab6Invars*)0;
  return dt;
}
Ab6Invars* ab6_invars_new_from_string(const char *string)
{
  int n;
  Ab6Invars *dt, tmpDt;
  
  n = strlen(string);
  
  FC_MOD_CALL(ab6_invars, ab6_invars_new_from_string, &tmpDt, string, &n);
  if (tmpDt > 0)
    {
      dt = malloc(sizeof(Ab6Invars));
      *dt = tmpDt;
    }
  else
    dt = (Ab6Invars*)0;
  return dt;
}

void ab6_invars_free(Ab6Invars *dt)
{
  FC_MOD_CALL(ab6_invars, ab6_invars_free, dt);
  free(dt);
}

Ab6Error ab6_invars_get_ndtset(Ab6Invars *dt, int *ndtset)
{
  Ab6Error errno;

  FC_MOD_CALL(ab6_invars, ab6_invars_get_ndtset, dt, ndtset, &errno);
  return errno;
}

Ab6Error ab6_invars_get_integer(Ab6Invars *dt, Ab6InvarsIds id, int idtset, int *value)
{
  Ab6Error errno;

  if (AB6_INVARS_TYPE(id) != _INT_SCALAR) return AB6_ERROR_INVARS_ATT;
  FC_MOD_CALL(ab6_invars, ab6_invars_get_integer, dt, value, (int*)&id, &idtset, &errno);
  return errno;
}

Ab6Error ab6_invars_get_real(Ab6Invars *dt, Ab6InvarsIds id, int idtset, double *value)
{
  Ab6Error errno;

  if (AB6_INVARS_TYPE(id) != _DOUBLE_SCALAR) return AB6_ERROR_INVARS_ATT;
  FC_MOD_CALL(ab6_invars, ab6_invars_get_real, dt, value, (int*)&id, &idtset, &errno);
  return errno;
}

Ab6Error ab6_invars_get_shape(Ab6Invars *dt, int *n, int dims[7], Ab6InvarsIds id, int idtset)
{
  Ab6Error errno;

  FC_MOD_CALL(ab6_invars, ab6_invars_get_shape, dt, dims, n, (int*)&id, &idtset, &errno);
  return errno;
}

Ab6Error ab6_invars_get_integer_array(Ab6Invars *dt, int *values, size_t n, Ab6InvarsIds id, int idtset)
{
  Ab6Error errno;

  if (AB6_INVARS_TYPE(id) != _INT_ARRAY) return AB6_ERROR_INVARS_ATT;
  FC_MOD_CALL(ab6_invars, ab6_invars_get_integer_array, dt, values, (int*)&n, (int*)&id, &idtset, &errno);
  return errno;
}

Ab6Error ab6_invars_get_real_array(Ab6Invars *dt, double *values, size_t n, Ab6InvarsIds id, int idtset)
{
  Ab6Error errno;

  if (AB6_INVARS_TYPE(id) != _DOUBLE_ARRAY) return AB6_ERROR_INVARS_ATT;
  FC_MOD_CALL(ab6_invars, ab6_invars_get_real_array, dt, values, (int*)&n, (int*)&id, &idtset, &errno);
  return errno;
}
