program toto

  use ab6_invars

  integer :: id, errno

  integer :: natom, ndtset, ixc, idtset, brvltt
  double precision, allocatable :: coord(:)
  integer :: dims(7), ndims
  character(len = 256) :: filename

  call getarg(1, filename)

  call ab6_invars_new_from_file(id, filename, len(filename))

  call ab6_invars_get_ndtset(id, ndtset, errno)
  if (errno /= AB6_NO_ERROR) goto 1000
  write(*,*) ndtset
  do idtset = 1, ndtset, 1
     write(*,*) "Dataset", idtset
     call ab6_invars_get_integer(id, natom, ab6_invars_natom, ndtset, errno)
     if (errno /= AB6_NO_ERROR) goto 1000
     write(*,*) "natom", natom
     call ab6_invars_get_shape(id, dims, ndims, ab6_invars_xred_orig, ndtset, errno)
     if (errno /= AB6_NO_ERROR) goto 1000
     write(*,*) "dims of xred_orig", ndims, " - ", dims(1:ndims)
     allocate(coord(product(dims(1:ndims))))
     call ab6_invars_get_real_array(id, coord, size(coord), ab6_invars_xred_orig, ndtset, errno)
     if (errno /= AB6_NO_ERROR) goto 1000
     write(*,*) "xred_orig", coord
     call ab6_invars_get_real(id, coord(1), ab6_invars_wvl_hgrid, ndtset, errno)
     if (errno /= AB6_NO_ERROR) goto 1000
     write(*,*) "wvl_hgrid", coord(1)
     deallocate(coord)
     call ab6_invars_get_integer(id, ixc, ab6_invars_ixc, ndtset, errno)
     if (errno /= AB6_NO_ERROR) goto 1000
     write(*,*) "ixc", ixc
     call ab6_invars_get_integer(id, brvltt, ab6_invars_brvltt, ndtset, errno)
     if (errno /= AB6_NO_ERROR) goto 1000
     write(*,*) "brvltt", brvltt
  end do

  1000 continue
  call ab6_invars_free(id)
  if (allocated(coord)) deallocate(coord)
  if (errno /= AB6_NO_ERROR) then
     write(0, *) "Error!"
  end if

end program toto
