#
# Makefile for the parser bindings of ABINIT
#

VPATH = $(abinit_srcdir)/bindings/parser

include ../../config.mk

all: libabinis.a ab6_invars.so

INCL_MOD = -I$(abinit_builddir)/src/10_defs -I$(abinit_builddir)/src/50_abitypes_defs

libabinit_tmpdir = tmp-libabinis-objects
libabinis.a: libbindings.a 
	test -e "$(libabinit_tmpdir)" || \
	$(MKDIR_P) $(libabinit_tmpdir)
	cd $(libabinit_tmpdir) && $(AR) x ../../../src/libs/libab6_parser.a
	cd $(libabinit_tmpdir) && $(AR) x ../libbindings.a
	$(AR) $(ARFLAGS) libabinis.a $(libabinit_tmpdir)/*
	rm -rf $(libabinit_tmpdir)

ab6_invars_c.o: ab6_invars_c.c ab6_invars_c.h ab6_invars.h
	$(CC) $(CPPFLAGS) -I. -I$(abinit_builddir) $(CFLAGS) -c $(abinit_srcdir)/bindings/parser/ab6_invars_c.c

ab6_invars_f90.o: ab6_invars_f90.f90 ab6_invars_f90.inc ab6_invars_f90_get.f90
	$(FC) $(CPPFLAGS) -I. $(INCL_MOD) -I$(abinit_builddir)/src/57_iovars $(FCFLAGS) -c $(abinit_srcdir)/bindings/parser/ab6_invars_f90.f90

dtsetinit.o: dtsetinit.F90
	$(FC) $(CPPFLAGS) -I. $(INCL_MOD) $(FCFLAGS) -c $(abinit_srcdir)/bindings/parser/dtsetinit.F90

libbindings.a: ab6_invars_c.o ab6_invars_f90.o dtsetinit.o
	$(AR) $(ARFLAGS) libbindings.a ab6_invars_c.o ab6_invars_f90.o dtsetinit.o
	$(RANLIB) libbindings.a

ab6_invars_py.o: ab6_invars_py.h ab6_invars.h ab6_invars_py.c
	$(CC) $(CPPFLAGS) $(PYTHON_CPPFLAGS) -I. $(CFLAGS) -c $(abinit_srcdir)/bindings/parser/ab6_invars_py.c


ab6_invars.so: ab6_invars_py.o
	$(FC) -shared -o ab6_invars.so ab6_invars_py.o -L. -lbindings -L$(abinit_builddir)/src/libs -lab6_parser



examples: example-c example-f90

example-c: example-c.c fallbacks.o libabinis.a
	$(FC) -o example-c -I. $(abinit_srcdir)/bindings/parser/example-c.c libabinis.a fallbacks.o

example-f90: example-f90.f90 fallbacks.o libabinis.a
	$(FC) -I. -I$(abinit_builddir)/src/defs $(FCFLAGS) -o example-f90 $(abinit_srcdir)/bindings/parser/example-f90.f90 libabinis.a fallbacks.o

fallbacks.o: fallbacks.f90
	$(FC) -I. -I$(abinit_builddir)/src/10_defs $(FCFLAGS) -c $(abinit_srcdir)/bindings/parser/fallbacks.f90

clean:
	rm -f *.o *.mod libbindings.a libabinis.a
	rm -f ab6_invars.so
	rm -f example-c example-f90

