# -*- Autoconf -*-
#
# Copyright (C) 2005-2009 ABINIT Group (Yann Pouillon)
# All rights reserved.
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

# Generated by make-macros-linalg on 2009/06/25 11:28:30 +0000

#
# Auto-detection of optimized linear algebra libraries
#

#
# IMPORTANT NOTE
#
# This file has been automatically generated by the make-macros-linalg
# script. Any change will systematically be overwritten.
#



# _ABI_CHECK_LIB_SGIMATH()
# ------------------------
#
# Looks for the SGIMATH library.
#
AC_DEFUN([_ABI_CHECK_LIB_SGIMATH],
[dnl Set search paths
 abi_check_dirs="/usr/local/lib"
 case "${target_os}" in
  irix*|macosx)
   abi_check_dirs="/sw/lib ${abi_check_dirs}"
   ;;
 esac

 dnl Set library names
 lib_blas="complib.sgimath"
 lib_lapack="complib.sgimath"
 lib_dirs=" ${abi_check_libs}"

 if test "${lib_blas}" != "" -a "${lib_lapack}" != ""; then
  for dir in ${lib_dirs} none; do
   dnl Clear cache values
   unset ac_cv_search_dgemm
   unset ac_cv_search_zggev

   dnl Look for the library routines
   if test "${dir}" = "none"; then
    AC_MSG_NOTICE([looking inside system paths])
    LDFLAGS=""
   else
    AC_MSG_NOTICE([looking inside ${dir}])
    LDFLAGS="-L${dir}"
   fi
   AC_CHECK_LIB([${lib_blas}],[dgemm],[abi_la_blas="sgimath"])
   AC_CHECK_LIB([${lib_lapack}],[zggev],[abi_la_lapack="sgimath"])

   if test "${abi_la_blas}" != "" -a "${abi_la_lapack}" != ""; then
    break
   fi
  done
 fi
]) # _ABI_CHECK_LIB_SGIMATH



# _ABI_CHECK_LIB_MKL()
# --------------------
#
# Looks for the MKL library.
#
AC_DEFUN([_ABI_CHECK_LIB_MKL],
[dnl Set search paths
 abi_check_dirs="/usr/local/lib"
 case "${target_os}" in
  irix*|macosx)
   abi_check_dirs="/sw/lib ${abi_check_dirs}"
   ;;
 esac

 dnl Set library names
 case "${abi_cpu_bits}" in
  32)
   lib_blas="mkl_ia32"
   lib_lapack="mkl_ia32"
   lib_dirs="/opt/intel/mkl/9.0/lib/32 /opt/intel/mkl/8.0/lib/32 /opt/intel/mkl721/lib/32 /opt/intel/mkl72/lib/32 /opt/intel/mkl701/lib/32 /opt/intel/mkl70/lib/32 /opt/intel/mkl/mkl61/lib/32 /opt/intel/mkl/lib/32 ${abi_check_dirs}"
   ;;
  64)
   lib_blas="mkl_ipf"
   lib_lapack="mkl_ipf"
   lib_dirs="/opt/intel/mkl/9.0/lib/64 /opt/intel/mkl/8.0/lib/64 /opt/intel/mkl721/lib/64 /opt/intel/mkl72/lib/64 /opt/intel/mkl701/lib/64 /opt/intel/mkl70/lib/64 /opt/intel/mkl/mkl61/lib/64 /opt/intel/mkl/lib/64 ${abi_check_dirs}"
   ;;
  *)
   lib_blas=""
   lib_lapack=""
   ;;
 esac

 if test "${lib_blas}" != "" -a "${lib_lapack}" != ""; then
  for dir in ${lib_dirs} none; do
   dnl Clear cache values
   unset ac_cv_search_dgemm
   unset ac_cv_search_zggev

   dnl Look for the library routines
   if test "${dir}" = "none"; then
    AC_MSG_NOTICE([looking inside system paths])
    LDFLAGS=""
   else
    AC_MSG_NOTICE([looking inside ${dir}])
    LDFLAGS="-L${dir}"
   fi
   AC_CHECK_LIB([${lib_blas}],[dgemm],[abi_la_blas="mkl"])
   AC_CHECK_LIB([${lib_lapack}],[zggev],[abi_la_lapack="mkl"])

   if test "${abi_la_blas}" != "" -a "${abi_la_lapack}" != ""; then
    break
   fi
  done
 fi
]) # _ABI_CHECK_LIB_MKL



# _ABI_CHECK_LIB_ACML()
# ---------------------
#
# Looks for the ACML library.
#
AC_DEFUN([_ABI_CHECK_LIB_ACML],
[dnl Set search paths
 abi_check_dirs="/usr/local/lib"
 case "${target_os}" in
  irix*|macosx)
   abi_check_dirs="/sw/lib ${abi_check_dirs}"
   ;;
 esac

 dnl Set library names
 lib_blas="acml"
 lib_lapack="acml"
 lib_dirs=" ${abi_check_libs}"

 if test "${lib_blas}" != "" -a "${lib_lapack}" != ""; then
  for dir in ${lib_dirs} none; do
   dnl Clear cache values
   unset ac_cv_search_dgemm
   unset ac_cv_search_zggev

   dnl Look for the library routines
   if test "${dir}" = "none"; then
    AC_MSG_NOTICE([looking inside system paths])
    LDFLAGS=""
   else
    AC_MSG_NOTICE([looking inside ${dir}])
    LDFLAGS="-L${dir}"
   fi
   AC_CHECK_LIB([${lib_blas}],[dgemm],[abi_la_blas="acml"])
   AC_CHECK_LIB([${lib_lapack}],[zggev],[abi_la_lapack="acml"])

   if test "${abi_la_blas}" != "" -a "${abi_la_lapack}" != ""; then
    break
   fi
  done
 fi
]) # _ABI_CHECK_LIB_ACML



# _ABI_CHECK_LIB_CXML()
# ---------------------
#
# Looks for the CXML library.
#
AC_DEFUN([_ABI_CHECK_LIB_CXML],
[dnl Set search paths
 abi_check_dirs="/usr/local/lib"
 case "${target_os}" in
  irix*|macosx)
   abi_check_dirs="/sw/lib ${abi_check_dirs}"
   ;;
 esac

 dnl Set library names
 lib_blas="cxml"
 lib_lapack="cxml"
 lib_dirs=" ${abi_check_libs}"

 if test "${lib_blas}" != "" -a "${lib_lapack}" != ""; then
  for dir in ${lib_dirs} none; do
   dnl Clear cache values
   unset ac_cv_search_dgemm
   unset ac_cv_search_zggev

   dnl Look for the library routines
   if test "${dir}" = "none"; then
    AC_MSG_NOTICE([looking inside system paths])
    LDFLAGS=""
   else
    AC_MSG_NOTICE([looking inside ${dir}])
    LDFLAGS="-L${dir}"
   fi
   AC_CHECK_LIB([${lib_blas}],[dgemm],[abi_la_blas="cxml"])
   AC_CHECK_LIB([${lib_lapack}],[zggev],[abi_la_lapack="cxml"])

   if test "${abi_la_blas}" != "" -a "${abi_la_lapack}" != ""; then
    break
   fi
  done
 fi
]) # _ABI_CHECK_LIB_CXML



# _ABI_CHECK_LIB_ATLAS()
# ----------------------
#
# Looks for the ATLAS library.
#
AC_DEFUN([_ABI_CHECK_LIB_ATLAS],
[dnl Set search paths
 abi_check_dirs="/usr/local/lib"
 case "${target_os}" in
  irix*|macosx)
   abi_check_dirs="/sw/lib ${abi_check_dirs}"
   ;;
 esac

 dnl Set library names
 lib_blas="atlas"
 lib_lapack="atlas"
 lib_dirs="/usr/lib/sse2 /usr/lib/sse /usr/lib/3dnow /usr/lib/atlas /usr/local/lib/sse2 /usr/local/lib/sse /usr/local/lib/3dnow /usr/local/lib/atlas ${abi_check_libs}"

 if test "${lib_blas}" != "" -a "${lib_lapack}" != ""; then
  for dir in ${lib_dirs} none; do
   dnl Clear cache values
   unset ac_cv_search_dgemm
   unset ac_cv_search_zggev

   dnl Look for the library routines
   if test "${dir}" = "none"; then
    AC_MSG_NOTICE([looking inside system paths])
    LDFLAGS=""
   else
    AC_MSG_NOTICE([looking inside ${dir}])
    LDFLAGS="-L${dir}"
   fi
   AC_CHECK_LIB([${lib_blas}],[dgemm],[abi_la_blas="atlas"])
   AC_CHECK_LIB([${lib_lapack}],[zggev],[abi_la_lapack="atlas"])

   if test "${abi_la_blas}" != "" -a "${abi_la_lapack}" != ""; then
    break
   fi
  done
 fi
]) # _ABI_CHECK_LIB_ATLAS



# _ABI_CHECK_LIB_SUNPERF()
# ------------------------
#
# Looks for the SUNPERF library.
#
AC_DEFUN([_ABI_CHECK_LIB_SUNPERF],
[dnl Set search paths
 abi_check_dirs="/usr/local/lib"
 case "${target_os}" in
  irix*|macosx)
   abi_check_dirs="/sw/lib ${abi_check_dirs}"
   ;;
 esac

 dnl Set library names
 lib_blas="sunperf"
 lib_lapack="sunperf"
 lib_dirs=" ${abi_check_libs}"

 if test "${lib_blas}" != "" -a "${lib_lapack}" != ""; then
  for dir in ${lib_dirs} none; do
   dnl Clear cache values
   unset ac_cv_search_dgemm
   unset ac_cv_search_zggev

   dnl Look for the library routines
   if test "${dir}" = "none"; then
    AC_MSG_NOTICE([looking inside system paths])
    LDFLAGS=""
   else
    AC_MSG_NOTICE([looking inside ${dir}])
    LDFLAGS="-L${dir}"
   fi
   AC_CHECK_LIB([${lib_blas}],[dgemm],[abi_la_blas="sunperf"])
   AC_CHECK_LIB([${lib_lapack}],[zggev],[abi_la_lapack="sunperf"])

   if test "${abi_la_blas}" != "" -a "${abi_la_lapack}" != ""; then
    break
   fi
  done
 fi
]) # _ABI_CHECK_LIB_SUNPERF



# _ABI_CHECK_LIB_ESSL()
# ---------------------
#
# Looks for the ESSL library.
#
AC_DEFUN([_ABI_CHECK_LIB_ESSL],
[dnl Set search paths
 abi_check_dirs="/usr/local/lib"
 case "${target_os}" in
  irix*|macosx)
   abi_check_dirs="/sw/lib ${abi_check_dirs}"
   ;;
 esac

 dnl Set library names
 lib_blas="essl"
 lib_lapack="essl"
 lib_dirs=" ${abi_check_libs}"

 if test "${lib_blas}" != "" -a "${lib_lapack}" != ""; then
  for dir in ${lib_dirs} none; do
   dnl Clear cache values
   unset ac_cv_search_dgemm
   unset ac_cv_search_zggev

   dnl Look for the library routines
   if test "${dir}" = "none"; then
    AC_MSG_NOTICE([looking inside system paths])
    LDFLAGS=""
   else
    AC_MSG_NOTICE([looking inside ${dir}])
    LDFLAGS="-L${dir}"
   fi
   AC_CHECK_LIB([${lib_blas}],[dgemm],[abi_la_blas="essl"])
   AC_CHECK_LIB([${lib_lapack}],[zggev],[abi_la_lapack="essl"])

   if test "${abi_la_blas}" != "" -a "${abi_la_lapack}" != ""; then
    break
   fi
  done
 fi
]) # _ABI_CHECK_LIB_ESSL



# _ABI_CHECK_LIB_MLIB()
# ---------------------
#
# Looks for the MLIB library.
#
AC_DEFUN([_ABI_CHECK_LIB_MLIB],
[dnl Set search paths
 abi_check_dirs="/usr/local/lib"
 case "${target_os}" in
  irix*|macosx)
   abi_check_dirs="/sw/lib ${abi_check_dirs}"
   ;;
 esac

 dnl Set library names
 lib_blas="veclib"
 lib_lapack="veclib"
 lib_dirs=" ${abi_check_libs}"

 if test "${lib_blas}" != "" -a "${lib_lapack}" != ""; then
  for dir in ${lib_dirs} none; do
   dnl Clear cache values
   unset ac_cv_search_dgemm
   unset ac_cv_search_zggev

   dnl Look for the library routines
   if test "${dir}" = "none"; then
    AC_MSG_NOTICE([looking inside system paths])
    LDFLAGS=""
   else
    AC_MSG_NOTICE([looking inside ${dir}])
    LDFLAGS="-L${dir}"
   fi
   AC_CHECK_LIB([${lib_blas}],[dgemm],[abi_la_blas="mlib"])
   AC_CHECK_LIB([${lib_lapack}],[zggev],[abi_la_lapack="mlib"])

   if test "${abi_la_blas}" != "" -a "${abi_la_lapack}" != ""; then
    break
   fi
  done
 fi
]) # _ABI_CHECK_LIB_MLIB



# _ABI_CHECK_LIB_ASL()
# --------------------
#
# Looks for the ASL library.
#
AC_DEFUN([_ABI_CHECK_LIB_ASL],
[dnl Set search paths
 abi_check_dirs="/usr/local/lib"
 case "${target_os}" in
  irix*|macosx)
   abi_check_dirs="/sw/lib ${abi_check_dirs}"
   ;;
 esac

 dnl Set library names
 lib_blas="asl"
 lib_lapack="asl"
 lib_dirs=" ${abi_check_libs}"

 if test "${lib_blas}" != "" -a "${lib_lapack}" != ""; then
  for dir in ${lib_dirs} none; do
   dnl Clear cache values
   unset ac_cv_search_dgemm
   unset ac_cv_search_zggev

   dnl Look for the library routines
   if test "${dir}" = "none"; then
    AC_MSG_NOTICE([looking inside system paths])
    LDFLAGS=""
   else
    AC_MSG_NOTICE([looking inside ${dir}])
    LDFLAGS="-L${dir}"
   fi
   AC_CHECK_LIB([${lib_blas}],[dgemm],[abi_la_blas="asl"])
   AC_CHECK_LIB([${lib_lapack}],[zggev],[abi_la_lapack="asl"])

   if test "${abi_la_blas}" != "" -a "${abi_la_lapack}" != ""; then
    break
   fi
  done
 fi
]) # _ABI_CHECK_LIB_ASL



# ABI_CHECK_LIBS_LINALG()
# -----------------------
#
# Looks for optimized versions of the linear algebra libraries.
#
AC_DEFUN([ABI_CHECK_LIBS_LINALG],
[dnl
 dnl Look until one library is found
 dnl

 dnl Look for SGIMATH
 if test "${abi_fc_vendor}" = "mipspro"; then
  if test "${abi_la_blas}" = "" -a "${abi_la_lapack}" = ""; then
   AC_MSG_NOTICE([looking for the SGIMATH library])
   _ABI_CHECK_LIB_SGIMATH
   if test "${abi_la_blas}" = "sgimath" -a "${abi_la_lapack}" = "sgimath"; then
    AC_DEFINE([HAVE_SGI_MATH],1,[Define to 1 if you have the SGIMATH library])
    AC_MSG_NOTICE([found the SGIMATH library])
   fi
  fi
 fi

 dnl Look for MKL
 if test "${abi_fc_vendor}" = "intel"; then
  if test "${abi_la_blas}" = "" -a "${abi_la_lapack}" = ""; then
   AC_MSG_NOTICE([looking for the MKL library])
   _ABI_CHECK_LIB_MKL
   if test "${abi_la_blas}" = "mkl" -a "${abi_la_lapack}" = "mkl"; then
    AC_DEFINE([HAVE_INTEL_MKL],1,[Define to 1 if you have the MKL library])
    AC_MSG_NOTICE([found the MKL library])
   fi
  fi
 fi

 dnl Look for CXML
 if test "${abi_fc_vendor}" = "compaq"; then
  if test "${abi_la_blas}" = "" -a "${abi_la_lapack}" = ""; then
   AC_MSG_NOTICE([looking for the CXML library])
   _ABI_CHECK_LIB_CXML
   if test "${abi_la_blas}" = "cxml" -a "${abi_la_lapack}" = "cxml"; then
    AC_DEFINE([HAVE_COMPAQ_CXML],1,[Define to 1 if you have the CXML library])
    AC_MSG_NOTICE([found the CXML library])
   fi
  fi
 fi

 dnl Look for SUNPERF
 if test "${abi_fc_vendor}" = "sun"; then
  if test "${abi_la_blas}" = "" -a "${abi_la_lapack}" = ""; then
   AC_MSG_NOTICE([looking for the SUNPERF library])
   _ABI_CHECK_LIB_SUNPERF
   if test "${abi_la_blas}" = "sunperf" -a "${abi_la_lapack}" = "sunperf"; then
    AC_DEFINE([HAVE_SUN_PERF],1,[Define to 1 if you have the SUNPERF library])
    AC_MSG_NOTICE([found the SUNPERF library])
   fi
  fi
 fi

 dnl Look for ESSL
 if test "${abi_fc_vendor}" = "ibm"; then
  if test "${abi_la_blas}" = "" -a "${abi_la_lapack}" = ""; then
   AC_MSG_NOTICE([looking for the ESSL library])
   _ABI_CHECK_LIB_ESSL
   if test "${abi_la_blas}" = "essl" -a "${abi_la_lapack}" = "essl"; then
    AC_DEFINE([HAVE_IBM_ESSL],1,[Define to 1 if you have the ESSL library])
    AC_MSG_NOTICE([found the ESSL library])
   fi
  fi
 fi

 dnl Look for MLIB
 if test "${abi_fc_vendor}" = "hp"; then
  if test "${abi_la_blas}" = "" -a "${abi_la_lapack}" = ""; then
   AC_MSG_NOTICE([looking for the MLIB library])
   _ABI_CHECK_LIB_MLIB
   if test "${abi_la_blas}" = "mlib" -a "${abi_la_lapack}" = "mlib"; then
    AC_DEFINE([HAVE_HP_MLIB],1,[Define to 1 if you have the MLIB library])
    AC_MSG_NOTICE([found the MLIB library])
   fi
  fi
 fi

 dnl Look for ASL
 if test "${abi_fc_vendor}" = "nec"; then
  if test "${abi_la_blas}" = "" -a "${abi_la_lapack}" = ""; then
   AC_MSG_NOTICE([looking for the ASL library])
   _ABI_CHECK_LIB_ASL
   if test "${abi_la_blas}" = "asl" -a "${abi_la_lapack}" = "asl"; then
    AC_DEFINE([HAVE_NEC_ASL],1,[Define to 1 if you have the ASL library])
    AC_MSG_NOTICE([found the ASL library])
   fi
  fi
 fi

 dnl Look for ACML
 if test "${abi_la_blas}" = "" -a "${abi_la_lapack}" = ""; then
  AC_MSG_NOTICE([starting search for the ACML library])
  _ABI_CHECK_LIB_ACML
  if test "${abi_la_blas}" = "acml" -a "${abi_la_lapack}" = "acml"; then
   AC_DEFINE([HAVE_AMD_ACML],1,[Define to 1 if you have the ACML library])
   AC_MSG_NOTICE([found the ACML library])
  fi
 fi

 dnl Look for ATLAS
 if test "${abi_la_blas}" = "" -a "${abi_la_lapack}" = ""; then
  AC_MSG_NOTICE([starting search for the ATLAS library])
  _ABI_CHECK_LIB_ATLAS
  if test "${abi_la_blas}" = "atlas" -a "${abi_la_lapack}" = "atlas"; then
   AC_DEFINE([HAVE_ICL_ATLAS],1,[Define to 1 if you have the ATLAS library])
   AC_MSG_NOTICE([found the ATLAS library])
  fi
 fi

]) # ABI_CHECK_LIBS_LINALG
