# -*- Autoconf -*-
#
# Copyright (C) 2005-2009 ABINIT Group (Yann Pouillon)
# All rights reserved.
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

# Generated by make-macros-options on 2009/06/25 11:28:29 +0000

#
# Command-line options for the "configure" script
#

#
# IMPORTANT NOTE
#
# This file has been automatically generated by the make-macros-options
# script. If you try to edit it, your changes will systematically be
# overwritten.
#



# ABI_OPTIONS_DEFINE()
# --------------------
#
# Declares command-line arguments for the "configure" script.
#
AC_DEFUN([ABI_OPTIONS_DEFINE],
[

 dnl
 dnl --enable arguments
 dnl

 AC_ARG_ENABLE(64bit-flags,
  AC_HELP_STRING([--enable-64bit-flags],
   [Use 64-bit flags (see documentation) (default: no)]))
 AC_SUBST(enable_64bit_flags)

 AC_ARG_ENABLE(all-plugins,
  AC_HELP_STRING([--enable-all-plugins],
   [Activate support for all plug-ins (default: )]))
 AC_SUBST(enable_all_plugins)

 AC_ARG_ENABLE(bigdft,
  AC_HELP_STRING([--enable-bigdft],
   [Activate internal support for BigDFT (default: yes)]))
 AC_SUBST(enable_bigdft)

 AC_ARG_ENABLE(bindings,
  AC_HELP_STRING([--enable-bindings],
   [Activate support for bindings (EXPERIMENTAL) (default: no)]))
 AC_SUBST(enable_bindings)

 AC_ARG_ENABLE(cclock,
  AC_HELP_STRING([--enable-cclock],
   [Use C clock for timings (default: no)]))
 AC_SUBST(enable_cclock)

 AC_ARG_ENABLE(config-file,
  AC_HELP_STRING([--enable-config-file],
   [Read options from config file (default: yes)]))
 AC_SUBST(enable_config_file)

 AC_ARG_ENABLE(debug,
  AC_HELP_STRING([--enable-debug],
   [Turn-on debug mode (default: symbols)]))
 AC_SUBST(enable_debug)

 AC_ARG_ENABLE(env-file,
  AC_HELP_STRING([--enable-env-file],
   [Read environment from file (EXPERIMENTAL) (default: no)]))
 AC_SUBST(enable_env_file)

 AC_ARG_ENABLE(error-handlers,
  AC_HELP_STRING([--enable-error-handlers],
   [Activate error handlers (default: no)]))
 AC_SUBST(enable_error_handlers)

 AC_ARG_ENABLE(etsf-io,
  AC_HELP_STRING([--enable-etsf-io],
   [Activate support for ETSF I/O (default: yes)]))
 AC_SUBST(enable_etsf_io)

 AC_ARG_ENABLE(exports,
  AC_HELP_STRING([--enable-exports],
   [Activate build of exported libraries (EXPERIMENTAL) (default: no)]))
 AC_SUBST(enable_exports)

 AC_ARG_ENABLE(fc-wrapper,
  AC_HELP_STRING([--enable-fc-wrapper],
   [Wrap Fortran compiler calls (default: no)]))
 AC_SUBST(enable_fc_wrapper)

 AC_ARG_ENABLE(fftw,
  AC_HELP_STRING([--enable-fftw],
   [Enable use of the FFTW library (EXPERIMENTAL) (default: no)]))
 AC_SUBST(enable_fftw)

 AC_ARG_ENABLE(fftw-threads,
  AC_HELP_STRING([--enable-fftw-threads],
   [Enable use of the threaded FFTW library (EXPERIMENTAL) (default: no)]))
 AC_SUBST(enable_fftw_threads)

 AC_ARG_ENABLE(fox,
  AC_HELP_STRING([--enable-fox],
   [Activate support for FoX (under development) (default: no)]))
 AC_SUBST(enable_fox)

 AC_ARG_ENABLE(gsl,
  AC_HELP_STRING([--enable-gsl],
   [Enable use of the GNU Scientific Library (EXPERIMENTAL) (default: no)]))
 AC_SUBST(enable_gsl)

 AC_ARG_ENABLE(gw-dpc,
  AC_HELP_STRING([--enable-gw-dpc],
   [Enable double-precision GW calculations (EXPERIMENTAL) (default: no)]))
 AC_SUBST(enable_gw_dpc)

 AC_ARG_ENABLE(libxc,
  AC_HELP_STRING([--enable-libxc],
   [Activate support for LibXC (default: yes)]))
 AC_SUBST(enable_libxc)

 AC_ARG_ENABLE(macroave,
  AC_HELP_STRING([--enable-macroave],
   [Enable build of macroave (EXPERIMENTAL) (default: yes)]))
 AC_SUBST(enable_macroave)

 AC_ARG_ENABLE(mpi,
  AC_HELP_STRING([--enable-mpi],
   [Enable MPI support (default: None)]))
 AC_SUBST(enable_mpi)

 AC_ARG_ENABLE(mpi-io,
  AC_HELP_STRING([--enable-mpi-io],
   [Enable MPI I/O (EXPERIMENTAL) (default: no)]))
 AC_SUBST(enable_mpi_io)

 AC_ARG_ENABLE(mpi-io-buggy,
  AC_HELP_STRING([--enable-mpi-io-buggy],
   [Workaround buggy MPI I/O (EXPERIMENTAL) (default: no)]))
 AC_SUBST(enable_mpi_io_buggy)

 AC_ARG_ENABLE(mpi-trace,
  AC_HELP_STRING([--enable-mpi-trace],
   [Enable MPI time tracing (EXPERIMENTAL) (default: no)]))
 AC_SUBST(enable_mpi_trace)

 AC_ARG_ENABLE(netcdf,
  AC_HELP_STRING([--enable-netcdf],
   [Activate support for NetCDF (default: yes)]))
 AC_SUBST(enable_netcdf)

 AC_ARG_ENABLE(nightly,
  AC_HELP_STRING([--enable-nightly],
   [Activate nightly build support (default: no)]))
 AC_SUBST(enable_nightly)

 AC_ARG_ENABLE(optlevel,
  AC_HELP_STRING([--enable-optlevel],
   [Set optimization level (default: standard)]))
 AC_SUBST(enable_optlevel)

 AC_ARG_ENABLE(papi,
  AC_HELP_STRING([--enable-papi],
   [Use the PAPI library for timings (default: no)]))
 AC_SUBST(enable_papi)

 AC_ARG_ENABLE(scalapack,
  AC_HELP_STRING([--enable-scalapack],
   [Use ScaLAPACK for parallel linear algebra operations (default: no)]))
 AC_SUBST(enable_scalapack)

 AC_ARG_ENABLE(stdin,
  AC_HELP_STRING([--enable-stdin],
   [Tell ABINIT to read file lists from standard input (default: yes)]))
 AC_SUBST(enable_stdin)

 AC_ARG_ENABLE(tricks,
  AC_HELP_STRING([--enable-tricks],
   [See ~abinit/doc/config/build-config.ac for information (default: yes)]))
 AC_SUBST(enable_tricks)

 AC_ARG_ENABLE(wannier90,
  AC_HELP_STRING([--enable-wannier90],
   [Activate support for Wannier90 (default: yes)]))
 AC_SUBST(enable_wannier90)

 AC_ARG_ENABLE(xmlf90,
  AC_HELP_STRING([--enable-xmlf90],
   [Activate support for XMLF90 (OBSOLETE) (default: no)]))
 AC_SUBST(enable_xmlf90)

 dnl
 dnl --with arguments
 dnl

 AC_ARG_WITH(64bit-flags,
  AC_HELP_STRING([--with-64bit-flags],
   [Specify 64-bit flags (see documentation) (default: None)]))
 AC_SUBST(with_64bit_flags)

 AC_ARG_WITH(ar-dbgflags,
  AC_HELP_STRING([--with-ar-dbgflags],
   [Set debug flags for archives (default: None)]))
 AC_SUBST(with_ar_dbgflags)

 AC_ARG_WITH(ar-optflags,
  AC_HELP_STRING([--with-ar-optflags],
   [Set optimization of archives (default: None)]))
 AC_SUBST(with_ar_optflags)

 AC_ARG_WITH(bigdft-includes,
  AC_HELP_STRING([--with-bigdft-includes],
   [Include parameters for BigDFT support (default: None)]))
 AC_SUBST(with_bigdft_includes)

 AC_ARG_WITH(bigdft-libs,
  AC_HELP_STRING([--with-bigdft-libs],
   [BigDFT libraries to link ABINIT binaries with (default: None)]))
 AC_SUBST(with_bigdft_libs)

 AC_ARG_WITH(config-file,
  AC_HELP_STRING([--with-config-file],
   [Specify config file to read options from (default: None)]))
 AC_SUBST(with_config_file)

 AC_ARG_WITH(cc-dbgflags,
  AC_HELP_STRING([--with-cc-dbgflags],
   [Set debug flags for C routines (default: None)]))
 AC_SUBST(with_cc_dbgflags)

 AC_ARG_WITH(cc-ld-dbgflags,
  AC_HELP_STRING([--with-cc-ld-dbgflags],
   [Prepend debug flags when calling the C linker (default: None)]))
 AC_SUBST(with_cc_ld_dbgflags)

 AC_ARG_WITH(cc-ld-dbglibs,
  AC_HELP_STRING([--with-cc-ld-dbglibs],
   [Append debug libraries when calling the C linker (default: None)]))
 AC_SUBST(with_cc_ld_dbglibs)

 AC_ARG_WITH(cc-ld-optflags,
  AC_HELP_STRING([--with-cc-ld-optflags],
   [Prepend optflags when calling the C linker (default: None)]))
 AC_SUBST(with_cc_ld_optflags)

 AC_ARG_WITH(cc-ld-optlibs,
  AC_HELP_STRING([--with-cc-ld-optlibs],
   [Append optimization libraries when calling the C linker (default: None)]))
 AC_SUBST(with_cc_ld_optlibs)

 AC_ARG_WITH(cc-optflags,
  AC_HELP_STRING([--with-cc-optflags],
   [Set optimization of C routines (default: None)]))
 AC_SUBST(with_cc_optflags)

 AC_ARG_WITH(cpp-dbgflags,
  AC_HELP_STRING([--with-cpp-dbgflags],
   [Set preprocessing options for debugging (default: None)]))
 AC_SUBST(with_cpp_dbgflags)

 AC_ARG_WITH(cpp-optflags,
  AC_HELP_STRING([--with-cpp-optflags],
   [Set preprocessing options for optimization (default: None)]))
 AC_SUBST(with_cpp_optflags)

 AC_ARG_WITH(cxx-dbgflags,
  AC_HELP_STRING([--with-cxx-dbgflags],
   [Set debug flags for C++ routines (default: None)]))
 AC_SUBST(with_cxx_dbgflags)

 AC_ARG_WITH(cxx-ld-dbgflags,
  AC_HELP_STRING([--with-cxx-ld-dbgflags],
   [Prepend debug flags when calling the C++ linker (default: None)]))
 AC_SUBST(with_cxx_ld_dbgflags)

 AC_ARG_WITH(cxx-ld-dbglibs,
  AC_HELP_STRING([--with-cxx-ld-dbglibs],
   [Append debug libraries when calling the C++ linker (default: None)]))
 AC_SUBST(with_cxx_ld_dbglibs)

 AC_ARG_WITH(cxx-ld-optflags,
  AC_HELP_STRING([--with-cxx-ld-optflags],
   [Prepend optflags when calling the C++ linker (default: None)]))
 AC_SUBST(with_cxx_ld_optflags)

 AC_ARG_WITH(cxx-ld-optlibs,
  AC_HELP_STRING([--with-cxx-ld-optlibs],
   [Append optimization libraries when calling the C++ linker (default: None)]))
 AC_SUBST(with_cxx_ld_optlibs)

 AC_ARG_WITH(cxx-optflags,
  AC_HELP_STRING([--with-cxx-optflags],
   [Set optimization of C++ routines (default: None)]))
 AC_SUBST(with_cxx_optflags)

 AC_ARG_WITH(etsf-io-includes,
  AC_HELP_STRING([--with-etsf-io-includes],
   [Include parameters for ETSF I/O support (default: None)]))
 AC_SUBST(with_etsf_io_includes)

 AC_ARG_WITH(etsf-io-libs,
  AC_HELP_STRING([--with-etsf-io-libs],
   [ETSF I/O libraries to link ABINIT binaries with (default: None)]))
 AC_SUBST(with_etsf_io_libs)

 AC_ARG_WITH(fc-dbgflags,
  AC_HELP_STRING([--with-fc-dbgflags],
   [Set debug flags for Fortran routines (default: None)]))
 AC_SUBST(with_fc_dbgflags)

 AC_ARG_WITH(fc-ld-dbgflags,
  AC_HELP_STRING([--with-fc-ld-dbgflags],
   [Prepend debug flags when calling the Fortran linker (default: None)]))
 AC_SUBST(with_fc_ld_dbgflags)

 AC_ARG_WITH(fc-ld-dbglibs,
  AC_HELP_STRING([--with-fc-ld-dbglibs],
   [Append debug libraries when calling the Fortran linker (default: None)]))
 AC_SUBST(with_fc_ld_dbglibs)

 AC_ARG_WITH(fc-ld-optflags,
  AC_HELP_STRING([--with-fc-ld-optflags],
   [Prepend optflags when calling the Fortran linker (default: None)]))
 AC_SUBST(with_fc_ld_optflags)

 AC_ARG_WITH(fc-ld-optlibs,
  AC_HELP_STRING([--with-fc-ld-optlibs],
   [Append optimization libraries when calling the Fortran linker (default: None)]))
 AC_SUBST(with_fc_ld_optlibs)

 AC_ARG_WITH(fc-optflags,
  AC_HELP_STRING([--with-fc-optflags],
   [Set optimization of Fortran routines (default: None)]))
 AC_SUBST(with_fc_optflags)

 AC_ARG_WITH(fc-vendor,
  AC_HELP_STRING([--with-fc-vendor],
   [Fortran compiler vendor to be used by the build system (default: None)]))
 AC_SUBST(with_fc_vendor)

 AC_ARG_WITH(fc-version,
  AC_HELP_STRING([--with-fc-version],
   [Fortran compiler version to be used by the build system (default: None)]))
 AC_SUBST(with_fc_version)

 AC_ARG_WITH(fftw-includes,
  AC_HELP_STRING([--with-fftw-includes],
   [Include parameters for the FFTW libraries (default: None)]))
 AC_SUBST(with_fftw_includes)

 AC_ARG_WITH(fftw-libs,
  AC_HELP_STRING([--with-fftw-libs],
   [FFTW libraries to link ABINIT binaries with (default: None)]))
 AC_SUBST(with_fftw_libs)

 AC_ARG_WITH(fox-includes,
  AC_HELP_STRING([--with-fox-includes],
   [Include parameters for FoX support (default: None)]))
 AC_SUBST(with_fox_includes)

 AC_ARG_WITH(fox-libs,
  AC_HELP_STRING([--with-fox-libs],
   [FoX libraries to link ABINIT binaries with (default: None)]))
 AC_SUBST(with_fox_libs)

 AC_ARG_WITH(gsl-includes,
  AC_HELP_STRING([--with-gsl-includes],
   [Include parameters for the GNU Scientific Library (default: None)]))
 AC_SUBST(with_gsl_includes)

 AC_ARG_WITH(gsl-libs,
  AC_HELP_STRING([--with-gsl-libs],
   [GSL libraries to link ABINIT binaries with (default: None)]))
 AC_SUBST(with_gsl_libs)

 AC_ARG_WITH(libxc-includes,
  AC_HELP_STRING([--with-libxc-includes],
   [Include parameters for ETSF XC support (default: None)]))
 AC_SUBST(with_libxc_includes)

 AC_ARG_WITH(libxc-libs,
  AC_HELP_STRING([--with-libxc-libs],
   [ETSF XC libraries to link ABINIT binaries with (default: None)]))
 AC_SUBST(with_libxc_libs)

 AC_ARG_WITH(linalg-includes,
  AC_HELP_STRING([--with-linalg-includes],
   [Include parameters for the linear algebra libraries (BLAS+LAPACK) (default: None)]))
 AC_SUBST(with_linalg_includes)

 AC_ARG_WITH(linalg-libs,
  AC_HELP_STRING([--with-linalg-libs],
   [Linear algebra libraries (BLAS+LAPACK) to link with (default: None)]))
 AC_SUBST(with_linalg_libs)

 AC_ARG_WITH(linalg-type,
  AC_HELP_STRING([--with-linalg-type],
   [See ~abinit/doc/config/build-config.ac for information (default: None)]))
 AC_SUBST(with_linalg_type)

 AC_ARG_WITH(mpi-cppflags,
  AC_HELP_STRING([--with-mpi-cppflags],
   [MPI preprocessing options for parallel code (default: None)]))
 AC_SUBST(with_mpi_cppflags)

 AC_ARG_WITH(mpi-cflags,
  AC_HELP_STRING([--with-mpi-cflags],
   [MPI compile options for C parallel code (default: None)]))
 AC_SUBST(with_mpi_cflags)

 AC_ARG_WITH(mpi-cc-ldflags,
  AC_HELP_STRING([--with-mpi-cc-ldflags],
   [MPI link options for C parallel code (default: None)]))
 AC_SUBST(with_mpi_cc_ldflags)

 AC_ARG_WITH(mpi-cc-libs,
  AC_HELP_STRING([--with-mpi-cc-libs],
   [MPI libraries required to link C parallel code (default: None)]))
 AC_SUBST(with_mpi_cc_libs)

 AC_ARG_WITH(mpi-cxxflags,
  AC_HELP_STRING([--with-mpi-cxxflags],
   [MPI compile options for C++ parallel code (default: None)]))
 AC_SUBST(with_mpi_cxxflags)

 AC_ARG_WITH(mpi-cxx-ldflags,
  AC_HELP_STRING([--with-mpi-cxx-ldflags],
   [MPI link options for C++ parallel code (default: None)]))
 AC_SUBST(with_mpi_cxx_ldflags)

 AC_ARG_WITH(mpi-cxx-libs,
  AC_HELP_STRING([--with-mpi-cxx-libs],
   [MPI libraries required to link C++ parallel code (default: None)]))
 AC_SUBST(with_mpi_cxx_libs)

 AC_ARG_WITH(mpi-fcflags,
  AC_HELP_STRING([--with-mpi-fcflags],
   [MPI compile options for Fortran parallel code (default: None)]))
 AC_SUBST(with_mpi_fcflags)

 AC_ARG_WITH(mpi-fc-ldflags,
  AC_HELP_STRING([--with-mpi-fc-ldflags],
   [MPI link options for Fortran parallel code (default: None)]))
 AC_SUBST(with_mpi_fc_ldflags)

 AC_ARG_WITH(mpi-fc-libs,
  AC_HELP_STRING([--with-mpi-fc-libs],
   [MPI libraries required to link Fortran parallel code (default: None)]))
 AC_SUBST(with_mpi_fc_libs)

 AC_ARG_WITH(mpi-level,
  AC_HELP_STRING([--with-mpi-level],
   [MPI standard level to use (1 or 2) (default: None)]))
 AC_SUBST(with_mpi_level)

 AC_ARG_WITH(mpi-prefix,
  AC_HELP_STRING([--with-mpi-prefix],
   [Prefix for the MPI installation (default: None)]))
 AC_SUBST(with_mpi_prefix)

 AC_ARG_WITH(mpi-runner,
  AC_HELP_STRING([--with-mpi-runner],
   [Full path to the MPI runner program (default: None)]))
 AC_SUBST(with_mpi_runner)

 AC_ARG_WITH(netcdf-includes,
  AC_HELP_STRING([--with-netcdf-includes],
   [Include parameters for NetCDF support (default: None)]))
 AC_SUBST(with_netcdf_includes)

 AC_ARG_WITH(netcdf-libs,
  AC_HELP_STRING([--with-netcdf-libs],
   [NetCDF libraries to link ABINIT binaries with (default: None)]))
 AC_SUBST(with_netcdf_libs)

 AC_ARG_WITH(papi-includes,
  AC_HELP_STRING([--with-papi-includes],
   [Include parameters for the PAPI library (default: None)]))
 AC_SUBST(with_papi_includes)

 AC_ARG_WITH(papi-libs,
  AC_HELP_STRING([--with-papi-libs],
   [PAPI libraries to link ABINIT binaries with (default: None)]))
 AC_SUBST(with_papi_libs)

 AC_ARG_WITH(plugins-prefix,
  AC_HELP_STRING([--with-plugins-prefix],
   [Prefix for already installed plug-ins (default: None)]))
 AC_SUBST(with_plugins_prefix)

 AC_ARG_WITH(plugins-tardir,
  AC_HELP_STRING([--with-plugins-tardir],
   [Full path for the tarballs of plug-ins (default: None)]))
 AC_SUBST(with_plugins_tardir)

 AC_ARG_WITH(scalapack-includes,
  AC_HELP_STRING([--with-scalapack-includes],
   [Include parameters for ScaLAPACK support (default: None)]))
 AC_SUBST(with_scalapack_includes)

 AC_ARG_WITH(scalapack-libs,
  AC_HELP_STRING([--with-scalapack-libs],
   [ScaLAPACK libraries to link ABINIT binaries with (default: None)]))
 AC_SUBST(with_scalapack_libs)

 AC_ARG_WITH(timeout,
  AC_HELP_STRING([--with-timeout],
   [Automatic test timeout (Nightly feature) (default: 1200)]))
 AC_SUBST(with_timeout)

 AC_ARG_WITH(wannier90,
  AC_HELP_STRING([--with-wannier90],
   [Full path to the Wannier90 executable (default: None)]))
 AC_SUBST(with_wannier90)

 AC_ARG_WITH(wannier90-includes,
  AC_HELP_STRING([--with-wannier90-includes],
   [Include parameters for Wannier90 support (default: None)]))
 AC_SUBST(with_wannier90_includes)

 AC_ARG_WITH(wannier90-libs,
  AC_HELP_STRING([--with-wannier90-libs],
   [Wannier90 libraries to link ABINIT binaries with (default: None)]))
 AC_SUBST(with_wannier90_libs)

 AC_ARG_WITH(xmlf90-includes,
  AC_HELP_STRING([--with-xmlf90-includes],
   [Include parameters for XML Fortran 90 support (default: None)]))
 AC_SUBST(with_xmlf90_includes)

 AC_ARG_WITH(xmlf90-libs,
  AC_HELP_STRING([--with-xmlf90-libs],
   [XML Fortran 90 libraries to link ABINIT binaries with (default: None)]))
 AC_SUBST(with_xmlf90_libs)
]) # ABI_OPTIONS_DEFINE



# ABI_OPTIONS_SETUP()
# -------------------
#
# Sets the default values of command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_SETUP],
[

 dnl
 dnl --enable arguments
 dnl

 if test "${enable_64bit_flags}" = ""; then
  enable_64bit_flags="no"
 fi
 if test "${enable_all_plugins}" = ""; then
  enable_all_plugins=""
 fi
 if test "${enable_bigdft}" = ""; then
  enable_bigdft="yes"
 fi
 if test "${enable_bindings}" = ""; then
  enable_bindings="no"
 fi
 if test "${enable_cclock}" = ""; then
  enable_cclock="no"
 fi
 if test "${enable_config_file}" = ""; then
  enable_config_file="yes"
 fi
 if test "${enable_debug}" = ""; then
  enable_debug="symbols"
 fi
 if test "${enable_env_file}" = ""; then
  enable_env_file="no"
 fi
 if test "${enable_error_handlers}" = ""; then
  enable_error_handlers="no"
 fi
 if test "${enable_etsf_io}" = ""; then
  enable_etsf_io="yes"
 fi
 if test "${enable_exports}" = ""; then
  enable_exports="no"
 fi
 if test "${enable_fc_wrapper}" = ""; then
  enable_fc_wrapper="no"
 fi
 if test "${enable_fftw}" = ""; then
  enable_fftw="no"
 fi
 if test "${enable_fftw_threads}" = ""; then
  enable_fftw_threads="no"
 fi
 if test "${enable_fox}" = ""; then
  enable_fox="no"
 fi
 if test "${enable_gsl}" = ""; then
  enable_gsl="no"
 fi
 if test "${enable_gw_dpc}" = ""; then
  enable_gw_dpc="no"
 fi
 if test "${enable_libxc}" = ""; then
  enable_libxc="yes"
 fi
 if test "${enable_macroave}" = ""; then
  enable_macroave="yes"
 fi
 if test "${enable_mpi_io}" = ""; then
  enable_mpi_io="no"
 fi
 if test "${enable_mpi_io_buggy}" = ""; then
  enable_mpi_io_buggy="no"
 fi
 if test "${enable_mpi_trace}" = ""; then
  enable_mpi_trace="no"
 fi
 if test "${enable_netcdf}" = ""; then
  enable_netcdf="yes"
 fi
 if test "${enable_nightly}" = ""; then
  enable_nightly="no"
 fi
 if test "${enable_optlevel}" = ""; then
  enable_optlevel="standard"
 fi
 if test "${enable_papi}" = ""; then
  enable_papi="no"
 fi
 if test "${enable_scalapack}" = ""; then
  enable_scalapack="no"
 fi
 if test "${enable_stdin}" = ""; then
  enable_stdin="yes"
 fi
 if test "${enable_tricks}" = ""; then
  enable_tricks="yes"
 fi
 if test "${enable_wannier90}" = ""; then
  enable_wannier90="yes"
 fi
 if test "${enable_xmlf90}" = ""; then
  enable_xmlf90="no"
 fi

 dnl
 dnl --with arguments
 dnl

 if test "${with_timeout}" = ""; then
  with_timeout="1200"
 fi
]) # ABI_OPTIONS_SETUP



# ABI_OPTIONS_BACKUP()
# --------------------
#
# Saves all command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_BACKUP],
[

 dnl
 dnl --enable arguments
 dnl
 cmd_enable_64bit_flags="${enable_64bit_flags}"
 cmd_enable_all_plugins="${enable_all_plugins}"
 cmd_enable_bigdft="${enable_bigdft}"
 cmd_enable_bindings="${enable_bindings}"
 cmd_enable_cclock="${enable_cclock}"
 cmd_enable_config_file="${enable_config_file}"
 cmd_enable_debug="${enable_debug}"
 cmd_enable_env_file="${enable_env_file}"
 cmd_enable_error_handlers="${enable_error_handlers}"
 cmd_enable_etsf_io="${enable_etsf_io}"
 cmd_enable_exports="${enable_exports}"
 cmd_enable_fc_wrapper="${enable_fc_wrapper}"
 cmd_enable_fftw="${enable_fftw}"
 cmd_enable_fftw_threads="${enable_fftw_threads}"
 cmd_enable_fox="${enable_fox}"
 cmd_enable_gsl="${enable_gsl}"
 cmd_enable_gw_dpc="${enable_gw_dpc}"
 cmd_enable_libxc="${enable_libxc}"
 cmd_enable_macroave="${enable_macroave}"
 cmd_enable_mpi="${enable_mpi}"
 cmd_enable_mpi_io="${enable_mpi_io}"
 cmd_enable_mpi_io_buggy="${enable_mpi_io_buggy}"
 cmd_enable_mpi_trace="${enable_mpi_trace}"
 cmd_enable_netcdf="${enable_netcdf}"
 cmd_enable_nightly="${enable_nightly}"
 cmd_enable_optlevel="${enable_optlevel}"
 cmd_enable_papi="${enable_papi}"
 cmd_enable_scalapack="${enable_scalapack}"
 cmd_enable_stdin="${enable_stdin}"
 cmd_enable_tricks="${enable_tricks}"
 cmd_enable_wannier90="${enable_wannier90}"
 cmd_enable_xmlf90="${enable_xmlf90}"

 dnl
 dnl --with arguments
 dnl
 cmd_with_64bit_flags="${with_64bit_flags}"
 cmd_with_ar_dbgflags="${with_ar_dbgflags}"
 cmd_with_ar_optflags="${with_ar_optflags}"
 cmd_with_bigdft_includes="${with_bigdft_includes}"
 cmd_with_bigdft_libs="${with_bigdft_libs}"
 cmd_with_config_file="${with_config_file}"
 cmd_with_cc_dbgflags="${with_cc_dbgflags}"
 cmd_with_cc_ld_dbgflags="${with_cc_ld_dbgflags}"
 cmd_with_cc_ld_dbglibs="${with_cc_ld_dbglibs}"
 cmd_with_cc_ld_optflags="${with_cc_ld_optflags}"
 cmd_with_cc_ld_optlibs="${with_cc_ld_optlibs}"
 cmd_with_cc_optflags="${with_cc_optflags}"
 cmd_with_cpp_dbgflags="${with_cpp_dbgflags}"
 cmd_with_cpp_optflags="${with_cpp_optflags}"
 cmd_with_cxx_dbgflags="${with_cxx_dbgflags}"
 cmd_with_cxx_ld_dbgflags="${with_cxx_ld_dbgflags}"
 cmd_with_cxx_ld_dbglibs="${with_cxx_ld_dbglibs}"
 cmd_with_cxx_ld_optflags="${with_cxx_ld_optflags}"
 cmd_with_cxx_ld_optlibs="${with_cxx_ld_optlibs}"
 cmd_with_cxx_optflags="${with_cxx_optflags}"
 cmd_with_etsf_io_includes="${with_etsf_io_includes}"
 cmd_with_etsf_io_libs="${with_etsf_io_libs}"
 cmd_with_fc_dbgflags="${with_fc_dbgflags}"
 cmd_with_fc_ld_dbgflags="${with_fc_ld_dbgflags}"
 cmd_with_fc_ld_dbglibs="${with_fc_ld_dbglibs}"
 cmd_with_fc_ld_optflags="${with_fc_ld_optflags}"
 cmd_with_fc_ld_optlibs="${with_fc_ld_optlibs}"
 cmd_with_fc_optflags="${with_fc_optflags}"
 cmd_with_fc_vendor="${with_fc_vendor}"
 cmd_with_fc_version="${with_fc_version}"
 cmd_with_fftw_includes="${with_fftw_includes}"
 cmd_with_fftw_libs="${with_fftw_libs}"
 cmd_with_fox_includes="${with_fox_includes}"
 cmd_with_fox_libs="${with_fox_libs}"
 cmd_with_gsl_includes="${with_gsl_includes}"
 cmd_with_gsl_libs="${with_gsl_libs}"
 cmd_with_libxc_includes="${with_libxc_includes}"
 cmd_with_libxc_libs="${with_libxc_libs}"
 cmd_with_linalg_includes="${with_linalg_includes}"
 cmd_with_linalg_libs="${with_linalg_libs}"
 cmd_with_linalg_type="${with_linalg_type}"
 cmd_with_mpi_cppflags="${with_mpi_cppflags}"
 cmd_with_mpi_cflags="${with_mpi_cflags}"
 cmd_with_mpi_cc_ldflags="${with_mpi_cc_ldflags}"
 cmd_with_mpi_cc_libs="${with_mpi_cc_libs}"
 cmd_with_mpi_cxxflags="${with_mpi_cxxflags}"
 cmd_with_mpi_cxx_ldflags="${with_mpi_cxx_ldflags}"
 cmd_with_mpi_cxx_libs="${with_mpi_cxx_libs}"
 cmd_with_mpi_fcflags="${with_mpi_fcflags}"
 cmd_with_mpi_fc_ldflags="${with_mpi_fc_ldflags}"
 cmd_with_mpi_fc_libs="${with_mpi_fc_libs}"
 cmd_with_mpi_level="${with_mpi_level}"
 cmd_with_mpi_prefix="${with_mpi_prefix}"
 cmd_with_mpi_runner="${with_mpi_runner}"
 cmd_with_netcdf_includes="${with_netcdf_includes}"
 cmd_with_netcdf_libs="${with_netcdf_libs}"
 cmd_with_papi_includes="${with_papi_includes}"
 cmd_with_papi_libs="${with_papi_libs}"
 cmd_with_plugins_prefix="${with_plugins_prefix}"
 cmd_with_plugins_tardir="${with_plugins_tardir}"
 cmd_with_scalapack_includes="${with_scalapack_includes}"
 cmd_with_scalapack_libs="${with_scalapack_libs}"
 cmd_with_timeout="${with_timeout}"
 cmd_with_wannier90="${with_wannier90}"
 cmd_with_wannier90_includes="${with_wannier90_includes}"
 cmd_with_wannier90_libs="${with_wannier90_libs}"
 cmd_with_xmlf90_includes="${with_xmlf90_includes}"
 cmd_with_xmlf90_libs="${with_xmlf90_libs}"

 dnl
 dnl Prefix
 dnl
 if test "${prefix}" != "NONE"; then
  cmd_prefix="${prefix}"
 fi
]) # ABI_OPTIONS_BACKUP



# ABI_OPTIONS_RECALL()
# --------------------
#
# Restores all previously-saved command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_RECALL],
[

 dnl
 dnl --enable arguments
 dnl

 if test "${cmd_enable_64bit_flags}" != ""; then
  enable_64bit_flags="${cmd_enable_64bit_flags}"
 fi

 if test "${cmd_enable_all_plugins}" != ""; then
  enable_all_plugins="${cmd_enable_all_plugins}"
 fi

 if test "${cmd_enable_bigdft}" != ""; then
  enable_bigdft="${cmd_enable_bigdft}"
 fi

 if test "${cmd_enable_bindings}" != ""; then
  enable_bindings="${cmd_enable_bindings}"
 fi

 if test "${cmd_enable_cclock}" != ""; then
  enable_cclock="${cmd_enable_cclock}"
 fi

 if test "${cmd_enable_config_file}" != ""; then
  enable_config_file="${cmd_enable_config_file}"
 fi

 if test "${cmd_enable_debug}" != ""; then
  enable_debug="${cmd_enable_debug}"
 fi

 if test "${cmd_enable_env_file}" != ""; then
  enable_env_file="${cmd_enable_env_file}"
 fi

 if test "${cmd_enable_error_handlers}" != ""; then
  enable_error_handlers="${cmd_enable_error_handlers}"
 fi

 if test "${cmd_enable_etsf_io}" != ""; then
  enable_etsf_io="${cmd_enable_etsf_io}"
 fi

 if test "${cmd_enable_exports}" != ""; then
  enable_exports="${cmd_enable_exports}"
 fi

 if test "${cmd_enable_fc_wrapper}" != ""; then
  enable_fc_wrapper="${cmd_enable_fc_wrapper}"
 fi

 if test "${cmd_enable_fftw}" != ""; then
  enable_fftw="${cmd_enable_fftw}"
 fi

 if test "${cmd_enable_fftw_threads}" != ""; then
  enable_fftw_threads="${cmd_enable_fftw_threads}"
 fi

 if test "${cmd_enable_fox}" != ""; then
  enable_fox="${cmd_enable_fox}"
 fi

 if test "${cmd_enable_gsl}" != ""; then
  enable_gsl="${cmd_enable_gsl}"
 fi

 if test "${cmd_enable_gw_dpc}" != ""; then
  enable_gw_dpc="${cmd_enable_gw_dpc}"
 fi

 if test "${cmd_enable_libxc}" != ""; then
  enable_libxc="${cmd_enable_libxc}"
 fi

 if test "${cmd_enable_macroave}" != ""; then
  enable_macroave="${cmd_enable_macroave}"
 fi

 if test "${cmd_enable_mpi}" != ""; then
  enable_mpi="${cmd_enable_mpi}"
 fi

 if test "${cmd_enable_mpi_io}" != ""; then
  enable_mpi_io="${cmd_enable_mpi_io}"
 fi

 if test "${cmd_enable_mpi_io_buggy}" != ""; then
  enable_mpi_io_buggy="${cmd_enable_mpi_io_buggy}"
 fi

 if test "${cmd_enable_mpi_trace}" != ""; then
  enable_mpi_trace="${cmd_enable_mpi_trace}"
 fi

 if test "${cmd_enable_netcdf}" != ""; then
  enable_netcdf="${cmd_enable_netcdf}"
 fi

 if test "${cmd_enable_nightly}" != ""; then
  enable_nightly="${cmd_enable_nightly}"
 fi

 if test "${cmd_enable_optlevel}" != ""; then
  enable_optlevel="${cmd_enable_optlevel}"
 fi

 if test "${cmd_enable_papi}" != ""; then
  enable_papi="${cmd_enable_papi}"
 fi

 if test "${cmd_enable_scalapack}" != ""; then
  enable_scalapack="${cmd_enable_scalapack}"
 fi

 if test "${cmd_enable_stdin}" != ""; then
  enable_stdin="${cmd_enable_stdin}"
 fi

 if test "${cmd_enable_tricks}" != ""; then
  enable_tricks="${cmd_enable_tricks}"
 fi

 if test "${cmd_enable_wannier90}" != ""; then
  enable_wannier90="${cmd_enable_wannier90}"
 fi

 if test "${cmd_enable_xmlf90}" != ""; then
  enable_xmlf90="${cmd_enable_xmlf90}"
 fi

 dnl
 dnl --with arguments
 dnl

 if test "${cmd_with_64bit_flags}" != ""; then
  with_64bit_flags="${cmd_with_64bit_flags}"
 fi

 if test "${cmd_with_ar_dbgflags}" != ""; then
  with_ar_dbgflags="${cmd_with_ar_dbgflags}"
 fi

 if test "${cmd_with_ar_optflags}" != ""; then
  with_ar_optflags="${cmd_with_ar_optflags}"
 fi

 if test "${cmd_with_bigdft_includes}" != ""; then
  with_bigdft_includes="${cmd_with_bigdft_includes}"
 fi

 if test "${cmd_with_bigdft_libs}" != ""; then
  with_bigdft_libs="${cmd_with_bigdft_libs}"
 fi

 if test "${cmd_with_config_file}" != ""; then
  with_config_file="${cmd_with_config_file}"
 fi

 if test "${cmd_with_cc_dbgflags}" != ""; then
  with_cc_dbgflags="${cmd_with_cc_dbgflags}"
 fi

 if test "${cmd_with_cc_ld_dbgflags}" != ""; then
  with_cc_ld_dbgflags="${cmd_with_cc_ld_dbgflags}"
 fi

 if test "${cmd_with_cc_ld_dbglibs}" != ""; then
  with_cc_ld_dbglibs="${cmd_with_cc_ld_dbglibs}"
 fi

 if test "${cmd_with_cc_ld_optflags}" != ""; then
  with_cc_ld_optflags="${cmd_with_cc_ld_optflags}"
 fi

 if test "${cmd_with_cc_ld_optlibs}" != ""; then
  with_cc_ld_optlibs="${cmd_with_cc_ld_optlibs}"
 fi

 if test "${cmd_with_cc_optflags}" != ""; then
  with_cc_optflags="${cmd_with_cc_optflags}"
 fi

 if test "${cmd_with_cpp_dbgflags}" != ""; then
  with_cpp_dbgflags="${cmd_with_cpp_dbgflags}"
 fi

 if test "${cmd_with_cpp_optflags}" != ""; then
  with_cpp_optflags="${cmd_with_cpp_optflags}"
 fi

 if test "${cmd_with_cxx_dbgflags}" != ""; then
  with_cxx_dbgflags="${cmd_with_cxx_dbgflags}"
 fi

 if test "${cmd_with_cxx_ld_dbgflags}" != ""; then
  with_cxx_ld_dbgflags="${cmd_with_cxx_ld_dbgflags}"
 fi

 if test "${cmd_with_cxx_ld_dbglibs}" != ""; then
  with_cxx_ld_dbglibs="${cmd_with_cxx_ld_dbglibs}"
 fi

 if test "${cmd_with_cxx_ld_optflags}" != ""; then
  with_cxx_ld_optflags="${cmd_with_cxx_ld_optflags}"
 fi

 if test "${cmd_with_cxx_ld_optlibs}" != ""; then
  with_cxx_ld_optlibs="${cmd_with_cxx_ld_optlibs}"
 fi

 if test "${cmd_with_cxx_optflags}" != ""; then
  with_cxx_optflags="${cmd_with_cxx_optflags}"
 fi

 if test "${cmd_with_etsf_io_includes}" != ""; then
  with_etsf_io_includes="${cmd_with_etsf_io_includes}"
 fi

 if test "${cmd_with_etsf_io_libs}" != ""; then
  with_etsf_io_libs="${cmd_with_etsf_io_libs}"
 fi

 if test "${cmd_with_fc_dbgflags}" != ""; then
  with_fc_dbgflags="${cmd_with_fc_dbgflags}"
 fi

 if test "${cmd_with_fc_ld_dbgflags}" != ""; then
  with_fc_ld_dbgflags="${cmd_with_fc_ld_dbgflags}"
 fi

 if test "${cmd_with_fc_ld_dbglibs}" != ""; then
  with_fc_ld_dbglibs="${cmd_with_fc_ld_dbglibs}"
 fi

 if test "${cmd_with_fc_ld_optflags}" != ""; then
  with_fc_ld_optflags="${cmd_with_fc_ld_optflags}"
 fi

 if test "${cmd_with_fc_ld_optlibs}" != ""; then
  with_fc_ld_optlibs="${cmd_with_fc_ld_optlibs}"
 fi

 if test "${cmd_with_fc_optflags}" != ""; then
  with_fc_optflags="${cmd_with_fc_optflags}"
 fi

 if test "${cmd_with_fc_vendor}" != ""; then
  with_fc_vendor="${cmd_with_fc_vendor}"
 fi

 if test "${cmd_with_fc_version}" != ""; then
  with_fc_version="${cmd_with_fc_version}"
 fi

 if test "${cmd_with_fftw_includes}" != ""; then
  with_fftw_includes="${cmd_with_fftw_includes}"
 fi

 if test "${cmd_with_fftw_libs}" != ""; then
  with_fftw_libs="${cmd_with_fftw_libs}"
 fi

 if test "${cmd_with_fox_includes}" != ""; then
  with_fox_includes="${cmd_with_fox_includes}"
 fi

 if test "${cmd_with_fox_libs}" != ""; then
  with_fox_libs="${cmd_with_fox_libs}"
 fi

 if test "${cmd_with_gsl_includes}" != ""; then
  with_gsl_includes="${cmd_with_gsl_includes}"
 fi

 if test "${cmd_with_gsl_libs}" != ""; then
  with_gsl_libs="${cmd_with_gsl_libs}"
 fi

 if test "${cmd_with_libxc_includes}" != ""; then
  with_libxc_includes="${cmd_with_libxc_includes}"
 fi

 if test "${cmd_with_libxc_libs}" != ""; then
  with_libxc_libs="${cmd_with_libxc_libs}"
 fi

 if test "${cmd_with_linalg_includes}" != ""; then
  with_linalg_includes="${cmd_with_linalg_includes}"
 fi

 if test "${cmd_with_linalg_libs}" != ""; then
  with_linalg_libs="${cmd_with_linalg_libs}"
 fi

 if test "${cmd_with_linalg_type}" != ""; then
  with_linalg_type="${cmd_with_linalg_type}"
 fi

 if test "${cmd_with_mpi_cppflags}" != ""; then
  with_mpi_cppflags="${cmd_with_mpi_cppflags}"
 fi

 if test "${cmd_with_mpi_cflags}" != ""; then
  with_mpi_cflags="${cmd_with_mpi_cflags}"
 fi

 if test "${cmd_with_mpi_cc_ldflags}" != ""; then
  with_mpi_cc_ldflags="${cmd_with_mpi_cc_ldflags}"
 fi

 if test "${cmd_with_mpi_cc_libs}" != ""; then
  with_mpi_cc_libs="${cmd_with_mpi_cc_libs}"
 fi

 if test "${cmd_with_mpi_cxxflags}" != ""; then
  with_mpi_cxxflags="${cmd_with_mpi_cxxflags}"
 fi

 if test "${cmd_with_mpi_cxx_ldflags}" != ""; then
  with_mpi_cxx_ldflags="${cmd_with_mpi_cxx_ldflags}"
 fi

 if test "${cmd_with_mpi_cxx_libs}" != ""; then
  with_mpi_cxx_libs="${cmd_with_mpi_cxx_libs}"
 fi

 if test "${cmd_with_mpi_fcflags}" != ""; then
  with_mpi_fcflags="${cmd_with_mpi_fcflags}"
 fi

 if test "${cmd_with_mpi_fc_ldflags}" != ""; then
  with_mpi_fc_ldflags="${cmd_with_mpi_fc_ldflags}"
 fi

 if test "${cmd_with_mpi_fc_libs}" != ""; then
  with_mpi_fc_libs="${cmd_with_mpi_fc_libs}"
 fi

 if test "${cmd_with_mpi_level}" != ""; then
  with_mpi_level="${cmd_with_mpi_level}"
 fi

 if test "${cmd_with_mpi_prefix}" != ""; then
  with_mpi_prefix="${cmd_with_mpi_prefix}"
 fi

 if test "${cmd_with_mpi_runner}" != ""; then
  with_mpi_runner="${cmd_with_mpi_runner}"
 fi

 if test "${cmd_with_netcdf_includes}" != ""; then
  with_netcdf_includes="${cmd_with_netcdf_includes}"
 fi

 if test "${cmd_with_netcdf_libs}" != ""; then
  with_netcdf_libs="${cmd_with_netcdf_libs}"
 fi

 if test "${cmd_with_papi_includes}" != ""; then
  with_papi_includes="${cmd_with_papi_includes}"
 fi

 if test "${cmd_with_papi_libs}" != ""; then
  with_papi_libs="${cmd_with_papi_libs}"
 fi

 if test "${cmd_with_plugins_prefix}" != ""; then
  with_plugins_prefix="${cmd_with_plugins_prefix}"
 fi

 if test "${cmd_with_plugins_tardir}" != ""; then
  with_plugins_tardir="${cmd_with_plugins_tardir}"
 fi

 if test "${cmd_with_scalapack_includes}" != ""; then
  with_scalapack_includes="${cmd_with_scalapack_includes}"
 fi

 if test "${cmd_with_scalapack_libs}" != ""; then
  with_scalapack_libs="${cmd_with_scalapack_libs}"
 fi

 if test "${cmd_with_timeout}" != ""; then
  with_timeout="${cmd_with_timeout}"
 fi

 if test "${cmd_with_wannier90}" != ""; then
  with_wannier90="${cmd_with_wannier90}"
 fi

 if test "${cmd_with_wannier90_includes}" != ""; then
  with_wannier90_includes="${cmd_with_wannier90_includes}"
 fi

 if test "${cmd_with_wannier90_libs}" != ""; then
  with_wannier90_libs="${cmd_with_wannier90_libs}"
 fi

 if test "${cmd_with_xmlf90_includes}" != ""; then
  with_xmlf90_includes="${cmd_with_xmlf90_includes}"
 fi

 if test "${cmd_with_xmlf90_libs}" != ""; then
  with_xmlf90_libs="${cmd_with_xmlf90_libs}"
 fi

 dnl
 dnl Prefix
 dnl
 if test "${cmd_prefix}" != ""; then
  prefix="${cmd_prefix}"
 fi
]) # ABI_OPTIONS_RECALL



dnl ABI_OPTIONS_CHANGED()
dnl ---------------------
dnl
dnl Display changes of user interface between versions and warns about
dnl obsolete uses.
dnl
AC_DEFUN([ABI_OPTIONS_CHANGED],
[AC_MSG_NOTICE([reporting user interface changes:])

 dnl New --enable-macroave option
 AC_MSG_NOTICE([ * new option --enable-macroave is available])

 dnl New --enable-gsl option
 AC_MSG_NOTICE([ * new option --enable-gsl is available])

 dnl New --with-gsl-includes option
 AC_MSG_NOTICE([ * new option --with-gsl-includes is available])

 dnl New --with-gsl-libs option
 AC_MSG_NOTICE([ * new option --with-gsl-libs is available])

 dnl New --enable-exports option
 AC_MSG_NOTICE([ * new option --enable-exports is available])

 dnl New --with-ar-dbgflags option
 AC_MSG_NOTICE([ * new option --with-ar-dbgflags is available])

 dnl New --with-cpp-dbgflags option
 AC_MSG_NOTICE([ * new option --with-cpp-dbgflags is available])

 dnl New --with-cc-dbgflags option
 AC_MSG_NOTICE([ * new option --with-cc-dbgflags is available])

 dnl New --with-cc-ld-dbgflags option
 AC_MSG_NOTICE([ * new option --with-cc-ld-dbgflags is available])

 dnl New --with-cc-ld-dbglibs option
 AC_MSG_NOTICE([ * new option --with-cc-ld-dbglibs is available])

 dnl New --with-cxx-dbgflags option
 AC_MSG_NOTICE([ * new option --with-cxx-dbgflags is available])

 dnl New --with-cxx-ld-dbgflags option
 AC_MSG_NOTICE([ * new option --with-cxx-ld-dbgflags is available])

 dnl New --with-cxx-ld-dbglibs option
 AC_MSG_NOTICE([ * new option --with-cxx-ld-dbglibs is available])

 dnl New --with-fc-dbgflags option
 AC_MSG_NOTICE([ * new option --with-fc-dbgflags is available])

 dnl New --with-fc-ld-dbgflags option
 AC_MSG_NOTICE([ * new option --with-fc-ld-dbgflags is available])

 dnl New --with-fc-ld-dbglibs option
 AC_MSG_NOTICE([ * new option --with-fc-ld-dbglibs is available])

 dnl New --enable-env-file option
 AC_MSG_NOTICE([ * new option --enable-env-file is available])

 dnl New --enable-mpi-io-buggy option
 AC_MSG_NOTICE([ * new option --enable-mpi-io-buggy is available])

 dnl New --enable-papi option
 AC_MSG_NOTICE([ * new option --enable-papi is available])

 dnl New --with-papi-includes option
 AC_MSG_NOTICE([ * new option --with-papi-includes is available])

 dnl New --with-papi-libs option
 AC_MSG_NOTICE([ * new option --with-papi-libs is available])

 dnl UI change for --with-fc-vendor option
 AC_MSG_NOTICE([ * --with-fc-vendor has a new meaning])
 AC_MSG_NOTICE([   please check that with-fc-vendor="${with_fc_vendor}" is OK for you])

 dnl New --with-fc-version option
 AC_MSG_NOTICE([ * new option --with-fc-version is available])

 dnl --enable-etsf-xc > --enable-libxc
 AC_MSG_NOTICE([ * --enable-etsf-xc renamed --enable-libxc])
 if test "${enable_etsf_xc}" != ""; then
  AC_MSG_WARN([option --enable-etsf-xc has been used])
 fi

 dnl --with-etsf-xc-includes > --with-libxc-includes
 AC_MSG_NOTICE([ * --with-etsf-xc-includes renamed --with-libxc-includes])
 if test "${with_etsf_xc_includes}" != ""; then
  AC_MSG_WARN([option --with-etsf-xc-includes has been used])
 fi

 dnl --with-etsf-xc-libs > --with-libxc-libs
 AC_MSG_NOTICE([ * --with-etsf-xc-libs renamed --with-libxc-libs])
 if test "${with_etsf_xc_libs}" != ""; then
  AC_MSG_WARN([option --with-etsf-xc-libs has been used])
 fi

]) dnl ABI_OPTIONS_CHANGED



dnl ABI_OPTIONS_PARSE()
dnl -------------------
dnl
dnl Parses command-line arguments.
dnl
AC_DEFUN([ABI_OPTIONS_PARSE],
[
 AC_REQUIRE([AC_PROG_EGREP])
 AC_MSG_NOTICE([parsing command-line options])

 dnl Parse enable_64bit_flags
 if test "${enable_64bit_flags}" != ""; then
  for v in `echo "${enable_64bit_flags}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_64bit_flags = (${r})])
   AC_MSG_ERROR([invalid option: enable_64bit_flags = ${v}])
  fi
 fi

 dnl Parse enable_all_plugins
 if test "${enable_all_plugins}" != ""; then
  for v in `echo "${enable_all_plugins}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_all_plugins = (${r})])
   AC_MSG_ERROR([invalid option: enable_all_plugins = ${v}])
  fi
 fi

 dnl Parse enable_bigdft
 if test "${enable_bigdft}" != ""; then
  for v in `echo "${enable_bigdft}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_bigdft = (${r})])
   AC_MSG_ERROR([invalid option: enable_bigdft = ${v}])
  fi
 fi

 dnl Parse enable_bindings
 if test "${enable_bindings}" != ""; then
  for v in `echo "${enable_bindings}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_bindings = (${r})])
   AC_MSG_ERROR([invalid option: enable_bindings = ${v}])
  fi
 fi

 dnl Parse enable_cclock
 if test "${enable_cclock}" != ""; then
  for v in `echo "${enable_cclock}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_cclock = (${r})])
   AC_MSG_ERROR([invalid option: enable_cclock = ${v}])
  fi
 fi

 dnl Parse enable_config_file
 if test "${enable_config_file}" != ""; then
  for v in `echo "${enable_config_file}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_config_file = (${r})])
   AC_MSG_ERROR([invalid option: enable_config_file = ${v}])
  fi
 fi

 dnl Parse enable_debug
 if test "${enable_debug}" != ""; then
  for v in `echo "${enable_debug}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no symbols; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no symbols" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_debug = (${r})])
   AC_MSG_ERROR([invalid option: enable_debug = ${v}])
  fi
 fi

 dnl Parse enable_env_file
 if test "${enable_env_file}" != ""; then
  for v in `echo "${enable_env_file}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_env_file = (${r})])
   AC_MSG_ERROR([invalid option: enable_env_file = ${v}])
  fi
 fi

 dnl Parse enable_error_handlers
 if test "${enable_error_handlers}" != ""; then
  for v in `echo "${enable_error_handlers}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_error_handlers = (${r})])
   AC_MSG_ERROR([invalid option: enable_error_handlers = ${v}])
  fi
 fi

 dnl Parse enable_etsf_io
 if test "${enable_etsf_io}" != ""; then
  for v in `echo "${enable_etsf_io}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_etsf_io = (${r})])
   AC_MSG_ERROR([invalid option: enable_etsf_io = ${v}])
  fi
 fi

 dnl Parse enable_exports
 if test "${enable_exports}" != ""; then
  for v in `echo "${enable_exports}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_exports = (${r})])
   AC_MSG_ERROR([invalid option: enable_exports = ${v}])
  fi
 fi

 dnl Parse enable_fc_wrapper
 if test "${enable_fc_wrapper}" != ""; then
  for v in `echo "${enable_fc_wrapper}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_fc_wrapper = (${r})])
   AC_MSG_ERROR([invalid option: enable_fc_wrapper = ${v}])
  fi
 fi

 dnl Parse enable_fftw
 if test "${enable_fftw}" != ""; then
  for v in `echo "${enable_fftw}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_fftw = (${r})])
   AC_MSG_ERROR([invalid option: enable_fftw = ${v}])
  fi
 fi

 dnl Parse enable_fftw_threads
 if test "${enable_fftw_threads}" != ""; then
  for v in `echo "${enable_fftw_threads}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_fftw_threads = (${r})])
   AC_MSG_ERROR([invalid option: enable_fftw_threads = ${v}])
  fi
 fi

 dnl Parse enable_fox
 if test "${enable_fox}" != ""; then
  for v in `echo "${enable_fox}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_fox = (${r})])
   AC_MSG_ERROR([invalid option: enable_fox = ${v}])
  fi
 fi

 dnl Parse enable_gsl
 if test "${enable_gsl}" != ""; then
  for v in `echo "${enable_gsl}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_gsl = (${r})])
   AC_MSG_ERROR([invalid option: enable_gsl = ${v}])
  fi
 fi

 dnl Parse enable_gw_dpc
 if test "${enable_gw_dpc}" != ""; then
  for v in `echo "${enable_gw_dpc}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_gw_dpc = (${r})])
   AC_MSG_ERROR([invalid option: enable_gw_dpc = ${v}])
  fi
 fi

 dnl Parse enable_libxc
 if test "${enable_libxc}" != ""; then
  for v in `echo "${enable_libxc}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_libxc = (${r})])
   AC_MSG_ERROR([invalid option: enable_libxc = ${v}])
  fi
 fi

 dnl Parse enable_macroave
 if test "${enable_macroave}" != ""; then
  for v in `echo "${enable_macroave}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_macroave = (${r})])
   AC_MSG_ERROR([invalid option: enable_macroave = ${v}])
  fi
 fi

 dnl Parse enable_mpi
 if test "${enable_mpi}" != ""; then
  for v in `echo "${enable_mpi}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no manual native; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no manual native" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_mpi = (${r})])
   AC_MSG_ERROR([invalid option: enable_mpi = ${v}])
  fi
 fi

 dnl Parse enable_mpi_io
 if test "${enable_mpi_io}" != ""; then
  for v in `echo "${enable_mpi_io}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_mpi_io = (${r})])
   AC_MSG_ERROR([invalid option: enable_mpi_io = ${v}])
  fi
 fi

 dnl Parse enable_mpi_io_buggy
 if test "${enable_mpi_io_buggy}" != ""; then
  for v in `echo "${enable_mpi_io_buggy}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_mpi_io_buggy = (${r})])
   AC_MSG_ERROR([invalid option: enable_mpi_io_buggy = ${v}])
  fi
 fi

 dnl Parse enable_mpi_trace
 if test "${enable_mpi_trace}" != ""; then
  for v in `echo "${enable_mpi_trace}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_mpi_trace = (${r})])
   AC_MSG_ERROR([invalid option: enable_mpi_trace = ${v}])
  fi
 fi

 dnl Parse enable_netcdf
 if test "${enable_netcdf}" != ""; then
  for v in `echo "${enable_netcdf}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_netcdf = (${r})])
   AC_MSG_ERROR([invalid option: enable_netcdf = ${v}])
  fi
 fi

 dnl Parse enable_nightly
 if test "${enable_nightly}" != ""; then
  for v in `echo "${enable_nightly}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_nightly = (${r})])
   AC_MSG_ERROR([invalid option: enable_nightly = ${v}])
  fi
 fi

 dnl Parse enable_optlevel
 if test "${enable_optlevel}" != ""; then
  for v in `echo "${enable_optlevel}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in safe standard aggressive; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "safe standard aggressive" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_optlevel = (${r})])
   AC_MSG_ERROR([invalid option: enable_optlevel = ${v}])
  fi
 fi

 dnl Parse enable_papi
 if test "${enable_papi}" != ""; then
  for v in `echo "${enable_papi}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_papi = (${r})])
   AC_MSG_ERROR([invalid option: enable_papi = ${v}])
  fi
 fi

 dnl Parse enable_scalapack
 if test "${enable_scalapack}" != ""; then
  for v in `echo "${enable_scalapack}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_scalapack = (${r})])
   AC_MSG_ERROR([invalid option: enable_scalapack = ${v}])
  fi
 fi

 dnl Parse enable_stdin
 if test "${enable_stdin}" != ""; then
  for v in `echo "${enable_stdin}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_stdin = (${r})])
   AC_MSG_ERROR([invalid option: enable_stdin = ${v}])
  fi
 fi

 dnl Parse enable_tricks
 if test "${enable_tricks}" != ""; then
  for v in `echo "${enable_tricks}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no fc-only no-ar opt-only; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no fc-only no-ar opt-only" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_tricks = (${r})])
   AC_MSG_ERROR([invalid option: enable_tricks = ${v}])
  fi
 fi

 dnl Parse enable_wannier90
 if test "${enable_wannier90}" != ""; then
  for v in `echo "${enable_wannier90}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_wannier90 = (${r})])
   AC_MSG_ERROR([invalid option: enable_wannier90 = ${v}])
  fi
 fi

 dnl Parse enable_xmlf90
 if test "${enable_xmlf90}" != ""; then
  for v in `echo "${enable_xmlf90}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in yes no; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "yes no" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([enable_xmlf90 = (${r})])
   AC_MSG_ERROR([invalid option: enable_xmlf90 = ${v}])
  fi
 fi

 dnl Parse with_64bit_flags
 if test "${with_64bit_flags}" != ""; then
  for v in `echo "${with_64bit_flags}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in ar cpp cc cxx fc; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "ar cpp cc cxx fc" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([with_64bit_flags = (${r})])
   AC_MSG_ERROR([invalid option: with_64bit_flags = ${v}])
  fi
 fi

 dnl Parse with_bigdft_includes
 if test "${with_bigdft_includes}" != ""; then
  opt_ok="yes"
  for v in ${with_bigdft_includes}; do
   if test "`echo "${v}" | grep '^-I'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid include statement in with_bigdft_includes: ${v}])
  fi
 fi

 dnl Parse with_bigdft_libs
 if test "${with_bigdft_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_bigdft_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_bigdft_libs: ${v}])
  fi
 fi

 dnl Parse with_etsf_io_includes
 if test "${with_etsf_io_includes}" != ""; then
  opt_ok="yes"
  for v in ${with_etsf_io_includes}; do
   if test "`echo "${v}" | grep '^-I'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid include statement in with_etsf_io_includes: ${v}])
  fi
 fi

 dnl Parse with_etsf_io_libs
 if test "${with_etsf_io_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_etsf_io_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_etsf_io_libs: ${v}])
  fi
 fi

 dnl Parse with_fftw_includes
 if test "${with_fftw_includes}" != ""; then
  opt_ok="yes"
  for v in ${with_fftw_includes}; do
   if test "`echo "${v}" | grep '^-I'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid include statement in with_fftw_includes: ${v}])
  fi
 fi

 dnl Parse with_fftw_libs
 if test "${with_fftw_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_fftw_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_fftw_libs: ${v}])
  fi
 fi

 dnl Parse with_fox_includes
 if test "${with_fox_includes}" != ""; then
  opt_ok="yes"
  for v in ${with_fox_includes}; do
   if test "`echo "${v}" | grep '^-I'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid include statement in with_fox_includes: ${v}])
  fi
 fi

 dnl Parse with_fox_libs
 if test "${with_fox_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_fox_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_fox_libs: ${v}])
  fi
 fi

 dnl Parse with_gsl_includes
 if test "${with_gsl_includes}" != ""; then
  opt_ok="yes"
  for v in ${with_gsl_includes}; do
   if test "`echo "${v}" | grep '^-I'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid include statement in with_gsl_includes: ${v}])
  fi
 fi

 dnl Parse with_gsl_libs
 if test "${with_gsl_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_gsl_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_gsl_libs: ${v}])
  fi
 fi

 dnl Parse with_libxc_includes
 if test "${with_libxc_includes}" != ""; then
  opt_ok="yes"
  for v in ${with_libxc_includes}; do
   if test "`echo "${v}" | grep '^-I'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid include statement in with_libxc_includes: ${v}])
  fi
 fi

 dnl Parse with_libxc_libs
 if test "${with_libxc_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_libxc_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_libxc_libs: ${v}])
  fi
 fi

 dnl Parse with_linalg_includes
 if test "${with_linalg_includes}" != ""; then
  opt_ok="yes"
  for v in ${with_linalg_includes}; do
   if test "`echo "${v}" | grep '^-I'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid include statement in with_linalg_includes: ${v}])
  fi
 fi

 dnl Parse with_linalg_libs
 if test "${with_linalg_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_linalg_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_linalg_libs: ${v}])
  fi
 fi

 dnl Parse with_linalg_type
 if test "${with_linalg_type}" != ""; then
  opt_ok="no"
  for v in ${linalg_supported_types}; do
   if test "${with_linalg_type}" = "${v}"; then
    opt_ok="yes"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([unsupported linear algebra implementation: ${with_linalg_type}])
  fi
 fi

 dnl Parse with_mpi_cc_libs
 if test "${with_mpi_cc_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_mpi_cc_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_mpi_cc_libs: ${v}])
  fi
 fi

 dnl Parse with_mpi_cxx_libs
 if test "${with_mpi_cxx_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_mpi_cxx_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_mpi_cxx_libs: ${v}])
  fi
 fi

 dnl Parse with_mpi_fc_libs
 if test "${with_mpi_fc_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_mpi_fc_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_mpi_fc_libs: ${v}])
  fi
 fi

 dnl Parse with_mpi_level
 if test "${with_mpi_level}" != ""; then
  for v in `echo "${with_mpi_level}" | sed -e 's/,/ /g'`; do
   opt_ok="no"
   for r in 1 2; do
    if test "${v}" = "${r}";then
     opt_ok="yes"
     break
    fi
   done
   test "${opt_ok}" = "no" && break
  done
  if test "${opt_ok}" = "no"; then
   r=`echo "1 2" | sed -e 's/^[[ ]]*//; s/[[ ]]*$//; s/[[ ]][[ ]]*/ /g; s/ /|/g'`
   AC_MSG_WARN([with_mpi_level = (${r})])
   AC_MSG_ERROR([invalid option: with_mpi_level = ${v}])
  fi
 fi

 dnl Parse with_netcdf_includes
 if test "${with_netcdf_includes}" != ""; then
  opt_ok="yes"
  for v in ${with_netcdf_includes}; do
   if test "`echo "${v}" | grep '^-I'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid include statement in with_netcdf_includes: ${v}])
  fi
 fi

 dnl Parse with_netcdf_libs
 if test "${with_netcdf_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_netcdf_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_netcdf_libs: ${v}])
  fi
 fi

 dnl Parse with_papi_includes
 if test "${with_papi_includes}" != ""; then
  opt_ok="yes"
  for v in ${with_papi_includes}; do
   if test "`echo "${v}" | grep '^-I'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid include statement in with_papi_includes: ${v}])
  fi
 fi

 dnl Parse with_papi_libs
 if test "${with_papi_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_papi_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_papi_libs: ${v}])
  fi
 fi

 dnl Parse with_scalapack_includes
 if test "${with_scalapack_includes}" != ""; then
  opt_ok="yes"
  for v in ${with_scalapack_includes}; do
   if test "`echo "${v}" | grep '^-I'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid include statement in with_scalapack_includes: ${v}])
  fi
 fi

 dnl Parse with_scalapack_libs
 if test "${with_scalapack_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_scalapack_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_scalapack_libs: ${v}])
  fi
 fi

 dnl Parse with_timeout
 if test "${with_timeout}" != ""; then
  opt_ok="yes"
  test "`echo "${with_timeout}" | ${EGREP} -e '^-?[[0-9]]+$'`" = "" && opt_ok="no"
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid integer: with_timeout = ${with_timeout}])
  fi
 fi

 dnl Parse with_wannier90_includes
 if test "${with_wannier90_includes}" != ""; then
  opt_ok="yes"
  for v in ${with_wannier90_includes}; do
   if test "`echo "${v}" | grep '^-I'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid include statement in with_wannier90_includes: ${v}])
  fi
 fi

 dnl Parse with_wannier90_libs
 if test "${with_wannier90_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_wannier90_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_wannier90_libs: ${v}])
  fi
 fi

 dnl Parse with_xmlf90_includes
 if test "${with_xmlf90_includes}" != ""; then
  opt_ok="yes"
  for v in ${with_xmlf90_includes}; do
   if test "`echo "${v}" | grep '^-I'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid include statement in with_xmlf90_includes: ${v}])
  fi
 fi

 dnl Parse with_xmlf90_libs
 if test "${with_xmlf90_libs}" != ""; then
  opt_ok="yes"
  for v in ${with_xmlf90_libs}; do
   if test "`echo "${v}" | grep '^-[[Ll]]'`" = ""; then
    opt_ok="no"
    break
   fi
  done
  if test "${opt_ok}" = "no"; then
   AC_MSG_ERROR([invalid library statement in with_xmlf90_libs: ${v}])
  fi
 fi

]) dnl ABI_OPTIONS_PARSE
