#
# Makefile for the Octopus XC library embedded in ABINIT
#

include ../../config.mk

all_targets all libxc: install
	@echo "$(libxc_pkg_name) is now ready for use."

uncompress: uncompress-stamp
	@echo "$(libxc_pkg_name) has been uncompressed."

configure: configure-stamp
	@echo "$(libxc_pkg_name) has been configured."

build: build-stamp
	@echo "$(libxc_pkg_name) has been built."

install: install-stamp
	@echo "$(libxc_pkg_name) has been installed."

uncompress-stamp:
	gzip -cd $(abinit_tardir)/$(libxc_pkg_name).tar.gz | tar xf -
	touch uncompress-stamp

configure-stamp: uncompress
	cd $(libxc_pkg_name) && \
	 CPP="$(CPP)" \
	 CPPFLAGS="$(CPPFLAGS_LIBXC)" \
	 CC="$(CC)" \
	 CFLAGS="$(CFLAGS_LIBXC)" \
	 FCCPP="$(TRUE_CPP) $(TRUE_CPPFLAGS)" \
	 FC="$(FC)" \
	 FCFLAGS="$(FCFLAGS_FREEFORM) $(FCFLAGS_LIBXC)" \
	 ./configure \
	  --prefix="$(abinit_builddir)/plugins/libxc/tmp" \
	  $(CFGFLAGS_LIBXC)
	touch configure-stamp

build-stamp: configure
	cd $(libxc_pkg_name) && $(MAKE)
	touch build-stamp

install-stamp: build
	cd $(libxc_pkg_name) && $(MAKE) install
	-cp $(libxc_pkg_name)/src/xc_types.mod \
	 $(libxc_pkg_name)/src/libxc.mod tmp/include
	touch install-stamp

clean:
	rm -rf $(libxc_pkg_name)
