!{\src2tex{textfont=tt}}
!!****m* ABINIT/defs_elphon
!!
!! NAME
!! defs_elphon
!!
!! FUNCTION
!! This module contains the datastructures for elphon
!!  the different (huge) matrices will either be allocated and
!!  used, or be written to disk. All combinations should be feasible.
!!
!! COPYRIGHT
!! Copyright (C) 2004-2009 ABINIT group (MVer, MG)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! NOTES
!!  Contains two datastructures:
!!   elph_type contains data and dimensions for the kpoints near the
!!    fermi surface and the $g_{k k+q}$ matrix elements
!!   phon_type contains the necessary data to interpolate the
!!    phonon bandstructure and eigenvectors in reciprocal space (ie.
!!    interatomic force constants and corresponding real space grid info).
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

module defs_elphon

  use defs_basis

  implicit none

!!***

!----------------------------------------------------------------------

!!****t* defs_elphon/elph_type
!! NAME
!! elph_type
!!
!! FUNCTION
!! elph_type contains data and dimensions for the kpoints near the
!! fermi surface and the $g_{k k+q}$ matrix elements
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

  type elph_type
     
   integer :: natom,nbranch,nFSband 
   integer :: nFSkpt,nFSkptirred,nqpt            !Matrix dimensions (natom is redundant)
   integer :: minFSband,maxFSband                !Index of lower and upper bands used for the FS

   integer :: ngkkband                           !Number of bands kept in final gkk matrix elements:
                                                 !either 1 if sum is performed immediately
                                                 !or = nband if all elements are kept based on flag tkeepbands

   integer :: nqptirred                          !number of irred q-points


   integer :: unita2f,unit_gkk2,unit_gkk_rpt
   integer :: unitgkq,unitphfrq                  !units for file output
     
   integer :: gkqexist,gkqwrite                              
   integer :: gkk2exist,gkk2write
   integer :: gkk_rptexist,gkk_rptwrite
   integer :: phfrqwrite,phfrqexist              !flags for existence and RAM/disk status for each matrix below

   integer :: doscalprod                         !flag to perform the scalar product
   integer :: tsymgkq                            !flag to symmetrize gkq matrix elements
   integer :: tkeepbands                         !flag to sum over bands or not

   
   integer :: na2f                               !dimensions and increments for a2F function
   integer :: nsppol                             ! number of spin polarization channels
   integer :: nspinor                            ! number of spinorial components
   real(dp) :: omega_min,omega_max 
   real(dp) :: a2fsmear,domega
   real(dp) :: occ_factor                        ! normalization for integrals over FS, for num of spins, spinors, etc...

   real(dp) :: mustar                            !mustar parameter
   real(dp) :: fermie                            !Fermi energy (Ha), either comes from wfk file or from anaddb input file

   character(len=fnlen) :: elph_base_name        !base name for output files

   integer,pointer :: qirredtofull(:)            !mapping between the qpoints found in the GGK file
                                                 !and the array of qpoints generated by the code

   real(dp),pointer :: wtq(:)                    !weight for each qpoint in the full grid spqt
                                                 !if a point is not in the IBZ ==>  wtq=0 
                                                 !MG we can also use indqpt

   real(dp),pointer :: n0(:)                     !DOS at the Fermi level (states/Ha/spin)
   real(dp),pointer :: spqpt(:,:)                !special q points obtained by the Monkhorst & Pack method,
                                                 !in reduced coordinates.These vectors have to be multiplied
                                                 !by the reciprocal basis vectors

   real(dp),pointer :: FSkpt(:,:)                !coordinates of the full kpoints close to the FS

   real(dp),pointer :: FSintweight(:,:,:)        !integration weights (see also gkk_intweight)
   real(dp),pointer :: FSkptirred(:,:)

   real(dp),pointer :: gkk_intweight(:,:,:)      !integration weights for gkk matrix elements on FS:
                                                 !if tkeepbands == 0 all are 1
                                                 !if tkeepbands == 1 then = to FSintweight in elphon
                                                 !DOES NOT INCLUDE FACTOR OF 1/nFSkpt

   real(dp),pointer :: gkk_qpt(:,:,:,:,:,:)      !Now gkq contains gkk2 matrices on basic qpts, 
                                                 !summed over bands if ngkkband==1
                                                 ! dims= 2, ngkkband**2, nbranch**2, nfskpt, nsppol, nqpt


   real(dp),pointer :: gkk_rpt(:,:,:,:,:,:)      !For the moment, gkk_rpt in memory is out of the question
                                                 ! dims= 2, ngkkband**2, nbranch**2, nfskpt, nsppol, nrpt
   real(dp),pointer :: gkk2(:,:,:,:,:,:)         !real(dp),pointer :: gkk_rpt(:,:,:,:,:,:)
                                                 !Same for real space:

   real(dp),pointer :: gamma_qpt(:,:,:,:)        !gamma matrices integrated over kpoint coeff
                                                 !  and bands: still depends on qpt
                                                 ! dims= 2, nbranch**2, nsppol, nqpt
   real(dp),pointer :: gamma_rpt(:,:,:,:)
                                                 ! dims= 2, nbranch**2, nsppol, nrpt
!NOTE: choice to put nsppol before or after nqpt is a bit arbitrary
!   abinis uses nband,nkpt,nsppol, but here for convenience nfskpt,nsppol,nqpt 
!   as interpolation is on qpt

   real(dp),pointer :: phfrq(:,:)                !phonon frequencies
   real(dp),pointer :: a2f(:,:,:)                !a2f function

   real(dp),pointer :: qgrid_data(:,:,:,:)       !e-ph values calculated over the irreducible part of the q-grid:
                                                 !first entry  =  index of the q-point,
                                                 !second index =  branch index
                                                 !the third slice contains the frequency, the linewidth and lambda(q,nu)
                                                 !for that particular phonon mode
                                                 ! dims= nqptirred,elph_ds%nbranch,nsppol,3 

  end type elph_type
!!***

!----------------------------------------------------------------------

!!****t* defs_elphon/phon_type
!! NAME
!! phon_type
!!
!! FUNCTION
!! phon_type contains the necessary data to interpolate the
!! phonon bandstructure and eigenvectors in reciprocal space 
!! (ie. interatomic force constants and corresponding real space grid info).
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 type phon_type

  integer :: dipdip
  integer :: mpert,nsym
  integer :: natom,ntypat,nrpt
  integer,pointer :: indsym(:,:,:),symrel(:,:,:),typat(:)
  real(dp) :: ucvol
  real(dp),pointer :: acell(:),amu(:),atmfrc(:,:,:,:,:,:)
  real(dp),pointer :: dielt(:,:),dyewq0(:,:,:),gprim(:,:),gmet(:,:)
  real(dp),pointer :: xred(:,:),zeff(:,:,:)
  real(dp),pointer :: rcan(:,:),rmet(:,:),rprim(:,:),rprimd(:,:),rpt(:,:)
  real(dp),pointer :: trans(:,:),wghatm(:,:,:)

 end type phon_type

!!***

!----------------------------------------------------------------------


!!****t* defs_elphon/elph_tr_type
!! NAME
!! phon_type
!!
!! FUNCTION
!! elph_tr_ds contains the necessary data for the transport properties
!!
!! SOURCE

  type elph_tr_type

     integer :: ifltransport
     integer :: unitgkq_trin,unitgkq_trout
     integer :: gkqwrite,gkqexist
     integer :: onegkksize
     character(len=fnlen) :: ddkfilename
     real(dp),pointer :: el_veloc(:,:,:,:)       ! nkpt nband 3 nsppol
     real(dp),pointer :: gkk_qpt_tr(:,:,:,:,:,:) ! 2 bands**2 branches**2 nFSkpt nsppol qpt 
     real(dp),pointer :: gkk_qpt_trin(:,:,:,:,:,:) 
     real(dp),pointer :: gkk_qpt_trout(:,:,:,:,:,:) 
     real(dp),pointer :: gamma_qpt_tr(:,:,:,:)   ! 2 branches**2 nsppol qpt
     real(dp),pointer :: gamma_qpt_trin(:,:,:,:)
     real(dp),pointer :: gamma_qpt_trout(:,:,:,:)
     real(dp),pointer :: gamma_rpt_tr(:,:,:,:)
     real(dp),pointer :: gamma_rpt_trin(:,:,:,:)
     real(dp),pointer :: gamma_rpt_trout(:,:,:,:)
     real(dp),pointer :: a2f_1d_tr(:,:)          ! nfreq nsppol
     real(dp),pointer :: a2f_1d_trin(:,:)
     real(dp),pointer :: a2f_1d_trout(:,:)

     real(dp),pointer ::  FSelecveloc_sq(:)      ! nsppol



  end type elph_tr_type

end module defs_elphon
!!***
