!{\src2tex{textfont=tt}}
!!****f* ABINIT/xcast_mpi
!! NAME
!! xcast_mpi
!!
!! FUNCTION
!! This module contains functions that calls MPI routine,
!! if we compile the code using the MPI CPP flags.
!! xcast_mpi is the generic function.
!!
!! COPYRIGHT
!! Copyright (C) 2001-2009 ABINIT group (Rshaltaf,AR,XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! TODO
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine xcast_mpi_intv(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
  integer,intent(inout) :: xval
  integer,intent(in) :: spaceComm,master
  integer,intent(out)   :: ier
!Local variables-------------------

! *************************************************************************

  ier=0
#if defined MPI
   call MPI_BCAST(xval,1,MPI_INTEGER,master,spaceComm,ier)
#endif
  end subroutine xcast_mpi_intv
!!***

!!****f* ABINIT/xcast_mpi_int1d
!! NAME
!! xcast_mpi_int1d
!! 
!! SOURCE
subroutine xcast_mpi_int1d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments ------------------------------------
 integer,intent(inout) :: xval(:)
 integer,intent(in) :: spaceComm,master
 integer,intent(out)   :: ier
!Local variables-------------------------------
 integer :: n

! *************************************************************************

 ier=0
 n=size(xval)
#if defined MPI 
                   call MPI_BCAST(xval,n,MPI_INTEGER,master,spaceComm,ier)
#endif
end subroutine xcast_mpi_int1d
!!***

!!****f* ABINIT/xcast_mpi_int2d
!! NAME
!! xcast_mpi_int2d
!! 
!! SOURCE
subroutine xcast_mpi_int2d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer,intent(inout) :: xval(:,:)
 integer,intent(in) :: spaceComm,master
 integer,intent(out)   :: ier

!Local variables-------------------
 integer :: n1,n2

! *************************************************************************

 n1=size(xval,dim=1)
 n2=size(xval,dim=2)
 ier=0
#if defined MPI
                  call MPI_BCAST(xval,n1*n2,MPI_INTEGER,master,spaceComm,ier)
#endif
end subroutine xcast_mpi_int2d
!!***

!!****f* ABINIT/xcast_mpi_int3d
!! NAME
!! xcast_mpi_int3d
!! 
!! SOURCE
subroutine xcast_mpi_int3d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
  include 'mpif.h'
#endif

!Arguments-------------------------
 integer,intent(inout) :: xval(:,:,:)
 integer,intent(in) :: spaceComm,master
 integer,intent(out)   :: ier

!Local variables-------------------------------
 integer :: n1,n2,n3

! *************************************************************************

 n1=size(xval,dim=1)
 n2=size(xval,dim=2)
 n3=size(xval,dim=3)
 ier=0
#if defined MPI
                  call MPI_BCAST(xval,n1*n2*n3,MPI_INTEGER,master,spaceComm,ier)
#endif
end subroutine xcast_mpi_int3d
!!***

!!****f* ABINIT/xcast_mpi_dpv
!! NAME
!! xcast_mpi_dpv
!! 
!! SOURCE
subroutine xcast_mpi_dpv(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

  implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments ------------------------------------
 real(dp),intent(inout) :: xval
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier
!Local variables-------------------------------

! *************************************************************************

 ier=0
#if defined MPI
     call MPI_BCAST(xval,1,MPI_DOUBLE_PRECISION,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_dpv
!!***

!!****f* ABINIT/xcast_mpi_dp1d
!! NAME
!! xcast_mpi_dp1d
!! 
!! SOURCE
subroutine xcast_mpi_dp1d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
    include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval(:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer::n

! *************************************************************************

 n=size(xval,dim=1)
 ier=0
#if defined MPI
  call MPI_BCAST(xval,n,MPI_DOUBLE_PRECISION,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_dp1d
!!***

!!****f* ABINIT/xcast_mpi_dp2d
!! NAME
!! xcast_mpi_dp2d
!! 
!! SOURCE
subroutine xcast_mpi_dp2d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
    include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval(:,:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer::n1,n2

! *************************************************************************

 n1=size(xval,dim=1)
 n2=size(xval,dim=2) 
 ier=0
#if defined MPI
  call MPI_BCAST(xval,n1*n2,MPI_DOUBLE_PRECISION,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_dp2d
!!***

!!****f* ABINIT/xcast_mpi_dp3d
!! NAME
!! xcast_mpi_dp3d
!! 
!! SOURCE
subroutine xcast_mpi_dp3d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
    include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval(:,:,:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer::n1,n2,n3

! *************************************************************************

 n1=size(xval,dim=1)
 n2=size(xval,dim=2)
 n3=size(xval,dim=3)
 ier=0
#if defined MPI
  call MPI_BCAST(xval,n1*n2*n3,MPI_DOUBLE_PRECISION,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_dp3d
!!***

!!****f* ABINIT/xcast_mpi_dp4d
!! NAME
!! xcast_mpi_dp4d
!! 
!! SOURCE
subroutine xcast_mpi_dp4d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
    include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval(:,:,:,:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer::n1,n2,n3,n4

! *************************************************************************

 n1=size(xval,dim=1)
 n2=size(xval,dim=2)
 n3=size(xval,dim=3)
 n4=size(xval,dim=4)
 ier=0
#if defined MPI
  call MPI_BCAST(xval,n1*n2*n3*n4,MPI_DOUBLE_PRECISION,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_dp4d
!!***

!!****f* ABINIT/xcast_mpi_spv
!! NAME
!! xcast_mpi_spv
!! 
!! SOURCE
subroutine xcast_mpi_spv(xval,master,spaceComm,ier)

use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

implicit none

#if defined MPI && defined MPI1
  include 'mpif.h'
#endif

!Arguments-------------------------
 real,intent(inout) :: xval
 integer,intent(in) :: spaceComm,master
 integer,intent(out) :: ier

!Local variables-------------------
 
! *************************************************************************

 ier=0
#if defined MPI 
 call MPI_BCAST(xval,1,MPI_REAL,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_spv
!!***

!!****f* ABINIT/xcast_mpi_sp1d
!! NAME
!! xcast_mpi_sp1d
!! 
!! SOURCE
subroutine xcast_mpi_sp1d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
    include 'mpif.h'
#endif

!Arguments-------------------------
 real,intent(inout) :: xval(:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer::n

! *************************************************************************

 n=size(xval,dim=1)
 ier=0
#if defined MPI 
  call MPI_BCAST(xval,n,MPI_REAL,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_sp1d
!!***

!!****f* ABINIT/xcast_mpi_sp2d
!! NAME
!! xcast_mpi_sp2d
!! 
!! SOURCE
subroutine xcast_mpi_sp2d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real,intent(inout) :: xval(:,:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer::n1,n2

! *************************************************************************

 n1=size(xval,dim=1)
 n2=size(xval,dim=2)
 ier=0
#if defined MPI
  call MPI_BCAST(xval,n1*n2,MPI_REAL,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_sp2d
!!***

!!****f* ABINIT/xcast_mpi_sp3d
!! NAME
!! xcast_mpi_sp3d
!! 
!! SOURCE
subroutine xcast_mpi_sp3d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
    include 'mpif.h'
#endif

!Arguments-------------------------
 real,intent(inout) :: xval(:,:,:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer::n1,n2,n3

! *************************************************************************

 n1=size(xval,dim=1)
 n2=size(xval,dim=2)
 n3=size(xval,dim=3)
 ier=0
#if defined MPI
  call MPI_BCAST(xval,n1*n2*n3,MPI_REAL,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_sp3d
!!***

!!****f* ABINIT/xcast_mpi_sp4d
!! NAME
!! xcast_mpi_sp4d
!! 
!! SOURCE
subroutine xcast_mpi_sp4d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
    include 'mpif.h'
#endif

!Arguments-------------------------
 real,intent(inout) :: xval(:,:,:,:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer::n1,n2,n3,n4

! *************************************************************************

 n1=size(xval,dim=1)
 n2=size(xval,dim=2)
 n3=size(xval,dim=3)
 n4=size(xval,dim=4)
 ier=0
#if defined MPI
  call MPI_BCAST(xval,n1*n2*n3*n4,MPI_REAL,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_sp4d
!!***

!!****f* ABINIT/xcast_mpi_cplxv
!! NAME
!! xcast_mpi_cplxv
!! 
!! SOURCE
subroutine xcast_mpi_cplxv(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 complex,intent(inout) :: xval
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------

! *************************************************************************

 ier=0
#if defined MPI 
  call MPI_BCAST(xval,1,MPI_COMPLEX,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_cplxv
!!***

!!****f* ABINIT/xcast_mpi_cplx1d
!! NAME
!! xcast_mpi_cplx1d
!! 
!! SOURCE
subroutine xcast_mpi_cplx1d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 complex,intent(inout) :: xval(:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer::n

! *************************************************************************

 n=size(xval(:))
 ier=0
#if defined MPI 
  call MPI_BCAST(xval,n,MPI_COMPLEX,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_cplx1d
!!***

!!****f* ABINIT/xcast_mpi_cplx2d
!! NAME
!! xcast_mpi_cplx2d
!! 
!! SOURCE
subroutine xcast_mpi_cplx2d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 complex,intent(inout) :: xval(:,:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
integer::n1,n2

! *************************************************************************

n1=size(xval,dim=1)
n2=size(xval,dim=2)
 ier=0
#if defined MPI 
  call MPI_BCAST(xval,n1*n2,MPI_COMPLEX,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_cplx2d
!!***

!!****f* ABINIT/xcast_mpi_cplx3d
!! NAME
!! xcast_mpi_cplx3d
!! 
!! SOURCE
subroutine xcast_mpi_cplx3d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 complex,intent(inout) :: xval(:,:,:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
integer::n1,n2,n3

! *************************************************************************

n1=size(xval,dim=1)
n2=size(xval,dim=2)
n3=size(xval,dim=3)
 ier=0
#if defined MPI 
  call MPI_BCAST(xval,n1*n2*n3,MPI_COMPLEX,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_cplx3d
!!***

!!****f* ABINIT/xcast_mpi_cplx4d
!! NAME
!! xcast_mpi_cplx4d
!! 
!! SOURCE
subroutine xcast_mpi_cplx4d(xval,master,spaceComm,ier)

 use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 complex,intent(inout) :: xval(:,:,:,:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
integer::n1,n2,n3,n4

! *************************************************************************

n1=size(xval,dim=1)
n2=size(xval,dim=2)
n3=size(xval,dim=3)
n4=size(xval,dim=4)
 ier=0
#if defined MPI
  call MPI_BCAST(xval,n1*n2*n3*n4,MPI_COMPLEX,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_cplx4d
!!***

!!****f* ABINIT/xcast_mpi_dcv
!! NAME
!! xcast_mpi_dcv
!! 
!! SOURCE
subroutine xcast_mpi_dcv(xval,master,spaceComm,ier)

use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 complex(dp),intent(inout):: xval
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------

! *************************************************************************

  ier=0
#if defined MPI
  call MPI_BCAST(xval,1,MPI_DOUBLE_COMPLEX,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_dcv
!!***

!!****f* ABINIT/xcast_mpi_dc1d
!! NAME
!! xcast_mpi_dct1d
!! 
!! SOURCE
subroutine xcast_mpi_dc1d(xval,master,spaceComm,ier)

use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 complex(dp),intent(inout):: xval(:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer::n

! *************************************************************************

 n=size(xval(:))
  ier=0
#if defined MPI
  call MPI_BCAST(xval,n,MPI_DOUBLE_COMPLEX,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_dc1d
!!***

!!****f* ABINIT/xcast_mpi_dc2d
!! NAME
!! xcast_mpi_dc2d
!! 
!! SOURCE
subroutine xcast_mpi_dc2d(xval,master,spaceComm,ier)

use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 complex(dp),intent(inout):: xval(:,:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
  integer::n1,n2

! *************************************************************************

  n1=size(xval,dim=1)
  n2=size(xval,dim=2)
  ier=0
#if defined MPI
  call MPI_BCAST(xval,n1*n2,MPI_DOUBLE_COMPLEX,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_dc2d
!!***

!!****f* ABINIT/xcast_mpi_dc3d
!! NAME
!! xcast_mpi_dc3d
!! 
!! SOURCE
subroutine xcast_mpi_dc3d(xval,master,spaceComm,ier)

use defs_basis
#if defined MPI && defined MPI2
 use mpi
#endif

implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 complex(dp),intent(inout):: xval(:,:,:)
 integer ,intent(in) :: spaceComm,master
 integer ,intent(out)   :: ier

!Local variables-------------------
  integer::n1,n2,n3

! *************************************************************************

  n1=size(xval,dim=1)
  n2=size(xval,dim=2)
  n3=size(xval,dim=3)
  ier=0
#if defined MPI
  call MPI_BCAST(xval,n1*n2*n3,MPI_DOUBLE_COMPLEX,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_dc3d
!!***

!!****f* ABINIT/xcast_mpi_ch0d
!! NAME
!! xcast_mpi_ch0d
!! 
!! SOURCE
subroutine xcast_mpi_ch0d(xval,master,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 character(len=*),intent(inout) :: xval
 integer,intent(in) :: spaceComm,master
 integer,intent(out)   :: ier

!Local variables-------------------------------

 integer :: nch,rank
!*************************************************************************

 ier=0
#if defined MPI 
 ! version 1
 !call MPI_BCAST(xval,len(xval),MPI_CHARACTER,master,spaceComm,ier)
 ! version 2
 call MPI_COMM_RANK(spaceComm,rank,ier)
 if (rank==master) nch=len_trim(xval)
 call MPI_BCAST(nch,1,MPI_INTEGER,master,spaceComm,ier)
 call MPI_BCAST(xval,nch,MPI_CHARACTER,master,spaceComm,ier)
 if (rank/=master) xval(nch+1:)=''
#endif

end subroutine xcast_mpi_ch0d
!!***

!!****f* ABINIT/xcast_mpi_ch1d
!! NAME
!! xcast_mpi_ch1d
!! 
!! SOURCE
subroutine xcast_mpi_ch1d(xval,master,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 Character(len=*),intent(inout) :: xval(:)
 integer,intent(in) :: spaceComm,master
 integer,intent(out)   :: ier

!Local variables-------------------------------
 integer :: ii,nch

!*************************************************************************

 ier=0
#if defined MPI 
 nch=0
 do ii=1,size(xval)
  nch=nch+len(xval(ii))
 end do
 call MPI_BCAST(xval,nch,MPI_CHARACTER,master,spaceComm,ier)
#endif

end subroutine xcast_mpi_ch1d
!!***
