!{\src2tex{textfont=tt}}
!!****f* ABINIT/xsum_mpi
!! NAME
!! xsum_mpi
!!
!! FUNCTION
!! This module contains functions that calls MPI routine,
!! if we compile the code using the MPI CPP flags.
!! xsum_mpi is the generic function.
!!
!! COPYRIGHT
!! Copyright (C) 2001-2009 ABINIT group (AR,XG,MB)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! TODO
!!
!! NOTES
!!  MG: The additional arrays xsum in not needed, MPI defines an
!!  option to do the SUM in place in case in intracommunicators.
!!  It would be useful to have a wrapper for the in place option
!!  since it allows for memory saving if the array to be summed up is large
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine xsum_mpi_int(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments ------------------------------------
 integer,intent(inout) :: xval(:)
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables-------------------------------

 integer :: n1

#if defined MPI
           integer , allocatable :: xsum(:)
#endif
! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /= MPI_COMM_SELF) then
!          Accumulate xval on all proc. in spaceComm
            n1 = size(xval)
            allocate(xsum(n1))
            call MPI_ALLREDUCE(xval,xsum,n1,MPI_INTEGER,&
            &  MPI_SUM,spaceComm,ier)
            xval (:) = xsum(:)
            deallocate(xsum)
           end if
#endif
end subroutine xsum_mpi_int
!!***

!!****f* ABINIT/xsum_mpi_intv
!! NAME
!! xsum_mpi_intv
!! 
!! SOURCE
subroutine xsum_mpi_intv(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments----------------------
 integer,intent(inout) :: xval
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables----------------
#if defined MPI
           integer  :: xsum
#endif
! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /= MPI_COMM_SELF) then
           !Accumulate xval on all proc. in spaceComm
            call MPI_ALLREDUCE(xval,xsum,1,MPI_INTEGER,&
            &  MPI_SUM,spaceComm,ier)
            xval = xsum
           end if
#endif
end subroutine xsum_mpi_intv
!!***

!!****f* ABINIT/xsum_mpi_intv2
!! NAME
!! xsum_mpi_intv2
!! 
!! SOURCE
subroutine xsum_mpi_intv2(xval,xsum,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments---------------------
 integer,intent(inout) :: xval,xsum
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables---------------

! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /=  MPI_COMM_SELF) then
           !Accumulate xval on all proc. in spaceComm
            call MPI_ALLREDUCE(xval,xsum,1,MPI_INTEGER,&
            &  MPI_SUM,spaceComm,ier)
           end if
#else
 xsum=xval
#endif
end subroutine xsum_mpi_intv2
!!***

!!****f* ABINIT/xsum_mpi_intn
!! NAME
!! xsum_mpi_intn
!! 
!! SOURCE
subroutine xsum_mpi_intn(xval,n1,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer,intent(inout) :: xval(:)
 integer,intent(in)    :: n1
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables-------------------
#if defined MPI
           integer , allocatable :: xsum(:)
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
           !Accumulate xval on all proc. in spaceComm
           if (spaceComm /=  MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             allocate(xsum(n1))
             call MPI_ALLREDUCE(xval,xsum,n1,MPI_INTEGER,&
             &  MPI_SUM,spaceComm,ier)
             xval (:) = xsum(:)
             deallocate(xsum)
            end if
           end if
#endif
end subroutine xsum_mpi_intn
!!***

!!****f* ABINIT/xsum_mpi_int2t
!! NAME
!! xsum_mpi_int2t
!! 
!! SOURCE
subroutine xsum_mpi_int2t(xval,xsum,n1,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none
#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer ,intent(inout) :: xval(:),xsum(:)
 integer ,intent(in)    :: n1
 integer ,intent(in) :: spaceComm
 integer ,intent(out)   :: ier

!Local variables-------------------

! *************************************************************************
 ier=0
#if defined MPI 
            if (spaceComm /=  MPI_COMM_SELF) then
             !Accumulate xval on all proc. in spaceComm
             call MPI_ALLREDUCE(xval,xsum,n1,MPI_INTEGER,&
             &  MPI_SUM,spaceComm,ier)
            end if
#else
 xsum=xval
#endif
end subroutine xsum_mpi_int2t
!!***

!!****f* ABINIT/xsum_mpi_int2d
!! NAME
!! xsum_mpi_int2d
!! 
!! SOURCE
subroutine xsum_mpi_int2d(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer,intent(inout) :: xval(:,:)
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables-------------------
 integer ::   n1,n2

#if defined MPI
           integer , allocatable :: xsum(:,:)
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /=  MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             !Accumulate xval on all proc. in spaceComm
             n1 =size(xval,dim=1)
             n2 =size(xval,dim=2)
             allocate(xsum(n1,n2))
             call MPI_ALLREDUCE(xval,xsum,n1*n2,MPI_INTEGER,&
             &  MPI_SUM,spaceComm,ier)
             xval (:,:) = xsum(:,:)
             deallocate(xsum)
            end if
           end if
#endif
end subroutine xsum_mpi_int2d
!!***

!!****f* ABINIT/xsum_mpi_int3d
!! NAME
!! xsum_mpi_int3d
!! 
!! SOURCE
subroutine xsum_mpi_int3d(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer,intent(inout) :: xval(:,:,:)
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables-------------------
 integer ::   n1,n2,n3

#if defined MPI
           integer , allocatable :: xsum(:,:,:)
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
           !Accumulate xval on all proc. in spaceComm
           if (spaceComm /=  MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             n1 =size(xval,dim=1)
             n2 =size(xval,dim=2)
             n3 =size(xval,dim=3)
             allocate(xsum(n1,n2,n3))
             call MPI_ALLREDUCE(xval,xsum,n1*n2*n3,MPI_INTEGER,&
             &  MPI_SUM,spaceComm,ier)
             xval (:,:,:) = xsum(:,:,:)
             deallocate(xsum)
            end if
           end if
#endif
end subroutine xsum_mpi_int3d
!!***

!!****f* ABINIT/xsum_mpi_int4d
!! NAME
!! xsum_mpi_int4d
!! 
!! SOURCE
subroutine xsum_mpi_int4d(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 integer,intent(inout) :: xval(:,:,:,:)
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables-------------------
 integer ::   n1,n2,n3,n4

#if defined MPI
           integer , allocatable :: xsum(:,:,:,:)
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
           !Accumulate xval on all proc. in spaceComm
           if (spaceComm /=  MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             n1 =size(xval,dim=1)
             n2 =size(xval,dim=2)
             n3 =size(xval,dim=3)
             n4 =size(xval,dim=4)
             allocate(xsum(n1,n2,n3,n4))
             call MPI_ALLREDUCE(xval,xsum,n1*n2*n3*n4,MPI_INTEGER,&
             &  MPI_SUM,spaceComm,ier)
             xval (:,:,:,:) = xsum(:,:,:,:)
             deallocate(xsum)
            end if
           end if
#endif
end subroutine xsum_mpi_int4d
!!***

!!****f* ABINIT/xsum_mpi_dp
!! NAME
!! xsum_mpi_dp
!! 
!! SOURCE
subroutine xsum_mpi_dp(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval(:)
 integer ,intent(in) :: spaceComm
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer ::   n1

#if defined MPI
           real(dp) , allocatable :: xsum(:)
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /=  MPI_COMM_SELF) then
           !Accumulate xval on all proc. in spaceComm
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             n1 = size(xval)
             allocate(xsum(n1))
             call MPI_ALLREDUCE(xval,xsum,n1,MPI_DOUBLE_PRECISION,&
             &  MPI_SUM,spaceComm,ier)
             xval (:) = xsum(:)
             deallocate(xsum)
            end if
           end if
#endif

end subroutine xsum_mpi_dp
!!***

!!****f* ABINIT/xsum_mpi_dpvt
!! NAME
!! xsum_mpi_dpvt
!! 
!! SOURCE
subroutine xsum_mpi_dpvt(xval,xsum,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(in) :: xval
 real(dp),intent(out) :: xsum
 integer ,intent(in) :: spaceComm
 integer ,intent(out)   :: ier

!Local variables-------------------
#if defined MPI
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
           !Accumulate xval on all proc. in spaceComm
           if (spaceComm /=  MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             call MPI_ALLREDUCE(xval,xsum,1,MPI_DOUBLE_PRECISION,&
             &  MPI_SUM,spaceComm,ier)
            end if
           end if
#else
 xsum=xval
#endif
end subroutine xsum_mpi_dpvt
!!***

!!****f* ABINIT/xsum_mpi_dpv
!! NAME
!! xsum_mpi_dpv
!! 
!! SOURCE
subroutine xsum_mpi_dpv(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval
 integer ,intent(in) :: spaceComm
 integer ,intent(out)   :: ier

!Local variables-------------------
#if defined MPI
           integer :: nproc_space_comm
           real(dp)  :: xsum
#endif
! *************************************************************************

 ier=0
#if defined MPI
           !Accumulate xval on all proc. in spaceComm
           if (spaceComm /=  MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             call MPI_ALLREDUCE(xval,xsum,1,MPI_DOUBLE_PRECISION,&
             &  MPI_SUM,spaceComm,ier)
             xval  = xsum
            end if
           end if
#endif
end subroutine xsum_mpi_dpv
!!***

!!****f* ABINIT/xsum_mpi_dpn
!! NAME
!! xsum_mpi_dpn
!! 
!! SOURCE
subroutine xsum_mpi_dpn(xval,n1,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval(:)
 integer ,intent(in)    :: n1
 integer ,intent(in) :: spaceComm
 integer ,intent(out)   :: ier

!Local variables-------------------
#if defined MPI
           integer :: nproc_space_comm
           real(dp) , allocatable :: xsum(:)
#endif
! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /=  MPI_COMM_SELF) then
            !Accumulate xval on all proc. in spaceComm
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             allocate(xsum(n1))
             call MPI_ALLREDUCE(xval,xsum,n1,MPI_DOUBLE_PRECISION,&
             &  MPI_SUM,spaceComm,ier)
             xval (:) = xsum(:)
             deallocate(xsum)
            end if
           end if
#endif
end subroutine xsum_mpi_dpn
!!***

!!****f* ABINIT/xsum_mpi_dp2d
!! NAME
!! xsum_mpi_dp2d
!! 
!! SOURCE
subroutine xsum_mpi_dp2d(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval(:,:)
 integer ,intent(in) :: spaceComm
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer :: n1,n2

#if defined MPI
           real(dp) , allocatable :: xsum(:,:)
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /=  MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             n1 = size(xval,dim=1)
             n2 = size(xval,dim=2)
             !Accumulate xval on all proc. in spaceComm
             allocate(xsum(n1,n2))
             call MPI_ALLREDUCE(xval,xsum,n1*n2,MPI_DOUBLE_PRECISION,&
             &  MPI_SUM,spaceComm,ier)
             xval (:,:) = xsum(:,:)
             deallocate(xsum)
            end if
           end if
#endif
end subroutine xsum_mpi_dp2d
!!***

!!****f* ABINIT/xsum_mpi_dp3d
!! NAME
!! xsum_mpi_dp3d
!! 
!! SOURCE
subroutine xsum_mpi_dp3d(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval(:,:,:)
 integer ,intent(in) :: spaceComm
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer :: n1,n2,n3

#if defined MPI
           real(dp) , allocatable :: xsum(:,:,:)
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /=  MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             n1 = size(xval,dim=1)
             n2 = size(xval,dim=2)
             n3 = size(xval,dim=3)
             !Accumulate xval on all proc. in spaceComm
             allocate(xsum(n1,n2,n3))
             call MPI_ALLREDUCE(xval,xsum,n1*n2*n3,MPI_DOUBLE_PRECISION,&
             &  MPI_SUM,spaceComm,ier)
             xval (:,:,:) = xsum(:,:,:)
             deallocate(xsum)
            end if
           end if
#endif
end subroutine xsum_mpi_dp3d
!!***

!!****f* ABINIT/xsum_mpi_dp4d
!! NAME
!! xsum_mpi_dp4d
!! 
!! SOURCE
subroutine xsum_mpi_dp4d(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval(:,:,:,:)
 integer ,intent(in) :: spaceComm
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer :: n1,n2,n3,n4

#if defined MPI
           real(dp) , allocatable :: xsum(:,:,:,:)
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /=  MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             n1 = size(xval,dim=1)
             n2 = size(xval,dim=2)
             n3 = size(xval,dim=3)
             n4 = size(xval,dim=4)
             !Accumulate xval on all proc. in spaceComm
             allocate(xsum(n1,n2,n3,n4))
             call MPI_ALLREDUCE(xval,xsum,n1*n2*n3*n4,MPI_DOUBLE_PRECISION,&
             &  MPI_SUM,spaceComm,ier)
             xval (:,:,:,:) = xsum(:,:,:,:)
             deallocate(xsum)
            end if
           end if
#endif
end subroutine xsum_mpi_dp4d
!!***

!!****f* ABINIT/xsum_mpi_dp5d
!! NAME
!! xsum_mpi_dp5d
!! 
!! SOURCE
subroutine xsum_mpi_dp5d(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval(:,:,:,:,:)
 integer ,intent(in) :: spaceComm
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer :: n1,n2,n3,n4,n5

#if defined MPI
           real(dp) , allocatable :: xsum(:,:,:,:,:)
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /=  MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             n1 = size(xval,dim=1)
             n2 = size(xval,dim=2)
             n3 = size(xval,dim=3)
             n4 = size(xval,dim=4)
             n5 = size(xval,dim=5)
             !Accumulate xval on all proc. in spaceComm
             allocate(xsum(n1,n2,n3,n4,n5))
             call MPI_ALLREDUCE(xval,xsum,n1*n2*n3*n4*n5,MPI_DOUBLE_PRECISION,&
             &  MPI_SUM,spaceComm,ier)
             xval (:,:,:,:,:) = xsum(:,:,:,:,:)
             deallocate(xsum)
            end if
           end if
#endif
end subroutine xsum_mpi_dp5d
!!***

!!****f* ABINIT/xsum_mpi_dp6d
!! NAME
!! xsum_mpi_dp6d
!! 
!! SOURCE
subroutine xsum_mpi_dp6d(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval(:,:,:,:,:,:)
 integer ,intent(in) :: spaceComm
 integer ,intent(out)   :: ier

!Local variables-------------------
 integer :: n1,n2,n3,n4,n5,n6

#if defined MPI
           real(dp) , allocatable :: xsum(:,:,:,:,:,:)
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /=  MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             n1 = size(xval,dim=1)
             n2 = size(xval,dim=2)
             n3 = size(xval,dim=3)
             n4 = size(xval,dim=4)
             n5 = size(xval,dim=5)
             n6 = size(xval,dim=6)
             !Accumulate xval on all proc. in spaceComm
             allocate(xsum(n1,n2,n3,n4,n5,n6))
             call MPI_ALLREDUCE(xval,xsum,n1*n2*n3*n4*n5*n6,MPI_DOUBLE_PRECISION,&
             &  MPI_SUM,spaceComm,ier)
             xval (:,:,:,:,:,:) = xsum(:,:,:,:,:,:)
             deallocate(xsum)
            end if
           end if
#endif
end subroutine xsum_mpi_dp6d
!!***

!!****f* ABINIT/xsum_mpi_dp2t
!! NAME
!! xsum_mpi_dp2t
!! 
!! SOURCE
subroutine xsum_mpi_dp2t(xval,xsum,n1,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval(:),xsum(:)
 integer ,intent(in)    :: n1
 integer ,intent(in) :: spaceComm
 integer ,intent(out)   :: ier

!Local variables-------------------

! *************************************************************************

 ier=0
#if defined MPI
            if (spaceComm /=  MPI_COMM_SELF) then
             !Accumulate xval on all proc. in spaceComm
             call MPI_ALLREDUCE(xval,xsum,n1,MPI_DOUBLE_PRECISION,&
             &  MPI_SUM,spaceComm,ier)
            end if
#else
 xsum=xval
#endif
end subroutine xsum_mpi_dp2t
!!***

!!****f* ABINIT/xsum_mpi_dp3d2t
!! NAME
!! xsum_mpi_dp3d2t
!! 
!! SOURCE
subroutine xsum_mpi_dp3d2t(xval,xsum,n1,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval(:,:,:),xsum(:,:,:)
 integer ,intent(in)    :: n1
 integer ,intent(in) :: spaceComm
 integer ,intent(out)   :: ier

!Local variables-------------------

! *************************************************************************
 ier=0
#if defined MPI
           if (spaceComm /=  MPI_COMM_SELF) then
            !Accumulate xval on all proc. in spaceComm
            call MPI_ALLREDUCE(xval,xsum,n1,MPI_DOUBLE_PRECISION,&
            &  MPI_SUM,spaceComm,ier)
           end if
#else
 xsum=xval
#endif
end subroutine xsum_mpi_dp3d2t
!!***

!!****f* ABINIT/xsum_mpi_dp4d2t
!! NAME
!! xsum_mpi_dp4d2t
!! 
!! SOURCE
subroutine xsum_mpi_dp4d2t(xval,xsum,n1,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 real(dp),intent(inout) :: xval(:,:,:,:),xsum(:,:,:,:)
 integer ,intent(in)    :: n1
 integer ,intent(in) :: spaceComm
 integer ,intent(out)   :: ier

!Local variables-------------------

! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /=  MPI_COMM_SELF) then
            !Accumulate xval on all proc. in spaceComm
            call MPI_ALLREDUCE(xval,xsum,n1,MPI_DOUBLE_PRECISION,&
            &  MPI_SUM,spaceComm,ier)
           end if
#else
 xsum=xval
#endif
end subroutine xsum_mpi_dp4d2t
!!***

!!****f* ABINIT/xsum_mpi_c1dc
!! NAME
!! xsum_mpi_c1dc
!! 
!! SOURCE
subroutine xsum_mpi_c1dc(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 complex(dpc),intent(inout) :: xval(:)
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables-------------------
 integer ::   n1

#if defined MPI
 complex(dpc) , allocatable :: xsum(:)
 integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
 if (spaceComm /= MPI_COMM_SELF) then
  call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
  if (nproc_space_comm /= 1) then
   !Accumulate xval on all proc. in spaceComm
   n1 =size(xval,dim=1)
   allocate(xsum(n1))
   call MPI_ALLREDUCE(xval,xsum,n1,MPI_DOUBLE_COMPLEX,MPI_SUM,spaceComm,ier)
   xval (:) = xsum(:)
   deallocate(xsum)
  end if
 end if
#endif

end subroutine xsum_mpi_c1dc
!!***

!!****f* ABINIT/xsum_mpi_c2dc
!! NAME
!! xsum_mpi_c2dc
!! 
!! SOURCE
subroutine xsum_mpi_c2dc(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 complex(dpc),intent(inout) :: xval(:,:)
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables-------------------
 integer ::   n1,n2

#if defined MPI
           complex(dpc) , allocatable :: xsum(:,:)
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /= MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             !Accumulate xval on all proc. in spaceComm
             n1 =size(xval,dim=1)
             n2 =size(xval,dim=2)
             allocate(xsum(n1,n2))
             call MPI_ALLREDUCE(xval,xsum,n1*n2,MPI_DOUBLE_COMPLEX,&
             &  MPI_SUM,spaceComm,ier)
             xval (:,:) = xsum(:,:)
             deallocate(xsum)
            end if
           end if
#endif
end subroutine xsum_mpi_c2dc
!!***

!!****f* ABINIT/xsum_mpi_c3dc
!! NAME
!! xsum_mpi_c3dc
!! 
!! SOURCE
subroutine xsum_mpi_c3dc(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 complex(dpc),intent(inout) :: xval(:,:,:)
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables-------------------
 integer ::   n1,n2,n3

#if defined MPI
           complex(dpc) , allocatable :: xsum(:,:,:)
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /= MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             !Accumulate xval on all proc. in spaceComm
             n1 =size(xval,dim=1)
             n2 =size(xval,dim=2)
             n3 =size(xval,dim=3)
             allocate(xsum(n1,n2,n3))
             call MPI_ALLREDUCE(xval,xsum,n1*n2*n3,MPI_DOUBLE_COMPLEX,&
             &  MPI_SUM,spaceComm,ier)
             xval (:,:,:) = xsum(:,:,:)
             deallocate(xsum)
            end if
           end if
#endif
end subroutine xsum_mpi_c3dc
!!***

!!****f* ABINIT/xsum_mpi_c4dc
!! NAME
!! xsum_mpi_c4dc
!! 
!! SOURCE
subroutine xsum_mpi_c4dc(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments-------------------------
 complex(dpc),intent(inout) :: xval(:,:,:,:)
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables-------------------
 integer :: n1,n2,n3,n4

#if defined MPI
 complex(dpc),allocatable :: xsum(:,:,:,:)
 integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
            if (spaceComm /= MPI_COMM_SELF) then
             call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
             if (nproc_space_comm /= 1) then
              !Accumulate xval on all proc. in spaceComm
              n1 =size(xval,dim=1)
              n2 =size(xval,dim=2)
              n3 =size(xval,dim=3)
              n4 =size(xval,dim=4)
              allocate(xsum(n1,n2,n3,n4))
              call MPI_ALLREDUCE(xval,xsum,n1*n2*n3*n4,MPI_DOUBLE_COMPLEX,MPI_SUM,spaceComm,ier)
              xval (:,:,:,:) = xsum(:,:,:,:)
              deallocate(xsum)
             end if
            end if
#endif

end subroutine xsum_mpi_c4dc
!!***

!!****f* ABINIT/xsum_mpi_c1cplx
!! NAME
!! xsum_mpi_c1cplx
!! 
!! SOURCE
subroutine xsum_mpi_c1cplx(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments----------------
 complex,intent(inout) :: xval(:)
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables--------------
#if defined MPI
           integer ::   n1
           complex, allocatable :: xsum(:)
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
                if (spaceComm /= MPI_COMM_SELF) then
                 call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
                 if (nproc_space_comm /= 1) then
          !Accumulate xval on all proc. in spaceComm
                   n1 =size(xval,dim=1)
                   allocate(xsum(n1))
                   call MPI_ALLREDUCE(xval,xsum,n1,MPI_COMPLEX,&
          &  MPI_SUM,spaceComm,ier)
                  xval (:) = xsum(:)
                  deallocate(xsum)
                 end if
                end if
#endif
end subroutine xsum_mpi_c1cplx
!!***

!!****f* ABINIT/xsum_mpi_c2cplx
!! NAME
!! xsum_mpi_c2cplx
!! 
!! SOURCE
subroutine xsum_mpi_c2cplx(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments----------------
 complex,intent(inout) :: xval(:,:)
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables--------------
#if defined MPI
           integer ::   n1,n2
           complex, allocatable :: xsum(:,:)
           integer :: nproc_space_comm
#endif
! *************************************************************************
 ier=0
#if defined MPI
           if (spaceComm /= MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
             !Accumulate xval on all proc. in spaceComm
              n1 =size(xval,dim=1)
              n2 =size(xval,dim=2)
              allocate(xsum(n1,n2))
              call MPI_ALLREDUCE(xval,xsum,n1*n2,MPI_COMPLEX,&
              &  MPI_SUM,spaceComm,ier)
              xval (:,:) = xsum(:,:)
              deallocate(xsum)
             end if
            end if
#endif
end subroutine xsum_mpi_c2cplx
!!***

!!****f* ABINIT/xsum_mpi_c3cplx
!! NAME
!! xsum_mpi_c3cplx
!! 
!! SOURCE
subroutine xsum_mpi_c3cplx(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments----------------
 complex,intent(inout) :: xval(:,:,:)
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables--------------
#if defined MPI
           integer ::   n1,n2,n3
           complex , allocatable :: xsum(:,:,:)
           integer :: nproc_space_comm
#endif
! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /= MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
            !Accumulate xval on all proc. in spaceComm
            n1 =size(xval,dim=1)
            n2 =size(xval,dim=2)
            n3 =size(xval,dim=3)
            allocate(xsum(n1,n2,n3))
            call MPI_ALLREDUCE(xval,xsum,n1*n2*n3,MPI_COMPLEX,&
            &  MPI_SUM,spaceComm,ier)
            xval (:,:,:) = xsum(:,:,:)
            deallocate(xsum)
           end if
          end if
#endif
end subroutine xsum_mpi_c3cplx
!!***

!!****f* ABINIT/xsum_mpi_c4cplx
!! NAME
!! xsum_mpi_c4cplx
!! 
!! SOURCE
subroutine xsum_mpi_c4cplx(xval,spaceComm,ier)

 use defs_basis

#if defined MPI && defined MPI2
 use mpi
#endif

 implicit none

#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments----------------
 complex,intent(inout) :: xval(:,:,:,:)
 integer,intent(in) :: spaceComm
 integer,intent(out)   :: ier

!Local variables--------------
#if defined MPI
           integer ::   n1,n2,n3,n4
           complex , allocatable :: xsum(:,:,:,:)
           integer :: nproc_space_comm
#endif

! *************************************************************************

 ier=0
#if defined MPI
           if (spaceComm /= MPI_COMM_SELF) then
            call MPI_COMM_SIZE(spaceComm,nproc_space_comm,ier)
            if (nproc_space_comm /= 1) then
            !Accumulate xval on all proc. in spaceComm
            n1 =size(xval,dim=1)
            n2 =size(xval,dim=2)
            n3 =size(xval,dim=3)
            n4 =size(xval,dim=4)
            allocate(xsum(n1,n2,n3,n4))
            call MPI_ALLREDUCE(xval,xsum,n1*n2*n3*n4,MPI_COMPLEX,&
            &  MPI_SUM,spaceComm,ier)
            xval (:,:,:,:) = xsum(:,:,:,:)
            deallocate(xsum)
           end if
          end if
#endif
end subroutine xsum_mpi_c4cplx

!!***
