/* abi_common.h */

/*
 * Copyright (c) 2008-2009 ABINIT Group (MG)
 * All rights reserved.
 *
 * This file is part of the ABINIT software package. For license information,
 * please see the COPYING file in the top-level directory of the ABINIT source
 * distribution.
 *
 */


/** 
 * Language standards requires the existance of pre-defined macros
 * TODO 
 * Microsoft Visual C++ does not define __STDC__, 
 * Sun Workshop 4.2 supports C94 without setting __STDC_VERSION__ to the proper value
**/

#if defined (__STDC__)
# define PREDEF_STANDARD_C_1989    /** ANSI X3.159-1989 **/
# if defined (__STDC_VERSION__)   
#  define PREDEF_STANDARD_C_1990   /** ISO/IEC 9899:1990 **/
#  if (__STDC_VERSION__ >= 199409L)
#   define PREDEF_STANDARD_C_1994  /** ISO/IEC 9899-1:1994 **/
#  endif
#  if (__STDC_VERSION__ >= 199901L)
#   define PREDEF_STANDARD_C_1999  /** ISO/IEC 9899:1999 **/
#  endif
# endif
#endif

/** 
 * TODO Ask Yann to add check for __STDC__ and friends in configure.ac
 */

#undef HAVE_LONG_LINES
#define HAVE_LONG_LINES 

/** define WHEREARG __FILE__,__LINE__**/
#if defined HAVE_LONG_LINES 
# define NEWLINE ;
#else
# define NEWLINE \newline
#endif 
/** define WHEREARG NEWLINE __FILE__, NEWLINE __LINE__ **/

/** this does not work with gfort, pgi, **/

#if defined (FC_GCC) || defined(FC_G95) || defined (FC_PGI) 
#define QUOTEME(x)     'x' 
#else
#define QUOTEME(x)     #x 
#endif

#define BYTE_SIZE(array)  PRODUCT(SHAPE(array)) * DBLE(KIND(array))

/** debugging macros so we can pin down message provenance at a glance
#define WHERESTR "[file %s, line %d] "
**/

/* 
 * ABI_ basic abinit macros.
 * DBG_ denote macros for debugging. Defined only if abinit is compiled in DEBUG_MODE.
 * MSG_ denote macros for logging.
 * MEM_ for memory profiling and checking.
 * */

#if defined HAVE_LONG_LINES 
#  define ABI_ASSERT(expr) call assert((expr), QUOTEME(expr),__FILE__,__LINE__)
#  define ABI_CHECK(expr,str) call assert((expr), str,__FILE__,__LINE__)
#  define ABI_DIE(msg)     call die(msg,__FILE__,__LINE__) 
#else
#  define ABI_ASSERT(expr) call assert((expr), QUOTEME(expr))
#  define ABI_CHECK(expr,str) call assert((expr), str)
#  define ABI_DIE(msg)     call die(msg) 
#endif

/* Macros for memory checking and profiling *
 * ERR_ALLOCATE_STAT is defined in the m_errors module.
 * Remember: subtract number of newlines in lineno otherwise the value might be misleading
#define HAVE_MEM_PROFILE 0
*/

#define MEM_ALLOCATE(array, size) \
 allocate(array, stat=ERR_ALLOCATE_STAT) NEWLINE \
 if (ERR_ALLOCATE_STAT /= 0) then        NEWLINE \
  call memerr( QUOTEME(array),size * dble(kind(array)), __FILE__,__LINE__) NEWLINE \
 end if

#define MEM_FREE(array) \
 deallocate(array, stat=ERR_ALLOCATE_STAT) NEWLINE \
 if (ERR_ALLOCATE_STAT /= 0) then        NEWLINE \
  ABI_DIE("deallocation error") \
 end if

/** 
* Variadic arguments are supported by several compilers, 
* however they have been standardized only in C99.
#define HAVE_VARMACROS
**/

#undef HAVE_VARMACROS

#if defined HAVE_VARMACROS  /**|| (__STDC_VERSION__ >= 199901L)**/

#define MEM_VARALLOCATE(...) allocate(__VA_ARGS__,stat=ERR_ALLOCATE_STAT) NEWLINE \
 if (ERR_ALLOCATE_STAT /= 0) then NEWLINE \
  ABI_DIE("allocation error") NEWLINE \
 end if

#define MEM_VARFREE(...) deallocate(__VA_ARGS__,stat=ERR_ALLOCATE_STAT) NEWLINE \
 if (ERR_ALLOCATE_STAT /= 0) then NEWLINE \
  ABI_DIE("allocation error") NEWLINE \
 end if

#else

#define MEM_VARALLOCATE allocate
#define MEM_VARFREE deallocate

#endif /** defined(HAVE_VARMACROS) || (__STDC_VERSION__ >= 199901L) **/


#if defined DEBUG_MODE 
#  if defined HAVE_LONG_LINES 
#    define DBG_ASSERT(expr) call assert((expr),QUOTEME(expr),__FILE__,__LINE__)
#    define DBG_CHKPT(value) write(std_out,*)__FILE__,":",__LINE__,":",value 
/*
* C99 __func__ doesn't work with Fortran code but we might use abilint to define a 
* CPP varible, ABI_func, containing the name of the F90 procedure.
#    define DBG_ENTER(mode) call sentinel(1,mode,ABI_func)
#    define DBG_EXIT(mode)  call sentinel(2,mode,ABI_func)
* For the moment we use __FILE__
*/
#    define DBG_ENTER(mode) call sentinel(1,mode,__FILE__)
#    define DBG_EXIT(mode)  call sentinel(2,mode,__FILE__)
#  else
#    define DBG_ASSERT(expr) call assert((expr), QUOTEME(expr)) 
#    define DBG_CHKPT(value) write(std_out,*)value
#    define DBG_ENTER(mode) call sentinel(1,mode)
#    define DBG_EXIT(mode)  call sentinel(2,mode)
#  endif
#else
#  define DBG_ASSERT(expr) 
#  define DBG_CHKPT(value)  
#  define DBG_ENTER(mode)
#  define DBG_EXIT(mode)
#endif

/* Macro for basic messages (COLLECTIVE and PERSONAL version) */
#if defined HAVE_LONG_LINES

#  define MSG_COMMENT(msg)      call msg_hndl(msg,"COMMENT","COLL",__FILE__,__LINE__) 
#  define MSG_WARNING(msg)      call msg_hndl(msg,"WARNING","COLL",__FILE__,__LINE__)
#  define MSG_ERROR(msg)        call msg_hndl(msg,"ERROR"  ,"COLL",__FILE__,__LINE__) 
#  define MSG_BUG(msg)          call msg_hndl(msg,"BUG"    ,"COLL",__FILE__,__LINE__) 
#  define MSG_PERS_COMMENT(msg) call msg_hndl(msg,"COMMENT","PERS",__FILE__,__LINE__) 
#  define MSG_PERS_WARNING(msg) call msg_hndl(msg,"WARNING","PERS",__FILE__,__LINE__)
#  define MSG_PERS_ERROR(msg)   call msg_hndl(msg,"ERROR"  ,"PERS",__FILE__,__LINE__) 
#  define MSG_PERS_BUG(msg)     call msg_hndl(msg,"BUG"    ,"PERS",__FILE__,__LINE__) 

#else
/* 
 * Safe macros for emergency cases! 
 * Useful if __FILE__ expands to the full path name exceeding
 * the max number of Fortran columns. ISO doesn't define any standard!
 */ 
#  define MSG_COMMENT(msg)      call msg_hndl(msg,"COMMENT","COLL") 
#  define MSG_WARNING(msg)      call msg_hndl(msg,"WARNING","COLL")
#  define MSG_ERROR(msg)        call msg_hndl(msg,"ERROR"  ,"COLL") 
#  define MSG_BUG(msg)          call msg_hndl(msg,"BUG"    ,"COLL") 
#  define MSG_PERS_COMMENT(msg) call msg_hndl(msg,"COMMENT","PERS") 
#  define MSG_PERS_WARNING(msg) call msg_hndl(msg,"WARNING","PERS")
#  define MSG_PERS_ERROR(msg)   call msg_hndl(msg,"ERROR"  ,"PERS") 
#  define MSG_PERS_BUG(msg)     call msg_hndl(msg,"BUG"    ,"PERS") 

#endif
