!!****m* ABINIT/interfaces_51_manage_mpi
!! NAME
!! interfaces_51_manage_mpi
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/51_manage_mpi
!!
!! COPYRIGHT
!! Copyright (C) 2009 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: config/scripts/abilint . .
!! 
!!
!! SOURCE

module interfaces_51_manage_mpi

 implicit none

interface
 subroutine clnmpi_band(nkpt,nsppol,mpi_enreg)
  use defs_abitypes
  implicit none
  integer,intent(in) :: nkpt
  integer,intent(in) :: nsppol
  type(mpi_type), intent(inout) :: mpi_enreg
 end subroutine clnmpi_band
end interface

interface
 subroutine clnmpi_fft(dtset, mpi_enreg)
  use defs_abitypes
  implicit none
  type(dataset_type), intent(in) :: dtset
  type(mpi_type), intent(inout) :: mpi_enreg
 end subroutine clnmpi_fft
end interface

interface
 subroutine clnmpi_gs(dtset, mpi_enreg)
  use defs_abitypes
  implicit none
  type(dataset_type) :: dtset
  type(mpi_type) :: mpi_enreg
 end subroutine clnmpi_gs
end interface

interface
 subroutine distrb2(mband, nband, nkpt, nsppol, mpi_enreg)
  use defs_abitypes
  implicit none
  integer,intent(in) :: mband
  integer,intent(in) :: nkpt
  integer,intent(in) :: nsppol
  type(mpi_type),intent(inout) :: mpi_enreg
  integer,intent(in) :: nband(nkpt*nsppol)
 end subroutine distrb2
end interface

interface
 subroutine herald(code_name,code_version,iout)
  implicit none
  integer,intent(in) :: iout
  character(len=24),intent(in) :: code_name
  character(len=6),intent(in) :: code_version
 end subroutine herald
end interface

interface
 subroutine initmpi_band(mpi_enreg,nband,nkpt,nsppol)
  use defs_abitypes
  implicit none
  integer,intent(in) :: nkpt
  integer,intent(in) :: nsppol
  type(mpi_type),intent(inout) :: mpi_enreg
  integer,intent(in) :: nband(nkpt*nsppol)
 end subroutine initmpi_band
end interface

interface
 subroutine initmpi_fft(dtset,mpi_enreg)
  use defs_abitypes
  implicit none
  type(dataset_type),intent(in) :: dtset
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine initmpi_fft
end interface

interface
 subroutine initmpi_grid(dtset,mpi_enreg)
  use defs_abitypes
  implicit none
  type(dataset_type),intent(in) :: dtset
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine initmpi_grid
end interface

interface
 subroutine initmpi_gs(dtset,mpi_enreg)
  use defs_abitypes
  implicit none
  type(dataset_type),intent(in) :: dtset
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine initmpi_gs
end interface

interface
 subroutine initmpi_respfn(mpi_enreg, spaceComm)
  use defs_abitypes
  implicit none
  integer :: spaceComm
  type(mpi_type) :: mpi_enreg
 end subroutine initmpi_respfn
end interface

interface
 subroutine initmpi_seq(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type),intent(out) :: mpi_enreg
 end subroutine initmpi_seq
end interface

interface
 subroutine leave_test(mpi_enreg)
  use defs_abitypes
  implicit none
  type(mpi_type) :: mpi_enreg
 end subroutine leave_test
end interface

interface
 subroutine pre_scatter(array,array_allgather,n1,n2,n3,mpi_enreg,option)
  use defs_basis
  use defs_abitypes
  implicit none
  integer :: n1
  integer :: n2
  integer :: n3
  type(mpi_type) :: mpi_enreg
  character(*) :: option
  real(dp) :: array(n1,n2,n3/mpi_enreg%nproc_fft,1)
  real(dp) :: array_allgather(n1,n2,n3,1)
 end subroutine pre_scatter
end interface

interface
 SUBROUTINE build_grid_scalapack(grid,nbprocs, communicator)
  use defs_scalapack
  implicit none
  integer, intent(in) :: communicator
  integer,intent(in) :: nbprocs
  type(grid_scalapack),intent(out) :: grid
 end subroutine build_grid_scalapack
end interface

interface
 SUBROUTINE build_processor_scalapack(processor,grid,myproc, comm)
  use defs_scalapack
  implicit none
  integer,intent(in) :: comm
  integer,intent(in) :: myproc
  type(grid_scalapack),intent(in) :: grid
  type(processor_scalapack),intent(out) :: processor
 end subroutine build_processor_scalapack
end interface

interface
 SUBROUTINE init_scalapack(processor,communicator)
  use defs_scalapack
  implicit none
  integer, intent(in) :: communicator
  type(processor_scalapack),intent(out) :: processor
 end subroutine init_scalapack
end interface

interface
 SUBROUTINE end_scalapack(processor)
  use defs_scalapack
  implicit none
  type(processor_scalapack),intent(inout) :: processor
 end subroutine end_scalapack
end interface

interface
 SUBROUTINE init_matrix_scalapack(matrix,nbli_global,&  
  &  nbco_global,processor,istwf_k,tbloc)
  use defs_scalapack
  implicit none
  integer,intent(in) :: istwf_k
  integer,intent(in) :: nbco_global
  integer,intent(in) :: nbli_global
  integer,intent(in),optional :: tbloc
  type(matrix_scalapack),intent(out) :: matrix
  type(processor_scalapack),intent(in),target :: processor
 end subroutine init_matrix_scalapack
end interface

interface
 SUBROUTINE destruction_matrix_scalapack(matrix)
  use defs_scalapack
  implicit none
  type(matrix_scalapack),intent(inout) :: matrix
 end subroutine destruction_matrix_scalapack
end interface

interface
 FUNCTION matrix_get_local_cplx(matrix,i,j)
  use defs_basis
  use defs_scalapack
  implicit none
  integer, intent(in) :: i
  integer, intent(in) :: j
  type(matrix_scalapack),intent(in) :: matrix
  complex(dp) :: matrix_get_local_cplx
 end function matrix_get_local_cplx
end interface

interface
 FUNCTION matrix_get_local_real(matrix,i,j)
  use defs_basis
  use defs_scalapack
  implicit none
  integer, intent(in) :: i
  integer, intent(in) :: j
  type(matrix_scalapack),intent(in) :: matrix
  real(dp) :: matrix_get_local_real
 end function matrix_get_local_real
end interface

interface
 SUBROUTINE matrix_set_local_cplx(matrix,i,j,value)
  use defs_basis
  use defs_scalapack
  implicit none
  integer, intent(in) :: i
  integer, intent(in) :: j
  type(matrix_scalapack),intent(out) :: matrix
  complex(dp) :: value
 end subroutine matrix_set_local_cplx
end interface

interface
 SUBROUTINE matrix_set_local_real(matrix,i,j,value)
  use defs_basis
  use defs_scalapack
  implicit none
  integer, intent(in) :: i
  integer, intent(in) :: j
  type(matrix_scalapack),intent(out) :: matrix
  real(dp) :: value
 end subroutine matrix_set_local_real
end interface

interface
 SUBROUTINE idx_loc(matrix,i,j,iloc,jloc)
  use defs_scalapack
  implicit none
  integer, intent(in) :: i
  integer, intent(out) :: iloc
  integer, intent(in) :: j
  integer, intent(out) :: jloc
  type(matrix_scalapack),intent(in) :: matrix
 end subroutine idx_loc
end interface

interface
 FUNCTION glob_loc(matrix,idx,lico)
  use defs_scalapack
  implicit none
  integer :: glob_loc
  integer, intent(in) :: idx
  integer, intent(in) :: lico
  type(matrix_scalapack),intent(in) :: matrix
 end function glob_loc
end interface

interface
 SUBROUTINE idx_glob(matrix,iloc,jloc,i,j)
  use defs_scalapack
  implicit none
  integer, intent(out) :: i
  integer, intent(in) :: iloc
  integer, intent(out) :: j
  integer, intent(in) :: jloc
  type(matrix_scalapack),intent(in) :: matrix
 end subroutine idx_glob
end interface

interface
 FUNCTION loc_glob(matrix,proc,idx,lico)
  use defs_scalapack
  implicit none
  integer, intent(in) :: idx
  integer, intent(in) :: lico
  integer :: loc_glob
  type(matrix_scalapack),intent(in) :: matrix
  type(processor_scalapack),intent(in) :: proc
 end function loc_glob
end interface

interface
 SUBROUTINE matrix_from_global(matrix,reference,istwf_k)
  use defs_basis
  use defs_scalapack
  implicit none
  integer,intent(in) :: istwf_k
  type(matrix_scalapack),intent(inout) :: matrix
  real(dp),dimension(:) :: reference
 end subroutine matrix_from_global
end interface

interface
 SUBROUTINE matrix_to_global(matrix,reference,istwf_k)
  use defs_basis
  use defs_scalapack
  implicit none
  integer,intent(in) :: istwf_k
  type(matrix_scalapack),intent(in) :: matrix
  real(dp),dimension(:),intent(inout) :: reference
 end subroutine matrix_to_global
end interface

interface
 SUBROUTINE matrix_to_reference(matrix,reference,istwf_k)
  use defs_basis
  use defs_scalapack
  implicit none
  integer,intent(in) :: istwf_k
  type(matrix_scalapack),intent(in) :: matrix
  real(dp),dimension(:,:),intent(inout) :: reference
 end subroutine matrix_to_reference
end interface

interface
 SUBROUTINE matrix_pzgemm(matrix1,alpha,matrix2,beta,results)
  use defs_basis
  use defs_scalapack
  implicit none
  complex(dp), intent(in) :: alpha
  complex(dp), intent(in) :: beta
  type(matrix_scalapack),intent(in) :: matrix1
  type(matrix_scalapack),intent(in) :: matrix2
  type(matrix_scalapack),intent(inout) :: results
 end subroutine matrix_pzgemm
end interface

interface
 SUBROUTINE compute_eigen_values_vectors(processor,matrix,results,eigen,communicator,istwf_k)
  use defs_scalapack
  implicit none
  integer,intent(in) :: communicator
  integer,intent(in) :: istwf_k
  type(matrix_scalapack),intent(in) :: matrix
  type(processor_scalapack),intent(in) :: processor
  type(matrix_scalapack),intent(inout) :: results
  double precision,dimension(:),intent(inout) :: eigen
 end subroutine compute_eigen_values_vectors
end interface

interface
 SUBROUTINE compute_eigen_problem(processor,matrix1,matrix2,results,eigen,communicator,istwf_k)
  use defs_scalapack
  implicit none
  integer,intent(in) :: communicator
  integer,intent(in) :: istwf_k
  type(matrix_scalapack),intent(in) :: matrix1
  type(matrix_scalapack),intent(in) :: matrix2
  type(processor_scalapack),intent(in) :: processor
  type(matrix_scalapack),intent(inout) :: results
  double precision,dimension(:),intent(inout) :: eigen
 end subroutine compute_eigen_problem
end interface

interface
 SUBROUTINE NO_SCALAPACK
  implicit none
 end subroutine NO_SCALAPACK
end interface

interface
 subroutine split_work(ntasks,istart,istop,verbose)
  implicit none
  integer,intent(inout) :: istart
  integer,intent(inout) :: istop
  integer,intent(in) :: ntasks
  integer,optional,intent(in) :: verbose
 end subroutine split_work
end interface

interface
 subroutine split_work2(ntasks,nprocs,istart,istop,verbose)
  implicit none
  integer,intent(in) :: nprocs
  integer,intent(in) :: ntasks
  integer,optional,intent(in) :: verbose
  integer,intent(inout) :: istart(nprocs)
  integer,intent(inout) :: istop(nprocs)
 end subroutine split_work2
end interface

interface
 subroutine xcomm_world(mpi_enreg,spaceComm)
  use defs_abitypes
  implicit none
  integer,intent(out) :: spaceComm
  type(mpi_type) :: mpi_enreg
 end subroutine xcomm_world
end interface

interface
 subroutine xcomm_init(mpi_enreg,spaceComm)
  use defs_abitypes
  implicit none
  integer,intent(out) :: spaceComm
  type(mpi_type),intent(in) :: mpi_enreg
 end subroutine xcomm_init
end interface

interface
 subroutine xmaster_init(mpi_enreg,master)
  use defs_abitypes
  implicit none
  integer,intent(out) :: master
  type(mpi_type),intent(in) :: mpi_enreg
 end subroutine xmaster_init
end interface

interface
 subroutine xmaster_init_fft(mpi_enreg,master)
  use defs_abitypes
  implicit none
  integer,intent(out) :: master
  type(mpi_type),intent(in) :: mpi_enreg
 end subroutine xmaster_init_fft
end interface

interface
 subroutine xme_init(mpi_enreg,me)
  use defs_abitypes
  implicit none
  integer,intent(out) :: me
  type(mpi_type),intent(in) :: mpi_enreg
 end subroutine xme_init
end interface

interface
 subroutine xproc_init(mpi_enreg,nproc_max)
  use defs_abitypes
  implicit none
  integer,intent(out) :: nproc_max
  type(mpi_type),intent(in) :: mpi_enreg
 end subroutine xproc_init
end interface

interface
 subroutine xdefineOff(formeig,wff,mpi_enreg,nband,npwarr,nspinor,nsppol,nkpt)
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer, intent(in) :: formeig
  integer, intent(in) :: nkpt
  integer, intent(in) :: nspinor
  integer, intent(in) :: nsppol
  type(mpi_type),intent(in) :: mpi_enreg
  type(wffile_type),intent(inout) :: wff
  integer, intent(in) :: nband(nkpt*nsppol)
  integer, intent(in) :: npwarr(nkpt)
 end subroutine xdefineOff
end interface

interface
 subroutine xderiveWRecEnd(wff,ierr)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  type(wffile_type),intent(inout) :: wff
 end subroutine xderiveWRecEnd
end interface

interface
 subroutine xderiveWRecEnd_cs(wff,ierr,me)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: me
  type(wffile_type),intent(inout) :: wff
 end subroutine xderiveWRecEnd_cs
end interface

interface
 subroutine xderiveWRecInit(wff,ierr)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  type(wffile_type),intent(inout) :: wff
 end subroutine xderiveWRecInit
end interface

interface
 subroutine xderiveWRecInit_cs(wff,ierr,me)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: me
  type(wffile_type),intent(inout) :: wff
 end subroutine xderiveWRecInit_cs
end interface

interface
 subroutine xderiveRRecEnd(wff,ierr)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  type(wffile_type),intent(inout) :: wff
 end subroutine xderiveRRecEnd
end interface

interface
 subroutine xderiveRRecInit(wff,ierr)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  type(wffile_type),intent(inout) :: wff
 end subroutine xderiveRRecInit
end interface


!Generic interface of the routines xderiveread
interface xderiveread
 subroutine xderiveRead_int(wff,xval,n1,ierr)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  type(wffile_type),intent(inout) :: wff
  integer,intent(out) :: xval(:)
 end subroutine xderiveRead_int
 subroutine xderiveRead_int_mpio(wff,xval,n1,ierr,spaceComm)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(out) :: xval(:)
 end subroutine xderiveRead_int_mpio
 subroutine xderiveRead_int2d(wff,xval,n1,n2,ierr)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  type(wffile_type),intent(inout) :: wff
  integer,intent(out) :: xval(:,:)
 end subroutine xderiveRead_int2d
 subroutine xderiveRead_int2d_mpio(wff,xval,n1,n2,ierr,spaceComm)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(out) :: xval(:,:)
 end subroutine xderiveRead_int2d_mpio
 subroutine xderiveRead_dp(wff,xval,n1,ierr)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(out) :: xval(:)
 end subroutine xderiveRead_dp
 subroutine xderiveRead_dp_mpio(wff,xval,n1,ierr,spaceComm)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(out) :: xval(:)
 end subroutine xderiveRead_dp_mpio
 subroutine xderiveRead_dp2d(wff,xval,n1,n2,ierr)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(out) :: xval(:,:)
 end subroutine xderiveRead_dp2d
 subroutine xderiveRead_dp2d_mpio(wff,xval,n1,n2,ierr,spaceComm)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(out) :: xval(:,:)
 end subroutine xderiveRead_dp2d_mpio
 subroutine xderiveRead_int2d_mpio_displ(wff,xval,n1,n2,ierr,spaceComm,displace)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: displace(:)
  integer,intent(out) :: xval(:,:)
 end subroutine xderiveRead_int2d_mpio_displ
 subroutine xderiveRead_dp2d_mpio_displ(wff,xval,n1,n2,ierr,spaceComm,displace)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: displace(:)
  real(dp),intent(out) :: xval(:,:)
 end subroutine xderiveRead_dp2d_mpio_displ
end interface
!End of the generic interface of xderiveread


!Generic interface of the routines xderivereadval
interface xderivereadval
 subroutine xderiveReadVal_dp(wff,xval)
  use defs_basis
  use defs_datatypes
  implicit none
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(out) :: xval
 end subroutine xderiveReadVal_dp
 subroutine xderiveReadVal_int(wff,xval)
  use defs_datatypes
  implicit none
  integer,intent(out) :: xval
  type(wffile_type),intent(inout) :: wff
 end subroutine xderiveReadVal_int
 subroutine xderiveReadVal_char(wff,xval,n)
  use defs_datatypes
  implicit none
  integer,intent(in) :: n
  type(wffile_type),intent(inout) :: wff
  character(len=*),intent(out) :: xval
 end subroutine xderiveReadVal_char
end interface
!End of the generic interface of xderivereadval


!Generic interface of the routines xderivewrite
interface xderivewrite
 subroutine xderiveWrite_int(wff,xval,n1,ierr)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: xval(:)
 end subroutine xderiveWrite_int
 subroutine xderiveWrite_int_mpio(wff,xval,n1,ierr,spaceComm)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: xval(:)
 end subroutine xderiveWrite_int_mpio
 subroutine xderiveWrite_int2d(wff,xval,n1,n2,ierr)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: xval(:,:)
 end subroutine xderiveWrite_int2d
 subroutine xderiveWrite_int2d_mpio(wff,xval,n1,n2,ierr,spaceComm)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: xval(:,:)
 end subroutine xderiveWrite_int2d_mpio
 subroutine xderiveWrite_int2d_mpio_arr(wff,xval,n1,n2,ierr,local_offset)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: local_offset(:)
  integer,intent(in) :: xval(:,:)
 end subroutine xderiveWrite_int2d_mpio_arr
 subroutine xderiveWrite_dp(wff,xval,n1,ierr)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(in) :: xval(:)
 end subroutine xderiveWrite_dp
 subroutine xderiveWrite_dp_mpio(wff,xval,n1,ierr,spaceComm)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(in) :: xval(:)
 end subroutine xderiveWrite_dp_mpio
 subroutine xderiveWrite_dp2d_mpio_arr(wff,xval,n1,n2,ierr,local_offset)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: local_offset(:)
  real(dp),intent(in) :: xval(:,:)
 end subroutine xderiveWrite_dp2d_mpio_arr
 subroutine xderiveWrite_dp2d(wff,xval,n1,n2,ierr)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(in) :: xval(:,:)
 end subroutine xderiveWrite_dp2d
 subroutine xderiveWrite_dp2d_mpio(wff,xval,n1,n2,ierr,spaceComm)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(in) :: xval(:,:)
 end subroutine xderiveWrite_dp2d_mpio
 subroutine xderiveWrite_int2d_mpio_displ(wff,xval,n1,n2,ierr,spaceComm,displace)
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: displace(:)
  integer,intent(in) :: xval(:,:)
 end subroutine xderiveWrite_int2d_mpio_displ
 subroutine xderiveWrite_dp2d_mpio_displ(wff,xval,n1,n2,ierr,spaceComm,displace)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(out) :: ierr
  integer,intent(in) :: n1
  integer,intent(in) :: n2
  integer,intent(in) :: spaceComm
  type(wffile_type),intent(inout) :: wff
  integer,intent(in) :: displace(:)
  real(dp),intent(in) :: xval(:,:)
 end subroutine xderiveWrite_dp2d_mpio_displ
end interface
!End of the generic interface of xderivewrite


!Generic interface of the routines xderivewriteval
interface xderivewriteval
 subroutine xderiveWriteVal_dp(wff,xval)
  use defs_basis
  use defs_datatypes
  implicit none
  type(wffile_type),intent(inout) :: wff
  real(dp),intent(in) :: xval
 end subroutine xderiveWriteVal_dp
 subroutine xderiveWriteVal_int(wff,xval)
  use defs_datatypes
  implicit none
  integer,intent(in) :: xval
  type(wffile_type),intent(inout) :: wff
 end subroutine xderiveWriteVal_int
 subroutine xderiveWriteVal_char(wff,xval,n)
  use defs_datatypes
  implicit none
  integer,intent(in) :: n
  type(wffile_type),intent(inout) :: wff
  character(len=*),intent(in) :: xval
 end subroutine xderiveWriteVal_char
end interface
!End of the generic interface of xderivewriteval

end module interfaces_51_manage_mpi
!!***
