!{\src2tex{textfont=tt}}
!!****f* ABINIT/getmpw
!!
!! NAME
!! getmpw
!!
!! FUNCTION
!! From input ecut, combined with ucvol and gmet, compute recommended mpw
!! mpw is the maximum number of plane-waves in the wave-function basis
!!  for one processor of the WF group
!!
!! COPYRIGHT
!! Copyright (C) 1998-2009 ABINIT group (DCA, XG, GMR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! ecut=plane-wave cutoff energy in Hartrees
!! exchn2n3d=if 1, n2 and n3 are exchanged
!! gmet(3,3)=reciprocal space metric (bohr**-2).
!! istwfk(nkpt)=input option parameter that describes the storage of wfs
!! kptns(3,nkpt)=real(dp) array for k points (normalisation is already
!!  taken into account)
!! mpi_enreg=informations about MPI parallelization
!! nkpt=integer number of k points in the calculation
!! ucvol=unit cell volume (bohr**3).
!!
!! OUTPUT
!! mpw=maximal number of plane waves over all k points of the processor
!!  (for one processor of the WF group)
!!
!! PARENTS
!!      invars2m,loper3,newsp,scfcv,suscep
!!
!! CHILDREN
!!      kpgsph,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine getmpw(ecut,exchn2n3d,gmet,istwfk,kptns,mpi_enreg,mpw,nkpt,ucvol)

 use defs_basis
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_56_recipspace, except_this_one => getmpw
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: exchn2n3d,nkpt
 integer,intent(out) :: mpw
 real(dp),intent(in) :: ecut,ucvol
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 integer,intent(in) :: istwfk(nkpt)
 real(dp),intent(in) :: gmet(3,3),kptns(3,nkpt)

!Local variables-------------------------------
!scalars
 integer :: ikpt,istwf_k,npw,npwwrk,pad=50
 real(dp) :: scale=1.3_dp
 character(len=500) :: message
!arrays
 integer,allocatable :: kg(:,:)
 real(dp) :: kpoint(3)

! *************************************************************************

!An upper bound for mpw, might be obtained as follows
!the average number of plane-waves in the cutoff sphere is
!npwave = (2*ecut)**(3/2) * ucvol / (6*pi**2)
!the upper bound is calculated as
!npwwrk = int(scale * npwave) + pad
!rescale so an upper bound
!npwave=nint(ucvol*(2.0_dp*ecut)**1.5_dp/(6.0_dp*pi**2))
!npwwrk=nint(dble(npwave)*scale)+pad

 allocate(kg(3,100))

!set mpw to zero, as needed for only counting in kpgsph
 mpw = 0

!DEBUG
!write(6,*)' getmpw : before kpgsph '
!write(6,*)' ecut, npwwrk=',ecut,npwwrk
!write(6,*)' gmet',gmet
!if(.true.)stop
!ENDDEBUG

!Might be parallelized over k points ? !
 do ikpt = 1,nkpt
! Do computation of G sphere, returning npw
  kpoint(:)=kptns(:,ikpt)
  istwf_k=istwfk(ikpt)
  call kpgsph(ecut,exchn2n3d,gmet,0,ikpt,istwf_k,kg,kpoint,0,mpi_enreg,0,npw)
! DEBUG
! write(6, '(i3,3es16.6,a,i6,a)' )&
! &  istwf_k,kpoint(:),' =>',npw,' plane waves.'
! ENDDEBUG
  mpw = max(npw,mpw)
 end do

 write(message,'(a,i8)') ' getmpw: optimal value of mpw=',mpw
 call wrtout(06,message,'COLL')

 deallocate(kg)

end subroutine getmpw
!!***
