!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawxc3
!! NAME
!! pawxc3
!!
!! FUNCTION
!! PAW only
!! Compute first-order change of XC potential and contribution to
!! 2nd-order change of XC energy inside a PAW sphere.
!! LDA ONLY - USE THE DENSITY OVER A WHOLE SPHERICAL GRID (r,theta,phi)
!!
!! COPYRIGHT
!! Copyright (C) 2009-2009 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!! This routine has been written from rhohxc
!!
!! INPUTS
!!  corexc1(cplex*pawrad%mesh_size)=first-order change of core density on radial grid
!!  cplex= if 1, real space 1-order functions on FFT grid are REAL, if 2, COMPLEX
!!  kxc(pawrad%mesh_size,pawang%angl_size,nkxc)=GS xc kernel
!!  lm_size=size of density array rhor (see below)
!!  lmselect(lm_size)=select the non-zero LM-moments of input density rhor1
!!  nhat1(cplex*pawrad%mesh_size,lm_size,nspden)=first-order change of compensation density
!!                                        (total in 1st half and spin-up in 2nd half if nspden=2)
!!  nkxc=second dimension of the kxc array
!!  nspden=number of spin-density components
!!  option=0  compute both 2nd-order XC energy and 1st-order potential
!!         1  compute only 1st-order XC potential
!!         2  compute only 2nd-order XC energy
!!  pawang <type(pawang_type)>=paw angular mesh and related data
!!  pawrad <type(pawrad_type)>=paw radial mesh and related data
!!  rhor1(cplex*pawrad%mesh_size,lm_size,nspden)=first-order change of density
!!  usecore= 1 if core density has to be used in Exc/Vxc ; 0 otherwise
!!  usexcnhat= 0 if compensation density does not have to be used
!!             1 if compensation density has to be used in d2Exc only
!!             2 if compensation density (nhat) has to be used in d2Exc and Vxc1
!!  xclevel= XC functional level
!!
!! OUTPUT
!!  == if option=0 or 2 ==
!!    d2enxc=returned exchange-cor. contribution to 2nd-order XC energy
!!  == if option=0 or 1 ==
!!    vxc1(cplex*pawrad%mesh_size,pawang%angl_size,nspden)=1st-order XC potential
!!
!! PARENTS
!!      pawdenpot
!!
!! CHILDREN
!!      leave_new,simp_gen,timab,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pawxc3(corexc1,cplex,d2enxc,kxc,lm_size,lmselect,nhat1,nkxc,nspden,option,&
&                 pawang,pawrad,rhor1,usecore,usexcnhat,vxc1,xclevel)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_18_timing
 use interfaces_32_util
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: cplex,lm_size,nkxc,nspden,option,usecore,usexcnhat,xclevel
 real(dp),intent(out) :: d2enxc
 type(pawang_type),intent(in) :: pawang
 type(pawrad_type),intent(in) :: pawrad
!arrays
 logical,intent(in) :: lmselect(lm_size)
 real(dp),intent(in) :: corexc1(cplex*pawrad%mesh_size)
 real(dp),intent(in) :: kxc(pawrad%mesh_size,pawang%angl_size,nkxc)
 real(dp),intent(in) :: nhat1(cplex*pawrad%mesh_size,lm_size,nspden)
 real(dp),intent(in) :: rhor1(cplex*pawrad%mesh_size,lm_size,nspden)
 real(dp),intent(out) :: vxc1(cplex*pawrad%mesh_size,pawang%angl_size,nspden)

!Local variables-------------------------------
!scalars
 integer :: ilm,ipts,ir,ispden,jr,npts,nrad
 real(dp) :: rho_dn,rhoim_dn,ro11i,ro11r,ro12i,ro12r,ro21i,ro21r,ro22i,ro22r
 real(dp) :: v11i,v11r,v12i,v12r,v21i,v21r,v22i,v22r,vxcrho
 character(len=500) :: message
!arrays
 real(dp) :: tsec(2)
 real(dp),allocatable :: ff(:),rhoarr(:,:)

! *************************************************************************

 call timab(81,1,tsec)

!----------------------------------------------------------------------
!----- Check options
!----------------------------------------------------------------------

 if(xclevel==2) then
  write(message, '(4a)' ) ch10,&
&  ' pawxc3 : ERROR -',ch10,&
&  '  GGA is not implemented !'
  call wrtout(06,message,'COLL')
  call leave_new('COLL')
 end if
 if(nkxc/=3) then
  write(message, '(4a)' ) ch10,&
&  ' pawxc3 : ERROR -',ch10,&
&  '  nkxc must be 3 !'
  call wrtout(06,message,'COLL')
  call leave_new('COLL')
 end if
 if(nspden==4) then
  write(message, '(4a)' ) ch10,&
&  ' pawxc3 : ERROR -',ch10,&
&  '  nspden=4 not implemented !'
  call wrtout(06,message,'COLL')
  call leave_new('COLL')
 end if

!----------------------------------------------------------------------
!----- Initializations
!----------------------------------------------------------------------

 nrad=pawrad%mesh_size
 npts=pawang%angl_size
 if (option==0.or.option==2) d2enxc=zero
 if (option==0.or.option==1) vxc1(:,:,:)=zero
 allocate(rhoarr(cplex*nrad,nspden))

!----------------------------------------------------------------------
!----- Loop on the angular part and inits
!----------------------------------------------------------------------

!Do loop on the angular part (theta,phi)
 do ipts=1,npts

! Copy the input density for this (theta,phi)
  rhoarr(:,:)=zero
  if (usexcnhat==0.or.usexcnhat==1) then
   do ispden=1,nspden
    do ilm=1,lm_size
     if (lmselect(ilm)) rhoarr(:,ispden)=rhoarr(:,ispden) &
&     +rhor1(:,ilm,ispden)*pawang%ylmr(ilm,ipts)
    end do
   end do
  else
   do ispden=1,nspden
    do ilm=1,lm_size
     if (lmselect(ilm)) rhoarr(:,ispden)=rhoarr(:,ispden) &
&     +(rhor1(:,ilm,ispden)+nhat1(:,ilm,ispden))*pawang%ylmr(ilm,ipts)
    end do
   end do
  end if

  if (usecore==1) then
   rhoarr(:,1)=rhoarr(:,1)+corexc1(:)
   if (nspden==2) rhoarr(:,2)=rhoarr(:,2)+half*corexc1(:)
  end if

! 
! ----------------------------------------------------------------------
! ----- Accumulate and store 1st-order change of XC potential
! ----------------------------------------------------------------------
  if (option==0.or.option==1) then

!  Non-spin-polarized
   if(nspden==1)then
    if(cplex==1)then
     vxc1(1:nrad,ipts,1)=kxc(1:nrad,ipts,1)*rhoarr(1:nrad,1)
    else
     do ir=1,nrad
      vxc1(2*ir-1,ipts,1)=kxc(ir,ipts,1)*rhoarr(2*ir-1,1)
      vxc1(2*ir  ,ipts,1)=kxc(ir,ipts,1)*rhoarr(2*ir  ,1)
     end do
    end if

!   Spin-polarized
   else
    if(cplex==1)then
     do ir=1,nrad
      rho_dn=rhoarr(ir,1)-rhoarr(ir,2)
      vxc1(ir,ipts,1)=kxc(ir,ipts,1)*rhoarr(ir,2)+kxc(ir,ipts,2)*rho_dn
      vxc1(ir,ipts,2)=kxc(ir,ipts,2)*rhoarr(ir,2)+kxc(ir,ipts,3)*rho_dn
     end do
    else
     do ir=1,nrad
      jr=2*ir
      rho_dn  =rhoarr(jr-1,1)-rhoarr(jr-1,2)
      rhoim_dn=rhoarr(jr  ,1)-rhoarr(jr  ,2)
      vxc1(jr-1,ipts,1)=kxc(ir,ipts,1)*rhoarr(jr-1,2)+kxc(ir,ipts,2)*rho_dn
      vxc1(jr  ,ipts,1)=kxc(ir,ipts,1)*rhoarr(jr  ,2)+kxc(ir,ipts,2)*rhoim_dn
      vxc1(jr-1,ipts,2)=kxc(ir,ipts,2)*rhoarr(jr-1,2)+kxc(ir,ipts,3)*rho_dn
      vxc1(jr  ,ipts,2)=kxc(ir,ipts,2)*rhoarr(jr  ,2)+kxc(ir,ipts,3)*rhoim_dn
     end do
    end if
   end if

  end if !option

! ----------------------------------------------------------------------
! ----- Accumulate and store 2nd-order change of XC energy
! ----------------------------------------------------------------------
  if (option==0.or.option==2) then

!  For usexnhat=2 particular case, add now compensation density
   if (usexcnhat==1) then
    do ispden=1,nspden
     do ilm=1,lm_size
      if (lmselect(ilm)) rhoarr(:,ispden)=rhoarr(:,ispden)+nhat1(:,ilm,ispden)*pawang%ylmr(ilm,ipts)
     end do
    end do
   end if

!  ----- Calculate d2Exc=Int[Vxc^(1)^*(r).n^(1)(r).dr]
   allocate(ff(nrad))
   if (cplex==1) then
    if (nspden/=4) then
!    Real part
     ff(:)=vxc1(:,ipts,1)*rhoarr(:,nspden)
     if (nspden==2) ff(:)=ff(:)+vxc1(:,ipts,2)*(rhoarr(:,1)-rhoarr(:,2))
!    Imaginary part
!    ff(:)=zero
    else
!    Real part
     ff(:)=half*(vxc1(:,ipts,1)*(rhoarr(:,1)+rhoarr(:,4)) &
&     +vxc1(:,ipts,2)*(rhoarr(:,1)-rhoarr(:,4))) &
&     +vxc1(:,ipts,3)*rhoarr(:,2) &
&     -vxc1(:,ipts,4)*rhoarr(:,3)
!    Imaginary part
!    ff(:)=zero
    end if
   else
    if (nspden/=4) then
!    Real part
     do ir=1,nrad
      jr=2*ir
      v11r=vxc1(jr-1,ipts,1);v11i=vxc1(jr,ipts,1)
      ro11r=rhoarr(jr-1,nspden);ro11i=rhoarr(jr,nspden)
      ff(ir)=v11r*ro11r+v11i*ro11i
!     Imaginary part
!     ff(ir)=v11r*ro11i-v11i*ro11r
     end do
     if (nspden==2) then
!     Real part
      do ir=1,nrad
       jr=2*ir
       v22r=vxc1(jr-1,ipts,2);v22i=vxc1(jr,ipts,2)
       ro22r=rhoarr(jr-1,1)-rhoarr(jr-1,2)
       ro22i=rhoarr(jr  ,1)-rhoarr(jr  ,2)
       ff(ir)=ff(ir)+v22r*ro22r+v22i*ro22i
!      Imaginary part
!      ff(ir)=ff(ir)+v22r*ro22i-v22i*ro22r
      end do
     end if
    else
!    V is stored as : v^11, v^22, V^12, i.V^21 (each are complex)
!    N is stored as : n, m_x, m_y, mZ          (each are complex)
!    Real part
     do ir=1,nrad
      jr=2*ir
      v11r=vxc1(jr-1,ipts,1);v11i= vxc1(jr  ,ipts,1)
      v22r=vxc1(jr-1,ipts,2);v22i= vxc1(jr  ,ipts,2)
      v12r=vxc1(jr-1,ipts,3);v12i= vxc1(jr  ,ipts,3)
      v21r=vxc1(jr  ,ipts,1);v21i=-vxc1(jr-1,ipts,1)
      ro11r=rhoarr(jr-1,1)+rhoarr(jr-1,4)
      ro11i=rhoarr(jr  ,1)+rhoarr(jr  ,4)
      ro22r=rhoarr(jr-1,1)-rhoarr(jr-1,4)
      ro22i=rhoarr(jr  ,1)-rhoarr(jr  ,4)
      ro12r=rhoarr(jr-1,2)+rhoarr(jr  ,3)
      ro12i=rhoarr(jr  ,2)-rhoarr(jr-1,3)
      ro12r=rhoarr(jr-1,2)-rhoarr(jr  ,3)
      ro12i=rhoarr(jr  ,2)+rhoarr(jr-1,3)
      ff(ir)=half*(v11r*ro11r+v11i*ro11i+v22r*ro22r+v22i*ro22i &
&      +v12r*ro12r+v12i*ro12i+v21r*ro21r+v21i*ro21i)
!     Imaginary part
!     ff(ir)=half*(v11r*ro11i-v11i*ro11r+v22r*ro22i-v22i*ro22r &
!     &               +v12r*ro12i-v12i*ro12r+v21r*ro21i-v21i*ro21r)
     end do
    end if
   end if

   ff(:)=ff(:)*pawrad%rad(:)**2
   call simp_gen(vxcrho,ff,pawrad)
   d2enxc=d2enxc+vxcrho*pawang%angwgth(ipts)

   deallocate(ff)

  end if

! ----- End of the loop on npts (angular part)
 end do

!Add the four*pi factor of the angular integration
 if (option==0.or.option==2) d2enxc=d2enxc*four_pi

 deallocate(rhoarr)

 call timab(81,2,tsec)

 end subroutine pawxc3
!!***
