!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawxcm3
!! NAME
!! pawxcm3
!!
!! FUNCTION
!! PAW only
!! PAW only
!! Compute first-order change of XC potential and contribution to
!! 2nd-order change of XC energy inside a PAW sphere.
!! LDA+GGA - USE A DEVELOPMENT OF THE DENSITY OVER (L,M) MOMENTS
!!
!! COPYRIGHT
!! Copyright (C) 2009-2009 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!! This routine has been written from rhohxc
!!
!! INPUTS
!!  corexc1(cplex*pawrad%mesh_size)=first-order change of core density on radial grid
!!  cplex= if 1, real space 1-order functions on FFT grid are REAL, if 2, COMPLEX
!!  kxc(pawrad%mesh_size,lm_size,nkxc)=GS xc kernel
!!  lm_size=size of density array rhor (see below)
!!  lmselect(lm_size)=select the non-zero LM-moments of input density rhor1
!!  nhat1(cplex*pawrad%mesh_size,lm_size,nspden)=first-order change of compensation density
!!                                        (total in 1st half and spin-up in 2nd half if nspden=2)
!!  nkxc=second dimension of the kxc array
!!  nspden=number of spin-density components
!!  option=0  compute both 2nd-order XC energy and 1st-order potential
!!         1  compute only 1st-order XC potential
!!         2  compute only 2nd-order XC energy
!!  pawang <type(pawang_type)>=paw angular mesh and related data
!!  pawrad <type(pawrad_type)>=paw radial mesh and related data
!!  pawxcdev=order of Vxc development
!!  rhor1(cplex*pawrad%mesh_size,lm_size,nspden)=first-order change of density
!!  usecore= 1 if core density has to be used in Exc/Vxc ; 0 otherwise
!!  usexcnhat= 0 if compensation density does not have to be used
!!             1 if compensation density has to be used in d2Exc only
!!             2 if compensation density (nhat) has to be used in d2Exc and Vxc1
!!  xclevel= XC functional level
!!
!! OUTPUT
!!  == if option=0 or 2 ==
!!    d2enxc=returned exchange-cor. contribution to 2nd-order XC energy
!!  == if option=0 or 1 ==
!!    vxc1(cplex*pawrad%mesh_size,pawang%angl_size,nspden)=1st-order XC potential
!!
!! PARENTS
!!      pawdenpot
!!
!! CHILDREN
!!      leave_new,,simp_gen,timab,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 subroutine pawxcm3(corexc1,cplex,d2enxc,kxc,lm_size,lmselect,nhat1,nkxc,nspden,option,&
&                   pawang,pawrad,pawxcdev,rhor1,usecore,usexcnhat,vxc1,xclevel)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_18_timing
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: cplex,lm_size,nkxc,nspden,option,pawxcdev,usecore,usexcnhat,xclevel
 real(dp),intent(out) :: d2enxc
 type(pawang_type),intent(in) :: pawang
 type(pawrad_type),intent(in) :: pawrad
!arrays
 logical,intent(in) :: lmselect(lm_size)
 real(dp),intent(in) :: corexc1(cplex*pawrad%mesh_size)
 real(dp),intent(in) :: kxc(pawrad%mesh_size,lm_size,nkxc)
 real(dp),intent(in) :: nhat1(cplex*pawrad%mesh_size,lm_size,nspden)
 real(dp),intent(in) :: rhor1(cplex*pawrad%mesh_size,lm_size,nspden)
 real(dp),intent(out) :: vxc1(cplex*pawrad%mesh_size,lm_size,nspden)

!Local variables-------------------------------
!scalars
 character(len=500) :: message
!arrays
 real(dp) :: tsec(2)

!************************************************************************

 call timab(81,1,tsec)

 write(message, '(4a)' ) ch10,&
& ' pawxcm3 : ERROR -',ch10,&
& '  Not yet implemented (choose pawxcdev=0) !'
 call wrtout(06,message,'COLL')
 call leave_new('COLL')

 d2enxc=zero
 vxc1=zero

!----- End of routine
 call timab(81,2,tsec)

 end subroutine pawxcm3
!!***
