!{\src2tex{textfont=tt}}
!!****f* ABINIT/finddistrproc
!! NAME
!! finddistrproc
!!
!! FUNCTION
!! find a distribution of processor to fill npkpt, npband, npfft and bandpp, knowing nproc
!!
!! COPYRIGHT
!! Copyright (C) 1999-2009 ABINIT group (FJ,MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  mpi_enreg=informations about MPI parallelization
!!  ndtset= number of datasets to be read; if 0, no multi-dataset mode
!!  ndtset_alloc=number of datasets, corrected for allocation of at least
!!               one data set.
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  mpi_enreg%keywp(5,250)= transient storage to print nproc, npkpt, npband, npfft, and bandpp.
!!  mpi_enreg%trialproc(2)= transient storage for the number of processors and the error flag.
!!  dtset%npkpt= number of processors for parallelisation on k points
!!  dtset%npband=number of processors for parallelisation on bands
!!  dtset%npfft=number of processors for parallelisation on fft grid
!!  dtset%bandpp= internal parameter for lobpcg parallelisation algorithm
!!
!! PARENTS
!!      invars1
!!
!! CHILDREN
!!  leave_new, wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine finddistrproc(dtset,mband,mpi_enreg)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_16_hideleave
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(MPI_type),intent(inout) :: mpi_enreg
 integer,intent(in) ::mband
 type(dataset_type),intent(inout) :: dtset
!arrays


!Local variables-------------------------------
!scalars
 integer :: bandpp,bandpp1,bandpp2,icount,idtset,i1,i2,ii,in,na,ncount,ndtsetmax,nleft,nnleft
 integer :: npband,npfft,npkpt,nproc,nproc1,nprocmin,nprocp
 character(len=500) :: message
!arrays
 integer,allocatable :: ndiv(:)
 
!******************************************************************
!DEBUG
!write(6,*)' finddistrproc : enter'
!stop
!ENDDEBUG
!print*,dtset%npkpt,dtset%npband,dtset%npfft,dtset%bandpp,dtset%paral_kgb
 if (dtset%npkpt/=1.or.dtset%npband/=1.or.dtset%npfft/=1.or.dtset%bandpp/=1) return
 nprocmin=2
 if(mpi_enreg%paral_compil==1)then
  if (dtset%paral_kgb==0) return
  if(dtset%paral_kgb <0) then
   nproc=-dtset%paral_kgb
  else
   nproc=mpi_enreg%nproc    
   nprocmin=nproc
  end if
 else
  if (dtset%paral_kgb>=0) return
  nproc=-dtset%paral_kgb
 end if
 mpi_enreg%trialproc(1)=nproc
 bandpp1=1
 bandpp2=1
 nprocp=0
 allocate(ndiv((mband/2)+1))
 ndiv=1
 icount=0
 do ii=1,mband/2
  na=mband/ii
  if(na*ii==mband)then
   icount=icount+1
   ndiv(icount)=na
   if(na==4)bandpp1=4
   if(na==2)bandpp2=2
  end if
 end do

 bandpp=max(bandpp1,bandpp2)
 ncount=icount+1

 i2=0
 do in=nprocmin,nproc
  npband=1;npfft=1;npkpt=1
  if(2*dtset%nkpt*dtset%nsppol>=in) then
   npkpt=dtset%nkpt*dtset%nsppol
  else
   npkpt=dtset%nkpt*dtset%nsppol
   nleft=in/npkpt
   i1=0
   do ii=1,ncount
    if(i1==1) cycle
    if((mband/(bandpp*ndiv(ii))*(bandpp*ndiv(ii)))/=mband)cycle
    if(ndiv(ii)>nleft)cycle
    if(nleft<=50) then
     npband=ndiv(ii)
     i1=1
    else
     if(ndiv(ii)<=4*nleft/5) npband=ndiv(ii)
     i1=1
    end if
    npfft=nleft/npband
   end do
  end if
  nproc1=npkpt*npband*npfft

  if (nproc1/=nprocp) then
   if(i2>250) then
    write(message,'(a,a,a,a)' )ch10,&
&    'BUG in finddistrproc: more than 250 possible choices for nproc',ch10,&
&    'Action: contact ABINIT group'
    call leave_new('COLL')
   end if
   i2=i2+1
   mpi_enreg%keywp(1,i2)=nproc1
   mpi_enreg%keywp(2,i2)=npkpt
   mpi_enreg%keywp(3,i2)=npband
   mpi_enreg%keywp(4,i2)=npfft
   mpi_enreg%keywp(5,i2)=bandpp
  end if
  nprocp=nproc1
 end do
 if (nproc1/=nproc) mpi_enreg%trialproc(2)=1
 if(mpi_enreg%paral_compil==1.and.nproc1/=mpi_enreg%nproc) mpi_enreg%trialproc(2)=2
 if(mpi_enreg%paral_compil/=1)mpi_enreg%trialproc(2)=3
!print *,mpi_enreg%keywp
 deallocate(ndiv)
 if(mpi_enreg%paral_compil==1) then
  if(dtset%paral_kgb==1)then
   dtset%npkpt=npkpt
   dtset%npband=npband
   dtset%npfft=npfft
   dtset%bandpp=bandpp
  else
   dtset%npfft=mpi_enreg%nproc
  end if
 end if
 dtset%paral_kgb=1
!DEBUG
!write(6,*)' finddistrproc : exit'
!call flush(6)
!stop
!ENDDEBUG

end subroutine finddistrproc


!!***
