!{\src2tex{textfont=tt}}
!!****f* ABINIT/filnam_comm
!! NAME
!! filnam_comm
!!
!! FUNCTION
!! Communicate filenames to all processors
!!
!! COPYRIGHT
!! Copyright (C) 2009 ABINIT group (XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  mpi_enreg=informations about MPI parallelization
!!
!! SIDE EFFECTS
!!  character(len=fnlen) :: filnam(5)=character strings giving file names
!!
!! PARENTS
!!      iofn1
!!
!! CHILDREN
!!      leave_test,mpi_bcast,timab
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine filnam_comm(filnam,mpi_enreg)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
#if defined MPI && defined MPI2
 use mpi
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_18_timing
 use interfaces_51_manage_mpi
!End of the abilint section

 implicit none
#if defined MPI && defined MPI1
 include 'mpif.h'
#endif

!Arguments ------------------------------------
 character(len=fnlen), intent(out) :: filnam(5)
 type(MPI_type), intent(in) :: mpi_enreg

!Local variables-------------------------------

!no_abirules

#if defined MPI 
          !Variables introduced for MPI version
           integer :: ierr
           real(dp) :: tsec(2)
#endif

!*************************************************************************

#if defined MPI 
           call timab(48,1,tsec)
           call leave_test(mpi_enreg)
           call MPI_BCAST(filnam(1:5),5*fnlen,MPI_CHARACTER,0,&
          &  MPI_COMM_WORLD,ierr)
           call timab(48,2,tsec)
#endif

end subroutine filnam_comm
!!***
