!{\src2tex{textfont=tt}}
!!****f* ABINIT/dijangmom
!! NAME
!! dijangmom
!!
!! FUNCTION
!! Compute the PAW on-site orbital angular momentum, necessary for magnetic field perturbation
!!
!! COPYRIGHT
!! Copyright (C) 2005-2009 ABINIT group (JJ,MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  natom=number of atoms in cell.
!!  ntypat=number of atom types
!!  pawang <type(pawang_type)>=paw angular mesh and related data
!!  pawrad(ntypat) <type(pawrad_type)>=paw radial mesh and related data
!!  pawtab(ntypat) <type(pawtab_type)>=paw tabulated starting data
!!  psps <type pseudopotential_type>: datastructure of pseudopotential information
!!  typat(natom)=type (integer) for each atom
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  paw_ij(natom) <type(paw_ij_type)>=paw arrays given on (i,j) channels
!!
!! NOTES
!!
!! PARENTS
!!      respfn
!!
!! CHILDREN
!!      deducer0,simp_gen
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine dijangmom(natom,ntypat,pawang,paw_ij,pawrad,pawtab,psps,typat)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_32_util
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: natom, ntypat
 type(pawang_type),intent(in) :: pawang
 type(pseudopotential_type),intent(in) :: psps
!arrays
 integer,intent(in) :: typat(natom)
 type(paw_ij_type),intent(inout) :: paw_ij(natom)
 type(pawrad_type),intent(in) :: pawrad(ntypat)
 type(pawtab_type),intent(in) :: pawtab(ntypat)

!Local variables-------------------------------
!scalars
 integer :: iatom, idir, itypat
 integer :: ilmn, il, im, ilm, iln
 integer :: jlmn, jl, jm, jlm, jln, j0lmn
 integer :: klmn, kln, mesh_size
 real(dp) :: intg, intgr3
 complex(dpc) :: lms
!arrays
 real(dp),allocatable :: ff(:)

! ************************************************************************

!DEBUG
!write(*,*)' dijangmom : enter'
!ENDDEBUG

!loop over atoms in cell
 do iatom = 1, natom
  itypat = typat(iatom)
  mesh_size=pawrad(itypat)%mesh_size
  allocate(ff(mesh_size))

! loop over basis state pairs for this atom
  do jlmn=1,pawtab(itypat)%lmn_size
   jl= psps%indlmn(1,jlmn,itypat)  
   jm=psps%indlmn(2,jlmn,itypat)
   jlm = psps%indlmn(4,jlmn,itypat)
   jln=psps%indlmn(5,jlmn,itypat)
   j0lmn=jlmn*(jlmn-1)/2
   do ilmn=1,jlmn
    il= psps%indlmn(1,ilmn,itypat)
    im=psps%indlmn(2,ilmn,itypat)
    iln=psps%indlmn(5,ilmn,itypat)
    ilm = psps%indlmn(4,ilmn,itypat)
    klmn=j0lmn+ilmn
    kln = pawtab(itypat)%indklmn(2,klmn)

!   Computation of <phi_i|phi_j>- <tphi_i|tphi_j> radial integral
!   this is NOT the same as the sij non-local overlap, because that also
!   involves an angular integral over the S_i*S_j spherical harmonics
    ff(2:mesh_size)=pawtab(itypat)%phiphj(2:mesh_size,kln)-&
&    pawtab(itypat)%tphitphj(2:mesh_size,kln)
    call deducer0(ff,mesh_size,pawrad(itypat))
    call simp_gen(intg,ff,pawrad(itypat))

!   Computation of (<phi_i|phi_j>- <tphi_i|tphi_j>)/r^3 radial integral
    ff(2:mesh_size)=(pawtab(itypat)%phiphj(2:mesh_size,kln)-&
&     pawtab(itypat)%tphitphj(2:mesh_size,kln))/&
&     pawrad(itypat)%rad(2:mesh_size)**3
    call deducer0(ff,mesh_size,pawrad(itypat))
    call simp_gen(intgr3,ff,pawrad(itypat))

    do idir = 1, 3

     call slxyzs(il,im,idir,jl,jm,lms)

     paw_ij(iatom)%dijL(idir,klmn)=intg*aimag(lms)
     paw_ij(iatom)%dijLr3(idir,klmn)=intgr3*aimag(lms)

    end do

   end do ! end loop over ilmn
  end do ! end loop over jlmn

  paw_ij(iatom)%has_dijL = 2
  paw_ij(iatom)%has_dijLr3 = 2

  deallocate(ff)

 end do ! end loop over atoms in cell

!DEBUG
!write(6,*)' dijangmom : exit '
!ENDDEBUG

 end subroutine dijangmom
!!***
