!{\src2tex{textfont=tt}}
!!****f* ABINIT/dijdipole
!! NAME
!! dijdipole
!!
!! FUNCTION
!! Compute the PAW on-site <r-R> terms, necessary for electric field perturbation
!!
!! COPYRIGHT
!! Copyright (C) 2005-2009 ABINIT group (JJ,MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  natom=number of atoms in cell.
!!  ntypat=number of atom types
!!  pawang <type(pawang_type)>=paw angular mesh and related data
!!  pawrad(ntypat) <type(pawrad_type)>=paw radial mesh and related data
!!  pawtab(ntypat) <type(pawtab_type)>=paw tabulated starting data
!!  typat(natom)=type (integer) for each atom
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  paw_ij(natom) <type(paw_ij_type)>=paw arrays given on (i,j) channels
!!
!! NOTES
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine dijdipole(natom,ntypat,pawang,paw_ij,pawrad,pawtab,typat)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_32_util
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: natom, ntypat
 type(pawang_type),intent(in) :: pawang
!arrays
 integer,intent(in) :: typat(natom)
 type(paw_ij_type),intent(inout) :: paw_ij(natom)
 type(pawrad_type),intent(in) :: pawrad(ntypat)
 type(pawtab_type),intent(in) :: pawtab(ntypat)

!Local variables-------------------------------
!scalars
 integer :: iatom, ils, ilslm, isel, itypat, klmn, klm, kln
 integer :: lmin, lmax, mesh_size, mm
 real(dp) :: c1, intg
!arrays
 real(dp) :: rg1(-1:1)
 real(dp),allocatable :: ff(:)

! ************************************************************************

!DEBUG
write(*,*)' dijdipole : enter'
!ENDDEBUG

!the following factor arises in expanding the angular dependence of the dipole
!vector in terms of real spherical harmonics. The real spherical harmonics are as 
!in the routine initylmr.F90; see
!http://www1.elsevier.com/homepage/saa/eccc3/paper48/eccc3.html
 c1 = sqrt(4.0*pi/3.0)

!loop over atoms in cell
 do iatom = 1, natom
  itypat = typat(iatom)
  mesh_size=pawrad(itypat)%mesh_size
  allocate(ff(mesh_size))

! loop over basis state pairs for this atom
  do klmn = 1, paw_ij(iatom)%lmn2_size
   klm =pawtab(itypat)%indklmn(1,klmn)
   kln =pawtab(itypat)%indklmn(2,klmn)
   lmin=pawtab(itypat)%indklmn(3,klmn)
   lmax=pawtab(itypat)%indklmn(4,klmn)

!  Select only l=1, because the dipole is a vector operator
   if (lmin<=1.and.lmax>=1) then

!   Computation of <phi_i|r|phi_j>- <tphi_i|r|tphi_j>
!   the dipole vector has radial dependence r
    ff(2:mesh_size)=(pawtab(itypat)%phiphj(2:mesh_size,kln)&
&    -pawtab(itypat)%tphitphj(2:mesh_size,kln))&
&    *pawrad(itypat)%rad(2:mesh_size)
    call deducer0(ff,mesh_size,pawrad(itypat))
    call simp_gen(intg,ff,pawrad(itypat))

!   Real gaunt coefficients selection
    ils=1 !l=1 only
    rg1(:)=zero
    do mm=-ils,ils
     ilslm=ils*ils+ils+mm+1
     isel=pawang%gntselect(ilslm,klm)
     if (isel>0) rg1(mm)=pawang%realgnt(isel) ! these are the non-zero <Ylm|Y1m|Yl'm'> matrix elements
    end do

    paw_ij(iatom)%dijR(1,klmn)=c1*rg1(1)*intg ! <r_x-R_x>
    paw_ij(iatom)%dijR(2,klmn)=c1*rg1(-1)*intg ! <r_y-R_y>
    paw_ij(iatom)%dijR(3,klmn)=c1*rg1(0)*intg ! <r_z-R_z>

   end if ! end gaunt constraint
  end do ! end loop over lmn2_size pairs of basis states

  paw_ij(iatom)%has_dijR=2

  deallocate(ff)

 end do ! end loop over atoms in cell

!DEBUG
write(6,*)' dijdipole : exit '
!stop
!ENDDEBUG

 end subroutine dijdipole
!!***
