!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawfrnhat
!!
!! NAME
!! pawfrnhat
!!
!! FUNCTION
!! PAW: Compute frozen part of charge compensation density nhat and
!!      frozen part of psp strength Dij due to 1st-order compensation density
!!      nhatfr(r)=Sum_ij,lm[rhoij_ij.q_ij^l.(g_l(r).Y_lm(r))^(1)]
!!      Dijfr    =Int_R^3{vtrial*Sum_LM[Q_ij_q^LM^(1)] + Vloc^(1)*Sum_LM[Q_ij_q^LM]}
!!      Depend on q wave vector but not on first-order wave-function.
!!
!! COPYRIGHT
!! Copyright (C) 2009-2009 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.
!!
!! INPUTS
!!  cplex: if 1, real space 1-order functions on FFT grid are REAL; if 2, COMPLEX
!!  gprimd(3,3)=dimensional primitive translations for reciprocal space(bohr^-1)
!!  idir=direction of atomic displacement (in case of phonons perturb.)
!!  ipert=nindex of perturbation
!!  natom=number of atoms in cell
!!  nfft=(effective) number of FFT grid points (for this processor)
!!  nspden=number of spin-density components
!!  ntypat=number of types of atoms
!!  optfr=0: computes only frozen part of compensation density
!!        1: computes only frozen part of Dij
!!        2: computes both
!!  pawang <type(pawang_type)>=paw angular mesh and related data
!!  pawfgrtab(natom) <type(pawfgrtab_type)>=atomic data given on fine rectangular grid
!!  pawrhoij(natom) <type(pawrhoij_type)>= Ground-State paw rhoij occupancies and related data
!!  pawtab(ntypat) <type(pawtab_type)>=paw tabulated starting data
!!  qphon(3)=wavevector of the phonon
!!  rprimd(3,3)=dimensional primitive translations in real space (bohr)
!!  typat(natom)=type integer for each atom in cell
!!  ucvol=unit cell volume (bohr^3)
!!  vpsp1(cplex*nfft)= first-order change of local potential
!!  vtrial(nfft,nspden)= total GS potential
!!
!! OUTPUT
!!  === If optfr= 0 or 2
!!    pawfgrtab(iatom)%nhatfr(nfgd,nspden)
!!                    frozen part of charge compensation density (inside PAW spheres)
!!                    =Sum_ij,lm[rhoij_ij.q_ij^l.(g_l(r).Y_lm(r))^(1)]
!!  === If optfr= 0 or 1
!!    paw_ij1(iatom)%dijfr(cplex_dij*lmn2_size,nspden)=
!!                    frozen contribution to psp strength Dij
!!                    =Int_R^3{vtrial*Sum_LM[Q_ij_q^LM^(1)] + Vloc^(1)*Sum_LM[Q_ij_q^LM]}
!!
!! PARENTS
!!      scfcv3,pawmknhat
!!
!! CHILDREN
!!      leave_new,pawgylm,wrtout,xcomm_init,xsum_mpi
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pawfrnhat(cplex,gprimd,idir,ipert,mpi_enreg,natom,nfft,ngfft,nspden,ntypat,&
&          optfr,paw_ij1,pawang,pawfgrtab,pawrhoij,pawtab,qphon,rprimd,typat,ucvol,&
&          vpsp1,vtrial)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_io_tools, only : flush_unit

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_12_hide_mpi
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_51_manage_mpi
 use interfaces_66_paw, except_this_one => pawfrnhat
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: cplex,idir,ipert,natom,nfft,nspden,ntypat,optfr
 real(dp),intent(in) :: ucvol
 type(MPI_type),intent(inout) :: mpi_enreg
 type(pawang_type),intent(in) :: pawang
!arrays
 integer,intent(in) :: ngfft(18),typat(natom)
 real(dp),intent(in) :: qphon(3),rprimd(3,3),gprimd(3,3)
 real(dp),intent(in) :: vpsp1(cplex*nfft*(optfr+1)/2),vtrial(nfft,nspden*(optfr+1)/2)
 type(paw_ij_type),intent(inout) :: paw_ij1(natom)
 type(pawfgrtab_type),intent(inout) :: pawfgrtab(natom)
 type(pawrhoij_type),intent(in) :: pawrhoij(natom)
 type(pawtab_type),intent(in) :: pawtab(ntypat)

!Local variables-------------------------------
!scalars
 integer :: dplex,iatom,ic,ier,ils,ilslm,iplex,irhoij,isel,ispden,itypat,jc,jrhoij,klm,klmn,klmn1,lm_size
 integer :: lmn2_size,lm0,lmax,lmin,mm,mu,nfftot,nfgd,old_paral_level,optgr0,optgr1,spaceComm
 logical :: need_dijfr_1,need_dijfr_2,need_nhatfr
 real(dp) :: fact,phase,ro,r1_red,r2_red,r3_red
 character(len=500) :: message
!arrays
 real(dp) :: contrib(2),r_cart(3),r_red(3),rdum(1)
 real(dp),allocatable :: expmiqr(:,:),intv(:,:),intvloc(:,:),intv_tmp(:,:)
 real(dp),allocatable :: nhatfr_tmp(:,:,:),vloc(:,:)

! *************************************************************************

#if defined DEBUG_MODE
 write(message,'(a)')' pawfrnhat : enter '
 call wrtout(std_out,message,'COLL')
 call flush(std_out)
#endif

!Compatibility tests
 if (pawfgrtab(1)%rfgd_allocated==0 .and. ipert <= natom) then
  write(message, '(4a)' )ch10,&
&  ' pawgylm : BUG -',ch10,&
&  '  pawfgrtab()%rfgd array must be allocated  !'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if
 if (optfr==1.or.optfr==2) then
  if (paw_ij1(1)%cplex/=cplex) then
   write(message, '(a,a,a,a)' )ch10,&
&   ' pawfrnhat : BUG -',ch10,&
&   '  paw_ij1()%cplex and cplex must be equal !'
   call wrtout(6,message,'COLL')
   call leave_new('COLL')
  end if
  if (ipert<=natom.and.paw_ij1(ipert)%has_dijfr==0) then
   write(message, '(4a)' )ch10,&
&   ' pawfrnhat : BUG -',ch10,&
&   '  pawdij1(ipert)%dijfr must be allocated !'
   call wrtout(6,message,'PERS')
   call leave_new('PERS')
  end if
 end if

 nfftot=ngfft(1)*ngfft(2)*ngfft(3)
 fact=ucvol/dble(nfftot)
 dplex=cplex-1

!Loops over  atoms
 do iatom=1,natom

! Eventually allocate frozen nhat points
! For the time being, nhatfr exists only for an atom. displ. perturbation
! original line, think it should be ipert==iatom (JWZ 19 April 2009)
!  if ((optfr==0.or.optfr==2).and.ipert==natom) then
  if ((optfr==0.or.optfr==2).and.ipert==iatom) then
   if (associated(pawfgrtab(iatom)%nhatfr)) deallocate(pawfgrtab(iatom)%nhatfr)
   allocate(pawfgrtab(iatom)%nhatfr(cplex*nfgd,nspden))
   pawfgrtab(iatom)%nhatfr_allocated=1
  end if

! Select which atom to treat
  need_nhatfr=((ipert==iatom).and.(pawfgrtab(iatom)%nhatfr_allocated==1))
  need_dijfr_1=((ipert==iatom).and.(paw_ij1(iatom)%has_dijfr==1))
  need_dijfr_2=(paw_ij1(iatom)%has_dijfr==1)
  if ((.not.need_nhatfr).and.(.not.need_dijfr_1).and.(.not.need_dijfr_2)) cycle

! Some atom-dependent quantities
  itypat=typat(iatom)
  lm_size=pawfgrtab(iatom)%l_size**2
  lmn2_size=pawtab(itypat)%lmn2_size
  nfgd=pawfgrtab(iatom)%nfgd

! Eventually compute g_l(r).Y_lm(r) factors for the current atom (if not already done)
  if (((need_dijfr_2).and.(pawfgrtab(iatom)%gylm_allocated==0)).or.&
&  ((need_dijfr_1.or.need_nhatfr).and.(pawfgrtab(iatom)%gylmgr_allocated==0))) then
   optgr0=0;optgr1=0
   if ((need_dijfr_2).and.(pawfgrtab(iatom)%gylm_allocated==0)) then
    if (associated(pawfgrtab(iatom)%gylm)) deallocate(pawfgrtab(iatom)%gylm)
    allocate(pawfgrtab(iatom)%gylm(pawfgrtab(iatom)%nfgd,lm_size))
    pawfgrtab(iatom)%gylm_allocated=2;optgr0=1
   end if
   if ((need_dijfr_1.or.need_nhatfr).and.(pawfgrtab(iatom)%gylmgr_allocated==0)) then
    if (associated(pawfgrtab(iatom)%gylmgr)) deallocate(pawfgrtab(iatom)%gylmgr)
    allocate(pawfgrtab(iatom)%gylmgr(3,pawfgrtab(iatom)%nfgd,lm_size))
    pawfgrtab(iatom)%gylmgr_allocated=2;optgr1=1
   end if
   call pawgylm(pawfgrtab(iatom)%gylm,pawfgrtab(iatom)%gylmgr,rdum,iatom,&
&   pawfgrtab(iatom)%ifftsph,itypat,lm_size,pawfgrtab(iatom)%nfgd,&
&   optgr0,optgr1,0,pawtab(itypat),pawfgrtab(iatom)%rfgd,&
&   pawfgrtab(iatom)%rfgd_allocated)
  end if

! Compute phase factors exp(-i.q.r)
  allocate(expmiqr(1:cplex,nfgd))
  if(qphon(1)**2+qphon(2)**2+qphon(3)**2<1.d-15) then
   expmiqr(cplex:cplex,1:nfgd)=zero
   do ic=1,nfgd
    expmiqr(1,ic)=one
   end do
  else
   do ic=1,nfgd
    r_cart(1:3)=pawfgrtab(iatom)%rfgd(1:3,ic)
    r_red(1)=gprimd(1,1)*r_cart(1)+gprimd(2,1)*r_cart(2)+gprimd(3,1)*r_cart(3)
    r_red(2)=gprimd(1,2)*r_cart(1)+gprimd(2,2)*r_cart(2)+gprimd(3,2)*r_cart(3)
    r_red(3)=gprimd(1,3)*r_cart(1)+gprimd(2,3)*r_cart(2)+gprimd(3,3)*r_cart(3)
    phase=two_pi*(qphon(1)*r_red(1)+qphon(2)*r_red(2)+qphon(3)*r_red(3))
    expmiqr(1,ic)=cos(phase)
    if (cplex==2) expmiqr(2,ic)=-sin(phase)
   end do
  end if

! Loop over spin components
  do ispden=1,nspden

!  Computation of frozen part of 1st-order compensation density
!  =Sum_ij,lm[rhoij_ij.q_ij^l.(g_l(r).Y_lm(r))^(1)]
!  ------------------------------------------------------------
   if (need_nhatfr) then
    jrhoij=1
    allocate(nhatfr_tmp(cplex,3,nfgd));nhatfr_tmp=zero
    do irhoij=1,pawrhoij(iatom)%nrhoijsel
     klmn=pawrhoij(iatom)%rhoijselect(irhoij)
     klm =pawtab(itypat)%indklmn(1,klmn)
     lmin=pawtab(itypat)%indklmn(3,klmn)
     lmax=pawtab(itypat)%indklmn(4,klmn)
     ro=pawrhoij(iatom)%rhoijp(jrhoij,ispden)*pawtab(itypat)%dltij(klmn)
     do ils=lmin,lmax,2
      lm0=ils**2+ils+1
      do mm=-ils,ils
       ilslm=lm0+mm;isel=pawang%gntselect(lm0+mm,klm)
       if (isel>0) then
        do ic=1,nfgd
         do mu=1,3
          contrib(1)=-ro*pawtab(itypat)%qijl(ilslm,klmn)*pawfgrtab(iatom)%gylmgr(mu,ic,ilslm)
          nhatfr_tmp(1:cplex,mu,ic)=nhatfr_tmp(1:cplex,mu,ic)+contrib(1)*expmiqr(1:cplex,ic)
         end do
        end do
       end if
      end do
     end do
     jrhoij=jrhoij+pawrhoij(iatom)%cplex
    end do
!   Convert from cartesian to reduced coordinates
    if (cplex==2) then
     jc=1
     do ic=1,nfgd
      pawfgrtab(iatom)%nhatfr(jc:jc+iplex-1,ispden)= &
&      gprimd(1,idir)*nhatfr_tmp(1:cplex,1,ic) &
&      +gprimd(2,idir)*nhatfr_tmp(1:cplex,2,ic) &
&      +gprimd(3,idir)*nhatfr_tmp(1:cplex,3,ic)
      jc=jc+cplex
     end do
    end if
    deallocate(nhatfr_tmp)

   end if

!  Computation of frozen part of 1st-order psps strength Dij
!  ------------------------------------------------------------------
   if (need_dijfr_1.or.need_dijfr_2) then

    allocate(intv(cplex,lm_size));intv=zero

!   First part: Int_R^3{vtrial*Sum_LM[Q_ij_q^LM^(1)]}
    if (need_dijfr_1) then

!    ----- Retrieve potential Vtrial (subtle if nspden=4 ;-)
     if (nspden/=4) then
      allocate(vloc(1,nfgd))
      do ic=1,nfgd
       vloc(1,ic)=vtrial(pawfgrtab(iatom)%ifftsph(ic),ispden)
      end do
     else
      allocate(vloc(2,nfgd))
      if (ispden<=2) then
       do ic=1,nfgd
        jc=pawfgrtab(iatom)%ifftsph(ic)
        vloc(1,ic)=vtrial(jc,ispden)
        vloc(2,ic)=zero
       end do
      else if (nspden==3) then
       do ic=1,nfgd
        jc=pawfgrtab(iatom)%ifftsph(ic)
        vloc(1,ic)=vtrial(jc,3)
        vloc(2,ic)=vtrial(jc,4)
       end do
      else ! ispden=4
       vloc(2,1:nfgd)=-vloc(2,1:nfgd)
      end if
     end if

!    ----- Compute Integral [ Vtrial(r).(g_l(r).Y_lm(r))^(1) dr ]
     allocate(intv_tmp(cplex,3))
     do ilslm=1,lm_size
      intv_tmp=zero
      if (nspden/=4) then
       do ic=1,pawfgrtab(iatom)%nfgd
        do mu=1,3
!        Minus sign because dg(r-R)/dR = -dg(r-R)/dr
         contrib(1)=-vloc(1,ic)*pawfgrtab(iatom)%gylmgr(mu,ic,ilslm)
         intv_tmp(1:cplex,mu)=intv_tmp(1:cplex,mu)+contrib(1)*expmiqr(1:cplex,ic)
        end do
       end do
      else ! nspden=4
       if (cplex==1) then
        do ic=1,pawfgrtab(iatom)%nfgd
         do mu=1,3
!         Minus sign because dg(r-R)/dR = -dg(r-R)/dr
          contrib(1:2)=-vloc(1:2,ic)*pawfgrtab(iatom)%gylmgr(mu,ic,ilslm)
          intv_tmp(1,mu)=intv_tmp(1,mu)+contrib(1)*expmiqr(1,ic)-contrib(2)*expmiqr(2,ic)
         end do
        end do
       else
        do ic=1,pawfgrtab(iatom)%nfgd
         do mu=1,3
!         Minus sign because dg(r-R)/dR = -dg(r-R)/dr
          contrib(1:2)=-vloc(1:2,ic)*pawfgrtab(iatom)%gylmgr(mu,ic,ilslm)
          intv_tmp(1,mu)=intv_tmp(1,mu)+contrib(1)*expmiqr(1,ic)-contrib(2)*expmiqr(2,ic)
          intv_tmp(2,mu)=intv_tmp(2,mu)+contrib(1)*expmiqr(2,ic)+contrib(2)*expmiqr(1,ic)
         end do
        end do
       end if
      end if
!     Convert from cartesian to reduced coordinates
      intv(1:cplex,ilslm)=intv(1:cplex,ilslm) &
&      +fact*(gprimd(1,idir)*intv_tmp(1:cplex,1) &
&      +gprimd(2,idir)*intv_tmp(1:cplex,2) &
&      +gprimd(3,idir)*intv_tmp(1:cplex,3))
     end do
     deallocate(vloc,intv_tmp)
    end if ! need_dijfr_1

!   2nd part: Int_R^3{Vloc^(1)*Sum_LM[Q_ij_q^LM]}
    if (need_dijfr_2) then

     if (ispden==1) then

!     ----- Retrieve potential Vloc^(1)
      allocate(vloc(cplex,nfgd))
      do ic=1,nfgd
       jc=cplex*pawfgrtab(iatom)%ifftsph(ic)-dplex
       vloc(1:cplex,ic)=vpsp1(jc:jc+dplex)
      end do

!     ----- Compute Integral [ Vloc^(1)(r).g_l(r).Y_lm(r) ]
      allocate(intvloc(cplex,lm_size));intvloc=zero
      if (cplex==1) then
       do ilslm=1,lm_size
        do ic=1,pawfgrtab(iatom)%nfgd
         contrib(1)=vloc(1,ic)*pawfgrtab(iatom)%gylmgr(mu,ic,ilslm)
         intvloc(1,mu)=intvloc(1,mu)+contrib(1)*expmiqr(1,ic)
        end do
       end do
      else
       do ilslm=1,lm_size
        do ic=1,pawfgrtab(iatom)%nfgd
         contrib(1:cplex)=vloc(1:cplex,ic)*pawfgrtab(iatom)%gylmgr(mu,ic,ilslm)
         intvloc(1,ilslm)=intvloc(1,ilslm)+contrib(1)*expmiqr(1,ic)-contrib(2)*expmiqr(2,ic)
         intvloc(2,ilslm)=intvloc(2,ilslm)+contrib(1)*expmiqr(2,ic)+contrib(2)*expmiqr(1,ic)
        end do
       end do
      end if
      deallocate(vloc)
     end if ! ispden=1

     if (ispden<=min(nspden,2)) then
      intv(1:cplex,1:lm_size)=intv(1:cplex,1:lm_size)+intvloc(1:cplex,1:lm_size)
      if (ispden==min(nspden,2)) deallocate(intvloc)
     end if
    end if ! need_dijfr_2

!   --- Reduction in case of parallelization ---
    if(mpi_enreg%paral_compil_fft==1)then
     old_paral_level= mpi_enreg%paral_level
     mpi_enreg%paral_level=3
     call xcomm_init(mpi_enreg,spaceComm)
     if(mpi_enreg%mode_para=='b') spaceComm=mpi_enreg%comm_fft
     call xsum_mpi(intv,spaceComm,ier)
     mpi_enreg%paral_level=old_paral_level
    end if

!   ---- Loop over (i,j) components
    klmn1=1
    do klmn=1,lmn2_size
     klm =pawtab(itypat)%indklmn(1,klmn)
     lmin=pawtab(itypat)%indklmn(3,klmn)
     lmax=pawtab(itypat)%indklmn(4,klmn)
     do ils=lmin,lmax,2
      lm0=ils**2+ils+1
      do mm=-ils,ils
       ilslm=lm0+mm;isel=pawang%gntselect(lm0+mm,klm)
       if (isel>0) then
        paw_ij1(iatom)%dijfr(klmn1:klmn1+cplex-1,ispden)= &
&        paw_ij1(iatom)%dijfr(klmn1:klmn1+cplex-1,ispden) &
&        +pawtab(itypat)%qijl(ilslm,klmn)*intv(1:cplex,ilslm)
       end if
      end do
     end do
     klmn1=klmn1+paw_ij1(iatom)%cplex_dij
    end do
    deallocate(intv)

!   Dijfr is marked as computed
    paw_ij1(iatom)%has_dijfr=2
   end if

!  End loop over spin components
  end do ! ispden

! Eventually free temporary space for g_l(r).Y_lm(r) gradients
  if (pawfgrtab(iatom)%gylm_allocated==2) then
   deallocate(pawfgrtab(iatom)%gylm);allocate(pawfgrtab(iatom)%gylm(0,0))
   pawfgrtab(iatom)%gylm_allocated=0
  end if
  if (pawfgrtab(iatom)%gylmgr_allocated==2) then
   deallocate(pawfgrtab(iatom)%gylmgr);allocate(pawfgrtab(iatom)%gylmgr(0,0,0))
   pawfgrtab(iatom)%gylmgr_allocated=0
  end if

! End loop on atoms
  deallocate(expmiqr)
 end do

#if defined DEBUG_MODE
 write(message,'(a)')' pawfrnhat : exit '
 call wrtout(std_out,message,'COLL')
 call flush(std_out)
#endif

end subroutine pawfrnhat
!!***
