!{\src2tex{textfont=tt}}
!!****f* ABINIT/setnoccmmp
!! NAME
!! setnoccmmp
!!
!! FUNCTION
!! PAW+U only:
!! Compute density matrix nocc_{m,m}
!! or
!! Impose value of density matrix using dmatpawu input array, then symetrize it.
!!
!! noccmmp^{\sigma}_{m,m'}=\sum_{ni,nj}[\rho^{\sigma}_{ni,nj}*phiphjint_{ni,nj}]
!!
!! COPYRIGHT
!! Copyright (C) 1998-2009 ABINIT group (BA,MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  compute_dmat= flag: if 1, nocc_{m,mp} is computed
!!  dimdmat=first dimension of dmatpawu array
!!  dmatpawu(dimdmat,dimdmat,nsppol*nspinor,natpawu)=input density matrix to be copied into noccmpp
!!  dmatudiag= flag controlling the use of diagonalization:
!!             0: no diagonalization of nocc_{m,mp}
!!             1: diagonalized nocc_{m,mp} matrix is printed
!!             2: dmatpawu matrix is expressed in the basis where nocc_(m,mp} is diagonal
!!  indsym(4,nsym,natom)=indirect indexing array for atom labels
!!  natom=number of atoms in cell
!!  natpawu=number of atoms on which PAW+U is applied
!!  nspinor=number of spinorial components of the wavefunctions
!!  nsppol=number of independant spin components
!!  nsym=number of symmetry elements in space group
!!  ntypat=number of atom types
!!  paw_ij(natom) <type(paw_ij_type)>=paw arrays given on (i,j) channels
!!  pawang <type(pawang_type)>=paw angular mesh and related data
!!  pawrhoij(natom) <type(pawrhoij_type)>= paw rhoij occupancies and related data
!!  pawtab(ntypat) <type(pawtab_type)>=paw tabulated starting data
!!  spinat(3,matom)=initial spin of each atom, in unit of hbar/2
!!  symafm(nsym)=(anti)ferromagnetic part of symmetry operations
!!  typat(natom)=type for each atom
!!  impose_dmat= flag: if 1, nocc_{m,mp} is replaced by dmatpawu
!!  useexexch=1 if local-exact-exchange is activated
!!  usepawu=1 if PAW+U is activated
!!
!! OUTPUT
!!   paw_ij(natom)%noccmmp(2*pawtab(itypat)%lpawu+1,2*pawtab(itypat)%lpawu+1,nspden)=density matrix
!!
!! NOTES
!! nocc_{m,mp} is stored as: noccmmp(:,:,1)=   n^{up,up}_{m,mp}
!!                           noccmmp(:,:,2)=   n^{dn,dn}_{m,mp}
!!                           noccmmp(:,:,3)=Re[n^{up,dn}_{m,mp}]
!!                           noccmmp(:,:,4)=Im[n^{up,dn}_{m,mp}]
!!
!! Also ready for future diagonalization of the occupation matrix.
!!
!! PARENTS
!!      afterscfloop,pawdenpot,pawprt,scfcv
!!
!! CHILDREN
!!      dgemm,dsyev,leave_new,wrtout,zgemm,zheev
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine setnoccmmp(compute_dmat,dimdmat,dmatpawu,dmatudiag,impose_dmat,indsym,natom,natpawu,&
&                     nspinor,nsppol,nsym,ntypat,paw_ij,pawang,pawprtvol,pawrhoij,pawtab,&
&                     spinat,symafm,typat,useexexch,usepawu)

 use defs_basis
  use defs_datatypes
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_linalg
!End of the abilint section

 implicit none

!Arguments ---------------------------------------------
!scalars
 integer,intent(in) :: compute_dmat,dimdmat,dmatudiag,impose_dmat,natom,natpawu
 integer,intent(in) :: nspinor,nsppol,nsym,ntypat,useexexch,usepawu
 type(pawang_type),intent(in) :: pawang
 integer,intent(in) :: pawprtvol
!arrays
 integer,intent(in) :: indsym(4,nsym,natom),symafm(nsym),typat(natom)
 real(dp),intent(in) :: dmatpawu(dimdmat,dimdmat,nspinor*nsppol,natpawu*impose_dmat)
 real(dp),intent(in) :: spinat(3,natom)
 type(paw_ij_type),intent(inout) :: paw_ij(natom)
 type(pawrhoij_type),intent(in) :: pawrhoij(natom)
 type(pawtab_type),intent(in) :: pawtab(ntypat)

!Local variables ---------------------------------------
!scalars
 integer :: at_indx,dmatudiag_loc,iafm,iatom,iatpawu,icount,ilm,im1,im2,in1,in2,info,irot,ispden
 integer :: irhoij,itypat,jlm,jm,jrhoij,jspden,klmn,kspden,lcur,ldim,lmax,lmin,lpawu,lwork,nspden,nsploop
 real(dp) :: factafm,mnorm,mx,my,mz,ntot,nup,ndn,ro,snorm,sx,sy,szp,szm,zarot2
 logical,parameter :: afm_noncoll=.true.  ! TRUE if antiferro symmetries are used with non-collinear magnetism
 logical :: antiferro,noccsym_error,use_afm
 character(len=500) :: message
!arrays
 integer :: nsym_used(2)
 real(dp) :: sumocc(2)
 real(dp),allocatable :: eig(:),hdp(:,:,:),hdp2(:,:),noccmmptemp(:,:),noccmmp_tmp(:,:,:),rwork(:)
 complex(dpc),allocatable :: zhdp(:,:),zhdp2(:,:),znoccmmp_tmp(:,:),zwork(:)
 character(len=9),parameter :: dspin(6)=(/"up       ","down     ","up-up    ","down-down","Re[up-dn]","Im[up-dn]"/)
!no_abirules
  type noccmmp_at
   real(dp),pointer :: noccmmp(:,:,:)
  end type
  type(noccmmp_at),allocatable :: tmp(:)

! *********************************************************************

!Tests
 if (nsppol/=paw_ij(1)%nsppol) then
  write(message, '(4a)' ) ch10,&
&  ' setnoccmmp: BUG - ',ch10,&
&  '   inconsistent values for nsppol !'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if
 if (compute_dmat>0) then
  if (pawrhoij(1)%nspden/=paw_ij(1)%nspden.and.&
&  pawrhoij(1)%nspden/=4.and.paw_ij(1)%nspden/=1) then
   write(message, '(4a)' ) ch10,&
&   ' setnoccmmp: BUG - ',ch10,&
&   '   inconsistent values for nspden !'
   call wrtout(6,message,'COLL')
   call leave_new('COLL')
  end if
 end if
 if (usepawu>0.and.useexexch>0) then
  write(message, '(4a)' ) ch10,&
&  ' setnoccmmp: BUG - ',ch10,&
&  '  usepawu>0 and useexexch>0 not allowed !'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if
 if (impose_dmat/=0.and.dimdmat==0) then
  write(message, '(4a)' ) ch10,&
&  ' setnoccmmp: BUG - ',ch10,&
&  '   dmatpawu must be allocated when impose_dmat/=0 !'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

!Some inits
 if (usepawu==0.and.useexexch==0) return
 nspden=paw_ij(1)%nspden
 antiferro=(nspden==2.and.nsppol==1)
 use_afm=((antiferro).or.((nspden==4).and.afm_noncoll))
 dmatudiag_loc=dmatudiag
 if (dmatudiag==2.and.(dimdmat==0.or.impose_dmat==0)) dmatudiag_loc=1

!If needed, store dmatpu in suitable format in tmp%noccmmp
 if (usepawu>0.and.impose_dmat/=0) then
  iatpawu=0
  allocate(tmp(natom))
  do iatom=1,natom
   lpawu=pawtab(typat(iatom))%lpawu
   if (lpawu/=-1) then
    iatpawu=iatpawu+1
    if (nspden/=4) then
     allocate(tmp(iatom)%noccmmp(2*lpawu+1,2*lpawu+1,nsppol))
     tmp(iatom)%noccmmp(1:2*lpawu+1,1:2*lpawu+1,1:nsppol)=&
&     dmatpawu(1:2*lpawu+1,1:2*lpawu+1,1:nsppol,iatpawu)
    else
     allocate(tmp(iatom)%noccmmp(2*lpawu+1,2*lpawu+1,nspden))
     snorm=sqrt(spinat(1,natom)**2+spinat(1,iatom)**2+spinat(3,iatom)**2)
     if (snorm>tol12) then
      sx=half*spinat(1,iatom)/snorm
      sy=half*spinat(2,iatom)/snorm
      szp=half*(one+spinat(3,iatom)/snorm)
      szm=half*(one-spinat(3,iatom)/snorm)
     else
      sx=zero;sy=zero
      szp=one;szm=zero
     end if
     do im2=1,2*lpawu+1
      do im1=1,2*lpawu+1
       nup=dmatpawu(im1,im2,1,iatpawu);ndn=dmatpawu(im1,im2,2,iatpawu)
       tmp(iatom)%noccmmp(im1,im2,1)=nup*szp+ndn*szm
       tmp(iatom)%noccmmp(im1,im2,2)=nup*szm+ndn*szp
       tmp(iatom)%noccmmp(im1,im2,3)=(nup-ndn)*sx
       tmp(iatom)%noccmmp(im1,im2,4)=(ndn-nup)*sy
      end do
     end do
    end if
   end if
  end do
 end if  ! impose_dmat/=0

!Print message
 if (usepawu>0.and.impose_dmat/=0) then
  if (dmatudiag_loc/=2) then
   write(message,'(6a)') ch10,'Occupation matrix for correlated orbitals is kept constant',ch10,&
&   'and equal to dmatpawu from input file !',ch10,&
&   '----------------------------------------------------------'
  else
   write(message,'(6a)') ch10,'Occupation matrix for correlated orbitals is imposed',ch10,&
&   'and equal to dmatpawu in the diagonal basis !',ch10,&
&   '----------------------------------------------------------'
  end if
  call wrtout(6,message,'COLL')
 end if

 if (usepawu>0.and.dmatudiag_loc/=0) then
  write(message,'(4a)') ch10,'Diagonalized occupation matrix "noccmmp" is printed !',ch10,&
&  '-------------------------------------------------------------'
  call wrtout(6,message,'COLL')
 end if

!Loops over atoms
 do iatom=1,natom
  itypat=typat(iatom)
  if (useexexch>0) then
   lcur=pawtab(itypat)%lexexch
  else if (usepawu>0) then
   lcur=pawtab(itypat)%lpawu
  end if
  if (lcur/=-1) then

!  ########################################################################################
!  # Compute nocc_mmp
!  ########################################################################################
   if ((usepawu>0.and.compute_dmat/=0).or.useexexch>0) then

    paw_ij(iatom)%noccmmp(:,:,:)=zero

!   Loop over spin components
    do ispden=1,nspden
     allocate(noccmmptemp(2*lcur+1,2*lcur+1));noccmmptemp(:,:)=zero
     jrhoij=1
     do irhoij=1,pawrhoij(iatom)%nrhoijsel
      klmn=pawrhoij(iatom)%rhoijselect(irhoij)
      im1=pawtab(itypat)%klmntomn(1,klmn)
      im2=pawtab(itypat)%klmntomn(2,klmn)
      in1=pawtab(itypat)%klmntomn(3,klmn)
      in2=pawtab(itypat)%klmntomn(4,klmn)
      lmin=pawtab(itypat)%indklmn(3,klmn)
      lmax=pawtab(itypat)%indklmn(4,klmn)
      if (nspden==1) then
       ro=half*pawrhoij(iatom)%rhoijp(jrhoij,1)
      else if (nspden==2) then
       ro=pawrhoij(iatom)%rhoijp(jrhoij,ispden)
      else
!      Non-collinear magnetism: transfer rhoij from (n,m) storage to (n^11,n^22,Re[n^12],Im[n^12])
       if (ispden==1) then
        ro=half*(pawrhoij(iatom)%rhoijp(jrhoij,1)+pawrhoij(iatom)%rhoijp(jrhoij,4))
       else if (ispden==2) then
        ro=half*(pawrhoij(iatom)%rhoijp(jrhoij,1)-pawrhoij(iatom)%rhoijp(jrhoij,4))
       else if (ispden==3) then
        ro=half*pawrhoij(iatom)%rhoijp(jrhoij,2)
       else  ! (ispden==4)
        ro=-half*pawrhoij(iatom)%rhoijp(jrhoij,3)
       end if
      end if
      if(lmin==0.and.lmax==2*lcur) then
       icount=in1+(in2*(in2-1))/2
       if(pawtab(itypat)%ij_proj<icount)  then
        write(message, '(4a)' ) ch10,&
&        '  setnoccmmp : BUG -',ch10,&
&        '  PAW+U: Problem in the loop for calculating noccmmp !',ch10
        call wrtout(6,message,'COLL')
        call leave_new('COLL')
       end if
       if(in1/=in2) then
        if(im2<=im1) then
         noccmmptemp(im1,im2)=noccmmptemp(im1,im2)+ro*pawtab(itypat)%phiphjint(icount)
        end if
       end if
       if(im2>=im1) then
        paw_ij(iatom)%noccmmp(im1,im2,ispden)=paw_ij(iatom)%noccmmp(im1,im2,ispden) &
&        +ro*pawtab(itypat)%phiphjint(icount)
       end if
      end if
      jrhoij=jrhoij+pawrhoij(iatom)%cplex
     end do ! irhoij
     do im2=1,2*lcur+1
      do im1=1,im2
       paw_ij(iatom)%noccmmp(im1,im2,ispden)=paw_ij(iatom)%noccmmp(im1,im2,ispden) &
&       +noccmmptemp(im2,im1)
      end do
     end do
     do im1=1,2*lcur+1
      do im2=1,im1
       paw_ij(iatom)%noccmmp(im1,im2,ispden)=paw_ij(iatom)%noccmmp(im2,im1,ispden)
      end do
     end do
     deallocate(noccmmptemp)
    end do ! ispden

!   Compute total number of electrons per spin
    paw_ij(iatom)%nocctot(:)=zero
    do ispden=1,nspden
     do im1=1,2*lcur+1
      paw_ij(iatom)%nocctot(ispden)=paw_ij(iatom)%nocctot(ispden) &
&      +paw_ij(iatom)%noccmmp(im1,im1,ispden)
     end do
    end do

!   Printing of new nocc_mmp
    if (usepawu>0) write(message, '(2a)' )  ch10,'========== LDA+U DATA =================================================== '
    if (useexexch>0) write(message, '(2a)' )ch10,'======= Local ex-exchange (PBE0) DATA =================================== '
    call wrtout(6,message,'COLL')
    write(message,'(2a,i5,a,i4,a)') ch10,"====== For Atom", iatom,&
&    ", occupations for correlated orbitals. l =",lcur,ch10
    call wrtout(6,message,'COLL')
    if(nspden==2) then
     do ispden=1,2
      write(message,'(a,i4,3a,f10.5)') "Atom", iatom,". Occupations for spin ",&
&      trim(dspin(ispden))," =",paw_ij(iatom)%nocctot(ispden)
      call wrtout(6,message,'COLL')
     end do
     write(message,'(a,i4,a,2x,e16.8)') "=> On atom",iatom,", local Mag. is  ",&
&     paw_ij(iatom)%nocctot(2)-paw_ij(iatom)%nocctot(1)
     call wrtout(6,message,'COLL')
    end if
    if(nspden==4) then
     mx= two*paw_ij(iatom)%nocctot(3)
     my=-two*paw_ij(iatom)%nocctot(4)
     mz=paw_ij(iatom)%nocctot(1)-paw_ij(iatom)%nocctot(2)
     ntot=paw_ij(iatom)%nocctot(1)+paw_ij(iatom)%nocctot(2)
     mnorm=sqrt(mx*mx+my*my+mz*mz)
     write(message,'(a,i4,a,2x,e16.8)') "=> On atom",iatom,", local Mag. x is ",mx
     call wrtout(6,message,'COLL')
     write(message,'(14x,a,2x,e16.8)') "  local Mag. y is ",my
     call wrtout(6,message,'COLL')
     write(message,'(14x,a,2x,e16.8)') "  local Mag. z is ",mz
     call wrtout(6,message,'COLL')
     write(message,'(14x,a,2x,e16.8)') "  norm of Mag. is ",mnorm
     call wrtout(6,message,'COLL')
     write(message,'(14x,a,2x,f10.5)') "  occ. for spin up is ",half*(ntot+mnorm)
     call wrtout(6,message,'COLL')
     write(message,'(14x,a,2x,f10.5)') "  occ. for spin dn is ",half*(ntot-mnorm)
     call wrtout(6,message,'COLL')
    end if
    write(message,'(2a)') ch10,"== Calculated occupation matrix for correlated orbitals:"
    call wrtout(6,message,'COLL')
    do ispden=1,nspden
     write(message,'(3a)') ch10,"Calculated occupation matrix for component ",trim(dspin(ispden+2*(nspden/4)))
     call wrtout(6,message,'COLL')
     do im1=1,lcur*2+1
      write(message,'(12(1x,9(1x,f10.5)))') (paw_ij(iatom)%noccmmp(im1,im2,ispden),im2=1,lcur*2+1)
      call wrtout(6,message,'COLL')
     end do
    end do

   end if ! impose_dmat==0

!  ########################################################################################
!  # Diagonalize nocc_mmp
!  ########################################################################################
   if(usepawu>0.and.dmatudiag_loc>0) then

    lpawu=lcur;ldim=2*lpawu+1
    allocate(noccmmp_tmp(ldim,ldim,nspden))
    if (nspden==4) allocate(znoccmmp_tmp(2*ldim,2*ldim))

!   Select noccmmp for this atom
    do ispden=1,nspden
     noccmmp_tmp(:,:,ispden)=paw_ij(iatom)%noccmmp(:,:,ispden)
    end do
    if (nspden==4) then
     do im2=1,ldim
      do im1=1,ldim
       znoccmmp_tmp(     im1,     im2)=cmplx(noccmmp_tmp(im1,im2,1),zero,kind=dp)
       znoccmmp_tmp(ldim+im1,ldim+im2)=cmplx(noccmmp_tmp(im1,im2,2),zero,kind=dp)
       znoccmmp_tmp(     im1,ldim+im2)=cmplx(noccmmp_tmp(im1,im2,3),+noccmmp_tmp(im1,im2,4),kind=dp)
       znoccmmp_tmp(ldim+im1,     im2)=cmplx(noccmmp_tmp(im2,im1,3),-noccmmp_tmp(im2,im1,4),kind=dp)
      end do
     end do
    end if

!   Diagonalize nocc_mmp
    if (nspden/=4) then
     allocate(hdp(ldim,ldim,nspden));hdp=zero
     lwork=3*ldim-1;allocate(rwork(lwork),eig(ldim))
     do ispden=1,nspden
      call DSYEV('v','u',ldim,noccmmp_tmp(:,:,ispden),ldim,eig,rwork,lwork,info)
      if(info/=0) then
       write(message,'(4a)') ch10,'Error in diagonalization of noccmmp (DSYEV)!'
       call wrtout(6,message,'COLL');call leave_new('COLL')
      end if
      do ilm=1,ldim
       hdp(ilm,ilm,ispden)=eig(ilm)
      end do
     end do ! ispden
     deallocate(rwork,eig)
    else
     allocate(hdp(2*ldim,2*ldim,1));hdp=zero
     lwork=4*ldim-1;allocate(rwork(6*ldim-2),zwork(lwork),eig(2*ldim))
     call ZHEEV('v','u',2*ldim,znoccmmp_tmp,2*ldim,eig,zwork,lwork,rwork,info)
     if(info/=0) then
      write(message,'(4a)') ch10,'Error in diagonalization of noccmmp (ZHEEV) !'
      call wrtout(6,message,'COLL');call leave_new('COLL')
     end if
     do ilm=1,2*ldim
      hdp(ilm,ilm,1)=eig(ilm)
     end do
     deallocate(rwork,zwork,eig)
    end if

!   Print diagonalized matrix and eigenvectors
    do ispden=1,size(hdp,3)
     write(message,'(2a,i3,a)') ch10,'== Atom ',iatom,' == Diagonalized Occupation matrix'
     if (nspden==1) write(message,fmt='(2a)')     trim(message)," for spin up =="
     if (nspden==2) write(message,fmt='(2a,i3,a)')trim(message)," for spin ",ispden," =="
     if (nspden==4) write(message,fmt='(2a,i3,a)')trim(message)," =="
     call wrtout(6,message,'COLL')
     do ilm=1,size(hdp,1)
      write(message,'(12(1x,9(1x,f10.5)))') (hdp(ilm,jlm,ispden),jlm=1,size(hdp,2))
      call wrtout(6,message,'COLL')
     end do
    end do ! ispden
    if(abs(pawprtvol)>=1) then
     if (nspden/=4) then
      do ispden=1,nspden
       write(message,'(2a,i3,a)') ch10,'== Atom ',iatom,' == Eigenvectors'
       if (nspden==1) write(message,fmt='(2a)')     trim(message),' for spin up =='
       if (nspden==2) write(message,fmt='(2a,i3,a)')trim(message),' for spin ',ispden,' =='
       call wrtout(6,message,'COLL')
       do ilm=1,ldim
        write(message,'(12(1x,9(1x,f10.5)))') (noccmmp_tmp(ilm,jlm,ispden),jlm=1,ldim)
        call wrtout(6,message,'COLL')
       end do
      end do
     else
      write(message,'(2a,i3,a)') ch10,'== Atom ',iatom,' == Eigenvectors (spinors) =='
      call wrtout(6,message,'COLL')
      do ilm=1,2*ldim
       write(message,'(12(1x,9(1x,"(",f7.3,",",f7.3,")")))') (znoccmmp_tmp(ilm,jlm),jlm=1,2*ldim)
       call wrtout(6,message,'COLL')
      end do
     end if
    end if

!   Back rotation of diagonalized matrix and printing
    if(abs(pawprtvol)>=1) then
     if (nspden/=4) then
      allocate(hdp2(ldim,ldim))
      do ispden=1,nspden
       call dgemm('n','t',ldim,ldim,ldim,one,hdp(:,:,ispden),ldim,noccmmp_tmp(:,:,ispden),ldim,zero,hdp2,ldim)
       call dgemm('n','n',ldim,ldim,ldim,one,noccmmp_tmp(:,:,ispden),ldim,hdp2,ldim,zero,hdp(:,:,ispden),ldim)
       noccmmp_tmp(:,:,ispden)=hdp(:,:,ispden)
      end do ! ispden
      deallocate(hdp2)
     else
      allocate(zhdp(2*ldim,2*ldim),zhdp2(2*ldim,2*ldim))
      zhdp(:,:)=cmplx(hdp(:,:,1),zero,kind=dp)
      call zgemm('n','c',2*ldim,2*ldim,2*ldim,cone,zhdp,2*ldim,znoccmmp_tmp,2*ldim,czero,zhdp2,2*ldim)
      call zgemm('n','n',2*ldim,2*ldim,2*ldim,cone,znoccmmp_tmp,2*ldim,zhdp2,2*ldim,czero,zhdp,2*ldim)
      do jlm=1,ldim
       do ilm=1,ldim
        noccmmp_tmp(ilm,jlm,1)= real(zhdp(     ilm,     jlm))
        noccmmp_tmp(ilm,jlm,2)= real(zhdp(ldim+ilm,ldim+jlm))
        noccmmp_tmp(ilm,jlm,3)= real(zhdp(     ilm,ldim+jlm))
        noccmmp_tmp(ilm,jlm,4)=aimag(zhdp(     ilm,ldim+jlm))
       end do
      end do
      deallocate(zhdp,zhdp2)
     end if
     do ispden=1,nspden
      write(message,'(2a,i3,a)') ch10,'== Atom ',iatom,&
&      ' == Rotated back diagonalized matrix'
      if (nspden==1) write(message,fmt='(2a)')     trim(message)," for spin up =="
      if (nspden==2) write(message,fmt='(2a,i3,a)')trim(message)," for spin ",ispden," =="
      if (nspden==4) write(message,fmt='(4a)')     trim(message)," for component ", &
&      trim(dspin(ispden+2*(nspden/4)))," =="
      call wrtout(6,message,'COLL')
      do ilm=1,ldim
       write(message,'(12(1x,9(1x,f10.5)))') (noccmmp_tmp(ilm,jlm,ispden),jlm=1,ldim)
       call wrtout(6,message,'COLL')
      end do
     end do ! ispden
    end if
    deallocate(hdp)

   end if ! dmatudiag_loc

!  ########################################################################################
!  # Impose value of nocc_mmp from dmatpu; symetrize it
!  ########################################################################################
   if (usepawu>0.and.impose_dmat/=0) then

    lpawu=lcur
    nsploop=nsppol;if (nspden==4) nsploop=4
    noccsym_error=.false.

!   Loop over spin components
    do ispden=1,nsploop
     if (nspden/=4) then
      jspden=min(3-ispden,paw_ij(iatom)%nsppol)
     else if (ispden<=2) then
      jspden=3-ispden
     else
      jspden=ispden
     end if

!    Loops over components of nocc_mmp
     do jlm=1,2*lpawu+1
      do ilm=1,2*lpawu+1

       if(nsym>1) then

        nsym_used(1:2)=0
        sumocc(1:2)=zero

!       Accumulate values of nocc_mmp over symmetries
        do irot=1,nsym
         if ((symafm(irot)/=1).and.(.not.use_afm)) cycle
         kspden=ispden;if (symafm(irot)==-1) kspden=jspden
         factafm=one;if (ispden>3) factafm=dble(symafm(irot))
         iafm=1;if ((antiferro).and.(symafm(irot)==-1)) iafm=2
         nsym_used(iafm)=nsym_used(iafm)+1
         at_indx=indsym(4,irot,iatom)
         do im2=1,2*lpawu+1
          do im1=1,2*lpawu+1
!          Be careful: use here R_rel^-1 in term of spherical harmonics
!          which is tR_rec in term of spherical harmonics
!          so, use transpose[zarot]
           sumocc(iafm)=sumocc(iafm)+factafm*tmp(at_indx)%noccmmp(im1,im2,kspden) &
&           *pawang%zarot(im1,ilm,lpawu+1,irot)&
&           *pawang%zarot(im2,jlm,lpawu+1,irot)
!          sumocc(iafm)=sumocc(iafm)+factafm*tmp(at_indx)%noccmmp(im1,im2,kspden) &
!          &                     *pawang%zarot(ilm,im1,lpawu+1,irot)&
!          &                     *pawang%zarot(jlm,im2,lpawu+1,irot)
          end do
         end do
        end do ! End loop over symmetries

!       Store new values of nocc_mmp
        paw_ij(iatom)%noccmmp(ilm,jlm,ispden)=sumocc(1)/nsym_used(1)
        if (.not.noccsym_error) noccsym_error=(abs(paw_ij(iatom)%noccmmp(ilm,jlm,ispden)-tmp(iatom)%noccmmp(ilm,jlm,ispden))>tol6)

!       Antiferromagnetic case: has to fill up "down" component of nocc_mmp
        if (antiferro.and.nsym_used(2)>0) paw_ij(iatom)%noccmmp(ilm,jlm,2)=sumocc(2)/nsym_used(2)

       else  ! nsym=1

!       Case without symetries
        paw_ij(iatom)%noccmmp(ilm,jlm,ispden)= tmp(iatom)%noccmmp(ilm,jlm,ispden)
       end if

      end do !ilm
     end do !jlm
    end do ! ispden

!   Printing of new nocc_mmp
    do ispden=1,nspden
     if(dmatudiag_loc==2) then
      write(message,'(2a,i3,a)') ch10,'== Atom ',iatom,&
&      ' == Imposed occupation matrix (in the basis of diagonalization!!)'
     else
      write(message,'(2a,i3,a)') ch10,'== Atom ',iatom,&
&      ' == Imposed occupation matrix'
     end if
     if (nspden==1) write(message,fmt='(2a)')     trim(message)," for spin up =="
     if (nspden==2) write(message,fmt='(2a,i3,a)')trim(message)," for spin ",ispden," =="
     if (nspden==4) write(message,fmt='(4a)')     trim(message)," for component ", &
&     trim(dspin(ispden+2*(nspden/4)))," =="
     call wrtout(6,message,'COLL')
     do ilm=1,2*lpawu+1
      write(message,'(12(1x,9(1x,f10.5)))') (paw_ij(iatom)%noccmmp(ilm,jlm,ispden),jlm=1,2*lpawu+1)
      call wrtout(6,message,'COLL')
     end do
    end do

!   WARNING if symmetrization changes the matrix
    if (noccsym_error) then
     write(message, '(4a,i4,6a)' ) ch10,&
&     ' setnoccmmp: WARNING - ',ch10,&
&     '   After symmetrization, imposed occupation matrix for atom ',iatom,ch10,&
&     '   is different from dmatpawu value set in input file !',ch10,&
&     '   It is likely that dmatpawu does not match the symmetry operations of the system.',ch10,&
&     '   Action: change dmatpawu in input file.'
     call wrtout(6,message,'COLL')
    end if

   end if ! impose_dmat/=0

!  ########################################################################################
!  # Rotate imposed occupation matrix in the non-diagonal basis
!  ########################################################################################
   if (usepawu>0.and.impose_dmat/=0.and.dmatudiag_loc==2) then

    lpawu=lcur;ldim=2*lpawu+1

!   Rotation of imposed nocc_mmp
    if (nspden/=4) then
     allocate(hdp2(ldim,ldim))
     do ispden=1,nspden
      call dgemm('n','t',ldim,ldim,ldim,one,paw_ij(iatom)%noccmmp(:,:,ispden),ldim,noccmmp_tmp(:,:,ispden),ldim,zero,hdp2,ldim)
      call dgemm('n','n',ldim,ldim,ldim,one,noccmmp_tmp(:,:,ispden),ldim,hdp2,ldim,zero,paw_ij(iatom)%noccmmp(:,:,ispden),ldim)
     end do ! ispden
     deallocate(hdp2)
    else
     allocate(zhdp(2*ldim,2*ldim),zhdp2(2*ldim,2*ldim))
     do im2=1,ldim
      do im1=1,ldim
       zhdp(     im1,     im2)=cmplx(paw_ij(iatom)%noccmmp(im1,im2,1),zero,kind=dp)
       zhdp(ldim+im1,ldim+im2)=cmplx(paw_ij(iatom)%noccmmp(im1,im2,2),zero,kind=dp)
       zhdp(     im1,ldim+im2)=cmplx(paw_ij(iatom)%noccmmp(im1,im2,3),+paw_ij(iatom)%noccmmp(im1,im2,4),kind=dp)
       zhdp(ldim+im1,     im2)=cmplx(paw_ij(iatom)%noccmmp(im2,im1,3),-paw_ij(iatom)%noccmmp(im2,im1,4),kind=dp)
      end do
     end do
     call zgemm('n','c',2*ldim,2*ldim,2*ldim,cone,zhdp,2*ldim,znoccmmp_tmp,2*ldim,czero,zhdp2,2*ldim)
     call zgemm('n','n',2*ldim,2*ldim,2*ldim,cone,znoccmmp_tmp,2*ldim,zhdp2,2*ldim,czero,zhdp,2*ldim)
     do jlm=1,ldim
      do ilm=1,ldim
       paw_ij(iatom)%noccmmp(ilm,jlm,1)= real(znoccmmp_tmp(     ilm,     jlm))
       paw_ij(iatom)%noccmmp(ilm,jlm,2)= real(znoccmmp_tmp(ldim+ilm,ldim+jlm))
       paw_ij(iatom)%noccmmp(ilm,jlm,3)= real(znoccmmp_tmp(     ilm,ldim+jlm))
       paw_ij(iatom)%noccmmp(ilm,jlm,4)=aimag(znoccmmp_tmp(     ilm,ldim+jlm))
      end do
     end do
     deallocate(zhdp,zhdp2)
    end if

!   Printing of rotated imposed matrix
    do ispden=1,nspden
     write(message,'(2a,i3,a)') ch10,'== Atom ',iatom,&
&     ' == Imposed density matrix in original basis'
     if (nspden==1) write(message,fmt='(2a)')     trim(message)," for spin up =="
     if (nspden==2) write(message,fmt='(2a,i3,a)')trim(message)," for spin ",ispden," =="
     if (nspden==4) write(message,fmt='(4a)')     trim(message)," for component ", &
&     trim(dspin(ispden+2*(nspden/4)))," =="
     call wrtout(6,message,'COLL')
     do ilm=1,2*lpawu+1
      write(message,'(12(1x,9(1x,f10.5)))') (paw_ij(iatom)%noccmmp(ilm,jlm,ispden),jlm=1,2*lpawu+1)
      call wrtout(6,message,'COLL')
     end do
    end do ! ispden

   end if ! dmatudiag_loc==2

   if (usepawu>0.and.dmatudiag_loc>0) then
    deallocate(noccmmp_tmp)
    if (nspden==4) deallocate(znoccmmp_tmp)
   end if

  end if ! lcur
 end do ! iatom

!Memory deallocation
 if (usepawu>0.and.impose_dmat/=0) then
  do iatom=1,natom
   lpawu=pawtab(typat(iatom))%lpawu
   if (lpawu/=-1) deallocate(tmp(iatom)%noccmmp)
  end do
  deallocate(tmp)
 end if

end subroutine setnoccmmp
!!***
