!{\src2tex{textfont=tt}}
!!****f* ABINIT/mlwfovlp_pw
!! NAME
!! mlwfovlp_pw
!!
!! FUNCTION
!! Routine which computes PW part of overlap M_{mn}(k,b) 
!! for Wannier code (www.wannier.org f90 version).
!!
!! COPYRIGHT
!! Copyright (C) 2005-2009 ABINIT group (BAmadon,FJollet)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  cg(2,mpw*nspinor*mband*mkmem*nsppol)=planewave coefficients of wavefunctions.
!!  dtset <type(dataset_type)>=all input variables for this dataset
!!  g1(3,nkpt,nntot) = G vector shift which is necessary to obtain k1+b
!!  iwav(nsppol,nkpt,mbandw): shift for pw components in cg.
!!  kg(3,mpw*mkmem)=reduced planewave coordinates.
!!  mband=maximum number of bands
!!  mgfft=maximum size of 1D FFTs
!!  mkmem =number of k points which can fit in memory; set to 0 if use disk
!!  mpsang= 1+maximum angular momentum for nonlocal pseudopotentials
!!  mpw=maximum dimensioned size of npw.
!!  natom=number of atoms in cell.
!!  nfft=(effective) number of FFT grid points (for this processor) (see NOTES at beginning of scfcv)
!!  ngfft(18)=contain all needed information about 3D FFT (see NOTES at beginning of scfcv)
!!  nkpt=number of k points.
!!  npwarr(nkpt)=number of planewaves in basis at this k point
!!  nspden=number of spin-density components
!!  nspinor=number of spinorial components of the wavefunctions
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  ntypat=number of types of atoms in unit cell.
!!  ovikp(nkpt,nntot)= gives  nntot value of k2 (in the BZ) for each k1  (k2=k1+b mod(G))
!!  prtvol=control print volume and debugging output
!!
!! OUTPUT
!!  cm1(2,nkpt,nntot,mbandw,mbandw): overlap <u_(nk1)|u_(mk1+b)>.

!!
!! SIDE EFFECTS
!!  (only writing, printing)
!!
!! NOTES
!!
!! PARENTS
!!      mlwfovlp
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 subroutine mlwfovlp_pw(cg,cm1,dtset,g1,invpwk,iwav,kg,mband,mbandw,mkmem,mpsang,mpw,natom,&
& nfft,ngfft,nkpt,nntot,npwarr,nspden,nspinor,nsppol,ntypat,ovikp,prtvol)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: mband,mbandw,mkmem,mpsang,mpw,natom,nfft,nkpt,nntot
 integer,intent(in) :: nspden,nspinor,nsppol,ntypat,prtvol
 type(dataset_type),intent(in) :: dtset
!arrays
 integer,intent(in) :: g1(3,nkpt,nntot),kg(3,mpw*mkmem),ngfft(18),npwarr(nkpt)
 integer,intent(in) :: invpwk(nkpt,nfft),iwav(nsppol,nkpt,mband)
 integer,intent(in) :: ovikp(nkpt,nntot)
 real(dp),intent(in) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
 real(dp),intent(out) :: cm1(2,nkpt,nntot,mband,mband)

!Local variables-------------------------------
!scalars
 integer :: iband,iband1,iband2,icgtemp,icpb,icspol,idum,ig,ig1,ig1b,ig2,ig2b
 integer :: ig3,ig3b,igk1,igk2,ii,ikg,ikpt,ikpt1,ikpt2,imntot,intot,ispden
 integer :: ispinor,isppol,n1,n2,n3,nband_k,npoint,npoint2,npw_k
 character(len=500) :: message
 character(len=fnlen) :: fildata

!************************************************************************

 write(message, '(a,a)' ) ch10,&
& '** mlwfovlp_pw : compute pw part of overlap'
 call wrtout(06,  message,'COLL')

!MJV 6/2008 : added error checking
 if (mkmem /= nkpt) then
  write(message, '(a,a,a,a)' ) ch10,&
&  '** mlwfovlp_pw : not all kpoints are in memory, or you are using this in parallel.',&
&  ch10,'Action: run a sequential job with mkmem = nkpt'
  call wrtout(06,  message,'COLL')
  call leave_new('COLL')
 end if

 n1=ngfft(1) ; n2=ngfft(2) ; n3=ngfft(3)

!***********************************************************************
!**calculate overlap M_{mn}(k,b)=<\Psi_{k,m}|e^{-ibr}|\Psi_{k+b,n}>*****
!***********************************************************************
 write(message, '(a,a)' ) ch10,&
& '   mlwfovlp_pw : compute overlaps '
 call wrtout(06,  message,'COLL')
 write(message, '(a,a)' ) ch10,&
& "     nkpt  nntot  mbandw  mbandw"
 call wrtout(06,  message,'COLL')
 write(message, '(i6,2x,i6,2x,i6,2x,i6)' ) &
& nkpt,nntot,mbandw,mbandw
 call wrtout(06,  message,'COLL')
 cm1=zero
 write(message, '(a)' )  '  '
 call wrtout(06,  message,'COLL')
 do isppol=1,nsppol
  imntot=0
  do ikpt1=1,nkpt
   write(message, '(a,i6)' ) &
&   '   compute overlaps for k-point=',ikpt1
   call wrtout(06,  message,'COLL')
   do intot=1,nntot
    imntot=imntot+1
    ikpt2= ovikp(ikpt1,intot)
    do ig3=1,n3
     do ig2=1,n2
      do ig1=1,n1
!      write(6,*) isppol,ikpt1,iband1,iband2,intot
       npoint=ig1+(ig2-1)*n1+(ig3-1)*n2*n1
       if(npoint.gt.nfft) then
        write(6,*) "error npoint  b"
        stop
       end if
       ig1b=ig1+g1(1,ikpt1,intot)
       ig2b=ig2+g1(2,ikpt1,intot)
       ig3b=ig3+g1(3,ikpt1,intot)
!      write(6,*) ig1,ig2,ig3
!      write(6,*) ig1b,ig2b,ig3b
       if(ig1b.lt.1) ig1b=ig1b+n1
       if(ig2b.lt.1) ig2b=ig2b+n2
       if(ig3b.lt.1) ig3b=ig3b+n3
       if(ig1b.gt.n1) ig1b=ig1b-n1
       if(ig2b.gt.n2) ig2b=ig2b-n2
       if(ig3b.gt.n3) ig3b=ig3b-n3
       npoint2=ig1b+(ig2b-1)*n1+(ig3b-1)*n2*n1
       if(npoint2.gt.nfft) then
        write(6,*)"error npoint  c"
        stop
       end if
       igk1=invpwk(ikpt1,npoint)
       igk2=invpwk(ikpt2,npoint2)
       if(igk1/=-1.and.igk2/=-1) then
        do iband1=1,mbandw
         do iband2=1,mbandw
          cm1(1,ikpt1,intot,iband1,iband2)=cm1(1,ikpt1,intot,iband1,iband2)+ &
&          cg(1,igk1+iwav(isppol,ikpt1,iband1))*cg(1,igk2+iwav(isppol,ikpt2,iband2))&
&          + cg(2,igk1+iwav(isppol,ikpt1,iband1))*cg(2,igk2+iwav(isppol,ikpt2,iband2))
          cm1(2,ikpt1,intot,iband1,iband2)=cm1(2,ikpt1,intot,iband1,iband2)+ &
&          cg(1,igk1+iwav(isppol,ikpt1,iband1))*cg(2,igk2+iwav(isppol,ikpt2,iband2))&
&          - cg(2,igk1+iwav(isppol,ikpt1,iband1))*cg(1,igk2+iwav(isppol,ikpt2,iband2))
!         write(1111,*) ikpt1,intot,iband1,iband2
!         write(1111,*) iwav(isppol,ikpt1,iband1),iwav(isppol,ikpt2,iband2)
!         write(1111,*) ig3,ig2,ig1, cm1(1,ikpt1,intot,iband1,iband2), cm1(2,ikpt1,intot,iband1,iband2)
         end do ! iband2
        end do ! iband1
       end if
      end do
     end do
    end do
   end do ! intot
  end do ! ikpt1
 end do ! isppol

!DEBUG
!write(6,*)' mlwfovlp_pw : exit'
!stop
!ENDDEBUG

 end subroutine mlwfovlp_pw
!!***
