!{\src2tex{textfont=tt}}
!!****f* ABINIT/uderiv
!! NAME
!! uderiv
!!
!! FUNCTION
!! This routine is called in scfcv.f to compute the derivative of
!! ground-state wavefunctions with respect to k (du/dk) by finite differencing
!! on neighbouring k points
!! Work for nsppol=1 or 2, but only accept nspinor=1,
!!
!! COPYRIGHT
!! Copyright (C) 2001-2009 ABINIT group (NSAI).
!!
!! INPUTS
!!  bdberry(4)=band limits for Berry phase contributions (or du/dk)
!!   spin up and spin down (bdberry(3:4) is irrelevant when nsppol=1)
!!  cg(2,mpw*nspinor*mband*mkmem*nsppol)=planewave coefficients of wavefunctions
!!  gprimd(3,3)=reciprocal space dimensional primitive translations
!!  hdr <type(hdr_type)>=the header of wf, den and pot files
!!  istwfk(nkpt_)=input option parameter that describes the storage of wfs
!!  kberry(3,20)= different delta k for Berry phases(or du/dk),
!!   in unit of kptrlatt only kberry(1:3,1:nberry) is relevant
!!  kg(3,mpw*mkmem)=reduced planewave coordinates
!!  kpt_(3,nkpt_)=reduced coordinates of k points generated by ABINIT,
!!               kpt_ samples half the BZ if time-reversal symetrie is used
!!  kptopt=2 when time-reversal symmetry is used
!!  kptrlatt(3,3)=k-point lattice specification
!!  mband=maximum number of bands
!!  mgfft=maximum size of 1D FFTs
!!  mkmem=number of k points which can fit in memory; set to 0 if use disk
!!  mpi_enreg=informations about MPI parallelization
!!  mpw=maximum dimensioned size of npw
!!  natom=number of atoms in cell
!!  nband(nkpt*nsppol)=number of bands at each k point, for each polarization
!!  nberry=number of Berry phases(or du/dk) to be computed
!!  nkpt=number of k points
!!  npwarr(nkpt)=number of planewaves in basis at this k point
!!  nspinor=number of spinorial components of the wavefunctions
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  rprimd(3,3)=dimensional real space primitive translations (bohr)
!!  unddk=unit number for ddk file
!!  unkg=unit number for (k+G) basis sphere data
!!  wffnow=struct info for wf disk file
!!
!! OUTPUT
!!  (the ddk wavefunctions are written on disk)
!!
!! SIDE EFFECTS
!!
!! TODO
!!  Cleaning, checking for rules
!!  Should allow for time-reversal symmetry (istwfk)
!!  WARNING : the use of nspinor is completely erroneous
!!
!! NOTES
!! Local Variables:
!!  cmatrix(:,:,:)= overlap matrix of size maxband*maxband
!!  cg_index(:,:,:)= unpacked cg index array for specific band,
!!   k point and polarization.
!!  det(2,2)= intermediate output of Lapack routine zgedi.f
!!  dk(3)= step taken to the next k mesh point along the kberry direction
!!  gpard(3)= dimensionalreciprocal lattice vector G along which the
!!          polarization is computed
!!  kg_kpt(:,:,:)= unpacked reduced planewave coordinates with subscript of
!!          planewave and k point
!!  kpt(3,nkpt)=reduced coordinates of k-point grid that samples the whole BZ
!!  kpt_flag(nkpt)=kpt_flag(ikpt)=0 when the wf was generated by the ABINIT
!!                 code
!!                 kpt_flag(ikpt) gives the indices of the k-point
!!                 related to ikpt by time revers
!!  kpt_mark(nkpt)= 0, if k point is unmarked; 1, if k point has been marked
!!  maxband/minband= control the minimum and maximum band calculated in the
!!           overlap matrix
!!  npw_k= npwarr(ikpt), number of planewaves in basis at this k point
!!  shift_g_2(nkpt,nkpt)= .true. if the k point should be shifted by a G vector;
!!  .false. if not
!!  tr(2)=variable that changes k to -k
!!                              G to -G
!!                     $c_g$ to $c_g^*$ when time-reversal symetrie is used
!!
!! PARENTS
!!      elpolariz
!!
!! CHILDREN
!!      appdig,dzgedi,dzgefa,handle_ncerr,hdr_io,hdr_io_netcdf,hdr_skip
!!      ini_wf_netcdf,leave_new,matr3inv,rwwf,waveformat,wffclose,wffopen
!!      wrtout,xdefineoff
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine uderiv(bdberry,cg,gprimd,hdr,istwfk,kberry,kg,kpt_,kptopt,kptrlatt,&
& mband,mgfft,mkmem,mpi_enreg,mpw,natom,nband,nberry,npwarr,nspinor,nsppol,nkpt_,&
& rprimd,unddk,unkg,wffnow,filnam)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
#if defined HAVE_NETCDF
 use netcdf
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_28_numeric_noabirule
 use interfaces_32_util
 use interfaces_51_manage_mpi
 use interfaces_59_io_mpi
 use interfaces_61_ionetcdf
 use interfaces_67_common, except_this_one => uderiv
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: kptopt,mband,mgfft,mkmem,mpw,natom,nberry,nkpt_,nspinor
 integer,intent(in) :: nsppol,unddk,unkg
 type(MPI_type),intent(inout) :: mpi_enreg
 type(hdr_type),intent(inout) :: hdr
 type(wffile_type),intent(inout) :: wffnow
!arrays
 integer,intent(in) :: bdberry(4),istwfk(nkpt_),kberry(3,20),kg(3,mpw*mkmem)
 integer,intent(in) :: kptrlatt(3,3),nband(nkpt_*nsppol),npwarr(nkpt_)
 real(dp),intent(in) :: cg(2,mpw*nspinor*mband*mkmem*nsppol),gprimd(1:3,1:3)
 real(dp),intent(in) :: kpt_(3,nkpt_),rprimd(3,3)
 character(len=fnlen),intent(in) :: filnam(5)

!Local variables -------------------------
!scalars
 integer :: accesswff,band_in,cg_index_iband,cg_index_jband,fform,flag,flag1
 integer :: formeig,iband,iberry,icg,idir,ierr,ifor,ii,iii,ikpt,ikpt2,ikpt_
 integer :: index,index1,info,ipert,ipw,isgn,isp,isppol,jband,jj,jkpt,jkpt_,jpw
 integer :: jsppol,lkpt,master,maxband,mcg_disk,me,minband,nband_diff,nband_k
 integer :: ncerr,ncid_hdr,nkpt,npw_k,option,pertcase,rdwr,read_k,spaceComm
 integer :: tim_rwwf
 real(dp) :: gmod,twodk
 character(len=500) :: message
 character(len=fnlen) :: fiwf1o,wff2nm
 type(wffile_type) :: wffddk
!arrays
 integer :: kpt_flag(2*nkpt_),kpt_mark(2*nkpt_)
 integer,allocatable :: cg_index(:,:,:),ikpt_dk(:,:),ipvt(:),kg_dum(:,:)
 integer,allocatable :: kg_jl(:,:,:),kg_kpt(:,:,:)
 real(dp) :: det(2,2),diffk(3),diffk2(3),dk(3),gpard(3),klattice(3,3)
 real(dp) :: kptrlattr(3,3),tr(2)
 real(dp),allocatable :: cg_disk(:,:,:),cg_disk_1(:,:),cmatrix(:,:,:),dudk(:,:)
 real(dp),allocatable :: eig_dum(:),eig_dum_2(:),kpt(:,:),occ_dum(:)
 real(dp),allocatable :: occ_dum_2(:),phi(:,:,:),u_tilde(:,:,:,:),zgwork(:,:)
 logical,allocatable :: shift_g_2(:,:)

! *************************************************************************
!DEBUG
!write(6,*)' uderiv : enter '
!ENDDEBUG

 if(nspinor==2)then
  write(6,*)' uderiv : does not yet work for nspinor=2'
  stop
 end if

 if(maxval(istwfk(:))/=1)then
  write(message, '(a,a,a,a,a,a)' )ch10,&
&  ' berryphase : BUG -',ch10,&
&  '  Sorry, this routine does not work yet with istwfk/=1.',ch10,&
&  '  This should have been tested previously ...'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

 if (kptopt==3) then
  nkpt = nkpt_
  allocate(kpt(3,nkpt))
  kpt(:,:)=kpt_(:,:)
 else if (kptopt==2) then
  nkpt = nkpt_*2
  allocate(kpt(3,nkpt))
  do ikpt = 1,nkpt/2
   kpt_flag(ikpt) = 0
   kpt(:,ikpt)=kpt_(:,ikpt)
  end do
  index = 0
  do ikpt = (nkpt/2+1),nkpt
   flag1 = 0
   do jkpt = 1, nkpt/2
    if (((abs(kpt_(1,ikpt-nkpt/2)+kpt_(1,jkpt))<1.0d-8).or.&
&    (abs(1-abs(kpt_(1,ikpt-nkpt/2)+kpt_(1,jkpt)))<1.0d-8))&
&    .and.((abs(kpt_(2,ikpt-nkpt/2)+kpt_(2,jkpt))<1.0d-8).or.&
&    (abs(1-abs(kpt_(2,ikpt-nkpt/2)+kpt_(2,jkpt)))<1.0d-8))&
&    .and.((abs(kpt_(3,ikpt-nkpt/2)+kpt_(3,jkpt))<1.0d-8).or.&
&    (abs(1-abs(kpt_(3,ikpt-nkpt/2)+kpt_(3,jkpt)))<1.0d-8))) then
     flag1 = 1
     index = index + 1
     exit
    end if
   end do
   if (flag1==0) then
    kpt_flag(ikpt-index)=ikpt-nkpt/2
    kpt(:,ikpt-index)=-kpt_(:,ikpt-nkpt/2)
   end if
  end do
  nkpt = nkpt - index
 end if

!DEBUG
!write(101,*) 'beginning write kpt'
!do ikpt=1,nkpt
!write(101,*) kpt(:,ikpt)
!end do
!ENDDEBUG

 allocate(shift_g_2(nkpt,nkpt))

!Compute primitive vectors of the k point lattice
!Copy to real(dp)
 kptrlattr(:,:)=kptrlatt(:,:)
!Go to reciprocal space (in reduced coordinates)
 call matr3inv(kptrlattr,klattice)

 do iberry=1,nberry

! **************************************************************************
! Determine the appended index for ddk 1WF files

  do idir=1,3
   if (kberry(idir,iberry) ==1) then
    ipert=natom+1
    pertcase=idir+(ipert-1)*3
   end if
  end do

! open ddk 1WF file
  formeig=1
  wff2nm=trim(filnam(4))//'_1WF'

  call appdig(pertcase,wff2nm,fiwf1o)

#if defined HAVE_NETCDF
  if(accesswff==2) then
!  Create empty netCDF file
   ncerr = nf90_create(path=wff2nm, cmode=NF90_CLOBBER, ncid=ncid_hdr)
   call handle_ncerr(ncerr," create netcdf wavefunction file")
   ncerr = nf90_close(ncid_hdr)
   call handle_ncerr(ncerr," close netcdf wavefunction file")
  else if(accesswff==3) then
   write (std_out,*) "FIXME: ETSF I/O support in uderiv"
  end if
#endif

  spaceComm=abinit_comm_serial ; me=0 ; master=0 ; accesswff=0
  call WffOpen(accesswff,spaceComm,fiwf1o,ierr,wffddk,master,me,unddk)

  rdwr=2 ; fform=2
  if (wffddk%accesswff /= 2) then
   call hdr_io(fform,hdr,rdwr,wffddk)
#if defined HAVE_NETCDF
  else if (wffddk%accesswff == 2) then
   call hdr_io_netcdf(fform,hdr,rdwr,wffddk)

   call ini_wf_netcdf(mpw,wffddk%unwff,1)
  else if (wffddk%accesswff==3) then
   write (std_out,*) "FIXME: ETSF I/O support in uderiv"
#endif
  end if

! Define offsets, in case of MPI I/O
  call xdefineOff(formeig,wffddk,mpi_enreg,nband,npwarr,nspinor,nsppol,nkpt_)

! *****************************************************************************
! Calculate dimensional recip lattice vector along which P is calculated
! dk =  step to the nearest k point along that direction
! in reduced coordinates

  dk(:)=dble(kberry(1,iberry))*klattice(:,1)+&
&  dble(kberry(2,iberry))*klattice(:,2)+&
&  dble(kberry(3,iberry))*klattice(:,3)

  do idir=1,3
   if (dk(idir)/=0) then
    twodk=2*dk(idir)
   end if
  end do

  gpard(:)=dk(1)*gprimd(:,1)+dk(2)*gprimd(:,2)+dk(3)*gprimd(:,3)
  gmod=sqrt(dot_product(gpard,gpard))

! ******************************************************************************
! Select the k grid  points along the direction to compute dudk
! dk =  step to the nearest k point along that direction

! For each k point, find k_prim such that k_prim= k + dk mod(G)
! where G is a vector of the reciprocal lattice
  allocate(ikpt_dk(2,nkpt))
  ikpt_dk(1:2,1:nkpt)=0
  shift_g_2(:,:)= .false.

  do ikpt=1,nkpt
   do ikpt2=1,nkpt
    diffk(:)=abs(kpt(:,ikpt2)-kpt(:,ikpt)-dk(:))
    diffk2(:)=abs(kpt(:,ikpt2)-kpt(:,ikpt)+dk(:))
    if (sum(abs(diffk(:)-nint(diffk(:))))<3*tol8)then
     ikpt_dk(1,ikpt)=ikpt2
     if(sum(diffk(:))>=3*tol8) shift_g_2(ikpt,ikpt2) = .true.
    end if
    if (sum(abs(diffk2(:)-nint(diffk2(:))))<3*tol8)then
     ikpt_dk(2,ikpt)=ikpt2
     if(sum(diffk2(:))>=3*tol8) shift_g_2(ikpt,ikpt2) = .true.
    end if
   end do
  end do

  write(message,'(a,a,a,3f9.5,a,a,3f9.5,a)')ch10,&
&  ' Computing the derivative for reciprocal vector:',ch10,&
&  dk(:),' (in reduced coordinates)',ch10,&
&  gpard(1:3),' (in cartesian coordinates - atomic units)'
  call wrtout(ab_out,message,'COLL')
  call wrtout(6,message,'COLL')

  if(nsppol==1)then
   write(message, '(a,i5,a,i5)')&
&   ' From band number',bdberry(1),'  to band number',bdberry(2)
  else
   write(message, '(a,i5,a,i5,a,a,a,i5,a,i5,a)')&
&   ' From band number',bdberry(1),'  to band number',bdberry(2),' for spin up,',&
&   ch10,&
&   ' from band number',bdberry(3),'  to band number',bdberry(4),' for spin down.'
  end if
  call wrtout(ab_out,message,'COLL')
  call wrtout(6,message,'COLL')

! *****************************************************************************
  allocate(dudk(2,mpw*nspinor*mband*nsppol))
  allocate(eig_dum_2((2*mband)**formeig*mband))
  allocate(occ_dum_2((2*mband)**formeig*mband))
  dudk(1:2,:)=0.0_dp
  eig_dum_2=0.0_dp
  occ_dum_2=0.0_dp

  if (mkmem/=0) then

!  Find the location of each wavefunction

   allocate(cg_index(mband,nkpt_,nsppol))
   icg = 0
   do isppol=1,nsppol
    do ikpt=1,nkpt_
     nband_k=nband(ikpt+(isppol-1)*nkpt_)
     npw_k=npwarr(ikpt)
     do iband=1,nband_k
      cg_index(iband,ikpt,isppol)=(iband-1)*npw_k*nspinor+icg
     end do
     icg=icg+npw_k*nspinor*nband(ikpt)
    end do
   end do

!  Find the planewave vectors for each k point
!  SHOULD BE REMOVED WHEN ANOTHER INDEXING TECHNIQUE WILL BE USED FOR kg
   allocate(kg_kpt(3,mpw*nspinor,nkpt_))
   kg_kpt(:,:,:) = 0
   index1 = 0
   do ikpt=1,nkpt_
    npw_k=npwarr(ikpt)
    do ipw=1,npw_k*nspinor
     kg_kpt(1:3,ipw,ikpt)=kg(1:3,ipw+index1)
    end do
    index1=index1+npw_k*nspinor
   end do
  end if

  if (mkmem==0) then
   call hdr_skip(wffnow,ierr)

!  Should Define offsets, in case of MPI I/O (Also, other hdr_skip calls !!)
!  For the time being does not work with MPI I/O
!  call xdefineOff(formeig,wffnow,mpi_enreg,nband,npwarr,nspinor,nsppol,nkpt_)

   allocate(cg_disk(2,mpw*nspinor*mband,2))
   rewind unkg
   allocate(kg_jl(3,mpw,2))
  end if


! *************************************************************************
! Loop over spins
  do isppol=1,nsppol

   minband=bdberry(2*isppol-1)
   maxband=bdberry(2*isppol)

   if(minband<1)then
    write(message,'(a,a,a,a,i5,a)')ch10,&
&    ' berryphase : BUG - ',ch10,&
&    '  The band limit minband=',minband,', is lower than 0.'
    call wrtout(6,message,'COLL')
    call leave_new('COLL')
   end if
   if(maxband<1)then
    write(message,'(a,a,a,a,i5,a)')ch10,&
&    ' berryphase : BUG - ',ch10,&
&    '  The band limit maxband=',maxband,', is lower than 0.'
    call wrtout(6,message,'COLL')
    call leave_new('COLL')
   end if
   if(maxband<minband)then
    write(message,'(4a,i5,a,i5)')ch10,&
&    ' berryphase : BUG - ',ch10,&
&    '  maxband=',maxband,', is lower than minband=',minband
    call wrtout(6,message,'COLL')
    call leave_new('COLL')
   end if

!  Loop over k points
   do ikpt_=1,nkpt_

    read_k = 0

    ikpt=ikpt_
    tr(1) = 1.0_dp

    if (kptopt==2) then
     if (read_k == 0) then
      if (kpt_flag(ikpt_)/=0) then
       tr(1) = -1.0_dp
       ikpt= kpt_flag(ikpt_)
      end if
     else           !read_k
      if (kpt_flag(ikpt_)/=0) then
       tr(-1*read_k+3) = -1.0_dp
       ikpt= kpt_flag(ikpt_)
      end if
     end if       !read_k
    end if           !kptopt

    nband_k=nband(ikpt+(isppol-1)*nkpt_)

    if(nband_k<maxband)then
     write(message,'(4a,i5,a,i5)')ch10,&
&     ' uderiv : BUG - ',ch10,&
&     '  maxband=',maxband,', is larger than nband(i,isppol)=',nband_k
     call wrtout(6,message,'COLL')
     call leave_new('COLL')
    end if

    npw_k=npwarr(ikpt)

    allocate(u_tilde(2,npw_k,maxband,2))
    u_tilde(1:2,1:npw_k,1:maxband,1:2)=0.0_dp

!   ifor = 1,2 represents forward and backward neighbouring k points of ikpt
!   respectively along dk direction

    do ifor=1,2

     allocate(phi(2,mpw,mband),cmatrix(2,maxband,maxband))
     phi(1:2,1:mpw,1:mband)=0.0_dp; cmatrix(1:2,1:maxband,1:maxband)=0.0_dp

     isgn=(-1)**ifor
     jkpt_= ikpt_dk(ifor,ikpt_)

     tr(2) = 1.0_dp

     jkpt=jkpt_

     if (kptopt==2) then
      if (read_k == 0) then
       if (kpt_flag(jkpt_)/=0) then
        tr(2) = -1.0_dp
        jkpt= kpt_flag(jkpt_)
       end if
      else           !read_k
       if (kpt_flag(jkpt_)/=0) then
        tr(read_k) = -1.0_dp
        jkpt= kpt_flag(jkpt_)
       end if
      end if       !read_k
     end if           !kptopt

     if (mkmem==0) then

!     if read_k = 0,read first k point of string
!     ******************************************
      if (read_k==0) then
       read_k = 1
       npw_k = npwarr(ikpt)
       rewind unkg
       index = 1
       do while(index < ikpt)
        read(unkg)
        read(unkg)
        read(unkg)
        index = index + 1
       end do

       read(unkg)
       read(unkg)
       read(unkg) kg_jl(1:3,1:npw_k,read_k)

       tim_rwwf = 0
       allocate(eig_dum(mband),occ_dum(mband))
       mcg_disk=mpw*nspinor*mband
       allocate(cg_disk_1(2,mcg_disk),kg_dum(3,0))

       call hdr_skip(wffnow,ierr)
       do isp=1,nsppol
        do lkpt=1,nkpt_
         if(isp==isppol .and. lkpt==ikpt)then
          option=-2 ! will read cg only
         else
          option=-1 ! will skip
         end if
         call rwwf(cg_disk_1,eig_dum,0,0,0,lkpt,isppol,kg_dum,mband,mcg_disk,&
&         mpi_enreg,nband_k,nband_k,npw_k,nspinor,occ_dum,option,0,tim_rwwf,wffnow)
         if(option==-2)exit
        end do
       end do
       cg_disk(1:2,:,read_k)=cg_disk_1(1:2,:)
       deallocate(cg_disk_1,eig_dum,kg_dum,occ_dum)

       read_k = 2

      end if           !read_k

!     read the next k point
!     *********************
      if (read_k /= 0) then
       npw_k = npwarr(jkpt)
       rewind unkg
       index = 1
       do while(index < jkpt)
        read(unkg)
        read(unkg)
        read(unkg)
        index = index + 1
       end do

       read(unkg)
       read(unkg)
       read(unkg) kg_jl(1:3,1:npw_k,read_k)

       tim_rwwf = 0
       allocate(eig_dum(mband),occ_dum(mband))
       mcg_disk=mpw*nspinor*mband
       allocate(cg_disk_1(2,mcg_disk))

       call hdr_skip(wffnow,ierr)
       do isp=1,nsppol
        do lkpt=1,nkpt_
         if(isp==isppol .and. lkpt==jkpt)then
          option=-2 ! will read cg only
         else
          option=-1 ! will skip
         end if
         call rwwf(cg_disk_1,eig_dum,0,0,0,lkpt,isppol,kg_dum,mband,mcg_disk,mpi_enreg,&
         nband_k,nband_k,npw_k,nspinor,occ_dum,option,0,tim_rwwf,wffnow)
         if(option==-2)exit
        end do
       end do
       cg_disk(1:2,:,read_k)=cg_disk_1(1:2,:)
       deallocate(cg_disk_1,eig_dum,kg_dum,occ_dum)

      end if           !read_k
     end if

     if (ifor==1) read_k = 2

     jj = read_k
     ii = -1*read_k+3

     call waveformat(cg,cg_disk,cg_index,phi,dk,ii,ikpt,&
&     ikpt_,isgn,isppol,jj,jkpt,jkpt_,kg_kpt,kpt,kg_jl,maxband,mband,&
&     minband,mkmem,mpw,nkpt,nkpt_,npwarr,nsppol,nspinor,shift_g_2,tr)

!    Compute the overlap matrix <u_k|u_k+b>

     if(mkmem==0)then

      do iband=minband,maxband
       cg_index_iband= (iband-1)*npwarr(ikpt)
       do jband=minband,maxband
        do ipw=1,npwarr(ikpt)
         cmatrix(1,iband,jband)=cmatrix(1,iband,jband)+&
&         cg_disk(1,ipw+cg_index_iband,ii)*phi(1,ipw,jband)+&
&         tr(ii)*cg_disk(2,ipw+cg_index_iband,ii)*tr(jj)*phi(2,ipw,jband)

         cmatrix(2,iband,jband)=cmatrix(2,iband,jband)+&
&         cg_disk(1,ipw+cg_index_iband,ii)*tr(jj)*phi(2,ipw,jband)-&
&         tr(ii)*cg_disk(2,ipw+cg_index_iband,ii)*phi(1,ipw,jband)
        end do
       end do
      end do

     else

      do iband=minband,maxband
       cg_index_iband=cg_index(iband,ikpt,isppol)
       do jband=minband,maxband
        do ipw=1,npwarr(ikpt)
         cmatrix(1,iband,jband)=cmatrix(1,iband,jband)+&
&         cg(1,ipw+cg_index_iband)*phi(1,ipw,jband)+&
&         tr(ii)*cg(2,ipw+cg_index_iband)*tr(jj)*phi(2,ipw,jband)

         cmatrix(2,iband,jband)=cmatrix(2,iband,jband)+&
&         cg(1,ipw+cg_index_iband)*tr(jj)*phi(2,ipw,jband)-&
&         tr(ii)*cg(2,ipw+cg_index_iband)*phi(1,ipw,jband)
        end do
       end do
      end do
     end if

!    Compute the inverse of cmatrix(1:2,minband:maxband, minband:maxband)

     band_in = maxband - minband + 1
     allocate(ipvt(maxband))
     allocate(zgwork(2,1:maxband))

!    Last argument of zgedi means calculate inverse only
     call dzgefa(cmatrix(1,minband,minband),maxband, band_in,ipvt,info)
     call dzgedi(cmatrix(1,minband,minband),maxband, band_in,ipvt,det,zgwork,01)

     deallocate(zgwork,ipvt)

!    Compute the product of Inverse overlap matrix with the wavefunction

     do iband=minband,maxband
      do ipw=1,npwarr(ikpt)
       u_tilde(1,ipw,iband,ifor)= &
&       dot_product(cmatrix(1,minband:maxband,iband),&
&       phi(1,ipw,minband:maxband))-&
&       dot_product(cmatrix(2,minband:maxband,iband),&
&       tr(jj)*phi(2,ipw,minband:maxband))
       u_tilde(2,ipw,iband,ifor)= &
&       dot_product(cmatrix(1,minband:maxband,iband),&
&       tr(jj)*phi(2,ipw,minband:maxband))+&
&       dot_product(cmatrix(2,minband:maxband,iband),&
&       phi(1,ipw,minband:maxband))
      end do
     end do
     deallocate(cmatrix,phi)

    end do !ifor

!   Compute dudk for ikpt

    npw_k=npwarr(ikpt)

    do iband=minband,maxband

     icg=(iband-minband)*npw_k

     dudk(1,1+icg:npw_k+icg)=(u_tilde(1,1:npw_k,iband,1)-&
&     u_tilde(1,1:npw_k,iband,2))/twodk

     dudk(2,1+icg:npw_k+icg)=(u_tilde(2,1:npw_k,iband,1)-&
&     u_tilde(2,1:npw_k,iband,2))/twodk

    end do

    tim_rwwf=0
    mcg_disk=mpw*nspinor*mband
    nband_diff=maxband-minband+1
    call rwwf(dudk,eig_dum_2,formeig,0,0,ikpt,isppol,kg_kpt(:,:,ikpt),&
&    mband,mcg_disk,mpi_enreg,nband_diff,nband_diff,&
&    npw_k,nspinor,occ_dum_2,2,1,tim_rwwf,wffddk)

    deallocate(u_tilde)

   end do !ikpt
  end do  !isppol

  deallocate(eig_dum_2,occ_dum_2)
  deallocate(dudk)

  call WffClose(wffddk,ierr)

  if (mkmem==0) then
   deallocate(cg_disk,kg_jl)
  else
   deallocate(kg_kpt,cg_index)
  end if
  deallocate(ikpt_dk)

 end do ! iberry

 deallocate(shift_g_2,kpt)

 write(6,*) 'uderiv:  exit '

end subroutine uderiv
!!***
