!{\src2tex{textfont=tt}}
!!****f* ABINIT/vtorhorec
!! NAME
!! vtorhorec
!! 
!! FUNCTION
!! This routine computes the new density from a fixed potential (vtrial)
!! using a recursion method
!! 
!! COPYRIGHT
!! Copyright (C) 2008-2009 ABINIT group ( ).
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  densymop_gs <type(dens_sym_operator_type)>=the density symmetrization
!!   operator (ground-state symmetries)
!!  dtfil <type(datafiles_type)>=variables related to files
!!  dtset <type(dataset_type)>=all input variables for this dataset
!!  irrzon(nfft**(1-1/nsym),2,(nspden/nsppol)-3*(nspden/4))=irreducible zone data
!!  mpi_enreg=informations about MPI parallelization
!!  natom=number of atoms in cell.
!!  nfftf=number of fft grid points
!!  nspden=number of spin-density components
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  nsym=number of symmetry elements in space group
!!  phnons(2,nfft**(1-1/nsym),(nspden/nsppol)-3*(nspden/4))=nonsymmorphic translation phases
!!  ucvol=unit cell volume in bohr**3.
!!  vtrial(nfft,nspden)=INPUT Vtrial(r).
!!  rmet=define the metric : rprimd*(transpose(rprimd)) 
!! 
!! OUTPUT
!!  ek=kinetic energy part of total energy.
!!  enl=nonlocal pseudopotential part of total energy.
!!  entropy=entropy due to the occupation number smearing (if metal)
!!  e_eigenvalues=Sum of the eigenvalues - Band energy (Hartree)
!!  fermie=fermi energy (Hartree)
!!  grnl(3*natom)=stores grads of nonlocal energy wrt length scales
!!   (3x3 tensor) and grads wrt atomic coordinates (3*natom)
!! 
!! SIDE EFFECTS
!!  rhog(2,nfft)=array for Fourier transform of electron density
!!  rhor(nfft,nspden)=array for electron density in electrons/bohr**3.
!! 
!! PARENTS
!!      scfcv
!! 
!! CHILDREN
!!      getngrec, green_kernel, recursion, entropyrec, fermisolverec, ingrid, xcomm_init, xsum_mpi, 
!!      wrtout, symrhg, leave_new, pre_scatter, xmax_mpi, status,
!!      timab, time_accu, transgrid, xallgatherv_mpi
!! 
!! NOTES
!!  at this time :
!!       - must change the choosen entropy (ie entropy = entropy_test). 
!!       - must deactivate computation of ekin, and use instead a computation of free energy. 
!!       
!!       - symetrie usage not implemented (densymop_gs, irrzon not used and nsym should be 1)
!!       - natom seems totaly unuseful in the method
!!       - spin-polarized not implemented (nsppol must be 1, nspden ?)
!!       - phnons ?
!!       - need a rectangular box (ngfft(1)=ngfft(2)=ngfft(3))
!!
!!       - enl and grnl are not computed (set to 0)
!! 
!! 
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif  

subroutine vtorhorec(densymop_gs,dtfil,dtset,&
&  ek,enl,entropy,e_eigenvalues,fermie,&
&  grnl,irrzon,mpi_enreg,natom,nfftf,nspden,nsppol,nsym,phnons,&
&  rhog, rhor,ucvol, vtrial, rmet, quit,get_ek,get_entropy,psps)
  
 use defs_basis
 use defs_datatypes
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_12_hide_mpi
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_18_timing
 use interfaces_51_manage_mpi
 use interfaces_66_paw
 use interfaces_67_recursion, except_this_one => vtorhorec
!End of the abilint section

 implicit none
   
!Arguments -------------------------------
!scalars
 integer,intent(in) :: get_ek,get_entropy,natom,nfftf,nspden,nsppol,nsym
 integer,intent(inout) :: quit
 real(dp),intent(in) :: ucvol
 real(dp),intent(out) :: e_eigenvalues,ek,enl,entropy,fermie
 type(MPI_type),intent(inout) :: mpi_enreg
 type(datafiles_type),intent(in) :: dtfil
 type(dataset_type),intent(in) :: dtset
 type(dens_sym_operator_type),intent(in) :: densymop_gs
!arrays
 integer,intent(in) :: irrzon((dtset%nfft)**(1-1/nsym),2,(nspden/nsppol)-3*(nspden/4))
 real(dp),intent(in) :: phnons(2,(dtset%nfft)**(1-1/nsym),(nspden/nsppol)-3*(nspden/4))
 real(dp),intent(in) :: rmet(3,3),vtrial(nfftf,nspden)
 real(dp),intent(inout) :: rhog(2,nfftf)
 real(dp),intent(out) :: grnl(3*natom),rhor(nfftf,dtset%nspden)
  
!Local variables-------------------------------
!pour calcul de la troncature ; a garder ???
!for parallel version
!pour calcul de la troncature ; a garder ???
!scalars
 integer,parameter :: level=7
 integer,save :: first=1,max_pt,max_pt_group_band,max_pt_group_fft,min_pt
 integer,save :: min_pt_group_band,min_pt_group_fft,nfftrec,ngfftrec(18)=0
 integer,save :: ntranche,ntranche_group_fft,reste
 integer :: affich,calcul_den,calcul_fermie,ierr,iexit,ii,ik,iklocal,index
 integer :: ipoint,ipointlocal,isign,jj,kk,kx,ky,kz,largest_ngfft,max_k
 integer :: maxpow11,maxpow2,maxpow3,maxpow5,maxpow7,me_band,me_fft,me_rec
 integer :: min_k,mk,mmsrch,modi,modj,modk,n1,n2,n3,n_pt_integ_entropy,nfftot
 integer :: nk,nn,nproc_band,nproc_fft,nproc_rec,nrec,nrec_k,ntranche_k
 integer :: old_paral_level,prtvol,reste_k,return_count,return_count2,spaceComm
 integer :: tim_fourdp,trotter,xx,yy,zz
 real(dp),save :: fermie_local
 real(dp) :: beta,drho,drhomax,dummypotmin,ekink,entropy1,entropy2,entropy3
 real(dp) :: entropy4,entropy_local_test,entropy_local_test1
 real(dp) :: entropy_local_test2,entropy_local_test3,entropy_local_test4
 real(dp) :: entropy_test,entropy_test1,entropy_test2,entropy_test3
 real(dp) :: entropy_test4,entropylocal,entropylocal1,entropylocal2
 real(dp) :: entropylocal3,entropylocal4,free_energy,free_energy1,free_energy2
 real(dp) :: free_energy3,free_energy4,free_energy_local,free_energy_local1
 real(dp) :: free_energy_local2,free_energy_local3,free_energy_local4
 real(dp) :: free_energy_local_test,free_energy_test,inf_ucvol,intrhov
 real(dp) :: long_troncat,nelect,potmin,rtroncat,rtrotter,toldrho,tolrec,tsmear
 real(dp) :: xmax
 character(len=4) :: tag
 character(len=500) :: message,timename
 type(MPI_type) :: mpi_enreg_rec
!arrays
 integer :: displs(1:mpi_enreg%nproc_band),ngfft_ek(18)
 integer :: recvcounts(1:mpi_enreg%nproc_band)
 integer,allocatable :: srch(:)
 real(dp) :: inf_rmet(3,3)
 real(dp) ::      pot(0:dtset%ngfft(1)-1,0:dtset%ngfft(2)-1,0:dtset%ngfft(3)-1,1)
 real(dp) :: smallpot(0:dtset%ngfft(1)-1,0:dtset%ngfft(2)-1,0:dtset%ngfft(3)/dtset%ngfft(10)-1,1)
 real(dp) :: tsec(2),tsec2(2)
 real(dp),allocatable :: T_p(:,:,:),ZT_p_G(:,:,:,:)
 real(dp),allocatable :: ZT_ptempo(:,:),a_k(:,:),alocal(:,:),b2_k(:,:)
 real(dp),allocatable :: b2local(:,:),exppot(:,:,:),exppotloc(:,:,:)
 real(dp),allocatable :: rholocal(:)

 !!#############################################################

 !!add_marco
 !integer,intent(in) :: gridratio 
 integer, save :: gridratio, min_nrec
 integer :: ii1,jj1,kk1, sum_bufsize
 integer, allocatable :: bufsize(:), bufdispl(:),bufsize_f(:), bufdispl_f(:) ! to save the block
                                ! size of  nonzero data on any processor when coarse gride is used 
 !integer, allocatable :: vett_rec_xproc(:),vett_rec_xproc_1(:)
 real(dp), allocatable :: rholocal_f(:)
 real(dp), allocatable :: rhogf(:,:),rhogc(:,:)
 real(dp), allocatable :: rhor_serial(:), rholoc_2(:)
 real(dp), allocatable :: ablocal_1(:,:,:),ablocal_2(:,:,:),ablocal_f(:,:,:),aloc_copy(:,:),b2loc_copy(:,:)
 real(dp), allocatable :: entropy_v_f(:,:),entropy_v_c(:,:),entropy_v_2(:,:)
 real(dp), allocatable :: free_ene_v_f(:,:),free_ene_v_c(:,:),free_ene_v_2(:,:)
 real(dp), allocatable,save :: ZT_p(:,:,:,:) 
 type(pawfgr_type), save :: pawfgr_rec 
 real(dp) :: perc_vmin
! real(dp):: entro_tran,entroprova
 ! for nonlocal pseudopotentials
 type(pseudopotential_type),intent(in) :: psps


! *************************************************************************

!DEBUG echo input variable
!!$write(6,*)' '
!!$write(6,*) 'enter vtorhorec : echo input variable'
!!$write(6,*) 'ek', ek
!!$write(6,*) 'enl', enl
!!$write(6,*) 'entropy', entropy
!!$write(6,*) 'fermi', fermie_local
!!$write(6,*) 'grnl', grnl(1), grnl(2*natom+1)
!!$write(6,*) 'irrzon',irrzon(1,1,1),irrzon(1,2,1),irrzon(dtset%nfft**(1-1/nsym),1,1)
!!$write(6,*) 'natom',natom
!!$write(6,*) 'nfftf',nfftf
!!$write(6,*) 'nspden',nspden
!!$write(6,*) 'nsppol',nsppol
!!$write(6,*) 'nsym',nsym
!!$write(6,*) 'phnons',phnons(1,1,1),phnons(2,1,1),phnons(1,dtset%nfft**(1-1/nsym),1)
!!$write(6,*) 'ucvol',ucvol
!!$write(6,*) 'vtrial',vtrial(1,1),vtrial(3,1)
!!$write(6,*) 'rmet', rmet(:,1)
!!$write(6,*) 'quitrec', quit
!!$write(6,*) 'get_ek', get_ek
!!$write(6,*) 'get_entropy', get_entropy
!!$
!!$call leave_new('COLL')
!ENDDEBUG





 call timab(21,1,tsec)
 call timab(600,1,tsec2)
 call timab(601,1,tsec2)
 
!Structured debugging if prtvol=-level
 prtvol=dtset%prtvol
 if(prtvol==-level)then
  write(message,'(80a,a,a)') ('=',ii=1,80),ch10,' vtorho : enter '
  call wrtout(06,message,'PERS')
 end if
 
 
!################################################################################################## 
!parameters for the recursion method 
 if(first == 1) then 
  nrec = dtset%recnrec
 else 
  nrec = min_nrec
 end if
!mk = dtset%useric
 trotter = dtset%recptrott
 nrec_k = nrec ! nrec_k is defined bat not really used
!dtset%userid !anyway, the recursion is stopped when values are converged 
!: taking the same number of recursion shouldn't be a problem.
!userid is now used in entropyrec.
 if (dtset%recnpath<=0) then  
  n_pt_integ_entropy = 25
 else
  n_pt_integ_entropy = dtset%recnpath
 end if
 rtroncat = dtset%recrcut
 toldrho = dtset%rectolden
 tolrec = toldrho*1.d-2
 if(first==1) fermie_local = dtset%recefermi !initial guess for fermie
 
 
!for allowing only kinetic energy computation or to freeze fermie (not implemented)
 calcul_den = 1
 calcul_fermie = 1
 
!##################################################################################################  
!initialisation
 enl = 0.d0
 grnl = 0.d0
 
 nelect = dtset%nelect
 n1=dtset%ngfft(1) ; n2=dtset%ngfft(2) ; n3=dtset%ngfft(3)
 nfftot=product(dtset%ngfft(1:3))
 me_rec=mpi_enreg%me ; nproc_rec=mpi_enreg%nproc !this should use only fft and band- parallelism - no kpt parallelism
 me_fft = mpi_enreg%me_fft ; nproc_fft = mpi_enreg%nproc_fft
 me_band = mpi_enreg%me_band ; nproc_band = mpi_enreg%nproc_band
 
 mpi_enreg_rec=mpi_enreg
 mpi_enreg_rec%nproc_fft=1; mpi_enreg_rec%me_fft=0 ! no fft-parallelism in the recursion

!DEBUG (echo input for parallel version)
!write(6,*)' '
!write(6,*)'me_rec',me_rec
!write(6,*)'me_fft',mpi_enreg%me_fft
!write(6,*)'me_band',mpi_enreg%me_band
!write(6,*)'me',mpi_enreg%me
!write(6,*)'nproc',mpi_enreg%nproc
!write(6,*)'nproc_fft',mpi_enreg%nproc_fft
!write(6,*)'nproc_band',mpi_enreg%nproc_band
!write(6,*)'num_group_fft',mpi_enreg%num_group_fft
!write(6,*)'num_group',mpi_enreg%num_group
!write(6,*)'spaceComm',mpi_enreg%spaceComm 
!write(6,*)'mpi_enreg%fft_comm(mpi_enreg%num_group_fft)',mpi_enreg%fft_comm(mpi_enreg%num_group_fft)
!write(6,*)'comm_fft',mpi_enreg%comm_fft
!write(6,*)'paral_compil_respfn',mpi_enreg%paral_compil_respfn 
!ENDDEBUG
 
 smallpot = reshape(vtrial,(/ n1,n2,n3/nproc_fft,1 /))
 pot(:,:,0:n3/nproc_rec-1,1) = smallpot(:,:,:,1)
 call pre_scatter(smallpot,pot,n1,n2,n3,mpi_enreg,'gather')
!call leave_new('COLL')
 if(dtset%rectesteg==1)  pot = 0.d0 !ELECTRON GAS 

 tsmear = dtset%tsmear
 beta = 1/tsmear
 if (trotter == 0) then
  rtrotter = 0.5d0
 else
  rtrotter = real(trotter,dp)
 end if
!infinitesimal metric
 do ii =1,3
  inf_rmet(ii,:) = one/dble(dtset%ngfft(ii))*rmet(ii,:)/dble(dtset%ngfft(1:3))
 end do
 inf_ucvol=ucvol/nfftot
 
!DEBUG : echo the values 
!if(prtvol==-level)then
!write(message,'(a)') '  version 11 '
!call wrtout(06,message,'COLL')
!write(message,'(a,d16.6)') '  temp (Hartree)    ', tsmear
!call wrtout(06,message,'COLL')
!write(message,'(a,d16.6)') '  beta (1/Hartree)  ', beta
!call wrtout(06,message,'COLL')
!write(message,'(a,d16.6)') '  mu                ', fermie_local
!call wrtout(06,message,'COLL')
!write(message,'(a,d16.6)') '  betamu            ',  beta*fermie_local
!call wrtout(06,message,'COLL')
!write(message,'(a,d16.6)') '  nelect            ', nelect
!call wrtout(06,message,'COLL')
!write(message,'(a,i8)')'  trotter            ', trotter
!call wrtout(06,message,'COLL')
!write(message,'(a,i8)')'  nrec               ', nrec
!call wrtout(06,message,'COLL')
!write(message,'(a,3i5)')'  nb_point             ', n1, n2, n3
!call wrtout(06,message,'COLL')
!write(message,'(a,3d12.3)')'  pas_maillage       ',sqrt(inf_rmet(1,1)),sqrt(inf_rmet(2,2)),sqrt(inf_rmet(3,3))
!call wrtout(06,message,'COLL')
!write(message,'(a,d16.6)')'  rtroncat           ',rtroncat
!call wrtout(06,message,'COLL')
!write(message,'(a,i8)')'  Ec max             ', mk
!call wrtout(06,message,'COLL')
!write(message,'(a,i8)')'  nrec_k             ',nrec_k
!call wrtout(06,message,'COLL')
!write(message,'(a,i8)')'  calcul densite     ', calcul_den 
!call wrtout(06,message,'COLL')
!write(message,'(a,i8)')'  calcul entropie    ', get_entropy 
!call wrtout(06,message,'COLL')
!write(message,'(a,i8)')'  calcul ekin        ', get_ek
!call wrtout(06,message,'COLL')
!write(message,'(a,i8)')'  calcul mu          ', calcul_fermie
!call wrtout(06,message,'COLL')
!write(message,'(a,i8)')'  niveau paralellisme', mpi_enreg%paral_level
!call wrtout(06,message,'COLL')
!end if
!ENDDEBUG 
 

!################################################################################################
!computation of the fourier transform of the Green kernel (only once)
 
!troncation of the box : determine new dimension
!the method is similar to the one used in getng (except that ecut and xboxcutmin give no constraint, 
!and symmetries are not handled)
 if(first == 1)then  
  write(6,*)'----------------------'
  write(6,*)'FIRST CYCLE'
  if ( rtroncat>tol14) then  !default value rtroncat = 0.d0 means no troncation 
   long_troncat = 2*rtroncat + sqrt(beta/rtrotter) !sqrt(beta/trotter) for guess - should be modified
   call timab(601,2,tsec2)
   call getngrec(dtset%ngfft,inf_rmet,ngfftrec,nfftrec,rtroncat+0.25d0*sqrt(beta/rtrotter)) 
!  1/4*sqrt(beta/trotter) for guess - should be modified     
   call timab(601,1,tsec2)
  else
   ngfftrec(:) = dtset%ngfft(:) 
!  For now, recursion method doesn't use paralelism on FFT - which would require a great number of processors 
   nfftrec = product(ngfftrec(1:3))
   ngfftrec(9)=0              ! paral
   ngfftrec(10)=1             ! nproc_rec
   ngfftrec(11)=0             ! me_rec
   ngfftrec(12)= ngfftrec(2)  ! n2proc
   ngfftrec(13)= ngfftrec(3)  ! n3proc
  end if
  
! !add_marco  ------------------------------------------------------
! DEFINITION VARIABLE COARSE-FINE GRID  TO USE TRANSGRID--INGRID FUNCTIONS
  if (dtset%recgratio>1) then
   gridratio = dtset%recgratio
   
   pawfgr_rec%nfft = product(dtset%ngfft(1:3))      !fin grid
   pawfgr_rec%ngfft = dtset%ngfft    !fin grid
   pawfgr_rec%ngfft(9:11)=(/0,1,0/)
   pawfgr_rec%ngfft(12:13)= pawfgr_rec%ngfft(2:3)
   pawfgr_rec%ngfftc(:) = pawfgr_rec%ngfft(:)
   pawfgr_rec%ngfftc(:3) = floor(real(dtset%ngfft(:3)+1)/real(gridratio)) !coarse grid
   pawfgr_rec%nfftc = product(pawfgr_rec%ngfftc(1:3)) !coarse grid
   pawfgr_rec%usefinegrid =1
   
   
   pawfgr_rec%usefinegrid =1
   allocate(pawfgr_rec%fintocoa(pawfgr_rec%nfft),pawfgr_rec%coatofin(pawfgr_rec%nfftc))
   call indgrid(pawfgr_rec%coatofin,pawfgr_rec%fintocoa,pawfgr_rec%nfftc,pawfgr_rec%nfft,pawfgr_rec%ngfftc,pawfgr_rec%ngfft)
   
!  write(message, '(a,a,a,i2,a)' ) ch10,' Coarse grid is used in recursion,',' gridratio=',gridratio,'.'
!  call wrtout(ab_out,message,'COLL')
  else 
   gridratio = 1
  end if
! !----------------------------------------------------------------
  

! DEBUG
! if(prtvol==-level)then
! long_troncat = sqrt(inf_rmet(1,1))* ngfftrec(1)
! write(message,'(a,3i5)')'  n_cell               ', ngfftrec(1:3)
! call wrtout(06,message,'COLL')
! write(message,'(a,f8.5)')'  long_troncat       ', long_troncat
! call wrtout(06,message,'COLL')
! end if
! ENDDEBUG
  
! that part could use fft-parallelism
  write(6,*)'----------------------------------------------'
  write(6,*)'green kernel calculation'
  allocate(ZT_p(1:2,0: ngfftrec(1)-1,0: ngfftrec(2)-1,0: ngfftrec(3)-1))
  allocate(ZT_ptempo(1:2,0: nfftrec-1))
  call timab(601,2,tsec2)
  call green_kernel(ZT_ptempo,inf_rmet,inf_ucvol,rtrotter/beta,mpi_enreg_rec,ngfftrec,nfftrec,prtvol)
  call timab(601,1,tsec2)
  ZT_p(:,:,:,:) = real(nfftrec,dp)*reshape(source=ZT_ptempo,shape=shape(ZT_p))
  deallocate(ZT_ptempo)     
! end computation of the fourier transform of the Green kernel
  write(6,*)'----------------------------------------------'
 end if  !!(endif first)
!###################################################################################
 

!###################################################################################
!computation of exp( -beta*pot/(4.d0*rtrotter) ) (only once)
 write(6,*)'potmin_0',minval(pot)
 allocate(exppot(0:n1-1,0:n2-1,0:n3-1))
 exppot(:,:,:) = exp( -beta*pot(:,:,:,1)/(4.d0*rtrotter) )
!end computation of exp( -beta*pot/(4.d0*rtrotter) )


!################################################################################### 
!determining which point will compute that proc

!paralelism using the fft group
 ntranche_group_fft = nfftf
 min_pt_group_fft = me_fft*ntranche_group_fft
 max_pt_group_fft = (me_fft+1)*ntranche_group_fft-1

!DEBUG
!!$if(dtset%userrd >= 10.d0)then !use symetrie
!!$n1=n1/2
!!$n2=n2/2
!!$n3=n3/2 
!!$ntranche_group_fft =  ntranche_group_fft/8
!!$min_pt_group_fft=me_fft*ntranche_group_fft
!!$max_pt_group_fft = (me_fft+1)*ntranche_group_fft-1
!!$endif
!ENDDEBUG
 
!paralelism using the band communicator (not used in the recursion)
!if(first==1)then
 if(nproc_band/=0)then
  reste = modulo(ntranche_group_fft,nproc_band)
  ntranche = ntranche_group_fft/nproc_band
  displs(1) = 0
  do ii=0,nproc_band-1
   if (ii<reste) then
    recvcounts(ii+1) = ntranche + 1
    if(ii+1/=nproc_band)displs(ii+2) = displs(ii+1) + recvcounts(ii+1)
   else
    recvcounts(ii+1) = ntranche
    if(ii+1/=nproc_band)displs(ii+2) = displs(ii+1) + recvcounts(ii+1)
   end if
  end do
  ntranche = recvcounts(me_band+1)
  min_pt_group_band = displs(me_band+1)
  max_pt_group_band = displs(me_band+1) + ntranche - 1
  min_pt =  min_pt_group_fft + min_pt_group_band
  max_pt =  min_pt_group_fft + max_pt_group_band
 else ! no fft parallelism implies that nproc_band = 0
  ntranche = ntranche_group_fft
  min_pt_group_band = 0
  max_pt_group_band = ntranche - 1
  min_pt =  min_pt_group_fft + min_pt_group_band
  max_pt =  min_pt_group_fft + max_pt_group_band
 end if

!DEBUG
!write(6,*)'  min_pt_group_band',  min_pt_group_band
!write(6,*)'  max_pt_group_band',  max_pt_group_band
!write(6,*)'ntranche',ntranche, ntranche_group_fft
!write(6,*)'minmax',min_pt,max_pt
!ENDDEBUG
!end if
 
 call timab(601,2,tsec2) !!#stop# time-counter: initialisation
!###################################################################################
!main loop
 noden : if(calcul_den/=0)then
  call timab(604,1,tsec2) !!#start# time-counter: noden1 

  allocate(rholocal(1:ntranche),alocal(0:nrec,1:ntranche),b2local(0:nrec,1:ntranche))
  rholocal = zero; alocal = zero; b2local = zero

  ipointlocal = 1

  graou2 : do kk = 0,n3-1,gridratio
   do jj = 0,n2-1,gridratio
    do ii = 0,n1-1,gridratio
     ipoint = ii+jj*n1+kk*n1*n2
     if ((ipoint>=min_pt).and.(ipoint<=max_pt))then !computation done by that proc
      if ( ngfftrec(1) >= n1 .and. ngfftrec(2) >= n2 .and. ngfftrec(3) >= n3 ) then
!      call status(ipointlocal,dtfil%filstat,iexit,level,'call recursion')
!      DEBUG
!      !$write(6,*)' '
!      !$write(6,*)'before recursion : echo input variables'
!      !$write(6,*)'exppot', exppot(1,1,:)
!      !$write(6,*)'coord',ii,jj,kk
!      !$write(6,*)'nrec,fermie,tsmear,trotter',nrec,fermie,tsmear,trotter
!      !$write(6,*)'ZT_p', Zt_p(1,1,1,:)
!      !$write(6,*)'get_rec_coef,prtvol',1,prtvol
!      !$write(6,*)'nfft,ngfft',nfftrec,ngfftrec
!      !$write(6,*)'rmet(:,1)',rmet(:,1)
!      !$write(6,*)'inf_ucvol,tim_fourdp',inf_ucvol,0
!      !  write(6,*)'',ipoint, ipointlocal
!      ENDDEBUG
       
       tim_fourdp=6
       call timab(604,2,tsec2)
       call recursion(exppot,ii,jj,kk, &
&       alocal(:,ipointlocal), &
&       b2local(:,ipointlocal), &
&       rholocal(ipointlocal),&
&       nrec, fermie_local,tsmear,trotter, &
&       ZT_p, &
&       tolrec, &
&       1,prtvol,&
&       mpi_enreg_rec,nfftrec,ngfftrec,rmet,inf_ucvol,tim_fourdp) 
       call timab(604,1,tsec2)

       
      else !we use a troncation
       allocate(exppotloc(0:ngfftrec(1)-1,0:ngfftrec(2)-1,0:ngfftrec(3)-1))
       do xx = 0,ngfftrec(1)-1
        do yy = 0,ngfftrec(2)-1
         do zz = 0,ngfftrec(3)-1         
          modi = modulo(ii+xx-ngfftrec(1)/2,n1)
          modj = modulo(jj+yy-ngfftrec(2)/2,n2)
          modk = modulo(kk+zz-ngfftrec(3)/2,n2)
          exppotloc(xx,yy,zz) = exppot(modi,modj,modk)
         end do
        end do
       end do
!      call status(ipointlocal,dtfil%filstat,iexit,level,'call recursion')
       tim_fourdp=6
       call timab(604,2,tsec2)
       call recursion(exppotloc,ngfftrec(1)/2,ngfftrec(2)/2,ngfftrec(3)/2, &
&       alocal(:,ipointlocal), &
&       b2local(:,ipointlocal), &
&       rholocal(ipointlocal),&
&       nrec, fermie_local,tsmear,trotter, &
&       ZT_p, &
&       tolrec, &
&       1,prtvol,&
&       mpi_enreg_rec,nfftrec,ngfftrec,rmet,inf_ucvol,tim_fourdp)

       call timab(604,1,tsec2)
       deallocate(exppotloc)
      end if
      ipointlocal =   ipointlocal + 1
      
     end if
    end do
   end do
  end do graou2
  write(6,*)'end graou2'
  write(6,*)'----------------------'
  call timab(604,2,tsec2)


! !#############################################################
! !  add_marco 
! ! ASSIGNATION PARAMETERS TO MENAGE PARALLELISME OF TRANSGRID
  call timab(605,1,tsec2)
  if (gridratio>1) then
   
   write(6,*)'----------------------'
   write(6,*)'TRANSGRID USING'  

!  bufsize contains the values of the number of points calculated
!  by any proc on the coarse grid; bufsize_f on the fine grid   
   if(ntranche /=dtset%nfft) then
    allocate(bufsize(0:nproc_rec-1),bufdispl(0:nproc_rec-1))
    allocate(bufsize_f(0:nproc_rec-1),bufdispl_f(0:nproc_rec-1))
    bufsize = zero; bufsize_f = zero
    bufsize(me_rec) = ipointlocal-1
    bufsize_f(me_rec) = ntranche
    
    mpi_enreg%paral_level=3
    call xsum_mpi(bufsize,mpi_enreg%commcart,ierr)
    call xsum_mpi(bufsize_f,mpi_enreg%commcart,ierr)
    mpi_enreg%paral_level=2
    sum_bufsize = sum(bufsize)                                  
    
    bufdispl(0) = 0; bufdispl_f(0) = 0
    do ii1 = 1, nproc_rec-1
     bufdispl(ii1) = bufsize(ii1-1) + bufdispl(ii1-1)        
     bufdispl_f(ii1) = bufsize_f(ii1-1) + bufdispl_f(ii1-1)       
    end do
   end if
   
!  ! End assignation parameter
!  !#############################################################

!  !#############################################################
!  !  TRANSGRID FOR THE DENSITY RHO AND THE COEFFICIENTS AN AND B2N

!  variables allocation---------------------
   allocate(rholocal_f(pawfgr_rec%nfft),rhogf(2,pawfgr_rec%nfft),rhogc(2,pawfgr_rec%nfftc))       
   allocate(rholoc_2(1:pawfgr_rec%nfftc)) 
   allocate(ablocal_2(1:pawfgr_rec%nfftc,0:nrec,2))    
   allocate(ablocal_f(1:pawfgr_rec%nfft,0:nrec,2))    
   allocate(ablocal_1(1:ipointlocal-1,0:nrec,2))

   rholocal_f = zero; ablocal_f = zero; ablocal_2 = zero
   
   ablocal_1(:,:,1) = transpose(alocal(:,1:ipointlocal-1)) 
   ablocal_1(:,:,2) = transpose(b2local(:,1:ipointlocal-1))
   
   if(get_entropy==1 .and. gridratio>1) then
    allocate(aloc_copy(0:nrec,1:ipointlocal-1),b2loc_copy(0:nrec,1:ipointlocal-1))
    aloc_copy = alocal(:,1:ipointlocal-1)
    b2loc_copy = b2local(:,1:ipointlocal-1)
   end if

   if(ntranche == dtset%nfft) then
!   --SEQUENTIAL CASE--
    rholoc_2 = rholocal(1:ipointlocal-1)
    ablocal_2 = ablocal_1
!   --Transigrid: coarse->fine  
    rhogf = zero; rhogc = zero
    call transgrid(1,mpi_enreg_rec,nspden,1,0,0,dtset%paral_kgb,pawfgr_rec,rhogc,rhogf,rholoc_2,rholocal_f)
    do jj1 = 1,2
     do ipoint = 0,nrec
      rhogf = zero; rhogc = zero
      call transgrid(1,mpi_enreg_rec,nspden,1,0,0,dtset%paral_kgb,pawfgr_rec&
&      ,rhogc,rhogf,ablocal_2(:,ipoint,jj1),ablocal_f(:,ipoint,jj1))
     end do
    end do
!   --assignation of the interpolated results on the fine grid--
    rholocal = rholocal_f
    alocal = transpose(ablocal_f(:,:,1))
    b2local = transpose(ablocal_f(:,:,2))
    
   else
!   --PARALLEL CASE--
    rholoc_2 = zero
!   --send on all procs rho,an,bn--
    mpi_enreg%paral_level=3
    call xallgatherv_mpi(rholocal(1:ipointlocal-1),bufsize(me_rec),rholoc_2,bufsize,bufdispl,mpi_enreg%commcart,ierr)
    do ipoint = 0,nrec
     call xallgatherv_mpi(ablocal_1(1:ipointlocal-1,ipoint,1)&
&     ,bufsize(me_rec),ablocal_2(:,ipoint,1),bufsize,bufdispl,mpi_enreg%commcart,ierr)
     call xallgatherv_mpi(ablocal_1(1:ipointlocal-1,ipoint,2)&
&     ,bufsize(me_rec),ablocal_2(:,ipoint,2),bufsize,bufdispl,mpi_enreg%commcart,ierr)
    end do
    mpi_enreg%paral_level=2
    

!   --Transigrid: coarse->fine on differents procs (with respect
!   --  the number of recursion)
    rhogf = zero;  rhogc = zero
    call transgrid(1,mpi_enreg_rec,nspden,1,0,0,dtset%paral_kgb,pawfgr_rec,rhogc,rhogf,rholoc_2,rholocal_f)


    do ipoint = 0,2*(nrec+1)-1
     ii1 = modulo(ipoint,nproc_rec)
     jj1 = 1+modulo(ipoint,2)
     kk1 = floor(ipoint/2.)
     if(maxval(abs(ablocal_2(:,kk1,jj1))) > tol10 .and. me_rec == ii1) then
      rhogf = zero; rhogc = zero
      call transgrid(1,mpi_enreg_rec,nspden,1,0,0,dtset%paral_kgb,pawfgr_rec&
&      ,rhogc,rhogf,ablocal_2(:,kk1,jj1),ablocal_f(:,kk1,jj1))
     end if
    end do

!   --Recuperation of all interpolated results 
!   --  from procs to allprocs 
    mpi_enreg%paral_level = 3
    call xsum_mpi(ablocal_f,mpi_enreg%commcart,ierr)
    mpi_enreg%paral_level = 2
!   --assignation the interpolated results on the fine grid
!   -- any procs obtain the same point as in the standard recursion
    do ii1 = 0, nproc_rec-1
     jj1 = bufdispl_f(ii1)+1
     if(ii1 == me_rec) then
      alocal = transpose(ablocal_f(jj1:jj1+bufsize_f(ii1)-1,:,1))
      b2local = transpose(ablocal_f(jj1:jj1+bufsize_f(ii1)-1,:,2)) 
      rholocal = rholocal_f(jj1:jj1+bufsize_f(ii1)-1)
     end if
    end do
    if(get_entropy/=1) deallocate(bufdispl,bufsize,bufdispl_f,bufsize_f)
   end if

   deallocate(ablocal_f,ablocal_2,ablocal_1)
   deallocate(rhogf,rholocal_f,rhogc,rholoc_2)

   write(6,*) 'END TRANSGRID'  
   write(6,*)'----------------------'
  else
   write(6,*) '-TRANSGRID NOT USED-'  
  end if

  call timab(605,2,tsec2)   
! !  End transgrid
! !###############################################################
  
! ###################################
! fermi energy computation
  call timab(604,1,tsec2)
  nomu : if(calcul_fermie/=0)then
!  trouver le mu convenable 
!  call status(0,dtfil%filstat,iexit,level,'call fermisolv')
   tim_fourdp=0
   call timab(604,2,tsec2)
   call fermisolverec(fermie_local,rholocal,alocal,b2local,nrec, &
&   tsmear,trotter,nelect, &
&   tol10,100, &
&   ntranche,mpi_enreg_rec, me_rec,&
&   rmet,inf_ucvol,tim_fourdp)
   call timab(604,1,tsec2)
  end if nomu

! DEBUG   
! if (prtvol==-level) then
! write(message,'(a)') ' '
! call wrtout(06,message,'COLL')
! write(message,'(a,d16.6)')'  mu                 ',fermie_local
! call wrtout(06,message,'COLL')
! end if
! ENDDEBUG
! end fermi energy computation
! #################################################################
! ######### ENTROPY AND FREE ENERGY COMPUTATION  ##################

  entropy = zero
  free_energy = zero
  noentropie : if(get_entropy==1)then    
   entropy = zero; entropy1 = zero; entropy2 = zero ;entropy3 = zero; entropy4 = zero
   free_energy = zero; free_energy1 = zero ; free_energy2 = zero; free_energy3 = zero; free_energy4 = zero
   
!  seek for the min of the path integral
   potmin = minval(pot)
   xmax = exp(-beta/(2.d0*rtrotter)*(potmin-fermie_local))     
   perc_vmin=1.0d0
   
   if(gridratio>1 .and. ntranche /=dtset%nfft) then
    allocate(rhogf(2,pawfgr_rec%nfft),rhogc(2,pawfgr_rec%nfftc))       
    allocate(entropy_v_f(pawfgr_rec%nfft,0:4))
    allocate(entropy_v_c(pawfgr_rec%nfftc,0:4))
    allocate(entropy_v_2(1:ipointlocal-1,0:4))
    allocate(free_ene_v_f(pawfgr_rec%nfft,0:4))
    allocate(free_ene_v_c(pawfgr_rec%nfftc,0:4))
    allocate(free_ene_v_2(1:ipointlocal-1,0:4))
    
    entropy_v_c = zero; entropy_v_f = zero; entropy_v_2 = zero
    free_ene_v_c = zero; free_ene_v_f = zero; free_ene_v_2 = zero

    call timab(604,2,tsec2)
    do ipoint = 1,ipointlocal-1
     call entropyrec(exp(beta*fermie_local/(2.d0*rtrotter))*aloc_copy(:,ipoint), &
&     exp(beta*fermie_local/rtrotter)*b2loc_copy(:,ipoint), &
&     nrec,trotter,entropy_v_2(ipoint,0),2.d0,&
&     prtvol,n_pt_integ_entropy,perc_vmin*xmax,&
&     entropy_v_2(ipoint,1),entropy_v_2(ipoint,2),entropy_v_2(ipoint,3),entropy_v_2(ipoint,4))

     call free_energyrec(exp(beta*fermie_local/(2.d0*rtrotter))*aloc_copy(:,ipoint), &
&     exp(beta*fermie_local/rtrotter)*b2loc_copy(:,ipoint), &
&     nrec,trotter,free_ene_v_2(ipoint,0),2.d0,& !/ucvol,&
&     prtvol,n_pt_integ_entropy,perc_vmin*xmax,&
&     free_ene_v_2(ipoint,1),free_ene_v_2(ipoint,2),free_ene_v_2(ipoint,3),free_ene_v_2(ipoint,4))      

    end do
    call timab(604,1,tsec2) 
    
    deallocate(aloc_copy,b2loc_copy)
    
    do ii1 = 0,4
     mpi_enreg%paral_level=3
     call xallgatherv_mpi(entropy_v_2(:,ii1),bufsize(me_rec)&
&     ,entropy_v_c(:,ii1),bufsize,bufdispl,mpi_enreg%commcart,ierr)   
     call xallgatherv_mpi(free_ene_v_2(:,ii1),bufsize(me_rec)&
&     ,free_ene_v_c(:,ii1),bufsize,bufdispl,mpi_enreg%commcart,ierr)   
     mpi_enreg%paral_level=2
     
     if(maxval(abs(entropy_v_c(:,ii1))) > tol10) then
      rhogf = zero; rhogc = zero
      call transgrid(1,mpi_enreg_rec,nspden,1,0,0,dtset%paral_kgb&
&      ,pawfgr_rec,rhogc,rhogf,entropy_v_c(:,ii1),entropy_v_f(:,ii1))
     end if
     if(maxval(abs(free_ene_v_c(:,ii1))) >tol10) then
      rhogf = zero; rhogc = zero
      call transgrid(1,mpi_enreg_rec,nspden,1,0,0,dtset%paral_kgb&
&      ,pawfgr_rec,rhogc,rhogf,free_ene_v_c(:,ii1),free_ene_v_f(:,ii1))
     end if
    end do

    entropy = sum(entropy_v_f(:,0))
    entropy1 = sum(entropy_v_f(:,1))
    entropy2 = sum(entropy_v_f(:,2))
    entropy3 = sum(entropy_v_f(:,3))
    entropy4 = sum(entropy_v_f(:,4))

    free_energy = sum(free_ene_v_f(:,0))
    free_energy1 = sum(free_ene_v_f(:,1))
    free_energy2 = sum(free_ene_v_f(:,2))
    free_energy3 = sum(free_ene_v_f(:,3))
    free_energy4 = sum(free_ene_v_f(:,4))

    deallocate(bufdispl,bufsize,bufdispl_f,bufsize_f)
    deallocate(entropy_v_f,entropy_v_c,entropy_v_2, rhogf,rhogc)
    deallocate(free_ene_v_f,free_ene_v_c,free_ene_v_2)

   else if(gridratio == 1 .or. ntranche == dtset%nfft) then
    do ipoint = 1,ntranche
     call timab(604,2,tsec2) 
     call entropyrec(exp(beta*fermie_local/(2.d0*rtrotter))*alocal(:,ipoint), &
&     exp(beta*fermie_local/rtrotter)*b2local(:,ipoint), &
&     nrec,trotter,entropylocal,2.d0,&
&     prtvol,n_pt_integ_entropy,perc_vmin*xmax,&
&     entropylocal1,entropylocal2,entropylocal3,entropylocal4)
     call free_energyrec(exp(beta*fermie_local/(2.d0*rtrotter))*alocal(:,ipoint), &
&     exp(beta*fermie_local/rtrotter)*b2local(:,ipoint), &
&     nrec,trotter,free_energy_local,2.d0,& !/ucvol,&
&     prtvol,n_pt_integ_entropy,perc_vmin*xmax,&
&     free_energy_local1,free_energy_local2&
&     ,free_energy_local3,free_energy_local4)
     call timab(604,1,tsec2)
     
     call timab(604,1,tsec2) 
     entropy = entropy + entropylocal
!    DEBUG
!    entropy1 = entropy1 + entropylocal1
!    entropy2 = entropy2 + entropylocal2
!    entropy3 = entropy3 + entropylocal3
!    entropy4 = entropy4 + entropylocal4
!    ENDDEBUG
     free_energy = free_energy + free_energy_local
!    DEBUG
!    free_energy1 = free_energy1 + free_energy_local1
!    free_energy2 = free_energy2 + free_energy_local2
!    free_energy3 = free_energy3 + free_energy_local3
!    free_energy4 = free_energy4 + free_energy_local4
!    ENDDEBUG
    end do

    mpi_enreg%paral_level=3
    call xsum_mpi(entropy,mpi_enreg%commcart ,ierr)
    call xsum_mpi(free_energy,mpi_enreg%commcart ,ierr)
!   DEBUG
!   call xsum_mpi(entropy1,mpi_enreg%commcart ,ierr)
!   call xsum_mpi(entropy2,mpi_enreg%commcart ,ierr)
!   call xsum_mpi(entropy3,mpi_enreg%commcart ,ierr)
!   call xsum_mpi(entropy4,mpi_enreg%commcart ,ierr)
!   call xsum_mpi(free_energy1,mpi_enreg%commcart ,ierr)
!   call xsum_mpi(free_energy2,mpi_enreg%commcart ,ierr)
!   call xsum_mpi(free_energy3,mpi_enreg%commcart ,ierr)
!   call xsum_mpi(free_energy4,mpi_enreg%commcart ,ierr)
!   ENDDEBUG
    mpi_enreg%paral_level=2


   else
    write(6,*)' ERROR inconsinstent gridratio '
   end if
   write(6,*)'potmin',potmin
   write(6,*)'entropy',entropy
   write(6,*)'free_energy',free_energy
!  write(6,*)'-omega/T',free_energy

   e_eigenvalues=tsmear*(entropy-free_energy) + fermie_local*nelect
!  !  add marco: in reality free_energy is not the free energy but the
!  !  potential omega=-PV (Landau-potential or gran-potential)
!  !  divided by -T so the internal energy 
!  !  U:=e_eigenvalues= TS+omega+muN = ST-T*sum(ln(1-n))+muN = 
!  !  T(S-free_energy)+muN

  end if noentropie
  
! ##### END ENTROPY AND FREE ENERGY COMPUTATION  ##################
! #################################################################
  

! --------------------------------------------------------
! ! at the first step to find the max number of recursion 
! ! needed to convergence, then redefine nrec.
  if(first==1 .and. dtset%ntime>0) then
   min_nrec = 1
   do ii=1,ntranche
    jj=0  !0:nrec,1:ntranche
    do while (b2local(jj,ii)>tol10 .or.  jj>nrec)
     jj = jj+1
     min_nrec = max(jj,min_nrec)       
    end do
   end do
   write(6,*) 'old nrec',nrec
   min_nrec = min_nrec +1
   mpi_enreg%paral_level=3
   call xmax_mpi(min_nrec,nrec,mpi_enreg%commcart,ierr)
   mpi_enreg%paral_level=2
   write(6,*) 'new nrec',min_nrec
  end if
! --------------------------------------------------------

  deallocate(alocal, b2local)
  call timab(604,2,tsec2) !!#stop# time-counter: noden1
 end if noden


!###########################################
!ek computation

 noekin : if(get_ek==2)then   !! since get_ek always !=2 so no ek calculation
! ! is made. ek is calculated by using entropy and free-energy
  write(6,*)'--------------------'
  write(6,*)'BEGIN EK COMPUTATION'
  call timab(612,1,tsec2) !!#start# time-counter: kinetic energy
  ek = zero

  ngfft_ek(:) = dtset%ngfft(:) 
! For now, recursion method doesn't use paralelism on FFT - which would require a great number of processors 
  ngfft_ek(9)=0              ! paral
  ngfft_ek(10)=1             ! nproc_rec
  ngfft_ek(11)=0             ! me_rec
  ngfft_ek(12)= ngfft_ek(2)  ! n2proc
  ngfft_ek(13)= ngfft_ek(3)  ! n3proc
  
! !$write(6,*)'green kernel (2)'
  allocate(ZT_p_G(1:2,0:n1-1,0:n2-1,0:n3-1))

  if(.false.)then !(ngfftrec(1)<n1 .or. ngfftrec(2)<n2 .or. ngfftrec(3)<n3)then ! T_p should not be truncated in ekin computation > new computation of ZT_p
   allocate(ZT_ptempo(1:2,0:nfftot-1))
   call timab(612,2,tsec2)
   call green_kernel(ZT_ptempo,inf_rmet,inf_ucvol,rtrotter/beta,mpi_enreg_rec,dtset%ngfft,nfftot,0)
   call timab(612,1,tsec2)
   ZT_p_G(:,:,:,:) =  real(nfftot,dp)*reshape(source=ZT_ptempo,shape=shape(ZT_p_G))
   deallocate(ZT_ptempo)
  else
   ZT_p_G(:,:,:,:) = ZT_p(:,:,:,:)
  end if
  
  iklocal = 1
  if(mk>minval((dtset%ngfft(1:3)-1)/2))then
   mk = minval((dtset%ngfft(1:3)-1)/2)
  end if
  nk = 2*mk + 1
  
  reste_k = modulo(nk**3,nproc_rec) ! no npband paralellism
  ntranche_k = nk**3/nproc_rec
  if (me_rec<reste_k) then
   ntranche_k = ntranche_k + 1
   min_k = me_rec*ntranche_k
   max_k = (me_rec+1)*ntranche_k-1
  else
   min_k = me_rec*ntranche_k + reste_k
   max_k = (me_rec+1)*ntranche_k-1 + reste_k
  end if
  allocate(a_k(0:nrec_k,1:ntranche_k),b2_k(0:nrec_k,1:ntranche_k))
  graouekin : do kx = -mk,mk
   do ky =  -mk,mk
    do kz =  -mk,mk
     ik = (kz+mk)+(ky+mk)*nk+(kx+mk)*nk**2
     if ((ik>=min_k).and.(ik<=max_k))then !computation done by that proc for that k 
      if(kx/=0.or.ky/=0.or.kz/=0)then   !to be modified
       tim_fourdp=7
       call timab(612,2,tsec2)
       call recursion(exppot,kx,ky,kz, &
&       a_k(:,iklocal), &
&       b2_k(:,iklocal), &
&       ekink, &
&       nrec_k, fermie_local,tsmear,trotter, &
&       ZT_p_G, &
&       tolrec, &
&       2,prtvol,&
&       mpi_enreg_rec,nfftot,ngfft_ek,rmet,inf_ucvol,tim_fourdp)

       if ((kx == -mk .and. ky == 0 .and. kz == 0).or.&
&       (kx == 0 .and. ky == -mk .and. kz == 0).or.&
&       (kx == 0 .and. ky == 0 .and. kz == -mk).or.&
&       (kx == mk .and. ky == 0 .and. kz == 0).or.&
&       (kx == 0 .and. ky == mk .and. kz == 0).or.&
&       (kx == 0 .and. ky == 0 .and. kz == mk)) then
        write(6,*)'k',kx,ky,kz
        write(6,*)'ekink', ekink
       end if
       
       ek = ek + ekink
!      DEBUG
!      if(modulo(ik,500)==0)write(71,*)'recursion for ekin',ik,tsec2
!      ENDDEBUG
      end if
      iklocal = iklocal+1  
     end if
    end do
   end do
  end do graouekin
  
  mpi_enreg%paral_level=3
  call xsum_mpi(ek,mpi_enreg%commcart  ,ierr)
  mpi_enreg%paral_level=2
  
! DEBUG
! call time_accu(603,return_count2,tsec2)
! write(71,*)'fin recursion for ekin', return_count2,tsec2(1)
! DEBUG
! DEBUG
! if (prtvol==-level) then
! write(message,'(a)') ' '
! call wrtout(06,message,'COLL')
! write(message,'(a,d16.6)')'  ekin               ',ek
! call wrtout(06,message,'COLL')
! end if
! ENDDEBUG
  deallocate(a_k,b2_k,ZT_p_G) 

  write(6,*)'END EK COMPUTATION'
  write(6,*)'------------------' 
  call timab(612,2,tsec2) 
 else 
  ek = zero
 end if noekin

!end ek computation
 
 deallocate(exppot)

 call timab(613,1,tsec2)  
 noden2 : if(calcul_den/=0)then
  write(6,*)'----------------------'
  write(6,*)'BEGIN NODEN 2'
  
! ------------------------------------------------------------------
! check if the convergence is reached for rho
  drho = maxval(abs(rhor(min_pt_group_band+1:max_pt_group_band+1,1)-rholocal(:)))
  drhomax = drho
  mpi_enreg%paral_level=3
  call xmax_mpi(drho,drhomax,mpi_enreg%commcart,ierr)
  mpi_enreg%paral_level=2
  if(drhomax<toldrho)then
   quit=quit+1
  else
   quit=0
  end if
! -------------------------------------------------------------------
  
  rhor(min_pt_group_band+1:max_pt_group_band+1,1)=rholocal(:)
  if(nproc_band /= 0)then
   mpi_enreg%paral_level=3
   call xallgatherv_mpi(rholocal,ntranche,rhor(:,1),recvcounts,displs,mpi_enreg%comm_band,ierr)
   mpi_enreg%paral_level=2
  end if

! --------------------------------------------------------------------
! 2nd EKIN CALCULATION: this method is used

  noekin2 : if(get_ek==1)then
   call timab(612,1,tsec2) !!#start# time-counter: kinetic energy
   intrhov = inf_ucvol*sum(rholocal*vtrial(min_pt_group_band+1:max_pt_group_band+1,1))
   mpi_enreg%paral_level=3
   call xsum_mpi(intrhov,mpi_enreg%commcart ,ierr)
   mpi_enreg%paral_level=2
   
   ek = e_eigenvalues-intrhov
   
!  DEBUG
!  write(6,*)' '
!  write(6,*)'ek, int(rho*V), ek+int(rho*V)', ek, intrhov,  ek+ intrhov
!  write(6,*)'kT*S, kT*sum(ln(...)), diff', tsmear*entropy, tsmear*free_energy, tsmear*(entropy-free_energy) 
!  write(6,*)'kT(S-sum(ln(...))) + mu*nelect', tsmear*(entropy-free_energy) + fermie_local*nelect
!  write(6,*)'e_eigenvalues', e_eigenvalues
!  write(6,*)' '
!  ENDDEBUG
   call timab(613,2,tsec2)  
  end if noekin2
! --------------------------------------------------------------------

  fermie = fermie_local
  
  deallocate( rholocal)
  
  write(6,*)'END OF NODEN 2'
  write(6,*)'---------------------' 
 end if noden2
 call timab(613,2,tsec2)
 
 
!Structured debugging : if prtvol=-level, stop here.
 if(prtvol==-level)then
  write(message,'(a)') '  rhor '
  call wrtout(06,message,'PERS')
  write(6,*)rhor   !pas la bonne methode
  write(message,'(a)') ' '
  call wrtout(06,message,'COLL')
! call time_accu(21,return_count,tsec)
  write(message,'(a,2d10.3)')'  temps recursion    ',tsec
  call wrtout(06,message,'COLL')
  write(message,'(a1,a,a1,a,i1,a)') ch10,' vtorho : exit ',&
&  ch10,'  prtvol=-',level,', debugging mode => stop '
  call wrtout(06,message,'COLL')
  call leave_new('COLL')
 end if

 if(first==1) first=0
 
 call timab(21,2,tsec)
 call timab(600,2,tsec2)
end subroutine vtorhorec
!!***
