!{\src2tex{textfont=tt}}
!!****f* ABINIT/assemblychi0sfq0
!! NAME
!! assemblychi0sfq0
!!
!! FUNCTION
!! Update the imaginary part of the independent particle susceptibility at q==0 for the contribution
!! of one pair of occupied-unoccupied band, for each frequencies
!! taking into account the symmetries of the little group of the external point q
!!
!! Compute chi0(G,G'',io)=chi0(G,G'',io)+\sum_S (rhotwg(G)*rhotwg*(G''))*den(io)
!! where S is a symmetry in reciprocal space 
!! The subroutine also performs the symmetrization of the matrix elements of the 
!! gradient operator and of the commutator of non local pseudopotential operator 
!! with the position operator 
!!
!! COPYRIGHT
!! Copyright (C) 1999-2009 ABINIT group (MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  ikbz=index of the k-point whose contribution to chi0 has to be added, 
!!   if we use symmetries the contribution to chi0 is symmetrized 
!!  isym_kbz=Index of the symmetry such as k = IS k_ibz
!!  itim_kbz=2 if time-reversal has to be used 
!!  my_wl,my_wr= upper and lower frequency considered by this processor
!!  npwe=number of plane waves for chi0
!!  npwepG0=maximum number of G vectors
!!  nomega=number of frequencies
!!  nqlwl=Number of point in qlwl.
!!  qlwl(3,nqlwl)=reciprocal space coordinates of the q wavevectors for long-wavelength limit treatment.
!!  rhotwg(npwe)=density of a pair of occupied-unoccupied states, in reciprocal space
!!  rhotwx(3)=matrix elements of the gradient and of the commutator of the non
!!   local operator with the position operator (the second term in included only if inclvkb=1
!!  den(nomega)=denominator of the susceptibility expression
!!  nsym=number of symmetry operations
!!  Gsph_epsG0<Gvectors_type> Information on the "enlarged" G-sphere used for chi0, it contains umklapp G0 vectors
!!   %ng=number of G vectors in the enlarged sphere, actually MUST be equal to the size of rhotwg
!!   %rottbm1(ng,2,nsym)=index of (IR)^{-1} G where I is the identity or the inversion 
!!   %phmGt(ng,nsym)=phase factors associated to non-simmorphic operations
!!  Ltg_q<little_group_type>=Info on the little group associated to the external q-point.
!!   %timrev=2 it time-reversal is used, 1 otherwise
!!   %nsym_sg=Number of space group symmetries
!!   %wtksym(2,nsym,nkbz)=1 if the symmetry (with or without time-reversal) must be considered for this k-point
!!   %flag_umklp(timrev,nsym)= flag for umklapp processes 
!!    if 1 that the particular operation (IS) requires a G_o to preserve Q, 0 otherwise 
!! Cryst<Crystal_structure>=Info on unit cell and it symmetries
!!   %nsym=Number of symmetry operations.
!!   %symrec(3,3,nsym)=Symmetry operations in reciprocal space (reduced coordinates).
!!    
!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!!  chi0sf(npwe,npwe,nomega)=independent-particle susceptibility matrix in reciprocal space at q==0
!!  lwing_sf(npwe,nomega,nqlwl) = Lower wing
!!  uwing_sf(npwe,nomega,nqlwl) = Upper wing
!!
!! NOTES
!!  Non symmporphic operations are not yet treated
!!
!! PARENTS
!!      cchi0q0
!!
!! CHILDREN
!!      cgerc,zgerc
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine assemblychi0sfq0(nqlwl,qlwl,ikbz,isym_kbz,itim_kbz,nspinor,symchi,npwepG0,npwe,Cryst,Ltg_q,Gsph_epsG0,&
& factocc,my_wl,iomegal,wl,my_wr,iomegar,wr,rhotwx,rhotwg,nomegasf,chi0sf,lwing_sf,uwing_sf)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_errors

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_32_util
 use interfaces_68_gw, except_this_one => assemblychi0sfq0
 use interfaces_linalg
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ikbz,my_wl,my_wr,nomegasf,npwe,npwepG0,nqlwl,nspinor
 integer,intent(in) :: isym_kbz,itim_kbz,symchi,iomegal,iomegar
 real(dp),intent(in) :: factocc,wl,wr 
 type(Little_group),intent(in) :: Ltg_q
 type(Gvectors_type),intent(in) :: Gsph_epsG0 
 type(Crystal_structure),intent(in) :: Cryst
!arrays
 real(dp),intent(in) :: qlwl(3,nqlwl)
 complex(gwpc),intent(inout) :: rhotwg(npwepG0*nspinor**2)
 complex(gwpc),intent(in) :: rhotwx(3)
 complex(gwpc),intent(inout) :: chi0sf(npwe,npwe,my_wl:my_wr)
 complex(dpc),intent(inout) :: lwing_sf(npwe,my_wl:my_wr,nqlwl)
 complex(dpc),intent(inout) :: uwing_sf(npwe,my_wl:my_wr,nqlwl)

!Local variables-------------------------------
!scalars
 integer :: itim,io,isym,iqlwl
 complex(gwpc) :: num 
 complex(gwpc) :: mqg0,mqg0_sym
 character(len=500) :: msg
!arrays
 integer,pointer :: Sm1G(:) 
 real(dp) :: opinv(3,3),qrot(3),b1(3),b2(3),b3(3)
 complex(gwpc),allocatable :: rhotwg_sym(:)
 complex(gwpc),allocatable :: rhotwg_sym_star(:),rhotwg_star(:)
 complex(gwpc),pointer :: phmGt(:)
!************************************************************************

 if (iomegal<my_wl .or. iomegar>my_wr) then 
  write(msg,'(3a,2(a,i5,a,i5))')ch10,&
&  ' assemblychi0sfq0 : Indeces out of boundary ',ch10,&
&  '  my_wl = ',my_wl,' iomegal = ',iomegal,ch10,&
&  '  my_wr = ',my_wr,' iomegar = ',iomegar,ch10
  MSG_PERS_BUG(msg)
  !write(msg,'(2f8.2,2i4)')ep%omegasf(my_wr)*Ha_eV,ep%omegasf(iomegar)*Ha_eV,ibv,ibc ; call wrtout(std_out,msg,'PERS')
 end if 

 b1(:)=two_pi*Gsph_epsG0%gprimd(:,1)
 b2(:)=two_pi*Gsph_epsG0%gprimd(:,2)
 b3(:)=two_pi*Gsph_epsG0%gprimd(:,3)

 SELECT CASE (symchi)

 CASE (0)
  ! 
  ! === Calculation without symmetries ===
  ! * rhotwg(1)= R^-1q*rhotwx_ibz
  ! * rhotwg(1)=-R^-1q*conjg(rhotwx_ibz) for inversion
  ! FIXME My equation reads  -iq* <cSk|\nabla|vSk> = -i \transpose S <ck_i|\nabla\|vk_i>  
  if (nspinor==1) then
   opinv(:,:)=REAL(Cryst%symrec(:,:,isym_kbz),dp)
   call matrginv(opinv,3,3)
   call dosym(opinv,itim_kbz,qlwl(:,1),qrot)
   rhotwg(1)=dotproductqrc(qrot,rhotwx,b1,b2,b3)
   if (itim_kbz==2) rhotwg(1)=CONJG(rhotwg(1))

   if (wl<huge(0.0_dp)*1.d-11) then !this is awful but it is still a first coding
    num=-wl*factocc ! Num is single precision needed for cgerc check factocc
#if defined HAVE_GW_DPC
    call ZGERC(npwe,npwe,num,rhotwg,1,rhotwg,1,chi0sf(:,:,iomegal),npwe)
#else
    call CGERC(npwe,npwe,num,rhotwg,1,rhotwg,1,chi0sf(:,:,iomegal),npwe)
#endif
   end if 
   ! Last point, must accumulate left point but not the right one
   if (iomegar/=nomegasf+1 .and. wr<huge(0.0_dp)*1.d-11) then 
    num=-wr*factocc
#if defined HAVE_GW_DPC
    call ZGERC(npwe,npwe,num,rhotwg,1,rhotwg,1,chi0sf(:,:,iomegar),npwe)
#else
    call CGERC(npwe,npwe,num,rhotwg,1,rhotwg,1,chi0sf(:,:,iomegar),npwe)
#endif
   end if 

   ! === Accumulate heads and wings for each small q ===
   ! * For better performance, this part is not done if nqlwl==1
   !   lwing and uwing will be filled in cchi0q0 after the MPI collective sum

   if (nqlwl>1) then
    allocate(rhotwg_star(npwepG0))
    rhotwg_star = CONJG(rhotwg(1:npwepG0)) 

    do iqlwl=2,nqlwl
     call dosym(opinv,itim_kbz,qlwl(:,iqlwl),qrot)
     mqg0 = dotproductqrc(qrot,rhotwx,b1,b2,b3) !TODO get rid of this
     if (itim_kbz==2) mqg0=CONJG(mqg0)
     rhotwg     (1) =mqg0
     rhotwg_star(1) =CONJG(mqg0)
     !
     if (wl<huge(0.0_dp)*1.d-11) then !this is awful but it is still a first coding    
      num=-wl*factocc ! Num is single precision needed for cgerc check factocc
      lwing_sf(:,iomegal,iqlwl) = lwing_sf(:,iomegal,iqlwl) + rhotwg     (1:npwepG0) * CONJG(mqg0) * num !green_w(io)
      uwing_sf(:,iomegal,iqlwl) = uwing_sf(:,iomegal,iqlwl) + rhotwg_star(1:npwepG0) *       mqg0  * num !green_w(io)
     end if 
     ! Last point, must accumulate left point but not the right one
     if (iomegar/=nomegasf+1 .and. wr<huge(0.0_dp)*1.d-11) then 
      num=-wr*factocc
      lwing_sf(:,iomegar,iqlwl) = lwing_sf(:,iomegar,iqlwl) + rhotwg     (1:npwepG0) * CONJG(mqg0) * num !green_w(io)
      uwing_sf(:,iomegar,iqlwl) = uwing_sf(:,iomegar,iqlwl) + rhotwg_star(1:npwepG0) *       mqg0  * num !green_w(io)
     end if 
    end do ! iqlwl

    deallocate(rhotwg_star)
   end if !nqlwl

  else ! spinorial case
   msg="Spectral method + nspinor==2 not implemented"
   MSG_BUG(msg)
  end if


 CASE (1)
  ! === Notes on the symmetrization of oscillator matrix elements ===
  ! If  Sq = q then  M_G( Sk,q)= e^{-i(q+G)\cdot t} M_{ S^-1G}  (k,q)
  ! If -Sq = q then  M_G(-Sk,q)= e^{-i(q+G)\cdot t} M_{-S^-1G}^*(k,q)
  ! 
  ! In case of an umklapp process 
  ! If  Sq = q+G_o then  M_G( Sk,q)= e^{-i(q+G)\cdot t} M_{ S^-1(G-G_o}   (k,q)
  ! If -Sq = q+G_o then  M_G(-Sk,q)= e^{-i(q+G)\cdot t} M_{-S^-1(G-G-o)}^*(k,q)
  ! 
  ! rhotwg(1)= R^-1q*rhotwx_ibz
  ! rhotwg(1)=-R^-1q*conjg(rhotwx_ibz) for inversion
  !
  if (nspinor==1) then
   allocate(rhotwg_sym(npwe))
   !
   ! === Loop over symmetries of the space group and time-reversal ===
   do isym=1,Ltg_q%nsym_sg
    do itim=1,Ltg_q%timrev

     if (Ltg_q%wtksym(itim,isym,ikbz)==1) then 
      ! === This operation belongs to the little group and has to be considered to reconstruct the BZ ===
      ! TODO this is a hot-spot, should add a test on the umklapp
      !
      phmGt => Gsph_epsG0%phmGt(1:npwe,isym) ! In these 2 lines mind the slicing (1:npwe)
      Sm1G  => Gsph_epsG0%rottbm1(1:npwe,itim,isym)

      opinv(:,:)=REAL(Cryst%symrec(:,:,isym),dp)
      call matrginv(opinv,3,3)
      call dosym(opinv,itim,qlwl(:,1),qrot)

      SELECT CASE (itim)

      CASE (1)
       rhotwg_sym(1:npwe)=rhotwg(Sm1G(1:npwe))*phmGt(1:npwe)
       rhotwg_sym(1)=dotproductqrc(qrot,rhotwx,b1,b2,b3)

      CASE (2) 
       rhotwg_sym(1:npwe)=CONJG(rhotwg(Sm1G(1:npwe)))*phmGt(1:npwe)
       rhotwg_sym(1)=CONJG(dotproductqrc(qrot,rhotwx,b1,b2,b3))

      CASE DEFAULT
       write(msg,'(a,i4)')'Wrong value of itim= ',itim
       MSG_BUG(msg)
      END SELECT
      !
      ! === Multiply elements G,Gp of rhotwg_sym*num and accumulate in chi0sf(G,Gp,io) ===
      if (wl<huge(0.0_dp)*1.d-11) then
       num=-wl*factocc
#if defined HAVE_GW_DPC
       call ZGERC(npwe,npwe,num,rhotwg_sym,1,rhotwg_sym,1,chi0sf(:,:,iomegal),npwe)
#else
       call CGERC(npwe,npwe,num,rhotwg_sym,1,rhotwg_sym,1,chi0sf(:,:,iomegal),npwe)
#endif
      end if
      ! Last point, must accumulate left point but not the right one
      if (iomegar/=nomegasf+1 .and. wr<huge(0.0_dp)*1.d-11) then 
       num=-wr*factocc
#if defined HAVE_GW_DPC
       call ZGERC(npwe,npwe,num,rhotwg_sym,1,rhotwg_sym,1,chi0sf(:,:,iomegar),npwe)
#else
       call CGERC(npwe,npwe,num,rhotwg_sym,1,rhotwg_sym,1,chi0sf(:,:,iomegar),npwe)
#endif
      end if 

      ! === Accumulate heads and wings for each small q ===
      ! * For better performance, this part is not done if nqlwl==1
      !   lwing and uwing will be filled in cchi0q0 after the MPI collective sum
      if (nqlwl>1) then                                                                                                        
       allocate(rhotwg_sym_star(npwe))
       rhotwg_sym_star = CONJG(rhotwg_sym(1:npwe)) 
 
       do iqlwl=2,nqlwl
        call dosym(opinv,itim_kbz,qlwl(:,iqlwl),qrot)
        mqg0_sym = dotproductqrc(qrot,rhotwx,b1,b2,b3) !TODO get rid of this
        if (itim_kbz==2) mqg0_sym=CONJG(mqg0_sym)
        rhotwg_sym     (1) =mqg0_sym
        rhotwg_sym_star(1) =CONJG(mqg0_sym)
        !
        if (wl<huge(0.0_dp)*1.d-11) then !this is awful but it is still a first coding    
         num=-wl*factocc ! Num is single precision needed for cgerc check factocc
         lwing_sf(:,iomegal,iqlwl) = lwing_sf(:,iomegal,iqlwl) + rhotwg_sym_star(1:npwe) * CONJG(mqg0_sym) * num !green_w(io)
         uwing_sf(:,iomegal,iqlwl) = uwing_sf(:,iomegal,iqlwl) + rhotwg_sym_star(1:npwe) *       mqg0_sym  * num !green_w(io)
        end if 
        ! Last point, must accumulate left point but not the right one
        if (iomegar/=nomegasf+1 .and. wr<huge(0.0_dp)*1.d-11) then 
         num=-wr*factocc
         lwing_sf(:,iomegar,iqlwl) = lwing_sf(:,iomegar,iqlwl) + rhotwg_sym_star(1:npwe) * CONJG(mqg0_sym) * num !green_w(io)
         uwing_sf(:,iomegar,iqlwl) = uwing_sf(:,iomegar,iqlwl) + rhotwg_sym_star(1:npwe) *       mqg0_sym  * num !green_w(io)
        end if 
       end do ! iqlwl
 
       deallocate(rhotwg_sym_star)
      end if !nqlwl

     end if !wtksym
    end do !inv
   end do !isym
   deallocate(rhotwg_sym)

  else ! spinorial case
   msg="Spectral method + nspinor==2 not implemented"
   MSG_BUG(msg)
  end if

 CASE DEFAULT
  write(msg,'(a,i4)')'Wrong value of symchi= ',symchi
  MSG_BUG(msg)
 END SELECT

end subroutine assemblychi0sfq0
!!***

!!****f* ABINIT/assemblychi0sf
!! NAME
!! assemblychi0sf
!!
!! FUNCTION
!! Update the imaginary part of the polarizability for the contribution
!! of one pair of occupied-unoccupied band, for each frequencies
!! taking into account the symmetries of the little group of the external point q
!!
!! Compute chi0(G,Gp,io)=chi0(G,Gp,io)+\sum_S (rhotwg(G)*rhotwg*(G''))*den(io)
!! where S are the symmetries of the little group of the external q-point.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2009 ABINIT group (MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  ik_bz=index of the k-point in the bz array whose contribution has to be added to cchi0 
!!   after symmetrization of the matrix elements. 
!!  my_wl,my_wr= upper and lower frequency considered by this processor
!!  npwe=number of plane waves in chi0
!!  npwepG0=maximum number of G vectors
!!  nomegasf=number of frequencies for imaginary part of chi0
!!  nspinor=Number of spinorial components.
!!  symchi= 1 if symmetries can be usd, 0 otherwise
!!  rhotwg(npwe*nspinor**2)=density of a pair of occupied-unoccupied states, in reciprocal space
!!  timrev=if 2, inversion is considered; if 1, inversion is not considered
!!  Gsph_epsG0<Gvectors_type> Information on the "enlarged" G-sphere used for chi0, it contains umklapp G0 vectors
!!   %ng=number of G vectors in the enlarged sphere, actually MUST be equal to the size of rhotwg
!!   %rottbm1(ng,2,nsym)=index of (IR)^{-1} G where I is the identity or the inversion 
!!   %phmGt(ng,nsym)=phase factors associated to non-simmorphic operations
!!  Ltg_q<little_group_type>=Info on the little group associated to the external q-point.
!!   %timrev=2 it time-reversal is used, 1 otherwise
!!   %nsym_sg=Number of space group symmetries
!!   %wtksym(2,nsym,nkbz)=1 if the symmetry (with or without time-reversal) must be considered for this k-point
!!   %flag_umklp(timrev,nsym)= flag for umklapp processes 
!!    if 1 that the particular operation (IS) requires a G_o to preserve Q, 0 otherwise 
!!   %igmG0(npwepG0,timrev,nsym) index of G-G0 in the array gvec
!!  factocc=occupation factor= f_occ*(ockp-occk) (see cchi0.F90)  
!!  wl,wr = weights used to approximate the Dirac function 
!!    
!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!!  chi0sf(npwe,npwe,my_wl:my_wr)= update the imaginary part of the independent-particle 
!!   susceptibility matrix in reciprocal space
!!
!! NOTES
!!  Umklapp processes are not yet implemented 
!! 
!! PARENTS
!!      cchi0
!!
!! CHILDREN
!!      cgerc,zgerc
!!
!! SOURCE

subroutine assemblychi0sf(ik_bz,nspinor,symchi,Ltg_q,npwepG0,npwe,rhotwg,Gsph_epsG0,&
& factocc,my_wl,iomegal,wl,my_wr,iomegar,wr,nomegasf,chi0sf)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_errors

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_linalg
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ik_bz,iomegal,iomegar,my_wl,my_wr,nomegasf,npwe,npwepG0
 integer,intent(in) :: nspinor,symchi
 real(dp),intent(in) :: factocc,wl,wr
 type(Gvectors_type),intent(in) :: Gsph_epsG0
 type(Little_group),intent(in) :: Ltg_q
!arrays
 complex(gwpc),intent(in) :: rhotwg(npwepG0*nspinor**2)
 complex(gwpc),intent(inout) :: chi0sf(npwe,npwe,my_wl:my_wr)

!Local variables-------------------------------
!scalars
 integer :: io,isym,itim
 complex(gwpc) :: num
 character(len=500) :: msg
!arrays
 integer,allocatable :: Sm1_gmG0(:)
 integer,pointer :: gmG0(:)
 complex(gwpc),allocatable :: rhotwg_sym(:)
 complex(gwpc),pointer :: phmGt(:)

! *************************************************************************

#ifdef VMS
!DEC$ ATTRIBUTES ALIAS:'CGERC' :: cgerc
#endif

 if (iomegal < my_wl .or. iomegar > my_wr) then 
   write(msg,'(3a,2(a,i5,a,i5))')ch10,&
&   ' assemblychi0sf : Indeces out of boundary ',ch10,&
&   '  my_wl = ',my_wl,' iomegal = ',iomegal,ch10,&
&   '  my_wr = ',my_wr,' iomegar = ',iomegar,ch10
   MSG_PERS_BUG(msg)
   !write(msg,'(2f8.2,2i4)')ep%omegasf(my_wl)*Ha_eV,ep%omegasf(iomegal)*Ha_eV,ibv,ibc
   !call wrtout(std_out,msg,'PERS')
   !write(msg,'(2f8.2,2i4)')ep%omegasf(my_wr)*Ha_eV,ep%omegasf(iomegar)*Ha_eV,ibv,ibc ; call wrtout(std_out,msg,'PERS')
 end if 

 SELECT CASE (symchi)

 CASE (0)
  ! === Do not use symmetries ===
  if (wl<huge(0.0_dp)*1.d-11) then !FIXME this is awful
   num=-wl*factocc 
#if defined HAVE_GW_DPC
   call ZGERC(npwe,npwe,num,rhotwg,1,rhotwg,1,chi0sf(:,:,iomegal),npwe)
#else
   call CGERC(npwe,npwe,num,rhotwg,1,rhotwg,1,chi0sf(:,:,iomegal),npwe)
#endif
  end if
  ! Last point, must accumulate left point but not the right one
  if (iomegar/=nomegasf+1 .and. wr<huge(0.0_dp)*1.d-11) then 
   num=-wr*factocc
#if defined HAVE_GW_DPC
   call ZGERC(npwe,npwe,num,rhotwg,1,rhotwg,1,chi0sf(:,:,iomegar),npwe)
#else
   call CGERC(npwe,npwe,num,rhotwg,1,rhotwg,1,chi0sf(:,:,iomegar),npwe)
#endif
  end if 

 CASE (1)
  ! Use symmetries to reconstruct oscillator matrix elements
  ! Notes on the symmetrization of the oscillator maxtri elements:
  ! 
  ! If  Sq=q then  M_G^( Sk,q)= e^{-i(q+G)\cdot t} M_{ S^-1G}  (k,q)
  ! If -Sq=q then  M_G^(-Sk,q)= e^{-i(q+G)\cdot t} M_{-S^-1G}^*(k,q)
  ! 
  ! In case of an umklapp process 
  ! If  Sq=q+G_o then  M_G( Sk,q)= e^{-i(q+G)\cdot t} M_{ S^-1(G-G_o}   (k,q)
  ! If -Sq=q+G_o then  M_G(-Sk,q)= e^{-i(q+G)\cdot t} M_{-S^-1(G-G_o)}^*(k,q)
  !
  ! Ltg_q%igmG0(ig,itim,isym) contains the index of G-G0 where ISq=q+G0
  ! Note that there is no need to take into account the phases due to q, 
  ! They cancel in the scalar product ==> phmGt(G,isym)=e^{-iG\cdot t}
  ! 
  ! Mind the slicing of %rottbm1(npwepG0,timrev,nsym) and %phgt(npwepG0,nsym) as 
  ! these arrays, usually, do not conform to rho_twg_sym(npw) !
  ! 
  allocate(rhotwg_sym(npwe))
  allocate(Sm1_gmG0(npwe))
  !
  ! === Loop over symmetries of the space group and time-reversal ===
  do isym=1,Ltg_q%nsym_sg
   do itim=1,Ltg_q%timrev

    if (Ltg_q%wtksym(itim,isym,ik_bz)==1) then 
     ! === This operation belongs to the little group and has to be used to reconstruct BZ ===
     ! TODO this is a hot-spot, should add a test on the umklapp
     !
     phmGt => Gsph_epsG0%phmGt(1:npwe,isym) ! In these 3 lines mind the slicing (1:npwe)
     gmG0 => Ltg_q%igmG0(1:npwe,itim,isym) 
     Sm1_gmG0(1:npwe)=Gsph_epsG0%rottbm1(gmG0(1:npwe),itim,isym)

     SELECT CASE (itim)
     CASE (1)
      !rhotwg_sym(1:npwe)=rhotwg(Sm1_gmG0)*Gsph_epsG0%phmGt(1:npwe,isym)
      rhotwg_sym(1:npwe)=rhotwg(Sm1_gmG0(1:npwe))*phmGt(1:npwe)
     CASE (2) 
      rhotwg_sym(1:npwe)=CONJG(rhotwg(Sm1_gmG0(1:npwe)))*phmGt(1:npwe)
     CASE DEFAULT
      write(msg,'(a,i3)')'Wrong value for itim= ',itim
      MSG_BUG(msg)
     END SELECT

     if (wl<huge(0.0_dp)*1.d-11) then
      num=-wl*factocc
#if defined HAVE_GW_DPC
      call ZGERC(npwe,npwe,num,rhotwg_sym,1,rhotwg_sym,1,chi0sf(:,:,iomegal),npwe)
#else
      call CGERC(npwe,npwe,num,rhotwg_sym,1,rhotwg_sym,1,chi0sf(:,:,iomegal),npwe)
#endif
     end if 
     ! Last point, must accumulate left point but not the right one
     if (iomegar/=nomegasf+1 .and. wr<huge(0.0_dp)*1.d-11) then 
      num=-wr*factocc
#if defined HAVE_GW_DPC
      call ZGERC(npwe,npwe,num,rhotwg_sym,1,rhotwg_sym,1,chi0sf(:,:,iomegar),npwe)
#else
      call CGERC(npwe,npwe,num,rhotwg_sym,1,rhotwg_sym,1,chi0sf(:,:,iomegar),npwe)
#endif
     end if 
    end if !wtksym 

   end do !inv
  end do !isym
  deallocate(rhotwg_sym,Sm1_gmG0)

 CASE DEFAULT
  write(msg,'(a,i4)')'Wrong value for symchi= ',symchi
  MSG_BUG(msg)
 END SELECT

end subroutine assemblychi0sf
!!***
