!{\src2tex{textfont=tt}}
!!****f* ABINIT/bstruct_init
!! NAME
!! bstruct_init
!!
!! FUNCTION
!! This subroutine initializes the bandstructure structured datatype
!!
!! COPYRIGHT
!! Copyright (C) 2002-2009 ABINIT group (XG, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!! bantot=total number of bands (=sum(nband(:))
!! doccde(bantot)=derivative of the occupation numbers with respect to the energy (Ha)
!! eig(bantot)=eigenvalues (hartree)
!! istwfk(nkpt)=parameter that describes the storage of wfs.
!! kptns(3,nkpt)=k points in terms of recip primitive translations
!! nband(nkpt*nsppol)=number of bands
!! nelect=Number of electrons.
!! nkpt=number of k points
!! npwarr(nkpt)=number of planewaves at each k point
!! nsppol=1 for unpolarized, 2 for spin-polarized
!! nspinor=Number of spinor components.
!! occopt=Occupation options (see input variable)
!! occ(bantot)=occupation numbers
!! tphysel=Physical temperature (input variable)
!! tsmear=Temperature of smearing.
!! wtk(nkpt)=weight assigned to each k point
!!
!! OUTPUT
!! bstruct<bstruct_type>=the bandstructure datatype
!!
!! SIDE EFFECTS
!!  %entropy and %fermie initialized to zero.
!!
!! TODO 
!!  It should become a module.
!!
!! PARENTS
!!      gstate,loper3,m_gwannier,mlwfovlp_qp,newsp,nonlinear,respfn
!!      setup_screening,setup_sigma
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine bstruct_init(bantot,bstruct,nelect,doccde,eig,istwfk,kptns,&
& nband,nkpt,npwarr,nsppol,nspinor,tphysel,tsmear,occopt,occ,wtk)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

 use m_electrons, only : put_eneocc_vect

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: bantot,nkpt,nsppol,nspinor,occopt
 real(dp),intent(in) :: nelect,tphysel,tsmear
 type(Bandstructure_type),intent(out) :: bstruct
!arrays
 integer,intent(in) :: istwfk(nkpt),nband(nkpt*nsppol),npwarr(nkpt)
 real(dp),intent(in) :: doccde(bantot),eig(bantot),kptns(3,nkpt),occ(bantot)
 real(dp),intent(in) :: wtk(nkpt)
! *************************************************************************

 ! Copy the scalars
 ! MG TODO here there is a inconsistency in the way occ are treated in the header
 ! (only the states used, bantot. are saved, and the way occ. and energies
 ! are passed to routines (mband,nkpt,nsppol). It might happen that bantot<mband*nktp*nsppol
 ! this should not lead to problems since arrays are passed by reference
 ! anyway the treatment of these arrays have to be rationalized
 bstruct%bantot =bantot
 bstruct%mband  =MAXVAL(nband(1:nkpt*nsppol))
 bstruct%nkpt   =nkpt
 bstruct%nspinor=nspinor
 bstruct%nsppol =nsppol
 bstruct%occopt =occopt
 
 bstruct%entropy=zero  ! Initialize results
 bstruct%fermie =zero  ! Initialize results
 bstruct%nelect =nelect
 bstruct%tphysel=tphysel
 bstruct%tsmear =tsmear

 ! Allocate the components
 allocate(bstruct%nband(nkpt*nsppol))
 allocate(bstruct%istwfk(nkpt))
 allocate(bstruct%npwarr(nkpt))
 allocate(bstruct%kptns(3,nkpt))
 allocate(bstruct%eig   (bstruct%mband,nkpt,nsppol))
 allocate(bstruct%occ   (bstruct%mband,nkpt,nsppol))
 allocate(bstruct%doccde(bstruct%mband,nkpt,nsppol))
 allocate(bstruct%wtk(nkpt))

 ! Copy the arrays
 bstruct%nband(1:nkpt*nsppol)=nband(1:nkpt*nsppol)
 bstruct%istwfk(1:nkpt)      =istwfk(1:nkpt)
 bstruct%npwarr(1:nkpt)      =npwarr(1:nkpt)
 bstruct%kptns(1:3,1:nkpt)   =kptns(1:3,1:nkpt)

 ! In bstruct, energies and occupations are stored in a matrix (mband,nkpt,nsppol).
 ! put_eneocc_vect is used to reshape the values stored in vectorial form.
 call put_eneocc_vect(bstruct,'eig',   eig   ) 
 call put_eneocc_vect(bstruct,'occ',   occ   ) 
 call put_eneocc_vect(bstruct,'doccde',doccde) 

 bstruct%wtk(1:nkpt)=wtk(1:nkpt)

end subroutine bstruct_init
!!***

!!****f* ABINIT/bstruct_clean
!! NAME
!! bstruct_clean
!!
!! FUNCTION
!! This subroutine deallocates the components of the bandstructure structured datatype
!!
!! INPUTS
!!  bstruct<bandstructure_type>=The data type to be deallocated.
!!
!! OUTPUT
!!  Deallocate the dynamic arrays in the bandstructure type.
!!  (only deallocate)
!!
!! PARENTS
!!      gstate,loper3,m_gwannier,mlwfovlp_qp,newsp,nonlinear,respfn,screening
!!      sigma
!!
!! CHILDREN
!!
!! SOURCE

subroutine bstruct_clean(bstruct)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_errors

 implicit none

!Arguments ------------------------------------
!scalars
 type(Bandstructure_type),intent(inout) :: bstruct
! *************************************************************************

 DBG_ENTER("COLL")

!Deallocate all components of bstruct
 deallocate(bstruct%istwfk)
 deallocate(bstruct%nband)
 deallocate(bstruct%npwarr)
 deallocate(bstruct%kptns)
 deallocate(bstruct%eig)
 deallocate(bstruct%occ)
 deallocate(bstruct%doccde)
 deallocate(bstruct%wtk)

 DBG_EXIT("COLL")

end subroutine bstruct_clean
!!***
