!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_coh
!! NAME
!! calc_coh
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 2005-2009 ABINIT group (FB,MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!! iqibz=index of the irreducible q-point in the array qibz, point which is 
!!  related by a symmetry operation to the point q summed over (see csigme). 
!!  This index is also used to treat the integrable coulombian singularity at q=0
!! jb,kb=left and righ band indeces definining the left and right states where the 
!!  partial contribution to the matrix element of $\Sigma_{COH}$ is evaluated
!! ngfft_gw(18)=contain all needed information about 3D FFT for GW wavefuntions,
!!  see ~abinit/doc/input_variables/vargs.htm#ngfft
!! nsig_ab=Number of components in the self-energy operator (1 for collinear magnetism) 
!! npwc=number of plane waves in $\tilde epsilon^{-1}$
!! npwx=number of G vectors in the arrays gvec and vc_sqrt
!! nspinor=Number of spinorial components.
!! nfftot=number of points in real space
!! i_sz=contribution arising from the integrable coulombian singularity at q==0 
!! (see csigme for the method used), note that in case of 3-D systems the factor 
!! 4pi in the coulombian potential is included in the definition of i_sz 
!! gvec(3,npwx)=G vectors in reduced coordinates 
!! vc_sqrt(npwx)= square root of the coulombian matrix elements for this q-point
!! epsm1q_o(npwc,npwc)= contains $\tilde epsilon^{-1}(q,w=0) - \delta_{G Gp}$ for 
!!  the particular q-point considered in the sum
!! wfg2_jk(nfftot)= Fourier Transform of $\u_{jb k}^*(r) u_{kb k}$ 
!! spinrot_k(4)=components of the spinor rotation matrix.
!!
!! OUTPUT
!! sigcohme=partial contribution to the matrix element of 
!!     $<jb k \sigma|\Sigma_{COH} | kb k \sigma>$ 
!!  coming from this single q-point
!!
!! SIDE EFFECTS
!!
!! PARENTS
!!      csigme
!!
!! CHILDREN
!!      rho_tw_g
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine calc_coh(paral_kgb,nspinor,nsig_ab,nfftot,ngfft_gw,tim_fourdp,MPI_enreg,ktabi_k,ktabr_k,spinrot_k,&
& wfr_jb,wfr_kb,npwx,npwc,gvec,epsm1q_o,vc_sqrt,i_sz,iqibz,same_band,sigcohme)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_gwdefs, only : czero_gw, cone_gw

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_68_gw, except_this_one => calc_coh
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iqibz,ktabi_k,nfftot,npwc,npwx,nsig_ab,nspinor,paral_kgb
 integer,intent(in) :: tim_fourdp
 real(dp),intent(in) :: i_sz
 logical,intent(in) :: same_band
 type(MPI_type),intent(inout) :: MPI_enreg
!arrays
 integer,intent(in) :: gvec(3,npwx),ktabr_k(nfftot),ngfft_gw(18)
 real(dp),intent(in) :: spinrot_k(4)
 complex(gwpc),intent(in) :: epsm1q_o(npwc,npwc)
 complex(gwpc),intent(in) :: wfr_kb(nfftot*nspinor),wfr_jb(nfftot*nspinor),vc_sqrt(npwx)
 complex(gwpc),intent(out) :: sigcohme(nsig_ab)

!Local variables-------------------------------
!scalars
 integer :: ig,ig4,ig4x,ig4y,ig4z,igp,igmin,ispinor,map2sphere,ngfft1,ngfft2,ngfft3
 integer :: spad
!arrays
 integer,allocatable :: igfftg0_dummy(:)
 complex(gwpc),allocatable :: test(:),wfg2_jk(:)

! *************************************************************************

!DEBUG
!write(6,*)' calc_coh : enter '
!ENDDEBUG

 allocate(wfg2_jk(nfftot*nspinor))
 !
 ! === Calculate the product of two wfr and Fourier-transform it in recip. space ===
 !call calc_wfwfg(mpi_enreg,paral_kgb,tim_fourdp,ktabr_k,ktabi_k,nfftot,ngfft_gw,wfr_jb,wfr_kb,wfg2_jk)
 !allocate(test(nfftot*nspinor)) ; test=wfg2_jk

 ! TODO for PAW:
 ! 1) add onsite contributions to calc_wfwfg on the FFT box, see paw_rho_tw_g
 ! non-symmporphic phases not needed as wfs are evaluated at the same k-point

 map2sphere=0
 allocate(igfftg0_dummy(map2sphere))
 call rho_tw_g(paral_kgb,nspinor,nfftot,nfftot,ngfft_gw,map2sphere,igfftg0_dummy,&
& wfr_jb,ktabi_k,ktabr_k,cone_gw,spinrot_k,& !ph_mkt  ,& 
& wfr_kb,ktabi_k,ktabr_k,cone_gw,spinrot_k,& !ph_mkgwt,& 
& nspinor,wfg2_jk,tim_fourdp,MPI_enreg)
 deallocate(igfftg0_dummy)

 !if (allocated(test)) then
 ! write(std_out,*)' == COH test == ',MAXVAL(ABS(test-wfg2_jk))
 ! deallocate(test)
 !end if
 !
 ! === Set up of \epsilon^{-1} vc_sqrt(q,G) vc_sqrt(q,Gp) ===
 ! * vc_sqrt contains sqrt(vc) i.e 4\pi/|q+G| in 3-D systems
! do igp=1,npwc
!  do ig=1,npwc
!   epsm1q_o(ig,igp) = epsm1q_o(ig,igp)*vc_sqrt(ig)*vc_sqrt(igp)
!  end do
! end do
 !
 ! === Treat the case q --> 0 adequately ===
 ! TODO Better treatment of wings     
 !      check cutoff in the coulombian interaction.
 if (iqibz==1) then
  igmin=2
 else
  igmin=1
 end if
 !
 ! === Partial contribution to the matrix element of Sigma_c ===
 ! * For nspinor==2, the closure relation reads: 
 !  $\sum_s \psi_a^*(1)\psi_b(2) = \delta_{ab} \delta(1-2)$
 !  where a,b are the spinor components. As a consequence, Sigma_{COH} is always 
 !  diagonal in spin-space and only diagonal matrix elements have to be calculated.
 ! MG  TODO wfg2_jk should be calculated on an augmented FFT box to avoid spurious wrapping of G1-G2.
 !
 ngfft1=ngfft_gw(1) 
 ngfft2=ngfft_gw(2) 
 ngfft3=ngfft_gw(3)
 sigcohme(:)=czero_gw

 do ispinor=1,nspinor
  spad=(ispinor-1)*nfftot

  do igp=igmin,npwc
   do ig=igmin,npwc
    ig4x=MODULO(gvec(1,igp)-gvec(1,ig),ngfft1)
    ig4y=MODULO(gvec(2,igp)-gvec(2,ig),ngfft2)
    ig4z=MODULO(gvec(3,igp)-gvec(3,ig),ngfft3)
    ig4= 1+ig4x+ig4y*ngfft1+ig4z*ngfft1*ngfft2
    sigcohme(ispinor) = sigcohme(ispinor) + half*wfg2_jk(spad+ig4)*epsm1q_o(ig,igp)*vc_sqrt(ig)*vc_sqrt(igp)
   end do
  end do
  if(iqibz==1.AND.same_band) sigcohme(ispinor) = sigcohme(ispinor) + half*wfg2_jk(spad+ig4)*epsm1q_o(1,1)*i_sz

 end do !ispinor

 deallocate(wfg2_jk)

end subroutine calc_coh
!!***


!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_coh_comp
!! NAME
!! calc_coh_comp
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 2005-2009 ABINIT group (FB,MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!! iqibz=index of the irreducible q-point in the array qibz, point which is 
!!  related by a symmetry operation to the point q summed over (see csigme). 
!!  This index is also used to treat the integrable coulombian singularity at q=0
!! jb,kb=left and righ band indeces definining the left and right states where the 
!!  partial contribution to the matrix element of $\Sigma_{COH}$ is evaluated
!! ngfft_gw(18)=contain all needed information about 3D FFT for GW wavefuntions,
!!  see ~abinit/doc/input_variables/vargs.htm#ngfft
!! nsig_ab=Number of components in the self-energy operator (1 for collinear magnetism) 
!! npwc=number of plane waves in $\tilde epsilon^{-1}$
!! npwx=number of G vectors in the arrays gvec and vc_sqrt
!! nspinor=Number of spinorial components.
!! nfftot=number of points in real space
!! i_sz=contribution arising from the integrable coulombian singularity at q==0 
!! (see csigme for the method used), note that in case of 3-D systems the factor 
!! 4pi in the coulombian potential is included in the definition of i_sz 
!! gvec(3,npwx)=G vectors in reduced coordinates 
!! vc_sqrt(npwx)= square root of the coulombian matrix elements for this q-point
!! epsm1q_o(npwc,npwc)= contains $\tilde epsilon^{-1}(q,w=0) - \delta_{G Gp}$ for 
!!  the particular q-point considered in the sum
!! wfg2_jk(nfftot)= Fourier Transform of $\u_{jb k}^*(r) u_{kb k}$ 
!! spinrot_k(4)=components of the spinor rotation matrix.
!!
!! OUTPUT
!! sigcohme=partial contribution to the matrix element of 
!!     $<jb k \sigma|\Sigma_{COH} | kb k \sigma>$ 
!!  coming from this single q-point for completeness trick
!!
!! SIDE EFFECTS
!!
!! PARENTS
!!      csigme
!!
!! CHILDREN
!!      rho_tw_g
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine calc_coh_comp(paral_kgb,nspinor,nsig_ab,nfftot,ngfft_gw,tim_fourdp,MPI_enreg,ktabi_k,ktabr_k,spinrot_k,&
& wfr_jb,wfr_kb,npwx,npwc,gvec,botsq,otq,ediff,vc_sqrt,i_sz,iqibz,same_band,sigcohme)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_gwdefs, only : czero_gw, cone_gw

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_68_gw, except_this_one => calc_coh_comp
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iqibz,ktabi_k,nfftot,npwc,npwx,nsig_ab,nspinor,paral_kgb
 integer,intent(in) :: tim_fourdp
 real(dp),intent(in) :: i_sz,ediff
 logical,intent(in) :: same_band
 type(MPI_type),intent(inout) :: MPI_enreg
!arrays
 integer,intent(in) :: gvec(3,npwx),ktabr_k(nfftot),ngfft_gw(18)
 real(dp),intent(in) :: spinrot_k(4)
 complex(gwpc),intent(in) :: botsq(npwc,npwc),otq(npwc,npwc)
 complex(gwpc),intent(in) :: wfr_kb(nfftot*nspinor),wfr_jb(nfftot*nspinor),vc_sqrt(npwx)
 complex(gwpc),intent(out) :: sigcohme(nsig_ab)

!Local variables-------------------------------
!scalars
 integer :: ig,ig4,ig4x,ig4y,ig4z,igp,igmin,ispinor,map2sphere,ngfft1,ngfft2,ngfft3
 integer :: spad
!arrays
 integer,allocatable :: igfftg0_dummy(:)
 complex(gwpc),allocatable :: test(:),wfg2_jk(:)

! *************************************************************************

!DEBUG
!write(6,*)' calc_coh_comp : enter '
!ENDDEBUG

 allocate(wfg2_jk(nfftot*nspinor))
 !
 ! === Calculate the product of two wfr and Fourier-transform it in recip. space ===
 !call calc_wfwfg(mpi_enreg,paral_kgb,tim_fourdp,ktabr_k,ktabi_k,nfftot,ngfft_gw,wfr_jb,wfr_kb,wfg2_jk)
 !allocate(test(nfftot*nspinor)) ; test=wfg2_jk

 ! TODO for PAW:
 ! 1) add onsite contributions to calc_wfwfg on the FFT box, see paw_rho_tw_g
 ! non-symmporphic phases not needed as wfs are evaluated at the same k-point

 map2sphere=0
 allocate(igfftg0_dummy(map2sphere))
 call rho_tw_g(paral_kgb,nspinor,nfftot,nfftot,ngfft_gw,map2sphere,igfftg0_dummy,&
& wfr_jb,ktabi_k,ktabr_k,cone_gw,spinrot_k,& !ph_mkt  ,& 
& wfr_kb,ktabi_k,ktabr_k,cone_gw,spinrot_k,& !ph_mkgwt,& 
& nspinor,wfg2_jk,tim_fourdp,MPI_enreg)
 deallocate(igfftg0_dummy)

 !if (allocated(test)) then
 ! write(std_out,*)' == COH test == ',MAXVAL(ABS(test-wfg2_jk))
 ! deallocate(test)
 !end if
 !
 ! === Set up of \epsilon^{-1} vc_sqrt(q,G) vc_sqrt(q,Gp) ===
 ! * vc_sqrt contains sqrt(vc) i.e 4\pi/|q+G| in 3-D systems
! do igp=1,npwc
!  do ig=1,npwc
!   epsm1q_o(ig,igp) = epsm1q_o(ig,igp)*vc_sqrt(ig)*vc_sqrt(igp)
!  end do
! end do
 !
 ! === Treat the case q --> 0 adequately ===
 ! TODO Better treatment of wings     
 !      check cutoff in the coulombian interaction.
 if (iqibz==1) then
  igmin=2
 else
  igmin=1
 end if
 !
 ! === Partial contribution to the matrix element of Sigma_c ===
 ! * For nspinor==2, the closure relation reads: 
 !  $\sum_s \psi_a^*(1)\psi_b(2) = \delta_{ab} \delta(1-2)$
 !  where a,b are the spinor components. As a consequence, Sigma_{COH} is always 
 !  diagonal in spin-space and only diagonal matrix elements have to be calculated.
 ! MG  TODO wfg2_jk should be calculated on an augmented FFT box to avoid spurious wrapping of G1-G2.
 !
 ngfft1=ngfft_gw(1) 
 ngfft2=ngfft_gw(2) 
 ngfft3=ngfft_gw(3)
 sigcohme(:)=czero_gw

 do ispinor=1,nspinor
  spad=(ispinor-1)*nfftot

  do igp=igmin,npwc
   do ig=igmin,npwc
    ig4x=MODULO(gvec(1,igp)-gvec(1,ig),ngfft1)
    ig4y=MODULO(gvec(2,igp)-gvec(2,ig),ngfft2)
    ig4z=MODULO(gvec(3,igp)-gvec(3,ig),ngfft3)
    ig4= 1+ig4x+ig4y*ngfft1+ig4z*ngfft1*ngfft2
    sigcohme(ispinor) = sigcohme(ispinor) + half*wfg2_jk(spad+ig4)*vc_sqrt(ig)*vc_sqrt(igp)&
&                      * botsq(ig,igp) / ( otq(ig,igp) * ( ediff -otq(ig,igp) ) )
   end do
  end do
  if(iqibz==1.AND.same_band) sigcohme(ispinor) = sigcohme(ispinor) + half*wfg2_jk(spad+ig4)*i_sz&
&                                               * botsq(1,1) / ( otq(1,1) * ( ediff -otq(1,1) ) )

 end do !ispinor

 deallocate(wfg2_jk)

end subroutine calc_coh_comp
!!***
