!{\src2tex{textfont=tt}}
!!****f* ABINIT/check_zarot
!! NAME
!! check_zarot
!!
!! FUNCTION
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2009 ABINIT group (the_author)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  argin(sizein)=description
!!
!! OUTPUT
!!  argout(sizeout)=description
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!
!! CHILDREN
!!      initmpi_seq,initylmg,mati3inv,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine check_zarot(npwvec,Cryst,gvec,psps,pawang,grottb,grottbm1)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_32_util
 use interfaces_51_manage_mpi
 use interfaces_56_recipspace
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: npwvec
 type(Crystal_structure),intent(in) :: Cryst
 type(pawang_type),intent(in) :: pawang
 type(pseudopotential_type),intent(in) :: psps
!arrays
 integer,intent(in) :: grottb(npwvec,Cryst%timrev,Cryst%nsym),grottbm1(npwvec,Cryst%timrev,Cryst%nsym)
 integer,intent(in) :: gvec(3,npwvec)

!Local variables-------------------------------
!scalars
 integer :: aa,ig,ig_sym,iginv_sym,ii,ilpa,ilpm,isym,itim,jj,ll,lmax,mm,mqmem_
 integer :: nqpt_,optder,sign_l,two_lmaxp1
 real(dp) :: err,max_diff,test,tmp,ylm_sym
 logical :: found
 character(len=500) :: message
 type(MPI_type) :: mpi_enreg_seq
!arrays
 integer :: toinv(Cryst%nsym),trial(3,3)
 integer,allocatable :: nband(:),npwarr(:)
 real(dp),allocatable :: DS_mmpl(:,:,:),DSinv_mmpl(:,:,:),qptns(:,:),ylm_q(:,:)
 real(dp),allocatable :: ylmgr_q(:,:,:)


! *************************************************************************

 write(message,'(a)')' check_zarot  : enter '
 call wrtout(std_out,message,'COLL') 

 do jj=1,Cryst%nsym 
  found=.FALSE.
  do ii=1,Cryst%nsym
   call mati3inv(Cryst%symrec(:,:,ii),trial) 
   trial=transpose(trial)
   if (ALL(trial==Cryst%symrec(:,:,jj))) then
    toinv(jj)=ii
    found=.TRUE.
    exit
   end if
  end do
  if (.not. found) stop "inverse not found! "
 end do

 mqmem_=1 ; nqpt_=1 ; optder=0
 allocate(npwarr(mqmem_),qptns(3,mqmem_)) 
 npwarr(:)=npwvec ; qptns(:,:)=zero

 lmax=psps%mpsang-1
 write(*,*)'lmax= ',lmax
 allocate(ylm_q(npwvec*mqmem_,(lmax+1)**2))
 allocate(ylmgr_q(npwvec*mqmem_,3+6*(optder/2),(lmax+1)**2))
 call initmpi_seq(mpi_enreg_seq) 
 allocate(nband(1)) ; nband=0

 ! Note: dtset%nband and dtset%nsppol are not used in sequential mode
 call initylmg(Cryst%gprimd,gvec,qptns,mqmem_,mpi_enreg_seq,psps%mpsang,npwvec,nband,nqpt_,npwarr,0,optder,&
& Cryst%rprimd,1,1,ylm_q,ylmgr_q)

 allocate(DS_mmpl(2*lmax+1,2*lmax+1,lmax+1))
 allocate(DSinv_mmpl(2*lmax+1,2*lmax+1,lmax+1))
 max_diff=zero ; test=zero

 do ig=1,npwvec
  if (ig==1) cycle

  do isym=1,Cryst%nsym
   do itim=1,Cryst%timrev

    ig_sym=grottb(ig,itim,isym) !index of IS G
    DS_mmpl(:,:,:)=pawang%zarot(:,:,:,isym)

    iginv_sym=grottbm1(ig,itim,isym) !index of (IS)^-1 G
    DSinv_mmpl(:,:,:)=pawang%zarot(:,:,:,toinv(isym))

    do ll=0,lmax
     do mm=1,2*ll+1
      ilpm=1+ll**2+ll+(mm-1-ll)
      ylm_sym=ylm_q(ig_sym,ilpm)     !Ylm(IS   G)
      !ylm_sym=ylm_q(iginv_sym,ilpm) !Ylm(IS^-1G)
      !
      ! here we calculate the symmetric
      tmp=zero
      do aa=1,2*ll+1
       test=MAX(test,ABS(DS_mmpl(aa,mm,ll+1)-DSinv_mmpl(mm,aa,ll+1)))
       ilpa=1+ll**2+ll+(aa-1-ll)
       tmp= tmp+ ylm_q(ig,ilpa)*DS_mmpl(aa,mm,ll+1)
      end do
      if (itim==2) tmp=tmp*(-1)**ll
      err=ABS(tmp-ylm_sym)

      if (err > tol6) then
       write(*,*)'WARNING check fort 77'
       write(77,'(6(a,i3),a)')' -- ig: ',ig,' igsym: ',ig_sym,' isym ',isym,' itim:',itim,' ll: ',ll,' mm: ',(mm-1-ll)," --" 
       write(77,*)tmp,ylm_sym,ABS(tmp-ylm_sym)
      end if
      max_diff=MAX(max_diff,err)

     end do
    end do !itim

   end do  !isym
  end do !sym
 end do !ig

 write(*,*)"MAX DIFF ",max_diff
 write(*,*)"MAX TEST ",test

 deallocate(DS_mmpl,DSinv_mmpl,nband)
 deallocate(npwarr,qptns) 
 deallocate(ylm_q,ylmgr_q)

end subroutine check_zarot
!!***

