!!****m* ABINIT/interfaces_68_gw
!! NAME
!! interfaces_68_gw
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/68_gw
!!
!! COPYRIGHT
!! Copyright (C) 2009 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: config/scripts/abilint . .
!! 
!!
!! SOURCE

module interfaces_68_gw

 implicit none

interface
 subroutine assemblychi0_sym(ik_bz,nspinor,Ep,Ltg_q,green_w,npwepG0,rhotwg,Gsph_epsG0,chi0)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: ik_bz
  integer,intent(in) :: npwepG0
  integer,intent(in) :: nspinor
  type(epsilonm1_parameters),intent(in) :: Ep
  type(gvectors_type),intent(in) :: Gsph_epsG0
  type(little_group),intent(in) :: Ltg_q
  complex(gwpc),intent(inout) :: chi0(Ep%npwe*Ep%nI,Ep%npwe*Ep%nJ,Ep%nomega)
  complex(dpc),intent(in) :: green_w(Ep%nomega)
  complex(gwpc),intent(in) :: rhotwg(npwepG0*nspinor**2)
 end subroutine assemblychi0_sym
end interface

interface
 subroutine mkrhotwg_sigma(ii,nspinor,npw,rhotwg,rhotwg_I)
  use defs_basis
  implicit none
  integer,intent(in) :: ii
  integer,intent(in) :: npw
  integer,intent(in) :: nspinor
  complex(gwpc),intent(in) :: rhotwg(npw*nspinor**2)
  complex(gwpc),intent(inout) :: rhotwg_I(npw)
 end subroutine mkrhotwg_sigma
end interface

interface
 subroutine assemblychi0q0_sym(nqlwl,qlwl,ik_bz,isym_kbz,itim_kbz,gwcomp,nspinor,npwepG0,Ep,Cryst,Ltg_q,Gsph_epsG0,&  
  &  chi0,rhotwx,rhotwg,green_w,green_enhigh_w,deltaf_b1b2,lwing,uwing)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: gwcomp
  integer,intent(in) :: ik_bz
  integer,intent(in) :: isym_kbz
  integer,intent(in) :: itim_kbz
  integer,intent(in) :: npwepG0
  integer,intent(in) :: nqlwl
  integer,intent(in) :: nspinor
  type(crystal_structure),intent(in) :: Cryst
  type(epsilonm1_parameters),intent(in) :: Ep
  type(gvectors_type),intent(in) :: Gsph_epsG0
  type(little_group),intent(in) :: Ltg_q
  real(dp),intent(in) :: deltaf_b1b2
  complex(gwpc),intent(inout) :: chi0(Ep%npwe*Ep%nI,Ep%npwe*Ep%nJ,Ep%nomega)
  complex(dpc),intent(in) :: green_enhigh_w(Ep%nomega)
  complex(dpc),intent(in) :: green_w(Ep%nomega)
  complex(dpc),intent(inout) :: lwing(Ep%npwe*Ep%nI,Ep%nomega,nqlwl)
  real(dp),intent(in) :: qlwl(3,nqlwl)
  complex(gwpc),intent(inout) :: rhotwg(npwepG0*nspinor**2)
  complex(gwpc),intent(in) :: rhotwx(3,nspinor**2)
  complex(dpc),intent(inout) :: uwing(Ep%npwe*Ep%nJ,Ep%nomega,nqlwl)
 end subroutine assemblychi0q0_sym
end interface

interface
 function q0limit(ii,qlwl,nspinor,rhotwx,b1,b2,b3)
  use defs_basis
  implicit none
  integer,intent(in) :: ii
  integer,intent(in) :: nspinor
  complex(gwpc) :: q0limit
  real(dp),intent(in) :: b1(3)
  real(dp),intent(in) :: b2(3)
  real(dp),intent(in) :: b3(3)
  real(dp),intent(in) :: qlwl(3)
  complex(gwpc),intent(in) :: rhotwx(3,nspinor**2)
 end function q0limit
end interface

interface
 subroutine assemblychi0sfq0(nqlwl,qlwl,ikbz,isym_kbz,itim_kbz,nspinor,symchi,npwepG0,npwe,Cryst,Ltg_q,Gsph_epsG0,&  
  &  factocc,my_wl,iomegal,wl,my_wr,iomegar,wr,rhotwx,rhotwg,nomegasf,chi0sf,lwing_sf,uwing_sf)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: ikbz
  integer,intent(in) :: iomegal
  integer,intent(in) :: iomegar
  integer,intent(in) :: isym_kbz
  integer,intent(in) :: itim_kbz
  integer,intent(in) :: my_wl
  integer,intent(in) :: my_wr
  integer,intent(in) :: nomegasf
  integer,intent(in) :: npwe
  integer,intent(in) :: npwepG0
  integer,intent(in) :: nqlwl
  integer,intent(in) :: nspinor
  integer,intent(in) :: symchi
  type(crystal_structure),intent(in) :: Cryst
  type(gvectors_type),intent(in) :: Gsph_epsG0
  type(little_group),intent(in) :: Ltg_q
  real(dp),intent(in) :: factocc
  real(dp),intent(in) :: wl
  real(dp),intent(in) :: wr
  complex(gwpc),intent(inout) :: chi0sf(npwe,npwe,my_wl:my_wr)
  complex(dpc),intent(inout) :: lwing_sf(npwe,my_wl:my_wr,nqlwl)
  real(dp),intent(in) :: qlwl(3,nqlwl)
  complex(gwpc),intent(inout) :: rhotwg(npwepG0*nspinor**2)
  complex(gwpc),intent(in) :: rhotwx(3)
  complex(dpc),intent(inout) :: uwing_sf(npwe,my_wl:my_wr,nqlwl)
 end subroutine assemblychi0sfq0
end interface

interface
 subroutine assemblychi0sf(ik_bz,nspinor,symchi,Ltg_q,npwepG0,npwe,rhotwg,Gsph_epsG0,&  
  &  factocc,my_wl,iomegal,wl,my_wr,iomegar,wr,nomegasf,chi0sf)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: ik_bz
  integer,intent(in) :: iomegal
  integer,intent(in) :: iomegar
  integer,intent(in) :: my_wl
  integer,intent(in) :: my_wr
  integer,intent(in) :: nomegasf
  integer,intent(in) :: npwe
  integer,intent(in) :: npwepG0
  integer,intent(in) :: nspinor
  integer,intent(in) :: symchi
  type(gvectors_type),intent(in) :: Gsph_epsG0
  type(little_group),intent(in) :: Ltg_q
  real(dp),intent(in) :: factocc
  real(dp),intent(in) :: wl
  real(dp),intent(in) :: wr
  complex(gwpc),intent(inout) :: chi0sf(npwe,npwe,my_wl:my_wr)
  complex(gwpc),intent(in) :: rhotwg(npwepG0*nspinor**2)
 end subroutine assemblychi0sf
end interface

interface
 subroutine init_Bands_Symmetries(kpt_in,Cryst,only_trace,nspinor,nsppol,nbnds,EDIFF_TOL,ene_k,BSym)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: nbnds
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  type(bands_symmetries),intent(out) :: BSym
  type(crystal_structure),intent(in) :: Cryst
  real(dp),intent(in) :: EDIFF_TOL
  logical,intent(in) :: only_trace
  real(dp),intent(in) :: ene_k(nbnds,nsppol)
  real(dp),intent(in) :: kpt_in(3)
 end subroutine init_Bands_Symmetries
end interface

interface
 subroutine print_Bands_Symmetries(Bsym,unitno,prtvol,mode_paral)
  use defs_datatypes
  implicit none
  integer,intent(in),optional :: prtvol
  integer,intent(in),optional :: unitno
  type(bands_symmetries),intent(in) :: BSym
  character(len=4),intent(in),optional :: mode_paral
 end subroutine print_Bands_Symmetries
end interface

interface
 subroutine destroy_Bands_Symmetries(Bsym)
  use defs_datatypes
  implicit none
  type(bands_symmetries),intent(inout) :: BSym
 end subroutine destroy_Bands_Symmetries
end interface

interface
 subroutine destroy_Degenerate_Bands(Cplx)
  use defs_datatypes
  implicit none
  type(degenerate_bands),intent(inout) :: Cplx(:,:)
 end subroutine destroy_Degenerate_Bands
end interface

interface
 subroutine nullify_Bands_Symmetries(BSym)
  use defs_datatypes
  implicit none
  type(bands_symmetries),intent(inout) :: Bsym
 end subroutine nullify_Bands_Symmetries
end interface

interface
 subroutine nullify_Degenerate_Bands(Cplx)
  use defs_datatypes
  implicit none
  type(degenerate_bands),intent(inout) :: Cplx(:,:)
 end subroutine nullify_Degenerate_Bands
end interface

interface
 subroutine get_classes(nsym,symrec,nclass,nelements,elements_idx)
  implicit none
  integer,intent(out) :: nclass
  integer,intent(in) :: nsym
  integer,intent(out) :: elements_idx(nsym,nsym)
  integer,intent(out) :: nelements(nsym)
  integer,intent(in) :: symrec(3,3,nsym)
 end subroutine get_classes
end interface

interface
 subroutine bstruct_init(bantot,bstruct,nelect,doccde,eig,istwfk,kptns,&  
  &  nband,nkpt,npwarr,nsppol,nspinor,tphysel,tsmear,occopt,occ,wtk)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: bantot
  integer,intent(in) :: nkpt
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  integer,intent(in) :: occopt
  type(bandstructure_type),intent(out) :: bstruct
  real(dp),intent(in) :: nelect
  real(dp),intent(in) :: tphysel
  real(dp),intent(in) :: tsmear
  real(dp),intent(in) :: doccde(bantot)
  real(dp),intent(in) :: eig(bantot)
  integer,intent(in) :: istwfk(nkpt)
  real(dp),intent(in) :: kptns(3,nkpt)
  integer,intent(in) :: nband(nkpt*nsppol)
  integer,intent(in) :: npwarr(nkpt)
  real(dp),intent(in) :: occ(bantot)
  real(dp),intent(in) :: wtk(nkpt)
 end subroutine bstruct_init
end interface

interface
 subroutine bstruct_clean(bstruct)
  use defs_datatypes
  implicit none
  type(bandstructure_type),intent(inout) :: bstruct
 end subroutine bstruct_clean
end interface

interface
 subroutine calc_coh(paral_kgb,nspinor,nsig_ab,nfftot,ngfft_gw,tim_fourdp,MPI_enreg,ktabi_k,ktabr_k,spinrot_k,&  
  &  wfr_jb,wfr_kb,npwx,npwc,gvec,epsm1q_o,vc_sqrt,i_sz,iqibz,same_band,sigcohme)
  use defs_basis
  use defs_abitypes
  implicit none
  integer,intent(in) :: iqibz
  integer,intent(in) :: ktabi_k
  integer,intent(in) :: nfftot
  integer,intent(in) :: npwc
  integer,intent(in) :: npwx
  integer,intent(in) :: nsig_ab
  integer,intent(in) :: nspinor
  integer,intent(in) :: paral_kgb
  integer,intent(in) :: tim_fourdp
  type(mpi_type),intent(inout) :: MPI_enreg
  real(dp),intent(in) :: i_sz
  logical,intent(in) :: same_band
  integer,intent(in) :: ngfft_gw(18)
  complex(gwpc),intent(in) :: epsm1q_o(npwc,npwc)
  integer,intent(in) :: gvec(3,npwx)
  integer,intent(in) :: ktabr_k(nfftot)
  complex(gwpc),intent(out) :: sigcohme(nsig_ab)
  real(dp),intent(in) :: spinrot_k(4)
  complex(gwpc),intent(in) :: vc_sqrt(npwx)
  complex(gwpc),intent(in) :: wfr_jb(nfftot*nspinor)
  complex(gwpc),intent(in) :: wfr_kb(nfftot*nspinor)
 end subroutine calc_coh
end interface

interface
 subroutine calc_coh_comp(paral_kgb,nspinor,nsig_ab,nfftot,ngfft_gw,tim_fourdp,MPI_enreg,ktabi_k,ktabr_k,spinrot_k,&  
  &  wfr_jb,wfr_kb,npwx,npwc,gvec,botsq,otq,ediff,vc_sqrt,i_sz,iqibz,same_band,sigcohme)
  use defs_basis
  use defs_abitypes
  implicit none
  integer,intent(in) :: iqibz
  integer,intent(in) :: ktabi_k
  integer,intent(in) :: nfftot
  integer,intent(in) :: npwc
  integer,intent(in) :: npwx
  integer,intent(in) :: nsig_ab
  integer,intent(in) :: nspinor
  integer,intent(in) :: paral_kgb
  integer,intent(in) :: tim_fourdp
  type(mpi_type),intent(inout) :: MPI_enreg
  real(dp),intent(in) :: ediff
  real(dp),intent(in) :: i_sz
  logical,intent(in) :: same_band
  integer,intent(in) :: ngfft_gw(18)
  complex(gwpc),intent(in) :: botsq(npwc,npwc)
  integer,intent(in) :: gvec(3,npwx)
  integer,intent(in) :: ktabr_k(nfftot)
  complex(gwpc),intent(in) :: otq(npwc,npwc)
  complex(gwpc),intent(out) :: sigcohme(nsig_ab)
  real(dp),intent(in) :: spinrot_k(4)
  complex(gwpc),intent(in) :: vc_sqrt(npwx)
  complex(gwpc),intent(in) :: wfr_jb(nfftot*nspinor)
  complex(gwpc),intent(in) :: wfr_kb(nfftot*nspinor)
 end subroutine calc_coh_comp
end interface

interface
 subroutine calc_density(Wfs,ngfftf,nfftf,igfftf,Cryst,Kmesh,Bstr,MPI_enreg,use_MPI,rhor)
  use defs_basis
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: nfftf
  type(bandstructure_type),intent(in) :: Bstr
  type(crystal_structure),intent(in) :: Cryst
  type(bz_mesh_type),intent(in) :: Kmesh
  type(mpi_type),intent(inout) :: MPI_enreg
  type(wavefunctions_information),intent(inout) :: Wfs
  logical,intent(in) :: use_MPI
  integer,intent(in) :: ngfftf(18)
  integer,intent(in) :: igfftf(Wfs%npwwfn)
  real(dp),intent(out) :: rhor(nfftf,Wfs%nspden)
 end subroutine calc_density
end interface

interface
 subroutine test_charge(nfftf,nelectron_exp,nspden,rhor,ucvol,nhat,&  
  &  usepaw,usexcnhat,usefinegrid,compch_sph,compch_fft,omegaplasma)
  use defs_basis
  implicit none
  integer,intent(in) :: nfftf
  integer,intent(in) :: nspden
  integer,intent(in) :: usefinegrid
  integer,intent(in) :: usepaw
  integer,intent(in) :: usexcnhat
  real(dp),intent(in) :: compch_fft
  real(dp),intent(in) :: compch_sph
  real(dp),intent(in) :: nelectron_exp
  real(dp),intent(out) :: omegaplasma
  real(dp),intent(in) :: ucvol
  real(dp),intent(in) :: nhat(nfftf,nspden*usepaw)
  real(dp),intent(inout) :: rhor(nfftf,nspden)
 end subroutine test_charge
end interface

interface
 subroutine calc_ffm(epsm1,nq,npw,nomega,omega,gprimd,qq,ppmodel,gvec,nfmidm)
  use defs_basis
  implicit none
  integer,intent(in) :: nfmidm
  integer,intent(in) :: nomega
  integer,intent(in) :: npw
  integer,intent(in) :: nq
  integer,intent(in) :: ppmodel
  complex(gwpc),intent(in) :: epsm1(npw,npw,nomega,nq)
  real(dp),intent(in) :: gprimd(3,3)
  integer,intent(in) :: gvec(3,npw)
  complex(dpc),intent(in) :: omega(nomega)
  real(dp),intent(in) :: qq(3,nq)
 end subroutine calc_ffm
end interface

interface
 subroutine calc_rpa_functional(iq,Ep,Pvc,Qmesh,Dtfil,gmet,kxc,MPI_enreg,chi0)
  use defs_basis
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: iq
  type(datafiles_type),intent(in) :: Dtfil
  type(epsilonm1_parameters),intent(in) :: Ep
  type(mpi_type),intent(inout) :: MPI_enreg
  type(coulombian_type),intent(in) :: Pvc
  type(bz_mesh_type),intent(in) :: Qmesh
  complex(gwpc),intent(inout) :: chi0(Ep%npwe,Ep%npwe,Ep%nomega)
  real(dp),intent(in) :: gmet(3,3)
  complex(gwpc),intent(in) :: kxc(:,:)
 end subroutine calc_rpa_functional
end interface

interface
 subroutine calc_sig_noppm(npwc,npwx,nspinor,nomega,nomegae,nomegaer,nomegaei,rhotwgp,&  
  &  omega,epsm1q,omegame0i,theta_mu_minus_e0i,ket)
  use defs_basis
  implicit none
  integer,intent(in) :: nomega
  integer,intent(in) :: nomegae
  integer,intent(in) :: nomegaei
  integer,intent(in) :: nomegaer
  integer,intent(in) :: npwc
  integer,intent(in) :: npwx
  integer,intent(in) :: nspinor
  real(dp),intent(in) :: theta_mu_minus_e0i
  complex(gwpc),intent(in) :: epsm1q(npwc,npwc,nomegae)
  complex(gwpc),intent(inout) :: ket(npwc*nspinor,nomega)
  complex(dpc),intent(in) :: omega(nomegae)
  real(dp),intent(in) :: omegame0i(nomega)
  complex(gwpc),intent(in) :: rhotwgp(npwx*nspinor)
 end subroutine calc_sig_noppm
end interface

interface
 subroutine calc_sig_ppm(PPm,nspinor,npwc,nomega,rhotwgp,botsq,otq,&  
  &  omegame0i,zcut,theta_mu_minus_e0i,eig,npwx,ket,sigcme)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: nomega
  integer,intent(in) :: npwc
  integer,intent(in) :: npwx
  integer,intent(in) :: nspinor
  type(ppmodel_type),intent(in) :: PPm
  real(dp),intent(in) :: theta_mu_minus_e0i
  real(dp),intent(in) :: zcut
  complex(gwpc),intent(in) :: botsq(npwc,PPm%dm2_botsq)
  complex(gwpc),intent(in) :: eig(PPm%dm_eig,PPm%dm_eig)
  complex(gwpc),intent(inout) :: ket(npwc*nspinor,nomega)
  real(dp),intent(in) :: omegame0i(nomega)
  complex(gwpc),intent(in) :: otq(npwc,PPm%dm2_otq)
  complex(gwpc),intent(in) :: rhotwgp(npwx*nspinor)
  complex(gwpc),intent(out) :: sigcme(nomega)
 end subroutine calc_sig_ppm
end interface

interface
 subroutine calc_sig_ppm_comp(npwc,nomega,rhotwgp,botsq,otq,omegame0i_io,zcut,theta_mu_minus_e0i,ket,ppmodel,npwx,npwc1,npwc2)
  use defs_basis
  implicit none
  integer,intent(in) :: nomega
  integer,intent(in) :: npwc
  integer,intent(in) :: npwc1
  integer,intent(in) :: npwc2
  integer,intent(in) :: npwx
  integer,intent(in) :: ppmodel
  real(dp),intent(in) :: omegame0i_io
  real(dp),intent(in) :: theta_mu_minus_e0i
  real(dp),intent(in) :: zcut
  complex(gwpc),intent(in) :: botsq(npwc,npwc1)
  complex(gwpc),intent(inout) :: ket(npwc,nomega)
  complex(gwpc),intent(in) :: otq(npwc,npwc2)
  complex(gwpc),intent(in) :: rhotwgp(npwx)
 end subroutine calc_sig_ppm_comp
end interface

interface
 subroutine calc_vHxc_braket(Dtset,Sp,Kmesh,make_newh0,b1,b2,gsqcutf_eff,nfftf_tot,nfftf,ngfftf,igfftf,gvec,&  
  &  Wf_info,vtrial,vhartr,vxc,Psps,Cprj,Pawtab,Paw_an,Pawang,Pawfgrtab,Pawrad,Paw_ij,&  
  &  MPI_enreg,Cryst,rhor,rhog,usexcnhat,nhat,nhatgr,nhatgrdim,vhartr_me,vxcval_me,vxc_me,vUpaw_me,h0_me)
  use defs_basis
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: b1
  integer,intent(in) :: b2
  integer,intent(in) :: make_newh0
  integer,intent(in) :: nfftf
  integer,intent(in) :: nfftf_tot
  integer,intent(in) :: nhatgrdim
  integer,intent(in) :: usexcnhat
  type(crystal_structure),intent(in) :: Cryst
  type(dataset_type),intent(in) :: Dtset
  type(bz_mesh_type),intent(in) :: Kmesh
  type(mpi_type),intent(inout) :: MPI_enreg
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(sigma_parameters),intent(in) :: Sp
  type(wavefunctions_information),intent(inout) :: Wf_info
  real(dp),intent(in) :: gsqcutf_eff
  integer,intent(in) :: ngfftf(18)
  type(cprj_type),intent(in) :: Cprj(Cryst%natom,Dtset%nspinor*Sp%nbnds*Kmesh%nibz*Dtset%nsppol*Dtset%usepaw)
  type(paw_an_type),intent(in) :: Paw_an(Cryst%natom)
  type(paw_ij_type),intent(inout) :: Paw_ij(Cryst%natom)
  type(pawfgrtab_type),intent(inout) :: Pawfgrtab(Cryst%natom)
  type(pawrad_type),intent(in) :: Pawrad(Cryst%ntypat)
  type(pawtab_type),intent(in) :: Pawtab(Cryst%ntypat*Dtset%usepaw)
  integer,intent(in) :: gvec(3,Sp%npwwfn)
  complex(dpc),intent(out) :: h0_me(b1:b2,b1:b2,Kmesh%nibz,Dtset%nsppol*Sp%nsig_ab*make_newh0)
  integer,intent(in) :: igfftf(Wf_info%npwwfn)
  real(dp),intent(in) :: nhat(nfftf,Dtset%nspden*Dtset%usepaw)
  real(dp),intent(in) :: nhatgr(nfftf,Dtset%nspden,3*nhatgrdim)
  real(dp),intent(in) :: rhog(2,nfftf)
  real(dp),intent(in) :: rhor(nfftf,Dtset%nspden)
  complex(dpc),intent(out) :: vUpaw_me(b1:b2,b1:b2,Kmesh%nibz,Dtset%nsppol*Sp%nsig_ab)
  real(dp),intent(in) :: vhartr(nfftf)
  complex(dpc),intent(out) :: vhartr_me(b1:b2,b1:b2,Kmesh%nibz,Dtset%nsppol*Sp%nsig_ab)
  real(dp),intent(in) :: vtrial(nfftf,Dtset%nspden)
  real(dp),intent(in) :: vxc(nfftf,Dtset%nspden)
  complex(dpc),intent(out) :: vxc_me(b1:b2,b1:b2,Kmesh%nibz,Dtset%nsppol*Sp%nsig_ab)
  complex(dpc),intent(out) :: vxcval_me(b1:b2,b1:b2,Kmesh%nibz,Dtset%nsppol*Sp%nsig_ab)
 end subroutine calc_vHxc_braket
end interface

interface
 subroutine update_cprj(natom,nkibz,nbnds,nsppol,nspinor,m_lda_to_qp,dimlmn,Cprj_ibz)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: natom
  integer,intent(in) :: nbnds
  integer,intent(in) :: nkibz
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  type(cprj_type),intent(inout) :: Cprj_ibz(natom,nspinor*nbnds*nkibz*nsppol)
  integer,intent(in) :: dimlmn(natom)
  complex(dpc),intent(in) :: m_lda_to_qp(nbnds,nbnds,nkibz,nsppol)
 end subroutine update_cprj
end interface

interface
 subroutine cchi0(have_valence,Dtset,Cryst,Dtfil,qpoint,Ep,Psps,Kmesh,QP_BSt,&  
  &  Gsph_epsG0,Gsph_wfn,rhoxsp_method,dim1_rhox,dim2_rhox,gvec,&  
  &  Pawang,Pawtab,nbvw,ngfft_gw,igfft,nfftot_gw,chi0,MPI_enreg,ktabr,Ltg_q,rhox_spl,Cprj_bz,chi0sumrule,Wf,Wf_val)
  use defs_basis
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: dim1_rhox
  integer,intent(in) :: dim2_rhox
  integer,intent(in) :: nbvw
  integer,intent(in) :: nfftot_gw
  integer,intent(in) :: rhoxsp_method
  type(crystal_structure),intent(in) :: Cryst
  type(datafiles_type),intent(in) :: Dtfil
  type(dataset_type),intent(in) :: Dtset
  type(epsilonm1_parameters),intent(in) :: Ep
  type(gvectors_type),intent(in) :: Gsph_epsG0
  type(gvectors_type),intent(in) :: Gsph_wfn
  type(bz_mesh_type),intent(in) :: Kmesh
  type(little_group),intent(in) :: Ltg_q
  type(mpi_type),intent(inout) :: MPI_enreg
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(bandstructure_type),intent(in) :: QP_BSt
  type(wavefunctions_information),intent(inout) :: Wf
  type(wavefunctions_information),intent(inout) :: Wf_val
  logical,intent(in) :: have_valence
  integer,intent(in) :: ngfft_gw(18)
  type(cprj_type),intent(in) :: Cprj_bz(Cryst%natom,Dtset%nspinor*Ep%nbnds*Kmesh%nbz*Ep%nsppol*Dtset%usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Psps%ntypat)
  complex(gwpc),intent(out) :: chi0(Ep%npwe*Ep%nI,Ep%npwe*Ep%nJ,Ep%nomega)
  real(dp),intent(out) :: chi0sumrule(Ep%npwe)
  integer,intent(in) :: gvec(3,Ep%npwvec)
  integer,intent(in) :: igfft(Ep%npwepG0,2*Ep%mG0(1)+1,2*Ep%mG0(2)+1,2*Ep%mG0(3)+1)
  integer,intent(in) :: ktabr(nfftot_gw,Kmesh%nbz)
  real(dp),intent(in) :: qpoint(3)
  real(dp),intent(in) :: rhox_spl(Psps%mqgrid_ff,2,0:2*(Psps%mpsang-1), &
  &         Psps%lnmax*(Psps%lnmax+1)/2,Psps%ntypat*Dtset%usepaw)
 end subroutine cchi0
end interface

interface
 function mkG0w(omega,numerator,delta_ene,zcut,TOL_W0,option) result(green0w)
  use defs_basis
  implicit none
  integer,intent(in) :: option
  real(dp),intent(in) :: TOL_W0
  real(dp),intent(in) :: delta_ene
  complex(dpc) :: green0w
  real(dp),intent(in) :: numerator
  complex(dpc),intent(in) :: omega
  real(dp),intent(in) :: zcut
 end function mkG0w
end interface

interface
 subroutine cchi0q0(have_valence,Dtset,Cryst,Dtfil,Ep,Psps,Kmesh,QP_BSt,KS_BSt,&  
  &  Gsph_epsG0,Gsph_wfn,rhoxsp_method,dim1_rhox,dim2_rhox,&  
  &  gvec,Pawang,Pawrad,Pawtab,Paw_ij,ktabr,nbvw,ngfft_gw,igfft,nfftot_gw,chi0,&  
  &  lwing,uwing,MPI_enreg,Ltg_q,pawrhox_spl,Cprj_ibz,Cprj_bz,vkb_dim,vkbsign,vkb,vkbd,chi0sumrule,Wf,Wf_val) 
  use defs_basis
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: dim1_rhox
  integer,intent(in) :: dim2_rhox
  integer,intent(in) :: nbvw
  integer,intent(in) :: nfftot_gw
  integer,intent(in) :: rhoxsp_method
  integer,intent(in) :: vkb_dim
  type(crystal_structure),intent(in) :: Cryst
  type(datafiles_type),intent(in) :: Dtfil
  type(dataset_type),intent(in) :: Dtset
  type(epsilonm1_parameters),intent(in) :: Ep
  type(gvectors_type),intent(in) :: Gsph_epsG0
  type(gvectors_type),intent(in) :: Gsph_wfn
  type(bandstructure_type),intent(in) :: KS_BSt
  type(bz_mesh_type),intent(in) :: Kmesh
  type(little_group),intent(in) :: Ltg_q
  type(mpi_type),intent(inout) :: MPI_enreg
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(bandstructure_type),intent(in) :: QP_BSt
  type(wavefunctions_information),intent(inout) :: Wf
  type(wavefunctions_information),intent(inout) :: Wf_val
  logical,intent(in) :: have_valence
  integer,intent(in) :: ngfft_gw(18)
  type(cprj_type),intent(in) :: Cprj_bz(Cryst%natom,Dtset%nspinor*Ep%nbnds*Kmesh%nbz*Ep%nsppol*Dtset%usepaw)
  type(cprj_type),intent(in) :: Cprj_ibz(Cryst%natom,Dtset%nspinor*Ep%nbnds*Kmesh%nibz*Ep%nsppol*Dtset%usepaw)
  type(paw_ij_type),intent(in) :: Paw_ij(Cryst%natom*Psps%usepaw)
  type(pawrad_type),intent(in) :: Pawrad(Psps%ntypat*Psps%usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Psps%ntypat*Psps%usepaw)
  complex(gwpc),intent(out) :: chi0(Ep%npwe,Ep%npwe,Ep%nomega)
  real(dp),intent(out) :: chi0sumrule(Ep%npwe)
  integer,intent(in) :: gvec(3,Ep%npwvec)
  integer,intent(in) :: igfft(Ep%npwepG0,2*Ep%mG0(1)+1,2*Ep%mG0(2)+1,Ep%mG0(3)+1)
  integer,intent(in) :: ktabr(nfftot_gw,Kmesh%nbz)
  complex(dpc),intent(out) :: lwing(Ep%npwe*Ep%nI,Ep%nomega,Ep%nqlwl)
  real(dp),intent(in) :: pawrhox_spl(Psps%mqgrid_ff,2,0:dim1_rhox, &
  &         dim2_rhox,Cryst%ntypat*Dtset%usepaw)
  complex(dpc),intent(out) :: uwing(Ep%npwe*Ep%nJ,Ep%nomega,Ep%nqlwl)
  real(dp),intent(in) :: vkb(Ep%npwwfn,Dtset%ntypat,Psps%mpsang,Kmesh%nibz*vkb_dim)
  real(dp),intent(in) :: vkbd(Ep%npwwfn,Dtset%ntypat,Psps%mpsang,Kmesh%nibz*vkb_dim)
  real(dp),intent(in) :: vkbsign(Psps%mpsang,Dtset%ntypat*vkb_dim)
 end subroutine cchi0q0
end interface

interface
 subroutine cppm1par(npwc,nqibz,nomega,epsm1,omega,omegaplasma,&  
  &  omegatw,bigomegatwsq) ! optional
  use defs_basis
  implicit none
  integer,intent(in) :: nomega
  integer,intent(in) :: npwc
  integer,intent(in) :: nqibz
  real(dp),intent(in) :: omegaplasma
  complex(gwpc),optional,target,intent(inout) :: bigomegatwsq(npwc,npwc,nqibz)
  complex(gwpc),target,intent(inout) :: epsm1(npwc,npwc,nomega,nqibz)
  complex(dpc),intent(in) :: omega(nomega)
  complex(gwpc),optional,target,intent(inout) :: omegatw(npwc,npwc,nqibz)
 end subroutine cppm1par
end interface

interface
 subroutine cppm2par(paral_kgb,npwc,nqiA,nomega,epsm1,bigomegatwsq,omegatw,&  
  &  ngfftf,gvec,gprimd,rhor,nfftf,Qmesh,gmet,&  
  &  iqiA) ! Optional
  use defs_basis
  use defs_datatypes
  implicit none
  integer,optional,intent(in) :: iqiA
  integer,intent(in) :: nfftf
  integer,intent(in) :: nomega
  integer,intent(in) :: npwc
  integer,intent(in) :: nqiA
  integer,intent(in) :: paral_kgb
  type(bz_mesh_type),intent(in) :: Qmesh
  integer,intent(in) :: ngfftf(18)
  complex(gwpc),intent(inout) :: bigomegatwsq(npwc,npwc,nqiA)
  complex(gwpc),intent(in) :: epsm1(npwc,npwc,nomega,nqiA)
  real(dp),intent(in) :: gmet(3,3)
  real(dp),intent(in) :: gprimd(3,3)
  integer,intent(in) :: gvec(3,npwc)
  complex(gwpc),intent(inout) :: omegatw(npwc,npwc,nqiA)
  real(dp),intent(inout) :: rhor(nfftf)
 end subroutine cppm2par
end interface

interface
 subroutine cppm3par(paral_kgb,npwc,nqiA,nomega,epsm1,bigomegatwsq,omegatw,&  
  &  ngfftf,gvec,gprimd,rho,nfftf,eigtot,Qmesh,&  
  &  iqiA) ! Optional
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in),optional :: iqiA
  integer,intent(in) :: nfftf
  integer,intent(in) :: nomega
  integer,intent(in) :: npwc
  integer,intent(in) :: nqiA
  integer,intent(in) :: paral_kgb
  type(bz_mesh_type),intent(in) :: Qmesh
  integer,intent(in) :: ngfftf(18)
  complex(gwpc),intent(inout) :: bigomegatwsq(npwc,1,nqiA)
  complex(gwpc),intent(inout) :: eigtot(npwc,npwc,nqiA)
  complex(gwpc),intent(in) :: epsm1(npwc,npwc,nomega,nqiA)
  real(dp),intent(in) :: gprimd(3,3)
  integer,intent(in) :: gvec(3,npwc)
  complex(gwpc),intent(inout) :: omegatw(npwc,1,nqiA)
  real(dp),intent(inout) :: rho(nfftf)
 end subroutine cppm3par
end interface

interface
 subroutine cppm4par(paral_kgb,npwc,nqiA,epsm1,nomega,bigomegatwsq,omegatw,ngfftf,gvec,gprimd,rho,nfftf,Qmesh,&  
  &  iqia) ! Optional
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in),optional :: iqiA
  integer,intent(in) :: nfftf
  integer,intent(in) :: nomega
  integer,intent(in) :: npwc
  integer,intent(in) :: nqiA
  integer,intent(in) :: paral_kgb
  type(bz_mesh_type),intent(in) :: Qmesh
  integer,intent(in) :: ngfftf(18)
  complex(gwpc),intent(inout) :: bigomegatwsq(npwc,npwc,nqiA)
  complex(gwpc),intent(in) :: epsm1(npwc,npwc,nomega,nqiA)
  real(dp),intent(in) :: gprimd(3,3)
  integer,intent(in) :: gvec(3,npwc)
  complex(gwpc),intent(inout) :: omegatw(npwc,1,nqiA)
  real(dp),intent(inout) :: rho(nfftf)
 end subroutine cppm4par
end interface

interface
 subroutine cqratio(npwc,gvec,nq,q,gmet,gprimd,qratio)
  use defs_basis
  implicit none
  integer,intent(in) :: npwc
  integer,intent(in) :: nq
  real(dp),intent(in) :: gmet(3,3)
  real(dp),intent(in) :: gprimd(3,3)
  integer,intent(in) :: gvec(3,npwc)
  real(dp),intent(in) :: q(3,nq)
  real(dp),intent(out) :: qratio(npwc,npwc,nq)
 end subroutine cqratio
end interface

interface
 subroutine csigme(ikcalc,rhoxsp_method,dim1_rhox,dim2_rhox,Dtfil,Dtset,Cryst,QP_BSt,Sp,Sr,Er,Gsph_Max,Vcp,Kmesh,Qmesh,&  
  &  Ltg_k,PPm,Pawang,Pawtab,Psps,Cprj_bz,Wf_info,Wf_info_braket,MPI_enreg,pawrhox_spl,gvec,ktabr,&  
  &  ngfft_gw,igfft,nfftgw_tot,my_minb,my_maxb,ngfftf,nfftf,rhor)
  use defs_basis
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: dim1_rhox
  integer,intent(in) :: dim2_rhox
  integer,intent(in) :: ikcalc
  integer,intent(in) :: my_maxb
  integer,intent(in) :: my_minb
  integer,intent(in) :: nfftf
  integer,intent(in) :: nfftgw_tot
  integer,intent(in) :: rhoxsp_method
  type(crystal_structure),intent(in) :: Cryst
  type(datafiles_type),intent(in) :: Dtfil
  type(dataset_type),intent(in) :: Dtset
  type(epsilonm1_results),intent(inout) :: Er
  type(gvectors_type),intent(in) :: Gsph_Max
  type(bz_mesh_type),intent(in) :: Kmesh
  type(little_group),intent(in) :: Ltg_k
  type(mpi_type),intent(inout) :: MPI_enreg
  type(ppmodel_type),intent(inout) :: PPm
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(bandstructure_type),intent(in) :: QP_BSt
  type(bz_mesh_type),intent(in) :: Qmesh
  type(sigma_parameters),intent(in) :: Sp
  type(sigma_results),intent(inout) :: Sr
  type(coulombian_type),intent(in) :: Vcp
  type(wavefunctions_information),intent(inout) :: Wf_info
  type(wavefunctions_information),intent(inout) :: Wf_info_braket
  integer,intent(in) :: ngfft_gw(18)
  integer,intent(in) :: ngfftf(18)
  type(cprj_type),intent(in) :: Cprj_bz(Cryst%natom,Dtset%nspinor*Sp%nbnds*Kmesh%nbz*Sp%nsppol*Dtset%usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Psps%ntypat)
  integer,intent(in) :: gvec(3,Sp%npwvec)
  integer,intent(in) :: igfft(MAX(Sp%npwx,Sp%npwc),2*Sp%mG0(1)+1,2*Sp%mG0(2)+1,2*Sp%mG0(3)+1)
  integer,intent(in) :: ktabr(nfftgw_tot,Kmesh%nbz)
  real(dp),intent(in) :: pawrhox_spl(Psps%mqgrid_ff,2,0:dim1_rhox,dim2_rhox,Cryst%ntypat)
  real(dp),intent(inout) :: rhor(nfftf,Dtset%nspden)
 end subroutine csigme
end interface

interface
 subroutine cutoff_m_elem(ep,kmesh,gvec,symrec,Wf,energy,gwenergy,z0,wdth,occ,direction,gprimd)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: direction
  type(wavefunctions_information),optional,intent(in) :: Wf
  type(epsilonm1_parameters),intent(in) :: ep
  type(bz_mesh_type),target,intent(in) :: kmesh
  real(dp),intent(in) :: wdth
  real(dp),intent(in) :: z0
  real(dp),intent(in) :: energy(ep%nbnds,ep%nkibz,ep%nsppol)
  real(dp),intent(in) :: gprimd(3,3)
  integer,intent(in) :: gvec(3,ep%npwvec)
  real(dp),intent(in) :: gwenergy(ep%nbnds,ep%nkibz,ep%nsppol)
  real(dp),intent(in) :: occ(ep%nbnds,ep%nkibz,ep%nsppol)
  integer,intent(in) :: symrec(3,3,kmesh%nsym)
 end subroutine cutoff_m_elem
end interface

interface
 subroutine matrixelements(npwwfn,wfg1,wfg2,gvec,kpoint,res)
  use defs_basis
  implicit none
  integer,intent(in) :: npwwfn
  integer,intent(in) :: gvec(3,npwwfn)
  real(dp),intent(in) :: kpoint(3)
  complex(gwpc),intent(out) :: res(3)
  complex(gwpc),intent(in) :: wfg1(npwwfn)
  complex(gwpc),intent(in) :: wfg2(npwwfn)
 end subroutine matrixelements
end interface

interface
 subroutine matrixelements_cutoff(npwwfn,wfg1,wfg2,gvec,kpoint,z0,wdth,direction,res)
  use defs_basis
  implicit none
  integer,intent(in) :: direction
  integer,intent(in) :: npwwfn
  real(dp), intent(in) :: wdth
  real(dp), intent(in) :: z0
  integer,intent(in) :: gvec(3,npwwfn)
  real(dp),intent(in) :: kpoint(3)
  complex(gwpc),intent(out) :: res(3)
  complex(gwpc),intent(in) :: wfg1(npwwfn)
  complex(gwpc),intent(in) :: wfg2(npwwfn)
 end subroutine matrixelements_cutoff
end interface

interface
 subroutine check_zarot(npwvec,Cryst,gvec,psps,pawang,grottb,grottbm1)
  use defs_datatypes
  implicit none
  integer,intent(in) :: npwvec
  type(crystal_structure),intent(in) :: Cryst
  type(pawang_type),intent(in) :: pawang
  type(pseudopotential_type),intent(in) :: psps
  integer,intent(in) :: grottb(npwvec,Cryst%timrev,Cryst%nsym)
  integer,intent(in) :: grottbm1(npwvec,Cryst%timrev,Cryst%nsym)
  integer,intent(in) :: gvec(3,npwvec)
 end subroutine check_zarot
end interface

interface
 subroutine dosym(op,iinv,k1,k2)
  use defs_basis
  implicit none
  integer,intent(in) :: iinv
  real(dp),intent(in) :: k1(3)
  real(dp),intent(out) :: k2(3)
  real(dp),intent(in) :: op(3,3)
 end subroutine dosym
end interface

interface
 subroutine dosymr(op,iinv,r1,ngfft,r2)
  use defs_basis
  implicit none
  integer,intent(in) :: iinv
  integer,intent(in) :: ngfft(3)
  real(dp),intent(in) :: op(3,3)
  real(dp),intent(in) :: r1(3)
  real(dp),intent(out) :: r2(3)
 end subroutine dosymr
end interface

interface
 function dotproductqrc(r,c,b1,b2,b3)
  use defs_basis
  implicit none
  complex(gwpc) :: dotproductqrc
  real(dp),intent(in) :: b1(3)
  real(dp),intent(in) :: b2(3)
  real(dp),intent(in) :: b3(3)
  complex(gwpc),intent(in) :: c(3)
  real(dp),intent(in) :: r(3)
 end function dotproductqrc
end interface

interface
 subroutine eps1_tc(dtset,mpi_enreg,ngfft,nr,rho,rprimd,&  
  &  npweps,gmet,gprimd,gvec,nomega,epsm1,nq,ucvol,qq,omega,dtfil,hdr,npwwfn,npwvec,nbnds)
  use defs_basis
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: nbnds
  integer,intent(in) :: nomega
  integer,intent(in) :: npweps
  integer,intent(in) :: npwvec
  integer,intent(in) :: npwwfn
  integer,intent(in) :: nq
  integer,intent(in) :: nr
  type(datafiles_type),intent(in) :: dtfil
  type(dataset_type),intent(in) :: dtset
  type(hdr_type),intent(inout) :: hdr
  type(mpi_type),intent(inout) :: mpi_enreg
  real(dp),intent(in) :: ucvol
  integer,intent(in) :: ngfft(18)
  complex(gwpc),intent(inout) :: epsm1(npweps,npweps,nomega,nq)
  real(dp),intent(in) :: gmet(3,3)
  real(dp),intent(in) :: gprimd(3,3)
  integer,intent(in) :: gvec(3,npweps)
  complex(dpc),intent(in) :: omega(nomega)
  real(dp),intent(in) :: qq(3,nq)
  real(dp),intent(in) :: rho(nr,dtset%nsppol)
  real(dp),intent(in) :: rprimd(3,3)
 end subroutine eps1_tc
end interface

interface
 subroutine fourdp_6d(cplex,matrix,isign,MPI_enreg,nfft,ngfft,paral_kgb,tim_fourdp)
  use defs_basis
  use defs_abitypes
  implicit none
  integer,intent(in) :: cplex
  integer,intent(in) :: isign
  integer,intent(in) :: nfft
  integer,intent(in) :: paral_kgb
  integer,intent(in) :: tim_fourdp
  type(mpi_type),intent(inout) :: MPI_enreg
  integer,intent(in) :: ngfft(18)
  complex(spc),intent(inout) :: matrix(nfft,nfft)
 end subroutine fourdp_6d
end interface

interface
 subroutine fsumrule(nomega,omega,eps,omegaplasma,method)
  use defs_basis
  implicit none
  integer,intent(in) :: method
  integer,intent(in) :: nomega
  real(dp),intent(in) :: omegaplasma
  real(dp),intent(in) :: eps(nomega)
  real(dp),intent(in) :: omega(nomega)
 end subroutine fsumrule
end interface

interface
 subroutine get_Bands_Sym_GW(nspinor,nbnds,mkmem,nsppol,usepaw,only_trace,&  
  &  Cryst,Kmesh,BSt,ngfft,Wfs,Pawtab,Pawang,Psps,Cprj_ibz,MPI_enreg,BSym,&  
  &  EDIFF_TOL) ! optional
  use defs_basis
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: mkmem
  integer,intent(in) :: nbnds
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  integer,intent(in) :: usepaw
  type(bandstructure_type),intent(in) :: BSt
  type(crystal_structure),intent(in) :: Cryst
  real(dp),intent(in),optional :: EDIFF_TOL
  type(bz_mesh_type),intent(in) :: Kmesh
  type(mpi_type),intent(inout) :: MPI_enreg
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(wavefunctions_information),intent(inout) :: Wfs
  logical,intent(in) :: only_trace
  integer,intent(in) :: ngfft(18)
  type(bands_symmetries),target,intent(out) :: BSym(Kmesh%nibz)
  type(cprj_type),intent(in) :: Cprj_ibz(Cryst%natom,nspinor*nbnds*mkmem*nsppol*usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Cryst%ntypat*usepaw)
 end subroutine get_Bands_Sym_GW
end interface

interface
 subroutine finalize_Bands_Sym(Bsym)
  use defs_datatypes
  implicit none
  type(bands_symmetries),intent(inout) :: BSym
 end subroutine finalize_Bands_Sym
end interface

interface
 subroutine rotate_cprj(isym,nbnds,Cryst,Psps,Pawang,Pawtab,Cprj_in,Cprj_out)
  use defs_datatypes
  implicit none
  integer,intent(in) :: isym
  integer,intent(in) :: nbnds
  type(crystal_structure),intent(in) :: Cryst
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(cprj_type),intent(in) :: Cprj_in(Cryst%natom,nbnds)
  type(cprj_type),intent(out) :: Cprj_out(Cryst%natom,nbnds)
  type(pawtab_type),intent(in) :: Pawtab(Cryst%ntypat)
 end subroutine rotate_cprj
end interface

interface
 subroutine make_transitions(chi0alg,nbnds,nbvw,nsppol,symchi,timrev,TOL_DELTA_OCC,zcut,&  
  &  max_rest,min_rest,my_max_rest,my_min_rest,kmesh,ltg_q,mpi_enreg,mG0,gw_energy,occ,qpoint)
  use defs_basis
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: chi0alg
  integer,intent(in) :: nbnds
  integer,intent(in) :: nbvw
  integer,intent(in) :: nsppol
  integer,intent(in) :: symchi
  integer,intent(in) :: timrev
  real(dp),intent(in) :: TOL_DELTA_OCC
  type(bz_mesh_type),intent(in) :: kmesh
  type(little_group),intent(in) :: ltg_q
  real(dp),intent(out) :: max_rest
  real(dp),intent(out) :: min_rest
  type(mpi_type    ),intent(in) :: mpi_enreg
  real(dp),intent(out) :: my_max_rest
  real(dp),intent(out) :: my_min_rest
  real(dp),intent(in) :: zcut
  integer,intent(in) :: mG0(3)
  real(dp),intent(in) :: gw_energy(nbnds,kmesh%nibz,nsppol)
  real(dp),intent(in) :: occ(nbnds,kmesh%nibz,nsppol)
  real(dp),intent(in) :: qpoint(3)
 end subroutine make_transitions
end interface

interface
 subroutine nullify_transitions(self)
  use defs_datatypes
  implicit none
  type(transitions_type),intent(out) :: self
 end subroutine nullify_transitions
end interface

interface
 subroutine init_transitions(self,nkbz,nbnds,nbvw,nsppol,nomega,qpoint,ntrans)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: nbnds
  integer,intent(in) :: nbvw
  integer,intent(in) :: nkbz
  integer,intent(in) :: nomega
  integer,intent(in) :: nsppol
  integer,optional,intent(in) :: ntrans
  type(transitions_type),intent(out) :: self
  real(dp),intent(in) :: qpoint(3)
 end subroutine init_transitions
end interface

interface
 subroutine destroy_transitions(self)
  use defs_datatypes
  implicit none
  type(transitions_type),intent(inout) :: self
 end subroutine destroy_transitions
end interface

interface
 subroutine copy_transitions(t_in,t_out)
  use defs_datatypes
  implicit none
  type(transitions_type),intent(in) :: t_in
  type(transitions_type),intent(out) :: t_out
 end subroutine copy_transitions
end interface

interface
 subroutine print_transitions(self,unit,prtvol)
  use defs_datatypes
  implicit none
  integer,optional,intent(in) :: prtvol
  integer,optional,intent(in) :: unit
  type(transitions_type),intent(in) :: self
 end subroutine print_transitions
end interface

interface
 subroutine get_my_extrema(self,my_min_res,my_max_res)
  use defs_basis
  use defs_datatypes
  implicit none
  real(dp),intent(out) :: my_max_res
  real(dp),intent(out) :: my_min_res
  type(transitions_type),intent(in) :: self
 end subroutine get_my_extrema
end interface

interface
 subroutine split_transitions(self,mpi_enreg)
  use defs_abitypes
  use defs_datatypes
  implicit none
  type(mpi_type),intent(in) :: mpi_enreg
  type(transitions_type),intent(inout) :: self
 end subroutine split_transitions
end interface

interface
 subroutine find_my_indeces(self,nomega,omega_mesh,my_w1,my_w2)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(out) :: my_w1
  integer,intent(out) :: my_w2
  integer,intent(in) :: nomega
  type(transitions_type),intent(in) :: self
  real(dp) :: omega_mesh(nomega)
 end subroutine find_my_indeces
end interface

interface
 subroutine get_rhor(fname,accesswff,localrdwf,nspden,nfft_asked,ngfft_asked,paral_kgb,MPI_enreg,rhor_out)
  use defs_basis
  use defs_abitypes
  implicit none
  integer,intent(in) :: accesswff
  integer,intent(in) :: localrdwf
  integer,intent(in) :: nfft_asked
  integer,intent(in) :: nspden
  integer,intent(in) :: paral_kgb
  type(mpi_type),intent(inout) :: MPI_enreg
  character(len=fnlen),intent(in) :: fname
  integer,intent(in) :: ngfft_asked(18)
  real(dp),intent(out) :: rhor_out(nfft_asked,nspden)
 end subroutine get_rhor
end interface

interface
 subroutine four_intepol(cplex,nspden,optin,optout,nfft_in,ngfft_in,nfft_out,ngfft_out,&  
  &  paral_kgb,MPI_enreg,rhor_in,rhor_out,rhog_in,rhog_out)
  use defs_basis
  use defs_abitypes
  implicit none
  integer,intent(in) :: cplex
  integer,intent(in) :: nfft_in
  integer,intent(in) :: nfft_out
  integer,intent(in) :: nspden
  integer,intent(in) :: optin
  integer,intent(in) :: optout
  integer,intent(in) :: paral_kgb
  type(mpi_type),intent(inout) :: MPI_enreg
  integer,intent(in) :: ngfft_in(18)
  integer,intent(in) :: ngfft_out(18)
  real(dp),intent(inout) :: rhog_in(2,nfft_in)
  real(dp),intent(out) :: rhog_out(2,nfft_out)
  real(dp),intent(inout) :: rhor_in(cplex*nfft_in,nspden)
  real(dp),intent(out) :: rhor_out(cplex*nfft_out,nspden)
 end subroutine four_intepol
end interface

interface
 subroutine completechi0_deltapart(ik_bz,qzero,symchi,npwe,npwvec,nomega,nspinor,&  
  &  nfftot,ngfft,gvec,igfft0,Gsph_wfn,Ltg_q,green_enhigh_w,wfwfg,chi0)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: ik_bz
  integer,intent(in) :: nfftot
  integer,intent(in) :: nomega
  integer,intent(in) :: npwe
  integer,intent(in) :: npwvec
  integer,intent(in) :: nspinor
  integer,intent(in) :: symchi
  type(gvectors_type),intent(in) :: Gsph_wfn
  type(little_group),intent(in) :: Ltg_q
  logical,intent(in) :: qzero
  integer,intent(in) :: ngfft(18)
  complex(gwpc),intent(inout) :: chi0(npwe,npwe,nomega)
  complex(dpc),intent(in) :: green_enhigh_w(nomega)
  integer,intent(in) :: gvec(3,npwvec)
  integer,intent(in) :: igfft0(npwvec)
  complex(gwpc),intent(in) :: wfwfg(nfftot*nspinor**2)
 end subroutine completechi0_deltapart
end interface

interface
 subroutine output_chi0sumrule(qeq0,iq,npwe,omegaplasma,chi0sumrule,epsm1_w0,vc_sqrt)
  use defs_basis
  implicit none
  integer,intent(in) :: iq
  integer,intent(in) :: npwe
  real(dp),intent(in) :: omegaplasma
  logical,intent(in) :: qeq0
  real(dp),intent(inout) :: chi0sumrule(npwe)
  complex(gwpc),intent(in) :: epsm1_w0(npwe,npwe)
  complex(gwpc),intent(in) :: vc_sqrt(npwe)
 end subroutine output_chi0sumrule
end interface

interface
 subroutine accumulate_chi0sumrule(ik_bz,symchi,npwe,factor,delta_ene,&  
  &  Ltg_q,Gsph_epsG0,npwepG0,rhotwg,chi0sumrule)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: ik_bz
  integer,intent(in) :: npwe
  integer,intent(in) :: npwepG0
  integer,intent(in) :: symchi
  type(gvectors_type),intent(in) :: Gsph_epsG0
  type(little_group),intent(in) :: Ltg_q
  real(dp),intent(in) :: delta_ene
  real(dp),intent(in) :: factor
  real(dp),intent(inout) :: chi0sumrule(npwe)
  complex(gwpc),intent(in) :: rhotwg(npwepG0)
 end subroutine accumulate_chi0sumrule
end interface

interface
 subroutine hdr_init(bstruct,codvsn,dtset,hdr,pawtab,pertcase,psps)
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: pertcase
  type(bandstructure_type),intent(in) :: bstruct
  character(len=6),intent(in) :: codvsn
  type(dataset_type),intent(in) :: dtset
  type(hdr_type),intent(out) :: hdr
  type(pseudopotential_type),intent(in) :: psps
  type(pawtab_type),intent(in) :: pawtab(dtset%ntypat*psps%usepaw)
 end subroutine hdr_init
end interface

interface
 subroutine hdr_vs_dtset(Hdr,Dtset)
  use defs_abitypes
  use defs_datatypes
  implicit none
  type(dataset_type),intent(inout) :: Dtset
  type(hdr_type) :: Hdr
 end subroutine hdr_vs_dtset
end interface

interface
 subroutine kramerskronig(nomega,omega,eps,method,only_check)
  use defs_basis
  implicit none
  integer,intent(in) :: method
  integer,intent(in) :: nomega
  integer,intent(in) :: only_check
  complex,intent(inout) :: eps(nomega)
  real(dp),intent(in) :: omega(nomega)
 end subroutine kramerskronig
end interface

interface
 subroutine linear_optics_paw(filnam,mpi_enreg)
  use defs_basis
  use defs_abitypes
  implicit none
  character(len=fnlen),intent(in) :: filnam
  type(mpi_type),intent(inout) :: mpi_enreg
 end subroutine linear_optics_paw
end interface

interface
 subroutine nullify_epsilonm1_parameters(Ep)
  use defs_datatypes
  implicit none
  type(epsilonm1_parameters),intent(inout) :: Ep
 end subroutine nullify_epsilonm1_parameters
end interface

interface
 subroutine destroy_epsilonm1_parameters(Ep)
  use defs_datatypes
  implicit none
  type(epsilonm1_parameters),intent(inout) :: Ep
 end subroutine destroy_epsilonm1_parameters
end interface

interface
 subroutine nullify_sigma_parameters(Sp)
  use defs_datatypes
  implicit none
  type(sigma_parameters),intent(inout) :: Sp
 end subroutine nullify_sigma_parameters
end interface

interface
 subroutine destroy_sigma_parameters(Sp)
  use defs_datatypes
  implicit none
  type(sigma_parameters),intent(inout) :: Sp
 end subroutine destroy_sigma_parameters
end interface

interface
 subroutine make_epsm1_driver(iqibz,dim_wing,npwe,nI,nJ,nomega,omega,&  
  &  approx_type,option_test,Vcp,dim_kxcg,kxcg,MPI_enreg,lwing,uwing,chi0,Spectra)
  use defs_basis
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: approx_type
  integer,intent(in) :: dim_kxcg
  integer,intent(in) :: dim_wing
  integer,intent(in) :: iqibz
  integer,intent(in) :: nI
  integer,intent(in) :: nJ
  integer,intent(in) :: nomega
  integer,intent(in) :: npwe
  integer,intent(in) :: option_test
  type(mpi_type),intent(in) :: MPI_enreg
  type(spectra_type),intent(out) :: Spectra
  type(coulombian_type),intent(in) :: Vcp
  complex(gwpc),intent(inout) :: chi0(npwe*nI,npwe*nJ,nomega)
  complex(gwpc),intent(in) :: kxcg(npwe,npwe*dim_kxcg)
  complex(dpc),intent(inout) :: lwing(npwe*nI,nomega,dim_wing)
  complex(dpc),intent(in) :: omega(nomega)
  complex(dpc),intent(inout) :: uwing(npwe*nJ,nomega,dim_wing)
 end subroutine make_epsm1_driver
end interface

interface
 subroutine mlwfovlp_qp(cg,Cprj_BZ,dtset,dtfil,eigen,mband,mkmem,mpw,natom,&  
  &  nkpt,npwarr,nspden,nspinor,nsppol,ntypat,Hdr,Pawtab,rprimd,MPI_enreg)
  use defs_basis
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: mband
  integer,intent(in) :: mkmem
  integer,intent(in) :: mpw
  integer,intent(in) :: natom
  integer,intent(in) :: nkpt
  integer,intent(in) :: nspden
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  integer,intent(in) :: ntypat
  type(hdr_type),intent(in) :: Hdr
  type(mpi_type),intent(inout) :: MPI_enreg
  type(datafiles_type),intent(in) :: dtfil
  type(dataset_type),intent(in) :: dtset
  type(cprj_type),intent(inout) :: Cprj_BZ(natom,nspinor*mband*mkmem*nsppol)
  type(pawtab_type),intent(in) :: Pawtab(ntypat*Dtset%usepaw)
  real(dp),intent(inout) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
  real(dp),intent(inout) :: eigen(mband*nkpt*nsppol)
  integer,intent(in) :: npwarr(nkpt)
  real(dp),intent(in) :: rprimd(3,3)
 end subroutine mlwfovlp_qp
end interface

interface
 subroutine outeps(nge,nomega,omega,eps,Gsphere,Gpairs_q,title,unt,prtvol)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: nge
  integer,intent(in) :: nomega
  integer,intent(in) :: prtvol
  integer,intent(in) :: unt
  type(gpairs_type),intent(in) :: Gpairs_q
  type(gvectors_type),intent(in) :: Gsphere
  character(len=500),intent(in) :: title
  complex(gwpc),intent(in) :: eps(nge,nge,nomega)
  complex(dpc),intent(in) :: omega(nomega)
 end subroutine outeps
end interface

interface
 subroutine paw_mknewh0(nsppol,nspden,nfftf,pawspnorb,pawprtvol,Cryst,Psps,&  
  &  Pawtab,Paw_an,Pawang,Pawrad,Pawfgrtab,vhartr,vxc,vxc_val,vtrial,Paw_ij)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: nfftf
  integer,intent(in) :: nspden
  integer,intent(in) :: nsppol
  integer,intent(in) :: pawprtvol
  integer,intent(in) :: pawspnorb
  type(crystal_structure),intent(in) :: Cryst
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(paw_an_type),intent(in) :: Paw_an(Cryst%natom)
  type(paw_ij_type),intent(inout) :: Paw_ij(Cryst%natom)
  type(pawfgrtab_type),intent(inout) :: Pawfgrtab(Cryst%natom)
  type(pawrad_type),intent(in) :: Pawrad(Cryst%ntypat)
  type(pawtab_type),intent(in) :: Pawtab(Cryst%ntypat)
  real(dp),intent(in) :: vhartr(nfftf)
  real(dp),intent(in) :: vtrial(nfftf,nspden)
  real(dp),intent(in) :: vxc(nfftf,nspden)
  real(dp),intent(in) :: vxc_val(nfftf,nspden)
 end subroutine paw_mknewh0
end interface

interface
 subroutine paw_mkrhox(Cryst,pwff_spl,gmet,gvec,method,dim1_rhox,dim2_rhox,&  
  &  Psps,Pawang,Pawtab,qpt,npw,ylm_q,paw_rhox)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: dim1_rhox
  integer,intent(in) :: dim2_rhox
  integer,intent(in) :: method
  integer,intent(in) :: npw
  type(crystal_structure),intent(in) :: Cryst
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(pawtab_type),intent(in) :: Pawtab(Cryst%ntypat)
  real(dp),intent(in) :: gmet(3,3)
  integer,intent(in) :: gvec(3,npw)
  real(dp),intent(out) :: paw_rhox(2,npw,Psps%lmnmax*(Psps%lmnmax+1)/2,Cryst%natom)
  real(dp),intent(in) :: pwff_spl(Psps%mqgrid_ff,2,0:dim1_rhox,dim2_rhox,Cryst%ntypat)
  real(dp),intent(in) :: qpt(3)
  real(dp),intent(in) :: ylm_q(npw,(2*Psps%mpsang-1)**2)
 end subroutine paw_mkrhox
end interface

interface
 subroutine paw_mkrhox_spl(ntypat,Psps,Pawrad,Pawtab,pwff_spl,method,dim1_rhox,dim2_rhox)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: dim1_rhox
  integer,intent(in) :: dim2_rhox
  integer,intent(in) :: method
  integer,intent(in) :: ntypat
  type(pseudopotential_type), intent(in) :: Psps
  type(pawrad_type),intent(in) :: Pawrad(ntypat)
  type(pawtab_type),intent(in) :: Pawtab(ntypat)
  real(dp),intent(out) :: pwff_spl(Psps%mqgrid_ff,2,0:dim1_rhox,dim2_rhox,ntypat)
 end subroutine paw_mkrhox_spl
end interface

interface
 subroutine paw_rho_tw_g(npw,dim_rtwg,nspinor,natom,lmnmax,dimlmn,Cprj_k1,Cprj_k2,paw_rhox,rhotwg)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: dim_rtwg
  integer,intent(in) :: lmnmax
  integer,intent(in) :: natom
  integer,intent(in) :: npw
  integer,intent(in) :: nspinor
  type(cprj_type),intent(in) :: Cprj_k1(natom,nspinor)
  type(cprj_type),intent(in) :: Cprj_k2(natom,nspinor)
  integer,intent(in) :: dimlmn(natom)
  real(dp),intent(in) :: paw_rhox(2,npw,lmnmax*(lmnmax+1)/2,natom)
  complex(gwpc),intent(inout) :: rhotwg(npw*dim_rtwg)
 end subroutine paw_rho_tw_g
end interface

interface
 subroutine paw_symcprj(Pawtab,Cryst,nspinor,mband,nband,&  
  &  nsppol,Psps,Kmesh,Cprj_ibz,Pawang,dimlmn,Cprj_bz)
  use defs_datatypes
  implicit none
  integer,intent(in) :: mband
  integer,intent(in) :: nspinor
  integer,intent(in) :: nsppol
  type(crystal_structure),intent(in) :: Cryst
  type(bz_mesh_type),intent(in) :: Kmesh
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(cprj_type),intent(out) :: Cprj_bz(Cryst%natom,nspinor*mband*Kmesh%nbz*nsppol)
  type(cprj_type),intent(in) :: Cprj_ibz(Cryst%natom,nspinor*mband*Kmesh%nibz*nsppol)
  type(pawtab_type),intent(in) :: Pawtab(Cryst%ntypat)
  integer,intent(in) :: dimlmn(Cryst%natom)
  integer,intent(in) :: nband(Kmesh%nibz*nsppol)
 end subroutine paw_symcprj
end interface

interface
 subroutine pawr(Pawtab,Pawrad,Pawang,Psps,natom,ntypat,typat,xcart,lmn2_size_max,rcart_onsite)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: lmn2_size_max
  integer,intent(in) :: natom
  integer,intent(in) :: ntypat
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(pawrad_type),intent(in) :: Pawrad(ntypat)
  type(pawtab_type),intent(in) :: Pawtab(ntypat)
  real(dp),intent(inout) :: rcart_onsite(3,lmn2_size_max,natom)
  integer,intent(in) :: typat(natom)
  real(dp),intent(in) :: xcart(3,natom)
 end subroutine pawr
end interface

interface
 subroutine print_psps(psps,unit,prtvol,mode_paral)
  use defs_datatypes
  implicit none
  integer,intent(in),optional :: prtvol
  integer,intent(in),optional :: unit
  character(len=4),intent(in),optional :: mode_paral
  type(pseudopotential_type),intent(in) :: psps
 end subroutine print_psps
end interface

interface
 subroutine plot_psps(psps,root_filename)
  use defs_basis
  use defs_datatypes
  implicit none
  type(pseudopotential_type),intent(in) :: psps
  character(len=fnlen),intent(in),optional :: root_filename
 end subroutine plot_psps
end interface

interface
 subroutine q0fit(nq,q,gvec,nomega,omega,npwvec,chi0,qcut,metal,&  
  &  nop,op,ninv,gprimd)
  use defs_basis
  implicit none
  integer,intent(in) :: ninv
  integer,intent(in) :: nomega
  integer,intent(in) :: nop
  integer,intent(in) :: npwvec
  integer,intent(in) :: nq
  logical,intent(in) :: metal
  real(dp),intent(in) :: qcut
  complex(gwpc),intent(inout) :: chi0(nq,npwvec,npwvec,nomega)
  real(dp),intent(in) :: gprimd(3,3)
  integer,intent(in) :: gvec(3,npwvec)
  complex(dpc),intent(in) :: omega(nomega)
  real(dp),intent(in) :: op(3,3,nop)
  real(dp),intent(in) :: q(3,nq)
 end subroutine q0fit
end interface

interface
 subroutine rho_tw_g(paral_kgb,nspinor,npwvec,nr,ngfft,map2sphere,igfftg0,&  
  &  wfn1,i1,ktabr1,ktabp1,spinrot1,&  
  &  wfn2,i2,ktabr2,ktabp2,spinrot2,&  
  &  dim_rtwg,rhotwg,tim_fourdp,MPI_enreg)
  use defs_basis
  use defs_abitypes
  implicit none
  integer,intent(in) :: dim_rtwg
  integer,intent(in) :: i1
  integer,intent(in) :: i2
  integer,intent(in) :: map2sphere
  integer,intent(in) :: npwvec
  integer,intent(in) :: nr
  integer,intent(in) :: nspinor
  integer,intent(in) :: paral_kgb
  integer,intent(in) :: tim_fourdp
  type(mpi_type),intent(inout) :: MPI_enreg
  complex(gwpc),intent(in) :: ktabp1
  complex(gwpc),intent(in) :: ktabp2
  integer,intent(in) :: ngfft(18)
  integer,intent(in) :: igfftg0(npwvec*map2sphere)
  integer,intent(in) :: ktabr1(nr)
  integer,intent(in) :: ktabr2(nr)
  complex(gwpc),intent(out) :: rhotwg(npwvec*dim_rtwg)
  real(dp),intent(in) :: spinrot1(4)
  real(dp),intent(in) :: spinrot2(4)
  complex(gwpc),intent(in) :: wfn1(nr*nspinor)
  complex(gwpc),intent(in) :: wfn2(nr*nspinor)
 end subroutine rho_tw_g
end interface

interface
 subroutine screening_gwdistrb(gwpara,gwcomp,spaceComm,nkbz,nbnds,nbvw,nbcw,nsppol,&  
  &  use_symmetries,Kmesh,Qmesh,Ltg_q,MPI_enreg,my_minb,my_maxb,gw_distrb)
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: gwcomp
  integer,intent(in) :: gwpara
  integer,intent(out) :: my_maxb
  integer,intent(out) :: my_minb
  integer,intent(in) :: nbcw
  integer,intent(in) :: nbnds
  integer,intent(in) :: nbvw
  integer,intent(in) :: nkbz
  integer,intent(in) :: nsppol
  integer,intent(in) :: spaceComm
  type(bz_mesh_type),intent(in) :: Kmesh
  type(little_group),intent(in) :: Ltg_q
  type(mpi_type),intent(in) :: MPI_enreg
  type(bz_mesh_type),intent(in) :: Qmesh
  logical,intent(in) :: use_symmetries
  integer,intent(out) :: gw_distrb(nkbz,nbnds,nsppol)
 end subroutine screening_gwdistrb
end interface

interface
 subroutine sigma_gwdistrb(gwpara,spaceComm,nkbz,nbnds,nsppol,&  
  &  use_symmetries,mG0,Kmesh,Qmesh,Ltg_kgw,MPI_enreg,my_minb,my_maxb,gw_distrb)
  use defs_abitypes
  use defs_datatypes
  implicit none
  integer,intent(in) :: gwpara
  integer,intent(out) :: my_maxb
  integer,intent(out) :: my_minb
  integer,intent(in) :: nbnds
  integer,intent(in) :: nkbz
  integer,intent(in) :: nsppol
  integer,intent(in) :: spaceComm
  type(bz_mesh_type),intent(in) :: Kmesh
  type(little_group),intent(in) :: Ltg_kgw
  type(mpi_type),intent(in) :: MPI_enreg
  type(bz_mesh_type),intent(in) :: Qmesh
  logical,intent(in) :: use_symmetries
  integer,intent(in) :: mG0(3)
  integer,intent(out) :: gw_distrb(nkbz,nbnds,nsppol)
 end subroutine sigma_gwdistrb
end interface

interface
 subroutine identq(qibz,nqibz,nqbzX,symrec,nsym,timrev,wtq,qbz,qtab,qtabi,qtabo,nqbz,verbose)
  use defs_basis
  implicit none
  integer,intent(out) :: nqbz
  integer,intent(in) :: nqbzX
  integer,intent(in) :: nqibz
  integer,intent(in) :: nsym
  integer,intent(in) :: timrev
  integer,intent(in) :: verbose
  real(dp),intent(out) :: qbz(3,nqbzX)
  real(dp),intent(in) :: qibz(3,nqibz)
  integer,intent(out) :: qtab(nqbzX)
  integer,intent(out) :: qtabi(nqbzX)
  integer,intent(out) :: qtabo(nqbzX)
  real(dp),intent(in) :: symrec(3,3,nsym)
  real(dp),intent(out) :: wtq(nqibz)
 end subroutine identq
end interface

interface
 subroutine setup_screening(codvsn,acell,rprim,ngfftf,Dtset,Dtfil,Psps,Pawtab,MPI_enreg,&  
  &  ngfft_gw,Hdr_kss,Hdr_out,Cryst,Kmesh,Qmesh,KS_BSt,Ltg_q,Gsph_epsG0,Gsph_wfn,Vcp,Ep)
  use defs_basis
  use defs_abitypes
  use defs_datatypes
  implicit none
  type(crystal_structure),intent(out) :: Cryst
  type(datafiles_type),intent(in) :: Dtfil
  type(dataset_type),intent(inout) :: Dtset
  type(epsilonm1_parameters),intent(out) :: Ep
  type(gvectors_type),intent(out) :: Gsph_epsG0
  type(gvectors_type),intent(out) :: Gsph_wfn
  type(hdr_type),intent(out) :: Hdr_kss
  type(hdr_type),intent(out) :: Hdr_out
  type(bandstructure_type),intent(out) :: KS_BSt
  type(bz_mesh_type),intent(out) :: Kmesh
  type(mpi_type),intent(inout) :: MPI_enreg
  type(pseudopotential_type),intent(in) :: Psps
  type(bz_mesh_type),intent(out) :: Qmesh
  type(coulombian_type),intent(out) :: Vcp
  character(len=6),intent(in) :: codvsn
  integer,intent(out) :: ngfft_gw(18)
  integer,intent(in) :: ngfftf(18)
  type(little_group),pointer :: Ltg_q(:)
  type(pawtab_type),intent(in) :: Pawtab(Psps%ntypat*Dtset%usepaw)
  real(dp),intent(in) :: acell(3)
  real(dp),intent(in) :: rprim(3,3)
 end subroutine setup_screening
end interface

interface
 subroutine setup_sigma(codvsn,acell,rprim,ngfftf,Dtset,Dtfil,Psps,Pawtab,MPI_enreg,&  
  &  ngfft_gw,Hdr_kss,Hdr_out,Cryst,Kmesh,Qmesh,KS_BSt,Gsph_Max,Vcp,Er,Sp)
  use defs_basis
  use defs_abitypes
  use defs_datatypes
  implicit none
  type(crystal_structure),intent(out) :: Cryst
  type(datafiles_type),intent(in) :: Dtfil
  type(dataset_type),intent(inout) :: Dtset
  type(epsilonm1_results),intent(out) :: Er
  type(gvectors_type),intent(out) :: Gsph_Max
  type(hdr_type),intent(out) :: Hdr_kss
  type(hdr_type),intent(out) :: Hdr_out
  type(bandstructure_type),intent(out) :: KS_BSt
  type(bz_mesh_type),intent(out) :: Kmesh
  type(mpi_type),intent(inout) :: MPI_enreg
  type(pseudopotential_type),intent(in) :: Psps
  type(bz_mesh_type),intent(out) :: Qmesh
  type(sigma_parameters),intent(out) :: Sp
  type(coulombian_type),intent(out) :: Vcp
  character(len=6),intent(in) :: codvsn
  integer,intent(out) :: ngfft_gw(18)
  integer,intent(in) :: ngfftf(18)
  type(pawtab_type),intent(in) :: Pawtab(Psps%ntypat*Dtset%usepaw)
  real(dp),intent(in) :: acell(3)
  real(dp),intent(in) :: rprim(3,3)
 end subroutine setup_sigma
end interface

interface
 subroutine approxdelta(nomegasf,omegasf,egwdiff_re,smear,iomegal,iomegar,wl,wr,spmeth)
  use defs_basis
  implicit none
  integer,intent(out) :: iomegal
  integer,intent(out) :: iomegar
  integer,intent(in) :: nomegasf
  integer,intent(in) :: spmeth
  real(dp),intent(in) :: egwdiff_re
  real(dp),intent(in) :: smear
  real(dp),intent(out) :: wl
  real(dp),intent(out) :: wr
  real(dp),intent(in) :: omegasf(nomegasf)
 end subroutine approxdelta
end interface

interface
 subroutine calc_kkweight(ne,omegae,nsp,omegasp,delta,omegamax,kkw)
  use defs_basis
  implicit none
  integer,intent(in) :: ne
  integer,intent(in) :: nsp
  real(dp),intent(in) :: delta
  real(dp),intent(in) :: omegamax
  complex(dpc),intent(out) :: kkw(ne,nsp)
  complex(dpc),intent(in) :: omegae(ne)
  real(dp),intent(in) :: omegasp(nsp)
 end subroutine calc_kkweight
end interface

interface
 subroutine setup_spectral(nomega,omega,nomegasf,omegasf,max_rest,min_rest,my_max_rest,my_min_rest,&  
  &  method,zcut,omegaplasma,my_wl,my_wr,kkweight)
  use defs_basis
  implicit none
  integer,intent(in) :: method
  integer,intent(out) :: my_wl
  integer,intent(out) :: my_wr
  integer,intent(in) :: nomega
  integer,intent(in) :: nomegasf
  real(dp),intent(in) :: max_rest
  real(dp),intent(in) :: min_rest
  real(dp),intent(in) :: my_max_rest
  real(dp),intent(in) :: my_min_rest
  real(dp),intent(in) :: omegaplasma
  real(dp),intent(in) :: zcut
  complex(dpc),intent(out) :: kkweight(nomega,nomegasf)
  complex(dpc),intent(in) :: omega(nomega)
  real(dp),intent(out) :: omegasf(nomegasf)
 end subroutine setup_spectral
end interface

interface
 subroutine split_sigc(sp,sr,npwc1,npwc2,jb,isppol,io,ioe0j,theta_mu_minus_e0i,&  
  &  rhotwg,omegame0i,otq,botsq,sigccoh,sigcsex)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: io
  integer,intent(in) :: ioe0j
  integer,intent(in) :: isppol
  integer,intent(in) :: jb
  integer,intent(in) :: npwc1
  integer,intent(in) :: npwc2
  type(sigma_parameters),intent(in) :: sp
  type(sigma_results),intent(in) :: sr
  real(dp),intent(in) :: theta_mu_minus_e0i
  complex(gwpc) :: botsq(sp%npwc,npwc1)
  real(dp),intent(in) :: omegame0i(sp%nomegasr+sp%nomegasrd)
  real(dp),intent(in) :: otq(sp%npwc,npwc2)
  complex(gwpc),intent(in) :: rhotwg(sp%npwx)
  complex(gwpc),intent(inout) :: sigccoh(sp%nbnds,sp%nsppol)
  complex(gwpc),intent(inout) :: sigcsex(sp%nbnds,sp%nsppol)
 end subroutine split_sigc
end interface

interface
 subroutine fkin(ff,kincontrib,omegame0,otw1,otw2,zcut)
  use defs_basis
  implicit none
  integer,intent(in) :: ff
  real(dp),intent(out) :: kincontrib
  real(dp),intent(in) :: omegame0
  real(dp),intent(in) :: otw1
  real(dp),intent(in) :: otw2
  real(dp),intent(in) :: zcut
 end subroutine fkin
end interface

interface
 subroutine symf12(npw,nomega,omega,eps,Gsphere,Gpairs_q,nsym,symrec,phgt,mode)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: mode
  integer,intent(in) :: nomega
  integer,intent(in) :: npw
  integer,intent(in) :: nsym
  type(gpairs_type),intent(in) :: Gpairs_q
  type(gvectors_type),intent(in) :: Gsphere
  complex(gwpc),intent(inout) :: eps(npw,npw,nomega)
  complex(dpc),intent(in) :: omega(nomega)
  complex(dpc),intent(in) :: phgt(npw,nsym)
  integer,intent(in) :: symrec(3,3,nsym)
 end subroutine symf12
end interface

interface
 subroutine symmetrize_afm_chi0(Cryst,Gsph,Ltg_q,npwe,nomega,chi0)
  use defs_basis
  use defs_datatypes
  implicit none
  integer,intent(in) :: nomega
  integer,intent(in) :: npwe
  type(crystal_structure),intent(in) :: Cryst
  type(gvectors_type),intent(in) :: Gsph
  type(little_group),intent(in) :: Ltg_q
  complex(gwpc),intent(inout) :: chi0(npwe,npwe,nomega)
 end subroutine symmetrize_afm_chi0
end interface

end module interfaces_68_gw
!!***
