!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_finite_cylinder
!!
!! NAME
!!  m_finite_cylinder
!!
!! COPYRIGHT
!!  Copyright (C) 2007-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

module m_finite_cylinder

 use defs_basis
 use m_errors,        only : die
 use m_numeric_tools, only : quadrature

 implicit none

 integer :: npts_,ntrial_,qopt_
 real(dp) :: ha_,hb_,r0_
 real(dp) :: qpg_perp_,qpg_para_,qpgx_,qpgy_
 real(dp) :: zz_,xx_,rho_
 real(dp) :: hcyl_,rcut_,accuracy_

CONTAINS  !=========================================================================================================================


function F2(xx)
!Arguments ------------------------------------
!scalars

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 real(dp),intent(in) :: xx
 real(dp) :: F2
!Local variables-------------------------------
!scalars
 integer :: ierr
 real(dp) :: intr
!************************************************************************

 zz_=xx
 call quadrature(F1,zero,rcut_,qopt_,intr,ntrial_,accuracy_,npts_,ierr)
 if (ierr/=0) then 
  ABI_DIE("Accuracy not reached")
 end if

 F2=intr*COS(qpg_para_*xx)

end function F2


function F1(rho) 
!Arguments ------------------------------------
!scalars

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_32_util
!End of the abilint section

 real(dp),intent(in) :: rho
 real(dp) :: F1

!Local variables-------------------------------
!scalars
 integer,parameter :: order=0,ll=0
 real(dp) :: arg,bes,besp,bespp
!************************************************************************

 !F1(\rho;z)= \rho*j_o(qpg_perp_*\rho)/sqrt(\rho**2+z**2)
 arg=rho*qpg_perp_
 call jbessel(bes,besp,bespp,ll,order,arg)
 if (zz_==zero) then 
  F1=bes
 else 
  F1=bes*rho/SQRT(rho**2+zz_**2)
 end if

end function F1


function F3(xx)

!Arguments ------------------------------------
!scalars

 real(dp),intent(in) :: xx
 real(dp) :: F3
!************************************************************************

 !$F3(z)=z*\sin(qpg_para_*z)/\sqrt(rcut^2+z^2)$
 F3=xx*SIN(qpg_para_*xx)/SQRT(rcut_**2+xx**2)

end function F3


function F4(rho)
!Arguments ------------------------------------
!scalars

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_32_util
!End of the abilint section

 real(dp),intent(in) :: rho
 real(dp) :: F4

!Local variables-------------------------------
!scalars
 integer,parameter :: order=0,ll=0
 real(dp) :: arg,bes,besp,bespp
!************************************************************************

 ! $F4(rho)=\rho*j_o(qpg_perp_.\rho) \ln((hcyl+\sqrt(rho^2+hcyl^2))/\rho)$
 if (ABS(rho)<tol12) then 
  F4=zero
 else
  arg=rho*qpg_perp_
  call jbessel(bes,besp,bespp,ll,order,arg)
  F4=bes*rho*LOG((hcyl_+SQRT(rho**2+hcyl_**2))/rho)
 end if

end function F4


function F5(rho)
!Arguments ------------------------------------
!scalars

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_32_util
!End of the abilint section

 real(dp),intent(in) :: rho
 real(dp) :: F5

!Local variables-------------------------------
!scalars
 integer,parameter :: order=0,ll=0
 real(dp) :: arg,bes,besp,bespp
!************************************************************************

 ! $F5(\rho)=\rho*j_o(G_perp\rho)log(\rho)$
 if (rho==0) then 
  F5=zero
 else 
  arg=rho*qpg_perp_
  call jbessel(bes,besp,bespp,ll,order,arg)
  F5=bes*rho*LOG(rho)
 end if

end function F5


function K0cos(yy) 
!Arguments ------------------------------------
!scalars

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_28_numeric_noabirule
!End of the abilint section

 real(dp),intent(in) :: yy
 real(dp) :: K0cos

!Local variables-------------------------------
!scalars
 real(dp) :: k0,rho,arg
!************************************************************************

 !$K0cos(y)=K0(\rho*|qpg_z|)*COS(x.qpg_x+y*qpg_y)$
 rho=SQRT(xx_**2+yy**2) ; arg=qpg_para_*rho
 call CALCK0(arg,k0,1)
 K0cos=k0*COS(qpgx_*xx_+qpgy_*yy)

end function K0cos


function K0cos_dy(xx)
!Arguments ------------------------------------
!scalars

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 real(dp),intent(in) :: xx
 real(dp) :: K0cos_dy
!Local variables-------------------------------
!scalars
 integer :: ierr
 real(dp) :: bb,quad
!************************************************************************

 !$ K0cos_dy(x)=\int_{-b/2}^{b/2} K0(|qpg_z|\rho)cos(x.qpg_x+y.qpg_y)dy$
 xx_=xx 
 call quadrature(K0cos,-hb_,+hb_,qopt_,quad,ntrial_,accuracy_,npts_,ierr)
 if (ierr/=0) then 
  ABI_DIE("Accuracy not reached")
 end if

 K0cos_dy=quad

end function K0cos_dy


function K0cos_dy_r0(xx)
!Arguments ------------------------------------
!scalars

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 real(dp),intent(in) :: xx
 real(dp) :: K0cos_dy_r0
!Local variables-------------------------------
!scalars
 integer :: ierr
 real(dp) :: bb,quad,yx
!************************************************************************

 ! $ K0cos_dy_r0(x)= \int_{-b/2}^{-y(x)} K0(|qpg_z|\rho) cos(x.qpg_x+y.qpg_y)dy 
 !                  +\int_{y(x)}^{b/2} K0(|qpg_z|\rho)cos(x.qpg_x+y.qpg_y)dy$
 ! where y(x)=SQRT(r0^2-x^2) and x<=r0
 !
 xx_=xx ; yx=SQRT(r0_**2-xx**2)
 call quadrature(K0cos,-hb_,-yx,qopt_,quad,ntrial_,accuracy_,npts_,ierr)
 if (ierr/=0) then 
  ABI_DIE("Accuracy not reached")
 end if
 K0cos_dy_r0=quad

 call quadrature(K0cos,+yx,+hb_,qopt_,quad,ntrial_,accuracy_,npts_,ierr)
 if (ierr/=0) then 
  ABI_DIE("Accuracy not reached")
 end if

 K0cos_dy_r0=quad+K0cos_dy_r0

end function K0cos_dy_r0


function K0cos_dth_r0(rho)
!Arguments ------------------------------------
!scalars

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_28_numeric_noabirule
!End of the abilint section

 real(dp),intent(in) :: rho
 real(dp) :: K0cos_dth_r0

!Local variables-------------------------------
!scalars
 integer :: ierr
 real(dp) :: bb,quad,arg,k0,tmp
!************************************************************************

 ! $ K0cos_dth_r0(\rho)= 
 ! \int_{0}^{2pi)} K0(|qpg_z|\rho)cos(\rho.cos(\theta).qpg_x+\rho.sin(\theta).qpg_y) d\theta $
 !
 ! where y(x)=SQRT(r0^2-x^2) and x<=r0
 !
 rho_=rho 
 call quadrature(Fcos_th,zero,two_pi,qopt_,quad,ntrial_,accuracy_,npts_,ierr)
 if (ierr/=0) then 
  ABI_DIE("Accuracy not reached")
 end if

 arg=qpg_para_*rho_ 
 tmp=zero 
 if (arg>tol6) then
  call CALCK0(arg,k0,1)
  tmp=k0*rho_
 end if
 K0cos_dth_r0=quad*tmp

end function K0cos_dth_r0


function Fcos_th(theta) 
!Arguments ------------------------------------
!scalars

 real(dp),intent(in) :: theta
 real(dp) :: Fcos_th

!Local variables-------------------------------
!scalars
 real(dp) :: k0,arg,tmp
!************************************************************************

 ! $ Fcos_th(\theta)=rho*K0(\rho*|qpg_z|)*COS(\rho.COS(\theta).qpg_x+\rho.SIN/(\theta)*qpg_y) $

 !arg=qpg_para_*rho_ 
 !call CALCK0(arg,k0,1)
 !tmp=k0*rho_
 Fcos_th=COS(rho_*COS(theta)*qpgx_+rho_*SIN(theta)*qpgy_)

end function Fcos_th

!the following functions should be used to deal with the singularity in the Cylindrical cutoff
!TODO Not yet used and indeed are still private 

function K0fit(mq,nn) result(vals)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 integer,intent(in) :: nn
 real(dp),intent(in) :: mq
 real(dp) :: vals(nn)
!Local variables-------------------------------
!scalars
 integer :: ii
 real(dp) :: mqh
!arrays
 real(dp),parameter :: cc(7)=(/-0.57721566,0.42278420,0.23069756,&
&                               0.03488590,0.00262698,0.00010750,0.00000740/) 
 ! *************************************************************************

  if (nn>8.or.nn<1) STOP 'not implemented'
  ! === Eq 9.8.5 in Abramovitz ===
  vals(1)=-LOG(mq*half)*I0(mq) 
  mqh=mq*half
  do ii=2,nn
   vals(ii)=cc(ii-1)*mqh**(2*(ii-2))
  end do
end function K0fit

function K0fit_int(mq,par,nn) result(integ)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 integer,intent(in) :: nn
 real(dp),intent(in) :: mq
 real(dp) :: integ
 real(dp),intent(in) :: par(nn)
!Local variables-------------------------------
!scalars
 integer :: ii,aa
 real(dp) :: mqh
!arrays
 real(dp),parameter :: cc(7)=(/-0.57721566,0.42278420,0.23069756,&
&                               0.03488590,0.00262698,0.00010750,0.00000740/) 
 ! *************************************************************************

 if (nn>8.or.nn<1) STOP 'not implemented'

 mqh=mq*half
 integ=-par(1)*int_I0ln(mqh)
 ! primitive of polynomial \sum_0^{N/2} cc_{2i} (x/2)^{2*i}
 do ii=2,nn
  aa=(2*(ii-1)+1)
  integ=integ+par(ii)*two*cc(ii-1)*(mqh**aa)/aa
 end do

end function K0fit_int

function I0(xx)


 real(dp),intent(in) :: xx
 real(dp) :: I0
!Local variables-------------------------------
 real(dp) :: tt
  ! *************************************************************************

 ! Eq 9.8.1 of Abramovitz, entering the expansion of K0 -->0
 ! Expansion holds for |x|<3.75, Error<1.6*10D-07 
 tt=xx/3.75
 I0=one+3.5156229*tt**2+3.0899424*tt**4 +1.2067492*tt**6 &
       +0.2659732*tt**8+0.0360768*tt**10+0.0045813*tt**12
end function I0
 
! Primitive of x^m Ln(x) for m/=-1
function int_xmln(xx,mm)  result(res)

!Arguments ------------------------------------

 integer,intent(in) :: mm
 real(dp),intent(in) :: xx
 real(dp) :: res
! *********************************************************************

 if (mm==-1) STOP ' invalid value for mm '
 if (xx<=zero) STOP ' invalid value '

 res= (xx**(mm+1))/(mm+1) * (LOG(xx) - one/(mm+1))

end function int_xmln

! Primitive function of ln(x/2)*I0(x) = sum_0^{N/2} 2^{2s+1} c_{2s} T(x/2,2s) 
! where T(x,s)=\int x^s ln(x)dx 
function int_I0ln(xx) result(res)

!Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 real(dp),intent(in) :: xx
 real(dp) :: res
!Local variables-------------------------------
 real(dp) :: yy
! *********************************************************************
 
 yy=xx*half
 res =  (       one*2    *int_xmln(yy,0)  &
&        +3.5156229*2**3 *int_xmln(yy,2)  &  
&        +3.0899424*2**5 *int_xmln(yy,4)  & 
&        +1.2067492*2**7 *int_xmln(yy,6)  &
&        +0.2659732*2**9 *int_xmln(yy,8)  & 
&        +0.0360768*2**11*int_xmln(yy,10) &
&        +0.0045813*2**13*int_xmln(yy,12) &
&       )

end function int_I0ln

end module m_finite_cylinder
!!***
