!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_gwdefs
!! NAME
!! m_gwdefs
!!
!! FUNCTION
!! This module contains definitions for a number of named constants used in the GW part
!! of abinit
!!
!! COPYRIGHT
!! Copyright (C) 2008-2009 ABINIT group (MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! NOTES
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

module m_gwdefs

 use defs_basis

 implicit none

 private

! Unit number for formatted files produced by GW calculations.
! These files are not supposed to be read by abinit therefore
! their names and unit numbers are not defined in the Dtfil% structure.

 integer,public,parameter :: unt_gw  = 21  ! GW corrections
 integer,public,parameter :: unt_sig = 22  ! Self-energy as a function of frequency
 integer,public,parameter :: unt_sgr = 23  ! Derivative wrt omega of the Self-energy
 integer,public,parameter :: unt_sgm = 20  ! Sigma on the Matsubara axis

!nb of bytes related to GW arrays, that can be tuned from sp to dp independently
!of other variables in ABINIT. Presently single precision is the default.
!#if defined HAVE_GW_DPC
! integer, parameter :: gwp=kind(1.0_dp)
! integer, parameter :: gwpc=kind((1.0_dp,1.0_dp))
!#else
! integer, parameter :: gwp=kind(1.0)
! integer, parameter :: gwpc=kind((1.0,1.0))
!#endif

 real(dp),public,parameter :: GW_TOLQ =0.0001_dp  
 ! Tolerance below which two BZ points are considered equal within a RL vector:
 ! for each red. direct. the abs value of the difference btw the two coord must be smaller that tolq.

 real(dp),public,parameter :: GW_TOLQ0=0.001_dp   
 ! Tolerance below which a q-point is treated as zero (long wavelength limit)

 real(dp),public,parameter :: GW_TOL_DOCC=0.01_dp 
 ! Tolerance on the difference between two occupation numbers.
 ! below this value, the contribution of the transition is neglected in the evaluation of chi0

 real(dp),public,parameter :: GW_TOL_W0=0.001_dp 
 ! Tolerance on the real part of the frequency appearing in the denominator of the 
 ! non-interacting Green function G0. Above this value, a small purely imaginary 
 ! complex shift is added to the denominator during the evaluation of chi0.

 complex(gwpc),public,parameter :: czero_gw=(0._gwp,0._gwp)
 complex(gwpc),public,parameter :: cone_gw =(1._gwp,0._gwp)
 complex(gwpc),public,parameter :: j_gw    =(0._gwp,1._gwp)

!arrays
 real(dp),public,parameter :: GW_Q0_DEFAULT(3) = (/0.00001_dp, 0.00002_dp, 0.00003_dp/)

CONTAINS  !=========================================================================================================================
!!***

!!****f* m_gwdefs/print_kinds
!! NAME
!! print_kinds
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
 subroutine print_kinds(unit)

 !Arguments ------------------------------------

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

 integer,intent(in) :: unit

 !Local variables-------------------------------
 character(len=500) :: msg
 ! *********************************************************************

 write(msg,'(2a)')ch10,' DATA TYPE INFORMATION: '
 call wrtout(unit,msg,'COLL') 

 write(msg,'(4a,2(a,i6,a),2(a,e14.8,a),e14.8,a)')ch10,&
& ' REAL:      Data type name:',' DP ',ch10,&
& '            Kind value: ',KIND(0.0_dp),ch10,&
& '            Precision: ',PRECISION(0.0_dp),ch10,&
& '            Smallest nonnegligible quantity relative to 1:',EPSILON(0.0_dp),ch10,&
& '            Smallest positive number:',TINY(0.0_dp),ch10,&
& '            Largest representable number:',HUGE(0.0_dp)
 call wrtout(unit,msg,'COLL') 

 write(msg,'(3a,2(a,i20,a),a,i20)')&
  ' INTEGER:   Data type name:',' (default) ',ch10,&
& '            Kind value:',KIND(0),ch10,&
& '            Bit size:',BIT_SIZE(0),ch10,&
  '            Largest representable number:',HUGE(0)
 call wrtout(unit,msg,'COLL') 

 write(msg,'(3a,a,i6)')&
& ' LOGICAL:   Data type name:',' (default) ',ch10,&
& '            Kind value:',KIND(.TRUE.)
 call wrtout(unit,msg,'COLL') 

 write(msg,'(2a,a,i6)')&
& ' CHARACTER: Data type name:',' (default) ',ch10,&
& '            Kind value:',KIND('C')
 call wrtout(unit,msg,'COLL') 

 end subroutine print_kinds

end module m_gwdefs
!!***

!!****f* ABINIT/nullify_epsilonm1_parameters
!! NAME
!! nullify_epsilonm1_parameters
!!
!! FUNCTION
!!  This file contains methods acting on the data types used in the 
!!  GW part of abinit. This methods can be used to nullify the pointers 
!!  defined in the data types before starting the calculation and to 
!!  deallocate the memory occupied before exiting.
!!
!! INPUTS
!!
!! OUTPUT
!!
!! NOTES
!!  All the pointer defined in the data types could be nullified 
!!  using the null() functions. Unfortunately null() has been 
!!  introduced in the F95 specifications and this might lead 
!!  to portability problems.
!!
!! TODO 
!!  write other methods to write the content of the data type.
!!
!! PARENTS
!!  Will be filled automatically by the parent script
!!
!! CHILDREN
!!  Will be filled automatically by the parent script
!!
!! SOURCE

subroutine nullify_epsilonm1_parameters(Ep)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

 implicit none

!Arguments ------------------------------------
!scalars
 type(epsilonm1_parameters),intent(inout) :: Ep

! *************************************************************************

!real
 nullify(Ep%qcalc  )
 nullify(Ep%qibz   )
 nullify(Ep%qlwl   )
 nullify(Ep%omegasf)

!complex
 nullify(Ep%omega) 

end subroutine nullify_epsilonm1_parameters
!!***

!!****f* ABINIT/destroy_epsilonm1_parameters
!! NAME
!! destroy_epsilonm1_parameters
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      screening
!!
!! CHILDREN
!!      nullify_sigma_results
!!
!! SOURCE

subroutine destroy_epsilonm1_parameters(Ep)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

 implicit none

!Arguments ------------------------------------
!scalars
 type(Epsilonm1_parameters),intent(inout) :: Ep

! *************************************************************************

!real
 if (associated(Ep%qcalc  ))  deallocate(Ep%qcalc)
 if (associated(Ep%qibz   ))  deallocate(Ep%qibz)
 if (associated(Ep%qlwl   ))  deallocate(Ep%qlwl)
 if (associated(Ep%omegasf))  deallocate(Ep%omegasf)

!complex
 if (associated(Ep%omega  ))  deallocate(Ep%omega) 

end subroutine destroy_epsilonm1_parameters
!!***

!!****f* ABINIT/nullify_sigma_parameters
!! NAME
!! nullify_sigma_parameters
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      setup_sigma
!!
!! CHILDREN
!!      nullify_sigma_results
!!
!! SOURCE

subroutine nullify_sigma_parameters(Sp)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

 implicit none

!Arguments ------------------------------------
!scalars
 type(Sigma_parameters),intent(inout) :: Sp

! *************************************************************************

!integer
 nullify(Sp%kcalc )
 nullify(Sp%minbnd)
 nullify(Sp%maxbnd)

!real
 nullify(Sp%xkcalc) 

!complex
 nullify(Sp%omegasi)
 nullify(Sp%omega_r)

end subroutine nullify_sigma_parameters
!!***

!!****f* ABINIT/destroy_sigma_parameters
!! NAME
!! destroy_sigma_parameters
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      nullify_sigma_results
!!
!! SOURCE

subroutine destroy_sigma_parameters(Sp)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

 implicit none

!Arguments ------------------------------------
!scalars
 type(Sigma_parameters),intent(inout) :: Sp

! *************************************************************************

!integer
 if (associated(Sp%kcalc ))  deallocate(Sp%kcalc )
 if (associated(Sp%minbnd))  deallocate(Sp%minbnd)
 if (associated(Sp%maxbnd))  deallocate(Sp%maxbnd)

!real
 if (associated(Sp%xkcalc))  deallocate(Sp%xkcalc) 

!complex
 if (associated(Sp%omegasi)) deallocate(Sp%omegasi) 
 if (associated(Sp%omega_r)) deallocate(Sp%omega_r) 

end subroutine destroy_sigma_parameters
!!***
