!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_sigma_results
!! NAME
!!  m_sigma_results
!!
!! FUNCTION
!!  
!!
!! COPYRIGHT
!! Copyright (C) 2008-2009 ABINIT group (MG, FB, GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

MODULE m_sigma_results

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_errors 

 implicit none

 private 

 public ::                      &
&  write_sigma_results_header,  &
&  write_sigma_results,         &
&  print_Sigma_perturbative,    &
&  print_Sigma_QPSC,            &
&  nullify_sigma_results,       &
&  init_sigma_results,          &
&  destroy_sigma_results,       &
&  allocate_sigma_results,      &
&  etsf_dump_QP,                &
&  abi_etsf_get_QP

CONTAINS  !=========================================================================================================================
!!***

!!****f* m_sigma_results/write_sigma_results_header
!! NAME
!! write_sigma_results_header
!!
!! FUNCTION
!!
!! INPUTS
!!  Sp=sigma_parameters
!!  Cryst<Crystal_structure>= Info on the Crystal structure
!!  Kmesh<Bz_mesh_type>= Description of the BZ sampling.
!!
!! OUTPUT
!!  (for writing routines, no output) otherwise, should be described
!!
!! NOTES
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE

subroutine write_sigma_results_header(Sp,Er,Cryst,Kmesh,Qmesh)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Bz_mesh_type),intent(in) :: Kmesh,Qmesh
 type(Crystal_structure),intent(in) :: Cryst
 type(Epsilonm1_results),intent(in) :: Er
 type(Sigma_parameters),intent(in) :: Sp

!Local variables-------------------------------
!scalars
 integer :: mod10
 character(len=500) :: msg

! *************************************************************************

 DBG_ENTER("COLL")

 write(msg,'(a)')' SIGMA fundamental parameters:'
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

 mod10=MOD(Sp%gwcalctyp,10)
 SELECT CASE (mod10)
 CASE (0)
  write(msg,'(a,i2)')' PLASMON POLE MODEL ',Sp%ppmodel
 CASE (1)
  write(msg,'(a)')' ANALYTIC CONTINUATION'
 CASE (2)
  write(msg,'(a)')' CONTOUR DEFORMATION'
 CASE (5)
  write(msg,'(a)')' Hartree-Fock'
 CASE (6)
  write(msg,'(a)')' Screened Exchange'
 CASE (7)
  write(msg,'(a)')' COHSEX'
 CASE (8)
  write(msg,'(a,i2)')' MODEL GW with PLASMON POLE MODEL ',Sp%ppmodel
 CASE (9)
  write(msg,'(a)')' MODEL GW without PLASMON POLE MODEL'
 CASE DEFAULT
  write(msg,'(a,i3)')' Wrong value for Sp%gwcalctyp = ',Sp%gwcalctyp 
  MSG_BUG(msg)
 END SELECT
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

 write(msg,'(a,i12)')' number of plane-waves for SigmaX         ',Sp%npwx
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of plane-waves for SigmaC and W   ',Sp%npwc
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of plane-waves for wavefunctions  ',Sp%npwwfn
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of bands                          ',Sp%nbnds
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of independent spin polarizations ',Sp%nsppol
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of spinorial components           ',Sp%nspinor
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of k-points in IBZ                ',Kmesh%nibz
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of q-points in IBZ                ',Qmesh%nibz
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of symmetry operations            ',Cryst%nsym
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of k-points in BZ                 ',Kmesh%nbz
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of q-points in BZ                 ',Qmesh%nbz
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of frequencies for dSigma/dE      ',Sp%nomegasrd
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,f12.2)')' frequency step for dSigma/dE [eV]        ',Sp%deltae*Ha_eV
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of omega for Sigma on real axis   ',Sp%nomegasr
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,f12.2)')' max omega for Sigma on real axis  [eV]   ',Sp%maxomega_r*Ha_eV
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,f12.2)')' zcut for avoiding poles [eV]             ',Sp%zcut*Ha_eV
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

 if (Sp%soenergy>0.1d-4) then 
  write(msg,'(a,f12.2)')' scissor energy [eV]                      ',Sp%soenergy*Ha_eV
  call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 end if

 if (MOD(Sp%gwcalctyp,10)==1) then
  write(msg,'(a,i12)')' number of imaginary frequencies for Sigma',Sp%nomegasi
  call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
  write(msg,'(a,f12.2)')' max omega for Sigma on imag axis  [eV]   ',Sp%omegasimax*Ha_eV
  call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 end if 

 write(msg,'(2a)')ch10,' EPSILON^-1 parameters (SCR file):'
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 !write(std_out,*) titem1(2)(1:79)
 write(msg,'(a,i12)')' dimension of the eps^-1 matrix on file   ',Er%Hscr%npwe
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' dimension of the eps^-1 matrix used      ',Er%npwe
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of plane-waves for wavefunctions  ',Er%Hscr%npwwfn_used
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of bands                          ',Er%Hscr%nbnds_used
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of q-points in IBZ                ',Qmesh%nibz
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of frequencies                    ',Er%nomega
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of real frequencies               ',Er%nomega_r
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
 write(msg,'(a,i12)')' number of imag frequencies               ',Er%nomega_i
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

 write(msg,'(3a)')ch10,' matrix elements of self-energy operator (all in [eV])',ch10
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

 if (Sp%gwcalctyp<10) then
  write(msg,'(a)')' Perturbative Calculation'
 else if (Sp%gwcalctyp<20) then
  write(msg,'(a)')' Self-Consistent on Energies only'
 else
  write(msg,'(a)')' Self-Consistent on Energies and Wavefunctions'
 end if
 call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

 DBG_EXIT("COLL")

end subroutine write_sigma_results_header
!!***

!!****f* m_sigma_results/write_sigma_results
!! NAME
!! write_sigma_results
!!
!! FUNCTION
!!  Write the final results of the GW calculation
!!
!! INPUTS
!!  KS_BSt<Bandstructure_type>=Info on the KS band structure energies.
!!     %eig(mband,nkibz,nsppol)= KS energies
!!  ikibz= index of the k-point in the array kibz, where GW corrections are calculated 
!!  ikcalc= index of the k-point in the array sp%kcalc 
!!  Kmesh<Bz_mesh_type>=Info on the k-point mesh
!!  sp=sigma_parameters datatype
!!  sr=sigma results datatype
!!
!! OUTPUT
!!  (for writing routines, no output) otherwise, should be described
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE
!!

subroutine write_sigma_results(ikcalc,ikibz,Sp,Sr,Kmesh,KS_BSt)

 use defs_basis
 use m_gwdefs, only : unt_gw, unt_sig, unt_sgr, unt_sgm

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ikcalc,ikibz
 type(Bandstructure_type),intent(in) :: KS_BSt
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Sigma_parameters),intent(in) :: Sp
 type(Sigma_results),intent(in) :: Sr
!arrays

!Local variables-------------------------------
!scalars
 integer :: ib,io,is
 character(len=500) :: msg
!arrays
 character(len=12) :: tag_spin(2)
 real(dp),pointer :: ks_energy(:,:,:)

! *************************************************************************

 !unt_gw  = 21  ! File with GW corrections.
 !unt_sig = 22  ! Self-energy as a function of frequency.
 !unt_sgr = 23  ! Derivative wrt omega of the Self-energy.
 !unt_sgm = 20  ! Sigma on the Matsubara axis.

 !TODO pass the object instead of the pointer
 ks_energy => KS_BSt%eig(:,:,:)

 tag_spin=(/'            ','            '/)
 if (Sr%nsppol==2) tag_spin=(/',  SPIN UP  ',',  SPIN DOWN'/)

 do is=1,Sr%nsppol
  write(msg,'(2a,3f8.3,a)')ch10,' k = ',Sp%xkcalc(:,ikcalc),tag_spin(is)
  call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

  write(msg,'(a)')&
&  ' Band     E0 <VxcLDA>   SigX SigC(E0)      Z dSigC/dE  Sig(E)    E-E0       E'

  if (Sr%usepawu/=0) then
   write(msg,'(a)')&
&   ' Band     E0 <VxcLDA>   <H_U>  SigX SigC(E0)      Z dSigC/dE  Sig(E)    E-E0       E'
  end if

  if (Sp%gwcalctyp>=10) then
   write(msg,'(2a)')&
&   ' Band     E_lda   <Vxclda>   E(N-1)  <Hhartree>   SigX  SigC[E(N-1)]',&
&   '    Z     dSigC/dE  Sig[E(N)]  DeltaE  E(N)_pert E(N)_diago'
  end if
  call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')

  write(unt_gw,'(3f10.6)')Sp%xkcalc(:,ikcalc)
  write(unt_gw,'(i4)')Sp%maxbnd(ikcalc)-Sp%minbnd(ikcalc)+1

  write(unt_sig,'("# k = ",3f10.6)')Sp%xkcalc(:,ikcalc)
  write(unt_sig,'("# b = ",2i10)')Sp%minbnd(ikcalc),Sp%maxbnd(ikcalc)

  write(unt_sgr,'("# k = ",3f10.6)')Sp%xkcalc(:,ikcalc)
  write(unt_sgr,'("# b = ",2i10)')Sp%minbnd(ikcalc),Sp%maxbnd(ikcalc)

  do ib=Sp%minbnd(ikcalc),Sp%maxbnd(ikcalc)

   if (Sp%gwcalctyp>=10) then
    call print_Sigma_QPSC(Sr,ikibz,ib,is,Kmesh,ks_energy,unit=ab_out)
    call print_Sigma_QPSC(Sr,ikibz,ib,is,Kmesh,ks_energy,unit=std_out,prtvol=1)
   else
    !
    ! === When using non-ppm, write out also the imaginary part in ab_out
    SELECT CASE(Sp%gwcalctyp)
    CASE(1,2)
     call print_Sigma_perturbative(Sr,ikibz,ib,is,unit=ab_out,prtvol=1)
    CASE DEFAULT
     call print_Sigma_perturbative(Sr,ikibz,ib,is,unit=ab_out)
    END SELECT
    call print_Sigma_perturbative(Sr,ikibz,ib,is,unit=std_out,prtvol=1)
   end if

   write(unt_gw,'(i6,3f9.4)')         &
&   ib,                               &
&   REAL (Sr%egw(ib,ikibz,is)) *Ha_eV,&
&   REAL (Sr%degw(ib,ikibz,is))*Ha_eV,&
&   AIMAG(Sr%egw(ib,ikibz,is)) *Ha_eV
   
  end do !ib

  if (Sr%e0gap(ikibz,is)**2+Sr%egwgap(ikibz,is)**2+Sr%degwgap(ikibz,is)**2 > tol10) then
   ! Output the direct gap for each spin
   ! If all the gaps are zero, this means that it could not be computed in the calling routine
   write(msg,'(2a,f8.3)')ch10,' E^0_gap       ',Sr%e0gap(ikibz,is)*Ha_eV
   call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
   write(msg,'(a,f8.3)')      ' E^GW_gap      ',Sr%egwgap(ikibz,is)*Ha_eV
   call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
   write(msg,'(a,f8.3,a)')    ' DeltaE^GW_gap ',Sr%degwgap(ikibz,is)*Ha_eV,ch10
   call wrtout(std_out,msg,'COLL') ; call wrtout(ab_out,msg,'COLL')
  end if

  ! === Output spectral function ===
  do io=1,Sr%nomega_r
   write(unt_sig,'(100(e11.5,2x))')&
&   REAL(Sr%omega_r(io))*Ha_eV,&
&   (REAL(Sr%sigxcme(ib,ikibz,io,is))*Ha_eV,&
&   AIMAG(Sr%sigxcme(ib,ikibz,io,is))*Ha_eV,&
&   one/pi*ABS(AIMAG(Sr%sigcme(ib,ikibz,io,is)))&
&   /( (REAL(Sr%omega_r(io)-Sr%hhartree(ib,ib,ikibz,is)-Sr%sigxcme(ib,ikibz,io,is)))**2&
&     +(AIMAG(Sr%sigcme(ib,ikibz,io,is)))**2) /Ha_eV,&
&   ib=Sp%minbnd(ikcalc),Sp%maxbnd(ikcalc))
  end do

  do ib=Sp%minbnd(ikcalc),Sp%maxbnd(ikcalc)
   write(unt_sgr,'("# ik, ib",2i5)')ikibz,ib
   do io=1,Sr%nomega4sd
    write(unt_sgr,'(100(e11.5,2x))')             &
&    REAL (Sr%omega4sd  (ib,ikibz,io,is)) *Ha_eV,&
&    REAL (Sr%sigxcme4sd(ib,ikibz,io,is)) *Ha_eV,&
&    AIMAG(Sr%sigxcme4sd(ib,ikibz,io,is)) *Ha_eV
   end do
  end do

  if (MOD(sp%gwcalctyp,10)==1) then 
   ! For AC write matrix elements of sigma along the imaginary axis
   do ib=Sp%minbnd(ikcalc),Sp%maxbnd(ikcalc)
    write(unt_sgm,'("# ik, ib",2i5)')ikibz,ib
    do io=1,Sr%nomega_i
     write(unt_sgm,'(3(e11.5,2x))')             &
&     AIMAG(Sr%omega_i(io))              *Ha_eV,&
&     REAL (Sr%sigxcmesi(ib,ikibz,io,is))*Ha_eV,&
&     AIMAG(Sr%sigxcmesi(ib,ikibz,io,is))*Ha_eV
    end do
   end do
  end if 

 end do !is

end subroutine write_sigma_results
!!***

!!****f* m_sigma_results/print_Sigma_perturbative 
!! NAME
!! print_Sigma_perturbative
!!
!! FUNCTION
!!  write the results of the GW calculation done with the perturbative approach
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      m_gwannier,m_sigma_results
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE

subroutine print_Sigma_perturbative(Sr,ik_ibz,iband,isp,unit,prtvol,mode_paral,witheader)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iband,ik_ibz,isp
 integer,optional,intent(in) :: prtvol,unit
 character(len=4),optional,intent(in) :: mode_paral
 logical,optional,intent(in) :: witheader
 type(Sigma_results),intent(in) :: Sr

!Local variables-------------------------------
!scalars
 integer :: unt,verbose
 logical :: ltest
 character(len=4) :: mode
 character(len=500) :: msg

! *********************************************************************

 unt=std_out ; if (PRESENT(unit))       unt=unit
 verbose=0   ; if (PRESENT(prtvol))     verbose=prtvol
 mode='COLL' ; if (PRESENT(mode_paral)) mode=mode_paral

 if (PRESENT(witheader)) then 
  if (witheader) then
   write(msg,'(a)')' Band     E0 <VxcLDA>   SigX SigC(E0)      Z dSigC/dE  Sig(E)    E-E0       E '
   call wrtout(unt,msg,mode) 
  end if 
 end if

 if (Sr%usepawu==0) then 

  if (Sr%nsig_ab/=1) then
   write(msg,'(i5,9f8.3)')                       & 
&        iband,                                  &
&        Sr%e0          (iband,ik_ibz,1)*Ha_eV,  &
&        SUM(Sr%vxcme   (iband,ik_ibz,:))*Ha_eV, &
&        SUM(Sr%sigxme  (iband,ik_ibz,:))*Ha_eV, &
&   REAL(SUM(Sr%sigcmee0(iband,ik_ibz,:)))*Ha_eV,&
&   REAL(Sr%ze0         (iband,ik_ibz,1)),       &
&   REAL(SUM(Sr%dsigmee0(iband,ik_ibz,:))),      &
&   REAL(SUM(Sr%sigmee  (iband,ik_ibz,:)))*Ha_eV,&
&   REAL(Sr%degw        (iband,ik_ibz,1))*Ha_eV, &
&   REAL(Sr%egw         (iband,ik_ibz,1))*Ha_eV
    call wrtout(unt,msg,mode) 
   if (verbose/=0) then
    write(msg,'(i5,9f8.3)')                        & 
&          iband,                                  &
&          zero,                                   &
&          zero,                                   &
&          zero,                                   &
&    AIMAG(SUM(Sr%sigcmee0(iband,ik_ibz,:)))*Ha_eV,&
&    AIMAG(Sr%ze0         (iband,ik_ibz,1)),       &
&    AIMAG(SUM(Sr%dsigmee0(iband,ik_ibz,:))),      &
&    AIMAG(SUM(Sr%sigmee  (iband,ik_ibz,:)))*Ha_eV,&
&    AIMAG(Sr%degw        (iband,ik_ibz,1))*Ha_eV, &
&    AIMAG(Sr%egw         (iband,ik_ibz,1))*Ha_eV
     call wrtout(unt,msg,mode) 
   end if
  else
   write(msg,'(i5,9f8.3)')                    & 
&        iband,                               &
&        Sr%e0      (iband,ik_ibz,isp)*Ha_eV, &
&        Sr%vxcme   (iband,ik_ibz,isp)*Ha_eV, &
&        Sr%sigxme  (iband,ik_ibz,isp)*Ha_eV, &
&   REAL(Sr%sigcmee0(iband,ik_ibz,isp))*Ha_eV,&
&   REAL(Sr%ze0     (iband,ik_ibz,isp)),      &
&   REAL(Sr%dsigmee0(iband,ik_ibz,isp)),      &
&   REAL(Sr%sigmee  (iband,ik_ibz,isp))*Ha_eV,&
&   REAL(Sr%degw    (iband,ik_ibz,isp))*Ha_eV,&
&   REAL(Sr%egw     (iband,ik_ibz,isp))*Ha_eV
    call wrtout(unt,msg,mode) 

   if (verbose/=0) then
    write(msg,'(i5,9f8.3)')                     & 
&          iband,                               &
&          zero,                                &
&          zero,                                &
&          zero,                                &
&    AIMAG(Sr%sigcmee0(iband,ik_ibz,isp))*Ha_eV,&
&    AIMAG(Sr%ze0     (iband,ik_ibz,isp)),      &
&    AIMAG(Sr%dsigmee0(iband,ik_ibz,isp)),      &
&    AIMAG(Sr%sigmee  (iband,ik_ibz,isp))*Ha_eV,&
&    AIMAG(Sr%degw    (iband,ik_ibz,isp))*Ha_eV,&
&    AIMAG(Sr%egw     (iband,ik_ibz,isp))*Ha_eV
     call wrtout(unt,msg,mode) 
   end if
  end if

 else 
  ! === PAW+U+GW calculation ===
  ltest=(Sr%nsig_ab==1)
  call assert(ltest,'LDA+U with spinor not implemented',&
&  __FILE__,__LINE__)
  write(msg,'(i5,10f8.3)')                   & 
&       iband,                               &
&       Sr%e0      (iband,ik_ibz,isp)*Ha_eV, &
&       Sr%vxcme   (iband,ik_ibz,isp)*Ha_eV, &
&       Sr%vUme    (iband,ik_ibz,isp)*Ha_eV, &
&       Sr%sigxme  (iband,ik_ibz,isp)*Ha_eV, &
&  REAL(Sr%sigcmee0(iband,ik_ibz,isp))*Ha_eV,&
&  REAL(Sr%ze0     (iband,ik_ibz,isp)),      &
&  REAL(Sr%dsigmee0(iband,ik_ibz,isp)),      &
&  REAL(Sr%sigmee  (iband,ik_ibz,isp))*Ha_eV,&
&  REAL(Sr%degw    (iband,ik_ibz,isp))*Ha_eV,&
&  REAL(Sr%egw     (iband,ik_ibz,isp))*Ha_eV
   call wrtout(unt,msg,mode) 

  if (verbose/=0) then
   write(msg,'(i5,10f8.3)')                    & 
&         iband,                               &
&         zero,                                &
&         zero,                                &
&         zero,                                &
&         zero,                                &
&   AIMAG(Sr%sigcmee0(iband,ik_ibz,isp))*Ha_eV,&
&   AIMAG(Sr%ze0     (iband,ik_ibz,isp)),      &
&   AIMAG(Sr%dsigmee0(iband,ik_ibz,isp)),      &
&   AIMAG(Sr%sigmee  (iband,ik_ibz,isp))*Ha_eV,&
&   AIMAG(Sr%degw    (iband,ik_ibz,isp))*Ha_eV,&
&   AIMAG(Sr%egw     (iband,ik_ibz,isp))*Ha_eV
    call wrtout(unt,msg,mode) 
  end if
 end if

end subroutine print_Sigma_perturbative 
!!***

!!****f* m_sigma_results/print_Sigma_QPSC
!! NAME
!!  print_Sigma_QPSC
!!
!! FUNCTION
!!  Write the results of the GW calculation in case of self-consistency
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      m_sigma_results
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE

subroutine print_Sigma_QPSC(Sr,ik_ibz,iband,isp,Kmesh,ks_energy,unit,prtvol,mode_paral)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!this should be in the datatype
!scalars
 integer,intent(in) :: iband,ik_ibz,isp
 integer,intent(in),optional :: prtvol,unit
 character(len=4),intent(in),optional :: mode_paral
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Sigma_results),intent(in) :: Sr
!arrays
 real(dp),intent(in) :: ks_energy(Sr%nbnds,Kmesh%nibz,Sr%nsppol)

!Local variables-------------------------------
!scalars
 integer :: unt,verbose
 character(len=4) :: mode
 character(len=500) :: msg

! *********************************************************************

 unt    =std_out ; if (PRESENT(unit))       unt    =unit
 verbose=0       ; if (PRESENT(prtvol))     verbose=prtvol
 mode   ='COLL'  ; if (PRESENT(mode_paral)) mode   =mode_paral

! write(msg,'(a)')&
!&   ' Band     E_lda   <Vxclda>   E(N-1)  <Hhartree>   SigX  SigC[E(N-1)]',&
!&   '    Z     dSigC/dE  Sig[E(N)]  DeltaE  E(N)_pert E(N)_diago'

 if (Sr%usepawu==0) then
  if (Sr%nsig_ab/=1) then
   write(msg,'(i5,12(2x,f8.3))')                       & 
&        iband,                                        &
&        ks_energy        (iband,ik_ibz,1)*Ha_eV,      &
         !sr%e0           (iband,ikibz,1)*Ha_eV,       &
&        SUM(Sr%vxcme   (iband,ik_ibz,:))*Ha_eV,       &
&        Sr%e0          (iband,ik_ibz,1)*Ha_eV,        &
&   REAL(SUM(Sr%hhartree(iband,iband,ik_ibz,:)))*Ha_eV,&
&        SUM(Sr%sigxme  (iband,ik_ibz,:))*Ha_eV,       &
&   REAL(SUM(Sr%sigcmee0(iband,ik_ibz,:)))*Ha_eV,      &
&   REAL(Sr%ze0         (iband,ik_ibz,1)),             &
&   REAL(SUM(Sr%dsigmee0(iband,ik_ibz,:))),            &
&   REAL(SUM(Sr%sigmee  (iband,ik_ibz,:)))*Ha_eV,      &
&   REAL(Sr%degw        (iband,ik_ibz,1))*Ha_eV,       &
&   REAL(Sr%egw         (iband,ik_ibz,1))*Ha_eV,       &
&        Sr%en_qp_diago (iband,ik_ibz,1)*Ha_eV
   call wrtout(unt,msg,mode) 

   write(msg,'(i5,12(2x,f8.3))')                        & 
&         iband,                                        &
&         zero,                                         &
          !sr%e0          (iband,ikibz,isp)*Ha_eV,      &
&         zero,                                         &
&         zero,                                         &
&   AIMAG(SUM(Sr%hhartree(iband,iband,ik_ibz,:)))*Ha_eV,&
&         zero,                                         &
&   AIMAG(SUM(Sr%sigcmee0(iband,ik_ibz,:)))*Ha_eV,      &
&   AIMAG(Sr%ze0         (iband,ik_ibz,1)),             &
&   AIMAG(SUM(Sr%dsigmee0(iband,ik_ibz,:))),            &
&   AIMAG(SUM(Sr%sigmee  (iband,ik_ibz,:)))*Ha_eV,      &
&   AIMAG(Sr%degw        (iband,ik_ibz,1))*Ha_eV,       &
&   AIMAG(Sr%egw         (iband,ik_ibz,1))*Ha_eV,       &
&         zero
   if (verbose/=0) call wrtout(unt,msg,mode) 
  else
   write(msg,'(i5,12(2x,f8.3))')                       & 
&        iband,                                        &
&        ks_energy       (iband,ik_ibz,isp)*Ha_eV,     &
         !sr%e0          (iband,ikibz,isp)*Ha_eV,      &
&        Sr%vxcme      (iband,ik_ibz,isp)*Ha_eV,       &
&        Sr%e0         (iband,ik_ibz,isp)*Ha_eV,       &
&   REAL(Sr%hhartree   (iband,iband,ik_ibz,isp))*Ha_eV,&
&        Sr%sigxme     (iband,ik_ibz,isp)*Ha_eV,       &
&   REAL(Sr%sigcmee0   (iband,ik_ibz,isp))*Ha_eV,      &
&   REAL(Sr%ze0        (iband,ik_ibz,isp)),            &
&   REAL(Sr%dsigmee0   (iband,ik_ibz,isp)),            &
&   REAL(Sr%sigmee     (iband,ik_ibz,isp))*Ha_eV,      &
&   REAL(Sr%degw       (iband,ik_ibz,isp))*Ha_eV,      &
&   REAL(Sr%egw        (iband,ik_ibz,isp))*Ha_eV,      &
&        Sr%en_qp_diago(iband,ik_ibz,isp)*Ha_eV
   call wrtout(unt,msg,mode) 

   write(msg,'(i5,12(2x,f8.3))')                       & 
&         iband,                                       &
&         zero,                                        &
          !sr%e0          (iband,ikibz,isp)*Ha_eV,     &
&         zero,                                        &
&         zero,                                        &
&   AIMAG(Sr%hhartree  (iband,iband,ik_ibz,isp))*Ha_eV,&
&         zero,                                        &
&   AIMAG(Sr%sigcmee0   (iband,ik_ibz,isp))*Ha_eV,     &
&   AIMAG(Sr%ze0        (iband,ik_ibz,isp)),           &
&   AIMAG(Sr%dsigmee0   (iband,ik_ibz,isp)),           &
&   AIMAG(Sr%sigmee     (iband,ik_ibz,isp))*Ha_eV,     &
&   AIMAG(Sr%degw       (iband,ik_ibz,isp))*Ha_eV,     &
&   AIMAG(Sr%egw        (iband,ik_ibz,isp))*Ha_eV,     &
&         zero
   if (verbose/=0) call wrtout(unt,msg,mode) 
  end if
 else 
  ! === PAW+U+GW calculation ===
  msg="PAW+U+GW not yet implemented"
  MSG_ERROR(msg)
 end if

end subroutine print_Sigma_QPSC
!!***

!!****f* m_sigma_results/nullify_sigma_results
!! NAME
!! nullify_sigma_results
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      m_sigma_results
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE

subroutine nullify_sigma_results(Sr)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 type(Sigma_results),intent(inout) :: Sr

! *************************************************************************

!integer 
 nullify(Sr%maxbnd     )
 nullify(Sr%minbnd     )

!real
 !nullify(Sr%ame       )
 nullify(Sr%degwgap    )
 nullify(Sr%egwgap     )
 nullify(Sr%en_qp_diago)
 nullify(Sr%e0         )
 nullify(Sr%e0gap      )
 nullify(Sr%omega_r    )
 nullify(Sr%xkcalc     )
 nullify(Sr%sigxme     )
 nullify(Sr%vxcme      )
 nullify(Sr%vUme       )

!complex
 nullify(Sr%degw       )
 nullify(Sr%dsigmee0   )
 nullify(Sr%egw        )
 nullify(Sr%eigvec_qp  )
 nullify(Sr%hhartree   )
 nullify(Sr%sigcme     )
 nullify(Sr%sigmee     )
 nullify(Sr%sigcmee0   )
 nullify(Sr%sigcmesi   )
 nullify(Sr%sigcme4sd  )
 nullify(Sr%sigxcme    )
 nullify(Sr%sigxcmesi  )
 nullify(Sr%sigxcme4sd )
 nullify(Sr%ze0        )
 nullify(Sr%omega_i    )
 nullify(Sr%omega4sd   )

end subroutine nullify_sigma_results
!!***

!!****f* m_sigma_results/init_sigma_results
!! NAME
!! init_sigma_results
!!
!! FUNCTION
!!
!! INPUTS
!! usepawu=1 if we used LDA+U as starting point (only for PAW)
!!
!! OUTPUT
!!
!! TODO
!!  Write documentation.
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE

subroutine init_sigma_results(Sp,nkibz,usepawu,Sr)

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 integer,intent(in) :: nkibz,usepawu
!scalars
 type(Sigma_parameters),intent(in) :: Sp
 type(Sigma_results),intent(inout) :: Sr

!Local variables-------------------------------
 !character(len=500) :: msg                   
!scalars
 integer :: b1gw,b2gw,mod10

! *************************************************************************

 call nullify_sigma_results(Sr)

 ! === Copy important dimensions ===
 mod10=MOD(Sp%gwcalctyp,10)

!BEGIN NEW
 Sr%nkcalc     =Sp%nkcalc
 Sr%gwcalctyp  =Sp%gwcalctyp
 Sr%deltae     =Sp%deltae
 Sr%maxomega4sd=Sp%maxomega4sd
 Sr%maxomega_r =Sp%maxomega_r
 Sr%scissor_ene=Sp%soenergy
 !FIXME this should be done in allocate_sigma_results
 allocate(Sr%minbnd(Sr%nkcalc),Sr%maxbnd(Sr%nkcalc))
 Sr%minbnd=Sp%minbnd ; Sr%maxbnd=Sp%maxbnd
 allocate(Sr%xkcalc(3,Sr%nkcalc))
 Sr%xkcalc=Sp%xkcalc
!END NEW

 Sr%b1gw     =Sp%minbdgw ! * min and Max GW band index over k and spin. 
 Sr%b2gw     =Sp%maxbdgw !   Used to dimension arrays.
 Sr%nbnds    =Sp%nbnds
 Sr%nkibz    =nkibz
 Sr%nsppol   =Sp%nsppol
 Sr%nsig_ab  =Sp%nsig_ab
 Sr%nomega_r =Sp%nomegasr  !FIXME change name
 Sr%nomega_i =Sp%nomegasi
 Sr%nomega4sd=Sp%nomegasrd
 Sr%usepawu  =usepawu

 !======================================================
 ! === Allocate arrays in the sigma_results datatype ===
 !======================================================
 b1gw=Sr%b1gw  
 b2gw=Sr%b2gw   

 !TODO use this routine
! call allocate_sigma_results(Sr,b1gw,b2gw,Sr%nbnds,Sr%nkibz,Sr%nsppol,&
!& Sr%nsig_ab,Sr%nomega_r,Sr%nomega_i,Sr%nomega4sd,omega_r=Sp%omega_r,omega_i=Sp%omegasi)

 ! hhartree(b1,b2,k,s)= <b1,k,s|T+v_{loc}+v_{nl}+v_{H}|b2,k,s>
 allocate(Sr%hhartree(b1gw:b2gw,b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab)) 
 Sr%hhartree=czero

 ! === QP amplitudes and energies ===
 allocate(Sr%en_qp_diago(Sr%nbnds,Sr%nkibz,Sr%nsppol))        ; Sr%en_qp_diago(:,:,:)=zero
 allocate(Sr%eigvec_qp(Sr%nbnds,Sr%nbnds,Sr%nkibz,Sr%nsppol)) ; Sr%eigvec_qp(:,:,:,:)=czero

 ! Dont know if it is better to do this here or in the sigma
 ! * Initialize with KS wavefunctions and energies
 !do ib=1,Sr%nbnds
 ! Sr%en_qp_diago(ib,:,:)=en(:,ib,:)
 ! Sr%eigvec_qp(ib,ib,:,:)=cone
 !end do 

 allocate(Sr%vxcme   (b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 allocate(Sr%vUme    (b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 allocate(Sr%sigxme  (b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))

 allocate(Sr%sigcme  (b1gw:b2gw,Sr%nkibz,Sr%nomega_r,Sr%nsppol*Sr%nsig_ab))
 allocate(Sr%sigxcme (b1gw:b2gw,Sr%nkibz,Sr%nomega_r,Sr%nsppol*Sr%nsig_ab))

 allocate(Sr%sigcmee0(b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 allocate(Sr%ze0     (b1gw:b2gw,Sr%nkibz,Sr%nsppol))
 allocate(Sr%dsigmee0(b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 allocate(Sr%sigmee  (b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 allocate(Sr%degw    (b1gw:b2gw,Sr%nkibz,Sr%nsppol))

 allocate(Sr%e0 (Sr%nbnds,Sr%nkibz,Sr%nsppol)) 
 allocate(Sr%egw(Sr%nbnds,Sr%nkibz,Sr%nsppol))

 allocate(Sr%e0gap  (Sr%nkibz,Sr%nsppol))
 allocate(Sr%degwgap(Sr%nkibz,Sr%nsppol))
 allocate(Sr%egwgap (Sr%nkibz,Sr%nsppol))
 !allocate(Sr%ame(Sr%nbnds,Sr%nkibz,Sr%nomega_r))
 !
 ! === These quantities are used to evaluate $\Sigma(E)$ around the KS\QP eigenvalue ===
 allocate(Sr%omega4sd  (b1gw:b2gw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol))
 allocate(Sr%sigcme4sd (b1gw:b2gw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol*Sr%nsig_ab))
 allocate(Sr%sigxcme4sd(b1gw:b2gw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol*Sr%nsig_ab))

 !TODO Find  better treatment
 ! Mesh along the real axis.
 if (Sr%nomega_r>0) then
  allocate(Sr%omega_r(Sr%nomega_r))
  Sr%omega_r(:)=Sp%omega_r(:)
 end if

 Sr%e0        =zero
 Sr%egw       =czero
 Sr%e0gap     =zero
 Sr%sigcme    =czero
 Sr%sigxme    =czero
 Sr%sigxcme   =czero
 Sr%sigcmee0  =czero
 Sr%ze0       =czero
 Sr%dsigmee0  =czero
 Sr%sigmee    =czero
 Sr%omega4sd  =czero
 Sr%sigcme4sd =czero
 Sr%sigxcme4sd=czero
 Sr%degw      =czero

 ! === Analytical Continuation ===
 if (mod10==1) then 
  ! FIXME omegasi should not be in Sp% here we should construct the mesh
  allocate(Sr%omega_i(Sr%nomega_i)) ; Sr%omega_i=Sp%omegasi
  allocate(Sr%sigcmesi (b1gw:b2gw,Sr%nkibz,Sr%nomega_i,Sr%nsppol*Sr%nsig_ab))
  allocate(Sr%sigxcmesi(b1gw:b2gw,Sr%nkibz,Sr%nomega_i,Sr%nsppol*Sr%nsig_ab))
  Sr%sigcmesi =czero
  Sr%sigxcmesi=czero
 end if

end subroutine init_sigma_results
!!***

!!****f* m_sigma_results/destroy_sigma_results
!! NAME
!! destroy_sigma_results
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      m_gwannier,sigma
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE

subroutine destroy_sigma_results(Sr)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 type(Sigma_results),intent(inout) :: Sr

! *************************************************************************

 DBG_ENTER("COLL")

!integer
 if (associated(Sr%maxbnd     ))    deallocate(Sr%maxbnd)
 if (associated(Sr%minbnd     ))    deallocate(Sr%minbnd)

!real
 !if (associated(Sr%ame       ))    deallocate(Sr%ame) 
 if (associated(Sr%degwgap    ))    deallocate(Sr%degwgap)
 if (associated(Sr%egwgap     ))    deallocate(Sr%egwgap)
 if (associated(Sr%en_qp_diago))    deallocate(Sr%en_qp_diago)
 if (associated(Sr%e0         ))    deallocate(Sr%e0)
 if (associated(Sr%e0gap      ))    deallocate(Sr%e0gap)
 if (associated(Sr%omega_r    ))    deallocate(Sr%omega_r)
 if (associated(Sr%xkcalc     ))    deallocate(Sr%xkcalc)
 if (associated(Sr%sigxme     ))    deallocate(Sr%sigxme)
 if (associated(Sr%vxcme      ))    deallocate(Sr%vxcme)
 if (associated(Sr%vUme       ))    deallocate(Sr%vUme)
 
!complex
 if (associated(Sr%degw       ))    deallocate(Sr%degw)
 if (associated(Sr%dsigmee0   ))    deallocate(Sr%dsigmee0)
 if (associated(Sr%egw        ))    deallocate(Sr%egw)
 if (associated(Sr%eigvec_qp  ))    deallocate(Sr%eigvec_qp)
 if (associated(Sr%hhartree   ))    deallocate(Sr%hhartree)
 if (associated(Sr%sigcme     ))    deallocate(Sr%sigcme)
 if (associated(Sr%sigmee     ))    deallocate(Sr%sigmee)
 if (associated(Sr%sigcmee0   ))    deallocate(Sr%sigcmee0)
 if (associated(Sr%sigcmesi   ))    deallocate(Sr%sigcmesi)
 if (associated(Sr%sigcme4sd  ))    deallocate(Sr%sigcme4sd)
 if (associated(Sr%sigxcme    ))    deallocate(Sr%sigxcme)
 if (associated(Sr%sigxcmesi  ))    deallocate(Sr%sigxcmesi)
 if (associated(Sr%sigxcme4sd ))    deallocate(Sr%sigxcme4sd)
 if (associated(Sr%ze0        ))    deallocate(Sr%ze0)
 if (associated(Sr%omega_i    ))    deallocate(Sr%omega_i)
 if (associated(Sr%omega4sd   ))    deallocate(Sr%omega4sd)

 DBG_EXIT("COLL")

end subroutine destroy_sigma_results
!!***

!!****f* m_sigma_results/allocate_sigma_results
!! NAME
!! allocate_sigma_results
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      m_sigma_results
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE

subroutine allocate_sigma_results(Sr,b1gw,b2gw,nbnds,nkibz,nkcalc,nsppol,nsig_ab,nomega_r,nomega_i,nomega4sd,&
& omega_r,omega_i) ! Optional

 use defs_basis

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: b1gw,b2gw,nkibz,nsppol,nsig_ab,nbnds
 integer,intent(in) :: nomega_r,nomega_i,nomega4sd,nkcalc
 type(Sigma_results),intent(inout) :: Sr
!arrays
 complex(dpc),optional,intent(in) :: omega_r(:),omega_i(:)

!Local variables-------------------------------
 integer :: ii
! *************************************************************************

 call nullify_sigma_results(Sr)

 Sr%nkcalc=nkcalc
 allocate(Sr%minbnd(Sr%nkcalc),Sr%maxbnd(Sr%nkcalc))

 allocate(Sr%xkcalc(3,Sr%nkcalc))

 ! hhartree(b1,b2,k,s)= <b1,k,s|T+v_{loc}+v_{nl}+v_{H}|b2,k,s>
 allocate(Sr%hhartree(b1gw:b2gw,b1gw:b2gw,nkibz,nsppol*nsig_ab)) 
 Sr%hhartree=czero

 ! === QP amplitudes and energies ===
 allocate(Sr%en_qp_diago(nbnds,nkibz,nsppol))        
 allocate(Sr%eigvec_qp(nbnds,nbnds,nkibz,nsppol)) 
 Sr%en_qp_diago=zero
 Sr%eigvec_qp  =czero

 allocate(Sr%vxcme   (b1gw:b2gw,nkibz,nsppol*nsig_ab))
 allocate(Sr%vUme    (b1gw:b2gw,nkibz,nsppol*nsig_ab))
 allocate(Sr%sigxme  (b1gw:b2gw,nkibz,nsppol*nsig_ab))

 allocate(Sr%sigcme  (b1gw:b2gw,nkibz,nomega_r,nsppol*nsig_ab))
 allocate(Sr%sigxcme (b1gw:b2gw,nkibz,nomega_r,nsppol*nsig_ab))

 allocate(Sr%sigcmee0(b1gw:b2gw,nkibz,nsppol*nsig_ab))
 allocate(Sr%ze0     (b1gw:b2gw,nkibz,nsppol))
 allocate(Sr%dsigmee0(b1gw:b2gw,nkibz,nsppol*nsig_ab))
 allocate(Sr%sigmee  (b1gw:b2gw,nkibz,nsppol*nsig_ab))
 allocate(Sr%degw    (b1gw:b2gw,nkibz,nsppol))

 allocate(Sr%e0 (nbnds,nkibz,nsppol)) 
 allocate(Sr%egw(nbnds,nkibz,nsppol))

 allocate(Sr%e0gap  (nkibz,nsppol))
 allocate(Sr%degwgap(nkibz,nsppol))
 allocate(Sr%egwgap (nkibz,nsppol))
 !allocate(Sr%ame(nbnds,nkibz,nomega_r))

 ! === These quantities are used to evaluate $\Sigma(E)$ around the KS\QP eigenvalue ===
 allocate(Sr%omega4sd  (b1gw:b2gw,nkibz,nomega4sd,nsppol))
 allocate(Sr%sigcme4sd (b1gw:b2gw,nkibz,nomega4sd,nsppol*nsig_ab))
 allocate(Sr%sigxcme4sd(b1gw:b2gw,nkibz,nomega4sd,nsppol*nsig_ab))

 ! Mesh along the real axis.
 if (nomega_r>0) then
  allocate(Sr%omega_r(nomega_r))
  if (PRESENT(omega_r)) then 
   ii=assert_eq(SIZE(omega_r),SIZE(Sr%omega_r),&
&   'DIM omega_r=/Sr%omega_r',__FILE__,__LINE__)
   Sr%omega_r(:)=omega_r(:)
  end if
 end if

 ! === Analytical Continuation ===
 !if (mod10==1) then 
  if (nomega_i>0) then
  ! FIXME omegasi should not be in Sp% here we should construct the mesh
  allocate(Sr%omega_i(nomega_i)) 
  !; Sr%omega_i=Sp%omegasi FIXME this has to be done outside
  allocate(Sr%sigcmesi (b1gw:b2gw,nkibz,nomega_i,nsppol*nsig_ab))
  allocate(Sr%sigxcmesi(b1gw:b2gw,nkibz,nomega_i,nsppol*nsig_ab))
  Sr%omega_i  =czero
  Sr%sigcmesi =czero
  Sr%sigxcmesi=czero
  if (PRESENT(omega_i)) then 
   ii=assert_eq(SIZE(Sr%omega_i),SIZE(omega_i),&
&   'DIM Sr%omega_i /= omega_i',__FILE__,__LINE__)
   Sr%omega_i=omega_i
  end if
 end if

 Sr%e0        =zero
 Sr%egw       =czero
 Sr%e0gap     =zero
 Sr%sigcme    =czero
 Sr%sigxme    =czero
 Sr%sigxcme   =czero
 Sr%sigcmee0  =czero
 Sr%ze0       =czero
 Sr%dsigmee0  =czero
 Sr%sigmee    =czero
 Sr%omega4sd  =czero
 Sr%sigcme4sd =czero
 Sr%sigxcme4sd=czero
 Sr%degw      =czero

end subroutine allocate_sigma_results
!!***

!!****f* m_sigma_results/etsf_dump_QP
!! NAME
!! etsf_dump_QP
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE

subroutine etsf_dump_QP(Sr,QP_BSt,KS_BSt,Hdr,Cryst,Kmesh,filapp)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
#if defined HAVE_ETSF_IO
 use etsf_io
#endif

 use m_numeric_tools, only : c2r
 use m_crystal,       only : abi_crystal_put
 use m_electrons,     only : abi_bands_put

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_61_ionetcdf
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Bandstructure_type),intent(in) :: QP_BSt,KS_BSt
 type(BZ_mesh_type),intent(in) :: Kmesh
 type(Crystal_structure),intent(in) :: Cryst
 type(Sigma_results),intent(in) :: Sr
 type(Hdr_type),intent(inout) :: Hdr
 character(len=fnlen),intent(in) :: filapp
!arrays

!Local variables ---------------------------------------
 character(len=500) :: msg
#if defined HAVE_ETSF_IO
!scalars
 integer :: ncid,nbgw,ndim_sig,b1gw,b2gw,fform,cplex
 logical :: lstat
 character(len=fnlen) :: filetsf
 character(len=etsf_io_low_error_len) :: errmess
 type(ETSF_dims) :: dims
 type(ETSF_io_low_error) :: Error_data
 type(ETSF_gwdata) :: GWdata
!arrays
 real(dp),target,allocatable :: gw_corrections(:,:,:,:) 
 real(dp),allocatable :: rdata2(:,:),rdata3(:,:,:),rdata4(:,:,:,:),rdata5(:,:,:,:,:)
#endif

! *************************************************************************

#if defined HAVE_ETSF_IO

 call abi_crystal_put(Cryst,filapp)
 call abi_Bands_put  (KS_Bst,filapp)
  !check here that I have problems

 filetsf=TRIM(filapp)//'-etsf.nc'
 write(msg,'(3a)')ch10,' etsf_dump_QP : about to open file ',TRIM(filetsf)
 call wrtout(std_out,msg,'COLL')

 call etsf_io_low_open_modify(ncid,filetsf,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 ! === Write the abinit header ===
 ! Have to update the occupations?
 fform=502
 call hdr_io_etsf(fform,Hdr,2,ncid)

 ! === Write the GW correction ===
 write(msg,'(a)')' etsf_dump_QP : about to write GW corrections'
 call wrtout(std_out,msg,'COLL')
 !FIXME this has to be done in a cleaner way use Sr%egw
 allocate(gw_corrections(2,KS_BSt%mband,KS_BSt%nkpt,KS_BSt%nsppol))
 gw_corrections=zero
 gw_corrections(1,:,:,:) = QP_BSt%eig - KS_BSt%eig
 !£gw_corrections = c2r(Sr%degw)
 GWdata%gw_corrections%data4D => gw_corrections

 call etsf_io_gwdata_put(ncid,GWdata,lstat,Error_data)
 if (.not.lstat) goto 1000

 nullify(GWdata%gw_corrections%data4D)
 deallocate(gw_corrections)

 ! === Up to now we have an ETSF file ===
 ! * Now add variables for internal use in abinit.

 call etsf_io_low_set_define_mode(ncid,lstat,Error_data)
 if (.not.lstat) goto 1000

 b1gw=Sr%b1gw ; b2gw=Sr%b2gw
 nbgw=b2gw-b1gw+1
 ndim_sig=Sr%nsppol*Sr%nsig_ab
 cplex=2

 call etsf_io_low_write_dim(ncid,'cplex',cplex,lstat,Error_data=Error_data)  
 if (.not.lstat) goto 1000  ! Needed to store complex quantities

 call etsf_io_low_write_dim(ncid,'b1gw',Sr%b1gw,lstat,Error_data=Error_data) 
 if (.not.lstat) goto 1000 ! min GW band

 call etsf_io_low_write_dim(ncid,'b2gw',Sr%b2gw,lstat,Error_data=Error_data) 
 if (.not.lstat) goto 1000 ! Max GW band

 call etsf_io_low_write_dim(ncid,'nbgw',nbgw,lstat,Error_data=Error_data) 
 if (.not.lstat) goto 1000 ! Number of GW bands

 call etsf_io_low_write_dim(ncid,'nkcalc',Sr%nkcalc,lstat,Error_data=Error_data) 
 if (.not.lstat) goto 1000 ! No. of points calculated

 call etsf_io_low_write_dim(ncid,'ndim_sig',ndim_sig,lstat,Error_data=Error_data)  
 if (.not.lstat) goto 1000 
 
 if (Sr%nomega_r>0) then ! No. of real frequencies, might be zero.
  call etsf_io_low_write_dim(ncid,'nomega_r',Sr%nomega_r,lstat,Error_data=Error_data) 
  if (.not.lstat) goto 1000 
 end if

 if (Sr%nomega_i>0) then ! No. of imaginary frequencies, might be zero.
  call etsf_io_low_write_dim(ncid,'nomega_i',Sr%nomega_i,lstat,Error_data=Error_data) 
  if (.not.lstat) goto 1000 
 end if

 call etsf_io_low_write_dim(ncid,'nomega4sd',Sr%nomega4sd,lstat,Error_data=Error_data) 
 if (.not.lstat) goto 1000 ! No. of points for sigma derivative.

 call etsf_io_low_write_dim(ncid,'nsig_ab',Sr%nsig_ab,lstat,Error_data=Error_data) 
 if (.not.lstat) goto 1000 ! No. of components of sigma (1 if collinear, 4 if noncollinear)

 !call etsf_io_low_write_dim(ncid,'usepawu',Sr%usepawu,lstat,Error_data=Error_data) 
 ! 1 if LDA+U TODO changes name to avoid problems with Hdr
 !if (.not.lstat) goto 1000 

 ! =======================
 ! == Define variables ===
 ! =======================
 ! TODO use more verbose names!

 call etsf_io_low_def_var(ncid,'gwcalctyp',etsf_io_low_integer,&
& lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'omegasrdmax',etsf_io_low_double,&
& lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'deltae',etsf_io_low_double,&
& lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'omegasrmax',etsf_io_low_double,&
& lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'scissor_ene',etsf_io_low_double,&
& lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'xkcalc',etsf_io_low_double,&
& (/pad('number_of_reduced_dimensions'),pad('nkcalc')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'minbnd',etsf_io_low_integer,&
& (/'nkcalc'/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'maxbnd',etsf_io_low_integer,&
& (/'nkcalc'/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 if (Sr%nomega_r>0) then
  call etsf_io_low_def_var(ncid,'omega_r',etsf_io_low_double,&
&  (/'nomega_r'/),lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

!here Sr% starts
 call etsf_io_low_def_var(ncid,'degwgap',etsf_io_low_double,&
& (/pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'egwgap',etsf_io_low_double,&
& (/pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'en_qp_diago',etsf_io_low_double,&
& (/pad('max_number_of_states'),pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'e0',etsf_io_low_double,&
& (/pad('max_number_of_states'),pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'e0gap',etsf_io_low_double,&
& (/pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'sigxme',etsf_io_low_double,&
& (/pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'vxcme',etsf_io_low_double,&
& (/pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'vUme',etsf_io_low_double,&
& (/pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'degw',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'dsigmee0',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'egw',etsf_io_low_double,&
& (/pad('cplex'),pad('max_number_of_states'),pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'eigvec_qp',etsf_io_low_double,&
& (/pad('cplex'),pad('max_number_of_states'),pad('max_number_of_states'),pad('number_of_kpoints'),pad('number_of_spins')/),&
& lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'hhartree',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 if (Sr%nomega_r>0) then
  call etsf_io_low_def_var(ncid,'sigcme',etsf_io_low_double,&
&  (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('nomega_r'),pad('ndim_sig')/),lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

 call etsf_io_low_def_var(ncid,'sigmee',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'sigcmee0',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'sigcmesi',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'sigcme4sd',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('nomega4sd'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 if (Sr%nomega_r>0) then
  call etsf_io_low_def_var(ncid,'sigxcme',etsf_io_low_double,&
&  (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('nomega_r'),pad('ndim_sig')/),lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

 if (Sr%nomega_i>0) then
  call etsf_io_low_def_var(ncid,'sigxcmesi',etsf_io_low_double,&
&  (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('nomega_i'),pad('ndim_sig')/),lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

 call etsf_io_low_def_var(ncid,'sigxcme4sd',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('nomega4sd'),pad('ndim_sig')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_def_var(ncid,'ze0',etsf_io_low_double,&
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 if (Sr%nomega_i>0) then
  call etsf_io_low_def_var(ncid,'omega_i',etsf_io_low_double,& 
&  (/pad('cplex'),pad('nomega_i')/),lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

 call etsf_io_low_def_var(ncid,'omega4sd',etsf_io_low_double,& 
& (/pad('cplex'),pad('nbgw'),pad('number_of_kpoints'),pad('nomega4sd'),pad('number_of_spins')/),lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 ! =====================
 ! === Start writing ===
 ! =====================
 call etsf_io_low_set_write_mode(ncid,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'gwcalctyp',Sr%gwcalctyp,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'omegasrdmax',Sr%maxomega4sd,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'deltae',Sr%deltae,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'omegasrmax',Sr%maxomega_r,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'scissor_ene',Sr%scissor_ene,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'xkcalc',Sr%xkcalc,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'minbnd',Sr%minbnd,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'maxbnd',Sr%maxbnd,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'degwgap',Sr%degwgap,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'egwgap',Sr%egwgap,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'en_qp_diago',Sr%en_qp_diago,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'e0',Sr%e0,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'e0gap',Sr%e0gap,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 if (Sr%nomega_r>0) then
  call etsf_io_low_write_var(ncid,'omega_r',Sr%omega_r,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

 call etsf_io_low_write_var(ncid,'sigxme',Sr%sigxme,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'vxcme',Sr%vxcme,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_write_var(ncid,'vUme',Sr%vUme,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 ! * Have to transfer complex arrays
 allocate(rdata4(cplex,b1gw:b2gw,Sr%nkibz,Sr%nsppol))
 rdata4=c2r(Sr%degw)
 call etsf_io_low_write_var(ncid,'degw',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata4)

 allocate(rdata4(cplex,b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 rdata4=c2r(Sr%dsigmee0)
 call etsf_io_low_write_var(ncid,'dsigmee0',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata4)

 allocate(rdata4(cplex,Sr%nbnds,Sr%nkibz,Sr%nsppol))
 rdata4=c2r(Sr%egw)
 call etsf_io_low_write_var(ncid,'egw',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata4)

 allocate(rdata5(cplex,Sr%nbnds,Sr%nbnds,Sr%nkibz,Sr%nsppol))
 rdata5=c2r(Sr%eigvec_qp)
 call etsf_io_low_write_var(ncid,'eigvec_qp',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata5)

 allocate(rdata5(cplex,nbgw,nbgw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 rdata5=c2r(Sr%hhartree)
 call etsf_io_low_write_var(ncid,'hhartree',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata5)

 if (Sr%nomega_r>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_r,Sr%nsppol*Sr%nsig_ab))
  rdata5=c2r(Sr%sigcme)
  call etsf_io_low_write_var(ncid,'sigcme',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  deallocate(rdata5)
 end if

 allocate(rdata4(cplex,nbgw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 rdata4=c2r(Sr%sigmee)
 call etsf_io_low_write_var(ncid,'sigmee',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata4)

 allocate(rdata4(cplex,nbgw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 rdata4=c2r(Sr%sigcmee0)
 call etsf_io_low_write_var(ncid,'sigcmee0',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata4)

 if (Sr%nomega_i>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_i,Sr%nsppol*Sr%nsig_ab))
  rdata5=c2r(Sr%sigcmesi)
  call etsf_io_low_write_var(ncid,'sigcmesi',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  deallocate(rdata5)
 end if

 allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol*Sr%nsig_ab))
 rdata5=c2r(Sr%sigcme4sd)
 call etsf_io_low_write_var(ncid,'sigcme4sd',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata5)

 if (Sr%nomega_r>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_r,Sr%nsppol*Sr%nsig_ab))
  rdata5=c2r(Sr%sigxcme)
  call etsf_io_low_write_var(ncid,'sigxcme',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  deallocate(rdata5)
 end if

 if (Sr%nomega_i>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_i,Sr%nsppol*Sr%nsig_ab))
  rdata5=c2r(Sr%sigxcmesi)
  call etsf_io_low_write_var(ncid,'sigxcmesi',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

 allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol*Sr%nsig_ab))
 rdata5=c2r(Sr%sigxcme4sd)
 call etsf_io_low_write_var(ncid,'sigxcme4sd',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata5)

 allocate(rdata4(cplex,nbgw,Sr%nkibz,Sr%nsppol))
 rdata4=c2r(Sr%ze0)
 call etsf_io_low_write_var(ncid,'ze0',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata4)

 if (Sr%nomega_i>0) then
  allocate(rdata2(cplex,Sr%nomega_i))
  rdata2=c2r(Sr%omega_i)
  call etsf_io_low_write_var(ncid,'omega_i',rdata2,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  deallocate(rdata2)
 end if

 allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol))
 rdata5=c2r(Sr%omega4sd)
 call etsf_io_low_write_var(ncid,'omega4sd',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 deallocate(rdata5)

 ! === Close the file ===
 call etsf_io_low_close(ncid,lstat,Error_data)
 if (.not.lstat) goto 1000

 1000 continue
 if (.not.lstat) then
  ! === Handle the error ===
  call etsf_io_low_error_to_str(errmess,Error_data)
  write(msg,'(4a)')ch10,' etsf_dump_QP: ERROR -',ch10,errmess(1:min(475, len(errmess)))
  call wrtout(std_out,msg,'COLL')
  call leave_new('COLL')
 end if

 write(msg,'(a)')' etsf_dump_QP: exit '
 call wrtout(std_out,msg,'COLL')

#else 
 write(msg,'(4a)')ch10,&
& ' etsf_dump_QP : ERROR - ',ch10,&
& '  ETSF-IO support is not activated. '
 call wrtout(std_out,msg,'COLL') 
 !£call leave_new('COLL')
#endif

end subroutine etsf_dump_QP
!!***

!!****f* m_sigma_results/abi_etsf_get_QP
!! NAME
!! abi_etsf_get_QP
!!
!! FUNCTION
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      m_gwannier
!!
!! CHILDREN
!!      abi_bands_read,allocate_sigma_results,etsf_io_dims_get
!!      etsf_io_low_close,etsf_io_low_error_to_str,etsf_io_low_open_read
!!      etsf_io_low_read_dim,etsf_io_low_read_var,hdr_io_etsf
!!      initcrystalfromhdr,leave_new,wrtout
!!
!! SOURCE

subroutine abi_etsf_get_QP(Sr,KS_BSt,Hdr,Cryst,filapp)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_crystal
#if defined HAVE_ETSF_IO
 use etsf_io
#endif

 use m_numeric_tools,  only : r2c
 use m_electrons,      only : abi_bands_read

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_61_ionetcdf
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(Bandstructure_type),intent(out) :: KS_BSt
 type(Crystal_structure),intent(out) :: Cryst
 type(Sigma_results),intent(out) :: Sr
 type(Hdr_type),intent(out) :: Hdr
 character(len=fnlen),intent(in) :: filapp
!arrays

!Local variables ---------------------------------------
 character(len=500) :: msg
#if defined HAVE_ETSF_IO
!scalars
 integer :: ncid,nbgw,ndim_sig,b1gw,b2gw,fform,cplex,timrev
 integer :: prtvol
 logical :: lstat
 character(len=fnlen) :: filetsf
 character(len=etsf_io_low_error_len) :: errmess
 type(ETSF_dims) :: Dims
 type(ETSF_io_low_error) :: Error_data
 type(ETSF_gwdata) :: GWdata
!arrays
 real(dp),target,allocatable :: gw_corrections(:,:,:,:) 
 real(dp),allocatable :: rdata2(:,:),rdata3(:,:,:),rdata4(:,:,:,:),rdata5(:,:,:,:,:)
#endif

! *************************************************************************

#if defined HAVE_ETSF_IO
 filetsf=TRIM(filapp)//'-etsf.nc'
 write(msg,'(3a)')ch10,' abi_etsf_get_QP : about to read file ',TRIM(filetsf)
 call wrtout(std_out,msg,'COLL')
 call etsf_io_low_open_read(ncid,filetsf,lstat,Error_data=Error_data,with_etsf_header=.TRUE.)
 if (.not.lstat) goto 1000

 ! === Read KS band structure ===
 call abi_Bands_read(KS_Bst,filapp)

 ! === Read the abinit header ===
 call hdr_io_etsf(fform,Hdr,1,ncid)

 timrev=2
 call InitCrystalFromHdr(Hdr,Cryst,timrev,remove_inv=.FALSE.)

 ! === Read dimensions handled by ETSF ===
 call etsf_io_dims_get(ncid,Dims,lstat,Error_data)
 if (.not.lstat) goto 1000

 ! FIXME: don't handle k_dependent = 1
 !hdr%bantot   = dims%max_number_of_states * dims%number_of_kpoints * dims%number_of_spins
 !hdr%natom    = dims%number_of_atoms
 Sr%nbnds     = Dims%max_number_of_states
 Sr%nkibz     = Dims%number_of_kpoints
 !hdr%nspden   = dims%number_of_components
 !hdr%nspinor  = dims%number_of_spinor_components
 Sr%nsppol     = Dims%number_of_spins
 !hdr%nsym     = dims%number_of_symmetry_operations
 !hdr%ntypat   = dims%number_of_atom_species

 call etsf_io_low_read_dim(ncid,'b1gw',Sr%b1gw,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_dim(ncid,'b2gw',Sr%b2gw,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 !call etsf_io_low_read_dim(ncid,'nbgw',??,lstat,Error_data=Error_data)
 !if (.not.lstat) goto 1000

 !FIXME
 call etsf_io_low_read_dim(ncid,'nkcalc',Sr%nkcalc,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 !call etsf_io_low_read_dim(ncid,'ndim_sig',Sr%ndim_sig,lstat,Error_data=Error_data)
 !if (.not.lstat) goto 1000

 ! The following dimensions might be not specified
 call etsf_io_low_read_dim(ncid,'nomega_r',Sr%nomega_r,lstat,Error_data=Error_data)
 if (Sr%nomega_r==etsf_no_dimension) lstat=.TRUE.
 if (.not.lstat) goto 1000

 call etsf_io_low_read_dim(ncid,'nomega_i',Sr%nomega_i,lstat,Error_data=Error_data)
 if (Sr%nomega_i==etsf_no_dimension) lstat=.TRUE.
 if (.not.lstat) goto 1000

 call etsf_io_low_read_dim(ncid,'nomega4sd',Sr%nomega4sd,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_dim(ncid,'nsig_ab',Sr%nsig_ab,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 !call etsf_io_low_read_dim(ncid,'usepawu',Sr%usepawu,lstat,Error_data=Error_data)
 !if (.not.lstat) goto 1000

 ! == Initialize the structure ===
 call allocate_sigma_results(Sr,&
& Sr%b1gw,Sr%b2gw,Sr%nbnds,Sr%nkibz,Sr%nkcalc,Sr%nsppol,Sr%nsig_ab,Sr%nomega_r,Sr%nomega_i,Sr%nomega4sd)

 b1gw=Sr%b1gw 
 b2gw=Sr%b2gw
 nbgw=b2gw-b1gw+1

 ! ======================
 ! === Read variables ===
 ! ======================

 call etsf_io_low_read_var(ncid,'gwcalctyp',Sr%gwcalctyp,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'omegasrdmax',Sr%maxomega4sd,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'deltae',Sr%deltae,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'omegasrmax',Sr%maxomega_r,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'scissor_ene',Sr%scissor_ene,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'xkcalc',Sr%xkcalc,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'minbnd',Sr%minbnd,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'maxbnd',Sr%maxbnd,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'degwgap',Sr%degwgap,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'egwgap',Sr%egwgap,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'en_qp_diago',Sr%en_qp_diago,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'e0',Sr%e0,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'e0gap',Sr%e0gap,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 if (Sr%nomega_r>0) then
  call etsf_io_low_read_var(ncid,'omega_r',Sr%omega_r,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
 end if

 call etsf_io_low_read_var(ncid,'sigxme',Sr%sigxme,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'vxcme',Sr%vxcme,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 call etsf_io_low_read_var(ncid,'vUme',Sr%vUme,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000

 cplex=2
 allocate(rdata4(cplex,b1gw:b2gw,Sr%nkibz,Sr%nsppol))
 call etsf_io_low_read_var(ncid,'degw',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%degw=r2c(rdata4)
 deallocate(rdata4)

 allocate(rdata4(cplex,b1gw:b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 call etsf_io_low_read_var(ncid,'dsigmee0',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%dsigmee0=r2c(rdata4) 
 deallocate(rdata4)

 allocate(rdata4(cplex,Sr%nbnds,Sr%nkibz,Sr%nsppol))
 call etsf_io_low_read_var(ncid,'egw',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%egw=r2c(rdata4)
 deallocate(rdata4)

 allocate(rdata5(cplex,Sr%nbnds,Sr%nbnds,Sr%nkibz,Sr%nsppol))
 call etsf_io_low_read_var(ncid,'eigvec_qp',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%eigvec_qp=r2c(rdata5)
 deallocate(rdata5)

 allocate(rdata5(cplex,Sr%b1gw:Sr%b2gw,Sr%b1gw:Sr%b2gw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 call etsf_io_low_read_var(ncid,'hhartree',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%hhartree=r2c(rdata5)
 deallocate(rdata5)

 if (Sr%nomega_r>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_r,Sr%nsppol*Sr%nsig_ab))
  call etsf_io_low_read_var(ncid,'sigcme',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  Sr%sigcme=r2c(rdata5)
  deallocate(rdata5)
 end if

 allocate(rdata4(cplex,nbgw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 call etsf_io_low_read_var(ncid,'sigmee',rdata4,lstat,Error_data=Error_data)
 Sr%sigmee=r2c(rdata4)
 if (.not.lstat) goto 1000
 deallocate(rdata4)

 allocate(rdata4(cplex,nbgw,Sr%nkibz,Sr%nsppol*Sr%nsig_ab))
 call etsf_io_low_read_var(ncid,'sigcmee0',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%sigcmee0=r2c(rdata4) 
 deallocate(rdata4)

 if (Sr%nomega_i>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_i,Sr%nsppol*Sr%nsig_ab))
  call etsf_io_low_read_var(ncid,'sigcmesi',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  Sr%sigcmesi=r2c(rdata5) 
  deallocate(rdata5)
 end if

 allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol*Sr%nsig_ab))
 call etsf_io_low_read_var(ncid,'sigcme4sd',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%sigcme4sd=r2c(rdata5)
 deallocate(rdata5)

 if (Sr%nomega_r>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_r,Sr%nsppol*Sr%nsig_ab))
  call etsf_io_low_read_var(ncid,'sigxcme',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  Sr%sigxcme=r2c(rdata5)
  deallocate(rdata5)
 end if

 if (Sr%nomega_i>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_i,Sr%nsppol*Sr%nsig_ab))
  call etsf_io_low_read_var(ncid,'sigxcmesi',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  Sr%sigxcmesi=r2c(rdata5)
  deallocate(rdata5)
 end if

 allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol*Sr%nsig_ab))
 call etsf_io_low_read_var(ncid,'sigcme4sd',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%sigcme4sd=r2c(rdata5)
 deallocate(rdata5)

 if (Sr%nomega_r>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_r,Sr%nsppol*Sr%nsig_ab))
  call etsf_io_low_read_var(ncid,'sigxcme',rdata5,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  Sr%sigxcme=r2c(rdata5)
  deallocate(rdata5)
 end if

 if (Sr%nomega_i>0) then
  allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega_i,Sr%nsppol*Sr%nsig_ab))
  call etsf_io_low_read_var(ncid,'sigxcmesi',rdata5,lstat,Error_data=Error_data)
  Sr%sigxcmesi=r2c(rdata5)
  if (.not.lstat) goto 1000
 end if

 allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol*Sr%nsig_ab))
 call etsf_io_low_read_var(ncid,'sigxcme4sd',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%sigxcme4sd=r2c(rdata5)
 deallocate(rdata5)

 allocate(rdata4(cplex,nbgw,Sr%nkibz,Sr%nsppol))
 call etsf_io_low_read_var(ncid,'ze0',rdata4,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%ze0=r2c(rdata4)
 !Sr%ze0=CMPLX(rdata4(1,:,:,:),rdata4(2,:,:,:))
 !write(*,*)rdata4
 !write(*,*)Sr%ze0
 deallocate(rdata4)

 if (Sr%nomega_i>0) then
  allocate(rdata2(cplex,Sr%nomega_i))
  call etsf_io_low_read_var(ncid,'omega_i',rdata2,lstat,Error_data=Error_data)
  if (.not.lstat) goto 1000
  Sr%omega_i=r2c(rdata2)
  deallocate(rdata2)
 end if

 allocate(rdata5(cplex,nbgw,Sr%nkibz,Sr%nomega4sd,Sr%nsppol))
 call etsf_io_low_read_var(ncid,'omega4sd',rdata5,lstat,Error_data=Error_data)
 if (.not.lstat) goto 1000
 Sr%omega4sd=r2c(rdata5)
 deallocate(rdata5)

 call etsf_io_low_close(ncid,lstat,Error_data)
 if (.not.lstat) goto 1000

 1000 continue
 ! === Handle the error ===
 if (.not.lstat) then
  call etsf_io_low_error_to_str(errmess,Error_data)
  write(msg,'(4a)')ch10,&
&  ' abi_etsf_get_QP: ERROR -',ch10,&
&  errmess(1:MIN(460,LEN(errmess)))
  call wrtout(std_out,msg,'COLL')
  call leave_new('COLL')
 end if

#else
 write(msg,'(4a)')ch10,&
& ' abi_etsf_get_QP : ERROR - ',ch10,&
& '  ETSF-IO support is not activated. '
 call wrtout(std_out,msg,'COLL') 
 !£call leave_new('COLL')
#endif

end subroutine abi_etsf_get_QP

END MODULE m_sigma_results
!!***
