!{\src2tex{textfont=tt}}
!!****f* ABINIT/mlwfovlp_qp
!! NAME
!! mlwfovlp_qp
!!
!! FUNCTION
!! Routine which computes replaces LDA wave functions and eigenvalues with
!! GW quasiparticle ones using previously computed qp wave functions in
!! LDA bloch function representation
!! for Wannier code (www.wannier.org f90 version).
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2009 ABINIT group (DRH)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  dtset <type(dataset_type)>=all input variables for this dataset
!!  dtfil <type(datafiles_type)>=variables related to files
!!  mband=maximum number of bands
!!  mkmem =number of k points which can fit in memory; set to 0 if use disk
!!  mpw=maximum dimensioned size of npw.
!!  natom=number of atoms in cell.
!!  nkpt=number of k points.
!!  npwarr(nkpt)=number of planewaves in basis at this k point
!!  nspden=number of spin-density components
!!  nspinor=number of spinorial components of the wavefunctions
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  rprimd(3,3)=dimensional primitive translations for real space (bohr)
!!  Hdr<Hdr_type>=The abinit header.
!!  MPI_enreg=information about MPI parallelization
!!  Cprj_BZ(natom,nspinor*mband*mkmem*nsppol)= <p_lmn|Cnk> coefficients for each WF |Cnk> and each |p_lmn> non-local projector
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  cg(2,mpw*nspinor*mband*mkmem*nsppol)=planewave coefficients of wavefunctions
!!   replaced by quasiparticle wavefunctions
!!  eigen(mband*nkpt*nsppol)=array for holding eigenvalues replaced by qp
!!   eigenvalues(hartree)
!!
!! NOTES
!!  Number of bands for wannier calculation must be identical to number used
!!   for gw calculation.  Bands not wanted for wannier calculation must be
!!   excluded in exclude_band statement in wannier90.win file.
!!  Full plane-wave basis for LDA wavefunctions must be used in GW calculation,
!!   or inaccuracies may result.
!!  This is at best a beta version of this code, with little consistency 
!!   checking, so the user must be very careful or the results may be invalid.
!!
!! PARENTS
!!      outscfcv
!!
!! CHILDREN
!!      assert,bstruct_clean,bstruct_init,destroy_bz_mesh_type,destroycrystal
!!      initcrystalfromhdr,initkmesh,initmpi_seq,leave_new,listkk,metric,rdqps
!!      update_cprj,wrtout,zgemm
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine mlwfovlp_qp(cg,Cprj_BZ,dtset,dtfil,eigen,mband,mkmem,mpw,natom,&
& nkpt,npwarr,nspden,nspinor,nsppol,ntypat,Hdr,Pawtab,rprimd,MPI_enreg)
    
 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use defs_wannier90
 use m_crystal
 use m_bz_mesh
 use m_errors,     only : assert
 use m_qparticles, only : rdqps

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_42_geometry
 use interfaces_51_manage_mpi
 use interfaces_66_wfs
 use interfaces_68_gw, except_this_one => mlwfovlp_qp
!End of the abilint section

 implicit none
!Arguments ------------------------------------
!scalars
 integer,intent(in) :: mband,mkmem,mpw,nkpt,nspden,nspinor,natom,ntypat
 integer,intent(in) :: nsppol
 type(dataset_type),intent(in) :: dtset
 type(datafiles_type),intent(in) :: dtfil
 type(Hdr_type),intent(in) :: Hdr
 type(MPI_type),intent(inout) :: MPI_enreg
 type(Cprj_type),intent(inout) :: Cprj_BZ(natom,nspinor*mband*mkmem*nsppol)
 type(Pawtab_type),intent(in) :: Pawtab(ntypat*Dtset%usepaw)
!arrays
 integer,intent(in) :: npwarr(nkpt)
 real(dp),intent(inout) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
 real(dp),intent(inout) :: eigen(mband*nkpt*nsppol)
 real(dp),intent(in) :: rprimd(3,3)

!Local variables-------------------------------
!scalars
 integer :: sppoldbl,timrev,bantot_ibz,ikibz,ikbz,dimrho
 integer :: iatom,iband,icg,icg_shift,ii,ipw,isppol,jband,nband_k
 integer :: nfftot,ikpt,irzkpt,npw_k,ikg,ijpack
 integer :: nscf,nbsc,itimrev,band_index,nkibz,nnsclo_now,nkbz
 integer :: gw_timrev
 real(dp) :: dksqmax,ortho_err,ucvol
 logical :: ltest
 character(len=500) :: message
 character(len=fnlen) :: filnam
 type(Bandstructure_type) :: QP_BSt
 type(Crystal_structure)  :: Cryst 
 type(BZ_mesh_type) :: Kibz_mesh
 type(MPI_type) :: MPI_enreg_seq
!arrays
 integer :: indkk(nkpt,6),my_ngfft(18)
 integer,allocatable :: npwarr_ibz(:),nband_ibz(:),ibz2bz(:,:),istwfk_ibz(:)
 integer,allocatable :: dimlmn(:) 
 real(dp) :: gmet(3,3),gprimd(3,3),rmet(3,3)
 real(dp),allocatable :: qp_rhor(:,:)
 real(dp),allocatable :: kibz(:,:),wtk_ibz(:)
 real(dp),allocatable :: doccde_ibz(:),occfact_ibz(:),eigen_ibz(:)
 complex(dpc),allocatable :: m_lda_to_qp(:,:,:,:),ortho(:),m_lda_to_qp_BZ(:,:,:,:)
 complex(dpc),allocatable :: m_tmp(:,:),cg_k(:,:),cg_qpk(:,:)

!************************************************************************

#if defined DEBUG_MODE
 write(message,'(a)')' mlwfovlp_qp : enter'
 call wrtout(std_out,message,'COLL')
#endif

 write(message,'(17a)')ch10,&
& ' mlwfovlp_qp: WARNING',ch10,&
& '  The input *_WFK file of LDA wavefunctions to be  converted',ch10,&
& '  to GW quasiparticle wavefunctions MUST have been written in',ch10,&
& '  the run that produced the GW *_KSS file using kssform 3,',ch10,&
& '  the ONLY value of kssform permitted for GW Wannier functions.',ch10,&
& '  Otherwise, the *_QPS file needed here will be inconsistent,',ch10,&
& '  and the output quasiparticle wavefunctions will be garbage.',ch10,&
& '  No internal check that can verify this is presently possible.',ch10
 call wrtout(std_out,message,'COLL')

 ! === Some features are not implemented yet ===
 ltest=(Dtset%nspinor==1)
 call assert(ltest,'nspinor==2 not implemented',__FILE__,__LINE__)
 ltest=(Dtset%nsppol==1)
 call assert(ltest,'nsppol==2 not implemented, check wannier90',__FILE__,__LINE__)
 ltest=ALL(Dtset%nband(1:Dtset%nkpt*Dtset%nsppol)==Dtset%nband(1))
 call assert(ltest,'nband should be constant',__FILE__,__LINE__)
 ltest=(mkmem/=0)
 call assert(ltest,'mkmem==0 not implemented',__FILE__,__LINE__)

 ! Compute reciprocal space metric gmet for unit cell of disk wf
 call metric(gmet,gprimd,-1,rmet,rprimd,ucvol)

 ! Compute k points from gw irreducible set equivalent to full-zone wannier set
 sppoldbl=1 ; timrev=1
 call listkk(dksqmax,gmet,indkk,dtset%kptgw,dtset%kpt,dtset%nkptgw,nkpt,&
& dtset%nsym,sppoldbl,dtset%symafm,dtset%symrel,timrev)

 if (dksqmax>tol8) then
  write(message,'(8a)')ch10,&
&  ' mlwfovlp_qp : ERROR',ch10,&
&  '  Set of GW irreducible-zone kptgw in input file is inconsistent',ch10,&
&  '  with full-zone set being used for wannier90 setup.',ch10,&
&  '  Action : correct input data'
  call wrtout(std_out,message,'COLL')
  call leave_new('COLL')
 end if

 ! === Initialize object defining the Band strucuture ===
 ! * Initialize with KS results using IBZ indexing.
 ! * After rdqps, QP_BSt will contain the QP amplitudes. 

 nkibz=Dtset%nkptgw
 allocate(kibz(3,nkibz),wtk_ibz(nkibz))
 kibz=Dtset%kptgw(:,1:Dtset%nkptgw) 

 ! MG: This part is needed to get the IBZ weight that will be reported 
 ! on ab_out thus we should be consistent. Ideally Cryst should be 
 ! one of the basic abinit objects and passed to this routine.

 gw_timrev=1 
 if (timrev==1) gw_timrev=2 !different conventions are used in GW and abinit!!
 call InitCrystalFromHdr(Hdr,Cryst,gw_timrev)
 call InitKmesh(nkibz,kibz,Cryst,Kibz_mesh,Dtset%prtvol)
 !wtk_ibz=one 
 wtk_ibz=Kibz_mesh%wt
 call DestroyCrystal(Cryst)
 call destroy_bz_mesh_type(Kibz_mesh)

 allocate(ibz2bz(nkibz,6))
 call listkk(dksqmax,gmet,ibz2bz,dtset%kpt,dtset%kptgw,nkpt,dtset%nkptgw,&
& dtset%nsym,sppoldbl,dtset%symafm,dtset%symrel,timrev)

 ltest=ALL(ibz2bz(:,2)==1) 
 call assert(ltest,'Not able to found irreducible points in the BZ set!',&
& __FILE__,__LINE__)

 if (dksqmax>tol8) then
  write(message,'(8a)')ch10,&
&  ' mlwfovlp_qp : ERROR',ch10,&
&  '  Set of GW irreducible-zone kptgw in input file is inconsistent',ch10,&
&  '  with full-zone set being used for wannier90 setup.',ch10,&
&  '  Action : correct input data'
  call wrtout(std_out,message,'COLL')
  call leave_new('COLL')
 end if

 allocate(npwarr_ibz(nkibz),istwfk_ibz(nkibz),nband_ibz(nkibz*nsppol)) 

 do isppol=1,nsppol
  do ikibz=1,nkibz
   ikbz=ibz2bz(ikibz+(sppoldbl-1)*(isppol-1)*nkibz,1)
   npwarr_ibz(ikibz)=      npwarr(ikbz)
   istwfk_ibz(ikibz)=Dtset%istwfk(ikbz)
   nband_ibz(ikibz+(isppol-1)*nkibz)=Dtset%nband(ikbz+(isppol-1)*nkpt)
  end do
 end do

 bantot_ibz=SUM(nband_ibz)
 allocate(doccde_ibz(bantot_ibz),eigen_ibz(bantot_ibz),occfact_ibz(bantot_ibz))
 doccde_ibz(:)=zero ; eigen_ibz(:)=zero ; occfact_ibz(:)=zero 

 band_index=0
 do isppol=1,nsppol
  do ikibz=1,nkibz
   ikbz=ibz2bz(ikibz+(sppoldbl-1)*(isppol-1)*nkibz,1)
   nband_k=nband_ibz(ikibz+(isppol-1)*nkibz)
   ii=SUM(Dtset%nband(1:ikbz+(isppol-1)*nkpt))-nband_k
   eigen_ibz(band_index+1:band_index+nband_k)=eigen(ii+1:ii+nband_k)
   band_index=band_index+nband_k
  end do
 end do

 call bstruct_init(bantot_ibz,QP_BSt,Dtset%nelect,doccde_ibz,eigen_ibz,istwfk_ibz,kibz,nband_ibz,&
& nkibz,npwarr_ibz,nsppol,nspinor,Dtset%tphysel,Dtset%tsmear,Dtset%occopt,occfact_ibz,wtk_ibz) 

 deallocate(kibz,wtk_ibz)
 deallocate(ibz2bz)
 deallocate(npwarr_ibz,istwfk_ibz,nband_ibz) 
 deallocate(doccde_ibz,eigen_ibz,occfact_ibz)

 ! === Read in quasiparticle information ===
 ! * Initialize QP amplitudes with KS, QP_BSt% presently contains KS energies.
 ! * If file not found return, everything has been already initialized with KS values
 !   Here qp_rhor is not needed thus dimrho=0 
 ! TODO paral_kgb not implemented but this is the last problem to be solved

 allocate(m_lda_to_qp(mband,mband,dtset%nkptgw,nsppol))
 m_lda_to_qp=czero
 do iband=1,mband
  m_lda_to_qp(iband,iband,:,:)=cone
 end do

 ! * Fake MPI_type for rdqps
 call initmpi_seq(MPI_enreg_seq) 

 my_ngfft=Dtset%ngfft ; if (Dtset%usepaw==1.and.ALL(Dtset%ngfftdg(1:3)/=0)) my_ngfft=Dtset%ngfftdg
 nfftot=PRODUCT(my_ngfft(1:3)) ; dimrho=0

 allocate(qp_rhor(nfftot,nspden*dimrho))

 call rdqps(QP_BSt,Dtfil%filqps,Dtset%usepaw,Dtset%nspden,dimrho,nscf,Dtset%prtvol,&
& nfftot,my_ngfft,ucvol,Dtset%paral_kgb,MPI_enreg_seq,nbsc,m_lda_to_qp,qp_rhor)

 deallocate(qp_rhor)

 ! === Begin big loop over full-zone k points and spin (not implemented) ===
 ! * Wannier90 treats only a single spin, changes in wannier90 are needed 
 allocate(cg_k(mpw,mband),cg_qpk(mpw,mband),m_tmp(mband,mband))

 band_index=0 ; icg=0 ; ikg=0
 do isppol=1,nsppol
  do ikpt=1,nkpt

   irzkpt =indkk(ikpt+(sppoldbl-1)*(isppol-1)*nkpt,1)
   itimrev=indkk(ikpt+(sppoldbl-1)*(isppol-1)*nkpt,6)
   npw_k=npwarr(ikpt)
   nband_k=dtset%nband(ikpt+(isppol-1)*nkpt)

   if (nband_k/=mband) then
    write(message,'(4a,i6,7a)')ch10,&
&    ' mlwfovlp_qp : ERROR',ch10,&
&    '  Number of bands for k point',ikpt,' is inconsistent with number',ch10,&
&    '  specified for wannier90 calculation',ch10,&
&    '  Action : correct input so all band numbers are equal for GW',ch10,&
&    '  and wannier90 datasets.'
    call wrtout(std_out,message,'COLL')
    call leave_new('COLL')
   end if

   ! === Load KS states for this kbz and spin ===
   do iband=1,nband_k
    icg_shift=npw_k*nspinor*(iband-1)+icg
    do ipw=1,npw_k
     cg_k(ipw,iband)=cmplx(cg(1,ipw+icg_shift),cg(2,ipw+icg_shift))
    end do
   end do

   ! If time reversal is used relating ikpt to irzkpt, then multiply by
   ! complex conjugage of lda-to-qp transformation matrix
   if (itimrev==0) then
    m_tmp(:,:)=m_lda_to_qp(:,:,irzkpt,isppol)
   else if (itimrev==1) then
    m_tmp(:,:)=conjg(m_lda_to_qp(:,:,irzkpt,isppol))
   else
    write(message,'(4a,i6,3a,i6,2a)')ch10,&
&    ' mlwfovlp_qp : ERROR',ch10,&
&    '  Invalid indkk(ikpt,6)',itimrev,'from routine listkk',ch10,&
&    '  for k-point',ikpt,ch10,&
&    '  Action : report error to Abinit'
    call wrtout(std_out,message,'COLL')
    call leave_new('COLL')
   end if

   call zgemm('N','N',npw_k,mband,mband,(1._dp,0._dp),cg_k,mpw,m_tmp,mband,(0._dp,0._dp),cg_qpk,mpw)

   ! === Orthonormality test ===
   ! * nband >= maxval(bndgw) for this to pass, but may be less than nband used in GW.
   ! * Unfortunately, does not test WFK and QPS consistency.
   allocate(ortho(nband_k*(nband_k+1)/2))
   ortho=czero ; ijpack=0
   do jband=1,nband_k
    do iband=1,jband
     ijpack=ijpack+1
     ortho(ijpack)=sum(conjg(cg_qpk(1:npw_k,iband))*cg_qpk(1:npw_k,jband))
     if (jband==iband) ortho(ijpack)=ortho(ijpack)-cone
    end do
   end do
   ortho_err=maxval(abs(ortho))

   !write(std_out,*)' drh - mlwfovlp_qp: ikpt,ortho_err',ikpt,ortho_err
   if (ortho_err>tol6) then
    write(message, '(6a,i4,a,i6,a,1p,e8.1,3a)' )ch10,&
&    ' mlwfovlp_qp : ERROR',ch10,&
&    '  orthonormality error for quasiparticle wave functions.',ch10,&
&    '  spin=',isppol,'  k point=',ikpt,'  ortho_err=',ortho_err,' >1E-6',ch10,&
&    '  Action : Be sure input nband>=maxval(bndgw)'
    call wrtout(std_out,message,'COLL')
    call leave_new('COLL')
   end if
   deallocate(ortho)

   ! Replace lda wave functions and eigenvalues with quasiparticle ones
   do iband=1,nband_k
    icg_shift=npw_k*nspinor*(iband-1)+icg
    eigen(iband+band_index)=QP_BSt%eig(iband,irzkpt,isppol)
    do ipw=1,npw_k
     cg(1,ipw+icg_shift)= real(cg_qpk(ipw,iband))
     cg(2,ipw+icg_shift)=aimag(cg_qpk(ipw,iband))
    end do
   end do

   band_index=band_index+nband_k
   icg=icg+npw_k*nspinor*nband_k
   ikg=ikg+npw_k
  end do !ikpt
 end do !isppol

 deallocate(cg_k,cg_qpk,m_tmp)

 ! === If PAW, update projections in BZ === 
 ! * Since I am lazy and here I do not care about memory, I just reconstruct m_lda_to_qp in the BZ. 
 ! * update_cprj will take care of updating the PAW projections to get <p_lmn|QP_{nks]>
 !   This allows some CPU saving, no need to call ctocprj.
 ! FIXME this part should be tested, automatic test to be provided
 if (Dtset%usepaw==1) then 
  allocate(dimlmn(natom))
  do iatom=1,natom
   dimlmn(iatom)=Pawtab(Dtset%typat(iatom))%lmn_size
  end do

  nkbz=nkpt
  allocate(m_lda_to_qp_BZ(mband,mband,nkbz,nsppol))
  do isppol=1,nsppol
   do ikbz=1,nkbz
    ikibz  =indkk(ikibz+(sppoldbl-1)*(isppol-1)*nkbz,1)
    itimrev=indkk(ikibz+(sppoldbl-1)*(isppol-1)*nkbz,6)
    select case (itimrev)
    case (0)
     m_lda_to_qp_BZ(:,:,ikbz,isppol)=m_lda_to_qp(:,:,ikibz,isppol)
    case (1)
     m_lda_to_qp_BZ(:,:,ikbz,isppol)=CONJG(m_lda_to_qp(:,:,ikibz,isppol))
    case default
     call assert(.FALSE.,'Wrong itimrev',__FILE__,__LINE__)
    end select
   end do
  end do

  call update_cprj(natom,nkbz,mband,nsppol,nspinor,m_lda_to_qp_BZ,dimlmn,Cprj_BZ)
  deallocate(dimlmn)
  deallocate(m_lda_to_qp_BZ)
 end if !PAW

 write(message,'(6a)')ch10,&
& ' mlwfovlp_qp: Input KS wavefuctions have been converted',ch10,&
& '  to GW quasiparticle wavefunctions for maximally localized wannier',ch10,&
& '  function construction by wannier90.'
 call wrtout(ab_out,message,'COLL')
 call wrtout(std_out,message,'COLL')

 deallocate(m_lda_to_qp)
 call bstruct_clean(QP_BSt)

#if defined DEBUG_MODE
 write(message,'(a)')' mlwfovlp_qp : exit'
 call wrtout(std_out,message,'COLL')
#endif

end subroutine mlwfovlp_qp
!!***
