!!****f* ABINIT/paw_mknewh0
!! NAME
!! paw_mknewh0
!!
!! FUNCTION
!!
!! COPYRIGHT
!!  Copyright (C) 2008-2009 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      calc_vHxc_braket
!!
!! CHILDREN
!!      assert,pawgylm,symdij,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine paw_mknewh0(nsppol,nspden,nfftf,pawspnorb,pawprtvol,Cryst,Psps,&
& Pawtab,Paw_an,Pawang,Pawrad,Pawfgrtab,vhartr,vxc,vxc_val,vtrial,Paw_ij)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_errors

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_66_paw
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nsppol,nspden,nfftf,pawprtvol,pawspnorb
!arrays
 real(dp),intent(in) :: vhartr(nfftf),vxc(nfftf,nspden),vxc_val(nfftf,nspden),vtrial(nfftf,nspden)
 type(Crystal_structure),intent(in) :: Cryst
 type(Pseudopotential_type),intent(in) :: Psps
 type(Pawang_type),intent(in) :: Pawang
 type(Pawtab_type),intent(in) :: Pawtab(Cryst%ntypat)
 type(Paw_an_type),intent(in) :: Paw_an(Cryst%natom)
 type(Pawrad_type),intent(in) :: Pawrad(Cryst%ntypat)
 type(Paw_ij_type),intent(inout) :: Paw_ij(Cryst%natom)
 type(Pawfgrtab_type),intent(inout) :: Pawfgrtab(Cryst%natom)

!Local variables-------------------------------
!scalars
 integer :: iat,idij,cplex,ndij,option_dij
 integer :: itypat,lmn_size,j0lmn,jlmn,ilmn,klmn,klmn1,klm,lmn2_size_max
 integer :: lmin,lmax,mm,isel,lm_size,lmn2_size,im,cplex_dij
 integer :: ils,ilslm,ic,lm0,lpawu,nspinor
 integer :: isp1,isp2,nsploop,ibsp1,ibsp2,is2fft
 real(dp) :: gylm,qijl
 logical :: ltest
 character(len=500) :: msg
!arrays
 integer,pointer :: indklmn_(:,:)
 real(dp) :: rdum(1)
 real(dp),allocatable :: prod_hloc(:,:),prodhxc_core(:,:)
 real(dp),allocatable :: dijhl_hat(:,:),dijhmxc_val(:,:),dijexxc(:,:,:)

! *************************************************************************

 DBG_ENTER("COLL")

 write(msg,'(a)')' assembling PAW strengths for bare Hamiloninan. '
 call wrtout(std_out,msg,'COLL')

 ! === Test if required pointers in paw_ij are associated ===
 ltest=(associated(Paw_ij(1)%dijxc).and.associated(Paw_ij(1)%dijxc_val))
 !£ltest=ltest.and.(Paw_ij(1)%has_dijxc=2.and.paw_ij(1)%has_dijxc_val==2)
 call assert(ltest,'dijxc or dijxc_val not associated',__FILE__,__LINE__)

 ltest=(associated(Paw_ij(1)%dijhat))
 !£ltest=ltest.and.(Paw_ij(1)%has_dijhat==2)
 call assert(ltest,'dijhat not associated',__FILE__,__LINE__)

 ltest=(associated(Paw_ij(1)%dijhartree))
 !£ltest=(ltest.and.Paw_ij(1)%dijhartree==2)
 call assert(ltest,'dijhartree not associated',__FILE__,__LINE__)

 if (ANY(Pawtab(:)%usepawu>0)) then
  ltest=(associated(Paw_ij(1)%dijU))
  !£ltest=ltest.and.Paw_ij(1)%has_dijU==2
  call assert(ltest,'dijU not associated',__FILE__,__LINE__)
 end if

 if (pawspnorb>0) then
  ltest=(associated(Paw_ij(1)%dijso))
  !£ltest=ltest.and.Paw_ij(1)%has_dijso==2
  call assert(ltest,'dijso not associated',__FILE__,__LINE__)
 end if

 ! == Construct the new PAW H0 Hamiltonian ===
 do iat=1,Cryst%natom

  itypat   =Cryst%typat(iat)
  lmn_size =Pawtab(itypat)%lmn_size
  lmn2_size=Pawtab(itypat)%lmn2_size
  lm_size  =Paw_an(iat)%lm_size
  cplex    =Paw_ij(iat)%cplex
  call assert((cplex==1),'cplex/=1 not implemented',__FILE__,__LINE__)
  cplex_dij=Paw_ij(iat)%cplex_dij
  call assert((cplex_dij==1),'cplex_dij/=1 not implemented',__FILE__,__LINE__)
  ndij     =Paw_ij(iat)%ndij
  !
  ! Eventually compute g_l(r).Y_lm(r) factors for the current atom (if not already done)
  if (Pawfgrtab(iat)%gylm_allocated==0) then
   if (associated(Pawfgrtab(iat)%gylm)) deallocate(Pawfgrtab(iat)%gylm)
   allocate(Pawfgrtab(iat)%gylm(Pawfgrtab(iat)%nfgd,lm_size))
   Pawfgrtab(iat)%gylm_allocated=2
   call pawgylm(Pawfgrtab(iat)%gylm,rdum,rdum,iat,Pawfgrtab(iat)%ifftsph,&
&   itypat,lm_size,Pawfgrtab(iat)%nfgd,1,0,0,Pawtab(itypat),&
&   Pawfgrtab(iat)%rfgd,Pawfgrtab(iat)%rfgd_allocated)
  end if

  ! === Calculate LM contribution to dijhmxc_val for this atom ===
  ! * Dijxc contains also the Hat term on the FFT mesh while Dijxc_val does not
  !   contain neither the hat term nor the LM sum of onsite terms (they should cancel each other)
  ! FIXME change paw_dij,  otherwise I miss tnc in vxc
  ! * prodhxc_core is used to assemble $\int g_l Ylm (vtrial - vxc_val[tn+nhat] dr$ on the FFT mesh ===
  ! * The following quantities do not depend on ij
  allocate(prod_hloc (lm_size,ndij))   ; prod_hloc =zero
  allocate(prodhxc_core(lm_size,ndij)) ; prodhxc_core=zero
  do idij=1,ndij
   do ilslm=1,lm_size
    do ic=1,Pawfgrtab(iat)%nfgd
     is2fft=Pawfgrtab(iat)%ifftsph(ic)
     gylm=Pawfgrtab(iat)%gylm(ic,ilslm)
     prod_hloc (ilslm,idij)=prod_hloc (ilslm,idij) + (vtrial(is2fft,idij)-vxc(is2fft,idij))*gylm
     !prodhxc_core(ilslm,idij)=prodhxc_core(ilslm,idij) + (vxc_val(is2fft,idij))*gylm
     prodhxc_core(ilslm,idij)=prodhxc_core(ilslm,idij) + (vtrial(is2fft,idij)-vxc_val(is2fft,idij))*gylm
    end do
   end do
  end do !idij

  ! === Assembly the "Hat" contribution for this atom ====
  allocate(dijhl_hat (cplex_dij*lmn2_size,ndij))  ; dijhl_hat =zero
  allocate(dijhmxc_val(cplex_dij*lmn2_size,ndij)) ; dijhmxc_val=zero
  indklmn_ => Pawtab(itypat)%indklmn(1:6,1:lmn2_size)

  do idij=1,ndij
   do klmn=1,lmn2_size
    klm =indklmn_(1,klmn)
    lmin=indklmn_(3,klmn)
    lmax=indklmn_(4,klmn)

    ! === $\sum_lm q_ij^l prod* for each idij$ ===
    do ils=lmin,lmax,2
     lm0=ils**2+ils+1
     do mm=-ils,ils
      ilslm=lm0+mm
      isel=Pawang%gntselect(lm0+mm,klm)
      if (isel>0) then
       qijl=Pawtab(itypat)%qijl(ilslm,klmn)
       dijhl_hat  (klmn,idij)=dijhl_hat  (klmn,idij)+prod_hloc (ilslm,idij)*qijl
       dijhmxc_val(klmn,idij)=dijhmxc_val(klmn,idij)+prodhxc_core(ilslm,idij)*qijl
      end if
     end do
    end do
   end do
  end do

  deallocate(prod_hloc) 
  deallocate(prodhxc_core) 


  ! * Normalization factor due to integration on the FFT mesh
  dijhl_hat  = dijhl_hat  *Cryst%ucvol/DBLE(nfftf)
  dijhmxc_val= dijhmxc_val*Cryst%ucvol/DBLE(nfftf)

  ! === Now asssembly the bare Hamiltonian ===
  ! * Loop over density components overwriting %dij
  nsploop=nsppol ; if (Paw_ij(iat)%ndij==4) nsploop=4

  do idij=1,nsploop
   klmn1=1
   do jlmn=1,lmn_size
    j0lmn=jlmn*(jlmn-1)/2
    do ilmn=1,jlmn
     klmn=j0lmn+ilmn

     ! The following gives back the input dij.
     ! since dijxc contains the hat term done on the FFT mesh
     if (.FALSE.) then
      Paw_ij(iat)%dij(klmn,idij) =           &
&       Pawtab(itypat)%dij0      (klmn)      &
&         +Paw_ij(iat)%dijhartree(klmn)      &
&         +Paw_ij(iat)%dijxc     (klmn,idij) &
&                   +dijhl_hat   (klmn,idij)

     else
      ! === Make nonlocal part of h0 removing the valence contribution ===
      ! Remeber that XC contains already the Hat contribution
      Paw_ij(iat)%dij(klmn,idij) =           &
&       Pawtab(itypat)%dij0      (klmn)      &
&         +Paw_ij(iat)%dijhartree(klmn)      &
&         +Paw_ij(iat)%dijxc     (klmn,idij) &  ! 2 lines to get the d1-dt1 XC core contribution + XC hat (core+val)
&         -Paw_ij(iat)%dijxc_val (klmn,idij) &  ! I suppose that the "hat" term on the FFT mesh in included in both.
&                     +dijhmxc_val(klmn,idij)   ! Local + Hartree - XC val contribution to the "hat" term.
     end if
     ! Just to be consistent, update some values.
     !£Paw_ij(iat)%dijhat(klmn,idij)=Paw_ij(iat)%dijhat(klmn,idij)-dijhmxc_val(klmn,idij)
     !TODO dijso, dijU, vpawx?
    end do !ilmn
   end do !jlmn
  end do !idij

  !this is to be consistent?
  !deallocate(Paw_ij(iat)%dijvxc_val)
  deallocate(dijhl_hat)
  deallocate(dijhmxc_val)
 end do !iat

 ! === Symmetrize total Dij ===
 option_dij=0
 call symdij(Cryst%gprimd,Psps%indlmn,Cryst%indsym,0,Psps%lmnmax,Cryst%natom,Cryst%nsym,Cryst%ntypat,option_dij,&
&  Paw_ij,Pawang,pawprtvol,Cryst%rprimd,Cryst%symafm,Cryst%symrec,Cryst%typat)

 !do iat=1,Cryst%natom
 ! write(91,*)' After update ',Paw_ij(iat)%dij
 !end do

 DBG_EXIT("COLL")

end subroutine paw_mknewh0
!!***
