!{\src2tex{textfont=tt}}
!!****f* ABINIT/nstdy3
!! NAME
!! nstdy3
!!
!! FUNCTION
!! This routine compute the non-stationary expression for the
!! second derivative of the total energy, for a whole row of
!! mixed derivatives.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2009 ABINIT group (XG, DCA, GMR, MM, AR, MV, MB, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  atindx(natom)=index table for atoms (see scfcv.f)
!!  atindx1(natom)=index table for atoms, inverse of atindx (see scfcv.f)
!!  cg(2,mpw*nspinor*mband*mkmem*nsppol)=planewave coefficients of wavefunctions at k
!!  cgq(2,mpw1*nspinor*mband*mkqmem*nsppol)=pw coefficients of GS wavefunctions at k+q.
!!  cg1(2,mpw1*nspinor*mband*mk1mem*nsppol)=pw coefficients of RF wavefunctions at k,q.
!!  cplex: if 1, real space 1-order functions on FFT grid are REAL, if 2, COMPLEX
!!  cprj(natom,nspinor*mband*mkmem*nsppol*usecprj)= wave functions at k
!!              projected with non-local projectors: cprj=<p_i|Cnk>
!!  cprjq(natom,nspinor*mband*mkqmem*nsppol*usecprj)= wave functions at k+q
!!              projected with non-local projectors: cprjq=<p_i|Cnk+q>
!!  cprj1(natom,nspinor*mband*mk1mem*nsppol*usecprj)= 1st-order wave functions at k,q
!!              projected with non-local projectors: cprj1=<p_i|C1nk,q>
!!  dimcprj(natom*usepaw)=array of dimensions of arrays cprj, cprjq (ordered by atom-type)
!!  doccde_rbz(mband*nkpt_rbz*nsppol)=derivative of occ_rbz wrt the energy
!!  docckqde(mband*nkpt_rbz*nsppol)=derivative of occkq wrt the energy
!!  dtfil <type(datafiles_type)>=variables related to files
!!  dtset <type(dataset_type)>=all input variables for this dataset
!!  ecut=cut-off energy for plane wave basis sphere (Ha)
!!  eigen0(mband*nkpt_rbz*nsppol)=GS eigenvalues at k (hartree)
!!  eigen1(2*mband*mband*nkpt_rbz*nsppol)=array for holding eigenvalues
!!  fform=index for choosing form of wf file
!!  gmet(3,3)=reciprocal space metric tensor in bohr**-2.
!!  gprimd(3,3)=dimensional reciprocal space primitive translations
!!  gsqcut=cutoff on (k+G)^2 (bohr^-2)
!!  idir=direction of the perturbation
!!  indkpt1(nkpt_rbz)=non-symmetrized indices of the k-points
!!  indsy1(4,nsym1,natom)=indirect indexing array for atom labels
!!  ipert=type of the perturbation
!!  istwfk_rbz(nkpt_rbz)=input option parameter that describes the storage of wfs
!!  kg(3,mpw*mkmem)=reduced planewave coordinates.
!!  kg1(3,mpw1*mk1mem)=reduced planewave coordinates at k+q, with RF k points
!!  kpt_rbz(3,nkpt_rbz)=reduced coordinates of k points in the reduced BZ
!!  kxc(nfftf,nkxc)=exchange and correlation kernel
!!  mgfftf=maximum size of 1D FFTs for the "fine" grid (see NOTES in respfn.F90)
!!  mpert =maximum number of ipert
!!  mpi_enreg=informations about MPI parallelization
!!  mpw=maximum dimensioned size of npw or wfs at k
!!  mpw1=maximum dimensioned size of npw for wfs at k+q (also for 1-order wfs).
!!  nattyp(ntypat)= # atoms of each type.
!!  nband_rbz(nkpt_rbz*nsppol)=number of bands at each RF k point for each spin
!!  ncpgr=number of gradients stored in cprj array (cprj=<p_i|Cnk>)
!!  nfftf=(effective) number of FFT grid points (for this proc) for the "fine" grid (see NOTES in respfn.F90)
!!  ngfftf(1:18)=integer array with FFT box dimensions and other for the "fine" grid (see NOTES in respfn.F90)
!!  nhat1(cplex*nfftf,nspden*psps%usepaw)=1st-order compensation charge density (PAW)
!!  nkpt=number of k points in the full BZ
!!  nkpt_rbz=number of k points in the reduced BZ for this perturbation
!!  nkxc=second dimension of the kxc array. If /=0, the XC kernel must be computed.
!!  npwarr(nkpt_rbz)=number of planewaves in basis at this GS k point
!!  npwar1(nkpt_rbz)=number of planewaves in basis at this RF k+q point
!!  nspden=number of spin-density components
!!  nspinor=number of spinorial components of the wavefunctions
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  nsym1=number of symmetry elements in space group consistent with i perturbation
!!  occkq(mband*nkpt_rbz*nsppol)=occupation number for each band (often 2)
!!   at each k+q point of the reduced Brillouin zone.
!!  occ_rbz(mband*nkpt_rbz*nsppol)=occupation number for each band
!!   and k in the reduced Brillouin zone (usually =2)
!!  paw_ij(natom*usepaw) <type(paw_ij_type)>=paw arrays given on (i,j) channels for the GS
!!  paw_ij1(natom) <type(paw_ij_type)>=1st-order paw arrays given on (i,j) channels
!!  pawang <type(pawang_type)>=paw angular mesh and related data
!!  pawfgr <type(pawfgr_type)>=fine grid parameters and related data
!!  pawfgrtab(natom*usepaw) <type(pawfgrtab_type)>=atomic data given on fine rectangular grid for the GS
!!  pawrad(ntypat*usepaw) <type(pawrad_type)>=paw radial mesh and related data
!!  pawtab(ntypat*usepaw) <type(pawtab_type)>=paw tabulated starting data
!!  ph1d(2,3*(2*mgfft+1)*natom)=one-dimensional structure factor information
!!  ph1df(2,3*(2*mgfftf+1)*natom)=one-dimensional structure factor information for the "fine" grid
!!  psps <type(pseudopotential_type)>=variables related to pseudopotentials
!!  rhor1(cplex*nfftf,nspden)=RF electron density in electrons/bohr**3.
!!  rmet(3,3)=real space metric (bohr**2)
!!  rprimd(3,3)=dimensional primitive translations in real space (bohr)
!!  symrc1(3,3,nsym1)=symmetry operations in reciprocal space
!!  ucvol=unit cell volume in bohr**3.
!!  usecprj= 1 if cprj, cprjq, cprj1 arrays are stored in memory
!!  wffnow=struct info for wf disk file
!!  wfftgs,wfftkq=struct info for ground-state wf disk files
!!  wtk_rbz(nkpt_rbz)=weight assigned to each k point in the reduced BZ
!!  xred(3,natom)=reduced dimensionless atomic coordinates
!!  ylm(mpw*mkmem,mpsang*mpsang*useylm)= real spherical harmonics for each G and k point
!!  ylm1(mpw1*mk1mem,mpsang*mpsang*useylm)= real spherical harmonics for each G and k+q point
!!
!! OUTPUT
!!  blkflg(3,mpert,3,mpert)=flags for each element of the 2DTE (=1 if computed)
!!  d2bbb(2,3,3,mpert,mband,mband*prtbbb)=band by band decomposition of some
!!                                        second order derivatives
!!  d2lo(2,3,mpert,3,mpert)=local contributions to the 2DTEs
!!  d2nl(2,3,mpert,3,mpert)=non-local contributions to the 2DTEs
!!                          Not used (should be suppressed, later)
!!  rhog1(2,nfftf)=RF electron density in reciprocal space
!!
!! NOTES
!! Note that the ddk perturbation should not be treated here.
!!
!! PARENTS
!!      scfcv3
!!
!! CHILDREN
!!      appdig,atm2fft3,clsopn,cprj_diskinit_r,dotprod_vn,hdr_skip,leave_new
!!      leave_test,mati3inv,mkcor3,mkvxc3,nstwf3,rdnpw,sygra3,timab,vloca3
!!      wffclose,wffkg,wffopen,wffreadnpwrec,wffreadskipk,wffreadskiprec,wrtout
!!      xcomm_world,xdefineoff,xme_init,xsum_mpi
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine nstdy3(atindx,atindx1,blkflg,cg,cgq,cg1,cplex,cprj,cprjq,cprj1,dimcprj,&
&          doccde_rbz,docckqde,dtfil,dtset,d2bbb,d2lo,d2nl,ecut,eigen0,eigen1,fform,&
&          gmet,gprimd,gsqcut,idir,indkpt1,indsy1,ipert,istwfk_rbz,kg,kg1,kpt_rbz,kxc,&
&          mgfftf,mpert,mpi_enreg,mpw,mpw1,nattyp,nband_rbz,ncpgr,nfftf,ngfftf,&
&          nhat1,nkpt,nkpt_rbz,nkxc,npwarr,npwar1,nspden,nspinor,nsppol,nsym1,occkq,&
&          occ_rbz,paw_ij,paw_ij1,pawang,pawfgr,pawfgrtab,pawtab,ph1d,ph1df,psps,&
&          rhog1,rhor1,rmet,rprimd,symrc1,ucvol,wffnow,wfftgs,wfftkq,&
&          usecprj,wtk_rbz,xred,ylm,ylm1)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_12_hide_mpi
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_18_timing
 use interfaces_32_util
 use interfaces_51_manage_mpi
 use interfaces_53_spacepar
 use interfaces_56_xc
 use interfaces_59_io_mpi
 use interfaces_62_iowfdenpot
 use interfaces_65_nonlocal
 use interfaces_72_response, except_this_one => nstdy3
!End of the abilint section

 implicit none

!Arguments -------------------------------
!scalars
 integer,intent(in) :: cplex,fform,idir,ipert,mgfftf,mpert,mpw,mpw1,ncpgr,nfftf
 integer,intent(in) :: nkpt,nkpt_rbz,nkxc,nspden,nsppol,nsym1,usecprj
 integer,intent(inout) :: nspinor
 real(dp),intent(in) :: ecut,gsqcut,ucvol
 type(MPI_type),intent(inout) :: mpi_enreg
 type(datafiles_type),intent(in) :: dtfil
 type(dataset_type),intent(in) :: dtset
 type(pawang_type),intent(in) :: pawang
 type(pawfgr_type),intent(in) :: pawfgr
 type(pseudopotential_type),intent(in) :: psps
 type(wffile_type),intent(inout) :: wffnow,wfftgs,wfftkq
!arrays
 integer,intent(in) :: atindx(dtset%natom),atindx1(dtset%natom)
 integer,intent(in) :: dimcprj(dtset%natom*psps%usepaw),indkpt1(nkpt_rbz)
 integer,intent(in) :: indsy1(4,nsym1,dtset%natom),istwfk_rbz(nkpt_rbz)
 integer,intent(in) :: kg(3,mpw*dtset%mkmem),kg1(3,mpw1*dtset%mkqmem)
 integer,intent(in) :: nattyp(dtset%ntypat),nband_rbz(nkpt_rbz*nsppol)
 integer,intent(in) :: ngfftf(18),npwar1(nkpt_rbz),npwarr(nkpt_rbz)
 integer,intent(in) :: symrc1(3,3,nsym1)
 integer,intent(out) :: blkflg(3,mpert,3,mpert)
 real(dp),intent(in) :: cg(2,mpw*nspinor*dtset%mband*dtset%mkmem*nsppol)
 real(dp),intent(in) :: cg1(2,mpw1*nspinor*dtset%mband*dtset%mkqmem*nsppol)
 real(dp),intent(in) :: cgq(2,mpw1*nspinor*dtset%mband*dtset%mkqmem*nsppol)
 real(dp),intent(in) :: doccde_rbz(dtset%mband*nkpt_rbz*nsppol)
 real(dp),intent(in) :: docckqde(dtset%mband*nkpt_rbz*nsppol)
 real(dp),intent(in) :: eigen0(dtset%mband*nkpt_rbz*nsppol)
 real(dp),intent(in) :: eigen1(2*dtset%mband*dtset%mband*nkpt_rbz*nsppol)
 real(dp),intent(in) :: gmet(3,3),gprimd(3,3),kpt_rbz(3,nkpt_rbz)
 real(dp),intent(in) :: kxc(nfftf,nkxc),nhat1(cplex*nfftf,nspden*psps%usepaw)
 real(dp),intent(in) :: occ_rbz(dtset%mband*nkpt_rbz*nsppol)
 real(dp),intent(in) :: occkq(dtset%mband*nkpt_rbz*nsppol)
 real(dp),intent(in) :: ph1d(2,3*(2*dtset%mgfft+1)*dtset%natom)
 real(dp),intent(in) :: ph1df(2,3*(2*mgfftf+1)*dtset%natom),rhog1(2,nfftf)
 real(dp),intent(in) :: rhor1(cplex*nfftf,nspden),rmet(3,3),rprimd(3,3)
 real(dp),intent(in) :: wtk_rbz(nkpt_rbz),xred(3,dtset%natom)
 real(dp),intent(in) :: ylm(mpw*dtset%mkmem,psps%mpsang*psps%mpsang*psps%useylm)
 real(dp),intent(in) :: ylm1(mpw1*dtset%mkqmem,psps%mpsang*psps%mpsang*psps%useylm)
 real(dp),intent(out) :: d2bbb(2,3,3,mpert,dtset%mband,dtset%mband*dtset%prtbbb)
 real(dp),intent(out) :: d2lo(2,3,mpert,3,mpert),d2nl(2,3,mpert,3,mpert)
 type(cprj_type),intent(in) :: cprj(dtset%natom,nspinor*dtset%mband*dtset%mkmem*nsppol*usecprj)
 type(cprj_type),intent(in) :: cprjq(dtset%natom,nspinor*dtset%mband*dtset%mkqmem*nsppol*usecprj)
 type(cprj_type),intent(inout) :: cprj1(dtset%natom,nspinor*dtset%mband*dtset%mkqmem*nsppol*usecprj)
 type(paw_ij_type),intent(in) :: paw_ij(dtset%natom*psps%usepaw)
 type(paw_ij_type),intent(in) :: paw_ij1(dtset%natom*psps%usepaw)
 type(pawfgrtab_type),intent(inout) :: pawfgrtab(dtset%natom*psps%usepaw)
 type(pawtab_type),intent(in) :: pawtab(dtset%ntypat*psps%usepaw)

!Local variables-------------------------------
!scalars
 integer :: ban2tot,bantot,bd2tot_index,bdtot_index,ddkcase,dimdij,enunit
 integer :: formeig,ia,iatom,iband,iband1,ibg,ibg1,ibgq,icg,icg1,icgq,idir1
 integer :: ierr,iexit,ifft,ii,ikg,ikg1,ikpt,ikpt_dum,ilm,ilmn,iorder_cprj
 integer :: iorder_cprj1,ipert1,iproc,ipw,ir,isp,ispden,isppol,istwf_k,isym
 integer :: itypat,jj,master,mbd2kpsp,mbdkpsp,mcgnpw,mcgnpw1,me,muig,n1,n2,n3
 integer :: n3xccc,n4,n5,n6,nband_dum,nband_k,nfftot,npw1_k,npw_k,nskip
 integer :: nspinor_,option,optn,optn2,optv,spaceworld,t_iostat,tag
 real(dp) :: arg,di_psp1,di_xc1,doti,dotr,dr_psp1,dr_xc1,dum,wtk_k
 logical :: logi,t_exist
 character(len=500) :: message
 character(len=fnlen) :: fil,fiwfddk
 type(gs_hamiltonian_type) :: gs_hamkq
!arrays
 integer :: ddkfil(3),ikpt_fbz(3),ikpt_fbz_previous(3),skipddk(3)
 integer,allocatable :: kg1_k(:,:),kg_dum(:,:),kg_k(:,:),symrl1(:,:,:)
 real(dp) :: d2nl_elfd(2,3),dummy(1),kpoint(3),sumelfd(2),tsec(2)
 real(dp),allocatable :: buffer1(:),buffer2(:),cg_dum(:,:),d2bbb_k(:,:,:,:)
 real(dp),allocatable :: d2nl_k(:,:,:),eig1_k(:),eig_k(:),eigen(:),eigen_dum(:)
 real(dp),allocatable :: occ_dum(:),occ_k(:),rhodummy(:,:),vpsp1(:),vxc1(:,:)
 real(dp),allocatable :: work1(:,:,:),xccc3d1(:),ylm1_k(:,:),ylm_k(:,:)
 type(wffile_type) :: wffddk(3)
!no_abirules
#if defined T3E
           integer,save :: file_exist(3)
           logical,save :: first=.true.
           character(len=fnlen),save :: wfnameddk_old
#endif

! *********************************************************************

!DEBUG
!write(6,*)' nstdy3 : enter, debug '
!stop
!write(6,*)' nstdy3 : cg1(:,1)=',cg1(:,1)
!write(6,*)' xred=',xred
!ENDDEBUG

!Keep track of total time spent in nstdy3
 call timab(101,1,tsec)

!Test size of FFT grids (1 grid in norm-conserving, 2 grids in PAW)
 if ((psps%usepaw==1.and.pawfgr%nfft/=nfftf).or.(psps%usepaw==0.and.dtset%nfft/=nfftf)) then
  write(message, '(a,a,a,a)' ) ch10,&
&  ' nstdy3 :  BUG -',ch10,&
&  '  wrong values for nfft, nfftf !'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

!Init spaceworld
!BEGIN TF_CHANGES
 call xcomm_world(mpi_enreg,spaceworld)
!END TF_CHANGES
 master =0
!Define me
 call xme_init(mpi_enreg,me)

 bdtot_index=0
 bd2tot_index=0
 ibg=0;icg=0
 ibgq=0;icgq=0
 ibg1=0;icg1=0
 mbdkpsp=dtset%mband*nkpt_rbz*nsppol
 mbd2kpsp=2*dtset%mband**2*nkpt_rbz*nsppol

!Zero only portion of nonlocal matrix to be computed here
 d2nl(:,:,1:dtset%natom+2,idir,ipert)=zero

 allocate(d2bbb_k(2,3,dtset%mband,dtset%mband*dtset%prtbbb))
 allocate(d2nl_k(2,3,mpert))

 allocate(eig_k(nsppol*dtset%mband))
 allocate(eig1_k(2*nsppol*dtset%mband**2))
 allocate(kg_k(3,mpw))
 allocate(kg1_k(3,mpw1))

!Do not try to open electric field file
 ddkfil(:)=0
!The treatment of homogeneous electric field potential need
!the existence of d/dk files.
 do idir1=1,3
  ddkcase=idir1+dtset%natom*3
  call appdig(ddkcase,dtfil%fnamewffddk,fiwfddk)
! DEBUG
! write(6,*)' nstdy3 : examine existence of ddkfile',fiwfddk
! ENDDEBUG
! Check that ddk file exists
#if defined T3E
  if (first) then
!  case first time : test file to do
#endif
   inquire(file=fiwfddk,iostat=t_iostat,exist=t_exist)
   if (t_iostat.ne.0) then
    write(message, '(8a,i8)' )ch10,&
&    ' nstdy3 : BUG -',ch10,&
&    '  Check for existence of file ',trim(fiwfddk),',',ch10,&
&    '  but INQUIRE statement returns error code',t_iostat
    call wrtout(6,message,'COLL')
    call leave_new('COLL')
#if defined T3E
   end if
   if (t_exist) then
    file_exist(idir1)=1
   else
    file_exist(idir1)=0
   end if
   if (idir1 == 3) then
    first=.false.
    wfnameddk_old = dtfil%fnamewffddk
   end if
  else
   if (wfnameddk_old /= dtfil%fnamewffddk) then
!   ddkfile changes
    inquire(file=fiwfddk,iostat=t_iostat,exist=t_exist)
    if (t_iostat.ne.0) then
     write(message, '(8a,i8)' )ch10,&
&     ' nstdy3 : BUG -',ch10,&
&     '  Check for existence of file ',trim(fiwfddk),',',ch10,&
&     '  but INQUIRE statement returns error code',t_iostat
     call wrtout(6,message,'COLL')
     call leave_new('COLL')
    end if
    if (t_exist) then
     file_exist(idir1)=1
    else
     file_exist(idir1)=0
    end if
    if (idir1 == 3) wfnameddk_old = dtfil%fnamewffddk
   end if
  end if
! If the file exists, open it (even if it is not needed ...)
  if (file_exist(idir1)==1) then
#else
  else if (t_exist) then
#endif
!  Note the use of unit numbers 21, 22 and 23
   ddkfil(idir1)=20+idir1
   write(message, '(a,a)') '-open ddk wf file :',fiwfddk
   call wrtout(6,message,'COLL')
   call wrtout(ab_out,message,'COLL')
   call WffOpen(dtset%accesswff,spaceworld,fiwfddk,ierr,wffddk(idir1),master,me,ddkfil(idir1))
  end if
 end do

!DEBUG
!write(6,*)' nstdy3 : stop now '
!stop
!ENDDEBUG

!Update list of computed matrix elements
 if (ipert /= dtset%natom + 1) then
  do ipert1=1,mpert
   do idir1=1,3
    if(ipert1 <= dtset%natom .or.  &
&    (ipert1==dtset%natom+2 .and. ddkfil(idir1)/=0) )then
     blkflg(idir1,ipert1,idir,ipert)=1
    end if
   end do
  end do
 else
  ipert1 = dtset%natom + 1
  do idir1=1,3
   if ((ddkfil(idir1) /= 0).or.(idir1 == idir)) then
    blkflg(idir1,ipert1,idir,ipert)=1
   end if
  end do
 end if

 n1=dtset%ngfft(1) ; n2=dtset%ngfft(2) ; n3=dtset%ngfft(3)
 n4=dtset%ngfft(4) ; n5=dtset%ngfft(5) ; n6=dtset%ngfft(6)

!Prepare GS k wf file for reading if mkmem==0
 if (dtset%mkmem==0) then
  call clsopn(wfftgs)
  call hdr_skip(wfftgs,ierr)
! Define offsets, in case of MPI I/O
  formeig=0
  call WffKg(wfftgs,1)
  call xdefineOff(formeig,wfftgs,mpi_enreg,nband_rbz,npwarr,nspinor,nsppol,nkpt_rbz)
 end if

!PAW ONLY: Prepare GS k+q wf file for reading if mkqmem==0
 if (psps%usepaw==1.and.dtset%mkqmem==0) then
  call clsopn(wfftkq)
  call hdr_skip(wfftkq,ierr)
! Define offsets, in case of MPI I/O
  formeig=0
  call WffKg(wfftkq,1)
  call xdefineOff(formeig,wfftkq,mpi_enreg,nband_rbz,npwar1,nspinor,nsppol,nkpt_rbz)
 end if

!Prepare RF wf files for reading and writing if mk1mem==0
 if (dtset%mkqmem==0) then
  call clsopn(wffnow)
  call hdr_skip(wffnow,ierr)
! Define offsets, in case of MPI I/O
  formeig=1
  call WffKg(wffnow,1)
  call xdefineOff(formeig,wffnow,mpi_enreg,nband_rbz,npwar1,nspinor,nsppol,nkpt_rbz)
 end if

!Prepare RF PAW files for reading and writing if mkmem, mkqmem or mk1mem==0
 if (psps%usepaw==1) then
  iorder_cprj=0;iorder_cprj1=0
  call cprj_diskinit_r(atindx1,dtset%natom,iorder_cprj ,dtset%mkmem ,dtset%natom,ncpgr,dimcprj,nspinor,dtfil%unpaw)
  call cprj_diskinit_r(atindx1,dtset%natom,iorder_cprj ,dtset%mkqmem,dtset%natom,0,    dimcprj,nspinor,dtfil%unpawq)
  call cprj_diskinit_r(atindx1,dtset%natom,iorder_cprj1,dtset%mkqmem,dtset%natom,0    ,dimcprj,nspinor,dtfil%unpaw1)
 end if

!Initialisation of the ddk files
 do idir1=1,3
  if (ddkfil(idir1)/=0)then
   call hdr_skip(wffddk(idir1),ierr)
  end if
 end do

 bantot = 0
 ban2tot = 0
 skipddk(:) = 0

!Allocate the arrays of the Hamiltonian whose dimensions do not depend on k
 allocate(gs_hamkq%atindx(dtset%natom),gs_hamkq%atindx1(dtset%natom),gs_hamkq%typat(dtset%natom))
 allocate(gs_hamkq%gbound(2*dtset%mgfft+8,2))
 allocate(gs_hamkq%indlmn(6,psps%lmnmax,dtset%ntypat))
 allocate(gs_hamkq%nattyp(dtset%ntypat))
 allocate(gs_hamkq%phkxred(2,dtset%natom))
 allocate(gs_hamkq%ph1d(2,3*(2*dtset%mgfft+1)*dtset%natom))
 allocate(gs_hamkq%pspso(dtset%ntypat))
 allocate(gs_hamkq%xred(3,dtset%natom))

!Initialize most components of the Ground-state Hamiltonian ar k+q
 gs_hamkq%atindx(:)  =atindx(:)
 gs_hamkq%atindx1(:) =atindx1(:)
 gs_hamkq%gmet(:,:)  =gmet(:,:)
 gs_hamkq%gprimd(:,:)=gprimd(:,:)
 gs_hamkq%indlmn(:,:,:)=psps%indlmn(:,:,:)
 gs_hamkq%lmnmax     =psps%lmnmax
 gs_hamkq%mgfft      =dtset%mgfft
 gs_hamkq%mpsang     =psps%mpsang
 gs_hamkq%mpssoang   =psps%mpssoang
 gs_hamkq%natom      =dtset%natom
 gs_hamkq%nattyp(:)  =nattyp(:)
 gs_hamkq%nfft       =dtset%nfft
 gs_hamkq%ngfft(:)   =dtset%ngfft(:)
 gs_hamkq%nloalg(:)  =dtset%nloalg(:)
 gs_hamkq%nspinor    =nspinor
 gs_hamkq%ntypat     =dtset%ntypat
 gs_hamkq%nvloc      =1
 gs_hamkq%n4         =n4
 gs_hamkq%n5         =n5
 gs_hamkq%n6         =n6
 gs_hamkq%usepaw     =psps%usepaw
 gs_hamkq%ph1d(:,:)  =ph1d(:,:)
 gs_hamkq%pspso(:)   =psps%pspso(1:dtset%ntypat)
 gs_hamkq%typat(:)   =dtset%typat(1:dtset%natom)
 gs_hamkq%ucvol      =ucvol
 gs_hamkq%useylm     =psps%useylm
 gs_hamkq%xred(:,:)  =xred(:,:)

!Non-local factors:
!Norm-conserving: kleimann-Bylander energies
!PAW: Dij coefficients and overlap coefficients
 if (psps%usepaw==0) then
  gs_hamkq%dimekb1=psps%dimekb
  gs_hamkq%dimekb2=dtset%ntypat
  allocate(gs_hamkq%ekb(gs_hamkq%dimekb1,gs_hamkq%dimekb2,nspinor**2))
  allocate(gs_hamkq%sij(0,0))
  gs_hamkq%ekb(:,:,1)=psps%ekb(:,:)
  if (nspinor==2) then
   gs_hamkq%ekb(:,:,2)=psps%ekb(:,:)
   gs_hamkq%ekb(:,:,3:4)=zero
  end if
 else
  gs_hamkq%dimekb1=psps%dimekb*paw_ij(1)%cplex_dij
  gs_hamkq%dimekb2=dtset%natom
  allocate(gs_hamkq%ekb(gs_hamkq%dimekb1,gs_hamkq%dimekb2,nspinor**2))
  allocate(gs_hamkq%sij(gs_hamkq%dimekb1,dtset%ntypat))
  do itypat=1,dtset%ntypat
   if (paw_ij(1)%cplex_dij==1) then
    gs_hamkq%sij(1:pawtab(itypat)%lmn2_size,itypat)=pawtab(itypat)%sij(:)
   else
    do ilmn=1,pawtab(itypat)%lmn2_size
     gs_hamkq%sij(2*ilmn-1,itypat)=pawtab(itypat)%sij(ilmn)
     gs_hamkq%sij(2*ilmn  ,itypat)=zero
    end do
   end if
  end do
 end if

!LOOP OVER SPINS
 do isppol=1,nsppol

  if (nsppol/=1) then
   write(message,*)' ****  In nstdy3 for isppol=',isppol
   call wrtout(06,message,'COLL')
  end if

! In case isppol = 2, skip the records that correspond to isppol = 1
! and that have not been read
  if (isppol == 2) then
   do idir1 = 1, 3
    if ((ddkfil(idir1)/=0).and.(skipddk(idir1) < nkpt)) then
     do ikpt = 1, (nkpt - skipddk(idir1))
      call WffReadNpwRec(ierr,ikpt,isppol,nband_k,npw_k,nspinor_,wffddk(idir1))
      call WffReadSkipRec(ierr,1,wffddk(idir1))
      do iband = 1, nband_k
       call WffReadSkipRec(ierr,2,wffddk(idir1))
      end do
     end do
    end if
   end do
  end if

! Rewind kpgsph data file if needed:
  if (dtset%mkmem==0) rewind(dtfil%unkg)
  if (dtset%mkqmem==0) rewind(dtfil%unkg1)
  if (dtset%mkmem==0.and.psps%useylm==1) rewind(dtfil%unylm)
  if (dtset%mkqmem==0.and.psps%useylm==1) rewind(dtfil%unylm1)
  ikg=0;ikg1=0

  ikpt_fbz(1:3)=0

! PAW: retrieve Dij coefficients for this spin component
  if (psps%usepaw==1) then
   do ispden=1,nspinor**2
    isp=isppol;if (nspinor==2) isp=ispden
    do iatom=1,dtset%natom
     dimdij=paw_ij(iatom)%cplex*paw_ij(iatom)%lmn2_size
     do ilmn=1,dimdij
      gs_hamkq%ekb(ilmn,iatom,ispden)=paw_ij(iatom)%dij(ilmn,isp)
     end do
     if(dimdij+1<=gs_hamkq%dimekb1) gs_hamkq%ekb(dimdij+1:gs_hamkq%dimekb1,iatom,ispden)=zero
    end do
   end do
  end if

! BIG FAT k POINT LOOP
  do ikpt=1,nkpt_rbz

   nband_k=nband_rbz(ikpt+(isppol-1)*nkpt_rbz)
   istwf_k=istwfk_rbz(ikpt)
   npw_k=npwarr(ikpt)
   npw1_k=npwar1(ikpt)

   eig_k(1:nband_k) = eigen0(1+bantot:nband_k+bantot)
   eig1_k(1:2*nband_k**2) = eigen1(1+ban2tot:2*nband_k**2+ban2tot)
   bantot = bantot + nband_k
   ban2tot = ban2tot + 2*nband_k**2

   if(mpi_enreg%paral_compil_kpt==1)then
    if(minval(abs(mpi_enreg%proc_distrb(ikpt,1:nband_k,isppol)-me))/=0) then
     bdtot_index=bdtot_index+nband_k
     bd2tot_index=bd2tot_index+2*nband_k**2
!    The wavefunction blocks for ddk file is skipped elsewhere in the loop
!    Skip the rest of the k-point loop
     cycle
    end if
   end if

   allocate(ylm_k(npw_k,psps%mpsang*psps%mpsang*psps%useylm))
   allocate(ylm1_k(npw1_k,psps%mpsang*psps%mpsang*psps%useylm))

!  In case of electric field pert1, read ddk wfs file
!  Note that the symmetries are not used for ddk, so read each k point
!  Also take into account implicitely the parallelism over k points
   do idir1=1,3
    if (ddkfil(idir1)/=0) then
!    Must select the corresponding k point in the full set of k points
!    used in the ddk file : compute the number of k points to skip
     ikpt_fbz_previous(idir1)=ikpt_fbz(idir1)
     ikpt_fbz(idir1)=indkpt1(ikpt)
     nskip=ikpt_fbz(idir1)-ikpt_fbz_previous(idir1)-1
     skipddk(idir1) = skipddk(idir1) + 1 + nskip
     if(nskip/=0)then
      allocate(cg_dum(2,1),eigen_dum(0),kg_dum(3,0),occ_dum(0))
      do ikpt_dum=1+ikpt_fbz_previous(idir1),ikpt_fbz(idir1)-1
       nband_dum=dtset%nband(ikpt_dum+(isppol-1)*nkpt)
!      Skip the records whose information is not needed (in case of parallelism)
       call WffReadSkipK(1,0,ikpt_dum,isppol,mpi_enreg,wffddk(idir1))
      end do
      deallocate(cg_dum,eigen_dum,kg_dum,occ_dum)
     end if
    end if
   end do

   allocate(occ_k(nband_k))

   d2nl_k(:,:,:)=zero
   if(dtset%prtbbb==1)d2bbb_k(:,:,:,:)=zero
   kpoint(:)=kpt_rbz(:,ikpt)
   occ_k(:)=occ_rbz(1+bdtot_index:nband_k+bdtot_index)
   wtk_k=wtk_rbz(ikpt)

!  Continue to initialize the Hamiltonian at k+q
   gs_hamkq%istwf_k=istwf_k
   gs_hamkq%npw    =npw1_k
   gs_hamkq%kpoint(:)=kpoint(:)
   if (ipert<dtset%natom+3) gs_hamkq%kpoint(:)=gs_hamkq%kpoint(:)+dtset%qptn(:)
   do ia=1,dtset%natom
    iatom=atindx(ia)
    arg=two_pi*(gs_hamkq%kpoint(1)*xred(1,ia)+gs_hamkq%kpoint(2)*xred(2,ia)&
&    +gs_hamkq%kpoint(3)*xred(3,ia))
    gs_hamkq%phkxred(1,iatom)=cos(arg)
    gs_hamkq%phkxred(2,iatom)=sin(arg)
   end do

!  Read plane-wave vectors and related data at k
   if (dtset%mkmem==0) then
!   Read (k+G) basis sphere data (same for each spin)
    call rdnpw(ikpt,isppol,nband_k,npw_k,nspinor,0,dtfil%unkg)
!   Read k+g data
    read (dtfil%unkg) ((kg_k(ii,muig),ii=1,3),muig=1,npw_k)
!   Eventually read (k+G) spherical harmonics
    if (psps%useylm==1) then
     read(dtfil%unylm)
     read(dtfil%unylm) ((ylm_k(muig,ilm),muig=1,npw_k),ilm=1,psps%mpsang*psps%mpsang)
    end if
   else
    kg_k(:,1:npw_k)=kg(:,1+ikg:npw_k+ikg)
    if (psps%useylm==1) then
     do ilm=1,psps%mpsang*psps%mpsang
      ylm_k(1:npw_k,ilm)=ylm(1+ikg:npw_k+ikg,ilm)
     end do
    end if
   end if ! End if for choice governed by mkmem

!  Read plane-wave vectors and related data at k+q
   if (dtset%mkqmem==0) then
!   Read (k+q+G) basis sphere data (same for each spin)
    call rdnpw(ikpt,isppol,nband_k,npw1_k,nspinor,0,dtfil%unkg1)
!   Read k+g data
    read (dtfil%unkg1) ((kg1_k(ii,muig),ii=1,3),muig=1,npw1_k)
!   Eventually read (k+q+G) spherical harmonics
    if (psps%useylm==1) then
     read(dtfil%unylm1)
     read(dtfil%unylm1) ((ylm1_k(muig,ilm),muig=1,npw1_k),ilm=1,psps%mpsang*psps%mpsang)
    end if
   else
    kg1_k(:,1:npw1_k)=kg1(:,1+ikg1:npw1_k+ikg1)
    if (psps%useylm==1) then
     do ilm=1,psps%mpsang*psps%mpsang
      ylm1_k(1:npw1_k,ilm)=ylm(1+ikg1:npw1_k+ikg1,ilm)
     end do
    end if
   end if ! End if for choice governed by mk1mem

!  Compute the eigenvalues, wavefunction,
!  contributions to kinetic energy, nonlocal energy, forces,
!  and update of rhor1 to this k-point and this spin polarization.
!  Note that nstwf3 is called with kpoint, while kpt is used inside vtowfk3
   call nstwf3(cg,cgq,cg1,cprj,cprjq,ddkfil,dimcprj,dtfil,d2bbb_k,d2nl_k,ecut,dtset%ecutsm,&
&   eig_k,eig1_k,gs_hamkq,ibg,ibgq,icg,icgq,icg1,idir,ikpt,ipert,&
&   isppol,istwf_k,kg_k,kg1_k,kpoint,dtset%mband,dtset%mgfft,dtset%mkmem,dtset%mkqmem,dtset%mkqmem,mpert,&
&   mpi_enreg,psps%mpsang,mpw,mpw1,dtset%natom,nband_k,nband_rbz,ncpgr,dtset%nfft,nkpt_rbz,&
&   npw_k,npw1_k,nspinor,nsppol,dtset%occopt,occ_k,dtset%paral_kgb,paw_ij,paw_ij1,dtset%prtbbb,&
&   dtset%prtvol,psps,rmet,usecprj,wffddk,wffnow,wfftgs,wfftkq,wtk_k,ylm_k,ylm1_k)

   d2nl(:,:,:,idir,ipert)=d2nl(:,:,:,idir,ipert)+d2nl_k(:,:,:)
   if(dtset%prtbbb==1)then
    d2bbb(:,:,idir,ipert,:,:) = d2bbb(:,:,idir,ipert,:,:) + d2bbb_k(:,:,:,:)
   end if

!  DEBUG
!  if (ipert < dtset%natom + 1) then
!  write(99,*)'d2nl', d2nl(1,1,dtset%natom+2,1,ipert)
!  dotr = zero
!  do iband = 1,dtset%mband
!  write(99,*)'bbb', d2bbb(1,1,1,ipert,iband,iband)
!  dotr = dotr +  d2bbb(1,1,1,ipert,iband,iband)
!  end do
!  write(99,*)'------------------'
!  write(99,*)dotr
!  write(99,*)''
!  end if
!  ENDDEBUG

!  Keep track of total number of bands (all k points so far, even for
!  k points not treated by me)
   bdtot_index=bdtot_index+nband_k
   bd2tot_index=bd2tot_index+2*nband_k**2

!  Shift array memory
   if (dtset%mkmem/=0) then
    ibg=ibg+nband_k
    icg=icg+npw_k*nspinor*nband_k
    ikg=ikg+npw_k
   end if
   if (dtset%mkqmem/=0) then
    ibgq=ibgq+nband_k
    icgq=icgq+npw1_k*nspinor*nband_k
   end if
   if (dtset%mkqmem/=0) then
    ibg1=ibg1+nband_k
    icg1=icg1+npw1_k*nspinor*nband_k
    ikg1=ikg1+npw1_k
   end if

   deallocate(occ_k)
   deallocate(ylm_k,ylm1_k)

!  End big k point loop
  end do

! End loop over spins
 end do

 if(mpi_enreg%paral_compil_kpt==1)then
  call timab(161,1,tsec)
  call leave_test(mpi_enreg)
  write(message,*) ' nstdy3: loop on k-points and spins done in parallel'
  call wrtout(06,message,'COLL')
  call timab(161,2,tsec)
 end if

 deallocate(gs_hamkq%atindx,gs_hamkq%atindx1,gs_hamkq%typat)
 deallocate(gs_hamkq%ekb,gs_hamkq%sij)
 deallocate(gs_hamkq%gbound)
 deallocate(gs_hamkq%indlmn)
 deallocate(gs_hamkq%nattyp)
 deallocate(gs_hamkq%phkxred)
 deallocate(gs_hamkq%pspso)
 deallocate(gs_hamkq%ph1d)
 deallocate(gs_hamkq%xred)

!Treat fixed occupation numbers (as in vtorho)
 if(mpi_enreg%paral_compil_kpt==1)then

  allocate(buffer1(2*3*mpert),buffer2(2*3*mpert))
! Pack d2nl
  buffer1(1:2*3*mpert)=reshape(d2nl(:,:,:,idir,ipert),(/2*3*mpert/))
! Build sum of everything
  call timab(48,1,tsec)
  call xsum_mpi(buffer1,buffer2,2*3*mpert,spaceworld,ierr)
  call timab(48,2,tsec)
! Unpack the final result
  d2nl(:,:,:,idir,ipert)=reshape(buffer2(:),(/2,3,mpert/))
  deallocate(buffer1,buffer2)

  if(dtset%prtbbb==1)then
   allocate(buffer1(2*3*dtset%mband*dtset%mband),buffer2(2*3*dtset%mband*dtset%mband))
!  Pack d2bbb
   buffer1(1:2*3*dtset%mband*dtset%mband)=reshape(d2bbb(:,:,idir,ipert,:,:),(/2*3*dtset%mband*dtset%mband/))
!  Build sum of everything
   call timab(48,1,tsec)
   call xsum_mpi(buffer1,buffer2,2*3*dtset%mband*dtset%mband,spaceworld,ierr)
   call timab(48,2,tsec)
!  Unpack the final result
   d2bbb(:,:,idir,ipert,:,:)=reshape(buffer2(:),(/2,3,dtset%mband,dtset%mband/))
   deallocate(buffer1,buffer2)
  end if

 end if ! mpi_enreg%paral_compil_kpt==1

!In the case of the strain perturbation time-reversal symmetry will always
!be true so imaginary part of d2nl will be must be set to zero here since
!the symmetry-reduced kpt set will leave a non-zero imaginary part.
 if(ipert==dtset%natom+3 .or. ipert==dtset%natom+4) d2nl(2,:,:,idir,ipert)=zero

!In case of electric field ipert1, close the ddk wf files
 do idir1=1,3
  if (ddkfil(idir1)/=0)then
   call WffClose(wffddk(idir1),ierr)
  end if
 end do

!Symmetrize the non-local contributions,
!as was needed for the forces in a ground-state calculation
!However, here the quantity is complex, and there are phases !

!DEBUG
!write(6,*)' nstdy3 : total d2nl before sygra3 '
!do ipert1=1,dtset%natom
!do idir1=1,3
!write(6,*)ipert1,idir1,d2nl(1,idir1,ipert1,idir,ipert),&
!&                         d2nl(2,idir1,ipert1,idir,ipert)
!end do
!end do
!write(6,*)' nstdy3 : before sygra3, nsym1 =',nsym1
!do isym=1,nsym1
!write(6,*)' isym, symrc1, indsy1(4,isym,1:dtset%natom) '
!write(6,*)isym
!write(6,*)symrc1(1:3,1,isym)
!write(6,*)symrc1(1:3,2,isym)
!write(6,*)symrc1(1:3,3,isym)
!write(6,*)indsy1(4,isym,:)
!enddo
!ENDDEBUG

!Do the transform
 allocate(work1(2,3,dtset%natom))
 do ipert1=1,dtset%natom
  do idir1=1,3
   work1(1,idir1,ipert1)=d2nl(1,idir1,ipert1,idir,ipert)
   work1(2,idir1,ipert1)=d2nl(2,idir1,ipert1,idir,ipert)
  end do
 end do
 call sygra3(dtset%natom,d2nl(:,:,:,idir,ipert),work1,indsy1,nsym1,dtset%qptn,symrc1)
 deallocate(work1)

!DEBUG
!write(6,*)' nstdy3 : total d2nl after sygra3 '
!do ipert1=1,dtset%natom+2
!do idir1=1,3
!write(6,*)ipert1,idir1,d2nl(1,idir1,ipert1,idir,ipert),&
!&                         d2nl(2,idir1,ipert1,idir,ipert)
!end do
!end do
!write(6,*)
!stop
!ENDDEBUG

 if(sum(ddkfil(:))/=0)then
! Must also symmetrize the electric field perturbation response !
! (XG 000803 This was not implemented until now)
! Get the symmetry matrices in terms of real space basis
  allocate(symrl1(3,3,nsym1))
  do isym=1,nsym1
   call mati3inv(symrc1(:,:,isym),symrl1(:,:,isym))
  end do
! There should not be any imaginary part, but stay general (for debugging)
  d2nl_elfd(:,:)=d2nl(:,:,dtset%natom+2,idir,ipert)
  do ii=1,3
   sumelfd(:)=zero
   do isym=1,nsym1
    do jj=1,3
     if(symrl1(ii,jj,isym)/=0)then
      if(ddkfil(jj)==0)then
       blkflg(ii,dtset%natom+2,idir,ipert)=0
      end if
     end if
    end do
    sumelfd(:)=sumelfd(:)+dble(symrl1(ii,1,isym))*d2nl_elfd(:,1)+&
&    dble(symrl1(ii,2,isym))*d2nl_elfd(:,2)+&
&    dble(symrl1(ii,3,isym))*d2nl_elfd(:,3)
   end do
   d2nl(:,ii,dtset%natom+2,idir,ipert)=sumelfd(:)/dble(nsym1)
  end do

  if ((dtset%prtbbb==1).and.(ipert<=dtset%natom)) then
   do iband = 1,dtset%mband
    d2nl_elfd(:,:)=d2bbb(:,:,idir,ipert,iband,iband)
    do ii=1,3
     sumelfd(:)=zero
     do isym=1,nsym1
!     do jj=1,3
!     if(symrl1(ii,jj,isym)/=0)then
!     if(ddkfil(jj)==0)then
!     blkflg(ii,dtset%natom+2,idir,ipert)=0
!     end if
!     end if
!     end do
      sumelfd(:)=sumelfd(:)+dble(symrl1(ii,1,isym))*d2nl_elfd(:,1)+&
&      dble(symrl1(ii,2,isym))*d2nl_elfd(:,2)+&
&      dble(symrl1(ii,3,isym))*d2nl_elfd(:,3)
     end do
     d2bbb(:,ii,idir,ipert,iband,iband)=sumelfd(:)/dble(nsym1)
    end do
   end do  !iband
  end if

  deallocate(symrl1)

 end if

!----------------------------------------------------------------------------
!Now, treat the local contribution

 nfftot=ngfftf(1)*ngfftf(2)*ngfftf(3)
 allocate(vpsp1(cplex*nfftf))
 if (ipert /= dtset%natom + 1) then
  n3xccc=0;if(psps%n1xccc/=0) n3xccc=cplex*nfftf
  allocate(xccc3d1(n3xccc),vxc1(cplex*nfftf,nspden))

  do ipert1=1,mpert
   do idir1=1,3
    if(ipert1 <= dtset%natom)then

!    Get first-order local potential and first-order pseudo core density
!    PAW: get them together in reciprocal space
     if (psps%usepaw==1) then
      optv=1;optn=n3xccc/(cplex*nfftf);optn2=1
      call atm2fft3(atindx,xccc3d1,vpsp1,cplex,dummy,gmet,gprimd,gsqcut,idir1,ipert1,&
&      mgfftf,mpi_enreg,psps%mqgrid_vl,dtset%natom,nattyp,1,nfftf,ngfftf,&
&      dtset%ntypat,optn,optn2,optv,dtset%paral_kgb,pawtab,ph1df,psps%qgrid_vl,&
&      dtset%qptn,dtset%typat,ucvol,psps%usepaw,psps%vlspl,xred)

     else
!     NCPP: get Vpsp1 in reciprocal space and rhocore1 in real space
      call vloca3(atindx,cplex,gmet,gsqcut,idir1,ipert1,mpi_enreg,psps%mqgrid_ff,dtset%natom,&
&      nattyp,nfftf,ngfftf,dtset%ntypat,n1,n2,n3,dtset%paral_kgb,ph1df,psps%qgrid_ff,&
&      dtset%qptn,ucvol,psps%vlspl,vpsp1,xred)
      if(psps%n1xccc/=0)then
       call mkcor3(cplex,idir1,ipert1,dtset%natom,dtset%ntypat,n1,psps%n1xccc,&
&       n2,n3,dtset%qptn,rprimd,dtset%typat,ucvol,psps%xcccrc,psps%xccc1d,xccc3d1,xred)
      end if
     end if

!    Get first-order exchange-correlation potential
!    (core-correction contribution only !)
     if(psps%n1xccc/=0)then
      option=0
      call mkvxc3(cplex,gmet,gsqcut,kxc,mpi_enreg,nfftf,ngfftf,nkxc,nspden,n3xccc,&
&      option,dtset%paral_kgb,dtset%qptn,rhodummy,rprimd,vxc1,xccc3d1)
     else
      vxc1(:,:)=zero
     end if

     if (psps%usepaw==0) then
!     Norm-conserving pseudpopotential case:
!     Combines density j2 with local potential j1 (vpsp1 and vxc1)
!     XG030514 : this is a first possible coding, however, each dotprod contains
!     a parallel section (reduction), so it is better to use only one dotprod ...
!     call dotprod_vn(cplex,rhor1,dr_psp1,di_psp1,mpi_enreg,nfftf,nfftot,1,2,vpsp1,ucvol)
!     call dotprod_vn(cplex,rhor1,dr_xc1,di_xc1,mpi_enreg,nfftf,nfftot,nspden,2,vxc1,ucvol)
!     dotr=dr_psp1+dr_xc1;doti=di_psp1+di_xc1
!     ... but then, one needs to overload vxc1
      do ispden=1,min(nspden,2)
       do ifft=1,cplex*nfftf
        vxc1(ifft,ispden)=vxc1(ifft,ispden)+vpsp1(ifft)
       end do
      end do
      call dotprod_vn(cplex,rhor1,dotr,doti,mpi_enreg,nfftf,nfftot,nspden,2,vxc1,ucvol)

     else
!     PAW case:
!     vxc1 is integrated with the total 1st-order density (rhor1 including nhat1)
      call dotprod_vn(cplex,rhor1,dr_xc1,di_xc1,mpi_enreg,nfftf,nfftot,nspden,2,vxc1,ucvol)
!     vpsp1 is integrated with the 1st-order pseudo density (rhor1 without nhat1)
      allocate(rhodummy(cplex*nfftf,nspden))
      do ispden=1,min(nspden,2)
       do ifft=1,cplex*nfftf
        rhodummy(ifft,ispden)=rhor1(ifft,ispden)-nhat1(ifft,ispden)
       end do
      end do
      call dotprod_vn(cplex,rhodummy,dr_psp1,di_psp1,mpi_enreg,nfftf,nfftot,nspden,2,vpsp1,ucvol)
      deallocate(rhodummy)
      dotr=dr_psp1+dr_xc1;doti=di_psp1+di_xc1
     end if

!    MVeithen 021212 : in case ipert = 2, these lines compute the local part
!    of the Born effective charges from phonon and electric
!    field type perturbations, see eq. 43 of
!    X. Gonze and C. Lee, PRB 55, 10355 (1997)
!    The minus sign is due to the fact that the effective charges
!    are minus the second derivatives of the energy
     if (ipert == dtset%natom+2) then
      d2lo(1,idir1,ipert1,idir,ipert)=-dotr
      d2lo(2,idir1,ipert1,idir,ipert)=-doti
     else
      d2lo(1,idir1,ipert1,idir,ipert)=dotr
      d2lo(2,idir1,ipert1,idir,ipert)=doti
     end if
!    Endif ipert1<=natom
    end if
   end do
  end do

  deallocate(vxc1,xccc3d1)

 end if ! ipert /= natom +1

 deallocate(d2bbb_k,d2nl_k,kg_k,kg1_k,vpsp1)
 deallocate(eig_k,eig1_k)

 call timab(101,2,tsec)

!DEBUG
!write(6,*)' nstdy3 : exit '
!write(6,*)' nstdy3 : d2nl(:,3,3,3,3)=',d2nl(:,3,3,3,3)
!stop
!ENDDEBUG

end subroutine nstdy3
!!***
