!{\src2tex{textfont=tt}}
!!****m* ABINIT/m_phdos
!!
!! NAME
!! m_phdos
!!
!! FUNCTION
!! Module for the phonon density of states.
!! Container type is defined, and destruction, print subroutines 
!! as well as the central mkphdos 
!!
!! COPYRIGHT
!! Copyright (C) 1999-2009 ABINIT group (MG,MJV)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUT
!!
!! OUTPUT
!!
!! NOTES
!! 
!! SOURCE


#if defined HAVE_CONFIG_H
#include "config.h"
#endif

module m_phdos

 use defs_basis

 implicit none

 type phonon_dos_type
! Integer
  integer :: ntypat
  integer :: natom
  integer :: prtdos

  integer :: nomega
  integer :: nqibz
  integer :: ntetra_ibz

! Reals
  real(dp) :: omega_min,omega_max,omega_step
  real(dp) :: dossmear

! Real pointers
  real(dp), pointer :: omega(:)              ! omega(nomega)   freq grid
  real(dp), pointer :: phdos(:)              ! phdos(nomega)   phonon DOS
  real(dp), pointer :: phdos_int(:)          ! phdos_int(nomega)  integrated phonon DOS
  real(dp), pointer :: pjdos(:,:,:)          ! pjdos(nomega,3,natom)
  real(dp), pointer :: pjdos_int(:,:,:)      ! pjdos_int(nomega,3,natom)
  real(dp), pointer :: pjdos_typ(:,:)        ! phdos(nomega,ntypat)
  real(dp), pointer :: pjdos_typ_int(:,:)    ! phdos(nomega,ntypat)
  real(dp), pointer :: pjdos_xyz_typ(:,:,:)  ! phdos(nomega,3,ntypat)

 end type phonon_dos_type

! Now the subroutines in the module
contains
!!***

!!****f* m_phdos/print_phondos
!!
!! NAME
!! print_phondos
!!
!! FUNCTION
!!
!! Print out phonon DOS (and partial DOS etc) in meV units
!!
!! COPYRIGHT
!! Copyright (C) 1999-2009 ABINIT group (MG,MJV)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUT
!! phonon_dos= container object for phonon DOS
!!
!! OUTPUT
!!
!! NOTES
!! 
!! PARENTS
!!      anaddb,scphon
!!
!! CHILDREN
!!
!! SOURCE
subroutine print_phondos (phonon_dos)

 use defs_basis
 use m_io_tools, only : get_unit

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 type(phonon_dos_type),intent(inout) :: phonon_dos

!Local variables-------------------------------
 integer :: io,itype
 integer :: unt

 real(dp) :: cfact
 character(len=50) :: frmt
 character(len=fnlen) :: fnam_loc
 character(len=500) :: msg
 character(len=3) :: unitname

! *************************************************************************

! === Convert everything into meV ===
  cfact=Ha_eV*1000 ; unitname='meV'
! === Leave everything in Ha      ===
! this should be the abinit default!
  cfact=one        ; unitname='Ha'

! === Open external file and write results ===
! TODO Here I have to rationalize how to write all this stuff!!

! write(frmt,*)'(f11.5,',phonon_dos%ntypat,'(3f11.5))'
! do io=1,phonon_dos%nomega
! write(888,frmt)phonon_dos%omega(io),((phonon_dos%pjdos_xyz_typ(io,ii,itype),ii=1,3),itype=1,phonon_dos%ntypat)
! end do
! 
! fnam_loc=trim(filname)//'_PHDOS'
  fnam_loc='PHDOS'
! call isfile(fnam_loc,'new')
  unt=get_unit()
! open(unit=unt,file=trim(fnam_loc),form='formatted',status='new')
  open(unit=unt,file=trim(fnam_loc),form='formatted')

  write(msg,'(3a)')'# ',ch10,'# Phonon density of states and projected DOS generated by anaddb'
  call wrtout(unt,msg,'COLL')
  write(msg,'(6a)')'# ',ch10,'# energy in ',unitname,', DOS in states/',unitname
  call wrtout(unt,msg,'COLL')
  if (phonon_dos%prtdos==1) then 
   write(msg,'(a,es16.8,2a,i4)')'# Gaussian method with smearing = ',phonon_dos%dossmear*cfact,unitname,', nqibz =',phonon_dos%nqibz
  else 
   write(msg,'(a,i5,a,i4)')'# Tetrahedron method, number of irreducible tetrahedrons = ',&
&   phonon_dos%ntetra_ibz,', nqibz= ',phonon_dos%nqibz
  end if
  call wrtout(unt,msg,'COLL')
! write(msg,'(4a,i5,5a,es16.8,a,es16.8,3a,es16.8,3a)')&
! & ' The DOS (in modes/',unitname,'/cell) and integrated DOS (in modes/cell) are computed,'&
! & ' at ',phonon_dos%nomega,' energies (in ',unitname,') covering the interval ',ch10,&
! & ' between ',phonon_dos%omega_min*cfact,' and ',phonon_dos%omega_max*cfact,&
! & ' ',unitname,' by steps of ',phonon_dos%omega_step*cfact,' ',unitname,'.'
! call wrtout(unt,msg,'COLL')
  write(msg,'(5a)')'# ',ch10,'# omega     PHDOS    IPHDOS   PJDOS[1]  IPJDOS[1] ...  ',ch10,'# '
  call wrtout(unt,msg,'COLL')
  write(frmt,*)'(',phonon_dos%ntypat,'(2es17.8))'
  do io=1,phonon_dos%nomega
   write(unt,'(3es17.8)',advance='NO')phonon_dos%omega(io)*cfact,phonon_dos%phdos(io)/cfact,phonon_dos%phdos_int(io)/cfact 
   do itype=1,phonon_dos%ntypat
    write(unt,frmt,advance='NO')phonon_dos%pjdos_typ(io,itype)/cfact,phonon_dos%pjdos_typ_int(io,itype)/cfact
   end do 
   write(unt,*)
  end do
  close(unt)

#ifdef DEBUG_MODE
  write(std_out,*)' phdos : exit '
#endif

 end subroutine print_phondos
!!***

!!****f* m_phdos/init_phondos
!!
!! NAME
!! init_phondos
!!
!! FUNCTION
!! 
!! init function for phonon DOS object
!!
!! COPYRIGHT
!! Copyright (C) 1999-2009 ABINIT group (MG,MJV)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUT
!!
!! OUTPUT
!! phonon_dos= container object for phonon DOS, filled and allocated
!!
!! NOTES
!! 
!! PARENTS
!!      mkphdos,scphon
!!
!! CHILDREN
!!
!! SOURCE
subroutine init_phondos(phonon_dos,ntypat,natom,prtdos,nomega,nqibz,ntetra_ibz,&
&   omega_max,omega_min,omega_step,dossmear)


 implicit none

!Arguments -------------------------------
 integer, intent(in) :: ntypat,natom,prtdos
 integer, intent(in) :: nomega,nqibz,ntetra_ibz

 real(dp), intent(in) :: omega_step,dossmear
 real(dp), intent(in) :: omega_max,omega_min

 type(phonon_dos_type),intent(inout) :: phonon_dos

!Local variables-------------------------------

! *************************************************************************

  phonon_dos%ntypat=ntypat
  phonon_dos%natom=natom
  phonon_dos%prtdos=prtdos
  phonon_dos%nomega=nomega
  phonon_dos%nqibz=nqibz
  phonon_dos%ntetra_ibz=ntetra_ibz

  phonon_dos%omega_max=omega_max
  phonon_dos%omega_min=omega_min
  phonon_dos%omega_step=omega_step
  phonon_dos%dossmear=dossmear

  nullify(phonon_dos%omega)
  nullify(phonon_dos%phdos)
  nullify(phonon_dos%phdos_int)
  nullify(phonon_dos%pjdos)
  nullify(phonon_dos%pjdos_int)
  nullify(phonon_dos%pjdos_typ)
  nullify(phonon_dos%pjdos_typ_int)
  nullify(phonon_dos%pjdos_xyz_typ)

  allocate(phonon_dos%omega(phonon_dos%nomega))
  allocate(phonon_dos%phdos(phonon_dos%nomega))
  allocate(phonon_dos%phdos_int(phonon_dos%nomega))
  allocate(phonon_dos%pjdos(phonon_dos%nomega,3,phonon_dos%natom))
  allocate(phonon_dos%pjdos_int(phonon_dos%nomega,3,phonon_dos%natom))
  allocate(phonon_dos%pjdos_typ(phonon_dos%nomega,phonon_dos%ntypat))
  allocate(phonon_dos%pjdos_typ_int(phonon_dos%nomega,phonon_dos%ntypat))
  allocate(phonon_dos%pjdos_xyz_typ(phonon_dos%nomega,3,phonon_dos%ntypat))


 end subroutine init_phondos
!!***


!!****f* m_phdos/destroy_phondos
!!
!! NAME
!! destroy_phondos
!!
!! FUNCTION
!! 
!! destructor function for phonon DOS object
!!
!! COPYRIGHT
!! Copyright (C) 1999-2009 ABINIT group (MG,MJV)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUT
!! phonon_dos= container object for phonon DOS
!!
!! OUTPUT
!!
!! NOTES
!! 
!! PARENTS
!!      anaddb
!!
!! CHILDREN
!!
!! SOURCE
subroutine destroy_phondos (phonon_dos)


 implicit none

!Arguments -------------------------------
 type(phonon_dos_type),intent(inout) :: phonon_dos
!Local variables-------------------------------

! *************************************************************************

  if(associated(phonon_dos%omega)) deallocate(phonon_dos%omega)
  if(associated(phonon_dos%phdos)) deallocate(phonon_dos%phdos)
  if(associated(phonon_dos%phdos_int)) deallocate(phonon_dos%phdos_int)
  if(associated(phonon_dos%pjdos)) deallocate(phonon_dos%pjdos)
  if(associated(phonon_dos%pjdos_int)) deallocate(phonon_dos%pjdos_int)
  if(associated(phonon_dos%pjdos_typ)) deallocate(phonon_dos%pjdos_typ)
  if(associated(phonon_dos%pjdos_typ_int)) deallocate(phonon_dos%pjdos_typ_int)
  if(associated(phonon_dos%pjdos_xyz_typ)) deallocate(phonon_dos%pjdos_xyz_typ)

 end subroutine destroy_phondos

end module m_phdos
!!***
