!{\src2tex{textfont=tt}}
!!****f* ABINIT/nmsq_gam
!!
!! NAME
!! nmsq_gam
!!
!! FUNCTION
!!  Calculate gamma matrices keeping full dependence on bands
!!  from original h1_mat_el_sq matrix elements (no averaging over
!!  bands near the Fermi surface)
!!
!! COPYRIGHT
!! Copyright (C) 2004-2009 ABINIT group (MVer)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!   displ_red = phonon mode displacement vectors, post-multiplied by gprim matrix
!!     (ie. turned to reduced coordinates)
!!   eigvec = phonon eigenvectors
!!   elph_ds = datastructure with gkk matrix elements
!!   FSfullpqtofull = mapping of k+q to k
!!   FSintweight = FS integration weights for each band and kpt
!!   FSkpt = coordinates of kpoints near to FS
!!   h1_mat_el_sq = matrix elements $<psi_{k+q,m} | H^{1} | psi_{k,n}>$ squared
!!   iqptfull = index of present qpoint
!!   phfrq_tmp = phonon frequencies
!!   spqpt = array of qpoint coordinates
!!   wf = gkk matrix element weight with $1/\sqrt{2 M \omega}$
!!
!! OUTPUT
!!   accum_mat = matrix for accumulating FS average of gkk (gamma matrix -> linewidths)
!!   accum_mat2 = matrix for accumulating FS average of gamma matrix with good prefactors
!!
!! NOTES
!!
!! PARENTS
!!      normsq_gkq
!!
!! CHILDREN
!!      leave_new,wrtout,zgemm
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine nmsq_gam (accum_mat,accum_mat2,displ_red,eigvec,elph_ds,FSfullpqtofull,&
&   FSintweight,FSkpt,h1_mat_el_sq,iqptfull,phfrq_tmp,spqpt,wf)

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use defs_elphon

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iqptfull
 type(elph_type),intent(inout) :: elph_ds
!arrays
 integer,intent(in) :: FSfullpqtofull(elph_ds%nFSkpt,elph_ds%nqpt)
 real(dp),intent(in) :: FSintweight(elph_ds%nFSband,elph_ds%nFSkpt,elph_ds%nsppol)
 real(dp),intent(in) :: FSkpt(3,elph_ds%nFSkpt)
 real(dp),intent(in) :: displ_red(2,elph_ds%nbranch,elph_ds%nbranch)
 real(dp),intent(in) :: eigvec(2,elph_ds%nbranch,elph_ds%nbranch)
 real(dp),intent(inout) :: &
& h1_mat_el_sq(2,elph_ds%nFSband*elph_ds%nFSband,elph_ds%nbranch*elph_ds%nbranch,elph_ds%nFSkpt,elph_ds%nsppol)
 real(dp),intent(in) :: phfrq_tmp(elph_ds%nbranch),spqpt(3,elph_ds%nqpt)
 real(dp),intent(in) :: wf(elph_ds%nbranch)
 real(dp),intent(inout) :: accum_mat(2,elph_ds%nbranch,elph_ds%nbranch,elph_ds%nsppol)
 real(dp),intent(inout) :: accum_mat2(2,elph_ds%nbranch,elph_ds%nbranch,elph_ds%nsppol)

!Local variables-------------------------------
! tmp variables for diagonalization
!scalars
 integer :: goodkpq,iFSkpt,iFSkptq,ib1,ib2,ibeff,ibranch,ipert1,ipert2,isppol
 integer :: jbranch,kbranch
 real(dp) :: res,sd1,sd2,ss
 character(len=500) :: message
!arrays
 real(dp) :: gkq(3),gkq_1band(2,elph_ds%nbranch,elph_ds%nbranch),kpt(3)
 real(dp) :: redkpt(3),tmp_mat2(2,elph_ds%nbranch,elph_ds%nbranch)
 real(dp) :: zgemm_tmp_mat(2,elph_ds%nbranch,elph_ds%nbranch)
 real(dp),allocatable :: matrx(:,:),val(:),vec(:,:,:),zhpev1(:,:),zhpev2(:)

! *************************************************************************

#ifdef __VMS
!DEC$ ATTRIBUTES ALIAS:'ZGEMM' :: zgemm
#endif

 if (elph_ds%tkeepbands == 0) then
  write (message,'(3a,i3)')' nmsq_gam : BUG- ',ch10,&
&  ' elph_ds%tkeepbands should be 1 while is ',elph_ds%tkeepbands
  call wrtout(06,message,'COLL')
  call leave_new('COLL')
 end if

!MG20060603 NOTE:
!accum_mat and accum_mat2 are real, the imaginary part is used for debugging purpose
!accum_mat2 is used to store the phonon-linewidhts before interpolation

 write (*,*) 'nmsq_gam : iqptfull = ', iqptfull

 do isppol=1,elph_ds%nsppol
  do iFSkpt=1,elph_ds%nFSkpt

   iFSkptq = FSfullpqtofull(iFSkpt,iqptfull)

   do ib1=1,elph_ds%nFSband
    sd1 = FSintweight(ib1,iFSkpt,isppol) !weights for distance from the fermi surface

    do ib2=1,elph_ds%nFSband
     sd2 = FSintweight(ib2,iFSkptq,isppol) !weights for distance from the fermi surface
     ibeff = ib2+elph_ds%nFSband*(ib1-1)

     gkq_1band(:,:,:) = zero

     zgemm_tmp_mat=zero
     tmp_mat2 = reshape (h1_mat_el_sq(:,ibeff,:,iFSkpt,isppol),(/2,elph_ds%nbranch,elph_ds%nbranch/))

     call zgemm('c','n',elph_ds%nbranch,elph_ds%nbranch,elph_ds%nbranch,cone,&
&     displ_red,elph_ds%nbranch,tmp_mat2,&
&     elph_ds%nbranch,czero,zgemm_tmp_mat,elph_ds%nbranch)

!    MG20060607 there is no explicit dependence on omega in the linewidth.
!    It is better dont use wf at all and employ the same approach as in nmsq_gam or nmsq_pure_gkk
     tmp_mat2=zero
!    factor of pi here
     call zgemm('n','n',elph_ds%nbranch,elph_ds%nbranch,elph_ds%nbranch,dcmplx(pi,zero),&
&     zgemm_tmp_mat,elph_ds%nbranch,displ_red,&
&     elph_ds%nbranch,czero,tmp_mat2,elph_ds%nbranch)
!    sum over bands 
     do ipert1=1,elph_ds%nbranch
      gkq_1band(1,ipert1,ipert1) = gkq_1band(1,ipert1,ipert1) + tmp_mat2(1,ipert1,ipert1)
     end do

!    summing over k points and bands, still diagonal in jbranch
     accum_mat(:,:,:,isppol) = accum_mat(:,:,:,isppol) + gkq_1band(:,:,:)*sd1*sd2

!    MG20060603 : summing over bands and kpoints with weights to calculate the phonon linewidth
     do jbranch=1,elph_ds%nbranch
      accum_mat2(:,jbranch,jbranch,isppol) = accum_mat2(:,jbranch,jbranch,isppol) + gkq_1band(:,jbranch,jbranch)*sd1*sd2
     end do
!    END MG


!    now turn to cartesian coordinates

!    Final Gamma matrix (hermitian) = E * D_g * E^{+}
!    Where E^{+} is the hermitian conjugate of the eigenvector matrix E
!    And D_g is the diagonal matrix of values of gamma for this qpoint

!    Here gkq_1band is indexed with real phonon modes (not atom+idir)
!    turn gkq_1band to atom+cartesian coordinates (instead of normal coordinates for qpoint)
     tmp_mat2(:,:,:) = zero
     do ibranch =1,elph_ds%nbranch
      do jbranch =1,elph_ds%nbranch
       tmp_mat2(1,ibranch,jbranch) = tmp_mat2(1,ibranch,jbranch) + &
&       eigvec(1,ibranch,jbranch) * gkq_1band(1,jbranch,jbranch)
       tmp_mat2(2,ibranch,jbranch) = tmp_mat2(2,ibranch,jbranch) + &
&       eigvec(2,ibranch,jbranch) * gkq_1band(1,jbranch,jbranch)
      end do
     end do
     gkq_1band(:,:,:) = zero

!    here eigvec is transposed and complexconjugated.
     zgemm_tmp_mat=zero
     call zgemm('n','c',elph_ds%nbranch,elph_ds%nbranch,elph_ds%nbranch,cone,&
&     tmp_mat2,elph_ds%nbranch,eigvec,elph_ds%nbranch,czero,zgemm_tmp_mat,elph_ds%nbranch)

     gkq_1band = zgemm_tmp_mat

!    gamma matrix contribution in cartesian coordinates (ie interpolatable form)
     h1_mat_el_sq(:,ibeff,:,iFSkpt,isppol) = reshape(gkq_1band,(/2,elph_ds%nbranch*elph_ds%nbranch/))

    end do
   end do
!  END loop over bands ib1 ib2

  end do
! END loop over FSkpt
 end do
!END loop over nsppol


end subroutine nmsq_gam
!!***
