!{\src2tex{textfont=tt}}
!!****f* ABINIT/prt_gkk_yambo
!!
!! NAME
!! prt_gkk_yambo
!!
!! FUNCTION
!! This routine outputs el-phon related quantities for the yambo code at 1
!!   q-point
!!
!! COPYRIGHT
!! Copyright (C) 2009 ABINIT group (MJV)
!! This file is distributed under the terms of the
!! GNU General Public Licence, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt
!.
!!
!! INPUTS
!!  displ = phonon displacement vectors for this q-point
!!  elph_ds = datastructure containing elphon matrix elements
!!  gprimd = reciprocal lattice vectors (dimensionful)
!!  h1_mat_el = matrix elements of first order hamiltonian for present q-point,
!!     all perturbations
!!  iqptfull = index of present q-point in full array of q-points
!!  irredpert = index of irreducible perturbation (atom displaced)
!!  natom = number of atoms
!!  nsym = number of symmetries for full lattice
!!  phfrq = phonon frequencies at present q-point
!!  rprimd = real space primitive vectors of cell (trans to cart coord)
!!  spqpt = coordinates of full uniform qpt grid
!!  symq  = info for symmetry operations for this q-point
!!  symrec = symmetry operations in reciprocal space
!!  symrel = symmetry operations in real space
!!  qtimrev = flag for using time reversal symmetry. No effect for the
!!     moment: info from symq
!!  tnons = translations associated to symrel
!!
!! OUTPUT
!!  only writes to a file
!!
!! NOTES
!!
!! PARENTS
!!      read_gkk
!!
!! CHILDREN
!!
!! SOURCE

subroutine prt_gkk_yambo(displ,FSkpt,gprimd,h1_mat_el,iqpt,&
      &       natom,nFSband,nFSkpt,nsym,&
      &       phfrq,rprimd,qptn,symrec,symrel,tnons)


 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: natom,nsym,iqpt
 integer,intent(in) :: nFSband,nFSkpt
 !arrays
 integer,intent(in) :: symrec(3,3,nsym)
 integer,intent(in) :: symrel(3,3,nsym)
 real*8,intent(in) :: FSkpt(3,nFSkpt)
 real*8,intent(in) :: h1_mat_el(2,nFSband*nFSband,3*natom,nFSkpt,1)
 real*8,intent(in) :: phfrq(3*natom)
 real*8,intent(in) :: displ(2,3*natom,3*natom)
 real*8,intent(in) :: gprimd(3,3)
 real*8,intent(in) :: rprimd(3,3)
 real*8,intent(in) :: qptn(3)
 real*8,intent(in) :: tnons(3,nsym)

!Local variables-------------------------------
 !scalars
 integer, save :: firsttime=1
 integer :: outunit,ikpt,imode,iband,ibandp,iatom,idir,ibandindex
 !arrays

! *************************************************************************

 outunit=444
!open file
 open (unit=outunit,file="yambo_elphon_data",status="unknown",position="append")


!if first time round:
 if (firsttime==1) then
  firsttime=0

! write dimensions
  write (outunit,'(a,I6)') 'number of el atoms ', natom
  write (outunit,'(a,I6)') 'number of ph modes ', 3*natom
  write (outunit,'(a,I6)') 'number of el bands ', nFSband

! write k-points
  write (outunit,'(a,I6)') 'number of k-points ', nFSkpt
  do ikpt=1,nFSkpt
   write (outunit,'(a,I6,3E20.10)') 'reduced coord kpoint no ', ikpt, FSkpt(:,ikpt)
  end do

! band energies are not accessible this deep in the code: simpler to get them
! from elsewhere

 end if ! first time round

!qpoint
 write (outunit,'(a,I6,3E20.10)') 'reduced coord qpoint no ', iqpt, qptn(:)

!frequencies
 do imode=1,3*natom
  write (outunit,'(a,I6,3E20.10)') 'phonon freq no ', imode, phfrq(imode)
 end do

!displacement vector
 do imode=1,3*natom
  write (outunit,'(a,I6,3E20.10)') 'phonon displ vec no ', imode
  do iatom=1,natom
   write (outunit,'(3(2E20.10,2x))') displ(:,(iatom-1)*3+1:iatom*3,imode)
  end do
 end do

!the beef: matrix elements of the first order hamiltonian for displacement of
!all atoms along all reduced directions
 write (outunit,'(a)') ' matrix elements of all perturbations for this q-point'
 do ikpt=1,nFSkpt 
  write (outunit,'(a,I6)') ' kpoint ', ikpt
  imode=0
  do iatom=1,natom
   do idir=1,3
    imode=imode+1
    write (outunit,'(a,I6,I6)') ' atom, direction = ', iatom,idir
    ibandindex=0
    do iband=1,nFSband
     do ibandp=1,nFSband
      ibandindex=ibandindex+1
      write (outunit,'(a,I6,I6,2E20.10)') ' mat el for n,np ', iband,ibandp,&
&      h1_mat_el(:,ibandindex,imode,nFSkpt,1)
     end do !bandp
    end do !band
   end do !dir
  end do !atom
 end do

!blank line
 write (outunit,*)

 close (outunit)

end subroutine prt_gkk_yambo
!!***
