!{\src2tex{textfont=tt}}
!!****f* ABINIT/thmeig
!! NAME
!! thmeig
!!
!! FUNCTION
!! This routine calculates the thermal corrections to the eigenvalues.
!! The output is this quantity for the input k point.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2009 ABINIT group (PB, XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! PARENTS
!!      anaddb
!!
!! CHILDREN
!!      get_tetra,get_tetra_weight,matr3inv,mkrdim,outg2f,outphdos,sort_dp
!!      wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine thmeig(g2fsmear,acell,amu,blkval2,eigvec,filnam,kpnt,mband,msize,natom,nkpt,nqpt,ntemper,ntypat,&
&                 phfreq,qphon,rprim,telphint,temperinc,tempermin,thmflag,typat,wtq,xred)

 use defs_basis
 use defs_datatypes
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_28_numeric_noabirule
 use interfaces_32_util
 use interfaces_42_geometry
 use interfaces_56_recipspace
 use interfaces_62_occeig
 use interfaces_77_ddb, except_this_one => thmeig
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: mband,msize,natom,nkpt,nqpt,ntemper,ntypat,telphint,thmflag
 real(dp),intent(in) :: g2fsmear,temperinc,tempermin
 character(len=fnlen),intent(in) :: filnam
!arrays
 integer,intent(in) :: typat(natom)
 real(dp),intent(in) :: acell(3),amu(ntypat),blkval2(2,msize,mband,nkpt,nqpt)
 real(dp),intent(in) :: eigvec(2,3,natom,3*natom,nqpt),kpnt(3,nkpt,nqpt)
 real(dp),intent(in) :: phfreq(3*natom,nqpt),qphon(9,nqpt),rprim(3,3)
 real(dp),intent(in) :: wtq(3,nqpt),xred(3,natom)

!Local variables-------------------------------
!tolerance for non degenerated levels
!scalars
 integer :: gqpt,iatom1,iatom2,iband,idem,idir1,idir2,ii,ikpt,ilatt,imod,imod1,index
 integer :: index2,iomega,iost,iqpt,iqpt1,iqpt2,iqpt3,isize,itemper
 integer :: mtetra,nene,ng2f,ntetra,unit_g2f
 integer :: unit_phdos,unitout
 real(dp),parameter :: qtol=2.0d-8
 real(dp) :: bosein,deltaene,det,domega,dot,enemax,enemin,fact1i,fact1r,fact2i,fact2r,facti,factr
 real(dp) :: gaussfactor,gaussprefactor,gaussval,im,invdet,omega,omega_max,omega_min,qnrm
 real(dp) :: rcvol,tmp,tol,vec1i,vec1r,vec2i,vec2r,veci,vecr,vv,xx
 character(len=500) :: message
 character(len=fnlen) :: outfile
!arrays
 integer :: indqpt(nqpt)
 integer,allocatable :: tetra_full(:,:,:),tetra_mult(:),tetra_wrap(:,:,:)
 real(dp) :: dedni(mband,nkpt,3*natom,nqpt),dednr(mband,nkpt,3*natom,nqpt),deigi(mband,nkpt)
 real(dp) :: deigr(mband,nkpt),dred(3),dwtermi(mband,nkpt),dwtermr(mband,nkpt),eigen_in(nqpt)
 real(dp) :: gprimd(3,3),klatt(3,3),mesh(3,3),multi(mband,nkpt),multr(mband,nkpt),norm(3)
 real(dp) :: qlatt(3,3),qpt_full(3,nqpt),qptnrm(nqpt)
 real(dp) :: rprimd(3,3),slope(2,mband,nkpt),tempqlatt(3),thmeigen(2,mband,nkpt),wghtq(nkpt)
 real(dp) :: zeropoint(2,mband,nkpt)
 real(dp),allocatable :: dos_phon(:),dtweightde(:,:),g2f(:,:,:),intweight(:,:,:)
 real(dp),allocatable :: indtweightde(:,:,:),tmpg2f(:,:,:),tmpphondos(:),total_dos(:),tweight(:,:)

! *********************************************************************


!wghtq(:)=wtq(1,:)
 wghtq(:)=one/nqpt

!write(*,*)'wghtq ',wghtq
!write(*,*)'phfreq',phfreq


!Calculating the directions (usefull because derivatives are in reduced coordinates)
 do ii=1,3
  norm(ii) = acell(ii) * sqrt(rprim(1,ii)**2+rprim(2,ii)**2+rprim(3,ii)**2)
 end do

!Finding the Gamma point
 do iqpt=1,nqpt
  qnrm = qphon(1,iqpt)*qphon(1,iqpt)+qphon(2,iqpt)*qphon(2,iqpt)+qphon(3,iqpt)*qphon(3,iqpt)
  if(qnrm<qtol) gqpt=iqpt
 end do

 if(gqpt==0 .and. thmflag==3) then
  write(message, '(a,a)' ) &
&  ' Could not find the Gamma point, but it is needed for DW term ',ch10
  call wrtout(6,message,'COLL')
  call wrtout(ab_out,message,'COLL')
  stop
 end if

 write(*,*)'thmeig: gqpt',gqpt

!test for the gamma point 

!=========================================================================
!0) Calculation of dE(n,k)/dn(Q,j)
!=========================================================================
 
 dednr(:,:,:,:) = zero
 dedni(:,:,:,:) = zero

!Sum on all phonon wavevectors and modes
 do iqpt=1,nqpt
  index2=0
! do imod=3*natom,3*natom   ! for molecules
  do imod=1,3*natom

!  Calculate the derivative
   deigr(:,:) = zero
   deigi(:,:) = zero
   dwtermr(:,:)=zero
   dwtermi(:,:)=zero
   index=0
   do iatom1=1,natom
    do idir1=1,3
     do iatom2=1,natom
      dred(:) = xred(:,iatom1) - xred(:,iatom2)
      dot = qphon(1,iqpt)*dred(1)+qphon(2,iqpt)*dred(2)+qphon(3,iqpt)*dred(3)
      index2=index2+1

!     Compute factor for SE term
      if(phfreq(imod,iqpt)<tol6)then
       factr = zero
       facti = zero
      else
       factr=cos(two_pi*dot) /sqrt(amu(typat(iatom1))*amu(typat(iatom2)))/phfreq(imod,iqpt)/amu_emass
       facti=sin(two_pi*dot) /sqrt(amu(typat(iatom1))*amu(typat(iatom2)))/phfreq(imod,iqpt)/amu_emass
      end if
      
      do idir2=1,3
       index = index+1

!      Compute products of polarization vectors
       vecr = eigvec(1,idir1,iatom1,imod,iqpt)*eigvec(1,idir2,iatom2,imod,iqpt)+&
&       eigvec(2,idir1,iatom1,imod,iqpt)*eigvec(2,idir2,iatom2,imod,iqpt)
       veci = eigvec(2,idir1,iatom1,imod,iqpt)*eigvec(1,idir2,iatom2,imod,iqpt)-&
&       eigvec(1,idir1,iatom1,imod,iqpt)*eigvec(2,idir2,iatom2,imod,iqpt)

       vec1r = eigvec(1,idir1,iatom1,imod,iqpt)*eigvec(1,idir2,iatom1,imod,iqpt)+&
&       eigvec(2,idir1,iatom1,imod,iqpt)*eigvec(2,idir2,iatom1,imod,iqpt)
       vec1i = eigvec(2,idir1,iatom1,imod,iqpt)*eigvec(1,idir2,iatom1,imod,iqpt)-&
&       eigvec(1,idir1,iatom1,imod,iqpt)*eigvec(2,idir2,iatom1,imod,iqpt)

       vec2r = eigvec(1,idir1,iatom2,imod,iqpt)*eigvec(1,idir2,iatom2,imod,iqpt)+&
&       eigvec(2,idir1,iatom2,imod,iqpt)*eigvec(2,idir2,iatom2,imod,iqpt)
       vec2i = eigvec(2,idir1,iatom2,imod,iqpt)*eigvec(1,idir2,iatom2,imod,iqpt)-&
&       eigvec(1,idir1,iatom2,imod,iqpt)*eigvec(2,idir2,iatom2,imod,iqpt)
       
!      Compute factor for DW term
       if(phfreq(imod,iqpt)<tol6)then
        fact2r = zero
        fact2i = zero
       else
        fact2r = wghtq(iqpt)*(vec1r/amu(typat(iatom1)) + vec2r/amu(typat(iatom2)))/phfreq(imod,iqpt)/&
&        amu_emass/2/norm(idir1)/norm(idir2)
        fact2i = wghtq(iqpt)*(vec1i/amu(typat(iatom1)) + vec2i/amu(typat(iatom2)))/phfreq(imod,iqpt)/&
&        amu_emass/2/norm(idir1)/norm(idir2)
       end if

       multr(:,:) =(blkval2(1,index,:,:,iqpt)*vecr - blkval2(2,index,:,:,iqpt)*veci)/(norm(idir1)*norm(idir2))
       multi(:,:) =(blkval2(1,index,:,:,iqpt)*veci + blkval2(2,index,:,:,iqpt)*vecr)/(norm(idir1)*norm(idir2))

!      write(*,*) 'factr et facti',factr,facti
!      write(*,*) 'fact2r et fact2i',fact2r,fact2i
!      write(*,*) 'multr et multi', multr, multi

!      Debye-Waller Term
       if(thmflag==3) then
        dwtermr(1:mband,1:nkpt) = dwtermr(1:mband,1:nkpt) + fact2r*blkval2(1,index,:,:,gqpt) - fact2i*blkval2(2,index,:,:,gqpt)
        dwtermi(1:mband,1:nkpt) = dwtermi(1:mband,1:nkpt) + fact2r*blkval2(2,index,:,:,gqpt) + fact2i*blkval2(1,index,:,:,gqpt)
       end if

!      Self-energy Term (Fan)
       deigr(1:mband,1:nkpt) = deigr(1:mband,1:nkpt) + wghtq(iqpt)*(factr*multr(1:mband,1:nkpt) - facti*multi(1:mband,1:nkpt))
       deigi(1:mband,1:nkpt) = deigi(1:mband,1:nkpt) + wghtq(iqpt)*(factr*multi(1:mband,1:nkpt) + facti*multr(1:mband,1:nkpt))

      end do !idir2
     end do !iatom2
    end do !idir1
   end do !iatom1
!  Eigenvalue derivative or broadning
   if(thmflag==3) then  
    dednr(1:mband,1:nkpt,imod,iqpt) = deigr(1:mband,1:nkpt) - dwtermr(1:mband,1:nkpt)
    dedni(1:mband,1:nkpt,imod,iqpt) = deigi(1:mband,1:nkpt) - dwtermi(1:mband,1:nkpt)
   else if(thmflag==4) then
    dednr(1:mband,1:nkpt,imod,iqpt) = pi*deigr(1:mband,1:nkpt) 
    dedni(1:mband,1:nkpt,imod,iqpt) = pi*deigi(1:mband,1:nkpt) 
   end if
  end do ! imod
 end do !iqpt
!write(*,*) 'mband, nkpt, nqpt',mband,nkpt,nqpt
!write(*,*)'dednr ',dednr
!write(*,*)'dedni ',dedni

!=============================================================================
!1) Evaluation of the Eliashberg type spectral function 
!and phonon DOS via gaussian broadning
!=============================================================================

 if(telphint==1)then
  ng2f = 400  ! number of frequencies
  omega_min=zero
  omega_max=zero
  do iqpt=1,nqpt
   do imod=1,3*natom
    omega_min = min(omega_min,phfreq(imod,iqpt))
    omega_max = max(omega_max,phfreq(imod,iqpt))
   end do
  end do

  allocate(dos_phon(ng2f),g2f(mband,nkpt,ng2f))
  allocate(tmpg2f(mband,nkpt,ng2f),tmpphondos(ng2f))

  write(6,'(a,es12.6)') 'omega_min :', omega_min
  write(6,'(a,es12.6)') 'omega_max :', omega_max
  write(6,'(a,i8)') 'ng2f :', ng2f

  domega = (omega_max-omega_min)/(ng2f-one)   

  gaussprefactor = sqrt(piinv) / g2fsmear    
  gaussfactor = one / g2fsmear

  g2f(:,:,:) = zero
  dos_phon(:) = zero

  do iqpt=1,nqpt
   do imod=1,3*natom
    omega = omega_min     
    tmpg2f(:,:,:) = zero
    tmpphondos(:) = zero
    do iomega=1,ng2f
     xx = (omega-phfreq(imod,iqpt))*gaussfactor
     gaussval = gaussprefactor*exp(-xx*xx)
     tmpg2f(:,:,iomega) = tmpg2f(:,:,iomega) + gaussval*dednr(:,:,imod,iqpt)
     tmpphondos(iomega) = tmpphondos(iomega) + gaussval
     omega = omega+domega
    end do

    g2f(:,:,:) = g2f(:,:,:) + tmpg2f(:,:,:)
    dos_phon(:) = dos_phon(:) + tmpphondos(:)

   end do !imod
  end do !iqpt

  g2f(:,:,:) = g2f(:,:,:) / nqpt
  dos_phon(:) = dos_phon(:) / nqpt
  
! output the g2f
  unit_g2f = 108
  call outg2f(domega,omega_min,omega_max,filnam,g2f,g2fsmear,kpnt,mband,ng2f,nkpt,nqpt,1,telphint,unit_g2f)

! output the phonon DOS
  unit_phdos = 108
  call outphdos(domega,dos_phon,omega_min,omega_max,filnam,g2fsmear,mband,ng2f,nqpt,1,telphint,unit_g2f)
  
  deallocate(dos_phon,g2f)
  deallocate(tmpg2f,tmpphondos)
  
 end if !telphint

!=======================================================================
!2) Evaluation of the Eliashberg type spectral function
!and phonon DOS via improved tetrahedron method 
!=======================================================================

 if(telphint==0)then

! make dimension-ful rprimd and gprimd for transformation of derivatives to cartesian coordinates.
  call mkrdim(acell,rprim,rprimd)
  call matr3inv(rprimd,gprimd)

! Q point Grid
  qpt_full(:,:) = qphon(1:3,:)

! Trivial Q point index  
  do iqpt=1,nqpt
   indqpt(iqpt)=iqpt
   qptnrm(iqpt)= qpt_full(1,iqpt)*qpt_full(1,iqpt)+qpt_full(2,iqpt)*qpt_full(2,iqpt)+qpt_full(3,iqpt)*qpt_full(3,iqpt)
  end do

! Build qlatt from scratch (for 5.7)
  tol = 0.1_dp
  ilatt = 0
  call sort_dp(nqpt,qptnrm,indqpt,tol)

  do iqpt1=1,nqpt-2
   mesh(1:3,1) = qpt_full(1:3,indqpt(iqpt1))
   do iqpt2=iqpt1+1,nqpt-1
    mesh(1:3,2)= qpt_full(1:3,indqpt(iqpt2))
    do iqpt3=iqpt2+1,nqpt
     mesh(1:3,3)= qpt_full(1:3,indqpt(iqpt3))
     det = mesh(1,1)*mesh(2,2)*mesh(3,3) + mesh(1,2)*mesh(2,3)*mesh(3,1) + mesh(1,3)*mesh(2,1)*mesh(3,2) &
&     -mesh(3,1)*mesh(2,2)*mesh(1,3) - mesh(3,2)*mesh(2,3)*mesh(1,1) - mesh(3,3)*mesh(2,1)*mesh(1,2)
     invdet = one/det
     if (abs(nint(invdet))==nqpt .and. abs(invdet)-nqpt < tol) then
      ilatt = 1
      qlatt(:,:) = mesh(:,:)
      exit
     end if            
    end do
    if(ilatt==1) exit
   end do
   if(ilatt==1) exit
  end do

! error message if qlatt not found and stop
  if(ilatt==0) then
   write(message, '(a,a)' ) &
&   ' Could not find homogeneous basis vectors for Q point grid ',ch10
   call wrtout(6,message,'COLL')
   call wrtout(ab_out,message,'COLL')
   stop
  end if

! test if qlatt is righthanded and possibly fixe it
  if(invdet < 0) then
   tempqlatt(:) = qlatt(:,2)
   qlatt(:,2) = qlatt(:,1)
   qlatt(:,1) = tempqlatt(:)    
  end if

  write(*,*) 'qlatt',qlatt

! test if qlatt generates all Q points  TO DO



! Get tetrahedra, ie indexes of the full kpoints at their summits
  mtetra = 6 * nqpt
  ntetra = mtetra

  allocate (tetra_full(4,2,mtetra),tetra_wrap(3,4,mtetra))
  allocate(tetra_mult(mtetra))

  call get_tetra(indqpt,gprimd,qlatt,qpt_full,mtetra,&
&  nqpt,ntetra,tetra_full,tetra_mult,tetra_wrap,vv)
  
! DEBUG
! write(*,*)' thmeig : vv = ', vv
! write(*,*)' thmeig : ntetra,mtetra = ', ntetra,mtetra
! write(*,*)' thmeig : tetra_full = ', tetra_full
! write(*,*)' thmeig : tetra_mult = ', tetra_mult
! ENDDEBUG

  rcvol = abs (gprimd(1,1)*(gprimd(2,2)*gprimd(3,3)-gprimd(3,2)*gprimd(2,3)) &
&  -gprimd(2,1)*(gprimd(1,2)*gprimd(3,3)-gprimd(3,2)*gprimd(1,3)) &
&  +gprimd(3,1)*(gprimd(1,2)*gprimd(2,3)-gprimd(2,2)*gprimd(1,3)))

! Calculate weights for phonon DOS
! Special precautions must be taking for Gamma point
! because of non-analytic term.
! Non-analyticity must be taken out and treated separatly.

  nene = 100     !nene=number of energies for DOS
  enemin = minval(phfreq) 
  enemax = maxval(phfreq) 
  deltaene = (enemax-enemin)/dble(nene-1)
! redefine enemin enemax to be at rounded multiples of deltaene
! enemin = elph_ds%fermie - dble(ifermi)*deltaene
! enemax = elph_ds%fermie + dble(nene-ifermi-1)*deltaene

  allocate(tweight(nqpt,nene),dtweightde(nqpt,nene))
  allocate(intweight(3*natom,nqpt,nene),indtweightde(3*natom,nqpt,nene))
  
  do iband=1,3*natom
   eigen_in(:) = phfreq(iband,:)

!  calculate general integration weights at each irred kpoint as in Blochl et al PRB 49 16223
   call get_tetra_weight(eigen_in,enemin,enemax,one,mtetra,nene,nqpt,&
&   ntetra,rcvol,tetra_full,tetra_mult,tweight,dtweightde,vv)

   intweight(iband,:,:) = tweight(:,:)
   indtweightde(iband,:,:) = dtweightde(:,:)
   
  end do !iband
  
! intdtweightse(nband,nqpt,nene) represents the weight in each energy bin for every kpt and every band
! So phonon DOS is calculated (neglecting the non-analyticity contribution for now !!!)

  allocate(total_dos(nene),g2f(mband,nkpt,nene))

  total_dos(:) = zero
  do iband=1,3*natom
   do iqpt=1,nqpt
    total_dos(:) = total_dos + indtweightde(iband,iqpt,:)
   end do
  end do

! For the g2f function
! Right now for one electronic band and one K point: dednr(1:mband,1:nkpt,imod,iqpt)
! Once again must pay close attention to the Gamma point
  g2f(:,:,:) = zero
  do ii=1,mband
   do ikpt=1,nkpt
    do iband=1,3*natom
     do iqpt=1,nqpt
      g2f(ii,ikpt,:) = g2f(ii,ikpt,:) + dednr(ii,ikpt,iband,iqpt) * indtweightde(iband,iqpt,:)
     end do
    end do
   end do
  end do

! output the g2f
  unit_g2f = 108
  call outg2f(deltaene,enemin,enemax,filnam,g2f,g2fsmear,kpnt,mband,nene,nkpt,nqpt,ntetra,telphint,unit_g2f)

! output the phonon DOS
  unit_phdos = 108
  call outphdos(deltaene,total_dos,enemin,enemax,filnam,g2fsmear,mband,nene,nqpt,ntetra,telphint,unit_g2f)

  deallocate(tweight,dtweightde)
  deallocate(intweight,indtweightde)
  deallocate(tetra_full,tetra_wrap,tetra_mult)
  deallocate(total_dos,g2f)
 end if !telphint

!=======================================================================
!3) direct evaluation of thermal corrections
!=======================================================================
 
 slope(:,:,:) = zero
 zeropoint(:,:,:) = zero
!Loop on temperatures
 do itemper= 1, ntemper
  tmp=tempermin+temperinc*float(itemper-1)
  thmeigen(:,:,:) = zero

! Sum on all phonon wavevectors and modes
  do iqpt=1,nqpt
   index2=0
   do imod=1,3*natom

!   Bose-Einstein distribution 
    if(phfreq(imod,iqpt)<tol6)then
     bosein = zero
    else
     bosein = one/(exp(phfreq(imod,iqpt)/(kb_HaK*tmp))-1) 
    end if

!   Calculate total
    thmeigen(1,1:mband,1:nkpt) = thmeigen(1,1:mband,1:nkpt) + dednr(1:mband,1:nkpt,imod,iqpt)*(bosein+half)
    thmeigen(2,1:mband,1:nkpt) = thmeigen(2,1:mband,1:nkpt) + dedni(1:mband,1:nkpt,imod,iqpt)*(bosein+half)

    if(itemper==1)then
!    Calculate slope of linear regime
     if(phfreq(imod,iqpt)<tol6)then
      slope(1,1:mband,1:nkpt) = slope(1,1:mband,1:nkpt) 
      slope(2,1:mband,1:nkpt) = slope(2,1:mband,1:nkpt) 
     else
      slope(1,1:mband,1:nkpt) = slope(1,1:mband,1:nkpt) + dednr(1:mband,1:nkpt,imod,iqpt)*(kb_HaK/phfreq(imod,iqpt))
      slope(2,1:mband,1:nkpt) = slope(2,1:mband,1:nkpt) + dedni(1:mband,1:nkpt,imod,iqpt)*(kb_HaK/phfreq(imod,iqpt))
     end if
!    Calculate zero-point renormalization
     zeropoint(1,1:mband,1:nkpt) = zeropoint(1,1:mband,1:nkpt) + dednr(1:mband,1:nkpt,imod,iqpt)*half
     zeropoint(2,1:mband,1:nkpt) = zeropoint(2,1:mband,1:nkpt) + dedni(1:mband,1:nkpt,imod,iqpt)*half
    end if
   end do ! imod
  end do !iqpt

! Output
! unitout should be attributed in dtset to avoid conflicts
  unitout = 42
  outfile = trim(filnam)//"_TBS"
  
! open TBS file
  open (unit=unitout,file=outfile,form='formatted',status='unknown')
  write(unitout,'(a)')'thmeig: Thermal Eigenvalue corrections'
! Write temperature independent results
  if(itemper==1)then
   write(unitout,'(a)')'Temperature independent results'
   do ikpt=1,nkpt
    write(unitout,'(a,3es16.8)')' Kpt :', kpnt(:,ikpt,1)
    do iband=1,mband
     write(unitout,'(4d22.14)') Ha_eV*slope(1,iband,ikpt),Ha_eV*slope(2,iband,ikpt),&
&     Ha_eV*zeropoint(1,iband,ikpt),Ha_eV*zeropoint(2,iband,ikpt)
    end do
   end do
   write(unitout,'(a)')'Temperature dependent results'
  end if
! Write result in file for each temperature
  write(unitout,'(a,es9.3,a)')'T :', tmp,' K'
  do ikpt=1,nkpt
   write(unitout,'(a,3es16.8)')' Kpt :', kpnt(:,ikpt,1)
   do iband=1,mband
    write(unitout,'(2d22.14)') Ha_eV*thmeigen(1,iband,ikpt), Ha_eV*thmeigen(2,iband,ikpt)
   end do
  end do
 end do !itemper
 
 close(unitout)

end subroutine thmeig
!!***

