!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_vtorho
!! NAME
!! wvl_vtorho
!!
!! FUNCTION
!! Heart of the wavelet resolution, compute new wavefunctions mixed witf previous
!! by computing the gradient of the wavefunctions knowing the external potential.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2009 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtset <type(dataset_type)>=input variables.
!!  istep=id of the current iteration (first is 1).
!!  mpi_enreg=informations about MPI parallelization
!!  occ(dtset%mband * dtset%nsppol)=occupation numbers.
!!  proj <type(wvl_projector_type)>=projectors informations for wavelets.
!!  psps <type(pseudopotential_type)>=variables related to pseudopotentials
!!  vtrial(dtset%nfft)=external potential.
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  energies <type(energies_type)>=storage for energies computed here :
!!   | e_kinetic(OUT)=kinetic energy part of total energy
!!   | e_localpsp(OUT)=local pseudopotential part of total energy
!!   | e_nonlocalpsp(OUT)=nonlocal pseudopotential part of total energy
!!  residm=max value for gradient in the minimisation process.
!!  rhor(dtset%nfft)=electron density in r space
!!  wfs <type(wvl_projector_type)>=wavefunctions informations for wavelets.
!!  xred(3,natom)=reduced dimensionless atomic coordinates (in fact IN but here
!!                because of INOUT xredxcart() behavior).
!!
!! PARENTS
!!      vtorho
!!
!! CHILDREN
!!      applylocpotkinall,applyprojectorsall,daxpy,diisstp,leave_new
!!      mpi_allreduce,orthoconstraint,orthoconstraint_p,orthon,orthon_p
!!      preconditionall,solveks,sumrho,transallwaves,untransallwaves,wrtout
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine wvl_vtorho(dtset, energies, istep, mpi_enreg, &
     & occ, psps, residm, rhor, rprimd, vtrial, wvl, xred)

  use defs_basis
  use defs_datatypes
 use defs_abitypes
  use defs_wvltypes
#if defined HAVE_BIGDFT
  use BigDFT_API, only : HamiltonianApplication, hpsitopsi, locreg_descriptors, create_Glr
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_16_hideleave
 use interfaces_42_geometry
 use interfaces_67_common
!End of the abilint section

  implicit none

!Arguments -------------------------------
  type(dataset_type), intent(inout)      :: dtset
  type(energies_type), intent(inout)     :: energies
  integer, intent(in)                    :: istep
  type(MPI_type), intent(in)             :: mpi_enreg
  type(pseudopotential_type), intent(in) :: psps
  real(dp), intent(inout)                :: residm
  type(wvl_data), intent(inout)          :: wvl
  real(dp), intent(in)                   :: occ(dtset%mband * dtset%nsppol)
  real(dp), intent(inout)                :: rhor(dtset%nfft)
  real(dp), intent(in)                   :: rprimd(3, 3)
  real(dp), intent(in)                   :: vtrial(dtset%nfft * dtset%nspden)
  real(dp), intent(inout)                :: xred(3, dtset%natom)

!Local variables-------------------------------
  real(dp), save        :: alpha, etotal_local, etotal_min
  integer, save         :: ids
  character(len = 500)  :: message
  real(dp)              :: epot_sum, ekin_sum, eproj_sum, etotal
  real(dp)              :: scprsum
  integer               :: vtrial_shift, ia, igeo
  real(dp), allocatable :: xcart(:, :), gxyz(:, :)
  character(len = 1)    :: bndcode
  
#if defined HAVE_BIGDFT
  type(locreg_descriptors) :: ld
#endif

  if (dtset%icoulomb == 0) then
     bndcode = 'P'
  else if (dtset%icoulomb == 1) then
     bndcode = 'F'
  else if (dtset%icoulomb == 2) then
     bndcode = 'S'
  end if

#if defined HAVE_BIGDFT

  write(message, '(a,a)' ) ch10,&
    &  ' wvl_vtorho: compute the new density from the trial potential.'
  call wrtout(6,message,'COLL')

  ! Initialisation of mixing parameter alpha
  if (istep == 1) then
    alpha        = real(1., dp)
    etotal_min   = real(1.d100, dp)
    etotal_local = real(1.d100, dp)
    ids          = dtset%nwfshist

    ! We allocate the DIIS arrays if necessary.
    if (dtset%nwfshist > 0) then
       allocate(wvl%wfs%psidst(wvl%wfs%mvctrp * wvl%wfs%mbandp * mpi_enreg%nproc * dtset%nwfshist))
       allocate(wvl%wfs%hpsidst(wvl%wfs%mvctrp * wvl%wfs%mbandp * mpi_enreg%nproc * dtset%nwfshist))
       allocate(wvl%wfs%ads(dtset%nwfshist + 1, dtset%nwfshist + 1, 3))
       wvl%wfs%ads = zero
    end if
  end if 

  !Store xcart for each atom
  allocate(xcart(3, dtset%natom))
  call xredxcart(dtset%natom, 1, rprimd, xcart, xred)

  call create_Glr(bndcode, dtset%wvl%n(1), dtset%wvl%n(2), dtset%wvl%n(3), &
       & dtset%wvl%fGrid(1, 1), dtset%wvl%fGrid(1, 2), &
       & dtset%wvl%fGrid(1, 3), dtset%wvl%fGrid(2, 1), &
       & dtset%wvl%fGrid(2, 2), dtset%wvl%fGrid(2, 3), &
       & dtset%wvl%ni(1), dtset%wvl%ni(2), dtset%wvl%ni(3), &
       & wvl%wfs%keys, wvl%wfs%bounds, ld)

  ! Apply vtrial and the projectors to the wavefubctions, computing HPsi.
  vtrial_shift = 1 + dtset%wvl%ni(1) * dtset%wvl%ni(2) * &
       & mpi_enreg%nscatterarr(mpi_enreg%me, 4)
  call HamiltonianApplication(mpi_enreg%me, mpi_enreg%nproc, &
       & dtset%wvl%atoms, dtset%wvl%h(1), dtset%wvl%h(2), dtset%wvl%h(3),&
       & xcart, dtset%wvl_cpmult, dtset%wvl_fpmult, psps%gth_params%radii_cf, &
       & wvl%wfs%nstates, wvl%wfs%mbandp, occ, wvl%projectors%keys, &
       & wvl%projectors%proj, ld, mpi_enreg%ngatherarr, &
       & dtset%wvl%ni(1) * dtset%wvl%ni(2) * mpi_enreg%nscatterarr(mpi_enreg%me, 2), &
       & vtrial(vtrial_shift), wvl%wfs%psi, &
       & wvl%wfs%hpsi, ekin_sum, epot_sum, eproj_sum, dtset%nsppol, dtset%nspinor, &
       & wvl%wfs%spinar, .false.)

  deallocate(xcart)

  ! WARNING! e_hartree is taken from the previous iteration as e_xc
  ! Update physical values
  energies%e_kinetic = ekin_sum
  energies%e_localpsp = epot_sum - real(2., dp) * energies%e_hartree
  energies%e_nonlocalpsp = eproj_sum
  energies%e_corepsp = real(0., dp)
  etotal = energies%e_kinetic + energies%e_localpsp + energies%e_nonlocalpsp + &
         & energies%e_hartree + energies%e_xc - energies%e_vxc + &
         & energies%e_ewald + energies%e_corepsp

  ! Precondition, minimise (DIIS or steepest descent) and ortho.
  ! Compute also the norm of the gradient.
  call hpsitopsi(mpi_enreg%me, mpi_enreg%nproc, wvl%wfs%nstates, &
       & wvl%wfs%mbandp, occ, dtset%wvl%h(1), dtset%wvl%h(2), dtset%wvl%h(3), &
       & wvl%wfs%mvctrp, ld, wvl%wfs%eval, dtset%wvl_nprccg, istep, &
       & dtset%nwfshist, ids, wvl%wfs%ads, etotal, etotal_local, etotal_min, &
       & alpha, residm, scprsum, wvl%wfs%psi, wvl%wfs%psit, wvl%wfs%hpsi, &
       & wvl%wfs%psidst, wvl%wfs%hpsidst, &
       & dtset%nsppol, dtset%nspinor, wvl%wfs%spinar, .false.)
  etotal_local = etotal

  ! Density from wavefunctions.
  call wvl_mkrho(dtset, mpi_enreg, occ, rhor, wvl%wfs)
  
  ! Debugging messages
  write(message, '(1x,a,3(1x,1pe18.11))') 'ekin_sum,epot_sum,eproj_sum', & 
       & ekin_sum,epot_sum,eproj_sum
  call wrtout(06, message, 'COLL')
  write(message, '(1x,a,3(1x,1pe18.11))') '   ehart,   eexcu,    vexcu', &
       & energies%e_hartree,energies%e_xc,energies%e_vxc
  call wrtout(06, message, 'COLL')
  write(message, '(1x,a,i6,2x,1pe19.12,1x,1pe9.2)') 'iter,total energy,gnrm', &
       & istep,etotal,residm
  call wrtout(06, message, 'COLL')

#else
  write(message, '(a,a,a,a)' ) ch10,&
    &  ' wvl_vtorho : BigDFT library is not compiled.', ch10, &
    &  '   Action, used the flag --enable-bigdft when configuring.'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
#endif
end subroutine wvl_vtorho
!!***
