!{\src2tex{textfont=tt}}
!!****p* ABINIT/mrgscr
!! NAME
!! mrgscr
!!
!! FUNCTION
!! This code reads partial (SCR|SUSC) files for different q points creating a single file that
!! can be used to perform a sigma calculation. 
!!
!! COPYRIGHT
!! Copyright (C) 2005-2009 ABINIT group (R.Shaltaf, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  (Main program)
!!
!! OUTPUT
!!  Only checking and writing
!! 
!! NOTES
!! If the number of SCR files to be merged is equal to 1, the program checks 
!! the integrity of the file reporting the list of missing q-points.
!! Note that the list of required q-points depends on the k-mesh 
!! used during the calculation of the KSS file. We assume indeed that the same k-mesh 
!! is used during the calculation of the matrix elements of sigma.
!!
!! PARENTS
!!
!! CHILDREN
!!      assert,decompose_epsm1,destroy_bz_mesh_type,destroy_coulombian
!!      destroy_epsilonm1_results,destroy_gpairs_type,destroy_gvectors
!!      destroy_ppmodel,destroycrystal,find_qmesh,fourdp,free_scrhdr
!!      get_ppm_eigenvalues,get_rhor,getem1_from_ppm,getng,herald
!!      init_er_from_file,init_gpairs_type,init_gvectors_type,init_ppmodel
!!      initcrystalfromhdr,initkmesh,initmpi_seq,int2char4,isfile,merge_scrhdr
!!      metric,mkdump_er,my_gwannier,nullify_epsilonm1_results
!!      nullify_gpairs_type,print_epsilonm1_results,print_scrhdr,prompt
!!      read_screening,scr_hdr_io,setup_coulombian,setup_ppmodel,test_charge
!!      write_screening,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

program mrgscr

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_build_info
 use m_errors

 use m_gwdefs,         only : GW_TOLQ, GW_TOLQ0
 use m_io_tools,       only : prompt, get_unit
 use m_header,         only : hdr_get_nelect_byocc
 use m_geometry,       only : normv
 use m_crystal,        only : initcrystalfromhdr , destroycrystal
 use m_gsphere,        only : init_gvectors_type, destroy_Gvectors, nullify_Gpairs_type, destroy_Gpairs_type, init_Gpairs_type
 use m_bz_mesh,        only : find_Qmesh, initkmesh, destroy_bz_mesh_type
 use m_coulombian,     only : setup_coulombian, destroy_coulombian
 use m_io_screening,   only : scr_hdr_io, print_scrhdr, merge_scrhdr, read_screening, write_screening, free_scrhdr
 use m_ppmodel,        only : init_PPmodel, destroy_PPmodel, setup_ppmodel, getem1_from_PPm, get_PPm_eigenvalues
 use m_gwannier,       only : my_gwannier
 use m_screening

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
 use interfaces_14_hidewrite
 use interfaces_27_toolbox_oop
 use interfaces_32_util
 use interfaces_42_geometry
 use interfaces_51_manage_mpi
 use interfaces_53_ffts
 use interfaces_56_recipspace
 use interfaces_68_gw
!End of the abilint section

 implicit none

!Arguments -----------------------------------

!Local variables-------------------------------
!scalars
 integer,parameter :: localrdwf=0,spaceComm=abinit_comm_serial,master=0,paral_kgb=0
 integer :: accesswff,fform,fform1,fform_merge,ifile,ifound,ii,ios,iqiA,iqibz,iqf,istat,jj
 integer :: nfiles,nomega4m,npwe4m,rdwr,restart,restartpaw,timrev,prtvol=0,unt_out,unitem1
 integer :: iqask,unt_dump,idx,igpair,ig1,ig2,iomega,ppmodel,npwe_asked,mqmem
 integer :: id_required,ikxc,approx_type,option_test,dim_kxcg
 integer :: usexcnhat,usefinegrid,ippmodel,ppmx,ichk
 integer :: mgfft,nqlwl,nfft,igmax
 real(dp) :: ucvol,boxcutmin,ecut,drude_plsmf,compch_fft,compch_sph
 real(dp) :: nelectron_exp
 logical :: is_old,ltest
 character(len=4) :: tagq,tagw
 character(len=24) :: codename
 character(len=500) :: msg
 character(len=fnlen) :: fname_out,fname,fname_dump,fname_rho,prefix
 type(ScrHdr_type),pointer :: Hscr0
 type(ScrHdr_type),target :: Hscr_merge
 type(MPI_type) :: MPI_enreg_seq
 type(BZ_mesh_type) :: Kmesh,Qmesh
 type(Crystal_structure) :: Cryst
 type(Gpairs_type) :: Gpairs_q 
 type(Gvectors_type)  :: Gsphere
 type(PPmodel_type) :: PPm
 type(Epsilonm1_results) :: Er
 type(Coulombian_type) :: Vcp
 type(Dataset_type) :: Dtset
 type(Datafiles_type) :: Dtfil
!arrays
 integer :: ngfft(18)
 integer,allocatable :: merge_table(:,:),foundq(:)
 integer,pointer :: gptab(:,:),gptabo(:,:),ip2fp(:,:)
 real(dp) :: gmet(3,3),gprimd(3,3),qdiff(3),rmet(3,3),qtmp(3)
 real(dp),allocatable :: qlwl(:,:)
 real(dp),allocatable :: rhor(:,:),rhog(:,:),nhat(:,:)
 complex(gwpc),allocatable :: epsm1(:,:,:,:),kxcg(:,:) 
 complex(dpc),allocatable :: em1_ppm(:,:,:),epsm1_eigen(:,:),ppm_eigen(:,:)
 character(len=fnlen),allocatable :: filenames(:)
 type(ScrHdr_type),target,allocatable :: Hscr_file(:)

! *************************************************************************

!* Init fake MPI type with values for sequential case.
 call initmpi_seq(MPI_enreg_seq)

!=== Write greetings, and read the number of files ===
 codename='MRGSCR'//REPEAT(' ',18)
 call herald(codename,abinit_version,std_out)
!YP: calling dump_config() makes tests fail => commented
!call dump_config()

 call prompt(' Enter the number of files to merge: ',nfiles)
!call assert((nfiles>0),'The number of files must be >0')
 if (nfiles<0 ) then 
  call my_GWannier()
 end if

 allocate(filenames(nfiles),Hscr_file(nfiles))

 if (nfiles==1) then
! === Single mode ===
  call prompt(' Enter the name of the file to be analyzed: ',filenames(1))
  write(msg,'(7a)')ch10,&
  ' Running single-file mode:',ch10,&
&  ' Checking the integrity of file: ',TRIM(filenames(1)),ch10,&
&  ' reporting the list of q-points that are missing. '
  call wrtout(std_out,msg,'COLL')

 else if (nfiles>1) then
! === Read name of files to be merged and check for existence ===
  call prompt(' Enter the prefix for the final output file: ',fname_out)

! TODO this should depend on the content (SCR|SUSC)
  fname_out=TRIM(fname_out)//'_SCR'
  call isfile(fname_out,'new')

  do ifile=1,nfiles
   write(msg,'(a,i4)')' Enter the name for the partial screening file no.',ifile
   call prompt(msg,filenames(ifile))

   inquire(file=filenames(ifile),exist=is_old)
   if (.not.is_old) then
    write(msg,'(3a)')' File ',TRIM(filenames(ifile)),' does not exist. '
    MSG_ERROR(msg)
   end if
  end do
 end if
!
!=== Read the header of each file ===
 do ifile=1,nfiles
  unitem1=get_unit()
  open(unit=unitem1,file=filenames(ifile),status='old',form='unformatted',iostat=ios)
  if (ios/=0) then 
   write(msg,'(3a)')' Opening file ',TRIM(filenames(ifile)),' as old-unformatted '
   MSG_ERROR(msg)
  end if  

! TODO this should initialized by the user 
  accesswff=0 

  rdwr=1 
  call scr_hdr_io(fform1,rdwr,unitem1,spaceComm,master,accesswff,localrdwf,Hscr_file(ifile))
  if (fform1/=1002) then
   write(msg,'(a,i5)')'Error while reading ScrHdr, fform/=1002, ',fform1
   MSG_ERROR(msg)
  end if

! rdwr=4 ; call scr_hdr_io(fform,rdwr,std_out,spaceComm,master,accesswff,localrdwf,Hscr_file(ifile))
  close(unitem1)

  call print_ScrHdr(Hscr_file(ifile),unit=std_out,prtvol=1)

  if (ifile==1) then 
   call metric(gmet,gprimd,-1,rmet,Hscr_file(ifile)%Hdr%rprimd,ucvol)
  end if
 end do !ifile

!============================
!=== Merge multiple files ===
!============================
 if (nfiles>1) then

! * Merge the headers creating the full list of q-points.
  call merge_ScrHdr(Hscr_file,Hscr_merge)
  call print_ScrHdr(Hscr_merge,header='Header of the final file',unit=std_out,prtvol=1)

! For each q to be merged, save the index of the file where q is stored as well as its sequential index. 
! Useful to do the merge point-by-point thus avoiding the allocation of the entire epsm1 array.
  allocate(merge_table(Hscr_merge%nqibz,2)) 
  do iqibz=1,Hscr_merge%nqibz
   ifound=0
   fl: do ifile=1,nfiles
    do iqf=1,Hscr_file(ifile)%nqibz
     qdiff(:)=Hscr_merge%qibz(:,iqibz)-Hscr_file(ifile)%qibz(:,iqf)
     if (normv(qdiff,gmet,'G')<GW_TOLQ) then
      merge_table(iqibz,1)=ifile
      merge_table(iqibz,2)=iqf
      ifound=ifound+1
      write(msg,'(a,3f12.6,2a)')' q-point :',Hscr_merge%qibz(:,iqibz),' will be taken from ',TRIM(filenames(ifile)) 
      call wrtout(std_out,msg,'COLL')
      EXIT fl
     end if
    end do
   end do fl
!  Check if point has been found, multiple points not allowed.
   ABI_CHECK(ifound==1,'ifound/=1')
  end do

  unt_out=get_unit()
  open(unit=unt_out,file=fname_out,status='new',form='unformatted',iostat=ios)
  if (ios/=0) then 
   write(msg,'(3a)')' Opening file ',TRIM(fname_out),' as new-unformatted'
   MSG_ERROR(msg)
  end if  

! * Write the header.
! TODO Use new format but first of all fix problem with hdr_check
  rdwr=2 ; fform_merge=1002 
  call scr_hdr_io(fform_merge,rdwr,unt_out,spaceComm,master,accesswff,localrdwf,Hscr_merge)

  npwe4m   = Hscr_merge%npwe
  nomega4m = Hscr_merge%nomega

  allocate(epsm1(npwe4m,npwe4m,nomega4m,1), STAT=istat)
  ABI_CHECK(istat==0,'out of memory in epsm1')

  do iqibz=1,Hscr_merge%nqibz
   ifile=merge_table(iqibz,1)
   iqiA =merge_table(iqibz,2)
   fname=filenames(ifile)
   call read_screening(fname,npwe4m,1,nomega4m,epsm1,MPI_enreg_seq,accesswff,localrdwf,iqiA=iqiA)
   call write_screening(unt_out,accesswff,npwe4m,nomega4m,Hscr_merge%omega,epsm1)
  end do

  deallocate(epsm1,merge_table)
  close(unt_out)
  write(msg,'(3a)')ch10,' ==== Files have been merged successfully === ',ch10
  call wrtout(std_out,msg,'COLL')
 end if ! nfiles>1

!=== Now check if the list of q-points is complete ===
!* Here we assume that the k-mesh reported in the header is the same as
!that used during the sigma calculation.
 write(msg,'(3a)')ch10,' Checking if the list of q-points is complete. ',ch10
 call wrtout(std_out,msg,'COLL')

 Hscr0 => Hscr_file(1)
 fname =filenames(1)
 if (nfiles>1) then 
  Hscr0 => Hscr_merge
  fname =fname_out
 end if

 timrev=2 ! This should be read from kptopt
 call InitCrystalFromHdr(HScr0%Hdr,Cryst,timrev,remove_inv=.FALSE.)

 call InitKmesh(HScr0%Hdr%nkpt,Hscr0%Hdr%kptns,Cryst,Kmesh,prtvol)

 call find_Qmesh(Cryst,Kmesh,Qmesh,prtvol)
 
 allocate(foundq(Qmesh%nibz)) ; foundq(:)=0
 do iqibz=1,Qmesh%nibz
  do iqf=1,Hscr0%nqibz
   qdiff(:)=Qmesh%ibz(:,iqibz)-Hscr0%qibz(:,iqf)
   if (normv(qdiff,gmet,'G')<GW_TOLQ) foundq(iqibz)=foundq(iqibz)+1
  end do
 end do

 if (ANY(foundq(:)==0)) then
  write(msg,'(6a)')ch10,&
&  ' File ',TRIM(fname),' is not complete ',ch10,&
&  ' The following q-points are missing :'
  call wrtout(std_out,msg,'COLL')
  ii=0
  do iqibz=1,Qmesh%nibz
   if (foundq(iqibz)==0) then 
    ii=ii+1
    write(msg,'(i3,a,3f12.6)')ii,') ',Qmesh%ibz(:,iqibz)
    call wrtout(std_out,msg,'COLL')
   end if
  end do
 end if

 if (ANY(foundq(:)>1)) then
  write(msg,'(6a)')ch10,&
&  ' File ',TRIM(fname),' is overcomplete ',ch10,&
&  ' The following q-points are present more than once :'
  call wrtout(std_out,msg,'COLL')
  ii=0
  do iqibz=1,Qmesh%nibz
   if (foundq(iqibz)>1) then 
    ii=ii+1
    write(msg,'(i3,a,3f12.6)')ii,') ',Qmesh%ibz(:,iqibz)
    call wrtout(std_out,msg,'COLL')
   end if
  end do
 end if

 if (ALL(foundq(:)==1)) then
  write(msg,'(5a)')ch10,&
&  ' File ',TRIM(fname),' contains a complete list of q-points ',ch10
  call wrtout(std_out,msg,'COLL')
 end if

!This part analyzes the SCR file.
 if (.FALSE.) then 

! === Initialize the G-sphere ===
  call init_Gvectors_type(.FALSE.,Gsphere,Cryst,Hscr0%npwe,Hscr0%gvec,Cryst%gmet,Cryst%gprimd)

  call nullify_Gpairs_type(Gpairs_q)

  allocate(epsm1(Hscr0%npwe,Hscr0%npwe,Hscr0%nomega,1),STAT=istat)
  if (istat/=0) STOP 'out of memory in epsm1'

! do iqibz=1,Hscr0%nqibz
  do iqibz=1,0

!  === Find the independent set of G-Gp pairs for this q-point. ===
!  * In the long wavelength limit we set q==0, because we still can use symmetryes for the Body.
   qtmp(:)=Hscr0%qibz(:,iqibz) ; if (normv(qtmp,Cryst%gmet,'G')<GW_TOLQ0) qtmp(:)=zero
   call init_Gpairs_type(Gpairs_q,qtmp,Gsphere,Cryst)

   call read_screening(fname,Hscr0%npwe,1,Hscr0%nomega,epsm1,MPI_enreg_seq,accesswff,localrdwf,iqiA=iqibz)

!  * Dump results
   call int2char4(iqibz,tagq)
   fname_dump=TRIM(fname)//'_Q'//TRIM(tagq) ; unt_dump=get_unit()
   open(file=fname_dump,unit=unt_dump,status='new',form='formatted',iostat=ios)

   idx=0
   do igpair=1,Gpairs_q%niggp
    if (igpair>50.and.igpair<=Gpairs_q%niggp-50) CYCLE ! By default only first and last 50 pairs are printed
    ig1 = Gpairs_q%ip2fp(1,igpair)
    ig2 = Gpairs_q%ip2fp(2,igpair)
    idx=idx+1
    write(unt_dump,'(a,i4,a,i8,/,a,3f12.6,/,a,3i6,a,3i6,/,a,/)')&
&    '# index= ',idx,' pair number = ',igpair,&
&    '# q = ',Hscr0%qibz(:,iqibz),&
&    '# G = ',Hscr0%gvec(:,ig1),'  G''= ',Hscr0%gvec(:,ig2),&
&    '#   omega [eV]           Re             Im ' 
    do iomega=1,Hscr0%nomega
     if (ABS(AIMAG(Hscr0%omega(iomega)))>tol8) EXIT !only real frequencies
     write(unt_dump,'(f8.2,4x,2es16.8)')REAL(Hscr0%omega(iomega))*Ha_eV,epsm1(ig1,ig2,iomega,1)
    end do
    write(unt_dump,*)
    write(unt_dump,*)
   end do

   close(unt_dump)
  end do !iqibz

  deallocate(epsm1)

  call destroy_Gpairs_type(Gpairs_q)

  if (.FALSE.) then
!  === This part performs a postprocessing of the SCR|SUSC file.  
   
!  === Make PPM parameters ===

   npwe_asked=Hscr0%npwe ; mqmem=Hscr0%nqibz
   call nullify_epsilonm1_results(Er)
   call init_Er_from_file(Er,fname,mqmem,npwe_asked,accesswff,localrdwf,MPI_enreg_seq)

   boxcutmin=two ; igmax=Gsphere%shlim(Gsphere%nsh)
   ecut=normv(Gsphere%gvec(:,igmax),Gsphere%gmet,'G') !TODO migh be an attribute of Gsphere

   call getng(boxcutmin,ecut,Gsphere%gmet,MPI_enreg_seq%me_fft,mgfft,nfft,ngfft,MPI_enreg_seq%nproc_fft,&
&   Cryst%nsym,MPI_enreg_seq%fft_option_lob,MPI_enreg_seq%paral_fft,Cryst%symrel)

!  I am using standard valued, it would be better to call indefo
   ngfft(7)=112
   ngfft(8)=256     ! Was optimized for my PII 450MHz

   Dtset%icutcoul=3 ; Dtset%rcut=zero 
   Dtset%vcutgeo=(/zero,zero,zero/) ; Dtset%boxcenter=(/zero,zero,zero/)

   nqlwl=0
   allocate(qlwl(3,nqlwl))
   call setup_coulombian(Dtset,Gsphere,Qmesh,Kmesh,Hscr0%npwe,nqlwl,qlwl,Cryst%rprimd,ngfft,MPI_enreg_seq,Vcp)
   deallocate(qlwl)

!  === Get the density from an external file === 
!  * If meshes are not the same, do a FFT interpolation to have rhor on ngfft.

   call prompt(' Enter name for external DEN file: ',fname_rho)

   allocate(rhor(nfft,Hscr0%Hdr%nspden)) 
   call get_rhor(fname_rho,accesswff,localrdwf,Hscr0%Hdr%nspden,nfft,ngfft,paral_kgb,MPI_enreg_seq,rhor)

   allocate(rhog(2,nfft)) 
   call fourdp(1,rhog,rhor(:,1),-1,MPI_enreg_seq,nfft,ngfft,paral_kgb,0)

   allocate(nhat(nfft,Hscr0%Hdr%nspden*Hscr0%Hdr%usepaw))
   compch_sph=greatest_real ; compch_fft=greatest_real
   call assert((Hscr0%Hdr%usepaw==0),'PAW not implemented',__FILE__,__LINE__)
   usexcnhat=0 ; usefinegrid=0

   nelectron_exp = hdr_get_nelect_byocc(Hscr0%Hdr)

   call test_charge(nfft,nelectron_exp,Hscr0%Hdr%nspden,rhor,Cryst%ucvol,nhat,&
&   Hscr0%Hdr%usepaw,usexcnhat,usefinegrid,compch_sph,compch_fft,drude_plsmf)

!  * Read and in case make Epsilon^{-1} according the the options specified
   id_required=4 ; ikxc=0 ; approx_type=0 ; option_test=0 ; dim_kxcg=0 
   allocate(kxcg(Er%npwe,Er%npwe*dim_kxcg))

   call prompt(' Enter prefix for output files: ',prefix)

!  TODO get rid of Dtfil
   fname_dump=TRIM(prefix)//'_SCR'
   Dtfil%filnam_ds(4)=prefix

   call mkdump_Er(Er,Vcp,dim_kxcg,kxcg,Dtfil,id_required,approx_type,ikxc,option_test,&
&   fname_dump,accesswff,localrdwf,MPI_enreg_seq)

   call print_epsilonm1_results(Er)

   allocate(epsm1_eigen(Er%npwe,Er%nomega))
   do iqibz=1,1 !, Er%nqibz !comment this for more q-points
    call decompose_epsm1(Er,iqibz,epsm1_eigen)
    write(100,*)' REAL omega [eV] , REAL (eigen(esp^-1)) AIMAG ' 
    do iomega=1,Er%nomega_r
!    write only the lowest eigenvalue
     write(100,'(3(es16.8))')REAL(Er%omega(iomega))*Ha_eV,REAL(epsm1_eigen(1,iomega)),AIMAG(epsm1_eigen(1,iomega))
    end do
   end do
   deallocate(epsm1_eigen)
   
   ichk=2

!  do iomega=1,Er%nomega_r
!  write(100,'((3es16.8))')&
!  & REAL(Er%omega(iomega))*Ha_eV,REAL(Er%epsm1(ichk,ichk,iomega,2))
!  end do

   deallocate(kxcg)

!  === Analyze the PPmodel ===
   ppmx=4

   do ippmodel=1,ppmx

    ppmodel=ippmodel
    call init_PPmodel(PPm,Er,ppmodel,drude_plsmf,0)

    call setup_ppmodel(PPm,paral_kgb,Qmesh,Er,MPI_enreg_seq,nfft,&
&    Gsphere%gvec,ngfft,Gsphere%gmet,Gsphere%gprimd,rhor(:,1))

    allocate(ppm_eigen(PPm%npwc,Er%nomega))

    do iqibz=1,1 !Er%nqibz
     call get_PPm_eigenvalues(PPm,iqibz,Er%Hscr%zcut,Er%nomega,Er%omega,Vcp,ppm_eigen)
     write(ippmodel*10,*)' Real(omega) [eV] , Real(ppm_eigen[1]) Aimag'
     do iomega=1,Er%nomega_r
      write(ippmodel*10,'(3(es16.8))')REAL(Er%omega(iomega))*Ha_eV,REAL(ppm_eigen(1,iomega)),AIMAG(ppm_eigen(1,iomega))
!     write only the lowest eigenvalue
     end do
    end do

    deallocate(ppm_eigen)

    if (.FALSE.) then
!    Reconstruct e^{-1}_GG'(w) according to PPmodel for statistical analysis.
     allocate(em1_ppm(Er%npwe,Er%npwe,Er%nomega_r))
     do iqibz=1,0 !2,2 !Er%nqibz
      call getem1_from_PPm(PPm,iqibz,Er%Hscr%zcut,Er%nomega_r,Er%omega,Vcp,em1_ppm)
      do iomega=1,Er%nomega_r
!      write(ippmodel*20,'((3es16.8))')REAL(Er%omega(iomega))*Ha_eV,REAL(em1_ppm(ichk,ichk,iomega))
      end do
     end do
     deallocate(em1_ppm)
    end if

    call destroy_PPmodel(PPm)

   end do !End loop over ippmodel


   deallocate(rhor,rhog)
   deallocate(nhat)

   call destroy_Coulombian(Vcp) 
   call destroy_Epsilonm1_results(Er)
   print*,'done'

  end if !FALSE

  call destroy_Gvectors(Gsphere)

 end if !FALSE

!=== Free memory ===
 call DestroyCrystal(Cryst)
 call destroy_BZ_mesh_type(Kmesh)
 call destroy_BZ_mesh_type(Qmesh)

 nullify(Hscr0)
 if (nfiles>1) then  
  call free_scrhdr(Hscr_merge)
 end if
 do ifile=1,nfiles
  call free_scrhdr(Hscr_file(ifile))
 end do
 deallocate(Hscr_file)
 deallocate(filenames)

 end program mrgscr
!!***
