!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_dij0
!! NAME
!! calc_dij0
!!
!! FUNCTION
!! Compute "frozen" values of Dij = Dij0
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  pawarray
!!    %indlmn(6,lmn_size)= Gives l,m,n,lm,ln,s for i=lmn
!!    %kij(lmn2_size)= Kinetic overlap operator
!!    %shapefunc(wav_meshsz)= Normalized shape function
!!  pawps
!!    %coreden4pr2(core_meshsz)= Core density multiplied by 4Pi.r2
!!    %phi(wav_meshsz,basis_size)= PAW atomic wavefunctions on the radial grid
!!    %tphi(wav_meshsz,basis_size)= PAW atomic pseudo-wavefunctions on the radial grid
!!    %vhtnzc(core_meshsz)= Hartree potential of the ps-density
!!                          of the nucleus + core electrons
!!  pawrad= radial grid definitions
!!  pshead
!!    %atomic_charge= Total atomic charge
!!    %core_meshsz= Dimension of radial mesh for core density
!!    %lmn_size= Number of elements for the paw basis
!!    %lmn2_size=pshead%lmn_size*(pshead%lmn_size+1)/2
!!    %sph_meshsz= Dimension of radial mesh corresponding to PAW spheres
!!    %vlocopt= Option for Vloc
!!
!! OUTPUT
!!  pawps
!!    %dij0(lmn2_size)= Frozen part of the Dij term
!!
!! PARENTS
!!      atompaw2abinit
!!
!! CHILDREN
!!      csimp
!!
!! SOURCE

 subroutine calc_dij0(pawarray,pawps,pawrad,pshead)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ---------------------------------------------
 type(pawarray_type) :: pawarray
 type(pawps_type)    :: pawps
 type(pawrad_type)   :: pawrad
 type(pshead_type)   :: pshead

!Local variables ---------------------------------------
 integer :: il,ilm,iln,ilmn,j0lmn,jl,jlm,jln,jlmn,klmn,meshsz
 real(dp) :: intg,intvh
 real(dp),allocatable :: ff(:),vhnzc(:)

!-------------------------------------------------------

 meshsz=pshead%sph_meshsz
 allocate(ff(meshsz))

!Kinetic part of Dij0
!====================
 pawps%dij0(1:pshead%lmn2_size)=pawarray%kij(1:pshead%lmn2_size)

!Computation of <phi_i|vh(nZc)|phi_j>
!====================================
 allocate(vhnzc(pshead%core_meshsz))
 call poisson(pawps%coreden4pr2,pshead%core_meshsz,pawrad,vhnzc)
 vhnzc(2:pshead%core_meshsz)=(vhnzc(2:pshead%core_meshsz)-pshead%atomic_charge)/pawrad%rad(2:pshead%core_meshsz)
 call deducer0(vhnzc,pawrad)
 do jlmn=1,pshead%lmn_size
  j0lmn=jlmn*(jlmn-1)/2
  jlm=pawarray%indlmn(4,jlmn);jln=pawarray%indlmn(5,jlmn)
  do ilmn=1,jlmn
   klmn=j0lmn+ilmn
   ilm=pawarray%indlmn(4,ilmn);iln=pawarray%indlmn(5,ilmn)
   if (jlm==ilm) then
    ff(1:meshsz)=pawps%phi(1:meshsz,iln)*pawps%phi(1:meshsz,jln)*vhnzc(1:meshsz)
    call csimp(ff,pawrad,meshsz,intg)
    pawps%dij0(klmn)=pawps%dij0(klmn)+intg
   endif
  enddo
 enddo
 deallocate(vhnzc)

!Computation of <tphi_i|vh(tnZc)|tphi_j>
!=======================================
 if (pshead%vlocopt==1) then
  do jlmn=1,pshead%lmn_size
   j0lmn=jlmn*(jlmn-1)/2
   jlm=pawarray%indlmn(4,jlmn);jln=pawarray%indlmn(5,jlmn)
   do ilmn=1,jlmn
    klmn=j0lmn+ilmn
    ilm=pawarray%indlmn(4,ilmn);iln=pawarray%indlmn(5,ilmn)
    if (jlm==ilm) then
     ff(1:meshsz)=pawps%tphi(1:meshsz,iln)*pawps%tphi(1:meshsz,jln)*pawps%vhtnzc(1:meshsz)
     call csimp(ff,pawrad,meshsz,intg)
     pawps%dij0(klmn)=pawps%dij0(klmn)-intg
    endif
   enddo
  enddo
 endif

!Computation of int[vh(tnzc)*Qijhat(r)dr]
!========================================
 if (pshead%vlocopt==1) then
  ff(1:meshsz)=pawps%vhtnzc(1:meshsz)*pawarray%shapefunc(1:meshsz)*pawrad%rad(1:meshsz)**2
  call csimp(ff,pawrad,meshsz,intvh)
  do jlmn=1,pshead%lmn_size
   j0lmn=jlmn*(jlmn-1)/2
   jl=pawarray%indlmn(1,jlmn);jln=pawarray%indlmn(5,jlmn);jlm=pawarray%indlmn(4,jlmn)
   do ilmn=1,jlmn
    klmn=j0lmn+ilmn
    il=pawarray%indlmn(1,ilmn);iln=pawarray%indlmn(5,ilmn);ilm=pawarray%indlmn(4,ilmn)
    if (ilm==jlm) then
     ff(1:meshsz)=(pawps%phi (1:meshsz,iln)*pawps%phi (1:meshsz,jln)&
&                 -pawps%tphi(1:meshsz,iln)*pawps%tphi(1:meshsz,jln))
     call csimp(ff,pawrad,meshsz,intg)
     pawps%dij0(klmn)=pawps%dij0(klmn)-intvh*intg
    endif
   enddo
  enddo
 endif

 deallocate(ff)

 end subroutine
!!***
