!{\src2tex{textfont=tt}}
!!****f* ABINIT/csimp
!! NAME
!! csimp
!!
!! FUNCTION
!! Do integral using corrected Simpson rule (on a linear or logarithmic grid)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  ff(meshsz)=integrand values
!!  meshsz=size of radial mesh for integration
!!  pawrad
!!    %rstep= Logarithmic step corresponding to radial mesh
!!    %lstep= Logarithmic step corresponding to radial mesh
!!    %radfact(max_meshsz)= Factor used to compute radial integrals on generalized grid
!!
!! OUTPUT
!!  simp=resulting integral by corrected Simpson rule
!!
!! PARENTS
!!      calc_dij0,calc_valden,calc_shapef
!!
!! CHILDREN
!!
!! SOURCE

 subroutine csimp(ff,pawrad,meshsz,simp)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ------------------------------------
 integer :: meshsz
 real(dp) :: simp
 real(dp) :: ff(meshsz)
 type(pawrad_type) :: pawrad

!Local variables-------------------------------
 real(dp),parameter :: eps=tol14**4
 integer :: ii,nn
 real(dp) :: hh,simp1,simp2,simp4

! *************************************************************************

 if (pawrad%islog==1) then
  hh=pawrad%lstep
 else
  hh=pawrad%rstep
 end if

 ii=meshsz;do while(abs(ff(ii))<eps);ii=ii-1;enddo
 nn=min(ii+1,meshsz)

 if (nn>=5) then

  if (mod(nn,2)==1) then
   simp1=ff(1)*pawrad%radfact(1)+ff(nn)*pawrad%radfact(nn)
   simp2=zero;simp4=ff(2)*pawrad%radfact(2)
   do ii=3,nn-1,2
    simp2=simp2+ff(ii)  *pawrad%radfact(ii)
    simp4=simp4+ff(ii+1)*pawrad%radfact(ii+1)
   enddo
  else
   simp1=1.25d0*ff(1)*pawrad%radfact(1)+3.d0*ff(2)*pawrad%radfact(2) &
&       -0.25d0*ff(3)*pawrad%radfact(3)+ff(nn)*pawrad%radfact(nn)
   simp2=zero;simp4=ff(3)*pawrad%radfact(3)
   do ii=4,nn-1,2
    simp2=simp2+ff(ii)  *pawrad%radfact(ii)
    simp4=simp4+ff(ii+1)*pawrad%radfact(ii+1)
   enddo
  endif
  simp=hh/3.d0*(simp1+two*simp2+four*simp4)

 else if (nn==4) then
  simp=hh*0.375d0*(3.d0*(ff(2)*pawrad%radfact(2)+ff(3)*pawrad%radfact(3)) &
&                 +     (ff(1)*pawrad%radfact(1)+ff(4)*pawrad%radfact(4)))
 else if (nn==3) then
  simp=hh/3.d0*(ff(1)*pawrad%radfact(1)+4.d0*ff(2)*pawrad%radfact(2)+ff(3)*pawrad%radfact(3))
 else if (nn==2) then
  simp=hh*0.5d0*(ff(1)*pawrad%radfact(1)+ff(2)*pawrad%radfact(2))
 else
  simp=zero
 end if

 end subroutine
!!***
