!{\src2tex{textfont=tt}}
!!****f* ABINIT/initmesh
!! NAME
!! initmesh
!!
!! FUNCTION
!! Initialize the radial mesh (here only regular mesh)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  meshsz= Size of radial mesh
!!  radstep= Step of regular radial mesh
!!
!! OUTPUT
!!  pawrad
!!   %meshsz= Size of radial grid
!!   %rad(meshsz)= Coordinates of the radial grid
!!   %radfact(meshsz)= Factors used in Simpson integrals
!!   %lstep= Step corresponding to exponential in log. mesh
!!   %rstep= Step corresponding to radial mesh
!!
!! PARENTS
!!      atompaw2abinit
!!
!! SOURCE

 subroutine initmesh(pawrad,meshsz,meshtype,radstep,logstep)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ---------------------------------------------
 integer :: meshsz,meshtype
 real(dp) :: radstep,logstep
 type(pawrad_type) :: pawrad

!Local variables ---------------------------------------
 integer :: ir

!--------------------------------------------------------

 pawrad%meshsz=meshsz
 pawrad%rstep=radstep

 if (meshtype==1) then
  pawrad%islog=0
  pawrad%lstep=zero
  do ir=1,meshsz
   pawrad%rad(ir)=(ir-1)*radstep
   pawrad%radfact(ir)=one
  enddo
 else
  pawrad%islog=1
  pawrad%lstep=logstep
  do ir=1,meshsz
   pawrad%rad(ir)=radstep*(exp((ir-1)*logstep)-1.d0)
   pawrad%radfact(ir)=pawrad%rad(ir)+radstep
  enddo
 end if

 end subroutine
!!***
