!{\src2tex{textfont=tt}}
!!****f* ABINIT/initpawps
!! NAME
!! initpawps
!!
!! FUNCTION
!! Initialize several quantities
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  pshead
!!    %basis_size= Number of elements for the paw nl basis
!!    %core_meshsz= Dimension of radial mesh for core density
!!    %lmn_size= Number of elements for the paw basis
!!    %mesh_type= type of radial grid (regular or log)
!!    %orbitals(basis_size)= Quantum number l for each basis function
!!    %rc_hat= radius for shape function
!!    %sph_meshsz= Dimension of radial mesh corresponding to PAW spheres
!!    %vale_meshsz= Dimension of radial mesh for pseudo valence density
!!
!! OUTPUT
!!  pawarray
!!    %indlmn(6,lmn_size)= Gives l,m,n,lm,ln,s for i=lmn
!!  pshead
!!    %creatorid= ID of psp generator (here pspfmt=1 !)
!!    %hat_meshsz= Dimension of radial mesh for shape function
!!    %l_size= Max. value of l+1 leading to a non zero Gaunt coeffs
!!    %lmax= Maximum value of l
!!    %lmn2_size= lmn_size*(lmn_size+1)/2
!!    %max_meshsz=  Max. dimension for radial meshes
!!    %prj_msz_max= Maximal dimension of radial mesh for tproj
!!    %pspcod= Psp code number for Abinit (here PAW->pspcod=7 !)
!!    %rc_hat= radius for shape function
!!    %rc_sph= Default PAW sphere radius
!!    %vloc_meshsz= Dimension of radial mesh for vloc=htnzc
!!  version= version number for AtomPAW2Abinit
!!
!! PARENTS
!!      atompaw2abinit
!!
!! SOURCE

 subroutine initpawps(pawarray,pshead,version)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ---------------------------------------------
 type(pawarray_type) :: pawarray
 type(pshead_type) :: pshead
 character*5 :: version

!Local variables ---------------------------------------
 real(dp),parameter :: rmax_vloc=10.d0 !We decide to cut at r=10 u.a because of numeric noise...
 integer :: ii1,ii2,ii3,ib,il,ilm,ilmn,iln,nproj

!--------------------------------------------------------

!Format codes for Abinit pseudopotential
 read(unit=version(1:1),fmt='(i1)') ii1
 read(unit=version(3:3),fmt='(i1)') ii2
 read(unit=version(5:5),fmt='(i1)') ii3
 pshead%creatorid=1000+100*ii1+10*ii2+ii3
 pshead%pspcod=7

!Maximum value for l quantum number
 pshead%lmax=maxval(pshead%orbitals(1:pshead%basis_size))
 pshead%l_size=2*pshead%lmax+1
 pshead%lmn2_size=pshead%lmn_size*(pshead%lmn_size+1)/2

!Radial mesh for PAW spheres
 if (pshead%mesh_type==1) then
  pshead%sph_meshsz=min(1+nint(pshead%rc_sph/pshead%rad_step),pshead%wav_meshsz)
  pshead%rc_sph=pshead%rad_step*dble(pshead%sph_meshsz-1)
 else
  pshead%sph_meshsz=min(1+nint(log(one+pshead%rc_sph/pshead%rad_step)/pshead%log_step),pshead%wav_meshsz)
  pshead%rc_sph=pshead%rad_step*(exp(pshead%log_step*dble(pshead%sph_meshsz-1))-1.d0)
 endif

!Radial mesh for hat density
 if (pshead%rc_hat<0) pshead%rc_hat=pshead%rc_sph
 if (abs(pshead%rc_hat-pshead%rc_sph)<tol8) then
  pshead%hat_meshsz=pshead%sph_meshsz
  pshead%rc_hat=pshead%rc_sph
 else
  if (pshead%mesh_type==1) then
   pshead%hat_meshsz=int(1.d0+pshead%rc_hat/pshead%rad_step)
  else
   pshead%hat_meshsz=int(log(1.d0+pshead%rc_hat/pshead%rad_step)/pshead%log_step)+1
  endif
 endif

!Radial mesh for projectors
 pshead%prj_msz_max=4.d0*pshead%sph_meshsz
 pshead%prj_meshsz=pshead%sph_meshsz

!Radial mesh for local potential
 if (pshead%vloc_meshsz<=0) then
  if (pshead%mesh_type==1) then
   ii1=int(1.d0+rmax_vloc/pshead%rad_step)
  else
   ii1=int(log(1.d0+rmax_vloc/pshead%rad_step)/pshead%log_step)+1
  endif
  pshead%vloc_meshsz=max(pshead%sph_meshsz,pshead%core_meshsz,ii1)
 endif

!Total radial mesh
 pshead%max_meshsz=max(pshead%sph_meshsz,pshead%hat_meshsz,pshead%core_meshsz,pshead%vale_meshsz,&
&                      pshead%vloc_meshsz,pshead%prj_msz_max,pshead%prj_meshsz)

!Initialization of the orbital basis indexes (indlmn)
 ilmn=0;iln=0
 do il=0,pshead%lmax
  nproj=0
  do ib=1,pshead%basis_size
   if (pshead%orbitals(ib)==il) then
    nproj=nproj+1;iln=iln+1
    do ilm=1,2*il+1
     pawarray%indlmn(1,ilmn+ilm)=il
     pawarray%indlmn(2,ilmn+ilm)=ilm-(il+1)
     pawarray%indlmn(3,ilmn+ilm)=nproj
     pawarray%indlmn(4,ilmn+ilm)=il*il+ilm
     pawarray%indlmn(5,ilmn+ilm)=iln
     pawarray%indlmn(6,ilmn+ilm)=1
    enddo
    ilmn=ilmn+2*il+1
   endif
  enddo
 enddo

 end subroutine
!!***
