!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_rhoij0
!! NAME
!! calc_rhoij0
!! 
!! FUNCTION
!! Compute initial values (atomic initialization) of rhoij0
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  pshead
!!    %basis_size= Number of elements for the paw nl basis
!!    %occ(basis_size)= occupation for each basis function
!!    %orbitals(basis_size)= Quantum number l for each basis function
!!
!! OUTPUT
!!  pawps
!!    %rhoij0= Atomic initialization of rhoij
!!
!! PARENTS
!!      atompaw2abinit
!!
!! CHILDREN
!!
!! SOURCE

 subroutine calc_rhoij0(pawps,pshead)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ---------------------------------------------
 type(pawps_type)    :: pawps
 type(pshead_type)   :: pshead

!Local variables ---------------------------------------
 integer :: ib,ilmn,ilmn0,ll2

!-------------------------------------------------------

 pawps%rhoij0=zero

!Store occupations into Rhoij0
!(This is only true bound states are included in the wave function basis
 ilmn0=0
 do ib=1,pshead%basis_size
  ll2=2*pshead%orbitals(ib)+1
  do ilmn=ilmn0+1,ilmn0+ll2
   pawps%rhoij0(ilmn*(ilmn+1)/2)=pshead%occ(ib)/dble(ll2)
  enddo
  ilmn0=ilmn0+ll2
 enddo

 end subroutine
!!***

