!{\src2tex{textfont=tt}}
!!****f* ABINIT/poisson
!! NAME
!! poisson
!!
!! FUNCTION
!! Solve poisson equation for a density given on a linear or logarithmic grid
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  den(nn) is electron density * (4*pi*r**2)
!!  nn= dimension of the radial arrays
!!  pawrad=datastructure containing mesh size definitions
!!
!! OUTPUT
!!  rv(nn) is returned as electrostatic potential * r (in Hartree*Bohr!)
!!
!! PARENTS
!!      calc_dij0
!!
!! CHILDREN
!!      deducer0
!!
!! SOURCE

 subroutine poisson(den,nn,pawrad,rv)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ------------------------------------
 integer :: nn
 real (dp) :: den(nn),rv(nn)
 type(pawrad_type) :: pawrad

!Local variables-------------------------------
 integer :: ir,jr
 real(dp) :: h3
 real (dp) :: aa(nn),bb(nn),cc(nn),dd(nn),ee(4)

! *************************************************************************

  if (pawrad%islog==1) then
   h3=pawrad%lstep/3.d0
  else
   h3=pawrad%rstep/3.d0
  end if

  do jr=nn,2,-1
   ir=nn-jr+1
   aa(ir)=den(jr)*pawrad%radfact(jr)
   bb(ir)=den(jr)*pawrad%radfact(jr)/pawrad%rad(jr)
  end do
  ee(4)=aa(nn-3);ee(3)=aa(nn-2);ee(2)=aa(nn-1)
  call deducer0(ee,pawrad);aa(nn)=ee(1)
  ee(4)=bb(nn-3);ee(3)=bb(nn-2);ee(2)=bb(nn-1)
  call deducer0(ee,pawrad);bb(nn)=ee(1)

  cc(1)=zero;dd(1)=zero
  do ir=3,nn,2
   cc(ir)  =cc(ir-2)+h3*(aa(ir-2)+4.d0*aa(ir-1)+aa(ir))
   cc(ir-1)=cc(ir-2)+h3*(1.25d0*aa(ir-2)+2.0d0*aa(ir-1)-0.25d0*aa(ir))
   dd(ir)  =dd(ir-2)+h3*(bb(ir-2)+4.d0*bb(ir-1)+bb(ir))
   dd(ir-1)=dd(ir-2)+h3*(1.25d0*bb(ir-2)+2.d0*bb(ir-1)-0.25d0*bb(ir))
  end do
  if (mod(nn,2)==0) then
   cc(nn)=cc(nn-2)+h3*(aa(nn-2)+4.d0*aa(nn-1)+aa(nn))
   dd(nn)=dd(nn-2)+h3*(bb(nn-2)+4.d0*bb(nn-1)+bb(nn))
  end if

  rv(1)=zero
  do ir=2,nn
   jr=nn-ir+1
   rv(ir)=dd(jr)*pawrad%rad(ir)+(cc(nn)-cc(jr))
  end do

 end subroutine
!!***
