!{\src2tex{textfont=tt}}
!!****f* ABINIT/solvbes
!! NAME
!! solvbes
!!
!! FUNCTION
!!    Find nq first roots of instrinsic equation:
!!              alpha.jl(Q) + beta.Q.djl/dr(Q) = 0
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  alpha,beta= factors in intrinsic equation
!!  ll= l quantum number
!!  nq= number of roots to find
!!
!! OUTPUT
!!  root(nq)= roots of instrinsic equation
!!
!! PARENTS
!!      shapebes
!!
!! CHILDREN
!!      jbessel
!!
!! SOURCE

 subroutine solvbes(root,alpha,beta,ll,nq)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ll,nq
 real(dp),intent(in) :: alpha,beta
!arrays
 real(dp),intent(out) :: root(nq)

!Local variables-------------------------------
!scalars
 real(dp),parameter :: dh=1.d-1, tol=1.d-12
 integer :: nroot
 real(dp) :: dum,jbes,jbesp,hh,qq,qx,y1,y2

! *************************************************************************

 qq=dh;nroot=0

 do while (nroot<nq)
  call jbessel(jbes,jbesp,dum,ll,1,qq)
  y1=alpha*jbes+beta*qq*jbesp
  qq=qq+dh
  call jbessel(jbes,jbesp,dum,ll,1,qq)
  y2=alpha*jbes+beta*qq*jbesp

  do while (y1*y2>=0.D0)
   qq=qq+dh
   call jbessel(jbes,jbesp,dum,ll,1,qq)
   y2=alpha*jbes+beta*qq*jbesp
  enddo

  hh=dh;qx=qq
  do while (hh>tol)
   hh=0.5D0*hh
   if (y1*y2<0) then
    qx=qx-hh
   else
    qx=qx+hh
   endif
   call jbessel(jbes,jbesp,dum,ll,1,qx)
   y2=alpha*jbes+beta*qx*jbesp
  enddo
  nroot=nroot+1
  root(nroot)=qx

 enddo

 end subroutine
!!***
