#
# Makefile for the parser bindings of ABINIT
#

VPATH = $(abinit_srcdir)/bindings/parser

include ../../config.mk

all: libabinis.a

python: ab6_invars.so

libabinit_tmpdir = tmp-libabinis-objects
libabinis.a: libbindings.a ../../src/libs/libab6_parser.a
	test -e "$(libabinit_tmpdir)" || \
	$(INSTALL) -d -m 755 $(libabinit_tmpdir)
	cd $(libabinit_tmpdir) && $(AR) x ../../../src/libs/libab6_parser.a
	cd $(libabinit_tmpdir) && $(AR) x ../libbindings.a
	$(AR) $(ARFLAGS) libabinis.a $(libabinit_tmpdir)/*
	$(RANLIB) libabinis.a
	rm -rf $(libabinit_tmpdir)

ab6_base.o: ab6_base.c ab6_base.h
	$(CC) $(CPPFLAGS) -I. -I$(abinit_builddir) $(CFLAGS) -c $(abinit_srcdir)/bindings/parser/ab6_base.c

ab6_invars_c.o: ab6_invars_c.c ab6_invars_c.h ab6_invars.h
	$(CC) $(CPPFLAGS) -I. -I$(abinit_builddir) $(CFLAGS) -c $(abinit_srcdir)/bindings/parser/ab6_invars_c.c
ab6_symmetry_c.o: ab6_symmetry_c.c ab6_symmetry.h
	$(CC) $(CPPFLAGS) -I. -I$(abinit_builddir) $(CFLAGS) -c $(abinit_srcdir)/bindings/parser/ab6_symmetry_c.c

ab6_dummy.o: ab6_dummy.f90
	$(FC) $(FCFLAGS) -c $(abinit_srcdir)/bindings/parser/ab6_dummy.f90

libbindings.a: ab6_base.o ab6_invars_c.o ab6_symmetry_c.o ab6_dummy.o
	$(AR) $(ARFLAGS) libbindings.a ab6_base.o ab6_invars_c.o ab6_symmetry_c.o ab6_dummy.o
	$(RANLIB) libbindings.a

ab6_invars_py.o: ab6_invars_py.h ab6_invars.h ab6_invars_py.c
	$(CC) $(CPPFLAGS) $(PYTHON_CPPFLAGS) -I. -I../.. $(CFLAGS) -c $(abinit_srcdir)/bindings/parser/ab6_invars_py.c


ab6_invars.so: ab6_invars_py.o
	$(FC) -shared -o ab6_invars.so ab6_invars_py.o libabinis.a


# If ETSF_IO is enable, must add  $(lib_etsf_io_libs) $(lib_netcdf_libs)
check_invars_c: check_invars_c.c fallbacks.o libabinis.a
	$(FC) -o check_invars_c -I. $(abinit_srcdir)/bindings/parser/check_invars_c.c libabinis.a fallbacks.o $(lib_linalg_libs)

# If ETSF_IO is enable, must add  $(lib_etsf_io_libs) $(lib_netcdf_libs)
check_invars_f90: check_invars_f90.f90 fallbacks.o libabinis.a
	$(FC) -I. $(FCFLAGS) $(FCFLAGS_MODDIR) -o check_invars_f90 $(abinit_srcdir)/bindings/parser/check_invars_f90.f90 libabinis.a fallbacks.o $(lib_linalg_libs)

fallbacks.o: fallbacks.f90
	$(FC) -I. $(FCFLAGS) $(FCFLAGS_MODDIR) -c $(abinit_srcdir)/bindings/parser/fallbacks.f90

clean:
	rm -f *.o *.mod libbindings.a libabinis.a
	rm -f ab6_invars.so
	rm -f check_invars_c check_invars_f90
	rm -f check_symmetry_f90 check_symmetry_c
	rm -f *.out

check_symmetry_f90: check_symmetry_f90.f90 libabinis.a fallbacks.o
	$(FC) -I. $(FCFLAGS) $(FCFLAGS_MODDIR) -o check_symmetry_f90 $(abinit_srcdir)/bindings/parser/check_symmetry_f90.f90 -L. -labinis fallbacks.o $(lib_linalg_libs)

check_symmetry_c: check_symmetry_c.c libabinis.a fallbacks.o
	$(FC) -I. $(CFLAGS) -o check_symmetry_c $(abinit_srcdir)/bindings/parser/check_symmetry_c.c -L. -labinis fallbacks.o $(lib_linalg_libs)

check: check_symmetry_f90 check_symmetry_c check_invars_f90 check_invars_c
	./check_symmetry_f90 > check_symmetry_f90.out
	diff $(abinit_srcdir)/bindings/parser/check_symmetry.ref check_symmetry_f90.out
	./check_symmetry_c  > check_symmetry_c.out
	diff $(abinit_srcdir)/bindings/parser/check_symmetry.ref check_symmetry_c.out
	./check_invars_f90 $(abinit_srcdir)/tests/v1/Input/t05.in > check_invars_f90.out
	diff $(abinit_srcdir)/bindings/parser/check_invars.ref check_invars_f90.out
	./check_invars_c $(abinit_srcdir)/tests/v1/Input/t05.in > check_invars_c.out
	diff $(abinit_srcdir)/bindings/parser/check_invars.ref check_invars_c.out
