# -*- Autoconf -*-
#
# Copyright (C) 2005-2010 ABINIT Group (Yann Pouillon)
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

# Generated by make-macros-options on 2010/12/26 07:52:16 +0000

#
# Command-line options for the "configure" script
#

#
# IMPORTANT NOTE
#
# This file has been automatically generated by the make-macros-options
# script. If you try to edit it, your changes will systematically be
# overwritten.
#



# ABI_OPTIONS_DEFINE()
# --------------------
#
# Declares command-line arguments for the "configure" script.
#
AC_DEFUN([ABI_OPTIONS_DEFINE],[

  dnl
  dnl --enable arguments
  dnl

  AC_ARG_ENABLE(64bit-flags,
    AC_HELP_STRING([--enable-64bit-flags],
      [Use 64-bit flags (see documentation) (default: no)]))
  AC_SUBST(enable_64bit_flags)

  AC_ARG_ENABLE(all-plugins,
    AC_HELP_STRING([--enable-all-plugins],
      [Activate support for all plug-ins (default: None)]))
  AC_SUBST(enable_all_plugins)

  AC_ARG_ENABLE(bigdft,
    AC_HELP_STRING([--enable-bigdft],
      [Activate internal support for BigDFT (default: yes)]))
  AC_SUBST(enable_bigdft)

  AC_ARG_ENABLE(bindings,
    AC_HELP_STRING([--enable-bindings],
      [Activate support for bindings (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_bindings)

  AC_ARG_ENABLE(bse-unpacked,
    AC_HELP_STRING([--enable-bse-unpacked],
      [Activate Bethe-Salpeter unpacking (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_bse_unpacked)

  AC_ARG_ENABLE(cclock,
    AC_HELP_STRING([--enable-cclock],
      [Use C clock for timings (default: no)]))
  AC_SUBST(enable_cclock)

  AC_ARG_ENABLE(clib,
    AC_HELP_STRING([--enable-clib],
      [Enable the Abinit C library (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_clib)

  AC_ARG_ENABLE(config-file,
    AC_HELP_STRING([--enable-config-file],
      [Read options from config file (default: yes)]))
  AC_SUBST(enable_config_file)

  AC_ARG_ENABLE(debug,
    AC_HELP_STRING([--enable-debug],
      [Set debug level (default: basic)]))
  AC_SUBST(enable_debug)

  AC_ARG_ENABLE(dft,
    AC_HELP_STRING([--enable-dft],
      [Activate support for DFT libraries (default: no)]))
  AC_SUBST(enable_dft)

  AC_ARG_ENABLE(etsf-io,
    AC_HELP_STRING([--enable-etsf-io],
      [Activate support for ETSF I/O (default: yes)]))
  AC_SUBST(enable_etsf_io)

  AC_ARG_ENABLE(exports,
    AC_HELP_STRING([--enable-exports],
      [Activate build of exported libraries (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_exports)

  AC_ARG_ENABLE(fast-check,
    AC_HELP_STRING([--enable-fast-check],
      [Run 'make check' using 4 processors (default: no)]))
  AC_SUBST(enable_fast_check)

  AC_ARG_ENABLE(fc-wrapper,
    AC_HELP_STRING([--enable-fc-wrapper],
      [Wrap Fortran compiler calls (default: no)]))
  AC_SUBST(enable_fc_wrapper)

  AC_ARG_ENABLE(fft,
    AC_HELP_STRING([--enable-fft],
      [Enable use of external FFT libraries (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_fft)

  AC_ARG_ENABLE(fox,
    AC_HELP_STRING([--enable-fox],
      [Activate support for FoX (under development) (default: no)]))
  AC_SUBST(enable_fox)

  AC_ARG_ENABLE(gpu,
    AC_HELP_STRING([--enable-gpu],
      [Activate support for GPU (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_gpu)

  AC_ARG_ENABLE(gw-cutoff,
    AC_HELP_STRING([--enable-gw-cutoff],
      [Activate the use of cut-offs for GW calculations (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_gw_cutoff)

  AC_ARG_ENABLE(gw-dpc,
    AC_HELP_STRING([--enable-gw-dpc],
      [Activate double-precision GW calculations (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_gw_dpc)

  AC_ARG_ENABLE(gw-optimal,
    AC_HELP_STRING([--enable-gw-optimal],
      [Activate optimal GW calculations (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_gw_optimal)

  AC_ARG_ENABLE(gw-wrapper,
    AC_HELP_STRING([--enable-gw-wrapper],
      [Activate wrapped GW calculations (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_gw_wrapper)

  AC_ARG_ENABLE(hints,
    AC_HELP_STRING([--enable-hints],
      [Preset flags to have the source building properly (default: yes)]))
  AC_SUBST(enable_hints)

  AC_ARG_ENABLE(libxc,
    AC_HELP_STRING([--enable-libxc],
      [Activate support for LibXC (default: yes)]))
  AC_SUBST(enable_libxc)

  AC_ARG_ENABLE(linalg,
    AC_HELP_STRING([--enable-linalg],
      [Activate support for external linear algebra libraries (default: yes)]))
  AC_SUBST(enable_linalg)

  AC_ARG_ENABLE(macroave,
    AC_HELP_STRING([--enable-macroave],
      [Enable build of macroave (EXPERIMENTAL) (default: yes)]))
  AC_SUBST(enable_macroave)

  AC_ARG_ENABLE(maintainer-checks,
    AC_HELP_STRING([--enable-maintainer-checks],
      [Activate maintainer checks (BuildBot) (default: no)]))
  AC_SUBST(enable_maintainer_checks)

  AC_ARG_ENABLE(math,
    AC_HELP_STRING([--enable-math],
      [Enable use of an external math library (default: no)]))
  AC_SUBST(enable_math)

  AC_ARG_ENABLE(mpi,
    AC_HELP_STRING([--enable-mpi],
      [Enable MPI support (default: None)]))
  AC_SUBST(enable_mpi)

  AC_ARG_ENABLE(mpi-io,
    AC_HELP_STRING([--enable-mpi-io],
      [Enable MPI I/O (default: None)]))
  AC_SUBST(enable_mpi_io)

  AC_ARG_ENABLE(mpi-io-test,
    AC_HELP_STRING([--enable-mpi-io-test],
      [Enable MPI I/O untested features (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_mpi_io_test)

  AC_ARG_ENABLE(mpi-trace,
    AC_HELP_STRING([--enable-mpi-trace],
      [Enable MPI time tracing (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_mpi_trace)

  AC_ARG_ENABLE(netcdf,
    AC_HELP_STRING([--enable-netcdf],
      [Activate support for NetCDF (default: yes)]))
  AC_SUBST(enable_netcdf)

  AC_ARG_ENABLE(optim,
    AC_HELP_STRING([--enable-optim],
      [Set optimization level (default: standard)]))
  AC_SUBST(enable_optim)

  AC_ARG_ENABLE(scalapack,
    AC_HELP_STRING([--enable-scalapack],
      [Use ScaLAPACK for parallel linear algebra operations (default: no)]))
  AC_SUBST(enable_scalapack)

  AC_ARG_ENABLE(smp,
    AC_HELP_STRING([--enable-smp],
      [Activate support for Symmetric Multi-Processing (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_smp)

  AC_ARG_ENABLE(stdin,
    AC_HELP_STRING([--enable-stdin],
      [Tell Abinit to read file lists from standard input (default: yes)]))
  AC_SUBST(enable_stdin)

  AC_ARG_ENABLE(test-timeout,
    AC_HELP_STRING([--enable-test-timeout],
      [Activate timeout for tests (will build additional C code) (default: no)]))
  AC_SUBST(enable_test_timeout)

  AC_ARG_ENABLE(timer,
    AC_HELP_STRING([--enable-timer],
      [Use external timer (default: no)]))
  AC_SUBST(enable_timer)

  AC_ARG_ENABLE(trio,
    AC_HELP_STRING([--enable-trio],
      [Activate transferable I/O support (default: no)]))
  AC_SUBST(enable_trio)

  AC_ARG_ENABLE(vdwxc,
    AC_HELP_STRING([--enable-vdwxc],
      [Activate van der Waals exchange-correlation (EXPERIMENTAL) (default: no)]))
  AC_SUBST(enable_vdwxc)

  AC_ARG_ENABLE(wannier90,
    AC_HELP_STRING([--enable-wannier90],
      [Activate support for Wannier90 (default: yes)]))
  AC_SUBST(enable_wannier90)

  AC_ARG_ENABLE(zdot-bugfix,
    AC_HELP_STRING([--enable-zdot-bugfix],
      [Activate workaround for bugged ZDOTC and ZDOTU (default: no)]))
  AC_SUBST(enable_zdot_bugfix)

  dnl
  dnl --with arguments
  dnl

  AC_ARG_WITH(bigdft-includes,
    AC_HELP_STRING([--with-bigdft-includes],
      [Include parameters for BigDFT support (default: None)]))
  AC_SUBST(with_bigdft_includes)

  AC_ARG_WITH(bigdft-libs,
    AC_HELP_STRING([--with-bigdft-libs],
      [BigDFT libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_bigdft_libs)

  AC_ARG_WITH(config-file,
    AC_HELP_STRING([--with-config-file],
      [Specify config file to read options from (default: None)]))
  AC_SUBST(with_config_file)

  AC_ARG_WITH(dft-flavor,
    AC_HELP_STRING([--with-dft-flavor],
      [Kind of DFT support to activate (default: bigdft+libxc+wannier90)]))
  AC_SUBST(with_dft_flavor)

  AC_ARG_WITH(dft-includes,
    AC_HELP_STRING([--with-dft-includes],
      [Include parameters for DFT support (default: None)]))
  AC_SUBST(with_dft_includes)

  AC_ARG_WITH(dft-libs,
    AC_HELP_STRING([--with-dft-libs],
      [Enhanced DFT libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_dft_libs)

  AC_ARG_WITH(etsf-io-includes,
    AC_HELP_STRING([--with-etsf-io-includes],
      [Include parameters for ETSF I/O support (default: None)]))
  AC_SUBST(with_etsf_io_includes)

  AC_ARG_WITH(etsf-io-libs,
    AC_HELP_STRING([--with-etsf-io-libs],
      [ETSF I/O libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_etsf_io_libs)

  AC_ARG_WITH(fc-vendor,
    AC_HELP_STRING([--with-fc-vendor],
      [Fortran compiler vendor to be used by the build system (default: None)]))
  AC_SUBST(with_fc_vendor)

  AC_ARG_WITH(fc-version,
    AC_HELP_STRING([--with-fc-version],
      [Fortran compiler version to be used by the build system (default: None)]))
  AC_SUBST(with_fc_version)

  AC_ARG_WITH(fft-flavor,
    AC_HELP_STRING([--with-fft-flavor],
      [Kind of FFT support to activate (default: fftw3)]))
  AC_SUBST(with_fft_flavor)

  AC_ARG_WITH(fft-includes,
    AC_HELP_STRING([--with-fft-includes],
      [Include parameters for the FFTW libraries (default: None)]))
  AC_SUBST(with_fft_includes)

  AC_ARG_WITH(fft-libs,
    AC_HELP_STRING([--with-fft-libs],
      [FFTW libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_fft_libs)

  AC_ARG_WITH(fox-includes,
    AC_HELP_STRING([--with-fox-includes],
      [Include parameters for FoX support (default: None)]))
  AC_SUBST(with_fox_includes)

  AC_ARG_WITH(fox-libs,
    AC_HELP_STRING([--with-fox-libs],
      [FoX libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_fox_libs)

  AC_ARG_WITH(gpu-cflags,
    AC_HELP_STRING([--with-gpu-cflags],
      [C flags to build GPU kernels (default: None)]))
  AC_SUBST(with_gpu_cflags)

  AC_ARG_WITH(gpu-cppflags,
    AC_HELP_STRING([--with-gpu-cppflags],
      [Preprocessing options to build GPU kernels (default: None)]))
  AC_SUBST(with_gpu_cppflags)

  AC_ARG_WITH(gpu-flavor,
    AC_HELP_STRING([--with-gpu-flavor],
      [Kind of GPU support to activate (default: cuda-single)]))
  AC_SUBST(with_gpu_flavor)

  AC_ARG_WITH(gpu-includes,
    AC_HELP_STRING([--with-gpu-includes],
      [Include parameters for GPU support (default: None)]))
  AC_SUBST(with_gpu_includes)

  AC_ARG_WITH(gpu-ldflags,
    AC_HELP_STRING([--with-gpu-ldflags],
      [Link flags to build GPU-specific binaries (default: None)]))
  AC_SUBST(with_gpu_ldflags)

  AC_ARG_WITH(gpu-libs,
    AC_HELP_STRING([--with-gpu-libs],
      [GPU libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_gpu_libs)

  AC_ARG_WITH(gpu-prefix,
    AC_HELP_STRING([--with-gpu-prefix],
      [Prefix path for the GPU installation (default: None)]))
  AC_SUBST(with_gpu_prefix)

  AC_ARG_WITH(libxc-includes,
    AC_HELP_STRING([--with-libxc-includes],
      [Include parameters for ETSF XC support (default: None)]))
  AC_SUBST(with_libxc_includes)

  AC_ARG_WITH(libxc-libs,
    AC_HELP_STRING([--with-libxc-libs],
      [ETSF XC libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_libxc_libs)

  AC_ARG_WITH(linalg-flavor,
    AC_HELP_STRING([--with-linalg-flavor],
      [See ~abinit/doc/config/build-config.ac for information (default: netlib)]))
  AC_SUBST(with_linalg_flavor)

  AC_ARG_WITH(linalg-includes,
    AC_HELP_STRING([--with-linalg-includes],
      [Include parameters for the linear algebra libraries (BLAS+LAPACK) (default: None)]))
  AC_SUBST(with_linalg_includes)

  AC_ARG_WITH(linalg-libs,
    AC_HELP_STRING([--with-linalg-libs],
      [Linear algebra libraries (BLAS+LAPACK) to link with (default: None)]))
  AC_SUBST(with_linalg_libs)

  AC_ARG_WITH(math-flavor,
    AC_HELP_STRING([--with-math-flavor],
      [Kind of math library to use (default: gsl)]))
  AC_SUBST(with_math_flavor)

  AC_ARG_WITH(math-includes,
    AC_HELP_STRING([--with-math-includes],
      [Include parameters for the math library (default: None)]))
  AC_SUBST(with_math_includes)

  AC_ARG_WITH(math-libs,
    AC_HELP_STRING([--with-math-libs],
      [GSL libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_math_libs)

  AC_ARG_WITH(mpi-includes,
    AC_HELP_STRING([--with-mpi-includes],
      [Include parameters for the MPI library (default: None)]))
  AC_SUBST(with_mpi_includes)

  AC_ARG_WITH(mpi-level,
    AC_HELP_STRING([--with-mpi-level],
      [MPI standard level to use (1 or 2) (default: None)]))
  AC_SUBST(with_mpi_level)

  AC_ARG_WITH(mpi-libs,
    AC_HELP_STRING([--with-mpi-libs],
      [MPI libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_mpi_libs)

  AC_ARG_WITH(mpi-prefix,
    AC_HELP_STRING([--with-mpi-prefix],
      [Prefix path to the MPI installation (default: None)]))
  AC_SUBST(with_mpi_prefix)

  AC_ARG_WITH(netcdf-includes,
    AC_HELP_STRING([--with-netcdf-includes],
      [Include parameters for NetCDF support (default: None)]))
  AC_SUBST(with_netcdf_includes)

  AC_ARG_WITH(netcdf-libs,
    AC_HELP_STRING([--with-netcdf-libs],
      [NetCDF libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_netcdf_libs)

  AC_ARG_WITH(plugins-prefix,
    AC_HELP_STRING([--with-plugins-prefix],
      [Prefix for already installed plug-ins (default: None)]))
  AC_SUBST(with_plugins_prefix)

  AC_ARG_WITH(plugins-tardir,
    AC_HELP_STRING([--with-plugins-tardir],
      [Full path for the tarballs of plug-ins (default: None)]))
  AC_SUBST(with_plugins_tardir)

  AC_ARG_WITH(test-timeout,
    AC_HELP_STRING([--with-test-timeout],
      [Automatic test timeout (default: 900)]))
  AC_SUBST(with_test_timeout)

  AC_ARG_WITH(timer-flavor,
    AC_HELP_STRING([--with-timer-flavor],
      [Kind of timer to use (default: abinit)]))
  AC_SUBST(with_timer_flavor)

  AC_ARG_WITH(timer-includes,
    AC_HELP_STRING([--with-timer-includes],
      [Include parameters for the timer library (default: None)]))
  AC_SUBST(with_timer_includes)

  AC_ARG_WITH(timer-libs,
    AC_HELP_STRING([--with-timer-libs],
      [PAPI libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_timer_libs)

  AC_ARG_WITH(trio-flavor,
    AC_HELP_STRING([--with-trio-flavor],
      [Kind of transferable I/O to activate (default: fox+etsf)]))
  AC_SUBST(with_trio_flavor)

  AC_ARG_WITH(trio-includes,
    AC_HELP_STRING([--with-trio-includes],
      [Include parameters for transferable I/O support (default: None)]))
  AC_SUBST(with_trio_includes)

  AC_ARG_WITH(trio-libs,
    AC_HELP_STRING([--with-trio-libs],
      [Enhanced I/O libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_trio_libs)

  AC_ARG_WITH(wannier90,
    AC_HELP_STRING([--with-wannier90],
      [Full path to the Wannier90 executable (default: None)]))
  AC_SUBST(with_wannier90)

  AC_ARG_WITH(wannier90-includes,
    AC_HELP_STRING([--with-wannier90-includes],
      [Include parameters for Wannier90 support (default: None)]))
  AC_SUBST(with_wannier90_includes)

  AC_ARG_WITH(wannier90-libs,
    AC_HELP_STRING([--with-wannier90-libs],
      [Wannier90 libraries to link Abinit binaries with (default: None)]))
  AC_SUBST(with_wannier90_libs)
]) # ABI_OPTIONS_DEFINE



# ABI_OPTIONS_SETUP()
# -------------------
#
# Sets the default values of command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_SETUP],[

  dnl
  dnl --enable arguments
  dnl

  if test "${enable_64bit_flags}" = ""; then
    enable_64bit_flags="no"
  fi
  if test "${enable_bigdft}" = ""; then
    enable_bigdft="yes"
  fi
  if test "${enable_bindings}" = ""; then
    enable_bindings="no"
  fi
  if test "${enable_bse_unpacked}" = ""; then
    enable_bse_unpacked="no"
  fi
  if test "${enable_cclock}" = ""; then
    enable_cclock="no"
  fi
  if test "${enable_clib}" = ""; then
    enable_clib="no"
  fi
  if test "${enable_config_file}" = ""; then
    enable_config_file="yes"
  fi
  if test "${enable_debug}" = ""; then
    enable_debug="basic"
  fi
  if test "${enable_dft}" = ""; then
    enable_dft="no"
  fi
  if test "${enable_etsf_io}" = ""; then
    enable_etsf_io="yes"
  fi
  if test "${enable_exports}" = ""; then
    enable_exports="no"
  fi
  if test "${enable_fast_check}" = ""; then
    enable_fast_check="no"
  fi
  if test "${enable_fc_wrapper}" = ""; then
    enable_fc_wrapper="no"
  fi
  if test "${enable_fft}" = ""; then
    enable_fft="no"
  fi
  if test "${enable_fox}" = ""; then
    enable_fox="no"
  fi
  if test "${enable_gpu}" = ""; then
    enable_gpu="no"
  fi
  if test "${enable_gw_cutoff}" = ""; then
    enable_gw_cutoff="no"
  fi
  if test "${enable_gw_dpc}" = ""; then
    enable_gw_dpc="no"
  fi
  if test "${enable_gw_optimal}" = ""; then
    enable_gw_optimal="no"
  fi
  if test "${enable_gw_wrapper}" = ""; then
    enable_gw_wrapper="no"
  fi
  if test "${enable_hints}" = ""; then
    enable_hints="yes"
  fi
  if test "${enable_libxc}" = ""; then
    enable_libxc="yes"
  fi
  if test "${enable_linalg}" = ""; then
    enable_linalg="yes"
  fi
  if test "${enable_macroave}" = ""; then
    enable_macroave="yes"
  fi
  if test "${enable_maintainer_checks}" = ""; then
    enable_maintainer_checks="no"
  fi
  if test "${enable_math}" = ""; then
    enable_math="no"
  fi
  if test "${enable_mpi_io_test}" = ""; then
    enable_mpi_io_test="no"
  fi
  if test "${enable_mpi_trace}" = ""; then
    enable_mpi_trace="no"
  fi
  if test "${enable_netcdf}" = ""; then
    enable_netcdf="yes"
  fi
  if test "${enable_optim}" = ""; then
    enable_optim="standard"
  fi
  if test "${enable_scalapack}" = ""; then
    enable_scalapack="no"
  fi
  if test "${enable_smp}" = ""; then
    enable_smp="no"
  fi
  if test "${enable_stdin}" = ""; then
    enable_stdin="yes"
  fi
  if test "${enable_test_timeout}" = ""; then
    enable_test_timeout="no"
  fi
  if test "${enable_timer}" = ""; then
    enable_timer="no"
  fi
  if test "${enable_trio}" = ""; then
    enable_trio="no"
  fi
  if test "${enable_vdwxc}" = ""; then
    enable_vdwxc="no"
  fi
  if test "${enable_wannier90}" = ""; then
    enable_wannier90="yes"
  fi
  if test "${enable_zdot_bugfix}" = ""; then
    enable_zdot_bugfix="no"
  fi

  dnl
  dnl --with arguments
  dnl

  if test "${with_dft_flavor}" = ""; then
    with_dft_flavor="bigdft+libxc+wannier90"
  fi
  if test "${with_fft_flavor}" = ""; then
    with_fft_flavor="fftw3"
  fi
  if test "${with_gpu_flavor}" = ""; then
    with_gpu_flavor="cuda-single"
  fi
  if test "${with_linalg_flavor}" = ""; then
    with_linalg_flavor="netlib"
  fi
  if test "${with_math_flavor}" = ""; then
    with_math_flavor="gsl"
  fi
  if test "${with_test_timeout}" = ""; then
    with_test_timeout="900"
  fi
  if test "${with_timer_flavor}" = ""; then
    with_timer_flavor="abinit"
  fi
  if test "${with_trio_flavor}" = ""; then
    with_trio_flavor="fox+etsf"
  fi
]) # ABI_OPTIONS_SETUP



# ABI_OPTIONS_BACKUP()
# --------------------
#
# Saves all command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_BACKUP],[

  dnl
  dnl --enable arguments
  dnl
  cmd_enable_64bit_flags="${enable_64bit_flags}"
  cmd_enable_all_plugins="${enable_all_plugins}"
  cmd_enable_bigdft="${enable_bigdft}"
  cmd_enable_bindings="${enable_bindings}"
  cmd_enable_bse_unpacked="${enable_bse_unpacked}"
  cmd_enable_cclock="${enable_cclock}"
  cmd_enable_clib="${enable_clib}"
  cmd_enable_config_file="${enable_config_file}"
  cmd_enable_debug="${enable_debug}"
  cmd_enable_dft="${enable_dft}"
  cmd_enable_etsf_io="${enable_etsf_io}"
  cmd_enable_exports="${enable_exports}"
  cmd_enable_fast_check="${enable_fast_check}"
  cmd_enable_fc_wrapper="${enable_fc_wrapper}"
  cmd_enable_fft="${enable_fft}"
  cmd_enable_fox="${enable_fox}"
  cmd_enable_gpu="${enable_gpu}"
  cmd_enable_gw_cutoff="${enable_gw_cutoff}"
  cmd_enable_gw_dpc="${enable_gw_dpc}"
  cmd_enable_gw_optimal="${enable_gw_optimal}"
  cmd_enable_gw_wrapper="${enable_gw_wrapper}"
  cmd_enable_hints="${enable_hints}"
  cmd_enable_libxc="${enable_libxc}"
  cmd_enable_linalg="${enable_linalg}"
  cmd_enable_macroave="${enable_macroave}"
  cmd_enable_maintainer_checks="${enable_maintainer_checks}"
  cmd_enable_math="${enable_math}"
  cmd_enable_mpi="${enable_mpi}"
  cmd_enable_mpi_io="${enable_mpi_io}"
  cmd_enable_mpi_io_test="${enable_mpi_io_test}"
  cmd_enable_mpi_trace="${enable_mpi_trace}"
  cmd_enable_netcdf="${enable_netcdf}"
  cmd_enable_optim="${enable_optim}"
  cmd_enable_scalapack="${enable_scalapack}"
  cmd_enable_smp="${enable_smp}"
  cmd_enable_stdin="${enable_stdin}"
  cmd_enable_test_timeout="${enable_test_timeout}"
  cmd_enable_timer="${enable_timer}"
  cmd_enable_trio="${enable_trio}"
  cmd_enable_vdwxc="${enable_vdwxc}"
  cmd_enable_wannier90="${enable_wannier90}"
  cmd_enable_zdot_bugfix="${enable_zdot_bugfix}"

  dnl
  dnl --with arguments
  dnl
  cmd_with_bigdft_includes="${with_bigdft_includes}"
  cmd_with_bigdft_libs="${with_bigdft_libs}"
  cmd_with_config_file="${with_config_file}"
  cmd_with_dft_flavor="${with_dft_flavor}"
  cmd_with_dft_includes="${with_dft_includes}"
  cmd_with_dft_libs="${with_dft_libs}"
  cmd_with_etsf_io_includes="${with_etsf_io_includes}"
  cmd_with_etsf_io_libs="${with_etsf_io_libs}"
  cmd_with_fc_vendor="${with_fc_vendor}"
  cmd_with_fc_version="${with_fc_version}"
  cmd_with_fft_flavor="${with_fft_flavor}"
  cmd_with_fft_includes="${with_fft_includes}"
  cmd_with_fft_libs="${with_fft_libs}"
  cmd_with_fox_includes="${with_fox_includes}"
  cmd_with_fox_libs="${with_fox_libs}"
  cmd_with_gpu_cflags="${with_gpu_cflags}"
  cmd_with_gpu_cppflags="${with_gpu_cppflags}"
  cmd_with_gpu_flavor="${with_gpu_flavor}"
  cmd_with_gpu_includes="${with_gpu_includes}"
  cmd_with_gpu_ldflags="${with_gpu_ldflags}"
  cmd_with_gpu_libs="${with_gpu_libs}"
  cmd_with_gpu_prefix="${with_gpu_prefix}"
  cmd_with_libxc_includes="${with_libxc_includes}"
  cmd_with_libxc_libs="${with_libxc_libs}"
  cmd_with_linalg_flavor="${with_linalg_flavor}"
  cmd_with_linalg_includes="${with_linalg_includes}"
  cmd_with_linalg_libs="${with_linalg_libs}"
  cmd_with_math_flavor="${with_math_flavor}"
  cmd_with_math_includes="${with_math_includes}"
  cmd_with_math_libs="${with_math_libs}"
  cmd_with_mpi_includes="${with_mpi_includes}"
  cmd_with_mpi_level="${with_mpi_level}"
  cmd_with_mpi_libs="${with_mpi_libs}"
  cmd_with_mpi_prefix="${with_mpi_prefix}"
  cmd_with_netcdf_includes="${with_netcdf_includes}"
  cmd_with_netcdf_libs="${with_netcdf_libs}"
  cmd_with_plugins_prefix="${with_plugins_prefix}"
  cmd_with_plugins_tardir="${with_plugins_tardir}"
  cmd_with_test_timeout="${with_test_timeout}"
  cmd_with_timer_flavor="${with_timer_flavor}"
  cmd_with_timer_includes="${with_timer_includes}"
  cmd_with_timer_libs="${with_timer_libs}"
  cmd_with_trio_flavor="${with_trio_flavor}"
  cmd_with_trio_includes="${with_trio_includes}"
  cmd_with_trio_libs="${with_trio_libs}"
  cmd_with_wannier90="${with_wannier90}"
  cmd_with_wannier90_includes="${with_wannier90_includes}"
  cmd_with_wannier90_libs="${with_wannier90_libs}"

  dnl
  dnl Prefix
  dnl
  if test "${prefix}" != "NONE"; then
    cmd_prefix="${prefix}"
  fi
]) # ABI_OPTIONS_BACKUP



# ABI_OPTIONS_RECALL()
# --------------------
#
# Restores all previously-saved command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_RECALL],[

  dnl
  dnl --enable arguments
  dnl

  if test "${cmd_enable_64bit_flags}" != ""; then
    enable_64bit_flags="${cmd_enable_64bit_flags}"
  fi

  if test "${cmd_enable_all_plugins}" != ""; then
    enable_all_plugins="${cmd_enable_all_plugins}"
  fi

  if test "${cmd_enable_bigdft}" != ""; then
    enable_bigdft="${cmd_enable_bigdft}"
  fi

  if test "${cmd_enable_bindings}" != ""; then
    enable_bindings="${cmd_enable_bindings}"
  fi

  if test "${cmd_enable_bse_unpacked}" != ""; then
    enable_bse_unpacked="${cmd_enable_bse_unpacked}"
  fi

  if test "${cmd_enable_cclock}" != ""; then
    enable_cclock="${cmd_enable_cclock}"
  fi

  if test "${cmd_enable_clib}" != ""; then
    enable_clib="${cmd_enable_clib}"
  fi

  if test "${cmd_enable_config_file}" != ""; then
    enable_config_file="${cmd_enable_config_file}"
  fi

  if test "${cmd_enable_debug}" != ""; then
    enable_debug="${cmd_enable_debug}"
  fi

  if test "${cmd_enable_dft}" != ""; then
    enable_dft="${cmd_enable_dft}"
  fi

  if test "${cmd_enable_etsf_io}" != ""; then
    enable_etsf_io="${cmd_enable_etsf_io}"
  fi

  if test "${cmd_enable_exports}" != ""; then
    enable_exports="${cmd_enable_exports}"
  fi

  if test "${cmd_enable_fast_check}" != ""; then
    enable_fast_check="${cmd_enable_fast_check}"
  fi

  if test "${cmd_enable_fc_wrapper}" != ""; then
    enable_fc_wrapper="${cmd_enable_fc_wrapper}"
  fi

  if test "${cmd_enable_fft}" != ""; then
    enable_fft="${cmd_enable_fft}"
  fi

  if test "${cmd_enable_fox}" != ""; then
    enable_fox="${cmd_enable_fox}"
  fi

  if test "${cmd_enable_gpu}" != ""; then
    enable_gpu="${cmd_enable_gpu}"
  fi

  if test "${cmd_enable_gw_cutoff}" != ""; then
    enable_gw_cutoff="${cmd_enable_gw_cutoff}"
  fi

  if test "${cmd_enable_gw_dpc}" != ""; then
    enable_gw_dpc="${cmd_enable_gw_dpc}"
  fi

  if test "${cmd_enable_gw_optimal}" != ""; then
    enable_gw_optimal="${cmd_enable_gw_optimal}"
  fi

  if test "${cmd_enable_gw_wrapper}" != ""; then
    enable_gw_wrapper="${cmd_enable_gw_wrapper}"
  fi

  if test "${cmd_enable_hints}" != ""; then
    enable_hints="${cmd_enable_hints}"
  fi

  if test "${cmd_enable_libxc}" != ""; then
    enable_libxc="${cmd_enable_libxc}"
  fi

  if test "${cmd_enable_linalg}" != ""; then
    enable_linalg="${cmd_enable_linalg}"
  fi

  if test "${cmd_enable_macroave}" != ""; then
    enable_macroave="${cmd_enable_macroave}"
  fi

  if test "${cmd_enable_maintainer_checks}" != ""; then
    enable_maintainer_checks="${cmd_enable_maintainer_checks}"
  fi

  if test "${cmd_enable_math}" != ""; then
    enable_math="${cmd_enable_math}"
  fi

  if test "${cmd_enable_mpi}" != ""; then
    enable_mpi="${cmd_enable_mpi}"
  fi

  if test "${cmd_enable_mpi_io}" != ""; then
    enable_mpi_io="${cmd_enable_mpi_io}"
  fi

  if test "${cmd_enable_mpi_io_test}" != ""; then
    enable_mpi_io_test="${cmd_enable_mpi_io_test}"
  fi

  if test "${cmd_enable_mpi_trace}" != ""; then
    enable_mpi_trace="${cmd_enable_mpi_trace}"
  fi

  if test "${cmd_enable_netcdf}" != ""; then
    enable_netcdf="${cmd_enable_netcdf}"
  fi

  if test "${cmd_enable_optim}" != ""; then
    enable_optim="${cmd_enable_optim}"
  fi

  if test "${cmd_enable_scalapack}" != ""; then
    enable_scalapack="${cmd_enable_scalapack}"
  fi

  if test "${cmd_enable_smp}" != ""; then
    enable_smp="${cmd_enable_smp}"
  fi

  if test "${cmd_enable_stdin}" != ""; then
    enable_stdin="${cmd_enable_stdin}"
  fi

  if test "${cmd_enable_test_timeout}" != ""; then
    enable_test_timeout="${cmd_enable_test_timeout}"
  fi

  if test "${cmd_enable_timer}" != ""; then
    enable_timer="${cmd_enable_timer}"
  fi

  if test "${cmd_enable_trio}" != ""; then
    enable_trio="${cmd_enable_trio}"
  fi

  if test "${cmd_enable_vdwxc}" != ""; then
    enable_vdwxc="${cmd_enable_vdwxc}"
  fi

  if test "${cmd_enable_wannier90}" != ""; then
    enable_wannier90="${cmd_enable_wannier90}"
  fi

  if test "${cmd_enable_zdot_bugfix}" != ""; then
    enable_zdot_bugfix="${cmd_enable_zdot_bugfix}"
  fi

  dnl
  dnl --with arguments
  dnl

  if test "${cmd_with_bigdft_includes}" != ""; then
    with_bigdft_includes="${cmd_with_bigdft_includes}"
  fi

  if test "${cmd_with_bigdft_libs}" != ""; then
    with_bigdft_libs="${cmd_with_bigdft_libs}"
  fi

  if test "${cmd_with_config_file}" != ""; then
    with_config_file="${cmd_with_config_file}"
  fi

  if test "${cmd_with_dft_flavor}" != ""; then
    with_dft_flavor="${cmd_with_dft_flavor}"
  fi

  if test "${cmd_with_dft_includes}" != ""; then
    with_dft_includes="${cmd_with_dft_includes}"
  fi

  if test "${cmd_with_dft_libs}" != ""; then
    with_dft_libs="${cmd_with_dft_libs}"
  fi

  if test "${cmd_with_etsf_io_includes}" != ""; then
    with_etsf_io_includes="${cmd_with_etsf_io_includes}"
  fi

  if test "${cmd_with_etsf_io_libs}" != ""; then
    with_etsf_io_libs="${cmd_with_etsf_io_libs}"
  fi

  if test "${cmd_with_fc_vendor}" != ""; then
    with_fc_vendor="${cmd_with_fc_vendor}"
  fi

  if test "${cmd_with_fc_version}" != ""; then
    with_fc_version="${cmd_with_fc_version}"
  fi

  if test "${cmd_with_fft_flavor}" != ""; then
    with_fft_flavor="${cmd_with_fft_flavor}"
  fi

  if test "${cmd_with_fft_includes}" != ""; then
    with_fft_includes="${cmd_with_fft_includes}"
  fi

  if test "${cmd_with_fft_libs}" != ""; then
    with_fft_libs="${cmd_with_fft_libs}"
  fi

  if test "${cmd_with_fox_includes}" != ""; then
    with_fox_includes="${cmd_with_fox_includes}"
  fi

  if test "${cmd_with_fox_libs}" != ""; then
    with_fox_libs="${cmd_with_fox_libs}"
  fi

  if test "${cmd_with_gpu_cflags}" != ""; then
    with_gpu_cflags="${cmd_with_gpu_cflags}"
  fi

  if test "${cmd_with_gpu_cppflags}" != ""; then
    with_gpu_cppflags="${cmd_with_gpu_cppflags}"
  fi

  if test "${cmd_with_gpu_flavor}" != ""; then
    with_gpu_flavor="${cmd_with_gpu_flavor}"
  fi

  if test "${cmd_with_gpu_includes}" != ""; then
    with_gpu_includes="${cmd_with_gpu_includes}"
  fi

  if test "${cmd_with_gpu_ldflags}" != ""; then
    with_gpu_ldflags="${cmd_with_gpu_ldflags}"
  fi

  if test "${cmd_with_gpu_libs}" != ""; then
    with_gpu_libs="${cmd_with_gpu_libs}"
  fi

  if test "${cmd_with_gpu_prefix}" != ""; then
    with_gpu_prefix="${cmd_with_gpu_prefix}"
  fi

  if test "${cmd_with_libxc_includes}" != ""; then
    with_libxc_includes="${cmd_with_libxc_includes}"
  fi

  if test "${cmd_with_libxc_libs}" != ""; then
    with_libxc_libs="${cmd_with_libxc_libs}"
  fi

  if test "${cmd_with_linalg_flavor}" != ""; then
    with_linalg_flavor="${cmd_with_linalg_flavor}"
  fi

  if test "${cmd_with_linalg_includes}" != ""; then
    with_linalg_includes="${cmd_with_linalg_includes}"
  fi

  if test "${cmd_with_linalg_libs}" != ""; then
    with_linalg_libs="${cmd_with_linalg_libs}"
  fi

  if test "${cmd_with_math_flavor}" != ""; then
    with_math_flavor="${cmd_with_math_flavor}"
  fi

  if test "${cmd_with_math_includes}" != ""; then
    with_math_includes="${cmd_with_math_includes}"
  fi

  if test "${cmd_with_math_libs}" != ""; then
    with_math_libs="${cmd_with_math_libs}"
  fi

  if test "${cmd_with_mpi_includes}" != ""; then
    with_mpi_includes="${cmd_with_mpi_includes}"
  fi

  if test "${cmd_with_mpi_level}" != ""; then
    with_mpi_level="${cmd_with_mpi_level}"
  fi

  if test "${cmd_with_mpi_libs}" != ""; then
    with_mpi_libs="${cmd_with_mpi_libs}"
  fi

  if test "${cmd_with_mpi_prefix}" != ""; then
    with_mpi_prefix="${cmd_with_mpi_prefix}"
  fi

  if test "${cmd_with_netcdf_includes}" != ""; then
    with_netcdf_includes="${cmd_with_netcdf_includes}"
  fi

  if test "${cmd_with_netcdf_libs}" != ""; then
    with_netcdf_libs="${cmd_with_netcdf_libs}"
  fi

  if test "${cmd_with_plugins_prefix}" != ""; then
    with_plugins_prefix="${cmd_with_plugins_prefix}"
  fi

  if test "${cmd_with_plugins_tardir}" != ""; then
    with_plugins_tardir="${cmd_with_plugins_tardir}"
  fi

  if test "${cmd_with_test_timeout}" != ""; then
    with_test_timeout="${cmd_with_test_timeout}"
  fi

  if test "${cmd_with_timer_flavor}" != ""; then
    with_timer_flavor="${cmd_with_timer_flavor}"
  fi

  if test "${cmd_with_timer_includes}" != ""; then
    with_timer_includes="${cmd_with_timer_includes}"
  fi

  if test "${cmd_with_timer_libs}" != ""; then
    with_timer_libs="${cmd_with_timer_libs}"
  fi

  if test "${cmd_with_trio_flavor}" != ""; then
    with_trio_flavor="${cmd_with_trio_flavor}"
  fi

  if test "${cmd_with_trio_includes}" != ""; then
    with_trio_includes="${cmd_with_trio_includes}"
  fi

  if test "${cmd_with_trio_libs}" != ""; then
    with_trio_libs="${cmd_with_trio_libs}"
  fi

  if test "${cmd_with_wannier90}" != ""; then
    with_wannier90="${cmd_with_wannier90}"
  fi

  if test "${cmd_with_wannier90_includes}" != ""; then
    with_wannier90_includes="${cmd_with_wannier90_includes}"
  fi

  if test "${cmd_with_wannier90_libs}" != ""; then
    with_wannier90_libs="${cmd_with_wannier90_libs}"
  fi

  dnl
  dnl Prefix
  dnl
  if test "${cmd_prefix}" != ""; then
    prefix="${cmd_prefix}"
  fi
]) # ABI_OPTIONS_RECALL



dnl ABI_OPTIONS_CHANGED()
dnl ---------------------
dnl
dnl Display changes of user interface between versions and warns about
dnl obsolete uses.
dnl
AC_DEFUN([ABI_OPTIONS_CHANGED],[
  AC_MSG_NOTICE([reporting user interface changes:])

  dnl New --enable-bse-unpacked option
  AC_MSG_NOTICE([ * new option --enable-bse-unpacked is available])

  dnl New --enable-dft option
  AC_MSG_NOTICE([ * new option --enable-dft is available])

  dnl Removed --enable-etsf-io-test option
  AC_MSG_NOTICE([ * --enable-etsf-io-test removed])
  if test "${enable_etsf_io_test}" != ""; then
    AC_MSG_ERROR([removed option --enable-etsf-io-test has been used])
  fi

  dnl New --enable-fast-check option
  AC_MSG_NOTICE([ * new option --enable-fast-check is available])

  dnl --enable-fftw > --enable-fft
  AC_MSG_NOTICE([ * --enable-fftw renamed --enable-fft])
  if test "${enable_fftw}" != ""; then
    AC_MSG_ERROR([renamed option --enable-fftw has been used])
  fi

  dnl Removed --enable-fftw-threads option
  AC_MSG_NOTICE([ * --enable-fftw-threads removed])
  if test "${enable_fftw_threads}" != ""; then
    AC_MSG_ERROR([removed option --enable-fftw-threads has been used])
  fi

  dnl --enable-cuda > --enable-gpu
  AC_MSG_NOTICE([ * --enable-cuda renamed --enable-gpu])
  if test "${enable_cuda}" != ""; then
    AC_MSG_ERROR([renamed option --enable-cuda has been used])
  fi

  dnl New --enable-gw-cutoff option
  AC_MSG_NOTICE([ * new option --enable-gw-cutoff is available])

  dnl New --enable-gw-optimal option
  AC_MSG_NOTICE([ * new option --enable-gw-optimal is available])

  dnl New --enable-gw-wrapper option
  AC_MSG_NOTICE([ * new option --enable-gw-wrapper is available])

  dnl New --enable-linalg option
  AC_MSG_NOTICE([ * new option --enable-linalg is available])

  dnl New --enable-maintainer-checks option
  AC_MSG_NOTICE([ * new option --enable-maintainer-checks is available])

  dnl --enable-gsl > --enable-math
  AC_MSG_NOTICE([ * --enable-gsl renamed --enable-math])
  if test "${enable_gsl}" != ""; then
    AC_MSG_ERROR([renamed option --enable-gsl has been used])
  fi

  dnl New --enable-smp option
  AC_MSG_NOTICE([ * new option --enable-smp is available])

  dnl --enable-nightly > --enable-test-timeout
  AC_MSG_NOTICE([ * --enable-nightly renamed --enable-test-timeout])
  if test "${enable_nightly}" != ""; then
    AC_MSG_ERROR([renamed option --enable-nightly has been used])
  fi

  dnl --enable-papi > --enable-timer
  AC_MSG_NOTICE([ * --enable-papi renamed --enable-timer])
  if test "${enable_papi}" != ""; then
    AC_MSG_ERROR([renamed option --enable-papi has been used])
  fi

  dnl New --enable-trio option
  AC_MSG_NOTICE([ * new option --enable-trio is available])

  dnl New --enable-vdwxc option
  AC_MSG_NOTICE([ * new option --enable-vdwxc is available])

  dnl Removed --with-64bit-flags option
  AC_MSG_NOTICE([ * --with-64bit-flags removed])
  if test "${with_64bit_flags}" != ""; then
    AC_MSG_ERROR([removed option --with-64bit-flags has been used])
  fi

  dnl Removed --with-ar-dbgflags option
  AC_MSG_NOTICE([ * --with-ar-dbgflags removed])
  if test "${with_ar_dbgflags}" != ""; then
    AC_MSG_ERROR([removed option --with-ar-dbgflags has been used])
  fi

  dnl Removed --with-ar-optflags option
  AC_MSG_NOTICE([ * --with-ar-optflags removed])
  if test "${with_ar_optflags}" != ""; then
    AC_MSG_ERROR([removed option --with-ar-optflags has been used])
  fi

  dnl Removed --with-cc-dbgflags option
  AC_MSG_NOTICE([ * --with-cc-dbgflags removed])
  if test "${with_cc_dbgflags}" != ""; then
    AC_MSG_ERROR([removed option --with-cc-dbgflags has been used])
  fi

  dnl Removed --with-cc-ld-dbgflags option
  AC_MSG_NOTICE([ * --with-cc-ld-dbgflags removed])
  if test "${with_cc_ld_dbgflags}" != ""; then
    AC_MSG_ERROR([removed option --with-cc-ld-dbgflags has been used])
  fi

  dnl Removed --with-cc-ld-dbglibs option
  AC_MSG_NOTICE([ * --with-cc-ld-dbglibs removed])
  if test "${with_cc_ld_dbglibs}" != ""; then
    AC_MSG_ERROR([removed option --with-cc-ld-dbglibs has been used])
  fi

  dnl Removed --with-cc-ld-optflags option
  AC_MSG_NOTICE([ * --with-cc-ld-optflags removed])
  if test "${with_cc_ld_optflags}" != ""; then
    AC_MSG_ERROR([removed option --with-cc-ld-optflags has been used])
  fi

  dnl Removed --with-cc-ld-optlibs option
  AC_MSG_NOTICE([ * --with-cc-ld-optlibs removed])
  if test "${with_cc_ld_optlibs}" != ""; then
    AC_MSG_ERROR([removed option --with-cc-ld-optlibs has been used])
  fi

  dnl Removed --with-cc-optflags option
  AC_MSG_NOTICE([ * --with-cc-optflags removed])
  if test "${with_cc_optflags}" != ""; then
    AC_MSG_ERROR([removed option --with-cc-optflags has been used])
  fi

  dnl Removed --with-cpp-dbgflags option
  AC_MSG_NOTICE([ * --with-cpp-dbgflags removed])
  if test "${with_cpp_dbgflags}" != ""; then
    AC_MSG_ERROR([removed option --with-cpp-dbgflags has been used])
  fi

  dnl Removed --with-cpp-optflags option
  AC_MSG_NOTICE([ * --with-cpp-optflags removed])
  if test "${with_cpp_optflags}" != ""; then
    AC_MSG_ERROR([removed option --with-cpp-optflags has been used])
  fi

  dnl Removed --with-cxx-dbgflags option
  AC_MSG_NOTICE([ * --with-cxx-dbgflags removed])
  if test "${with_cxx_dbgflags}" != ""; then
    AC_MSG_ERROR([removed option --with-cxx-dbgflags has been used])
  fi

  dnl Removed --with-cxx-ld-dbgflags option
  AC_MSG_NOTICE([ * --with-cxx-ld-dbgflags removed])
  if test "${with_cxx_ld_dbgflags}" != ""; then
    AC_MSG_ERROR([removed option --with-cxx-ld-dbgflags has been used])
  fi

  dnl Removed --with-cxx-ld-dbglibs option
  AC_MSG_NOTICE([ * --with-cxx-ld-dbglibs removed])
  if test "${with_cxx_ld_dbglibs}" != ""; then
    AC_MSG_ERROR([removed option --with-cxx-ld-dbglibs has been used])
  fi

  dnl Removed --with-cxx-ld-optflags option
  AC_MSG_NOTICE([ * --with-cxx-ld-optflags removed])
  if test "${with_cxx_ld_optflags}" != ""; then
    AC_MSG_ERROR([removed option --with-cxx-ld-optflags has been used])
  fi

  dnl Removed --with-cxx-ld-optlibs option
  AC_MSG_NOTICE([ * --with-cxx-ld-optlibs removed])
  if test "${with_cxx_ld_optlibs}" != ""; then
    AC_MSG_ERROR([removed option --with-cxx-ld-optlibs has been used])
  fi

  dnl Removed --with-cxx-optflags option
  AC_MSG_NOTICE([ * --with-cxx-optflags removed])
  if test "${with_cxx_optflags}" != ""; then
    AC_MSG_ERROR([removed option --with-cxx-optflags has been used])
  fi

  dnl New --with-dft-flavor option
  AC_MSG_NOTICE([ * new option --with-dft-flavor is available])

  dnl New --with-dft-includes option
  AC_MSG_NOTICE([ * new option --with-dft-includes is available])

  dnl New --with-dft-libs option
  AC_MSG_NOTICE([ * new option --with-dft-libs is available])

  dnl Removed --with-etsf-io-test-includes option
  AC_MSG_NOTICE([ * --with-etsf-io-test-includes removed])
  if test "${with_etsf_io_test_includes}" != ""; then
    AC_MSG_ERROR([removed option --with-etsf-io-test-includes has been used])
  fi

  dnl Removed --with-etsf-io-test-libs option
  AC_MSG_NOTICE([ * --with-etsf-io-test-libs removed])
  if test "${with_etsf_io_test_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-etsf-io-test-libs has been used])
  fi

  dnl Removed --with-fc-dbgflags option
  AC_MSG_NOTICE([ * --with-fc-dbgflags removed])
  if test "${with_fc_dbgflags}" != ""; then
    AC_MSG_ERROR([removed option --with-fc-dbgflags has been used])
  fi

  dnl Removed --with-fc-ld-dbgflags option
  AC_MSG_NOTICE([ * --with-fc-ld-dbgflags removed])
  if test "${with_fc_ld_dbgflags}" != ""; then
    AC_MSG_ERROR([removed option --with-fc-ld-dbgflags has been used])
  fi

  dnl Removed --with-fc-ld-dbglibs option
  AC_MSG_NOTICE([ * --with-fc-ld-dbglibs removed])
  if test "${with_fc_ld_dbglibs}" != ""; then
    AC_MSG_ERROR([removed option --with-fc-ld-dbglibs has been used])
  fi

  dnl Removed --with-fc-ld-optflags option
  AC_MSG_NOTICE([ * --with-fc-ld-optflags removed])
  if test "${with_fc_ld_optflags}" != ""; then
    AC_MSG_ERROR([removed option --with-fc-ld-optflags has been used])
  fi

  dnl Removed --with-fc-ld-optlibs option
  AC_MSG_NOTICE([ * --with-fc-ld-optlibs removed])
  if test "${with_fc_ld_optlibs}" != ""; then
    AC_MSG_ERROR([removed option --with-fc-ld-optlibs has been used])
  fi

  dnl Removed --with-fc-optflags option
  AC_MSG_NOTICE([ * --with-fc-optflags removed])
  if test "${with_fc_optflags}" != ""; then
    AC_MSG_ERROR([removed option --with-fc-optflags has been used])
  fi

  dnl New --with-fft-flavor option
  AC_MSG_NOTICE([ * new option --with-fft-flavor is available])

  dnl --with-fftw-includes > --with-fft-includes
  AC_MSG_NOTICE([ * --with-fftw-includes renamed --with-fft-includes])
  if test "${with_fftw_includes}" != ""; then
    AC_MSG_ERROR([renamed option --with-fftw-includes has been used])
  fi

  dnl --with-fftw-libs > --with-fft-libs
  AC_MSG_NOTICE([ * --with-fftw-libs renamed --with-fft-libs])
  if test "${with_fftw_libs}" != ""; then
    AC_MSG_ERROR([renamed option --with-fftw-libs has been used])
  fi

  dnl New --with-gpu-cflags option
  AC_MSG_NOTICE([ * new option --with-gpu-cflags is available])

  dnl New --with-gpu-cppflags option
  AC_MSG_NOTICE([ * new option --with-gpu-cppflags is available])

  dnl New --with-gpu-flavor option
  AC_MSG_NOTICE([ * new option --with-gpu-flavor is available])

  dnl --with-cuda-includes > --with-gpu-includes
  AC_MSG_NOTICE([ * --with-cuda-includes renamed --with-gpu-includes])
  if test "${with_cuda_includes}" != ""; then
    AC_MSG_ERROR([renamed option --with-cuda-includes has been used])
  fi

  dnl New --with-gpu-ldflags option
  AC_MSG_NOTICE([ * new option --with-gpu-ldflags is available])

  dnl --with-cuda-libs > --with-gpu-libs
  AC_MSG_NOTICE([ * --with-cuda-libs renamed --with-gpu-libs])
  if test "${with_cuda_libs}" != ""; then
    AC_MSG_ERROR([renamed option --with-cuda-libs has been used])
  fi

  dnl New --with-gpu-prefix option
  AC_MSG_NOTICE([ * new option --with-gpu-prefix is available])

  dnl --with-linalg-type > --with-linalg-flavor
  AC_MSG_NOTICE([ * --with-linalg-type renamed --with-linalg-flavor])
  if test "${with_linalg_type}" != ""; then
    AC_MSG_ERROR([renamed option --with-linalg-type has been used])
  fi

  dnl New --with-math-flavor option
  AC_MSG_NOTICE([ * new option --with-math-flavor is available])

  dnl --with-gsl-includes > --with-math-includes
  AC_MSG_NOTICE([ * --with-gsl-includes renamed --with-math-includes])
  if test "${with_gsl_includes}" != ""; then
    AC_MSG_ERROR([renamed option --with-gsl-includes has been used])
  fi

  dnl --with-gsl-libs > --with-math-libs
  AC_MSG_NOTICE([ * --with-gsl-libs renamed --with-math-libs])
  if test "${with_gsl_libs}" != ""; then
    AC_MSG_ERROR([renamed option --with-gsl-libs has been used])
  fi

  dnl Removed --with-mpi-runner option
  AC_MSG_NOTICE([ * --with-mpi-runner removed])
  if test "${with_mpi_runner}" != ""; then
    AC_MSG_ERROR([removed option --with-mpi-runner has been used])
  fi

  dnl Removed --with-scalapack-includes option
  AC_MSG_NOTICE([ * --with-scalapack-includes removed])
  if test "${with_scalapack_includes}" != ""; then
    AC_MSG_ERROR([removed option --with-scalapack-includes has been used])
  fi

  dnl Removed --with-scalapack-libs option
  AC_MSG_NOTICE([ * --with-scalapack-libs removed])
  if test "${with_scalapack_libs}" != ""; then
    AC_MSG_ERROR([removed option --with-scalapack-libs has been used])
  fi

  dnl --with-timeout > --with-test-timeout
  AC_MSG_NOTICE([ * --with-timeout renamed --with-test-timeout])
  if test "${with_timeout}" != ""; then
    AC_MSG_ERROR([renamed option --with-timeout has been used])
  fi

  dnl New --with-timer-flavor option
  AC_MSG_NOTICE([ * new option --with-timer-flavor is available])

  dnl --with-papi-includes > --with-timer-includes
  AC_MSG_NOTICE([ * --with-papi-includes renamed --with-timer-includes])
  if test "${with_papi_includes}" != ""; then
    AC_MSG_ERROR([renamed option --with-papi-includes has been used])
  fi

  dnl --with-papi-libs > --with-timer-libs
  AC_MSG_NOTICE([ * --with-papi-libs renamed --with-timer-libs])
  if test "${with_papi_libs}" != ""; then
    AC_MSG_ERROR([renamed option --with-papi-libs has been used])
  fi

  dnl New --with-trio-flavor option
  AC_MSG_NOTICE([ * new option --with-trio-flavor is available])

  dnl New --with-trio-includes option
  AC_MSG_NOTICE([ * new option --with-trio-includes is available])

  dnl New --with-trio-libs option
  AC_MSG_NOTICE([ * new option --with-trio-libs is available])

]) dnl ABI_OPTIONS_CHANGED



dnl ABI_OPTIONS_PARSE()
dnl -------------------
dnl
dnl Parses command-line arguments.
dnl
AC_DEFUN([ABI_OPTIONS_PARSE],[
  AC_REQUIRE([AC_PROG_EGREP])
  AC_MSG_NOTICE([parsing command-line options])

  dnl Parse enable_64bit_flags
  if test "${enable_64bit_flags}" != ""; then
    for v in `echo "${enable_64bit_flags}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_64bit_flags = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_64bit_flags = ${v}])
    fi
  fi

  dnl Parse enable_all_plugins
  if test "${enable_all_plugins}" != ""; then
    for v in `echo "${enable_all_plugins}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_all_plugins = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_all_plugins = ${v}])
    fi
  fi

  dnl Parse enable_bigdft
  if test "${enable_bigdft}" != ""; then
    for v in `echo "${enable_bigdft}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_bigdft = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_bigdft = ${v}])
    fi
  fi

  dnl Parse enable_bindings
  if test "${enable_bindings}" != ""; then
    for v in `echo "${enable_bindings}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_bindings = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_bindings = ${v}])
    fi
  fi

  dnl Parse enable_bse_unpacked
  if test "${enable_bse_unpacked}" != ""; then
    for v in `echo "${enable_bse_unpacked}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_bse_unpacked = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_bse_unpacked = ${v}])
    fi
  fi

  dnl Parse enable_cclock
  if test "${enable_cclock}" != ""; then
    for v in `echo "${enable_cclock}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_cclock = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_cclock = ${v}])
    fi
  fi

  dnl Parse enable_clib
  if test "${enable_clib}" != ""; then
    for v in `echo "${enable_clib}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_clib = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_clib = ${v}])
    fi
  fi

  dnl Parse enable_config_file
  if test "${enable_config_file}" != ""; then
    for v in `echo "${enable_config_file}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_config_file = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_config_file = ${v}])
    fi
  fi

  dnl Parse enable_debug
  if test "${enable_debug}" != ""; then
    for v in `echo "${enable_debug}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes basic enhanced paranoid naughty; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_debug = (no|yes|basic|enhanced|paranoid|naughty)])
      AC_MSG_ERROR([invalid option: enable_debug = ${v}])
    fi
  fi

  dnl Parse enable_dft
  if test "${enable_dft}" != ""; then
    for v in `echo "${enable_dft}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_dft = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_dft = ${v}])
    fi
  fi

  dnl Parse enable_etsf_io
  if test "${enable_etsf_io}" != ""; then
    for v in `echo "${enable_etsf_io}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_etsf_io = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_etsf_io = ${v}])
    fi
  fi

  dnl Parse enable_exports
  if test "${enable_exports}" != ""; then
    for v in `echo "${enable_exports}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_exports = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_exports = ${v}])
    fi
  fi

  dnl Parse enable_fast_check
  if test "${enable_fast_check}" != ""; then
    for v in `echo "${enable_fast_check}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_fast_check = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_fast_check = ${v}])
    fi
  fi

  dnl Parse enable_fc_wrapper
  if test "${enable_fc_wrapper}" != ""; then
    for v in `echo "${enable_fc_wrapper}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_fc_wrapper = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_fc_wrapper = ${v}])
    fi
  fi

  dnl Parse enable_fft
  if test "${enable_fft}" != ""; then
    for v in `echo "${enable_fft}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_fft = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_fft = ${v}])
    fi
  fi

  dnl Parse enable_fox
  if test "${enable_fox}" != ""; then
    for v in `echo "${enable_fox}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_fox = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_fox = ${v}])
    fi
  fi

  dnl Parse enable_gpu
  if test "${enable_gpu}" != ""; then
    for v in `echo "${enable_gpu}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_gpu = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_gpu = ${v}])
    fi
  fi

  dnl Parse enable_gw_cutoff
  if test "${enable_gw_cutoff}" != ""; then
    for v in `echo "${enable_gw_cutoff}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_gw_cutoff = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_gw_cutoff = ${v}])
    fi
  fi

  dnl Parse enable_gw_dpc
  if test "${enable_gw_dpc}" != ""; then
    for v in `echo "${enable_gw_dpc}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_gw_dpc = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_gw_dpc = ${v}])
    fi
  fi

  dnl Parse enable_gw_optimal
  if test "${enable_gw_optimal}" != ""; then
    for v in `echo "${enable_gw_optimal}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_gw_optimal = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_gw_optimal = ${v}])
    fi
  fi

  dnl Parse enable_gw_wrapper
  if test "${enable_gw_wrapper}" != ""; then
    for v in `echo "${enable_gw_wrapper}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_gw_wrapper = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_gw_wrapper = ${v}])
    fi
  fi

  dnl Parse enable_hints
  if test "${enable_hints}" != ""; then
    for v in `echo "${enable_hints}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_hints = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_hints = ${v}])
    fi
  fi

  dnl Parse enable_libxc
  if test "${enable_libxc}" != ""; then
    for v in `echo "${enable_libxc}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_libxc = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_libxc = ${v}])
    fi
  fi

  dnl Parse enable_linalg
  if test "${enable_linalg}" != ""; then
    for v in `echo "${enable_linalg}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_linalg = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_linalg = ${v}])
    fi
  fi

  dnl Parse enable_macroave
  if test "${enable_macroave}" != ""; then
    for v in `echo "${enable_macroave}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_macroave = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_macroave = ${v}])
    fi
  fi

  dnl Parse enable_maintainer_checks
  if test "${enable_maintainer_checks}" != ""; then
    for v in `echo "${enable_maintainer_checks}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_maintainer_checks = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_maintainer_checks = ${v}])
    fi
  fi

  dnl Parse enable_math
  if test "${enable_math}" != ""; then
    for v in `echo "${enable_math}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_math = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_math = ${v}])
    fi
  fi

  dnl Parse enable_mpi
  if test "${enable_mpi}" != ""; then
    for v in `echo "${enable_mpi}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_mpi = ${v}])
    fi
  fi

  dnl Parse enable_mpi_io
  if test "${enable_mpi_io}" != ""; then
    for v in `echo "${enable_mpi_io}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi_io = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_mpi_io = ${v}])
    fi
  fi

  dnl Parse enable_mpi_io_test
  if test "${enable_mpi_io_test}" != ""; then
    for v in `echo "${enable_mpi_io_test}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi_io_test = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_mpi_io_test = ${v}])
    fi
  fi

  dnl Parse enable_mpi_trace
  if test "${enable_mpi_trace}" != ""; then
    for v in `echo "${enable_mpi_trace}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi_trace = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_mpi_trace = ${v}])
    fi
  fi

  dnl Parse enable_netcdf
  if test "${enable_netcdf}" != ""; then
    for v in `echo "${enable_netcdf}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_netcdf = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_netcdf = ${v}])
    fi
  fi

  dnl Parse enable_optim
  if test "${enable_optim}" != ""; then
    for v in `echo "${enable_optim}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes safe standard aggressive; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_optim = (no|yes|safe|standard|aggressive)])
      AC_MSG_ERROR([invalid option: enable_optim = ${v}])
    fi
  fi

  dnl Parse enable_scalapack
  if test "${enable_scalapack}" != ""; then
    for v in `echo "${enable_scalapack}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_scalapack = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_scalapack = ${v}])
    fi
  fi

  dnl Parse enable_smp
  if test "${enable_smp}" != ""; then
    for v in `echo "${enable_smp}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_smp = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_smp = ${v}])
    fi
  fi

  dnl Parse enable_stdin
  if test "${enable_stdin}" != ""; then
    for v in `echo "${enable_stdin}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_stdin = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_stdin = ${v}])
    fi
  fi

  dnl Parse enable_test_timeout
  if test "${enable_test_timeout}" != ""; then
    for v in `echo "${enable_test_timeout}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_test_timeout = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_test_timeout = ${v}])
    fi
  fi

  dnl Parse enable_timer
  if test "${enable_timer}" != ""; then
    for v in `echo "${enable_timer}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_timer = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_timer = ${v}])
    fi
  fi

  dnl Parse enable_trio
  if test "${enable_trio}" != ""; then
    for v in `echo "${enable_trio}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_trio = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_trio = ${v}])
    fi
  fi

  dnl Parse enable_vdwxc
  if test "${enable_vdwxc}" != ""; then
    for v in `echo "${enable_vdwxc}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_vdwxc = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_vdwxc = ${v}])
    fi
  fi

  dnl Parse enable_wannier90
  if test "${enable_wannier90}" != ""; then
    for v in `echo "${enable_wannier90}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_wannier90 = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_wannier90 = ${v}])
    fi
  fi

  dnl Parse enable_zdot_bugfix
  if test "${enable_zdot_bugfix}" != ""; then
    for v in `echo "${enable_zdot_bugfix}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_zdot_bugfix = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_zdot_bugfix = ${v}])
    fi
  fi

  dnl Parse with_bigdft_includes
 if test "${with_bigdft_includes}" != ""; then
    opt_ok="yes"
    for v in ${with_bigdft_includes}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_bigdft_includes: ${v}])
    fi
  fi

  dnl Parse with_bigdft_libs
 if test "${with_bigdft_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_bigdft_libs}; do
      if test "`echo "${v}" | grep '^-[[LlW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_bigdft_libs: ${v}])
    fi
  fi

  dnl Parse with_dft_flavor
  if test "${with_dft_flavor}" != ""; then
    for v in `echo "${with_dft_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in bigdft libxc wannier90; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_dft_flavor = (bigdft|libxc|wannier90)])
      AC_MSG_ERROR([invalid option: with_dft_flavor = ${v}])
    fi
  fi

  dnl Parse with_dft_includes
  dnl FIXME: NOT IMPLEMENTED!

  dnl Parse with_dft_libs
 if test "${with_dft_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_dft_libs}; do
      if test "`echo "${v}" | grep '^-[[LlW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_dft_libs: ${v}])
    fi
  fi

  dnl Parse with_etsf_io_includes
 if test "${with_etsf_io_includes}" != ""; then
    opt_ok="yes"
    for v in ${with_etsf_io_includes}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_etsf_io_includes: ${v}])
    fi
  fi

  dnl Parse with_etsf_io_libs
 if test "${with_etsf_io_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_etsf_io_libs}; do
      if test "`echo "${v}" | grep '^-[[LlW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_etsf_io_libs: ${v}])
    fi
  fi

  dnl Parse with_fft_flavor
  if test "${with_fft_flavor}" != ""; then
    for v in `echo "${with_fft_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in asl fftw2 fftw2-threads fftw3 fftw3-mkl fftw3-threads sgimath; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_fft_flavor = (asl|fftw2|fftw2-threads|fftw3|fftw3-mkl|fftw3-threads|sgimath)])
      AC_MSG_ERROR([invalid option: with_fft_flavor = ${v}])
    fi
  fi

  dnl Parse with_fft_includes
 if test "${with_fft_includes}" != ""; then
    opt_ok="yes"
    for v in ${with_fft_includes}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_fft_includes: ${v}])
    fi
  fi

  dnl Parse with_fft_libs
 if test "${with_fft_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_fft_libs}; do
      if test "`echo "${v}" | grep '^-[[LlW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_fft_libs: ${v}])
    fi
  fi

  dnl Parse with_fox_includes
 if test "${with_fox_includes}" != ""; then
    opt_ok="yes"
    for v in ${with_fox_includes}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_fox_includes: ${v}])
    fi
  fi

  dnl Parse with_fox_libs
 if test "${with_fox_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_fox_libs}; do
      if test "`echo "${v}" | grep '^-[[LlW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_fox_libs: ${v}])
    fi
  fi

  dnl Parse with_gpu_flavor
  if test "${with_gpu_flavor}" != ""; then
    for v in `echo "${with_gpu_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in cuda-single cuda-double; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_gpu_flavor = (cuda-single|cuda-double)])
      AC_MSG_ERROR([invalid option: with_gpu_flavor = ${v}])
    fi
  fi

  dnl Parse with_gpu_includes
 if test "${with_gpu_includes}" != ""; then
    opt_ok="yes"
    for v in ${with_gpu_includes}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_gpu_includes: ${v}])
    fi
  fi

  dnl Parse with_gpu_libs
 if test "${with_gpu_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_gpu_libs}; do
      if test "`echo "${v}" | grep '^-[[LlW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_gpu_libs: ${v}])
    fi
  fi

  dnl Parse with_libxc_includes
 if test "${with_libxc_includes}" != ""; then
    opt_ok="yes"
    for v in ${with_libxc_includes}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_libxc_includes: ${v}])
    fi
  fi

  dnl Parse with_libxc_libs
 if test "${with_libxc_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_libxc_libs}; do
      if test "`echo "${v}" | grep '^-[[LlW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_libxc_libs: ${v}])
    fi
  fi

  dnl Parse with_linalg_flavor
  if test "${with_linalg_flavor}" != ""; then
    for v in `echo "${with_linalg_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in acml asl atlas cxml essl mkl mlib netlib sgimath sunperf; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_linalg_flavor = (acml|asl|atlas|cxml|essl|mkl|mlib|netlib|sgimath|sunperf)])
      AC_MSG_ERROR([invalid option: with_linalg_flavor = ${v}])
    fi
  fi

  dnl Parse with_linalg_includes
 if test "${with_linalg_includes}" != ""; then
    opt_ok="yes"
    for v in ${with_linalg_includes}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_linalg_includes: ${v}])
    fi
  fi

  dnl Parse with_linalg_libs
 if test "${with_linalg_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_linalg_libs}; do
      if test "`echo "${v}" | grep '^-[[LlW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_linalg_libs: ${v}])
    fi
  fi

  dnl Parse with_math_flavor
  if test "${with_math_flavor}" != ""; then
    for v in `echo "${with_math_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in gsl mlib; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_math_flavor = (gsl|mlib)])
      AC_MSG_ERROR([invalid option: with_math_flavor = ${v}])
    fi
  fi

  dnl Parse with_math_includes
 if test "${with_math_includes}" != ""; then
    opt_ok="yes"
    for v in ${with_math_includes}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_math_includes: ${v}])
    fi
  fi

  dnl Parse with_math_libs
 if test "${with_math_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_math_libs}; do
      if test "`echo "${v}" | grep '^-[[LlW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_math_libs: ${v}])
    fi
  fi

  dnl Parse with_mpi_includes
 if test "${with_mpi_includes}" != ""; then
    opt_ok="yes"
    for v in ${with_mpi_includes}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_mpi_includes: ${v}])
    fi
  fi

  dnl Parse with_mpi_level
  if test "${with_mpi_level}" != ""; then
    for v in `echo "${with_mpi_level}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in 1 2; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_mpi_level = (1|2)])
      AC_MSG_ERROR([invalid option: with_mpi_level = ${v}])
    fi
  fi

  dnl Parse with_mpi_libs
 if test "${with_mpi_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_mpi_libs}; do
      if test "`echo "${v}" | grep '^-[[LlW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_mpi_libs: ${v}])
    fi
  fi

  dnl Parse with_netcdf_includes
 if test "${with_netcdf_includes}" != ""; then
    opt_ok="yes"
    for v in ${with_netcdf_includes}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_netcdf_includes: ${v}])
    fi
  fi

  dnl Parse with_netcdf_libs
 if test "${with_netcdf_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_netcdf_libs}; do
      if test "`echo "${v}" | grep '^-[[LlW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_netcdf_libs: ${v}])
    fi
  fi

  dnl Parse with_test_timeout
 if test "${with_test_timeout}" != ""; then
    opt_ok="yes"
    test "`echo "${with_test_timeout}" | ${EGREP} -e '^-?[[0-9]]+$'`" = "" && opt_ok="no"
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid integer: with_test_timeout = ${with_test_timeout}])
    fi
  fi

  dnl Parse with_timer_flavor
  if test "${with_timer_flavor}" != ""; then
    for v in `echo "${with_timer_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in abinit gptl papi; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_timer_flavor = (abinit|gptl|papi)])
      AC_MSG_ERROR([invalid option: with_timer_flavor = ${v}])
    fi
  fi

  dnl Parse with_timer_includes
 if test "${with_timer_includes}" != ""; then
    opt_ok="yes"
    for v in ${with_timer_includes}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_timer_includes: ${v}])
    fi
  fi

  dnl Parse with_timer_libs
 if test "${with_timer_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_timer_libs}; do
      if test "`echo "${v}" | grep '^-[[LlW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_timer_libs: ${v}])
    fi
  fi

  dnl Parse with_trio_flavor
  if test "${with_trio_flavor}" != ""; then
    for v in `echo "${with_trio_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in etsf fox hdf netcdf; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_trio_flavor = (etsf|fox|hdf|netcdf)])
      AC_MSG_ERROR([invalid option: with_trio_flavor = ${v}])
    fi
  fi

  dnl Parse with_trio_includes
  dnl FIXME: NOT IMPLEMENTED!

  dnl Parse with_trio_libs
 if test "${with_trio_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_trio_libs}; do
      if test "`echo "${v}" | grep '^-[[LlW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_trio_libs: ${v}])
    fi
  fi

  dnl Parse with_wannier90_includes
 if test "${with_wannier90_includes}" != ""; then
    opt_ok="yes"
    for v in ${with_wannier90_includes}; do
      if test "`echo "${v}" | grep '^-I'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid include statement in with_wannier90_includes: ${v}])
    fi
  fi

  dnl Parse with_wannier90_libs
 if test "${with_wannier90_libs}" != ""; then
    opt_ok="yes"
    for v in ${with_wannier90_libs}; do
      if test "`echo "${v}" | grep '^-[[LlW]]'`" = ""; then
        opt_ok="no"
        break
      fi
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_ERROR([invalid library statement in with_wannier90_libs: ${v}])
    fi
  fi

]) dnl ABI_OPTIONS_PARSE
