# -*- Autoconf -*-
#
# Copyright (C) 2005-2010 ABINIT Group (Yann Pouillon)
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

#
# Support for Density-Functional Theory libraries
#



# _ABI_DFT_CHECK_BIGDFT()
# ----------------------
#
# Check whether the BigDFT library is working.
#
AC_DEFUN([_ABI_DFT_CHECK_BIGDFT],[
  dnl Init
  abi_dft_bigdft_has_incs="no"
  abi_dft_bigdft_has_libs="no"
  abi_dft_bigdft_serial="no"
  abi_dft_bigdft_mpi="no"
  abi_dft_bigdft_fcflags=""
  abi_dft_bigdft_ldflags=""
  abi_dft_bigdft_incs="${with_dft_includes}"
  abi_dft_bigdft_libs="${with_dft_libs}"

  dnl Look for libraries and routines
  if test "${abi_dft_bigdft_libs}" = ""; then
    LIBS="-lbigdft -lpoissonsolver ${LIBS}"
    AC_MSG_CHECKING([whether we have a working BigDFT library])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        use bigdft_api
        type(atoms_data) :: atoms
        type(restart_objects) :: rst
        character(len=*),parameter :: routine = "conftest"
        call init_restart_objects(atoms,rst,routine)
      ]])], [abi_dft_bigdft_has_libs="yes"], [abi_dft_bigdft_has_libs="no"])
    AC_MSG_RESULT([${abi_dft_bigdft_has_libs}])
    if test "${abi_dft_bigdft_has_libs}" = "yes"; then
      abi_dft_bigdft_has_incs="yes"
      abi_dft_bigdft_libs="-lbigdft -lpoissonsolver"
    fi
  else
    AC_MSG_CHECKING([whether the specified BigDFT library works])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        use bigdft_api
        type(atoms_data) :: atoms
        type(restart_objects) :: rst
        character(len=*),parameter :: routine = "conftest"
        call init_restart_objects(atoms,rst,routine)
      ]])], [abi_dft_bigdft_has_incs="yes"; abi_dft_bigdft_has_libs="yes"], [abi_dft_bigdft_has_libs="no"])
    AC_MSG_RESULT([${abi_dft_bigdft_has_libs}])
  fi

  dnl Take final decision for the serial case
  if test "${abi_dft_bigdft_has_incs}" = "yes" -a \
          "${abi_dft_bigdft_has_libs}" = "yes"; then
    abi_dft_bigdft_serial="yes"
  fi

  dnl Check for MPI support
  if test "${enable_mpi}" = "yes"; then
    dnl AC_MSG_CHECKING([whether BIGDFT supports MPI])
    dnl AC_LINK_IFELSE([AC_LANG_PROGRAM([],
    dnl  [[
    dnl    use bigdft_api
    dnl  ]])], [abi_dft_bigdft_mpi="yes"], [abi_dft_bigdft_mpi="no"])
    dnl AC_MSG_RESULT([${abi_dft_bigdft_has_libs}])
    abi_dft_bigdft_mpi="yes"
  fi
]) # _ABI_DFT_CHECK_BIGDFT



# _ABI_DFT_CHECK_LIBXC()
# ------------------------
#
# Check whether the LibXC library is working.
#
AC_DEFUN([_ABI_DFT_CHECK_LIBXC],[
  dnl Init
  abi_dft_libxc_has_incs="no"
  abi_dft_libxc_has_libs="no"
  abi_dft_libxc_serial="no"
  abi_dft_libxc_mpi="no"
  abi_dft_libxc_fcflags=""
  abi_dft_libxc_ldflags=""
  abi_dft_libxc_incs="${with_dft_includes}"
  abi_dft_libxc_libs="${with_dft_libs}"

  dnl Look for includes
  AC_LANG_PUSH([C])
  AC_CHECK_HEADERS([xc.h xc_funcs.h],[abi_dft_libxc_has_incs="yes"],[abi_dft_libxc_has_incs="no"])
  AC_LANG_POP

  dnl Look for libraries and routines
  if test "${abi_dft_libxc_libs}" = ""; then
    AC_LANG_PUSH([C])
    AC_CHECK_LIB([libxc],[xc_func_init])
    AC_LANG_POP
    if test "${ac_cv_lib_libxc_xc_func_init}" = "yes"; then
      dnl FIXME: check Fortran part
      dnl AC_CHECK_LIB([libxc],[nf_open],[abi_dft_libxc_has_libs="yes"],[abi_dft_libxc_has_libs="no"])
      if test "${abi_dft_libxc_has_libs}" = "yes"; then
        abi_dft_libxc_libs="-llibxc"
      fi
    fi
  else
    AC_MSG_CHECKING([whether the specified LibXC library works])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        use xc_f90_lib_m
        integer :: i
        type(xc_f90_pointer_t) :: info
        i = xc_f90_info_number(info)
      ]])], [abi_dft_libxc_has_libs="yes"], [abi_dft_libxc_has_libs="no"])
    AC_MSG_RESULT([${abi_dft_libxc_has_libs}])
  fi

  dnl Take final decision for the serial case
  if test "${abi_dft_libxc_has_incs}" = "yes" -a \
          "${abi_dft_libxc_has_libs}" = "yes"; then
    abi_dft_libxc_serial="yes"
  fi

  dnl Check for MPI support
  if test "${enable_mpi}" = "yes"; then
    dnl FIXME: check MPI
    dnl AC_MSG_CHECKING([whether LibXC supports MPI])
    dnl AC_LINK_IFELSE([AC_LANG_PROGRAM([],
    dnl  [[
    dnl    use libxc
    dnl    call nf90_open_par
    dnl  ]])], [abi_dft_libxc_mpi="yes"], [abi_dft_libxc_mpi="no"])
    dnl AC_MSG_RESULT([${abi_dft_libxc_has_libs}])
    abi_dft_libxc_mpi="yes"
  fi

  dnl Make sure LIBS are properly set for BigDFT and Wannier90
  LIBS="${abi_dft_libxc_libs} ${LIBS}"
]) # _ABI_DFT_CHECK_LIBXC



# _ABI_DFT_CHECK_WANNIER90()
# ---------------------
#
# Check whether the Wannier90 library is working.
#
AC_DEFUN([_ABI_DFT_CHECK_WANNIER90],[
  dnl Init
  abi_dft_wannier90_has_incs="no"
  abi_dft_wannier90_has_libs="no"
  abi_dft_wannier90_serial="no"
  abi_dft_wannier90_mpi="no"
  abi_dft_wannier90_fcflags=""
  abi_dft_wannier90_ldflags=""
  abi_dft_wannier90_incs="${with_dft_includes}"
  abi_dft_wannier90_libs="${with_dft_libs}"

  dnl Look for libraries and routines
  if test "${abi_dft_wannier90_libs}" = ""; then
    LIBS="-lwannier ${LIBS}"
    AC_MSG_CHECKING([whether we have a working Wannier90 library])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        call wannier_run
      ]])], [abi_dft_wannier90_has_libs="yes"], [abi_dft_wannier90_has_libs="no"])
    AC_MSG_RESULT([${abi_dft_wannier90_has_libs}])
    if test "${abi_dft_wannier90_has_libs}" = "yes"; then
      abi_dft_wannier90_has_incs="yes"
      abi_dft_wannier90_libs="-lwannier"
    fi
  else
    AC_MSG_CHECKING([whether the specified Wannier90 library works])
    AC_LINK_IFELSE([AC_LANG_PROGRAM([],
      [[
        call wannier_run
      ]])], [abi_dft_wannier90_has_incs="yes"; abi_dft_wannier90_has_libs="yes"], [abi_dft_wannier90_has_libs="no"])
    AC_MSG_RESULT([${abi_dft_wannier90_has_libs}])
  fi

  dnl Take final decision for the serial case
  if test "${abi_dft_wannier90_has_incs}" = "yes" -a \
          "${abi_dft_wannier90_has_libs}" = "yes"; then
    abi_dft_wannier90_serial="yes"
  fi
]) # _ABI_DFT_CHECK_WANNIER90



# ABI_CONNECT_DFT()
# ------------------
#
# Sets all variables needed to handle the DFT libraries.
#
AC_DEFUN([ABI_CONNECT_DFT],[
  dnl Initial setup
  lib_dft_flavor="${with_dft_flavor}"
  lib_dft_fcflags=""
  lib_dft_ldflags=""
  lib_dft_incs=""
  lib_dft_libs=""

  dnl Display user requests
  AC_MSG_CHECKING([whether to use DFT libraries])
  AC_MSG_RESULT([${enable_dft}])

  dnl Prepare environment
  ABI_ENV_BACKUP
  abi_saved_LIBS="${LIBS}"
  CPPFLAGS="${with_dft_includes} ${CPPFLAGS}"
  FCFLAGS="${with_dft_includes} ${FCFLAGS}"
  LDFLAGS="${FC_LDFLAGS}"
  LIBS="${with_dft_libs} ${LIBS}"
  AC_LANG_PUSH([Fortran])

  dnl Look for external DFT libraries
  if test "${enable_dft}" = "yes"; then

    dnl Check whether we have a working I/O environment
    AC_MSG_CHECKING([for the requested DFT support])
    AC_MSG_RESULT([${with_dft_flavor}])

    dnl Make sure LibXC is looked for before the others
    abi_dft_iter=`echo "${with_dft_flavor}" | sed -e 's/+/\n/g' | sort -u | awk '{printf " %s",[$]1}'`
    abi_dft_tmp="${abi_dft_iter}"
    for abi_dft_flavor in ${abi_dft_iter}; do
      if test "${abi_dft_flavor}" != "libxc"; then
        abi_dft_tmp=`echo "${abi_dft_iter}" | sed -e 's/libxc//'`
        abi_dft_tmp="libxc ${abi_dft_tmp}"
      fi
    done
    abi_dft_iter="${abi_dft_tmp}"

    for abi_dft_flavor in ${abi_dft_iter}; do

      case "${abi_dft_flavor}" in

        bigdft)
          if test "${abi_dft_libxc_serial}" = "yes"; then
            _ABI_DFT_CHECK_BIGDFT
          else
            abi_dft_bigdft_serial="no"
            abi_dft_bigdft_mpi="no"
          fi
          if test "${abi_dft_bigdft_serial}" = "yes"; then
            AC_DEFINE([HAVE_DFT_BIGDFT],1,[Define to 1 if you have the BigDFT library.])
            dnl FIXME: temporary takeover
            AC_MSG_WARN([disabling BigDFT plugin])
            enable_bigdft_io="no"
            AC_DEFINE([HAVE_BIGDFT],1,[Define to 1 if you have the BigDFT library.])
          else
            AC_MSG_WARN([falling back to BigDFT plugin])
            enable_bigdft="yes"
          fi
          ;;

        libxc)
          _ABI_DFT_CHECK_LIBXC
          if test "${abi_dft_libxc_serial}" = "yes"; then
            AC_DEFINE([HAVE_DFT_LIBXC],1,[Define to 1 if you have the LibXC library.])
            dnl FIXME: temporary takeover
            AC_MSG_WARN([disabling LibXC plugin])
            enable_libxc="no"
            AC_DEFINE([HAVE_LIBXC],1,[Define to 1 if you have the LibXC library.])
          else
            AC_MSG_WARN([falling back to LibXC plugin])
            enable_libxc="yes"
          fi
          ;;

        wannier90)
          _ABI_DFT_CHECK_WANNIER90
          if test "${abi_dft_wannier90_serial}" = "yes"; then
            AC_DEFINE([HAVE_DFT_WANNIER90],1,[Define to 1 if you have the Wannier90 library.])
            dnl FIXME: temporary takeover
            AC_MSG_WARN([disabling Wannier90 plugin])
            enable_wannier90="no"
            AC_DEFINE([HAVE_WANNIER90],1,[Define to 1 if you have the Wannier90 library.])
          else
            AC_MSG_WARN([falling back to Wannier90 plugin])
            enable_wannier90="yes"
          fi
          ;;

        *)
          AC_MSG_ERROR([unknown DFT flavor '${abi_dft_flavor}'])
          ;;

      esac

    done

    dnl Rebuild actual flavor
    lib_dft_flavor=`echo "${abi_dft_iter}" | sed -e 's/^[[ ]]*//;s/[[ ]]*$//;s/ [[ ]]*/+/g;'`
  fi

  dnl Transmit information
  lib_dft_fcflags="${abi_dft_libxc_fcflags} ${abi_dft_bigdft_fcflags} ${abi_dft_wannier90_fcflags}"
  lib_dft_ldflags="${abi_dft_libxc_ldflags} ${abi_dft_bigdft_ldflags} ${abi_dft_wannier90_ldflags}"
  lib_dft_incs="${abi_dft_libxc_incs} ${abi_dft_bigdft_incs} ${abi_dft_wannier90_incs}"
  lib_dft_libs="${abi_dft_bigdft_libs} ${abi_dft_wannier90_libs} ${abi_dft_libxc_libs}"

  dnl Restore build environment
  AC_LANG_POP
  LIBS="${abi_saved_LIBS}"
  ABI_ENV_RESTORE

  dnl Output final flavor
  if test "${enable_dft}" = "yes"; then
    AC_MSG_CHECKING([for the actual DFT support])
    AC_MSG_RESULT([${lib_dft_flavor}])
  fi

  dnl Substitute variables needed for the use of the library
  AC_SUBST(lib_dft_flavor)
  AC_SUBST(lib_dft_fcflags)
  AC_SUBST(lib_dft_ldflags)
  AC_SUBST(lib_dft_incs)
  AC_SUBST(lib_dft_libs)
]) # ABI_CONNECT_DFT
